/*-----------------------------------------------------------------------------*
 * WorkThread.h                                               *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file WorkThread.h
 *
 * \brief Worker thread for device manager
 *
 * \version 17.11.2011, Koechling, Christian (Bosch),
 *          -# compilabilty enable switch off log mechanism used by MV - see LogTrace.h
 *          -# cleanup: 1st step to shift includes to Common.h
 * \version 12.12.2011, Koechling, Christian (Bosch), cleanup: EOL-values uses
 *          one singleton data container

 * \version 07.03.2012, Negi, Sunder (Montavista), get property adjusted for
 *          startup (Mediaplayer needs this)
 * \version 07.03.2012, Koechling, Christian (Bosch), merged MV-code Feb27 -
 *          contains fix for startup synchronization
 * \version 27.07.2012, Negi, Sunder (MontaVista), Cleaned up file hierarchy
 * \version 30.07.2012, Koechling, Christian (Bosch), changed header to doxygen
 *          style and shifted information from .cpp to .h
 * \version 02.08.2012, Negi, Sunder (MontaVista),
 *          -# Refactored debug information logging
 *          -# Added History Manager, refer define HISTORY_MANAGER
 * \version 05.08.2012, Negi, Sunder (MontaVista), Modified and fixed doxygen comments
 * \version 27.08.2012, Koechling, Christian (Bosch), trigger FillStorage fct. by PDT-diag  
 * \version 29.08.2012, Koechling, Christian (Bosch),  use defines THREAD_WORKER
 *
 *-----------------------------------------------------------------
 *                                   development for Gen3:
 *-----------------------------------------------------------------
 *\version 23.10.2013, Christian Koechling (Bosch) 
 *         -# start tp replace QStrings by replacing QString by define GENSTRING
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2016
 */

#ifndef __WORKTHREAD_H__
#define __WORKTHREAD_H__

/*-----------------------------------------------------------------------------*
 * Forward declarations                                                        *
 *-----------------------------------------------------------------------------*/
class CyclicDiagThread;
/*-----------------------------------------------------------------------------*
 * using namespace                                                        *
 *-----------------------------------------------------------------------------*/
//using namespace statetbl;

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class WorkThread
 *
 * Worker thread for device manager for monitoring device connection/disconnection
 *
 * \see ahl_tclBaseWorkThread
 */
class WorkThread :public TFThread
{
   
    public:

        typedef enum
        {
           eThread_WorkThread = 0,
           eThread_Last       = 1
        }tenThreadFunction;

        /*! 
         * \brief Parameterized constructor
         *
         */
        WorkThread();

        /*! 
         * \brief Destructor
         *
         * \see ahl_tclBaseWorkThread::~ahl_tclBaseWorkThread()
         */
        virtual ~WorkThread();



        /*! 
         * \brief start worker thread
         *
         * \return TRUE: started FALSE if already started 
         */

        tBool bActivate();


     /*! 
         * \brief stop worker thread
         *
         *
         * \return TRUE: started FALSE if already started 
         */

        tBool bDeActivate();


    /**
        * This function derives from TFThread and starts a user function in a thread from the thread factory's thread pool.
        * After leaving while loop used thread is stopped and released for other users
        *
        * @return void
        */
        virtual void Do(int functionID, void *ptr);

#ifdef USE_DECOUPLE_CYCLICDIAGCCA
        /**
               * handover pointer of cyclic diagnosis thread to start it within worker thread
               *
               */
        void SetInterface(CyclicDiagThread *pCyclicDiagThread);
#endif


    protected:

        /**< to mark if thread has been started already or not*/
        tBool m_bActiveThread;
#ifdef USE_DECOUPLE_CYCLICDIAGCCA
        CyclicDiagThread *m_pCyclicDiagThread;
#endif


       /*! 
        * \brief Thread Function of worker thread
        */
       virtual tVoid vThreadFunction();  //lint !e1768 : virtual function has access private  (private) different from access (public) in the base class (ahl_trclBaseWorkthread) ///@todo replace by non OSALthread




}; //lint !e1712 : default contructor not defined 

#endif // __VD_DEVICEMANAGER_WORKERTHREAD_H__

////////////////////////////////////////////////////////////////////////////////
// <EOF>
