/*-----------------------------------------------------------------------------*
 * IStateTableMount.h                                                      *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM G3G                                                   *
 * COPYRIGHT   : (c) 2014-2016  Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file ICyclicDiagnosis.h
 *
 * \brief Interface used by components to inform StateTable about the hw malfunction
 *
 * \version 22.01.2016, Christian Koechling(CM/ESC3), version 1.0
 
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 
 */



#ifndef INTERFCACE_CYCLICDIAGNOSIS_H
#define INTERFCACE_CYCLICDIAGNOSIS_H  

#include "Config.h"
#include "Enums.h"
#include <vector>


/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class ICyclicDiagnosis
 */

class ICyclicDiagnosis
{
    public:

        /*!
         * \brief Destructor
         */
        virtual ~ICyclicDiagnosis(){};
        
        /*!
         * \brief execute cyclic doagnosis function 
         */
        virtual void ProcessDiag(vector<trDtcCodeResult> &ListCyclicDiagResults) = 0;


    protected:
        vector<trDtcCodeResult> m_ListCyclicDiagResults;

};
// class ICyclicDiagnosis

#endif // INTERFCACE_CYCLICDIAGNOSIS_H  

////////////////////////////////////////////////////////////////////////////////
// <EOF>

