//ROADMAP13035_Overtemp



/*-----------------------------------------------------------------------------*
 * DeviceManagerInterface.h                                                         *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : G3G                                                           *
 * COPYRIGHT   : (c) 2013-2020 Robert Bosch GmbH, Hildesheim                   *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file VD_DeviceManger.h
 *
 * \brief Implementation of Interface of VD_DEviceManager used by clients - this is mainly used by CCA-VD_DeviceManagerService 
 *
 * \version 10.02.2014, Christian Kchling (Bosch), version 1.0
 *          Initial version to serve ROADMAP13035_Overtemp and to make a refactoring
 
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2016
 */

#ifndef _DEVICEMANAGER_INTERFACE_INTERNAL_H_
#define _DEVICEMANAGER_INTERFACE_INTERNAL_H_


/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \interface IDeviceManagerInterfaceInternal
 */

class IDeviceManagerInterfaceInternal 
{
    public:


       /*!
        * \brief Destructor
        *
        * \note This is private since its a singleton class
        */
       virtual ~IDeviceManagerInterfaceInternal(){};


    //=====================================================================================
    // IN VD_DeviceManager Service
    //=====================================================================================
 
          /*! 
    * \brief connect/diaconnect clients i.e. prevent for testing that output is notified to clients
    *        
    * \param [IN] bConnect: TRUE: clients are connected FALSE: not connected
    *
    * \return 
    */
    INTERN virtual tVoid vConnectClients(tBool bConnect) const = 0;


}; // class Info_tclDmEolConfSettings

#endif // _DEVICEMANAGER_INTERFACE_INTERNAL_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>

