
/*-----------------------------------------------------------------------------*
 * DeviceManagerInterface.h                                                         *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : G3G                                                           *
 * COPYRIGHT   : (c) 2013-2020 Robert Bosch GmbH, Hildesheim                   *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file VD_DeviceManger.h
 *
 * \brief Implementation of Interface of VD_DEviceManager used by clients - this is mainly used by CCA-VD_DeviceManagerService 
 *
 * \version 10.02.2014, Christian K�chling (Bosch), version 1.0
 *          Initial version to serve ROADMAP13035_Overtemp and to make a refactoring
 
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2016
 */

#ifndef _IDEVICEMANAGER_INTERFACE_GENERAL_H_
#define _IDEVICEMANAGER_INTERFACE_GENERAL_H_

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class Info_tclDmEolConfSettings
 */

//@todo after it works rename Info_tclDmEolConfSettings to ConfigurationManager
class IDeviceManagerInterfaceGeneral 
{
    public:



        /*!
         * \brief Destructor
         *
         * \note This is private since its a singleton class
         */
        virtual ~IDeviceManagerInterfaceGeneral(){};



    /*! 
    * \brief measure resistance at USB connector 
    *        
    * \param [IN] bAvailable: TRUE: Service available FALSE: Service unavailable
    *
    * \return 
    */
        INTERN virtual tVoid vSetServiceAvailable(tBool bAvailable) const = 0;


    //=====================================================================================
    // OUT (MAIN SERVICE): these functions are used by VD_DVM to send to the 'outside world'
    //=====================================================================================

//#ifdef REFACTOR_STATETABLE_OUTPUT
        OUT    virtual tVoid vInformClients() const = 0;
//#endif



     /*!
          * \brief vInformClientsDeviceList about recent device change (index=0) 
          *           Service sends the List
          * \parm -f_pNotifyClients: property of device to be used for notification change
          * \parm bTest true/false
          * \return 
          */
        OUT virtual tVoid vInformClients(structNotifyClients &f_oDevice, tBool bTest) const = 0;

     /*!
          * \brief notfication of HW-Signals - this function is used if no devices are connected but HW Signals are notified
          *       
          *
          * \return 
          */
        OUT virtual tVoid vInformClientsHWSignals() const = 0; //Roadmap 14003 Diagnosis2 (notfy PortStates) 


     /*!
          * \brief vSetOverTemperature -inform clients (e.g. mediaplayer) about OverTemp at CDROM rue/false  (Index0)
          *          Index 1...connected devices:  notify all connected devices
          *
          * \parm oDevice CDROM-device with overtemperature true/false
          * \return DeviceManagerInterface*
          */
        OUT virtual tVoid vInformClientsCDDriveOvertemp(structNotifyClients &f_oDevice) const = 0; //Roadmap_13035_Overtemp


     /*!
          * \brief notfication of InternalSDCard for diagnosis (originally implmented for NissanLCN2Kai) but since it belongs to th normal FI and not diaglog or diaglib it is listed in this interfaxe
          *       
          *
          * \return 
          */
        OUT virtual tVoid vInformClientsCard( ) const = 0;

      //=====================================================================================
      // INOUT:  these functions are used by clients to trigger VD_DVM to send an answer to the  'outside world' (METHOD type)
      //=====================================================================================

    /*! 
         * \brief Get properties of the device of the given serial number
         *
         * Queries UDevManager for the device with the serial id as specified
         * by f_ucDeviceSerial
         *
         * \param [in]  f_ucDeviceSerial Serial number of the device to look for.
         * \param [out] objDevice       Reference of the CDevice object. This
         *              object will be filled according to matching serial
         *              number.If no matching device find it is assigned as null.
         *
         * \return [bool] FALSE: device not present  TRUE: device detected
         */
        IN virtual bool getDeviceProperties(const GENSTRING f_ucDeviceSerial, CDevice& f_objDevice) const = 0;


        /*!
         * \brief Get list of all connected devices
         *
         * \param [out] f_vConnectedDevices reference to a vector to be filled
         *             with list of connected devices
         *
         * \return [StateTable*] pointer to l_pStateTableManagerApp
         */
        INOUT virtual StateTable* getAllConnectedDevices(vector<structNotifyClients> &f_vConnectedDevices) const = 0;


    //================================================================================================
    // IN: function is called e.g. by FC_HeatControl  might cause notification to clients
    //================================================================================================

    /*!
         * \brief function to support behaviour for over temperature at te CDDrive
         *
         * FC_HeatCtrol call this. VD_DVM notifies for CDROM overtemperature
         * MEdiaplayer stops to use the CDDrive
         * 
         * \parm IN:bOverTemperature: true or false  means overtemperature or normal operating temperature
         * \parm IN:strDeviceName  e.g.  /dev/sr0
         * \return tVoid  (VD_DVM posts notifies devicelist CDROM would have correspondent connection state)
         */
       IN virtual tVoid vSetOverTemperatureCDDrive(IN tBool bOverTemperature) = 0; //Roadmap 13035 Over temperature




        /*!
		 * \brief to send the cdda device slot status to interface
		 *
		 *\param [IN]tDMOpticalDiscSlotState CDDA Slot state
		 *
		 */

        IN  virtual tVoid vInformClientsOpticalDiscSlotState(IN const tDMOpticalDiscSlotState  eOpticalDiscSlotState) const = 0;

        /*!
         * \brief to send the cdda device CD Info status to interface
         *
         *\param [IN] trOpticalDiskCDInfo CDDA CD Info
         *
         */

        IN  virtual tVoid vInformClientsOpticalDiscCDInfo(IN const trOpticalDiskCDInfo  f_OpticalDiskCDInfo) const = 0;



}; // class Info_tclDmEolConfSettings

#endif //_IDEVICEMANAGER_INTERFACE_GENERAL_H_

