//ROADMAP13035_Overtemp



/*-----------------------------------------------------------------------------*
 * DeviceManagerInterface.h                                                         *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : G3G                                                           *
 * COPYRIGHT   : (c) 2013-2020 Robert Bosch GmbH, Hildesheim                   *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file VD_DeviceManger.h
 *
 * \brief Implementation of Interface of VD_DEviceManager used by clients - this is mainly used by CCA-VD_DeviceManagerService
 *
 * \version 10.02.2014, Christian K�chling (Bosch), version 1.0
 *          Initial version to serve ROADMAP13035_Overtemp and to make a refactoring
 
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2016
 */

#ifndef _IDEVICEMANAGER_INTERFACE_DIAGNOSIS_H_
#define _IDEVICEMANAGER_INTERFACE_DIAGNOSIS_H_


/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class Info_tclDmEolConfSettings
 */

//@todo after it works rename Info_tclDmEolConfSettings to ConfigurationManager
class IDeviceManagerInterfaceDiagnosis 
{
public:

    typedef enum
    {
        enOvercurrent = 0,
        enOK          = 1,
        enOpen        = 2,
        enFailure     = 3,
        enAbortCalled = 4
    }tenResultResistance;

    /*!
      * \brief Destructor
      *
      * \note This is private since its a singleton class
      */
    virtual ~IDeviceManagerInterfaceDiagnosis(){};





    /*!
         * \brief function to support mounting Mixed Mode CD's. Used in the production line
         *
         * vDiagMountCDRom is called by Diagnosis and VD_DVM uses vDiagMountCDRomResult to return result
         *
         * \parm IN:strDeviceName  e.g.  /dev/sr0
         * \parm IN:strMountPoint    e.g.  /media/cdrom_diag

         * \parm  OUT: enResult: result executing this
         * \return tVoid
         */
    OUT virtual tVoid vDiagMountCDRomResult(OUT tBool bResult,tBool bMount, IN std::string strDeviceName, IN std::string strMountPoint) const = 0; //Roadmap 14002 MountCDROM (diagMixeMode)



    /*!
          * \brief function to support mounting Mixed Mode CD's. Used in the production line
          *
          * vDiagMountCDRom is called by Diagnosis and VD_DVM uses vDiagMountCDRomResult to return result
          *
          * \parm IN:bMount: true or false  means mount  or unmount
          * \parm IN:strDeviceName  e.g.  /dev/sr0
          * \return tVoid  (VD_DVM posts result with vDiagMountCDRomResult)
          */
    IN virtual tVoid vDiagMountCDRom(IN tBool bMount, OUT const std::string &strDeviceName /*e.g. /dev/sr0*/) const = 0; //Roadmap 14002 MountCDROM (diagMixeMode)


    //=====================================================================================
    // IN diagnosis (first used Gen2
    //=====================================================================================

    /*!
          * \brief Enabled/disabled diagnosis
          *
          * \param [in] bEnable TRUE means enable FALSE means disable
          */
    IN virtual tVoid vDiagEnable(tBool bEnable) const = 0;

    /*!
             * \brief // Start timer to get the actual status after 3s of no changes (triggered  in StateTable)
             *
             */
    IN virtual tVoid vDiaglogStartUsbOcTimer() const = 0;

    //=====================================================================================
    // IN ('DIAGLIB'): these functions are used by diaglib-Interface to receive data from VD_DEvicemanager
    //=====================================================================================
    /*!
    * \brief get if USB connector VBUS is switched on or off
    *
    * \param [IN] eUSBConnectorNum: eUSB1, eUSB2 .... i.e.
    * \param [out] eAvtivated SIG_TRUE means activated, SIG_FALSE disabled - variable won't be changed if function returns true
    *
    * \return TRUE if result from prm could be caught. FALSE if an error occurred
    */
    OUT virtual tBool bGetUSBHardwareConnector(IN tenDevManagerUSBHost eUSBConnectorNum,OUT tenSignalValue &eActivated) const = 0;//Roadmap 14003 ReadUSBPowerSupply_Activated/Deactivated


    //=====================================================================================
    // IN (DIAGLIB): these functions are used by diaglib to trigger a function of  VD_DeviceManager
    //=====================================================================================

    /*!
    * \brief set VBUS of USB connectors back to original state defined by ConfigurationManager
    *
    *
    * \return TRUE if result from prm could be caught. FALSE if an error occurred
    */
    IN virtual tBool bInitUSBHardwareConnectors() const = 0;//Roadmap 14003 ReadUSBPowerSupply_Activated/Deactivated

    /*!
        * \brief set VBUS of USB connectors back to demanded state defined by parameters
        *
        * \param [IN] eUSBConnectorNum: eUSB1, eUSB2 .... i.e.
        * \param [out] eAvtivated SIG_TRUE means activated, SIG_FALSE disabled - variable won't be changed if function returns true
        *
        * \return TRUE if result from prm could be caught. FALSE if an error occurred
        */

    IN virtual tBool bSetUSBHardwareConnector(IN tenDevManagerUSBHost eUSBConnectorNum,IN tBool bOn) const = 0;//Roadmap 14003 SetUSBPowerSupply_Activated/Deactivated


    /*!
        * \brief measure resistance at USB connector
        *
        * \param [IN] eUSBConnectorNum: eUSB1, eUSB2 .... i.e.
        * \param [IN] a sendID - answer is received asynchonous this ID gives the possibility of an additional check
        *
        * \return TRUE if result from prm could be caught. FALSE if an error occurred
        */
    IN virtual tBool bStartMeasureResistanceUSBConnector(IN tenDevManagerUSBHost enUSBConnector, tU32 ureSendID) = 0; //Roadmap 14003 Measure resistance of USB-connector (VAGMIBE)




    //=====================================================================================
    // OUT (DIAGLOG): these functions are used by VD_DVM to send to the 'outside world' or to get information from drivers
    //=====================================================================================

    /*!
        * \brief measure resistance at USB connector
        *
        * \param [IN] eUSBConnectorNum: eUSB1, eUSB2 .... i.e.
        * \param [IN] a sendID - answer is received asynchonous this ID gives the possibility of an additional check
        *
        * \return TRUE if result from prm could be caught. FALSE if an error occurred
        */
    OUT virtual tVoid vSendResistanceUSBConnector_Result(IN tenResultResistance enResultResistance, tenDevManagerUSBHost enUSBConnector, IN tU32 u32SendID) = 0; //Roadmap 14003 Measure resistance of USB-connector (VAGMIBE)





    /*!
    * \brief trigger  diagnosis data to be written to diagnosis for test
    *
    * \return
    */
    IN virtual tVoid vOnDiagnosisProductionLineTEST() const = 0;

#ifdef USE_FOURTH_USB_CONNECTOR
    /*!
        * \brief Get the diagnosis parameter values
        *
        * \param [in]  eDiagType gives the type of diagnosis this is bind
        *              calculation of size of device to production line
        *              diagnosis but not to cyclic diagnosis
        * \param [out] f_objUSBDiagnosisHUB1 diagnosis container for hub1
        * \param [out] f_objUSBDiagnosisHUB2 diagnosis container for hub2
        * \param [out] f_objUSBDiagnosisHUB3 diagnosis container for hub3
        * \param [out] f_objUSBDiagnosisHUB4 diagnosis container for hub4
        * -
        * \return [tBool] TRUE: ok, FALSE: if the lock could not be caught
        *         within timeout
        *
        * \todo it is better to hand over an array of objects instead of one
        *       for USB1 and one for USB2
        */
    OUT virtual tBool bGetDiagnosis(CGlobalEnumerations::Diag_Type_e eDiagType, CUSBDiagnosis &f_objUSBDiagnosisHUB1, CUSBDiagnosis &f_objUSBDiagnosisHUB2, CUSBDiagnosis &f_objUSBDiagnosisHUB3, CUSBDiagnosis &f_objUSBDiagnosisHUB4) const = 0;
#else
    /*!
    * \brief Get the diagnosis parameter values
    *
    * \param [in]  eDiagType gives the type of diagnosis this is bind
    *              calculation of size of device to production line
    *              diagnosis but not to cyclic diagnosis
    * \param [out] f_objUSBDiagnosisHUB1 diagnosis container for hub1
    * \param [out] f_objUSBDiagnosisHUB2 diagnosis container for hub2
    * \param [out] f_objUSBDiagnosisHUB3 diagnosis container for hub3
    * -
    * \return [tBool] TRUE: ok, FALSE: if the lock could not be caught
    *         within timeout
    *
    * \todo it is better to hand over an array of objects instead of one
    *       for USB1 and one for USB2
    */
    OUT virtual tBool bGetDiagnosis(CGlobalEnumerations::Diag_Type_e eDiagType, CUSBDiagnosis &f_objUSBDiagnosisHUB1, CUSBDiagnosis &f_objUSBDiagnosisHUB2, CUSBDiagnosis &f_objUSBDiagnosisHUB3) const = 0;

#endif
    /*!
         * \brief Get the connection status of BTA telematics box
         *
         * \note
         *
         *       This function will be accessed by diaglog client handler periodically and check the connection to BTA box from the application layer is still active
         */
    OUT virtual tVoid  vIsBTABoxAlive(INOUT BTAMonitorStates &eBTAMonitoringState,OUT bool &bisBTAAlive) const = 0;

    /*!
         * \brief Set the overtemperature of CDDrive. The input is received from FC_HeatControl
         *
         * \note
         *
         *       This function will call the method of statetable
         */
    IN     virtual tVoid vSetOverTemperatureCDDrive(IN tBool bOverTemperature)  = 0; //Roadmap 13035 Over temperature
    /*!
         * \brief Set the Connection status of Telematics Box. The input is received from FC_ATB
         *
         * \note
         *
         *       This function will be used to check the connection to BTA box from the application layer is still active
         */

    IN     virtual tVoid vSetTelematicsBoxApplicationLayerAlive(IN tBool bIsBTAAlive,IN tU32 u32TimoutBeforeSendingITC) = 0;
    /*!
         * \brief Fill the speed info from the PRM Manager
         *
         * \note
         *
         *       This function will be used by diagnosis to get the device speed.
         */

    IN virtual  tVoid vFillDeviceSpeedinfo(INOUT TelematicsBoxSpeedAndPortInfo f_TelematicsBoxSpeedAndPortInfo[ARRAYSIZEFORUSB]) = 0;


    /*!
          * \brief check if cyclic diagnosis has been switched on
          *
          * \return
          */
    OUT virtual tBool bGetDiagEnable() const = 0;

    OUT virtual tBool bGetSdcDiagnosis( tenSlot eSdcSlot, const tBool& bSdcOcActive ) const = 0;


    /*!
            * \brief read system voltage
            *
            * \param [out] true: critical voltage e.g. below 6.5V but depends on target
            *
            */
    OUT virtual bool IsCriticalVoltage() = 0;


}; // class Info_tclDmEolConfSettings

#endif // _IDEVICEMANAGER_INTERFACE_DIAGNOSIS_H_

////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
// <EOF>

