/************************************************************************
* FILE:         DiagLibHandler
* PROJECT:      
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION:
/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file IDiagLibHandler.h
 *
 * \brief Diaglib Handler to receive comands from FC_Diagnosis
 *
 * \version 31.03.2014, Christian Koechling CM_AI/ECD1
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2016
 */


#ifndef IDIAGLIB_HANDLER_H
#define IDIAGLIB_HANDLER_H

/*-----------------------------------------------------------------------------*
 * class                                                                       *
 *-----------------------------------------------------------------------------*/

/**
 * Message are received by implementing ListenerInterfaces and registering 
 * them with diagnosis library. This demo shows two ways to achieve this.
 * SystemSets are handled in this class. For RoutineControl we create an
 * extra classe that handles requests for two different routines.
 */



// +++ Adjust class prefix +++
class IDiagLibHandler: public diaglib::tclRoutineControlListenerIF, 
                              public diaglib::tclIoControlListenerIF, 
                              public diaglib::tclDiagnosisDataListenerIF
{
public:
   // +++ Depending on the type of listener you need the associated interface to send responses +++
   IDiagLibHandler() : mpDiaglibService(NULL) {};//lint !e1704 Info 1704 , eliminating lint warnings
   IDiagLibHandler(diaglib::tclServiceDiaglib* pDiaglibService) : mpDiaglibService(pDiaglibService) {}; // sim4hi: fix for Coverity CID-17872
   virtual ~IDiagLibHandler(){};

 
    //----------------------------------
    //origin in tclRoutineControlListenerIF
    //----------------------------------
    virtual tU32 vOnGetRoutineResult ( tU32 u32RoutineId,diaglib::tContext MsgContext)= 0; //pur evirtual
    virtual tU32 vOnRoutineControlAbort (tU32 u32RoutineId,diaglib::tContext MsgContext) = 0;
    virtual tU32 vOnRoutineControlStart (tU32 u32RoutineId,tU32 u32Bitmask, const diaglib::tclParameterVector& oParamVector,diaglib::tContext MsgContext) = 0;

    //----------------------------------
    //origin in tclIoControlListenerIF
    //----------------------------------
    virtual tU32 vOnIoControl (tU32 u32IoControlId,diaglib::tenIoControlAction enActionId, const diaglib::tclParameterVector& oParameterVector,diaglib::tContext MsgContext) = 0;
    virtual tU32 vOnIoControlFreeze (tU32 u32IoControlId,diaglib::tContext MsgContext) = 0;
    virtual tU32 vOnIoControlUnfreeze (tU32 u32IoControlId,diaglib::tContext MsgContext) = 0;

    //----------------------------------
    //origin in tclDiagnosisDataListenerIF
    //----------------------------------
   virtual tU32 vOnDiagnosisDataWrite(tU32 /*u32DiagDataId*/,const diaglib::tclParameterVector& /*rfcoParamVector*/,diaglib::tContext /*MsgContext*/) = 0;
   virtual tU32 vOnDiagnosisDataRead(tU32 u32DiagDataId, diaglib::tContext MsgContext) = 0;


protected:
private:
   diaglib::tclServiceDiaglib* mpDiaglibService;

 


};
#endif // IDIAGLIB_HANDLER_H
