#ifndef DIAGLIB_GEN2_HANDLER_H
#define DIAGLIB_GEN2_HANDLER_H

/*-----------------------------------------------------------------------------*
 * Enums                                                                       *
 *-----------------------------------------------------------------------------*/
/*!
 * \enum diag_enHub
 * \brief Enumeration which defines Hub number
 */
enum diag_enHub
{
   EN_HUB_1 = 0, ///< hub number 1
   EN_HUB_2 = 1  ///< hub number 2
};

/*!
 * \enum diag_enUsb
 * \brief Enumeration which defines Usb number
 */
enum diag_enUsb
{
   EN_USB_1 = 0, ///< USB port number 1
   EN_USB_2 = 1  ///< USB port number 2
};


/*-----------------------------------------------------------------------------*
 * Forward declarations                                                        *
 *-----------------------------------------------------------------------------*/
class vd_devicemanager_tclApp;

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class DiaglibHandlerGen2
 *
 * \brief Implementation of a Dignosis Diaglib Data ID Listener
 *
 * \see tclDiagnosisDataListenerIF
 */
class DiaglibHandlerGen2: public tclDiagnosisDataListenerIF
{
        public:

        /*!
         * \brief Parameterized Constructor, based on Dependency Injection
         *        Principle (DIP)
         *
         * \param [in] cpoMainAppl       pointer to main application
         * \param [in] cpoDiaglibService pointer to diaglib service.
         *
         * \return NONE
         */
        DiaglibHandlerGen2(
                vd_devicemanager_tclApp* const cpoMainAppl,
                tclServiceDiaglib* const cpoDiaglibService);

        /*!
         * \brief Destructor
         */
        virtual ~DiaglibHandlerGen2();

#ifdef TTFISCMD_PRODUCTIONLINETEST
        tVoid vOnDiagnosisDataWriteTEST(tVoid);
#endif

    protected:

        /*!
         * \brief Incoming diagnosis data event handler
         *
         * Is called on incoming diagnostic read requests. Components reaction
         * should be one of the following:
         *
         * \param [in] u32DiagDataId diagnosis data ID of the incoming request
         * \param [in] MsgContext    internal message context. Just return
         *           exactly this context when you answer to this request.
         *
         * \return [tU32] ResultCode, currently not checked. Please return 0.
         */
        virtual tU32 vOnDiagnosisDataRead(tU32 u32DiagDataId,
                tContext MsgContext);

        /*!
         * \brief Incoming diagnosis data event handler
         *
         * Is called on incoming diagnostic write requests. Components reaction
         * should be one of the following:
         *
         * \param [in]     u32DiagDataId   diagnosis data ID of the incoming request
         * \param [in,out] rfcoParamVector parameters as specified in the IDspec
         * \param [in]     MsgContext      internal message context. Just return
         *                 exactly this context when you answer to this request.
         *
         * \return [tU32] ResultCode, currently not checked. Please return 0.
         */
        virtual tU32 vOnDiagnosisDataWrite(tU32 u32DiagDataId,
                const tclParameterVector& rfcoParamVector, tContext MsgContext);

        /*!
         * \brief  Default Constructor
         *
         * \note   Default constructor is declared protected to disable it. So
         *         that any attempt to create without parameter will be caught by
         *         the compiler.
         */
        DiaglibHandlerGen2();

        /*!
         * \brief  Copy Constructor
         *
         * \param  [in] rfcoVdDmRC the object to be copied
         *
         * \note   Default copy constructor is declared protected to disable it. So
         *         that any attempt to copy will be caught by the compiler.
         */
        DiaglibHandlerGen2(
                const DiaglibHandlerGen2 &rfcoVdDmRC);

        /*!
         * \brief Assignment Operator
         *
         * \param [in] rfcoVdDmRC the object to be copied
         *
         * \return [DiaglibHandlerGen2&] Reference to this pointer.
         *
         * \note   Assignment operator is declared protected to disable it. So
         *         that any attempt for assignment will be caught by the compiler.
         */
        DiaglibHandlerGen2& operator =(
                const DiaglibHandlerGen2 &rfcoVdDmRC);

    private:

        /*!
         * \brief Function to process the USB version request.
         *
         * \param [in] usb
         * \param [in] MsgContext the message context
         * \param [in] bTestMode
         *
         * \return U32_DIAGLIB_RETURN_OK if the request is successful,
         *         U32_DIAGLIB_RETURN_NOT_OK otherwise
         */
#ifdef TTFISCMD_PRODUCTIONLINETEST
        tU32 u32ProcessUSBVersionRequest(tenDevManagerUSBHost usb,
                tContext MsgContext, tBool bTestMode = FALSE);
#else
        tU32 u32ProcessUSBVersionRequest(tenDevManagerUSBHost usb,tContext MsgContext);
#endif

        /*!
         * \brief Function to process the USB Overcurrent request.
         *
         * \param [in] usb
         * \param [in] MsgContext the message context
         * \param [in] bTestMode
         *
         * \return U32_DIAGLIB_RETURN_OK if the request is successful,
         *         U32_DIAGLIB_RETURN_NOT_OK otherwise
         */
#ifdef TTFISCMD_PRODUCTIONLINETEST
        tU32 u32ProcessUSBVbusRequest(tenDevManagerUSBHost usb,
                tContext MsgContext, tBool bTestMode = FALSE);
#else
        tU32 u32ProcessUSBVbusRequest(tenDevManagerUSBHost usb,tContext MsgContext);

#endif

        /*!
         * \brief Function to process if device is connected to USB1,USB2 and
         *        if SD-card is connected
         *
         * \param [in] MsgContext the message context
         *
         * \return U32_DIAGLIB_RETURN_OK if the request is successful,
         *         U32_DIAGLIB_RETURN_NOT_OK otherwise
         */
        tU32 u32ProcessHMIModuleInput(tContext MsgContext);

        /*!
         * \addtogroup tclMem
         */
        /*! \{*/

        tclServiceDiaglib* m_poDiaglibService; ///< DiagLib service pointer.
        tclDiagnosisDataIF* m_poDataIDIf; ///< DiagLib data id IF pointer.
        vd_devicemanager_tclApp* m_poVdDmApp;

        /*! \}*/
};
#endif // DiaglibHandlerGen2_H

////////////////////////////////////////////////////////////////////////////////
// <EOF>

