/*-----------------------------------------------------------------------------*
 * ServiceHistory.h                                                            *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file ServiceHistory.h
 *
 * \brief This file holds the declaration for CServiceHistory
 *
 * \version 02.08.2012, Negi, Sunder (MontaVista), initial version
 * \version 05.08.2012, Negi, Sunder (MontaVista), Modified and fixed doxygen comments
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2016
 */

#ifndef SERVICEHISTORY_H_
#define SERVICEHISTORY_H_

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class CServiceHistory
 *
 * \brief class to hold the debug information of device manager service
 *
 * \see CObjectHistory
 */
class CServiceHistory:public CObjectHistory
{
private:
    int m_currIndex, m_iSendNo;
    CDevice m_aoLastNotifiedDevices[HELPER_ANAYLSIS_SEND2CLIENTS]; //for analysis

public:

    /*!
     * \brief Constructor
     */
    CServiceHistory();

    /*!
     * \brief Destructor
     */
    ~CServiceHistory();

    /*!
     * \brief shows the last message sent to clients
     */
    void ShowLastMsgSend2Clients ();

    /*!
     * \brief adds info to debug history
     *
     * \param [in] f_oDevice the device notified
     */
    void AddToHistory (CDevice& f_oDevice);

    /*!
     * \brief clears the Service history
     */
    //lint -sem(CServiceHistory::ClearHistory,initializer)
    void ClearHistory();

    /*!
     * \brief displays the service history
     */
    void TraceHistory();
};

#endif // SERVICEHISTORY_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
