/*-----------------------------------------------------------------------------*
 * PrmHistory.cpp                                                              *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file PrmHistory.cpp
 *
 * \brief This file holds the implementation for CPrmHistory
 *
 * \version 02.08.2012, Negi, Sunder (MontaVista), initial version
 * \version 05.08.2012, Negi, Sunder (MontaVista), Modified and fixed doxygen comments
 * \version 13.08.2012, Negi, Sunder (MontaVista), cleanup logging to usb (WRITEHISTORYTOUSBSTICK)
 * \version 28.08.2012, Koechling, Christian (Bosch), enable logging to USB-stick 
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2016
 */

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"

#define INCLUDE_VD_DVM_OSAL
#define INCLUDE_VD_DVM_BASICS
#include "Common.h"

#include "Enums.h"
#include "Device.h"
#include "DeviceCard.h"
#include "debug/ObjectHistory.h"
#include "debug/PrmHistory.h"
#include "config/ConfigurationManager.h" //for eclapsed time

/*-----------------------------------------------------------------------------*
 * ETG Tracing                                                                 *
 *-----------------------------------------------------------------------------*/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_dvm.h"

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_DEVICEMANAGER_HISTORYMANAGER
#include "trcGenProj/Header/PrmHistory.cpp.trc.h"
#endif

#include "ETGTrace.h"
#endif //VARIANT_S_FTR_ENABLE_UNITTEST

/*-----------------------------------------------------------------------------*
 * Namespace                                                                   *
 *-----------------------------------------------------------------------------*/
using namespace prmmgr;

/*-----------------------------------------------------------------------------*
 * Constructor                                                                 *
 *-----------------------------------------------------------------------------*/
CPrmHistory::CPrmHistory()
{
    m_poDumpFile = NULL;

    CPrmHistory::ClearHistory();
}//lint !e1566 
//Warning 1566: prio3: member 'CPrmHistory::m_currIndex' might have been initialized by a separate function but no '-sem(CPrmHistory::ClearHistory,initializer)' was seen
//Warning 1566: prio3: member 'CPrmHistory::m_uiSendNo'   might have been initialized by a separate function but no '-sem(CPrmHistory::ClearHistory,initializer)' was seen
//Warning 1566: prio3: member 'CPrmHistory::m_aoPrmEvts' might have been initialized by a separate function but no '-sem(CPrmHistory::ClearHistory,initializer)' was seen
//done in ClearHistory()

/*-----------------------------------------------------------------------------*
 * Destructor                                                                  *
 *-----------------------------------------------------------------------------*/
CPrmHistory::~CPrmHistory()
{
    // Do nothing
}

/*-----------------------------------------------------------------------------*
 * void AddToHistory (UsbPortState *pPortState)                                *
 *-----------------------------------------------------------------------------*/
void CPrmHistory::AddToHistory ( const UsbPortState *pPortState)
{
    ETG_TRACE_USR3 (("AddToHistory: Begin"));

    m_LockHistory.lock();

    if (NULL != pPortState)
    {
        m_uiSendNo++;
        m_aoPrmEvts[m_currIndex].history.u8PortNr         = pPortState->u8PortNr;
        m_aoPrmEvts[m_currIndex].history.u8OC             = pPortState->u8OC;
        m_aoPrmEvts[m_currIndex].history.u8UV             = pPortState->u8UV;
        m_aoPrmEvts[m_currIndex].history.u8PPON           = pPortState->u8PPON;
        m_aoPrmEvts[m_currIndex].history.u32OCStartTime   = pPortState->u32OCStartTime;
        m_aoPrmEvts[m_currIndex].history.u32OCEndTime     = pPortState->u32OCEndTime;
        m_aoPrmEvts[m_currIndex].history.u32UVStartTime   = pPortState->u32UVStartTime;
        m_aoPrmEvts[m_currIndex].history.u32UVEndTime     = pPortState->u32UVEndTime;
        m_aoPrmEvts[m_currIndex].history.u32PPONStartTime = pPortState->u32PPONStartTime;
        m_aoPrmEvts[m_currIndex].history.u32PPONEndTime   = pPortState->u32PPONEndTime;

        m_aoPrmEvts[m_currIndex].send_nr   = m_uiSendNo;
        m_aoPrmEvts[m_currIndex].send_time = (tU32)ConfigurationManager::GetInstance()->GetEclapsedTime_ms();;

        m_currIndex++;

        if (m_currIndex > (HELPER_ANAYLSIS_PRMCALLBACKS-1))
        {
            m_currIndex = 0;
        }
    }

    m_LockHistory.unlock();

    ETG_TRACE_USR3 (("AddToHistory: End"));
}

/*-----------------------------------------------------------------------------*
 * void TraceHistory ()                                                        *
 *-----------------------------------------------------------------------------*/
void CPrmHistory::TraceHistory()
{
    ETG_TRACE_USR3 (("TraceHistory: Begin"));
    ETG_TRACE_FATAL (("[ok] ===============================->PrmManager==============================="));

    tU64 u64StartTimeAbsoluteDeviceManager = ConfigurationManager::GetInstance()->GetStartTime_ms();
    ETG_TRACE_U64_FATAL((char*)"u64StartTimeAbsoluteDeviceManager (ms) : ",u64StartTimeAbsoluteDeviceManager);
    ETG_TRACE_U64_FATAL((char*)"u64StartTimeAbsoluteDeviceManager (sec): ",u64StartTimeAbsoluteDeviceManager/1000);

    // dump to file, if available
    if (NULL != m_poDumpFile)
    {
        fprintf (m_poDumpFile,
                "\n[ok] ===============================->PrmManager===============================");
    }

    UsbPortState *pPortState = NULL;

    for (unsigned int itr = 0; itr < m_currIndex; itr++)
    {
        pPortState = &m_aoPrmEvts[itr].history;

        ETG_TRACE_FATAL ((">>>>>>>>>>>>>>>>>>>>>>>>/PRM: fctCallbackHWSignals [%d]>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
                m_aoPrmEvts[itr].send_nr));
        ETG_TRACE_FATAL (("[%d]  m_uiSendNo:           %d",
                m_aoPrmEvts[itr].send_nr, m_aoPrmEvts[itr].send_nr));
        ETG_TRACE_FATAL (("[%d]  m_sendTime:           %d ms",
                m_aoPrmEvts[itr].send_nr, m_aoPrmEvts[itr].send_time));
        ETG_TRACE_FATAL (("[%d]  rPortState->u8PortNr: %d                                   ",
                m_aoPrmEvts[itr].send_nr, ETG_ENUM(TENDEVMANAGERUSBHOST,pPortState->u8PortNr)));
        ETG_TRACE_FATAL (("[%d]  rPortState->u8OC:     %d  [StartTime=%d   EndTime=%d]  ",
                m_aoPrmEvts[itr].send_nr, ETG_ENUM(TENSIGNALVALUE,pPortState->u8OC),
                pPortState->u32OCStartTime, pPortState->u32OCEndTime));
        ETG_TRACE_FATAL (("[%d]  rPortState->u8UV:     %d  [StartTime=%d   EndTime=%d]  ",
                m_aoPrmEvts[itr].send_nr, ETG_ENUM(TENSIGNALVALUE,pPortState->u8UV),
                pPortState->u32UVStartTime, pPortState->u32UVEndTime));
        ETG_TRACE_FATAL (("[%d]  rPortState->u8PPON:   %d  [StartTime=%d   EndTime=%d]  ",
                m_aoPrmEvts[itr].send_nr, ETG_ENUM(TENSIGNALVALUE,pPortState->u8PPON),
                pPortState->u32PPONStartTime, pPortState->u32PPONEndTime));
        ETG_TRACE_FATAL (("<<<<<<<<<<<<<<<<<<<<<<<<<PRM: fctCallbackHWSignals/<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<"));
        ETG_TRACE_FATAL (("                                                               "));

        // dump to file, if available
        if (NULL != m_poDumpFile)
        {
            fprintf (m_poDumpFile, "\n>>>>>>>>>>>>>>>>>>>>>>>>/PRM: fctCallbackHWSignals [%u]>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
                    m_aoPrmEvts[itr].send_nr);
            fprintf (m_poDumpFile, "\n[%u]  m_uiSendNo:           %u",
                    m_aoPrmEvts[itr].send_nr, m_aoPrmEvts[itr].send_nr);
            fprintf (m_poDumpFile, "\n[%u]  m_sendTime:           %u ms",
                    m_aoPrmEvts[itr].send_nr, (tUInt)m_aoPrmEvts[itr].send_time);
            fprintf (m_poDumpFile, "\n[%u]  rPortState->u8PortNr: %d                                   ",
                    m_aoPrmEvts[itr].send_nr, ETG_ENUM(TENDEVMANAGERUSBHOST,pPortState->u8PortNr));
            fprintf (m_poDumpFile, "\n[%u]  rPortState->u8OC:     %d  [StartTime=%u   EndTime=%u]  ",
                    m_aoPrmEvts[itr].send_nr, ETG_ENUM(TENSIGNALVALUE,pPortState->u8OC),
                    (tUInt)pPortState->u32OCStartTime, (tUInt)pPortState->u32OCEndTime);
            fprintf (m_poDumpFile, "\n[%u]  rPortState->u8UV:     %d  [StartTime=%u   EndTime=%u]  ",
                    m_aoPrmEvts[itr].send_nr, ETG_ENUM(TENSIGNALVALUE,pPortState->u8UV),
                    (tUInt)pPortState->u32UVStartTime, (tUInt)pPortState->u32UVEndTime);
            fprintf (m_poDumpFile, "\n[%u]  rPortState->u8PPON:   %d  [StartTime=%u   EndTime=%u]  ",
                    m_aoPrmEvts[itr].send_nr, ETG_ENUM(TENSIGNALVALUE,pPortState->u8PPON),
                    (tUInt)pPortState->u32PPONStartTime, (tUInt)pPortState->u32PPONEndTime);
            fprintf (m_poDumpFile, "\n<<<<<<<<<<<<<<<<<<<<<<<<<PRM: fctCallbackHWSignals/<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
            fprintf (m_poDumpFile, "\n                                                               ");
        }
    }

    ETG_TRACE_FATAL (("[ok] ================================PrmManager<-=============================="));

    // dump to file, if available
    if (NULL != m_poDumpFile)
    {
        fprintf (m_poDumpFile,
                "\n[ok] ================================PrmManager<-==============================");
    }

    ETG_TRACE_USR3 (("TraceHistory: End"));
}

/*-----------------------------------------------------------------------------*
 * void ClearHistory ()                                                        *
 *-----------------------------------------------------------------------------*/
void CPrmHistory::ClearHistory()
{
    ETG_TRACE_USR3 (("ClearHistory: Begin"));

    m_uiSendNo   = 0;
    m_currIndex = 0;

    for (int i = 0; i < HELPER_ANAYLSIS_PRMCALLBACKS; i++)
    {
        m_aoPrmEvts[i].send_nr   = 0;
        m_aoPrmEvts[i].send_time = 0;

        m_aoPrmEvts[i].history.u8PortNr         = 0;
        m_aoPrmEvts[i].history.u8OC             = 0;
        m_aoPrmEvts[i].history.u8UV             = 0;
        m_aoPrmEvts[i].history.u8PPON           = 0;
        m_aoPrmEvts[i].history.u32OCStartTime   = 0;
        m_aoPrmEvts[i].history.u32OCEndTime     = 0;
        m_aoPrmEvts[i].history.u32UVStartTime   = 0;
        m_aoPrmEvts[i].history.u32UVEndTime     = 0;
        m_aoPrmEvts[i].history.u32PPONStartTime = 0;
        m_aoPrmEvts[i].history.u32PPONEndTime   = 0;
    }

    ETG_TRACE_USR3 (("ClearHistory: End"));
}   //lint !e1565 Warning 1565: member 'CObjectHistory::m_poDumpFile' (VD_DeviceManager/inc/debug/ObjectHistory.h) not assigned by initializer function

////////////////////////////////////////////////////////////////////////////////
// <EOF>
