/*-----------------------------------------------------------------------------*
 * ObjectHistory.cpp                                                           *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file ObjectHistory.cpp
 *
 * \brief This file holds the implementation for ObjectHistory
 *
 * Each object that needs to maintain history needs to implement this interace.
 *
 * \version 14.08.2012, Negi, Sunder (MontaVista), initial version
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"

#define INCLUDE_VD_DVM_OSAL
#define INCLUDE_VD_DVM_BASICS
#include "Common.h"
#include "debug/ObjectHistory.h"

//#include <stdio.h>antilint: repeatedly included but does not have a standard include guard


/*-----------------------------------------------------------------------------*
 * ETG Tracing                                                                 *
 *-----------------------------------------------------------------------------*/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_dvm.h"

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_DEVICEMANAGER_HISTORYMANAGER
#include "trcGenProj/Header/ObjectHistory.cpp.trc.h"
#endif

#include "ETGTrace.h"
#endif //VARIANT_S_FTR_ENABLE_UNITTEST

/*-----------------------------------------------------------------------------*
 * Constructor                                                                 *
 *-----------------------------------------------------------------------------*/
CObjectHistory::CObjectHistory()
{
    m_poDumpFile = NULL;
}

/*-----------------------------------------------------------------------------*
 * Destructor                                                                  *
 *-----------------------------------------------------------------------------*/
CObjectHistory::~CObjectHistory()
{
    m_poDumpFile = NULL;
    // Do nothing
}

/*-----------------------------------------------------------------------------*
 * void setDumpFile (const FILE*poDumpFile)                                  *
 *-----------------------------------------------------------------------------*/
void CObjectHistory::setDumpFile(FILE*poDumpFile)
{
    m_poDumpFile = poDumpFile;
}

////////////////////////////////////////////////////////////////////////////////
// <EOF>
