/*-----------------------------------------------------------------------------*
 * HWMalfunctionHistory.h                                                          *
 *-----------------------------------------------------------------------------*
-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file HWMalfunctionHistory.h
 *
 * \brief This file holds the declaration for HWMalfunctionHistory
 *
 * \version 31.03.2016, adjusted for Gen3 with VoltageManager
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2020
 */

#ifndef MWMALFUNCTIONHISTORY_H_
#define MWMALFUNCTIONHISTORY_H_

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * Structs                                                                     *
 *-----------------------------------------------------------------------------*/
struct HWMalfunctionEvt
{
    int                  send_nr;
    tU32                 sent_time;
    GENSTRING            strCallingFunction;
    structNotifyClients  deviceInfo;
    tBool                bDeviceInfoValid;
};

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class HWMalfunctionHistory
 *
 * \brief class to hold the debug information of SPM clienthandler
 *
 * \see CObjectHistory
 */
class HWMalfunctionHistory:public CObjectHistory
{
    private:
   
        int m_iSendNo;
        int m_currIndex;

        struct HWMalfunctionEvt m_rHWMalfunctionEvt[HELPER_ANALYSIS_HWMALFUNCTION];

    public:

        /*!
         * \brief Constructor
         */
        HWMalfunctionHistory();

        /*!
         * \brief Destructor
         */
        ~HWMalfunctionHistory();

        /*!
         * \brief adds info to debug history
         *
         * \param [in] eSpmCvmActive the debug info
         */
        void AddToHistory(GenString strFctName,structNotifyClients *pDeviceInfo);

        /*!
         * \brief clears the Diagnosis clienthandler history
         */
        //lint -sem(HWMalfunctionHistory::ClearHistory,initializer)
        void ClearHistory();

        /*!
         * \brief displays the Diagnosis clienthandler history
         */
        void TraceHistory();
};

#endif // MWMALFUNCTIONHISTORY_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
