/*-----------------------------------------------------------------------------*
 * DiagClientHistory.h                                                         *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file DiagClientHistory.h
 *
 * \brief This file holds the declaration for CDiagClientHistory
 *
 * \version 02.08.2012, Negi, Sunder (MontaVista), initial version
 * \version 05.08.2012, Negi, Sunder (MontaVista), Modified and fixed doxygen comments
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifndef DIAGCLIENTHISTORY_H_
#define DIAGCLIENTHISTORY_H_

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * Forward declarations                                                        *
 *-----------------------------------------------------------------------------*/
class midw_fi_tcl_TestResultList;

/*-----------------------------------------------------------------------------*
 * Structs                                                                     *
 *-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class CDiagClientHistory
 *
 * \brief class to hold the debug information of Diagnosis clienthandler
 *
 * \see CObjectHistory
 */
class CDiagClientHistory:public CObjectHistory
{
    private:
        unsigned int m_currIndex,m_iSendCounter;

        trDiagEvt m_aoDiagEvts[HELPER_ANAYLSIS_SEND2DIAGNOSIS];

    public:

        /*!
         * \brief Constructor
         */
        CDiagClientHistory();

        /*!
         * \brief Destructor
         */
        ~CDiagClientHistory();

        /*!
         * \brief adds info to debug history
         *
         * \param [in] f_oTestResultList the diagnosis test results
         */
        void AddToHistory (trDiagEvt& f_rDiagEvent);

        /*!
         * \brief clears the Diagnosis clienthandler history
         */
        //lint -sem(CDiagClientHistory::ClearHistory,initializer)
        void ClearHistory();

        /*!
         * \brief displays the Diagnosis clienthandler history
         */
        void TraceHistory();
};

#endif // DIAGCLIENTHISTORY_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
