/*-----------------------------------------------------------------------------*
 * IStateTableVoltage.h                                                      *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM G3G                                                   *
 * COPYRIGHT   : (c) 2014-2016  Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file IStateTableVoltage.h
 *
 * \brief Interface used by VoltageManager to inform StateTable
 *
 * \version 25.09.2014, Koechling Christian (CM-AI/ECD1), version 1.0
 
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifndef INTERFCACE_STATETABLE_VOLTAGE_H
#define INTERFCACE_STATETABLE_VOLTAGE_H  

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class IStateTableVoltage
 */

class IStateTableVoltage
{
    public:

        /*!
         * \brief Destructor
         */
        virtual ~IStateTableVoltage(){};

    /*!
         * \brief Used by voltage manager to notify  undervoltage to StateTable
         *        voltage. Values are written into a queue and received and
         *        used in StartMonitorLooseBlocking see 'case enVoltWarning'
         *        undervoltage is a voltage where USB-connectors are switched off by underlying platform
         *
         * \param [in] eUsb       connector usb i.e. which connector is
         *             influenced by under voltage. 
         * \param [in] eU60_drop SIG_TRUE means undervoltage, SIG_FALSE means
         *             normal voltage
         */
     virtual tVoid setVoltage(IN tenDevManagerUSBHost eUsb,IN tenSignalValue eU60_drop) = 0;

   protected:
    
      /*!
            * \brief helperfunction used by public setvoltage function. function is mentioned here to emphasise binding to setVoltage-function.
            *          In unit tests no threads are used. if setvolate is called then this normally fills a messag queue. A Thread is waiting for that message and calls correspoding vCase-function
            *          Hence in unit tests below function is used which fills msg-content. The unit test does call directly the correspodning vCase-function. I.e. it does what the thread does but
            *          same function are envolved to be as close as possible at what happens with the thread
            *
            */
       virtual tBool  setVoltageFill(IN tenDevManagerUSBHost eUsb,IN tenSignalValue eU60_drop, OUT util_StructMsg &oMsg) = 0;

};
// class IStateTableVoltage

#endif // INTERFCACE_STATETABLE_VOLTAGE_H

////////////////////////////////////////////////////////////////////////////////
// <EOF>

