/*-----------------------------------------------------------------------------*
 * WriterDatapool.h                                                      *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM G3G                                                   *
 * COPYRIGHT   : (c) 2014-2016  Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file WriterDatapool.h
 *
 * \brief Implementation to  write  persistent configuration
 *
 * \version 27.01.2016, Rajeev Narayanan Sambhu (RBEI/ECS1) <Rajeev.NarayananSambhu@in.bosch.com>, version 1.0

 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifndef WRITER_DATAPOOL_H
#define WRITER_DATAPOOL_H

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class ReaderDataPool
 */

class WriterDataPool: public IConfigurationPersistent
{
public:

    /*!
         * \brief Default constructor
         */
    WriterDataPool();

    /*!
         * \brief Destructor
         */
    virtual ~WriterDataPool();


	/*!
	* \brief to get type of reader 
	*/
	virtual int GetTypeOfReader();

    /*!
         * \brief see description in IConfigurationPersistent
         */
    virtual tBool bWriteDataPool(IN tU16 eTypeOfConfigValue, IN tU16 u16ConfigValue  );

    /*!
         * \brief see description in IConfigurationPersistent -- Write ExternalHub info to DP
         */
    virtual tBool bWriteDataPool(IN trExternalHubInfo f_uiExternalHubInfo [], IN tU8 f_uiNumberOfExternalHubsUsed  );

    /*!
         * \brief see description in IConfigurationPersistent -- Write TelematicsBoxDevice info to DP
         */
    virtual tBool bWriteDataPool(IN trTelematicsBoxDeviceInfo f_uiTelematicsBoxDeviceInfo [], IN tU8 f_uiNumberOfTelematicBoxesUsed  );


private:



};
// class WriterDataPool

#endif // WRITER_DATAPOOL_H

////////////////////////////////////////////////////////////////////////////////
// <EOF>
