/*-----------------------------------------------------------------------------*
 * ReaderDatapool.cpp                                                    *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : G3G                                                   *
 * COPYRIGHT   : (c) 2012 - 2020 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file WriterDatapool.cpp
 *
 * \brief Implementation to  read Datapool.
 *
 * \version 27.01.2016, Rajeev Narayanan Sambhu (RBEI/ECS1) <Rajeev.NarayananSambhu@in.bosch.com>, version 1.0
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2020
 */

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"



#define INCLUDE_VD_DVM_OSAL
#define INCLUDE_VD_DVM_BASICS
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EOL
#define INCLUDE_VD_DVM_EOLLIB
#endif // #ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EOL
#endif //VARIANT_S_FTR_ENABLE_UNITTEST

#include "Common.h"
#include "Enums.h"

#include "config/IConfigurationPersistent.h"
#include "config/WriterDatapool.h"
#include "config/ConfigurationBase.h"





/*-----------------------------------------------------------------------------*
 * ETG Tracing                                                                 *
 *-----------------------------------------------------------------------------*/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_dvm.h"

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_DEVICEMANAGER_CONFIGMANAGER
#include "trcGenProj/Header/WriterDatapool.cpp.trc.h"
#endif
#include "ETGTrace.h"
#endif //VARIANT_S_FTR_ENABLE_UNITTEST

// Includes all header files for FI of DP-component
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_devicemanager_if.h"


/*-----------------------------------------------------------------------------*
 * Constructor                                                                 *
 *-----------------------------------------------------------------------------*/
WriterDataPool::WriterDataPool()
{
    ETG_TRACE_USR4(("Begin:WriterDataPool"));

    ETG_TRACE_USR4(("End  :WriterDataPool"));

}// WriterDataPool::WriterDataPool()


/*-----------------------------------------------------------------------------*
 * Destructor                                                                  *
 *-----------------------------------------------------------------------------*/
WriterDataPool::~WriterDataPool()
{
    ETG_TRACE_USR4(("Begin:~WriterDataPool"));

    ETG_TRACE_USR4(("End  :~WriterDataPool"));
} // WriterDataPool::~WriterDataPool()

/*-----------------------------------------------------------------------------*
 * tBool bWriteDataPool(tU16,tU16)
 *-----------------------------------------------------------------------------*/
tBool WriterDataPool::bWriteDataPool(IN tU16 eTypeOfConfigValue, IN tU16 u16ConfigValue  )
{
    ETG_TRACE_USR4(("Begin:bWriteDataPool"));
    tBool bRet = TRUE;
    tBool bFound = TRUE;
    dp_tclBaseElement myDpElem;
    int iRetVal;

    switch(eTypeOfConfigValue)
    {
    case eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1:
    {
        dp_tcldevicemanagerDPeCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1 dpelemnt;
        iRetVal = dpelemnt.s32SetData(u16ConfigValue);
        if(DP_S32_NO_ERR > iRetVal)
        {
            ETG_TRACE_USR4(("bWriteDataPool Error in storing the configuration param %d. The error code obtained is %d",eTypeOfConfigValue,iRetVal));
            bRet = FALSE;
        }
        break;
    }
    case eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB2:
    {
        dp_tcldevicemanagerDPeCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB2 dpelemnt;
        iRetVal = dpelemnt.s32SetData(u16ConfigValue);
        if(DP_S32_NO_ERR > iRetVal)
        {
            ETG_TRACE_USR4(("bWriteDataPool Error in storing the configuration param %d. The error code obtained is %d",eTypeOfConfigValue, iRetVal));
            bRet = FALSE;
        }
        break;
    }
    case eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB3:
    {
        dp_tcldevicemanagerDPeCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB3 dpelemnt;
        iRetVal = dpelemnt.s32SetData(u16ConfigValue);
        if(DP_S32_NO_ERR > iRetVal)
        {
            ETG_TRACE_USR4(("bWriteDataPool Error in storing the configuration param %d. The error code obtained is %d",eTypeOfConfigValue,iRetVal));
            bRet = FALSE;
        }
        break;
    }
    case eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB4:
    {
        dp_tcldevicemanagerDPeCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB4 dpelemnt;
        iRetVal = dpelemnt.s32SetData(u16ConfigValue);
        if(DP_S32_NO_ERR > iRetVal)
        {
            ETG_TRACE_USR4(("bWriteDataPool Error in storing the configuration param %d. The error code obtained is %d",eTypeOfConfigValue,iRetVal));
            bRet = FALSE;
        }
        break;
    }
    default:
    {
        ETG_TRACE_USR4(("bWriteDataPool Configuration param %d is not allowed for set ",eTypeOfConfigValue));
        break;
    }

    }
    ETG_TRACE_USR4(("End:bWriteDataPool"));
    return bRet;

}

/*-----------------------------------------------------------------------------*
 * tBool bWriteDataPool(trExternalHubInfo,tU8)
 *-----------------------------------------------------------------------------*/
tBool WriterDataPool::bWriteDataPool(IN trExternalHubInfo f_uiExternalHubInfo [], IN tU8 f_uiNumberOfExternalHubsUsed  )
{
    ETG_TRACE_USR4(("Begin:bWriteDataPool.."));
    tBool bRet = TRUE;

    int iRetVal;
    dp_tcldevicemanagerDPEXTERNALHUB_DETAILS dpelement;
    dp_tcldevicemanagerDPEXTERNALHUB_COUNT dpelementcount;
    trDPExternalHubInfo l_DPExternalHubInfo[10];

    for(int i=0; i <f_uiNumberOfExternalHubsUsed ; i++ )  //Write to DP type array
    {
        l_DPExternalHubInfo[i].u16VendorID=f_uiExternalHubInfo[i].iVendorID;
        l_DPExternalHubInfo[i].u16ProductID=f_uiExternalHubInfo[i].iProductID;
        l_DPExternalHubInfo[i].u16USBConnector=f_uiExternalHubInfo[i].eUsb;
    }

    ETG_TRACE_USR4(("***********************bWriteDataPool ExternalHub l_DPExternalHubInfo***********************"));
    for(int i=0 ; i<f_uiNumberOfExternalHubsUsed ; i++)
    {
        ETG_TRACE_USR4(("ExternalHub in array: l_DPExternalHubInfo[%d].u16VendorID = 0x%x",i,l_DPExternalHubInfo[i].u16VendorID));
        ETG_TRACE_USR4(("ExternalHub in array: l_DPExternalHubInfo[%d].u16ProductID =0x%x",i,l_DPExternalHubInfo[i].u16ProductID));
        ETG_TRACE_USR4(("ExternalHub in array: l_DPExternalHubInfo[%d].u16USBConnector = %d",i,l_DPExternalHubInfo[i].u16USBConnector));
        ETG_TRACE_USR4(("---------------------------------------------------------------------------------------"));
    }

    iRetVal = dpelement.s32SetData(l_DPExternalHubInfo,(sizeof(l_DPExternalHubInfo)/sizeof(l_DPExternalHubInfo[0])));
    iRetVal = dpelementcount.s32SetData(f_uiNumberOfExternalHubsUsed);
    if(DP_S32_NO_ERR > iRetVal)
    {
        ETG_TRACE_USR4(("bWriteDataPool Error in storing the ExternalHub param. The error code obtained is %d",iRetVal));
        bRet = FALSE;
    }

    ETG_TRACE_USR4(("End:bWriteDataPool"));
    return bRet;
}

/*-----------------------------------------------------------------------------*
 * tBool bWriteDataPool(trTelematicsBoxDeviceInfo,tU8)
 *-----------------------------------------------------------------------------*/
tBool WriterDataPool::bWriteDataPool(IN trTelematicsBoxDeviceInfo f_uiTelematicsBoxDeviceInfo [], IN tU8 f_uiNumberOfTelematicBoxesUsed  )
{
    ETG_TRACE_USR4(("Begin:bWriteDataPool.."));
    tBool bRet = TRUE;
    int iRetVal;
    dp_tcldevicemanagerDPTELEMATICSBOXDEVICE_DETAILS dpelement;
    dp_tcldevicemanagerDPTELEMATICSBOXDEVICE_COUNT dpelementcount;
    trDPTelematicsBoxDeviceInfo l_DPTelematicsBoxDeviceInfo[10];

    for(int i=0; i <f_uiNumberOfTelematicBoxesUsed ; i++ )  //Write to DP type array
    {
        l_DPTelematicsBoxDeviceInfo[i].u16VendorID=f_uiTelematicsBoxDeviceInfo[i].iVendorID;
        l_DPTelematicsBoxDeviceInfo[i].u16ProductID=f_uiTelematicsBoxDeviceInfo[i].iProductID;
        l_DPTelematicsBoxDeviceInfo[i].bIsHighSpeedExpected=f_uiTelematicsBoxDeviceInfo[i].bIsHighSpeedExpected;
        l_DPTelematicsBoxDeviceInfo[i].u16USBConnector=f_uiTelematicsBoxDeviceInfo[i].eUsb;
    }

    ETG_TRACE_USR4(("***********************bWriteDataPool TelematicsBoxDeviceInfo l_DPTelematicsBoxDeviceInfo***********************"));
    for(int i=0 ; i<f_uiNumberOfTelematicBoxesUsed ; i++)
    {
        ETG_TRACE_USR4(("TelematicsBoxDeviceInfo in array: l_DPTelematicsBoxDeviceInfo[%d].u16VendorID = 0x%x",i,l_DPTelematicsBoxDeviceInfo[i].u16VendorID));
        ETG_TRACE_USR4(("TelematicsBoxDeviceInfo in array: l_DPTelematicsBoxDeviceInfo[%d].u16ProductID = 0x%x",i,l_DPTelematicsBoxDeviceInfo[i].u16ProductID));
        ETG_TRACE_USR4(("TelematicsBoxDeviceInfo in array: l_DPTelematicsBoxDeviceInfo[%d].bIsHighSpeedExpected = 0x%x",i,l_DPTelematicsBoxDeviceInfo[i].bIsHighSpeedExpected));
        ETG_TRACE_USR4(("TelematicsBoxDeviceInfo in array: l_DPTelematicsBoxDeviceInfo[%d].u16USBConnector = %d",i,l_DPTelematicsBoxDeviceInfo[i].u16USBConnector));
        ETG_TRACE_USR4(("---------------------------------------------------------------------------------------"));
    }

    iRetVal = dpelement.s32SetData(l_DPTelematicsBoxDeviceInfo,(sizeof(l_DPTelematicsBoxDeviceInfo)/sizeof(l_DPTelematicsBoxDeviceInfo[0])));
    iRetVal = dpelementcount.s32SetData(f_uiNumberOfTelematicBoxesUsed);
    if(DP_S32_NO_ERR > iRetVal)
    {
        ETG_TRACE_USR4(("bWriteDataPool Error in storing the TelematicsBoxDeviceInfo param. The error code obtained is %d",iRetVal));
        bRet = FALSE;
    }

    ETG_TRACE_USR4(("End:bWriteDataPool"));
    return bRet;
}


int WriterDataPool::GetTypeOfReader()
{
    return (int)eReader_WriterDataPool;
}

