/*-----------------------------------------------------------------------------*
 * ReaderDatapool.h                                                      *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM G3G                                                   *
 * COPYRIGHT   : (c) 2014-2016  Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file ReaderDatapool.h
 *
 * \brief Implementation to  read  persistent configuration
 *
 * \version 27.01.2016, Rajeev Narayanan Sambhu (RBEI/ECS1) <Rajeev.NarayananSambhu@in.bosch.com>, version 1.0

 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifndef READER_DATAPOOL_H
#define READER_DATAPOOL_H
#include "Config.h"

#define INCLUDE_VD_DVM_OSAL
#define INCLUDE_VD_DVM_BASICS
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EOL
#define INCLUDE_VD_DVM_EOLLIB
#endif // #ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EOL
#endif //VARIANT_S_FTR_ENABLE_UNITTEST
//#define INCLUDE_VD_DVM_QTDBUS
#include "Common.h"
#include "Enums.h"
/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class ReaderDataPool
 */

class ReaderDataPool: public IConfigurationPersistent
{
public:

    /*!
         * \brief Default constructor
         */
    ReaderDataPool();

    /*!
         * \brief Destructor
         */
    virtual ~ReaderDataPool();

    /*!
         * \brief to get type of reader 
         */
	virtual int GetTypeOfReader();

    /*!
         * \brief see description in IConfigurationPersistent
         */
    virtual tBool bReadDataPool(IN tU16  eTypeOfConfigValue, OUT tU16 &u16ConfigValue);

    /*!
         * \brief see description in IConfigurationPersistent -- Read ExternalHub info from DP
         */
    virtual tBool bReadDataPool(OUT trExternalHubInfo f_uiExternalHubInfo [], OUT tU8 &f_uiNumberOfExternalHubsUsed );

    /*!
         * \brief see description in IConfigurationPersistent -- Read TelematicsBoxDevice info from DP
         */
    virtual tBool bReadDataPool(OUT trTelematicsBoxDeviceInfo f_uiTelematicsBoxDeviceInfo [], OUT tU8 &f_uiNumberOfTelematicBoxesUsed  );

private:



};
// class ReaderDataPool

#endif // READER_DATAPOOL_H

////////////////////////////////////////////////////////////////////////////////
// <EOF>
