#include "Config.h"

#define INCLUDE_VD_DVM_OSAL
#define INCLUDE_VD_DVM_BASICS
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EOL
#define INCLUDE_VD_DVM_EOLLIB
#endif // #ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EOL
#endif //VARIANT_S_FTR_ENABLE_UNITTEST
//#define INCLUDE_VD_DVM_QTDBUS
#include "Common.h"
#include "Enums.h"
#include "Device.h"
#include "DeviceCard.h"
#include "DeviceManager_ErrorCodes.h"

#ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT
#include <inttypes.h>
#endif

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef USE_DATAPOOL_INSTEADOF_KDS
#define DP_S_IMPORT_INTERFACE_KDS_FI
#include "dp_kds_if.h"
#endif //USE_DATAPOOL_INSTEADOF_KDS
#endif //VARIANT_S_FTR_ENABLE_UNITTEST



/*-----------------------------------------------------------------------------*
 * ETG Tracing                                                                 *
 *-----------------------------------------------------------------------------*/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_dvm.h"


#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_DEVICEMANAGER_CONFIGMANAGER
#include "trcGenProj/Header/ConfigurationManager.cpp.trc.h"
#endif
#include "ETGTrace.h"
#endif //VARIANT_S_FTR_ENABLE_UNITTEST

#include "common/utils.h"
#include "device/DeviceListManager.h"
#include "config/ConfigurationManager.h"
#include "config/IConfigurationPersistent.h"
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL
#include "config/WriterDatapool.h"//for writing the persistent data
#endif//VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL

const uint16_t u16AppleVendorID = 0x05ac;

/*-----------------------------------------------------------------------------*
 * namespace                                                                     *
 *-----------------------------------------------------------------------------*/
using namespace configmgr;
using namespace generic_kds;

/*-----------------------------------------------------------------------------*
 * Singleton                                                                   *
 *-----------------------------------------------------------------------------*/
ConfigurationManager  *ConfigurationManager::m_pConfigurationManager = NULL; // static pointer used to ensure a single instance of PrmManager
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
DVMLOCK ConfigurationManager::m_singelton;
#endif


ConfigurationManager * ConfigurationManager::GetInstance()
{
    //ETG_TRACE_USR4(("Begin: GetInstance"));

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
    ConfigurationManager::m_singelton.lock();
#endif

    if(NULL == m_pConfigurationManager)
    {
        m_pConfigurationManager = new ConfigurationManager();
    }

    if(m_pConfigurationManager == NULL)
    {
        ETG_TRACE_ERRMEM(("[ERROR]ConfigurationManager::GetInstance() NULL == m_pConfigurationManager"));
    }
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
    ConfigurationManager::m_singelton.unlock();
#endif

    //ETG_TRACE_USR4(("End  : GetInstance"));
    return m_pConfigurationManager;
}

void  ConfigurationManager::DestroyInstance()
{
    //@tbd.:
}


void  ConfigurationManager::vAdjustValuesForGM(tenDevManagerConfigValue eTypeOfConfigValue)
{
    /* these values are special for GM this is taken into account now
        eCONF_USB_1_HUB_ENABLE                         = 0x00,
        eCONF_USB_2_HUB_ENABLE                         = 0x01,
        eCONF_USB_1_HUB_MAX_PORTS                      = 0x02,
        eCONF_USB_2_HUB_MAX_PORTS                      = 0x03,
        eCONF_SYSTEM_OFFERING_BYTE1                    = 0x04,  //this is used also to store l_Byte19_Bit6And7 of VAGMIBE project
        eCONF_SYSTEM_OFFERING_BYTE1Bit3_USB2HubPresent = 0x05,
        eCONF_SYSTEM_OFFERING_BYTE1Bit4_USB1HubPresent = 0x06,
        eCONF_SYSTEM_OFFERING_BYTE1Bit5_SDPresent      = 0x07,
        eCONF_SYSTEM_OFFERING_BYTE1Bit6_USB2Present    = 0x08,
        eCONF_SYSTEM_OFFERING_BYTE1Bit7_USB1Present    = 0x09,
        eCONF_ENABLE_MTP_DEVICES                       = 0x0A,
        eCONF_USB_VOLTAGE_RECOVERY_AUTOPLAY_DELAY_TIME = 0x0B,
        eCONF_MARKETING_REGION                         = 0x0C,
        eCONF_USB_UNUSED_BITS                          = 0x0D,
*/

    switch(eTypeOfConfigValue)
    {
    //---------------------------------
    case eCONF_ENABLE_HUBandPORTSatUSB1:
        //---------------------------------
        if(m_u16ConfigurationValue[eCONF_ENABLE_HUBandPORTSatUSB1] >0)
        {
            m_u16ConfigurationValue[eCONF_USB_1_HUB_ENABLE]    = DVM_ON;
        }
        else
        {
            m_u16ConfigurationValue[eCONF_USB_1_HUB_ENABLE]                         = DVM_OFF;
            m_u16ConfigurationValue[eCONF_SYSTEM_OFFERING_BYTE1Bit4_USB1HubPresent] = DVM_OFF;
        }
        m_u16ConfigurationValue[eCONF_USB_1_HUB_MAX_PORTS] =  m_u16ConfigurationValue[eCONF_ENABLE_HUBandPORTSatUSB1];
        break;
        //---------------------------------
    case eCONF_ENABLE_HUBandPORTSatUSB2:
        //---------------------------------
        if(m_u16ConfigurationValue[eCONF_ENABLE_HUBandPORTSatUSB2] >0)
        {
            m_u16ConfigurationValue[eCONF_SYSTEM_OFFERING_BYTE1Bit6_USB2Present] = m_u16ConfigurationValue[eCONF_ENABLE_observeDTC_HUBatUSB2];
            m_u16ConfigurationValue[eCONF_USB_2_HUB_ENABLE]    = DVM_ON;
        }
        else
        {
            m_u16ConfigurationValue[eCONF_USB_2_HUB_ENABLE]                         = DVM_OFF;
            m_u16ConfigurationValue[eCONF_SYSTEM_OFFERING_BYTE1Bit6_USB2Present]     = DVM_OFF;
        }
        m_u16ConfigurationValue[eCONF_USB_2_HUB_MAX_PORTS] =  m_u16ConfigurationValue[eCONF_ENABLE_HUBandPORTSatUSB2];
        break;
    default:
        break;

    }
}
/*-----------------------------------------------------------------------------*
 * void  ConfigurationManager::vSetConfigurationValue(...)
 *-----------------------------------------------------------------------------*/
tVoid ConfigurationManager::vSetConfigurationValue(tenDevManagerConfigValue eTypeOfConfigValue,tU16 u16Value)
{
    //ETG_TRACE_USR4(("Begin: setConfigurationValue"));
    //m_lockSetting.lock();
    //ETG_TRACE_COMP(("[ok] setConfigurationValue value=%d [%d]",u16Value,ETG_CENUM(tenDevManagerConfigValue,eTypeOfConfigValue)));

    if( (eTypeOfConfigValue == eCONF_SYSTEM_OFFERING_BYTE1) || (eTypeOfConfigValue == eCONF_USB_UNUSED_BITS))
    {
        //ETG_TRACE_FATAL(("vSetConfigurationValue: WRONG VAL of eTypeOfConfigValue %d",eTypeOfEOL));
    }
    else
    {
        m_u16ConfigurationValue[eTypeOfConfigValue] = u16Value;

        vAdjustValuesForGM(eTypeOfConfigValue);
    }


    //m_lockSetting.unlock();
    //ETG_TRACE_USR4(("End  : setConfigurationValue"));
}

/*-----------------------------------------------------------------------------*
 * tU16 ConfigurationManager::u16GetConfigurationValue((...)
 *-----------------------------------------------------------------------------*/
tU16 ConfigurationManager::u16GetConfigurationValue(tenDevManagerConfigValue eTypeOfConfigValue) const
{
    tU16 u16RetVal = 0;
    //ETG_TRACE_USR4(("Begin: getConfigurationValue"));

    //m_lockSetting.lock();


    //-----------------gen3 version------------------

    if((eTypeOfConfigValue == eCONF_SYSTEM_OFFERING_BYTE1) || (eTypeOfConfigValue == eCONF_USB_UNUSED_BITS))  //placeholder for completion
    {
        ETG_TRACE_FATAL(("vSetConfigurationValue: WRONG VAL of eTypeOfConfigValue %d",eTypeOfConfigValue));
    }
    else
    {
        u16RetVal = m_u16ConfigurationValue[eTypeOfConfigValue];
    }

    //-----------------gen2 version------------------

    //ETG_TRACE_USR1(("%d = getConfigurationValue( %d )",u16RetVal,ETG_CENUM(tenDevManagerEOLValue,eTypeOfConfigValue)));
    //ETG_TRACE_USR4(("End  : getConfigurationValue"));

    //m_lockSetting.unlock();
    return u16RetVal;
}


tBool ConfigurationManager::bGetConfigurationValueDescription(IN tenDevManagerConfigValue eTypeOfConfigValue, OUT  trConfigValueDescription &rConfigValueDescription)
{
    tBool bRet = FALSE;
    if(bCheckConsistencyOfConfigValuesDescription())
    {
        rConfigValueDescription.enConfigValue                       = ConfigurationBase::m_rConfigValueDescription[eTypeOfConfigValue].enConfigValue;
        rConfigValueDescription.strConfigValue                      = ConfigurationBase::m_rConfigValueDescription[eTypeOfConfigValue].strConfigValue;
        rConfigValueDescription.strInternal                         = ConfigurationBase::m_rConfigValueDescription[eTypeOfConfigValue].strInternal;
        rConfigValueDescription.strRange                            = ConfigurationBase::m_rConfigValueDescription[eTypeOfConfigValue].strRange;
        rConfigValueDescription.strConfigurableProductionLine       = ConfigurationBase::m_rConfigValueDescription[eTypeOfConfigValue].strConfigurableProductionLine;
        rConfigValueDescription.strVarianSwitchToWhichItIsbound     = ConfigurationBase::m_rConfigValueDescription[eTypeOfConfigValue].strVarianSwitchToWhichItIsbound;
        rConfigValueDescription.strDescriptionOfValues              = ConfigurationBase::m_rConfigValueDescription[eTypeOfConfigValue].strDescriptionOfValues;

        printf("bGetConfigurationValueDescription: ConfigurationBase::m_rConfigValueDescription[%d].strConfigurableProductionLine:%s\n",
               (int)eTypeOfConfigValue,ConfigurationBase::m_rConfigValueDescription[eTypeOfConfigValue].strConfigurableProductionLine.c_str());
        bRet = TRUE;
    }

    return bRet;

}

/*-----------------------------------------------------------------------------*
 * tVoid vPrintConfiguration()                                                     *
 *-----------------------------------------------------------------------------*/
tVoid ConfigurationManager::vPrintConfiguration(FILE *poDumpFile,tBool bTest) const
{
    tInt i;

    if(bTest == FALSE)
    {
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_GMMY16
        ETG_TRACE_COMP(("[ok] ********************** vPrintConfiguration() GM specific*********************************" ));
        ETG_TRACE_COMP(("[ok] --- CONFIG of MTP devices is                      %d                     ",m_u16ConfigurationValue[eCONF_ENABLE_MTP_DEVICES]));
        ETG_TRACE_COMP(("[ok] --- CONFIG of USB_1_HUB is                        %d                     ",m_u16ConfigurationValue[eCONF_USB_1_HUB_ENABLE]));
        ETG_TRACE_COMP(("[ok] --- CONFIG of USB_2_HUB is                        %d                     ",m_u16ConfigurationValue[eCONF_USB_2_HUB_ENABLE]));
        ETG_TRACE_COMP(("[ok] --- CONFIG of INFO_USB_1_HUB_MAX_PORTS is         %d                     ",m_u16ConfigurationValue[eCONF_USB_1_HUB_MAX_PORTS]));
        ETG_TRACE_COMP(("[ok] --- CONFIG of INFO_USB_2_HUB_MAX_PORTS is         %d                     ",m_u16ConfigurationValue[eCONF_USB_2_HUB_MAX_PORTS]));
        ETG_TRACE_COMP(("[ok] --- CONFIG of SYSTEM_OFFERING_BYTE1_BIT3          %d  [HUB2 present]     ",m_u16ConfigurationValue[eCONF_SYSTEM_OFFERING_BYTE1Bit3_USB2HubPresent]));
        ETG_TRACE_COMP(("[ok] --- CONFIG of SYSTEM_OFFERING_BYTE1_BIT4          %d  [HUB1 present]     ",m_u16ConfigurationValue[eCONF_SYSTEM_OFFERING_BYTE1Bit4_USB1HubPresent]));
        ETG_TRACE_COMP(("[ok] --- CONFIG of SYSTEM_OFFERING_BYTE1_BIT5          %d  [SD   present]     ",m_u16ConfigurationValue[eCONF_SYSTEM_OFFERING_BYTE1Bit5_SDPresent]));
        ETG_TRACE_COMP(("[ok] --- CONFIG of SYSTEM_OFFERING_BYTE1_BIT6          %d  [USB2 present]     ",m_u16ConfigurationValue[eCONF_SYSTEM_OFFERING_BYTE1Bit6_USB2Present]));
        ETG_TRACE_COMP(("[ok] --- CONFIG of SYSTEM_OFFERING_BYTE1_BIT7          %d  [USB1 present]     ",m_u16ConfigurationValue[eCONF_SYSTEM_OFFERING_BYTE1Bit7_USB1Present]));
        ETG_TRACE_COMP(("[ok] --- CONFIG of UsbVoltageRecoveryAutoPlayDelayTime %d                     ",m_u16ConfigurationValue[eCONF_USB_VOLTAGE_RECOVERY_AUTOPLAY_DELAY_TIME]));
        ETG_TRACE_COMP(("[ok] --- CONFIG of INFO_OFFSET_MARKETING_REGION        %d                     ",
                        ETG_ENUM(TEN_DEV_MANAGER_EOL_REGION,m_u16ConfigurationValue[eCONF_MARKETING_REGION])));
#endif //VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_GMMY16
        //-----------generic solution gen3--------------
        ETG_TRACE_COMP(("[ok] ********************** vPrintConfiguration()*********************************" ));
        for(i = 0; i<(tInt)eCONF_LAST_ELEMENT; i++ )
        {
            ETG_TRACE_COMP(("[ok] --- value: %d for %d                ",m_u16ConfigurationValue[i],
                            ETG_CENUM(tenDevManagerConfigValue,(tenDevManagerConfigValue)i) ));
        }
        ETG_TRACE_COMP(("[ok] ------------------------------------------------------------------------------" ));
        for(i=(tInt)eUSB1;i<ARRAYSIZEFORUSB;i++)
        {
            ETG_TRACE_COMP(("m_rCustomerUSBConnectorConfig[eUSB%d].eConnectorInfo : %d  (eConnectorRealisedIntHub: %d,eConnectorRealisedDirect: %d)",
                i,(int)m_rCustomerUSBConnectorConfig[i].eConnectorInfo,(int)eConnectorRealisedIntHub, (int)eConnectorRealisedDirect))
            ETG_TRACE_COMP(("m_rCustomerUSBConnectorConfig[eUSB%d].m_strSysPathEntryUSBPortAdressForUSBConnector = %s",i,m_rCustomerUSBConnectorConfig[i].m_strSysPathEntryUSBPortAdressForUSBConnector))
            ETG_TRACE_COMP(("m_rCustomerUSBConnectorConfig[eUSB%d].m_strSysPathEntryUSBPortHubForUSBConnector    = %s",i,m_rCustomerUSBConnectorConfig[i].m_strSysPathEntryUSBPortHubForUSBConnector))
        }
        ETG_TRACE_COMP(("************************** vPrintConfiguration()\\*********************************" ));
    }
    else
    {
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_GMMY16
        //FATAL trace to show it always. this is ok since function is called for test using TTFIS cmd
        ETG_TRACE_FATAL(("[ok] ********************** vPrintConfiguration() GM specific*********************************" ));
        ETG_TRACE_FATAL(("[ok] --- CONFIG of MTP devices is                      %d                     ",m_u16ConfigurationValue[eCONF_ENABLE_MTP_DEVICES]));
        ETG_TRACE_FATAL(("[ok] --- CONFIG of USB_1_HUB is                        %d                     ",m_u16ConfigurationValue[eCONF_USB_1_HUB_ENABLE]));
        ETG_TRACE_FATAL(("[ok] --- CONFIG of USB_2_HUB is                        %d                     ",m_u16ConfigurationValue[eCONF_USB_2_HUB_ENABLE]));
        ETG_TRACE_FATAL(("[ok] --- CONFIG of INFO_USB_1_HUB_MAX_PORTS is         %d                     ",m_u16ConfigurationValue[eCONF_USB_1_HUB_MAX_PORTS]));
        ETG_TRACE_FATAL(("[ok] --- CONFIG of INFO_USB_2_HUB_MAX_PORTS is         %d                     ",m_u16ConfigurationValue[eCONF_USB_2_HUB_MAX_PORTS]));
        ETG_TRACE_FATAL(("[ok] --- CONFIG of SYSTEM_OFFERING_BYTE1_BIT3          %d  [HUB2 present]     ",m_u16ConfigurationValue[eCONF_SYSTEM_OFFERING_BYTE1Bit3_USB2HubPresent]));
        ETG_TRACE_FATAL(("[ok] --- CONFIG of SYSTEM_OFFERING_BYTE1_BIT4          %d  [HUB1 present]     ",m_u16ConfigurationValue[eCONF_SYSTEM_OFFERING_BYTE1Bit4_USB1HubPresent]));
        ETG_TRACE_FATAL(("[ok] --- CONFIG of SYSTEM_OFFERING_BYTE1_BIT5          %d  [SD   present]     ",m_u16ConfigurationValue[eCONF_SYSTEM_OFFERING_BYTE1Bit5_SDPresent]));
        ETG_TRACE_FATAL(("[ok] --- CONFIG of SYSTEM_OFFERING_BYTE1_BIT6          %d  [USB2 present]     ",m_u16ConfigurationValue[eCONF_SYSTEM_OFFERING_BYTE1Bit6_USB2Present]));
        ETG_TRACE_FATAL(("[ok] --- CONFIG of SYSTEM_OFFERING_BYTE1_BIT7          %d  [USB1 present]     ",m_u16ConfigurationValue[eCONF_SYSTEM_OFFERING_BYTE1Bit7_USB1Present]));
        ETG_TRACE_FATAL(("[ok] --- CONFIG of UsbVoltageRecoveryAutoPlayDelayTime %d                     ",m_u16ConfigurationValue[eCONF_USB_VOLTAGE_RECOVERY_AUTOPLAY_DELAY_TIME]));
        ETG_TRACE_FATAL(("[ok] --- CONFIG of INFO_OFFSET_MARKETING_REGION        %d                     ",
                         ETG_ENUM(TEN_DEV_MANAGER_EOL_REGION,m_u16ConfigurationValue[eCONF_MARKETING_REGION])));
#endif //VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_GMMY16
        //-----------generic solution gen3--------------
        ETG_TRACE_FATAL(("[ok] ********************** vPrintConfiguration()*********************************" ));
        for(i = 0; i<(tInt)eCONF_LAST_ELEMENT; i++ )
        {
            ETG_TRACE_FATAL(("[ok] --- value: %d for %d                ",m_u16ConfigurationValue[i],
                             ETG_CENUM(tenDevManagerConfigValue,(tenDevManagerConfigValue)i) ));
        }
        ETG_TRACE_FATAL(("[ok] ------------------------------------------------------------------------------" ));
        for(i=(tInt)eUSB1;i<ARRAYSIZEFORUSB;i++)
        {
            ETG_TRACE_FATAL(("m_rCustomerUSBConnectorConfig[eUSB%d].eConnectorInfo : %d  (eConnectorRealisedIntHub: %d,eConnectorRealisedDirect: %d)",
                i,(int)m_rCustomerUSBConnectorConfig[i].eConnectorInfo,(int)eConnectorRealisedIntHub, (int)eConnectorRealisedDirect))
            ETG_TRACE_FATAL(("m_rCustomerUSBConnectorConfig[eUSB%d].m_strSysPathEntryUSBPortAdressForUSBConnector = %s",i,m_rCustomerUSBConnectorConfig[i].m_strSysPathEntryUSBPortAdressForUSBConnector))
            ETG_TRACE_FATAL(("m_rCustomerUSBConnectorConfig[eUSB%d].m_strSysPathEntryUSBPortHubForUSBConnector    = %s",i,m_rCustomerUSBConnectorConfig[i].m_strSysPathEntryUSBPortHubForUSBConnector))
        }
        ETG_TRACE_FATAL(("************************** vPrintConfiguration()\\*********************************" ));

        if (NULL != poDumpFile)
        {
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_GMMY16
            //FATAL trace to show it always. this is ok since function is called for test using TTFIS cmd
            fprintf (poDumpFile, "[ok] ********************** vPrintConfiguration GM specific()*********************************" );

            fprintf (poDumpFile, "[ok] --- CONFIG of MTP devices is                      %d                     \n",m_u16ConfigurationValue[eCONF_ENABLE_MTP_DEVICES]);
            fprintf (poDumpFile, "[ok] --- CONFIG of USB_1_HUB is                        %d                     \n",m_u16ConfigurationValue[eCONF_USB_1_HUB_ENABLE]);
            fprintf (poDumpFile, "[ok] --- CONFIG of USB_2_HUB is                        %d                     \n",m_u16ConfigurationValue[eCONF_USB_2_HUB_ENABLE]);
            fprintf (poDumpFile, "[ok] --- CONFIG of INFO_USB_1_HUB_MAX_PORTS is         %d                     \n",m_u16ConfigurationValue[eCONF_USB_1_HUB_MAX_PORTS]);
            fprintf (poDumpFile, "[ok] --- CONFIG of INFO_USB_2_HUB_MAX_PORTS is         %d                     \n",m_u16ConfigurationValue[eCONF_USB_2_HUB_MAX_PORTS]);
            fprintf (poDumpFile, "[ok] --- CONFIG of SYSTEM_OFFERING_BYTE1_BIT3          %d  [HUB2 present]     \n",m_u16ConfigurationValue[eCONF_SYSTEM_OFFERING_BYTE1Bit3_USB2HubPresent]);
            fprintf (poDumpFile, "[ok] --- CONFIG of SYSTEM_OFFERING_BYTE1_BIT4          %d  [HUB1 present]     \n",m_u16ConfigurationValue[eCONF_SYSTEM_OFFERING_BYTE1Bit4_USB1HubPresent]);
            fprintf (poDumpFile, "[ok] --- CONFIG of SYSTEM_OFFERING_BYTE1_BIT5          %d  [SD   present]     \n",m_u16ConfigurationValue[eCONF_SYSTEM_OFFERING_BYTE1Bit5_SDPresent]);
            fprintf (poDumpFile, "[ok] --- CONFIG of SYSTEM_OFFERING_BYTE1_BIT6          %d  [USB2 present]     \n",m_u16ConfigurationValue[eCONF_SYSTEM_OFFERING_BYTE1Bit6_USB2Present]);
            fprintf (poDumpFile, "[ok] --- CONFIG of SYSTEM_OFFERING_BYTE1_BIT7          %d  [USB1 present]     \n",m_u16ConfigurationValue[eCONF_SYSTEM_OFFERING_BYTE1Bit7_USB1Present]);
            fprintf (poDumpFile, "[ok] --- CONFIG of UsbVoltageRecoveryAutoPlayDelayTime %d                     \n",m_u16ConfigurationValue[eCONF_USB_VOLTAGE_RECOVERY_AUTOPLAY_DELAY_TIME]);
            fprintf (poDumpFile, "[ok] --- CONFIG of INFO_OFFSET_MARKETING_REGION        %d                     \n",m_u16ConfigurationValue[eCONF_MARKETING_REGION]);
#endif //VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_GMMY16
            //-----------generic solution gen3--------------
            fprintf (poDumpFile, "[ok] ********************** vPrintConfiguration()*********************************" );
            for(i = 0; i<(tInt)eCONF_LAST_ELEMENT; i++ )
            {
                fprintf (poDumpFile, "[ok] --- CONFIG of %d                                     %d                     \n", i,m_u16ConfigurationValue[i]);
            }

            fprintf (poDumpFile, "[ok] ------------------------------------------------------------------------------\n");
            for(i=(tInt)eUSB1;i<ARRAYSIZEFORUSB;i++)
            {
                 fprintf (poDumpFile, "m_rCustomerUSBConnectorConfig[eUSB%d].eConnectorInfo : %d  (eConnectorRealisedIntHub: %d,eConnectorRealisedDirect: %d)\n",
                    i,(int)m_rCustomerUSBConnectorConfig[i].eConnectorInfo,(int)eConnectorRealisedIntHub, (int)eConnectorRealisedDirect);
                 fprintf (poDumpFile, "m_rCustomerUSBConnectorConfig[eUSB%d].m_strSysPathEntryUSBPortAdressForUSBConnector = %s\n",i,m_rCustomerUSBConnectorConfig[i].m_strSysPathEntryUSBPortAdressForUSBConnector.c_str());
                 fprintf (poDumpFile, "m_rCustomerUSBConnectorConfig[eUSB%d].m_strSysPathEntryUSBPortHubForUSBConnector    = %s\n",i,m_rCustomerUSBConnectorConfig[i].m_strSysPathEntryUSBPortHubForUSBConnector.c_str());
            }
        }
    }
}


/*-----------------------------------------------------------------------------*
 * tBool ConfigurationManager::bCheckHWSpecificBlockDevName(...)
 *-----------------------------------------------------------------------------*/
tBool ConfigurationManager::bCheckHWSpecificBlockDevName(CGlobalEnumerations::DEVICE_TYPE_Type eDeviceType, std::string strBlockDeviceName) const
{
    tBool bRetVal = FALSE;

    int iRes = -1; /*0:equal*/

    //ETG_TRACE_USR4(("Begin: checkHWSpecificBlockDevName"));

    size_t len, lenSubstr;
    std::string strSubBlockDeviceName;

    //ETG_TRACE_USR4(("bCheckHWSpecificBlockDevName:CGlobalEnumerations::eDeviceType: %d",ETG_CENUM(CGlobalEnumerations::DEVICE_TYPE_Type,eDeviceType)));
    //ETG_TRACE_USR4(("bCheckHWSpecificBlockDevName:strBlockDeviceName              :%s",strBlockDeviceName));

    if(CGlobalEnumerations::DTY_SD_INTERNAL == eDeviceType)
    {
        len = m_strBlockDevNameSDCardInternal.length();              // "/dev/mmcblk0" len=12
        strSubBlockDeviceName = strBlockDeviceName.substr(0,len);    //  strBlockDeviceName="/dev/mmcblk0p1" -strSubBlockDeviceName = "/dev/mmcblk0p"
        lenSubstr = strSubBlockDeviceName.length();

        if(lenSubstr == len)
        {
            iRes = m_strBlockDevNameSDCardInternal.compare(strSubBlockDeviceName);   // e.g.l_strBlockDevNameSDCardInternal = "/dev/mmcblk0"  strSubBlockDeviceName = "/dev/mmcblk0"  are the same
        }

    }
    else if(CGlobalEnumerations::DTY_CDROM  == eDeviceType)
    {
        iRes = strBlockDeviceName.compare(0, m_strBlockDevNameCDROMInternalPart.size(),m_strBlockDevNameCDROMInternalPart); //strBlockDeviceName="/dev/sr[0..9]"  and m_strBlockdevNameCDROMInternal= "/dev/sr are same"
    }
    else if(CGlobalEnumerations::DTY_DVD_DRIVE  == eDeviceType)
    {
        iRes = strBlockDeviceName.compare(0, m_strBlockDevNameDVDInternalUSBConnectedPart.size(),m_strBlockDevNameDVDInternalUSBConnectedPart); //strBlockDeviceName="/dev/sr0"  are the same m_strBlockDevNameDVDInternalUSBConnected= "/dev/sr0"
    }
    else
    {
        //ETG_TRACE_FATAL(("checkHWSpecificBlockDevName: Not Expected input for this function eDeviceType %d", ETG_CENUM(CGlobalEnumerations::DEVICE_TYPE_Typ,eDeviceType)));
    }

    //ETG_TRACE_USR4(("End  : checkHWSpecificBlockDevName"));

    if(0 == iRes)
    {
        bRetVal = TRUE;
    }

    return bRetVal;

}




/*-----------------------------------------------------------------------------*
 * tVoid ConfigurationManager::vGetSpecificBlockDevName(...)
 *-----------------------------------------------------------------------------*/
tVoid ConfigurationManager::vGetSpecificBlockDevName(IN CGlobalEnumerations::DEVICE_TYPE_Type enDevType, OUT std::string &strDeviceName) const
{
    ETG_TRACE_USR4(("Begin:  vGetSpecificBlockDevName"));

    if(CGlobalEnumerations::DTY_CDROM == enDevType)
    {
        strDeviceName = m_strBlockDevNameCDROMInternalPart;
    }
    else if(CGlobalEnumerations::DTY_SD_INTERNAL == enDevType)
    {
        strDeviceName = m_strBlockDevNameSDCardInternal;
    }
    else if(CGlobalEnumerations::DTY_DVD_DRIVE == enDevType)
    {
        strDeviceName = m_strBlockDevNameDVDInternalUSBConnectedPart;
    }
    else
    {
        ETG_TRACE_FATAL(("vGetSpecificBlockDevName: unknown device type: %d",enDevType));
    }
    ETG_TRACE_USR1(("End  :vGetSpecificBlockDevName: IN enDevType:%d , OUT strDeviceName: %s",ETG_CENUM(CGlobalEnumerations::DEVICE_TYPE_Type, enDevType), strDeviceName.c_str()));
}


/*-----------------------------------------------------------------------------*
 * int ConfigurationManager::FilterWithConfiguration(CDevice* f_pCurDevice)                            *
 *-----------------------------------------------------------------------------*/
int ConfigurationManager::FilterWithConfiguration(INOUT CDevice *f_pCurDevice) const
{
    ETG_TRACE_USR4(("Begin:FilterWithConfiguration"));

    int   l_iUsbNumber                                          = f_pCurDevice->m_iUSBConnector;
    int   l_iHubIndex                                           = f_pCurDevice->m_iHubIndex;
    int   l_iVendorID                                           = f_pCurDevice->m_iVendorID;
    int   l_iProductID                                          = f_pCurDevice->m_iProductID;
    tBool l_bConnectedAtHub                                     = f_pCurDevice->m_bConnectedAtHub;
    CGlobalEnumerations::DEVICE_TYPE_Type     l_eDeviceType     = f_pCurDevice->m_eDeviceType;
    CGlobalEnumerations::FILESYSTEM_TYPE_Type l_eFileSystemType = f_pCurDevice->m_eFSType;
    GENSTRING f_cSysName                                        = f_pCurDevice->m_cSysName;
    tBool l_bClearSerialIDUnSupportedDevices                    = TRUE;

    tenResultFilter l_enResultFilter;
    int             l_iDevUsable  = DEVICE_NOK;
    int             l_arrUSBPortsUsed[ARRAYSIZEFORUSB];

    vPrintConfiguration(NULL /*don't dump to file*/,FALSE /*show it with TR_LEVEL_COMP */);

    ETG_TRACE_COMP(("=====================/FilterWithConfiguration======================="));
    ETG_TRACE_USR1(("FilterWithConfiguration: l_iUsbNumber = %d",l_iUsbNumber));

#if defined(BUGFIX_DECOUPLE_SDCARD_PRM) || defined(BUGFIX_DECOUPLE_CDROM_PRM)
    if( (f_pCurDevice->m_eDeviceType == CGlobalEnumerations::DTY_SD_INTERNAL) ||
            (f_pCurDevice->m_eDeviceType == CGlobalEnumerations::DTY_CDROM/*_INTERNAL*/) ||
            (f_pCurDevice->m_eDeviceType == CGlobalEnumerations::DTY_DVD_DRIVE/*_INTERNAL DVD DRIVE*/) ||
            ((f_pCurDevice->m_eDeviceType == CGlobalEnumerations::DTY_USB && 1 != f_pCurDevice->m_iIsMounted/*USB device not mounted*/))
      )
    {
        l_iDevUsable = DEVICE_OK; //not bound to USBConnectors thus undef or 0 is allowed for those numbers
    }
    else
#endif
    {
        vCountDevicesAtUSBConnectors(OUT l_arrUSBPortsUsed);
        //---------------------------------------------------------------------------------------------------------
        //vFilterForConnectorsAndHubs   //@tod split to two and use
        //---------------------------------------------------------------------------------------------------------
        vFilterForConnectorsAndHubs(INOUT l_iDevUsable, IN l_arrUSBPortsUsed, IN l_iUsbNumber, IN l_iHubIndex, IN l_bConnectedAtHub,IN f_cSysName,IN l_eDeviceType);

        ETG_TRACE_COMP(("FilterWithConfiguration:l_iDevUsable 0x%x",l_iDevUsable));



    }
    ETG_TRACE_COMP(("FilterWithConfiguration:l_iDevUsable 0x%x",l_iDevUsable));
    //---------------------------------------------------------------------------------------------------------
    //vFilterForDeviceType
    //---------------------------------------------------------------------------------------------------------
    if(  (DEVICE_OK == l_iDevUsable)
         &&(f_pCurDevice->m_eDeviceType != CGlobalEnumerations::DTY_NOT_SUPPORTED))  //if platform has notified it unsupported already
    {
        vFilterForDeviceType(OUT l_enResultFilter, IN l_eDeviceType,IN l_iUsbNumber);
        switch(l_enResultFilter)  //@todo check to shift to its own subfunction
        {
        case enUnknown:
        case enDisabled:
            l_iDevUsable = DEVICE_NOK;  //means won't be notified

            if(DVM_ON == u16GetConfigurationValue(eCONF_ENABLE_NOTIFY_UNSUPPORTED_DEVTYPE))
            {
                l_iDevUsable = DEVICE_OK; //will be notified
                f_pCurDevice->m_eDeviceType = CGlobalEnumerations::DTY_NOT_SUPPORTED;
                ETG_TRACE_FATAL(("FilterWithConfiguration: Set to DTY_NOT_SUPPORTED and DEVICE_NOK to FORCE NOTIFICATION"));
            }
            break;
        case enEnabled:
            l_iDevUsable = DEVICE_OK; //means will be notified if following filters would not create a nok
            break;
        default:
            DVM_NORMAL_M_ASSERT_ALWAYS();
            break;
        }
    }
    ETG_TRACE_COMP(("FilterWithConfiguration:l_iDevUsable 0x%x",l_iDevUsable));
    //---------------------------------------------------------------------------------------------------------
    //vFilterForFilsystemType
    //---------------------------------------------------------------------------------------------------------
    if(     (l_iDevUsable == DEVICE_OK)
            &&  (f_pCurDevice->m_eDeviceType != CGlobalEnumerations::DTY_NOT_SUPPORTED)
            &&  (TRUE == bIsMassStorageDevice(f_pCurDevice->m_eDeviceType))
            )
    {

        vFilterForFilsystemType(OUT l_enResultFilter,IN l_eFileSystemType);
        switch(l_enResultFilter)
        {
        case enUnknown:
        case enDisabled:
            l_iDevUsable = DEVICE_NOK; //means won't be notified
            if(DVM_ON == u16GetConfigurationValue(eCONF_ENABLE_NOTIFY_UNSUPPORTED_FILESYSTEM))
            {
                l_bClearSerialIDUnSupportedDevices = FALSE;
                l_iDevUsable = DEVICE_OK; //will be notified
                f_pCurDevice->m_eDeviceType = CGlobalEnumerations::DTY_NOT_SUPPORTED;   //@todo think about announcing Fylesystem usupported - but since configuration for filesystem is supported in Mediaplayer I don't care here
                ETG_TRACE_FATAL(("FilterWithConfiguration: Set to DTY_NOT_SUPPORTED and DEVICE_NOK to FORCE NOTIFICATION"));
            }
            break;
        case enEnabled:
            l_iDevUsable = DEVICE_OK;//means will be notified if following filters would not create a no
            break;
        default:
            DVM_NORMAL_M_ASSERT_ALWAYS();
            break;
        }

    }
    ETG_TRACE_COMP(("FilterWithConfiguration:f_iDevUsable 0x%x",l_iDevUsable));


    //---------------------------------------------------------------------------------------------------------
    //vFilterForMassStorageDeviceSize
    //---------------------------------------------------------------------------------------------------------
    if(     (l_iDevUsable == DEVICE_OK)
            &&  (f_pCurDevice->m_eDeviceType != CGlobalEnumerations::DTY_NOT_SUPPORTED)
            &&  (TRUE == bIsMassStorageDevice(f_pCurDevice->m_eDeviceType))
            )
    {
        tU16 l_u16TotalSizeGB = (tU16) ( f_pCurDevice->m_u64TotalSize_KB/(1024*1024));

        vFilterForMassStorageDeviceSize(OUT l_enResultFilter, IN f_pCurDevice->m_eDeviceType ,IN l_u16TotalSizeGB);
        switch(l_enResultFilter)
        {

        case enDisabled:
            l_iDevUsable = DEVICE_NOK; //means won't be notified
            if(DVM_ON == u16GetConfigurationValue(eCONF_ENABLE_NOTIFY_UNSUPPORTED_DEVTYPE))
            {
                l_iDevUsable = DEVICE_OK; //will be notified
                f_pCurDevice->m_eDeviceType = CGlobalEnumerations::DTY_NOT_SUPPORTED;   //@todo think about announcing Fylesystem usupported - but since configuration for filesystem is supported in Mediaplayer I don't care here
                ETG_TRACE_FATAL(("FilterWithConfiguration: Set to DTY_NOT_SUPPORTED and DEVICE_NOK to FORCE NOTIFICATION"));
            }
            break;
        case enUnknown: //not Mass storage
        case enEnabled: //size lower than limit
            l_iDevUsable = DEVICE_OK;//means will be notified if following filters would not create a no
            break;
        default:
            DVM_NORMAL_M_ASSERT_ALWAYS();
            break;
        }
    }

    if(     (CGlobalEnumerations::DTY_NOT_SUPPORTED == f_pCurDevice->m_eDeviceType)
            &&  ((GENSTRING("MISCELLANEOUS") == f_pCurDevice->m_cMountPoint)
            ||  (OK != f_pCurDevice->m_eDeviceUnsupportedReason))
            )
    {
        l_bClearSerialIDUnSupportedDevices = FALSE;
        ETG_TRACE_FATAL(("FilterWithConfiguration: Set l_bClearSerialIDUnSupportedDevices to False.. Clearing of SerialID not done"));
    }

    ETG_TRACE_COMP(("FilterWithConfiguration:f_iDevUsable 0x%x",l_iDevUsable));
    //---------------------------------------------------------------------------------------------------------
    //vFilterForDeviceAppleUnsupported
    //---------------------------------------------------------------------------------------------------------
    if(     (l_iDevUsable == DEVICE_OK)
            &&  (f_pCurDevice->m_eDeviceType != CGlobalEnumerations::DTY_NOT_SUPPORTED)
            )
    {
        vFilterForDeviceAppleUnsupported(OUT l_enResultFilter, IN l_iVendorID,IN l_iProductID);
        switch(l_enResultFilter)
        {
        case enUnknown:
        case enDisabled:
            l_iDevUsable = DEVICE_NOK; //means won't be notified
            if(u16GetConfigurationValue(eCONF_ENABLE_NOTIFY_UNSUPPORTED_DEVTYPE))
            {
                f_pCurDevice->m_eDeviceType = CGlobalEnumerations::DTY_NOT_SUPPORTED;
                l_iDevUsable = DEVICE_OK; //will be notified
                ETG_TRACE_FATAL(("FilterWithConfiguration: Set to DTY_NOT_SUPPORTED and DEVICE_NOK to FORCE NOTIFICATION"));
            }
            break;
        case enEnabled:
            l_iDevUsable = DEVICE_OK; //will be notified
            break;
        default:
            DVM_NORMAL_M_ASSERT_ALWAYS();
            break;
        }
    }


    //---------------------------------------------------------------------------------------------------------
    //if device has been set Unsupported before clear  serial number
    //---------------------------------------------------------------------------------------------------------
    if((l_iDevUsable == DEVICE_OK)
            &&  (CGlobalEnumerations::DTY_NOT_SUPPORTED == f_pCurDevice->m_eDeviceType)
            && (TRUE == l_bClearSerialIDUnSupportedDevices)
            )
    {
        ETG_TRACE_USR2(("FilterWithConfiguration:f_pCurDevice->m_eDeviceType=DTY_NOT_SUPPORTED : clear existing serial number of device"));
                f_pCurDevice->m_cSerialID = "";
    }

    ETG_TRACE_USR1(("FilterWithConfiguration: l_DevUsable = 0x%x (DEVICE_OK:0x%x,DEVICE_NOK:0x%x)", l_iDevUsable,DEVICE_OK,DEVICE_NOK));

    ETG_TRACE_COMP(("=====================FilterWithConfiguration/======================="));

    return l_iDevUsable;
}

/*-----------------------------------------------------------------------------*
 * void  ConfigurationManager::vCountDevicesAtUSBConnectors(...)
 *-----------------------------------------------------------------------------*/
void ConfigurationManager::vCountDevicesAtUSBConnectors(OUT int (&f_arrUSBPortsUsed)[ARRAYSIZEFORUSB]) const
{
    ETG_TRACE_USR4(("Begin: vCountDevicesAtUSBConnectors"));

    CDevice oDevice;

    //--------------------------------------------------------------------------------------------------
    // //@todo think about shifting these to headerfile
    // Count number of currently connected devices on each USB Connector: e.g. if there are 3 VD_DVM 'thinks' 3 are connected
    //using a HUB because otherwhise only 1 would be possible
    //
    // in some projects CDROM-Internal (/dev/sr0) and SDCard-Internal (e.g. /dev/mmcblk0..)exists
    // these are hardlinked to eUSB1 to let it work. It woould be more clean to add additional ports for these
    // as a workaround we care below that these are not counter
    //
    ////@todo for projects which allow multiple partitions another check has to be added here
    //
    //-------------------------------------------------------------------------------------------------
    /*clear it*/
    for(tInt i=(tInt)eUSB1;i<ARRAYSIZEFORUSB;i++)
    {
        f_arrUSBPortsUsed[i]=0;
    }
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST   //@todo mock devlistmanager for utests then this define can be taken off
    tBool bExists;

    unsigned int uiSize = DeviceListManager::GetInstance()->getSizeOfList(DEVLIST_UDEVMGR);

    //store the accessory names of mass storage devices which are having more than partitions
    //the idea is to not to consider the device as different device if the device is having more than one partitions
    vector<GenString>  l_vAccessoryNames;
    vector<GenString>::const_iterator it;
    tBool bUpdatePortUsed = TRUE;

    for ( unsigned int l_uiCount=0; l_uiCount< uiSize ; l_uiCount++)
    {
        bExists= DeviceListManager::GetInstance()->getElement(IN DEVLIST_UDEVMGR,IN l_uiCount,OUT oDevice);
        DVM_NORMAL_M_ASSERT(TRUE == bExists);
        if(TRUE == bExists)
        {
            for(tInt i=(tInt)eUSB1;i<ARRAYSIZEFORUSB;i++)
            {
                if(i == oDevice.m_iUSBConnector)
                {
                    if(oDevice.m_iTotalValidPartitons>1)
                    {
                        for(it = l_vAccessoryNames.begin();it<l_vAccessoryNames.end();it++)
                        {
                            if(*it == oDevice.m_cAccessoryName)
                            {
                                ETG_TRACE_COMP(("Device with accessoryName : %s has multiple partitions, and the device is counted already."
                                                " So no need to consider it as a separate device",oDevice.m_cAccessoryName.toStdString().c_str()));
                                bUpdatePortUsed = FALSE;
                                break;
                            }

                        }
                        if(FALSE == bUpdatePortUsed)
                        {
                            //We have already search for the alias name m_vConnectedDevices_StateTable[i].cAccessoryName, so no need to search again
                            continue;
                        }
                        l_vAccessoryNames.push_back(oDevice.m_cAccessoryName);
                    }
                    if(   (oDevice.m_eDeviceType !=CGlobalEnumerations::DTY_CDROM)
                          && (oDevice.m_eDeviceType !=CGlobalEnumerations::DTY_SD_INTERNAL)
                          && (oDevice.m_eDeviceType !=CGlobalEnumerations::DTY_HUB)
                          && (oDevice.m_eDeviceType !=CGlobalEnumerations::DTY_DIGIAUX)
#if (defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_INF4CV) || defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_SMART))
                          && (false == isDeviceAssociatedWithHub(oDevice.m_iVendorID, oDevice.m_iProductID))
#endif
                          )
                    {
                        f_arrUSBPortsUsed[i]++;
                    }
                }
            }
        }
    }
#endif
    for(tInt i=(tInt)eUSB1;i<ARRAYSIZEFORUSB;i++)
    {
        ETG_TRACE_COMP(("vCountDevicesAtUSBConnectors:USB%1d ports used:%d",i,f_arrUSBPortsUsed[i]+1));
    }
    ETG_TRACE_USR4(("End  : vCountDevicesAtUSBConnectors"));
}

/*-----------------------------------------------------------------------------*
 * void ConfigurationManager:: vFilterForHubConnectedToHub(...)
 *-----------------------------------------------------------------------------*/
void ConfigurationManager::vFilterForHubConnectedToHub(INOUT int &f_iDevUsable, IN   GENSTRING f_cSysName) const
{

    int l_iPos   = -1;
    int l_iChar  = 0;   // stores location of usb level '.'
    int l_iCount = 0;   // counts the usb level
    f_iDevUsable = DEVICE_OK;

    ETG_TRACE_USR4(("Begin: vFilterForHubConnectedToHub : %s ",f_cSysName.toStdString().c_str()));
    //printf("Begin: vFilterForHubConnectedToHub %s\n",f_cSysName.toStdString().c_str());
    l_iPos = f_cSysName.indexOf(".");
    if(l_iPos > -1)
    {
        ETG_TRACE_USR4(("vFilterForHubConnectedToHub: Hub Present"));
        //puts("vFilterForHubConnectedToHub: Hub Present");
        if (-1 != f_cSysName.indexOf("-"))
        {
            f_cSysName.remove(0,2);
            while ((l_iChar = f_cSysName.indexOf(".", l_iChar)) != -1)
            {
                l_iChar++;
                l_iCount++;
            }
            ETG_TRACE_USR4(("vFilterForHubConnectedToHub Hub present at level :  %d",l_iCount));
            //printf("vFilterForHubConnectedToHub Hub present at level :  %d\n",l_iCount);
            if(l_iCount>=2)
            {
                ETG_TRACE_USR4(("vFilterForHubConnectedToHub device is connected to a Hub which is connected  another hub.Device DEVICE_NOK "));
                //puts("vFilterForHubConnectedToHub device is connected to a Hub which is connected  another hub.Device DEVICE_NOK ");
                f_iDevUsable = DEVICE_NOK;
            }

        }
        else
        {
            ETG_TRACE_FATAL(("vFilterForHubConnectedToHub: Unexpected f_cSysName : %s", f_cSysName.toStdString().c_str()))
                    //printf("vFilterForHubConnectedToHub: Unexpected f_cSysName : %s\n", f_cSysName.toStdString().c_str());
        }
    }


    ETG_TRACE_USR4(("End  : vFilterForHubConnectedToHub"));
    //puts("End  : vFilterForHubConnectedToHub");


}

void ConfigurationManager::vFilterForAppleDeviceWithoutCustomerHub(INOUT int &deviceUsable, IN const int &usbNumber, IN const CGlobalEnumerations::DEVICE_TYPE_Type &deviceType) const
{
    ETG_TRACE_USR4(("Begin: vFilterForAppleDeviceWithoutCustomerHub "));
    if((CGlobalEnumerations::DTY_IPHONE == deviceType || CGlobalEnumerations::DTY_IPAD == deviceType || CGlobalEnumerations::DTY_IPOD == deviceType))
    {
        //If hub support is enabled and apple device is not connected on a customer hub, then the device is not usable
        if(((u16GetConfigurationValue(m_eHUBAndPortsEnable[usbNumber]) >= DVM_ON) && (FALSE == ConfigurationManager::GetInstance()->bExpectedExternalHubIsConnected(tenDevManagerUSBHost(usbNumber)))))
        {
            deviceUsable = DEVICE_NOK_APPLE_DEVICE_CONNECTION_WITHOUT_CUSTOMERHUB;
            ETG_TRACE_COMP(("vFilterForAppleDeviceWithourCustomerHub: HUB at USB%1d enabled (m_eHUBEnable), but the apple device is not connected on customer hub",usbNumber));
        }
    }
    ETG_TRACE_USR4(("End: vFilterForAppleDeviceWithoutCustomerHub"));
}

/*-----------------------------------------------------------------------------*
 * void ConfigurationManager:: vFilterForConnectorsAndHubs(...)
 *-----------------------------------------------------------------------------*/
void ConfigurationManager::vFilterForConnectorsAndHubs(INOUT int &f_iDevUsable, IN const int (&f_arrUSBPortsUsed)[ARRAYSIZEFORUSB], IN int f_iUsbNumber, IN int f_iHubIndex, IN tBool f_bConnectedAtHub,IN  GENSTRING f_cSysName, IN CGlobalEnumerations::DEVICE_TYPE_Type deviceType) const
{
    ETG_TRACE_USR4(("Begin: vFilterForConnectorHubAndHubPorts"));

    //------------------------------------
    //array for each possible connector
    //------------------------------------
    for(tInt i=(tInt)eUSB1;i<ARRAYSIZEFORUSB;i++)
    {
        ETG_TRACE_COMP(("vFilterForConnectorHubAndHubPorts: f_iUsbNumber = %d",f_iUsbNumber));
        ETG_TRACE_COMP(("vFilterForConnectorHubAndHubPorts: USBi         = %d",i));

        if(i == f_iUsbNumber)
        {
            //-------------------------------------
            //is USB-i port allowed by callibration
            //-------------------------------------
            if(u16GetConfigurationValue(m_eUSBPresent[i])== DVM_ON)
            {
                f_iDevUsable = DEVICE_OK;
                ETG_TRACE_COMP(("vFilterForConnectorHubAndHubPorts: USB%1d connector enabled (m_eUSBPresent)",i));
            }
            else
            {
                f_iDevUsable = DEVICE_NOK;
                ETG_TRACE_COMP(("vFilterForConnectorHubAndHubPorts: USB%1d connector disabled (m_eUSBPresent)",i));
            }

            //--------------------------------------------------------------
            //is device connected via HUB and does callibration allow this?
            //--------------------------------------------------------------
            ETG_TRACE_COMP(("vFilterForConnectorHubAndHubPorts: f_iHubIndex       = %d",f_iHubIndex));
            ETG_TRACE_COMP(("vFilterForConnectorHubAndHubPorts: f_bConnectedAtHub = %d",f_bConnectedAtHub));
            if(    ((int)i    == f_iHubIndex)
                   && (TRUE      == f_bConnectedAtHub)
                   && (DEVICE_OK == f_iDevUsable))
            {
                if(u16GetConfigurationValue(m_eHUBAndPortsEnable[i]) >= DVM_ON)
                {
                    ETG_TRACE_COMP(("vFilterForConnectorHubAndHubPorts: EOL: HUB at USB%1d enabled (m_eHUBEnable)",i));
                    //l_DevUsable = DEVICE_OK;

                    //----------------------------------------------------
                    //is port num ok? - check if this is an
                    //----------------------------------------------------
                    ETG_TRACE_COMP(("vFilterForConnectorHubAndHubPorts:USB%1d used ports:%d",i,f_arrUSBPortsUsed[i]+1));
                    ETG_TRACE_COMP(("vFilterForConnectorHubAndHubPorts:USB%1d  max ports:%d",i,u16GetConfigurationValue( m_eHUBAndPortsEnable[i]) ));

                    /*+1 because function is called because another add has been reported*/
                    if( (f_arrUSBPortsUsed[i]+1) <= u16GetConfigurationValue(m_eHUBAndPortsEnable[i]) )
                    {
                        ETG_TRACE_COMP(("vFilterForConnectorHubAndHubPorts:USB%1d ports OK:",i));
                        f_iDevUsable = DEVICE_OK;
                    }
                    else
                    {
                        ETG_TRACE_COMP(("vFilterForConnectorHubAndHubPorts:USB%1d ports NOK:",i));
                        f_iDevUsable = DEVICE_NOK;
                    }
                    //Check for hub connected to hub here
                    if(DVM_OFF == u16GetConfigurationValue(m_eHUBconnectedToHUBAndPortsEnable[i]))
                    {
                        ETG_TRACE_COMP(("vFilterForConnectorHubAndHubPorts:USB%1d Checking the hub connected to hub",i));
                        vFilterForHubConnectedToHub(f_iDevUsable,f_cSysName);
                        if(DEVICE_OK != f_iDevUsable)
                        {
                            ETG_TRACE_COMP(("vFilterForConnectorHubAndHubPorts: The device is connected to a hub connected to hub, which is not allowed as per configuration"));
                        }
                    }
                    else if( (f_arrUSBPortsUsed[i]+1) <= u16GetConfigurationValue(m_eHUBconnectedToHUBAndPortsEnable[i]) )
                    {
                        ETG_TRACE_COMP(("vFilterForConnectorHubAndHubPorts:USB%1d ports OK:",i));
                        f_iDevUsable = DEVICE_OK;
                    }
                    else
                    {
                        ETG_TRACE_COMP(("vFilterForConnectorHubAndHubPorts:USB%1d ports NOK:",i));
                        f_iDevUsable = DEVICE_NOK;
                    }
                }
                else
                {
                    f_iDevUsable = DEVICE_NOK;
                    ETG_TRACE_COMP(("vFilterForConnectorHubAndHubPorts: EOL: HUB at USB%1d disabled (m_eHUBEnable)",i));
                }
            }

            if((DEVICE_OK == f_iDevUsable) && (DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_SUPPRESS_APPLE_DEVICE_WITHOUT_CUSTOMERHUB)))
            {
                vFilterForAppleDeviceWithoutCustomerHub(INOUT f_iDevUsable, IN f_iUsbNumber, IN deviceType);
            }
            break; //if found then don't continue to search
        }
    }
    ETG_TRACE_COMP(("vFilterForConnectorHubAndHubPorts:f_iDevUsable 0x%x",f_iDevUsable));
    ETG_TRACE_USR4(("End  : vFilterForConnectorHubAndHubPorts"));
}

/*-----------------------------------------------------------------------------*
 * void ConfigurationManager:: vFilterForDeviceType(...)
 *-----------------------------------------------------------------------------*/
void  ConfigurationManager::vFilterForDeviceType(OUT tenResultFilter &f_enResult, IN CGlobalEnumerations::DEVICE_TYPE_Type f_eDeviceType, IN int f_iUsbNumber) const
{
    ETG_TRACE_USR4(("Begin: vFilterForDeviceType"));
    ETG_TRACE_USR2(("vFilterForDeviceType: f_eDeviceType: %d", ETG_CENUM(CGlobalEnumerations::DEVICE_TYPE_Type,f_eDeviceType)));

    f_enResult = enUnknown;
    tU16 u16configvalue;

    for(tInt i=(tInt)eCONF_ENABLE_EXTERNAL_SD; i<=(tInt)eCONF_ENABLE_EXTERNAL_UNSUPPORTED; i++)
    {
        if( m_eDeviceType[i] == f_eDeviceType )
        {
            u16configvalue = u16GetConfigurationValue((tenDevManagerConfigValue)i);
            if(DVM_ON == u16configvalue)
            {
                ETG_TRACE_COMP(("vFilterForDeviceType: Type ENABLED"));
                f_enResult = enEnabled;
            }
            else
            {
                f_enResult = enDisabled;
                /*Check for Connected Device in Portnumber based on Configuration value*/
                switch(u16configvalue)
                {
                    case DVM_ON_USB1:
                        if(eUSB1 == f_iUsbNumber)
                        {
                            ETG_TRACE_COMP(("vFilterForDeviceType: Type ENABLED"));
                            f_enResult = enEnabled;
                        }
                        break;
                    case DVM_ON_USB2:
                        if(eUSB2 == f_iUsbNumber)
                        {
                            ETG_TRACE_COMP(("vFilterForDeviceType: Type ENABLED"));
                            f_enResult = enEnabled;
                        }
                        break;
                    case DVM_ON_USB3:
                        if(eUSB3 == f_iUsbNumber)
                        {
                            ETG_TRACE_COMP(("vFilterForDeviceType: Type ENABLED"));
                            f_enResult = enEnabled;
                        }break;
                    case DVM_ON_USB1_USB2:
                        if(eUSB1 == f_iUsbNumber || eUSB2 == f_iUsbNumber)
                        {
                            ETG_TRACE_COMP(("vFilterForDeviceType: Type ENABLED"));
                            f_enResult = enEnabled;
                        }
                        break;
                    case DVM_ON_USB2_USB3:
                        if(eUSB2 == f_iUsbNumber || eUSB3 == f_iUsbNumber)
                        {
                            ETG_TRACE_COMP(("vFilterForDeviceType: Type ENABLED"));
                            f_enResult = enEnabled;
                        }
                        break;
                    case DVM_ON_USB3_USB1:
                        if(eUSB3 == f_iUsbNumber || eUSB1 == f_iUsbNumber)
                        {
                            ETG_TRACE_COMP(("vFilterForDeviceType: Type ENABLED"));
                            f_enResult = enEnabled;
                        }
                        break;
                    default:
                        ETG_TRACE_USR2(("vFilterForDeviceType: Unexpected Value.."));
                }

            }
         }

    }

    ETG_TRACE_USR2(("vFilterForDeviceType: f_enResult: %d", ETG_CENUM(tenResultFilter,f_enResult)));
    ETG_TRACE_USR4(("End  : vFilterForDeviceType"));
}


/*-----------------------------------------------------------------------------*
 * int ConfigurationManager::IsSupportedFS(GENSTRING f_cFSType)                                        *
 *-----------------------------------------------------------------------------*/
int ConfigurationManager::IsSupportedFS(GENSTRING f_cFSType)
{
    ETG_TRACE_USR4(("Begin: IsSupportedFS"));


    //Check For supported filesystem
    int l_iSupportedFS = DEVICEMANAGER_ERROR_NOTVALID;

    ETG_TRACE_USR4(("IsSupportedFS: Value of  f_cFSType:: %s", f_cFSType.toStdString().c_str()));

    for(tInt i=(tInt)eCONF_ENABLE_FILESYSTEM_FAT; i<=(tInt)eCONF_ENABLE_FILESYSTEM_UDF; i++)
    {
        if(DVM_ON == u16GetConfigurationValue((tenDevManagerConfigValue)i))
        {
            switch(i)
            {
            case eCONF_ENABLE_FILESYSTEM_FAT:
                if (GENSTRING("vfat") == f_cFSType )
                {
                    l_iSupportedFS = DEVICEMANAGER_OK;
                }
                break;
            case eCONF_ENABLE_FILESYSTEM_NTFS:
                if (GENSTRING("ntfs") == f_cFSType)
                {
                    l_iSupportedFS = DEVICEMANAGER_OK;
                }
                break;
            case eCONF_ENABLE_FILESYSTEM_EXTFAT:
                if (GENSTRING("exfat") == f_cFSType)
                {
                    l_iSupportedFS = DEVICEMANAGER_OK;
                }
                break;
            case eCONF_ENABLE_FILESYSTEM_HFSPLUS:
                if (GENSTRING("hfsplus") == f_cFSType )
                {
                    l_iSupportedFS = DEVICEMANAGER_OK;
                }
                break;
            case eCONF_ENABLE_FILESYSTEM_EXT_3_4_FS:
                if (GENSTRING("ext3") == f_cFSType || GENSTRING("ext4") == f_cFSType )
                {
                    l_iSupportedFS = DEVICEMANAGER_OK;
                }
                break;
            default:
                ETG_TRACE_FATAL(("IsSupportedFS: Unexpected file system value  : %d", (int)i))
                        break;
            }

        }
    }

    ETG_TRACE_USR4(("End   : IsSupportedFS"));

    return l_iSupportedFS;
}

/*-----------------------------------------------------------------------------*
 * void ConfigurationManager:: vFilterForFilsystemType(...)
 *-----------------------------------------------------------------------------*/
void ConfigurationManager::vFilterForFilsystemType(OUT tenResultFilter &f_enResult,IN CGlobalEnumerations::FILESYSTEM_TYPE_Type f_eFileSystemType) const
{
    ETG_TRACE_USR4(("Begin: vFilterForFilsystemType"));
    ETG_TRACE_USR2(("vFilterForFilsystemType:  f_eFileSystemType: %d", ETG_CENUM(CGlobalEnumerations::FILESYSTEM_TYPE_Type,f_eFileSystemType)))

            f_enResult = enUnknown;

    for(tInt i=(tInt)eCONF_ENABLE_FILESYSTEM_FAT; i<=(tInt)eCONF_ENABLE_FILESYSTEM_UDF; i++)
    {
        if( m_eFileSystemType[i] == f_eFileSystemType )
        {
            if(DVM_ON == u16GetConfigurationValue((tenDevManagerConfigValue)i))
            {
                ETG_TRACE_COMP(("vFilterForFilsystemType: Type ENABLED"));
                f_enResult = enEnabled;
            }
            else
            {
                ETG_TRACE_COMP(("vFilterForFilsystemType: Type DISABLED"));
                f_enResult = enDisabled;
            }
        }
    }

    ETG_TRACE_USR2(("vFilterForFilsystemType: f_enResult: %d", ETG_CENUM(tenResultFilter,f_enResult)));
    ETG_TRACE_USR4(("End  : vFilterForFilsystemType"));
}

/*-----------------------------------------------------------------------------*
 * void ConfigurationManager:: vFilterForDeviceAppleUnsupported(...)
 *-----------------------------------------------------------------------------*/
void  ConfigurationManager::vFilterForDeviceAppleUnsupported(OUT tenResultFilter &f_enResult, IN int f_iVendorID,IN int f_iProductID) const
{
    ETG_TRACE_USR4(("Begin: FilterWithConfigurationDeviceAppleUnsupported"));

    ETG_TRACE_COMP(("vFilterForDeviceAppleUnsupported: u16AppleVendorID: 0x%x ; f_iVendorID: 0x%x, f_iProductID:0x%x ",u16AppleVendorID, f_iVendorID,f_iProductID));
    f_enResult = enEnabled;


    if(u16AppleVendorID == f_iVendorID && 0x12 != (f_iProductID >> 8) )
    {
#ifdef DISABLE_UNSUPPORTED_APPLE_DEVICES
        ETG_TRACE_USR1(("FilterWithConfiguration: Unsupported Apple device found" ));
        f_enResult = enDisabled;
#else
        ETG_TRACE_USR1(("FilterWithConfiguration: DISABLE_UNSUPPORTED_APPLE_DEVICES not used" ));
#endif

    }

    ETG_TRACE_USR2(("FilterWithConfigurationDeviceAppleUnsupported: f_enResult: %d", ETG_CENUM(tenResultFilter,f_enResult)));
    ETG_TRACE_USR4(("End  : FilterWithConfigurationDeviceAppleUnsupported"));
}

/*-----------------------------------------------------------------------------*
 * void ConfigurationManager:: vFilterForIsOsalNotifiedDeviceSDCardInternal(...)
 *-----------------------------------------------------------------------------*/
bool ConfigurationManager::bIsOsalNotifiedDeviceSDCardInternal(IN GENSTRING f_strcUUIDDeviceName) const
{
    ETG_TRACE_USR4(("Begin: vFilterForIsOsalNotifiedDeviceSDCardInternal"));

    bool bRet = f_strcUUIDDeviceName.contains(m_strBlockDevNameSDCardInternalWithoutDev.c_str());

    ETG_TRACE_USR4(("End  : vFilterForIsOsalNotifiedDeviceSDCardInternal"));

    return bRet;
}



/*-----------------------------------------------------------------------------*
 * void ConfigurationManager:: vCheckAdjustDeviceNameForRegion(...)
 *-----------------------------------------------------------------------------*/
void ConfigurationManager::vCheckAdjustDeviceNameForRegion(CDevice* f_pCurDevice) const
{
    ETG_TRACE_USR4(("Begin: vCheckAdjustDeviceNameForRegion"));
    if (bUseMArketingRegion == TRUE)
    {
        ETG_TRACE_COMP(("vCheckAdjustDeviceNameForRegion: ENABLED"));
        if(f_pCurDevice)
        {

            //---------------------------------------------------
            //  adjust device name country dependent
            //---------------------------------------------------
            ETG_TRACE_COMP(("vCheckAdjustDeviceNameForRegion: before ValidateAndConvertToRegionLanguage %s", f_pCurDevice->m_cDeviceName.toStdString().c_str()));
#ifdef USE_VALIDATE_AND_CONVERT2REGION_LANGUAGE
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST   //@todo mock this for tests then this switch does become obsolete
            tU8 l_u8MarketingRegion = (tU8) u16GetConfigurationValue(eCONF_MARKETING_REGION);

            f_pCurDevice->m_cDeviceName = ValidateAndConvertToRegionLanguage(f_pCurDevice->m_cFSType,f_pCurDevice->m_cDeviceName,l_u8MarketingRegion);
            ETG_TRACE_COMP(("vCheckAdjustDeviceNameForRegion:after  ValidateAndConvertToRegionLanguage %s", f_pCurDevice->m_cDeviceName.toStdString().c_str()));
#endif
#endif
        }
        else
        {
            ETG_TRACE_USR1(("[ERROR]: vCheckAdjustDeviceNameForRegion:f_pCurDevice == NULL"));
        }
    }
    else
    {
        ETG_TRACE_FATAL(("vCheckAdjustDeviceNameForRegion: DISABLED"));
    }

    ETG_TRACE_USR4(("End  : vCheckAdjustDeviceNameForRegion"));
}

/*-----------------------------------------------------------------------------*
 * void ConfigurationManager:: bIsMassStorageDevice(...)
 *-----------------------------------------------------------------------------*/
tBool ConfigurationManager::bIsMassStorageDevice(CGlobalEnumerations::DEVICE_TYPE_Type eDeviceType) const
{
    tBool bRetVal = FALSE;
    if(   (eDeviceType == CGlobalEnumerations::DTY_USB)
          ||(eDeviceType == CGlobalEnumerations::DTY_SD)
          ||(eDeviceType == CGlobalEnumerations::DTY_CDROM)
          ||(eDeviceType == CGlobalEnumerations::DTY_SD_INTERNAL))
    {
        bRetVal = TRUE;
    }
    return bRetVal;
}

/*-----------------------------------------------------------------------------*
 * void ConfigurationManager:: bIsMassStorageDevice(...)
 *-----------------------------------------------------------------------------*/
void ConfigurationManager::vFilterForMassStorageDeviceSize(OUT tenResultFilter &f_enResult, IN CGlobalEnumerations::DEVICE_TYPE_Type eDeviceType,IN tU16 f_u16TotalSize_GB) const
{
    f_enResult = enUnknown;
    tU16 l_u16LimitedSizeGB = u16GetConfigurationValue(eCONF_ENABLE_LIMIT_SIZE_MSD);


    if((TRUE == bIsMassStorageDevice(eDeviceType)) && (f_u16TotalSize_GB != 0))
    {
        f_enResult = enEnabled;
        if(l_u16LimitedSizeGB >=DVM_ON)
        {
            if(f_u16TotalSize_GB >= l_u16LimitedSizeGB)
            {
                f_enResult = enDisabled;
            }
        }
    }
    else
    {
        ETG_TRACE_USR2(("vFilterForMassStorageDeviceSize: "));
    }

    ETG_TRACE_USR2(("vFilterForMassStorageDeviceSize: f_enResult: %d", ETG_CENUM(tenResultFilter,f_enResult)));
}


/*-----------------------------------------------------------------------------*
 * tVoid vGetUSBConnectorFromSysPath(...)
 *-----------------------------------------------------------------------------*/
//this function has been shifted to ConfigurationBase in order to offer overwriting it this is important for extension planned for PSA

/*-----------------------------------------------------------------------------*
 * tVoid vGetHUBConnectedFromSysPath((...)
 *-----------------------------------------------------------------------------*/
int ConfigurationManager::iGetHUBConnectedFromSysName(OUT bool &f_bConnectedWithHUB, OUT int &f_iPortNum, IN const GENSTRING &f_strSysName) const
{
    ETG_TRACE_USR4(("Begin: iGetHUBConnectedFromSysName f_pcSysName : %s ",f_strSysName.toStdString().c_str()));

    int l_iParseSuccessful = DEVICEMANAGER_DEVICE_DETECTED;

    GENSTRING l_cSysNamePart1;  //e.g. f_strSysName is  2-2.1 then part1 is 2
    GENSTRING l_cSysNamePart2; // e.g. f_strSysName is  2-2.1 then part2 is 2.1

    // Check for valid params
    if(!f_strSysName.isEmpty() )
    {
        int l_iPos   = -1;
        int l_iChar  = 0;   // stores location of usb level '.'
        int l_iCount = 0;   // counts the usb level

        l_cSysNamePart1 = f_strSysName;
        l_cSysNamePart2 = f_strSysName;

        // Check l_cSysName for validity
        if (-1 == l_cSysNamePart2.indexOf("-"))
        {
            ETG_TRACE_ERR (("iGetHUBConnectedFromSysName: [ERROR] Invalid f_pcSysName : %s", f_strSysName.toStdString().c_str()));
            l_iParseSuccessful = DEVICEMANAGER_ERROR_NOTVALID;
            f_iPortNum = 0;
        }
        else
        {
            l_cSysNamePart1 = l_cSysNamePart1.left(l_cSysNamePart1.indexOf("-"));
            // Removes 1- from 1-2.3  i.e.
            l_cSysNamePart2.remove(0,2);

            // Find number of dot for usb level hub
            while ((l_iChar = l_cSysNamePart2.indexOf(".", l_iChar)) != -1)
            {
                l_iChar++;
                l_iCount++;
            }
            ETG_TRACE_USR4(("iGetHUBConnectedFromSysName: l_cSysNamePart1:%s",l_cSysNamePart1.toStdString().c_str()));
            ETG_TRACE_USR4(("iGetHUBConnectedFromSysName: l_cSysNamePart2:%s",l_cSysNamePart2.toStdString().c_str()));
            // Check how many HUB levels are there
            if (l_iCount < 2)
            {
                //e.g. : l_cSysNamePart2: 1.1 or 1.2 or 1.3  means 1,2,3 are the portnum at the HUB
                //e.g. :  l_cSysNamePart2: 1 means no HUB present USBNumber is 1 port is 0
                l_iPos = l_cSysNamePart2.indexOf(".");

                // Check whether device connected to USB directly and not through a Hub
                if (l_iPos > -1)
                {
                    f_bConnectedWithHUB = true;
                    f_iPortNum = l_cSysNamePart2.right(l_iPos).toInt();

                    ETG_TRACE_USR3 (("iGetHUBConnectedFromSysName: Hub present"));
                }
                else
                {
                    ETG_TRACE_USR3 (("iGetHUBConnectedFromSysName: No Hub present"));
                    f_bConnectedWithHUB = false;
                    f_iPortNum = 0;
                }

                l_iParseSuccessful = DEVICEMANAGER_DEVICE_DETECTED;
            }
#ifdef USE_HUB_CONNECTED_TO_HUB
            else if(l_iCount >= 2)
            {
                FILE *l_pAllowItFile;
                f_iPortNum = 0;
                f_bConnectedWithHUB = true;

                if (NULL != (l_pAllowItFile = fopen (USE_HUB_CONNECTED_TO_HUB_ALLOW_IT_FILE, "r")))
                {
                    ETG_TRACE_FATAL(("[ok] x  : PERMANENT ENABLED : HUB connected to HUB:                 (Found file %s:) ",USE_HUB_CONNECTED_TO_HUB_ALLOW_IT_FILE));
                    fclose(l_pAllowItFile);

                    //e.g. : l_cSysName: 1.2.1 or 1.2.2 or 1.2.3  means 1,2,3 are the portnum at the HUB whereas '2' is the portnumber at the first HUB where the second is connected to

                    ETG_TRACE_FATAL(("iGetHUBConnectedFromSysName: l_cSysName.remove(0,2):%s",l_cSysNamePart2.toStdString().c_str()));

                    l_iPos = l_cSysNamePart2.indexOf(".");

                    // Check whether device connected to USB directly and not through a Hub
                    if (l_iPos > -1)
                    {


                        l_cSysNamePart2.remove(0,2); //removes '1.' from           //results in e.g. '2.3'   '2' means second HUB connected at port 2 of first HUB
                        l_iPos = l_cSysNamePart2.indexOf(".");
                        if(l_iPos > -1)
                        {
                            f_iPortNum = l_cSysNamePart2.right(l_iPos).toInt(); //e.g. basis is '2.3' ...'3' means port 3 of HUB connected to first HUB

                        }
                        else
                        {
                            ETG_TRACE_FATAL(("iGetHUBConnectedFromSysName: unexpected case 1 (HUB connected to HUB)"));
                        }

                        ETG_TRACE_USR3 (("iGetHUBConnectedFromSysName: Hub at HUB present"));
                    }
                }
                else
                {
                    ETG_TRACE_FATAL(("iGetHUBConnectedFromSysName: unexpected case 2 (HUB connected to HUB)"));
                }
            }
#endif
            else
            {
                ETG_TRACE_USR3 (("iGetHUBConnectedFromSysName: Device detected on above level one HUB (HUB connected to HUB always diasbled)"));

                f_iPortNum = 0;

                l_iParseSuccessful = DEVICEMANAGER_ERROR_NODEVICE;
            } // if (multiple HUB levels)
        }
    }
    else
    {
        ETG_TRACE_ERR (("v: [ERROR] Invalid f_pCurDevice is NULL"));

        l_iParseSuccessful = DEVICEMANAGER_ERROR_INVALID_PARAM;
    } // if (f_pCurDevice is NULL)

    ETG_TRACE_USR4 (("iGetHUBConnectedFromSysName:  f_pcSysName         :  %s", f_strSysName.toStdString().c_str()));
    ETG_TRACE_USR4 (("iGetHUBConnectedFromSysName:  l_cSysNamePart1   :  %s", l_cSysNamePart1.toStdString().c_str()));
    ETG_TRACE_USR4 (("iGetHUBConnectedFromSysName:  l_cSysNamePart2   :  %s", l_cSysNamePart2.toStdString().c_str()));
    ETG_TRACE_USR4 (("iGetHUBConnectedFromSysName:  f_uiPortNo          :  %d", f_iPortNum));
    ETG_TRACE_USR4 (("iGetHUBConnectedFromSysName:  f_bConnectedWithHUB :  0x%x", f_bConnectedWithHUB));

    ETG_TRACE_USR4(("End  : iGetHUBConnectedFromSysName"));
    return l_iParseSuccessful;
}


tVoid ConfigurationManager::vGetProjectName(OUT std::string &strProjectName)
{
    if(m_eCustomer != eLastCustomer)
    {
        strProjectName = m_strAllCustomerNames[m_eCustomer];
    }
    else
    {
        strProjectName = "undefined";
    }
    ETG_TRACE_USR4(("vGetProjectName: %s",strProjectName.c_str()));
}

/*-----------------------------------------------------------------------------*
 * tVoid ShowVariantSwitches(tVoid)                                      *
 *-----------------------------------------------------------------------------*/
tVoid ConfigurationManager::vShowVariantSwitches(FILE* f_poDumpFile)
{
    FILE *l_pDisableFile;

    ETG_TRACE_FATAL(("[ok] ===================================================="));
    ETG_TRACE_FATAL(("[ok] VERSION: %s",VERSION_NUM_OF_COMPONENT));
    ETG_TRACE_FATAL(("[ok] ===================================================="));


    ETG_TRACE_FATAL(("[ok] -------------------/switches in _prod.xml----------------------------------"));


    //<!-- SPECIAL FOR SDCARD INTERNAL-->
#ifdef USE_ENABLE_DEVMGR_GPIOIF
    ETG_TRACE_FATAL(("[ok] x  : USE_ENABLE_DEVMGR_GPIOIF             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : USE_ENABLE_DEVMGR_GPIOIF             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_HW_SDCARD
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_HW_SDCARD             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_HW_SDCARD             "));
#endif
    //<!-- UNDERVOLTAGE & OVERCURRENT & CHARGE APPLE -->
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_USE_DRV_VOLT
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_USE_DRV_VOLT             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_USE_DRV_VOLT             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_PRM_USED
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_PRM_USED             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_PRM_USED             "));
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_USBHWCTRL
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_USBHWCTRL             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_USBHWCTRL             "));
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CHARGE_APPLE_DEVICES
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_CHARGE_APPLE_DEVICES             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_CHARGE_APPLE_DEVICES             "));
#endif

    //<!-- DEVICE NOTIFICATION-->
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_IPAD_AS_IPOD
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_IPAD_AS_IPOD             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_IPAD_AS_IPOD             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_SDINT_AS_SD
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_SDINT_AS_SD             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_SDINT_AS_SD             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_IPAD_SUPPRESS
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_IPAD_SUPPRESS             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_IPAD_SUPPRESS             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_CDROM_AS_USBMSC
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_CDROM_AS_USBMSC             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_CDROM_AS_USBMSC             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_UNSUPPORTED_DEVTYPE
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_UNSUPPORTED_DEVTYPE             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_UNSUPPORTED_DEVTYPE             "));
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_UNSUPPORTED_FILESYSTEM
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_UNSUPPORTED_FILESYSTEM             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_UNSUPPORTED_FILESYSTEM             "));
#endif

#ifdef USE_SENT_ALL_CHANGES
    ETG_TRACE_FATAL(("[ok] x  : USE_SENT_ALL_CHANGES             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : USE_SENT_ALL_CHANGES             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_MTP_DEVICES
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_MTP_DEVICES             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_MTP_DEVICES             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_APPLE_DEVICES
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_APPLE_DEVICES             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_APPLE_DEVICES             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_SDCARD_DEVICES
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_SDCARD_DEVICES             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_SDCARD_DEVICES             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_USBMSC_DEVICES
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_USBMSC_DEVICES             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_USBMSC_DEVICES             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_CDROM_DEVICE
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_CDROM_DEVICE             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_CDROM_DEVICE             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_SDCARD_DEVICE
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_SDCARD_DEVICE             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_SDCARD_DEVICE             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_CDDA_DEVICE
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_CDDA_DEVICE             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_CDDA_DEVICE             "));
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_USE_SPM_HISTORYTRIGGER_EJECT
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_USE_SPM_HISTORYTRIGGER_EJECT             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_USE_SPM_HISTORYTRIGGER_EJECT             "));
#endif


    //<!-- FILESYSTEMS -->
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_FAT
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_FAT             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_FAT             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_NTFS
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_NTFS             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_NTFS             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_EXTFAT
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_EXTFAT             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_EXTFAT             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_HFSPLUS
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_HFSPLUS             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_HFSPLUS             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_EXT_3_4_FS
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_EXT_3_4_FS             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_EXT_3_4_FS             "));
#endif


    //<!-- DIAGNOSIS -->
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_DIAGLOG_DTC_USB_TRIGGERED_BY_HWSIGNALS
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_DIAGLOG_DTC_USB_TRIGGERED_BY_HWSIGNALS             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_DIAGLOG_DTC_USB_TRIGGERED_BY_HWSIGNALS             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_DIAGLOG_DTC_CYCLIC_DIAGNOSIS
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_DIAGLOG_DTC_CYCLIC_DIAGNOSIS   "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_DIAGLOG_DTC_CYCLIC_DIAGNOSIS   "));
#endif

    //<!-- CONFIGURATION -->
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EOL
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_EOL             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_EOL             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_KDS
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_KDS             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_KDS             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN2_GM
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN2_GM             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN2_GM             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN2_NISSANLCN2KAI
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN2_NISSANLCN2KAI             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN2_NISSANLCN2KAI             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_PSARCC
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_PSARCC             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_PSARCC             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_JACCII
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_JACCII             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_JACCII             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_SUZSLN
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_SUZSLN             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_SUZSLN             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_RNAIVI
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_RNAIVI             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_RNAIVI             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_G3G
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_G3G             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_G3G             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_VAGMIBE
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_VAGMIBE             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_VAGMIBE             "));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_GMMY16
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_GMMY16             "));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_GMMY16             "));
#endif
#ifdef USE_EXTERNAL_UNSUPPORTED_DEVICES
    ETG_TRACE_FATAL(("[ok] x  : USE_EXTERNAL_UNSUPPORTED_DEVICES"));
#else
    ETG_TRACE_FATAL(("[ok] -  : USE_EXTERNAL_UNSUPPORTED_DEVICES"));
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_PRM_USB_UV_AVAILABLE
    ETG_TRACE_FATAL(("[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_PRM_USB_UV_AVAILABLE"));
#else
    ETG_TRACE_FATAL(("[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_PRM_USB_UV_AVAILABLE"));
#endif


//---------------------------------------------------------------------
//switches with dependencies to control if and how state machine informs clients
//----------------------------------------------------------------------
ETG_TRACE_FATAL(("[ok] -------------------/switches in config.h----------------------------------"));

    //---------------------------------
    //diagnosis and end of line
    //---------------------------------
#ifdef USE_LOOKUP
    ETG_TRACE_FATAL(("[ok] x  : USE_LOOKUP                               "));
#else
    ETG_TRACE_FATAL(("[ok] -  : USE_LOOKUP                               "));
#endif

    //-----------------------------------------------
    // show if something has been permanent disabled
    //----------------------------------------------
    ETG_TRACE_FATAL(("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - "));

    if (NULL != (l_pDisableFile = fopen (CYLCIC_DIAGNOSIS_DISABLEFILE, "r")))
    {
        ETG_TRACE_FATAL(("[ok] x  : PERMANENT DISABLED : CYCLIC DIAGNOSIS:                 (Found file %s:) ",CYLCIC_DIAGNOSIS_DISABLEFILE));
        fclose(l_pDisableFile);
    }
    if (NULL != (l_pDisableFile = fopen (STARTUP_SERVICEAVAILABLE_DISABLEFILE, "r")))
    {
        ETG_TRACE_FATAL(("[ok] x  : PERMANENT DISABLED : SERVICE AVAILABILITY AT STARTUP:  (Found file %s:) ",STARTUP_SERVICEAVAILABLE_DISABLEFILE));
        fclose(l_pDisableFile);
    }
    if (NULL != (l_pDisableFile = fopen (STARTUP_DEVICEMONITOR_DISABLEFILE, "r")))
    {
        ETG_TRACE_FATAL(("[ok] x  : PERMANENT DISABLED : DEVICEMONITOR AT STARTUP (Found file %s:) ",STARTUP_DEVICEMONITOR_DISABLEFILE));
        fclose(l_pDisableFile);
    }
    if (NULL != (l_pDisableFile = fopen (USE_HUB_CONNECTED_TO_HUB_ALLOW_IT_FILE, "r")))
    {
        ETG_TRACE_FATAL(("[ok] x  : PERMANENT ENABLED  : HUB connected to HUB:                 (Found file %s:) ",USE_HUB_CONNECTED_TO_HUB_ALLOW_IT_FILE));
        fclose(l_pDisableFile);
    }
    ETG_TRACE_FATAL(("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - "));

    ETG_TRACE_FATAL(("[ok] -------------------switches in config.h/----------------------------------"));

    //---------------------------------------------------------------------
    // dump to file, if available
    //--------------------------------------------------------------------
    if (NULL != f_poDumpFile)
    {
        fprintf(f_poDumpFile, "[ok] ====================================================\n");
        fprintf(f_poDumpFile, "[ok] VERSION: %s\n",VERSION_NUM_OF_COMPONENT);
        fprintf(f_poDumpFile, "[ok] ====================================================\n\n");

        fprintf(f_poDumpFile, "[ok] -------------------/switches in _prod.xml----------------------------------\n\n");

        //<!-- SPECIAL FOR SDCARD INTERNAL-->
#ifdef USE_ENABLE_DEVMGR_GPIOIF
        fprintf(f_poDumpFile, "[ok] x  : USE_ENABLE_DEVMGR_GPIOIF                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : USE_ENABLE_DEVMGR_GPIOIF                 \n");
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_HW_SDCARD
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_HW_SDCARD                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_HW_SDCARD                 \n");
#endif

        //<!-- UNDERVOLTAGE & OVERCURRENT & CHARGE APPLE -->
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_USE_DRV_VOLT
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_USE_DRV_VOLT                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_USE_DRV_VOLT                 \n");
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_PRM_USED
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_PRM_USED                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_PRM_USED                 \n");
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_USBHWCTRL
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_USBHWCTRL                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_USBHWCTRL                 \n");
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CHARGE_APPLE_DEVICES
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_CHARGE_APPLE_DEVICES                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_CHARGE_APPLE_DEVICES                 \n");
#endif

        //<!-- DEVICE NOTIFICATION-->
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_IPAD_AS_IPOD
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_IPAD_AS_IPOD                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_IPAD_AS_IPOD                 \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_SDINT_AS_SD
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_SDINT_AS_SD                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_SDINT_AS_SD                 \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_IPAD_SUPPRESS
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_IPAD_SUPPRESS                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_IPAD_SUPPRESS                 \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_CDROM_AS_USBMSC
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_CDROM_AS_USBMSC                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_CDROM_AS_USBMSC                 \n");
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_UNSUPPORTED_DEVTYPE
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_UNSUPPORTED_DEVTYPE                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_UNSUPPORTED_DEVTYPE                 \n");
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_UNSUPPORTED_FILESYSTEM
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_UNSUPPORTED_FILESYSTEM                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_UNSUPPORTED_FILESYSTEM                 \n");
#endif

#ifdef USE_SENT_ALL_CHANGES
        fprintf(f_poDumpFile, "[ok] x  : USE_SENT_ALL_CHANGES                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : USE_SENT_ALL_CHANGES                 \n");
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_MTP_DEVICES
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_MTP_DEVICES                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_MTP_DEVICES                 \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_APPLE_DEVICES
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_APPLE_DEVICES                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_APPLE_DEVICES                 \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_SDCARD_DEVICES
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_SDCARD_DEVICES                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_SDCARD_DEVICES                 \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_USBMSC_DEVICES
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_USBMSC_DEVICES                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_USBMSC_DEVICES                 \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_CDROM_DEVICE
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_CDROM_DEVICE                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_CDROM_DEVICE                 \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_SDCARD_DEVICE
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_SDCARD_DEVICE                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_SDCARD_DEVICE                 \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_CDDA_DEVICE
        fprintf(f_poDumpFile,"[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_CDDA_DEVICE             \n");
#else
        fprintf(f_poDumpFile,"[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_CDDA_DEVICE             \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_USE_SPM_HISTORYTRIGGER_EJECT
        fprintf(f_poDumpFile,"[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_USE_SPM_HISTORYTRIGGER_EJECT             \n");
#else
        fprintf(f_poDumpFile,"[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_USE_SPM_HISTORYTRIGGER_EJECT             \n");
#endif


#ifdef USE_EXTERNAL_UNSUPPORTED_DEVICES
        fprintf(f_poDumpFile, "[ok] x  : USE_EXTERNAL_UNSUPPORTED_DEVICES                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : USE_EXTERNAL_UNSUPPORTED_DEVICES                 \n");
#endif

        //<!-- FILESYSTEMS -->
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_FAT
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_FAT                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_FAT                 \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_NTFS
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_NTFS                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_NTFS                 \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_EXTFAT
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_EXTFAT                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_EXTFAT                 \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_HFSPLUS
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_HFSPLUS                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_HFSPLUS                 \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_EXT_3_4_FS
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_EXT_3_4_FS                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_EXT_3_4_FS                 \n");
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_DIAGLOG_DTC_USB_TRIGGERED_BY_HWSIGNALS
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_DIAGLOG_DTC_USB_TRIGGERED_BY_HWSIGNALS                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_DIAGLOG_DTC_USB_TRIGGERED_BY_HWSIGNALS                 \n");
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_DIAGLOG_DTC_CYCLIC_DIAGNOSIS
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_DIAGLOG_DTC_CYCLIC_DIAGNOSIS   \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_DIAGLOG_DTC_CYCLIC_DIAGNOSIS    \n");
#endif

        //<!-- CONFIGURATION -->
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EOL
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_EOL                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_EOL                 \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_KDS
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_KDS                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_KDS                 \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL                 \n");
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN2_GM
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN2_GM                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN2_GM                 \n");
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN2_NISSANLCN2KAI
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN2_NISSANLCN2KAI                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN2_NISSANLCN2KAI                 \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_PSARCC
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_PSARCC                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_PSARCC                 \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_JACCII
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_JACCII                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_JACCII                 \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_SUZSLN
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_SUZSLN                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_SUZSLN                 \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_RNAIVI
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_RNAIVI                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_RNAIVI                 \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_G3G
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_G3G                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_G3G                 \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_VAGMIBE
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_VAGMIBE                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_VAGMIBE                 \n");
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_GMMY16
        fprintf(f_poDumpFile, "[ok] x  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_GMMY16                 \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_GMMY16                 \n");
#endif

        //<!-- INTERFACE -->

        //---------------------------------------------------------------------
        //switches with dependencies to control if and how state machine informs clients
        //----------------------------------------------------------------------
        fprintf(f_poDumpFile, "[ok] -------------------/switches in config.h----------------------------------\n");

        //---------------------------------
        //diagnosis and end of line
        //---------------------------------
#ifdef USE_LOOKUP
        fprintf(f_poDumpFile, "[ok] x  : USE_LOOKUP                               \n");
#else
        fprintf(f_poDumpFile, "[ok] -  : USE_LOOKUP                               \n");
#endif

        //-----------------------------------------------
        // show if something has been permanent disabled
        //----------------------------------------------
        fprintf(f_poDumpFile, "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - \n");

        if (NULL != (l_pDisableFile = fopen (CYLCIC_DIAGNOSIS_DISABLEFILE, "r")))
        {
            fprintf(f_poDumpFile, "[ok] x  : PERMANENT DISABLED : CYCLIC DIAGNOSIS:                 (Found file %s:) \n",CYLCIC_DIAGNOSIS_DISABLEFILE);
            fclose(l_pDisableFile);
        }
        if (NULL != (l_pDisableFile = fopen (STARTUP_SERVICEAVAILABLE_DISABLEFILE, "r")))
        {
            fprintf(f_poDumpFile, "[ok] x  : PERMANENT DISABLED : SERVICE AVAILABILITY AT STARTUP:  (Found file %s:) \n",STARTUP_SERVICEAVAILABLE_DISABLEFILE);
            fclose(l_pDisableFile);
        }
        if (NULL != (l_pDisableFile = fopen (STARTUP_DEVICEMONITOR_DISABLEFILE, "r")))
        {
            fprintf(f_poDumpFile, "[ok] x  : PERMANENT DISABLED : DEVICEMONITOR AT STARTUP (Found file %s:) \n",STARTUP_DEVICEMONITOR_DISABLEFILE);
            fclose(l_pDisableFile);
        }
        if (NULL != (l_pDisableFile = fopen (USE_HUB_CONNECTED_TO_HUB_ALLOW_IT_FILE, "r")))
        {
            fprintf(f_poDumpFile, "[ok] x  : PERMANENT ENABLED  : HUB connected to HUB (Found file %s:) \n",USE_HUB_CONNECTED_TO_HUB_ALLOW_IT_FILE);
            fclose(l_pDisableFile);
        }
        fprintf(f_poDumpFile, "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - \n");

        fprintf(f_poDumpFile, "[ok] -------------------switches in config.h/----------------------------------\n");
    }
}


/*-----------------------------------------------------------------------------*
* void vCheckLSIMSDCardFake(INOUT CDevice *f_pCurDevice)
 *-----------------------------------------------------------------------------*/
void ConfigurationManager::vCheckLSIMSDCardFake(INOUT CDevice *f_pCurDevice) const
{
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
    (void)f_pCurDevice;
#else //VARIANT_S_FTR_ENABLE_UNITTEST
    tBool bAdjustToSDCard;
    //if running in LSIM and USB stick holds keyfile then 'sell USB stick as SD-Card' this is to test for upper layers
    if(f_pCurDevice)
    {
        if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_FAKE_SDCARD))
        {
            if(f_pCurDevice->m_eDeviceType == CGlobalEnumerations::DTY_USB) //relevant for USB-stick only
            {
                if(CheckKeyDirExists(CGlobalEnumerations::Key_LSIM_SDCARD_FAKE,f_pCurDevice->m_cMountPoint.toStdString().c_str()))
                {
                    bAdjustToSDCard = TRUE;
                }
                else if(CheckKeyFileExists(CGlobalEnumerations::Key_LSIM_SDCARD_FAKE,f_pCurDevice->m_cMountPoint.toStdString().c_str()))
                {
                    bAdjustToSDCard = TRUE;
                }
                else
                {
                    bAdjustToSDCard = FALSE;
                }

                if(bAdjustToSDCard)
                {
                    ETG_TRACE_FATAL(("[INFO]:vCheckLSIMSDCardFake: LSIM : USB-Stick found with key file/dir 'SDCARD' switch DTY_USB to DTY_SD"));
                    f_pCurDevice->m_eDeviceType = CGlobalEnumerations::DTY_SD;
                }
            }
        }
    }
#endif
}
/*-----------------------------------------------------------------------------*
 *tVoid vSetTelematicsBoxDeviceSpeed(IN tBool b_DeviceSpeed)
 *-----------------------------------------------------------------------------*/
tVoid ConfigurationManager::vSetTelematicsBoxDeviceSpeed(IN tBool b_DeviceSpeed)
{
    ETG_TRACE_USR4(("Begin: vSetTelematicsBoxDeviceSpeed Device speed %d",b_DeviceSpeed));
    if(m_uiNumberOfTelematicBoxesUsed <= iMaxSizeOfArray)
    {
        if(DVM_ON == m_u16ConfigurationValue[eConf_ENABLE_EXTERNAL_BTA])
        {
            for(unsigned int i=0; i<m_uiNumberOfTelematicBoxesUsed; i++)
            {
                m_uiTelematicsBoxDeviceInfo[i].bIsHighSpeedExpected = b_DeviceSpeed;
            }
        }
        else
        {
            ETG_TRACE_FATAL(("bFilterIsTelematicsBox: check configuration of bFilterIsTelematicsBox with iMaxSizeOfArray"));
        }
    }
    else
    {
        ETG_TRACE_ERRMEM(("vFillDeviceSpeed: check configuration of bFilterIsTelematicsBox with iMaxSizeOfArray"));
    }
    ETG_TRACE_USR4(("Leaving  : vSetTelematicsBoxDeviceSpeed"));
}

/*-----------------------------------------------------------------------------*
 * void bIsEnabled_IStateTableHWMalfunction
 *-----------------------------------------------------------------------------*/
bool ConfigurationManager::bIsEnabled_IStateTableHWMalfunction()
{
    bool bRet = true;

    //adjust bRet in dependency of corresponding configuration value i.e. that which is bound to temporarily not available
    if(DVM_OFF == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_MALFUNCTION_USBCONNECTORS))
    {
        bRet = false;
    }

    if(bRet == false)
    {
        ETG_TRACE_FATAL(("ConfigurationManager::bIsEnabled_IStateTableHWMalfunction(): Interface is called despite it is disabled"));
        ETG_TRACE_ERRMEM(("ConfigurationManager::bIsEnabled_IStateTableHWMalfunction(): Interface is called despite it is disabled"));
        DVM_NORMAL_M_ASSERT_ALWAYS(); //to get callstack in errmem to find out which function is called which is not allowed to be called
    }
    return bRet;
}



/*-----------------------------------------------------------------------------*
 * bIsEnabled_IStateTableHWSignals
 *-----------------------------------------------------------------------------*/
bool ConfigurationManager::bIsEnabled_IStateTableHWSignals()
{
    bool bRet = true;

    //adjust bRet in dependency of corresponding configuration value i.e. that which is bound to temporarily not available
    if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_MALFUNCTION_USBCONNECTORS))
    {
        bRet = false;
    }


    if(bRet == false)
    {
        ETG_TRACE_FATAL(("ConfigurationManager::bIsEnabled_IStateTableHWSignals(): Interface is called despite it is disabled"));
        ETG_TRACE_ERRMEM(("ConfigurationManager::bIsEnabled_IStateTableHWSignals(): Interface is called despite it is disabled"));
        DVM_NORMAL_M_ASSERT_ALWAYS(); //to get callstack in errmem to find out which function is called which is not allowed to be called
    }
    return bRet;
}


/*-----------------------------------------------------------------------------*
 * void Constructor and Destructor
 *-----------------------------------------------------------------------------*/
ConfigurationManager::ConfigurationManager()
{
    bCheckConsistencyOfConfigValues();//Used to check confliting configuration parameters are not enabled for the project is defined in ConfigurationBase

    InitEclapsedTime_ms(); //set representative start time of VD_DVM

}
ConfigurationManager::~ConfigurationManager()
{
}

/*-----------------------------------------------------------------------------*
 * tBool vGetConfigurationValue()
 *-----------------------------------------------------------------------------*/
tBool ConfigurationManager::vGetConfigurationValue(IN const char* f_strConfigParam,OUT tU16 &u16ConfigValue) const
{
    ETG_TRACE_USR4(("Begin: vGetConfigurationValue"));
    tBool bRet = TRUE;

    if(f_strConfigParam)
    {
        ETG_TRACE_USR4(("vGetConfigurationValue Configuration parameter need to be fetched is : %s", f_strConfigParam));

        tenDevManagerConfigValue eTypeOfConfigValue = eCONF_LAST_ELEMENT;

        if(TRUE == isConfigParamAllowedTobeFetched(f_strConfigParam,eTypeOfConfigValue))
        {
            ETG_TRACE_USR4(("vGetConfigurationValue Configuration parameter %s is allowed to be fetched ",f_strConfigParam));
            u16ConfigValue = u16GetConfigurationValue(eTypeOfConfigValue);
            ETG_TRACE_USR4(("vGetConfigurationValue: the value of Configuration param %d ",u16ConfigValue));
        }
        else
        {
            ETG_TRACE_FATAL(("vGetConfigurationValue: The Configuration parameter %s is not allowed to be fetched!!!",f_strConfigParam));
            bRet = FALSE;
        }
    }
    else
    {
        ETG_TRACE_FATAL(("[ERROR] vGetConfigurationValue: f_strConfigParam==NULL!"));
    }

    ETG_TRACE_USR4(("End: vGetConfigurationValue"));
    return bRet;
}

/*-----------------------------------------------------------------------------*
 * tBool vSetConfigurationValue()
 *-----------------------------------------------------------------------------*/
tBool ConfigurationManager::vSetConfigurationValue(IN const char* f_strConfigParam,IN tU16 u16ConfigValue,IN tenSettingsMode eSettingsMode)
{
    ETG_TRACE_USR4(("Begin: vSetConfigurationValue"));
    tBool bRet = TRUE;

    if(f_strConfigParam)
    {
        ETG_TRACE_USR4(("vSetConfigurationValue Configuration parameter whoes value need to be Set is : %s", f_strConfigParam));
        ETG_TRACE_USR4(("vSetConfigurationValue Settings Mode(Permanent, Temporary, default) is : %d", eSettingsMode));




        tenDevManagerConfigValue eTypeOfConfigValue = eCONF_LAST_ELEMENT;

        //------------------------------------------
        //if parameter is allowed to be set then this is done
        //------------------------------------------
        if(TRUE == isConfigParamAllowedTobeFetched(f_strConfigParam,eTypeOfConfigValue))
        {
            ETG_TRACE_USR4(("vSetConfigurationValue Config parameter %s is allowed to be set ",f_strConfigParam));
            vSetConfigurationValue(eTypeOfConfigValue,u16ConfigValue);

            //--------------------------------------------------------------------------
            //automatically set dependent values concerning eCONF_ENABLE_HUBandPORTSatUSB1,2,3,4
            //-------------------------------------------------------------------------
            if(  (eTypeOfConfigValue>=eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1)
               &&(eTypeOfConfigValue<=eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB4))
            {
                int iOffset = (int)eTypeOfConfigValue - (int)eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1;
                if(DVM_ON == m_u16ConfigurationValue[(int)eCONF_ENABLE_HWInternalHUBRealizesUSB1+iOffset] )
                {
                    vSetConfigurationValue((tenDevManagerConfigValue)(eCONF_ENABLE_HUBandPORTSatUSB1+iOffset), u16ConfigValue);
                }
            }

            //-----------------------------------------
            //if required store it permanent using the datapool
            //-----------------------------------------
            if(eSettingsMode == PERMANENT)
            {
                ETG_TRACE_USR4(("vSetConfigurationValue the Config parameter %s need to be stored in persistent memory",f_strConfigParam));

                if(DVM_ON == u16GetConfigurationValue(eCONF_ENABLE_PERSISTENT_STORAGE_FOR_CONFIG_PARAMS))
                {
#if defined(VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL)  && !defined(VARIANT_S_FTR_ENABLE_UNITTEST)
                    //store in datapool
                    IConfigurationPersistent *l_pIFConfPersistentDataWriter = NULL;
                    l_pIFConfPersistentDataWriter = (IConfigurationPersistent*)new WriterDataPool();
                    if(l_pIFConfPersistentDataWriter && FALSE == l_pIFConfPersistentDataWriter->bWriteDataPool(eTypeOfConfigValue,u16ConfigValue))
                    {
                        ETG_TRACE_FATAL(("vSetConfigurationValue: Error while storing the configuration parameter %s in persistent memory",f_strConfigParam));
                        bRet = FALSE;
                    }
                    if(l_pIFConfPersistentDataWriter)
                    {
                        delete l_pIFConfPersistentDataWriter;
                        l_pIFConfPersistentDataWriter = NULL;
                    }
#endif//VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL
                }
                else
                {
                    ETG_TRACE_FATAL(("vSetConfigurationValue: Configuration parameter eCONF_ENABLE_PERSISTENT_STORAGE_FOR_CONFIG_PARAMS is not enabled. Not possible to store in persistent memory"));
                }

            }
        }
        else
        {
            ETG_TRACE_FATAL(("vSetConfigurationValue: The Configuration parameter %s is not allowed to be Set!!!",f_strConfigParam));
            bRet = FALSE;
        }
    }
    else
    {
        ETG_TRACE_FATAL(("[ERROR] vSetConfigurationValue: f_strConfigParam==NULL!"));
    }
    ETG_TRACE_USR4(("End: vSetConfigurationValue"));
    return bRet;

}

/*-----------------------------------------------------------------------------*
 * tBool isConfigParamAllowedTobeFetched()
 *-----------------------------------------------------------------------------*/
tBool ConfigurationManager::isConfigParamAllowedTobeFetched(IN const char* f_strConfigParam, OUT tenDevManagerConfigValue &enConfigValue) const
{
    ETG_TRACE_USR4(("Begin: isConfigParamAllowedTobeFetched"));
    tBool bRet = TRUE;
    tBool bFound = FALSE;
    for(unsigned int i = 0; i< (unsigned int)eCONF_LAST_ELEMENT; i++)
    {
        if(!((m_rConfigValueDescription[i].strConfigValue).compare(f_strConfigParam)))
        {
            ETG_TRACE_USR4(("isConfigParamAllowedTobeFetched match found for the configuration parameter %s",f_strConfigParam));
            bFound = TRUE;
            if(FALSE == m_rConfigValueDescription[i].bIsConfigurableFromOutside)
            {
                ETG_TRACE_FATAL(("isConfigParamAllowedTobeFetched the configuration parameter  %s is not allowed to set or get!!! ",f_strConfigParam));
                bRet = FALSE;
            }
            else
            {
                ETG_TRACE_USR4(("isConfigParamAllowedTobeFetched the configuration parameter  %s is allowed to set or get",f_strConfigParam));
                enConfigValue = m_rConfigValueDescription[i].enConfigValue;
            }
            break;
        }
    }
    if(FALSE == bFound)
    {
        ETG_TRACE_FATAL(("isConfigParamAllowedTobeFetched the configuration parameter  %s is not valid!!! ",f_strConfigParam));
        bRet = FALSE;
    }
    ETG_TRACE_USR4(("End: isConfigParamAllowedTobeFetched"));
    return bRet;


}


tU64 m_u64StartTime;

/*-----------------------------------------------------------------------------*
 * tU64 GetEclapsedTime()
 *-----------------------------------------------------------------------------*/
tU64 ConfigurationManager::GetEclapsedTime_ms()
{
    timespec tp;
#ifdef USE_ECLAPSEDTIME_UNIXEPOCHE
    int const iRes = clock_gettime(CLOCK_REALTIME, &tp);   //from UNIX epoche 1. jan1970
#else
    int const iRes = clock_gettime(CLOCK_MONOTONIC, &tp);  //from boot of system in bosch system
#endif
    DVM_NORMAL_M_ASSERT(0==iRes);

    tU64 u64CurrentTimeAbsolute = (tU64)((1000ll * tp.tv_sec) + (tU64)( ( ((double)tp.tv_nsec)/1000000.0 ) + 0.5) );

    return u64CurrentTimeAbsolute;

}

/*-----------------------------------------------------------------------------*
 * tU64 GetStartTime_ms()
 *-----------------------------------------------------------------------------*/
tU64 ConfigurationManager::GetStartTime_ms()
{
    return m_u64StartTime;
}

/*-----------------------------------------------------------------------------*
 * tU64 GetEclapsedTime()
 *-----------------------------------------------------------------------------*/
tU64 ConfigurationManager::InitEclapsedTime_ms()
{
    timespec tp;

#ifdef USE_ECLAPSEDTIME_UNIXEPOCHE
    int const iRes = clock_gettime(CLOCK_REALTIME, &tp);//start at  UNIX  Epoche which is defined as the time 00:00:00 UTC on 1 January 1970 (or 1970-01-01T00:00:00Z ISO 8601).
#else
    int const iRes = clock_gettime(CLOCK_MONOTONIC, &tp);//Clock that cannot be set and represents monotonic time since some unspecified starting point. In our system seems to be bound to boot
#endif

    if(iRes == -1)
    {
        ETG_TRACE_ERR(("InitEclapsedTime_ms: ERROR clock_gettime "));
    }

    //DVM_NORMAL_M_ASSERT(0==iRes);
    m_u64StartTime = (tU64)( (1000ll * tp.tv_sec) + (tU64)( ( ((double)tp.tv_nsec)/1000000.0 ) + 0.5) );


    ETG_TRACE_COMP(("=========================================================="));
    EtgTraceU64Value((char*)"VD_DEVICEMANAGER STARTTIME (ms) : ",m_u64StartTime,LEVEL_COMP);
    EtgTraceU64Value((char*)"VD_DEVICEMANAGER STARTTIME (sec): ",m_u64StartTime/1000,LEVEL_COMP);

    ETG_TRACE_SYS(("==========================================================="));

    return m_u64StartTime;
}

void ConfigurationManager::InformIfTestmode(char* strFunctionName, tU64 u64TestValue)
{
    if(u64TestValue>0)
    {
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT
        printf("[INFO]: %s executed in Testmode  - u64TestValue:%" PRId64 "\n",strFunctionName,u64TestValue);
#else
        printf("[INFO]: %s executed in Testmode  - u64TestValue:%llu\n",strFunctionName,(long long unsigned int)u64TestValue);
#endif
#else
        char strNum[80] /*max of tU64 uses20 characters*/;
        snprintf(strNum,sizeof(strNum),"%s executed in Testmode - u64TestValue:%llu",strFunctionName, (long long unsigned int)u64TestValue);
        ETG_TRACE_FATAL(("!!!!!!!!!!!!!!!!!!"));
        ETG_TRACE_FATAL(("[ERROR]: %s", strNum));
        ETG_TRACE_FATAL(("!!!!!!!!!!!!!!!!!!"));

        ETG_TRACE_ERRMEM(("!!!!!!!!!!!!!!!!!!"));
        ETG_TRACE_ERRMEM(("[ERROR]:NOT ALLOWED %s", strNum));
        ETG_TRACE_ERRMEM(("!!!!!!!!!!!!!!!!!!"));
        DVM_NORMAL_M_ASSERT_ALWAYS();
#endif
    }
}

void ConfigurationManager::EtgTraceU64Value(char* strDescriptionText_80characters, tU64 u64Value, tU8 u8Level)
{

#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT
    (void)u8Level;
    printf("%s %" PRId64 "\n",strDescriptionText_80characters, u64Value);
#else
    printf("%s %llu\n",strDescriptionText_80characters, (long long unsigned int)u64Value);
#endif
#else
        char strNum[256]; // Note: exaclty speaking max size 80+20 would be ok (max of tU64 uses20 characters 2^64)*/
        snprintf(strNum,sizeof(strNum),"%s %llu",strDescriptionText_80characters, (long long unsigned int)u64Value);

        switch(u8Level)
        {
            case LEVEL_FATAL:
                ETG_TRACE_FATAL(("%s",strNum));
                break;
            case LEVEL_COMP:
                ETG_TRACE_USR4(("%s",strNum));
                break;
            case LEVEL_USR4:
                ETG_TRACE_USR4(("%s",strNum));
                break;
            default:
                ETG_TRACE_USR4(("%s",strNum));
                break;
        }

#endif
}




tVoid ConfigurationManager::vPrintConfigurationUSBConnectorMapping() const
{
     ETG_TRACE_COMP(("[ok] ********************** vPrintConfigurationUSBConnectorMapping()*********************************" ));

     tInt i;

     //usb connectors are enabled to be used:
     for(i = eCONF_ENABLE_USB1; i<(tInt)eCONF_ENABLE_USB4; i++ )
     {
         ETG_TRACE_COMP(("[ok] --- value: %d for %d                ",m_u16ConfigurationValue[i],
                         ETG_CENUM(tenDevManagerConfigValue,(tenDevManagerConfigValue)i) ));
     }

     //hubs plus num of ports enabled to be used at certain usb connectors
     for(i = eCONF_ENABLE_HUBandPORTSatUSB1; i<(tInt)eCONF_ENABLE_HUBandPORTSatUSB4; i++ )
     {
         ETG_TRACE_COMP(("[ok] --- value: %d for %d                ",m_u16ConfigurationValue[i],
                         ETG_CENUM(tenDevManagerConfigValue,(tenDevManagerConfigValue)i) ));
     }

     //hubs at certain usb connectors are provided by the customer which has to give warranty that's why these are observed to be connected - if not diaglog is informed
     for(i =  eCONF_ENABLE_observeDTC_HUBatUSB1; i<(tInt) eCONF_ENABLE_observeDTC_HUBatUSB4; i++ )
     {
         ETG_TRACE_COMP(("[ok] --- value: %d for %d                ",m_u16ConfigurationValue[i],
                         ETG_CENUM(tenDevManagerConfigValue,(tenDevManagerConfigValue)i) ));
     }

     //not implmented: IT was planned to disable power of those usb conectors which are not planned to be used by the customer
     for(i =  eCONF_ENABLE_HW_USB1; i<(tInt) eCONF_ENABLE_HW_USB4; i++ )
     {
         ETG_TRACE_COMP(("[ok] --- value: %d for %d                ",m_u16ConfigurationValue[i],
                         ETG_CENUM(tenDevManagerConfigValue,(tenDevManagerConfigValue)i) ));
     }

     //signal source mapping is relevant for switching on and off VBUS for certain connectors (diagnosis uses this feature) .
     //prm sends HW signals which are used to send temporary or permanent unavailability of devices and inform diagnosis about such a failure
     for(i =  eCONF_HWSIGNAL_SOURCE_USB1; i<(tInt) eCONF_HWSIGNAL_SOURCE_USB4; i++ )
     {
         ETG_TRACE_COMP(("[ok] --- value: %d for %d                ",m_u16ConfigurationValue[i],
                         ETG_CENUM(tenDevManagerConfigValue,(tenDevManagerConfigValue)i) ));
     }

     //in some projects some USB connectors at the outside of the target are realised with an internal HUB
     for(i =  eCONF_ENABLE_HWInternalHUBRealizesUSB1; i<(tInt) eCONF_ENABLE_HWInternalHUBRealizesUSB4; i++ )
     {
         ETG_TRACE_COMP(("[ok] --- value: %d for %d                ",m_u16ConfigurationValue[i],
                         ETG_CENUM(tenDevManagerConfigValue,(tenDevManagerConfigValue)i) ));
     }


     //in some projects where internal hub is used for test purpose also a HUB should be connectable at this internal HUB
     for(i =  eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1; i<(tInt) eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB4; i++ )
     {
         ETG_TRACE_COMP(("[ok] --- value: %d for %d                ",m_u16ConfigurationValue[i],
                         ETG_CENUM(tenDevManagerConfigValue,(tenDevManagerConfigValue)i) ));
     }

     ETG_TRACE_COMP(("************************** vPrintConfigurationUSBConnectorMapping()\\*********************************" ));
}


void ConfigurationManager::vPrintGenericKdsValuesDevicemanager()
{
    ETG_TRACE_COMP(("[ok] ********************** vPrintGenericKdsValuesDevicemanager()*********************************" ));
    tU8 l_u8Array[KDS_MAX_ENTRY_LENGTH];
    generickds_devicemanager readValues;
    generickds_devicemanager_dedcoded readValues_decoded;

    //error check to prevent exceptions with memcpy
    if(KDS_MAX_ENTRY_LENGTH < sizeof(generickds_devicemanager))
    {
        ETG_TRACE_FATAL(("[ERROR] vPrintGenericKdsValuesDevicemanager KDS_MAX_ENTRY_LENGTH (%d) to small:sizeof(generickds_devicemanager):%d "
            ,(int)KDS_MAX_ENTRY_LENGTH,sizeof(generickds_devicemanager)));
        return;
    }


    if(m_pIFConfPersistent) //member of base class
    {
        if(m_pIFConfPersistent->GetTypeOfReader() == IConfigurationPersistent::eReader_KDS)
        {
            if(GENERIC_KDS_ADDRESS_DEVICEMANAGER_ARRAYOFVALUES_BYTELEN == sizeof(generickds_devicemanager))
            {
                if(TRUE==m_pIFConfPersistent->bReadKDS(GENERIC_KDS_ADDRESS_DEVICEMANAGER,
                                                       GENERIC_KDS_ADDRESS_DEVICEMANAGER_ARRAYOFVALUES_BYTELEN,
                                                       l_u8Array))
                {
                    //copy values to struct generickds_devicemanager
                    memcpy(&readValues, l_u8Array, sizeof(generickds_devicemanager));

                    //Robust approach: since diagnosis may not have written end of string to strings we add one at the end to be on the secure side
                    int len = sizeof(readValues.Tag);
                    memcpy(readValues_decoded.Tag,readValues.Tag, len);
                    readValues_decoded.Tag[len] = '\0';

                    len = sizeof(readValues.MajorVersion);
                    memcpy(readValues_decoded.MajorVersion,readValues.MajorVersion,len);
                    readValues_decoded.MajorVersion[len] = '\0';

                    len = sizeof(readValues.MinorVersion);
                    memcpy(readValues_decoded.MinorVersion,readValues.MinorVersion,len);
                    readValues_decoded.MinorVersion[len] = '\0';

                    len = sizeof(readValues.Subvariants);
                    memcpy(readValues_decoded.Subvariants,readValues.Subvariants,len);
                    readValues_decoded.Subvariants[len] = '\0';

                    //Function is triggered per TTFIS only that's why we use Fatal trace
                    ETG_TRACE_FATAL(("==============================================================================================================="));
                    ETG_TRACE_FATAL(("[INFO] vPrintGenericKdsValuesDevicemanager: readValues_decoded.Tag          :%s",readValues_decoded.Tag ));
                    ETG_TRACE_FATAL(("[INFO]vPrintGenericKdsValuesDevicemanager: readValues_decoded.MajorVersion :%s",readValues_decoded.MajorVersion));
                    ETG_TRACE_FATAL(("[INFO]vPrintGenericKdsValuesDevicemanager: readValues_decoded.MinorVersion :%s",readValues_decoded.MinorVersion));
                    ETG_TRACE_FATAL(("[INFO]vPrintGenericKdsValuesDevicemanager: readValues_decoded.Subvariants  :%s",readValues_decoded.Subvariants));
                    ETG_TRACE_FATAL(("==============================================================================================================="));

                    //further values could be shown here later - currrent approach aims on Subvariant so we stop here


                }
            }
            else
            {
                ETG_TRACE_FATAL(("[ERROR] :vPrintGenericKdsValuesDevicemanager: sizeof(generickds_devicemanager) != GENERIC_KDS_ADDRESS_DEVICEMANAGER_ARRAYOFVALUES_BYTELEN (%d != %d)",
                    sizeof(generickds_devicemanager),(int)GENERIC_KDS_ADDRESS_DEVICEMANAGER_ARRAYOFVALUES_BYTELEN));
            }
        }
        else
        {
            ETG_TRACE_COMP(("[INFO]: vPrintGenericKdsValuesDevicemanager:m_pIFConfPersistent is not Type KDS")); //e.g. for GM which uses EOL this is the case
        }
    }
    else
    {
       ETG_TRACE_COMP(("[INFO]: vPrintGenericKdsValuesDevicemanager:m_pIFConfPersistent==NULL"));
    }


    ETG_TRACE_COMP(("************************** vPrintConfigurationUSBConnectorMapping()\\*********************************" ));

}

void ConfigurationManager::vPrintGenericKdsValuesMediaplayer()
{
    ETG_TRACE_COMP(("[ok] ********************** vPrintGenericKdsValuesMediaplayer()*********************************" ));
    tU8 l_u8Array[KDS_MAX_ENTRY_LENGTH];
    generickds_mediaplayer readValues;
    generickds_mediaplayer_decoded readValues_decoded;

    //error check to prevent exceptions with memcpy
    if(KDS_MAX_ENTRY_LENGTH < sizeof(generickds_mediaplayer))
    {
        ETG_TRACE_FATAL(("[ERROR] vPrintGenericKdsValuesMediaplayer KDS_MAX_ENTRY_LENGTH (%d) to small:sizeof(generickds_mediaplayer):%d "
            ,(int)KDS_MAX_ENTRY_LENGTH,sizeof(generickds_mediaplayer)));
        return;
    }

    if(m_pIFConfPersistent) //member of base class
    {
        if(m_pIFConfPersistent->GetTypeOfReader() == IConfigurationPersistent::eReader_KDS)
        {
            if(sizeof(generickds_mediaplayer) == GENERIC_KDS_ADDRESS_MEDIAPLAYER_ARRAYOFVALUES_BYTELEN)
            {
                if(TRUE==m_pIFConfPersistent->bReadKDS(GENERIC_KDS_ADDRESS_MEDIAPLAYER,
                                                       GENERIC_KDS_ADDRESS_MEDIAPLAYER_ARRAYOFVALUES_BYTELEN,
                                                       l_u8Array))
                {
                    //copy values to struct generickds_mediaplayer
                    memcpy(&readValues, l_u8Array, sizeof(generickds_mediaplayer));

                    //Robust approach: since diagnosis may not have written end of string to strings we add one at the end to be on the secure side
                    int len = sizeof(readValues.RegistryFile);
                    memcpy(readValues_decoded.RegistryFile,readValues.RegistryFile, len);
                    readValues_decoded.RegistryFile[len] = '\0'; // sim4hi: fix for Coverity CID-82167

                    //Function is triggered per TTFIS only that's why we use Fatal trace
                    ETG_TRACE_FATAL(("==============================================================================================================="));
                    ETG_TRACE_FATAL(("[INFO]vPrintGenericKdsValuesDevicemanager: readValues_decoded.RegistryFile :%s",readValues_decoded.RegistryFile ));
                    ETG_TRACE_FATAL(("==============================================================================================================="));
                }
            }
            else
            {
                ETG_TRACE_FATAL(("[ERROR] : vPrintGenericKdsValuesMediaplayer:sizeof(generickds_devicemanager) != GENERIC_KDS_ADDRESS_DEVICEMANAGER_ARRAYOFVALUES_BYTELEN (%d != %d)",
                    sizeof(generickds_devicemanager),(int)GENERIC_KDS_ADDRESS_DEVICEMANAGER_ARRAYOFVALUES_BYTELEN));
            }
        }
        else
        {
            ETG_TRACE_COMP(("[INFO]: vPrintGenericKdsValuesMediaplayer:m_pIFConfPersistent is not Type KDS")); //e.g. for GM which uses EOL this is the case
        }
    }
    else
    {
       ETG_TRACE_COMP(("[INFO]: vPrintGenericKdsValuesMediaplayer:m_pIFConfPersistent==NULL"));
    }


    ETG_TRACE_COMP(("************************** vPrintGenericKdsValuesMediaplayer()\\*********************************" ));

}



tVoid ConfigurationManager::vPrintRNAIVKdsValuesMediaplayerFeaDVD()
{
    ETG_TRACE_COMP(("[ok] ********************** vPrintRNAIVKdsValuesMediaplayerFeaDVD()*********************************" ));

    tU8 l_u8Array[KDS_MAX_ENTRY_LENGTH];
    tU8 l_Bit7 = 0;

     //error check to prevent exceptions with memcpy
     if(KDS_MAX_ENTRY_LENGTH < sizeof(generickds_mediaplayer))
     {
         ETG_TRACE_FATAL(("[ERROR] vPrintRNAIVKdsValuesMediaplayerFeaDVD KDS_MAX_ENTRY_LENGTH (%d) to small:sizeof(generickds_mediaplayer):%d "
             ,(int)KDS_MAX_ENTRY_LENGTH,sizeof(generickds_mediaplayer)));
         return;
     }

     if(m_pIFConfPersistent) //member of base class
     {
         if(m_pIFConfPersistent->GetTypeOfReader() == IConfigurationPersistent::eReader_KDS)
         {
             if(KDS_MAX_ENTRY_LENGTH >= RNAIVI_KDS_ADDRESS_CMVARIANTCODING_ARRAYOFVALUES_BYTELEN)
             {
                 if(TRUE==m_pIFConfPersistent->bReadKDS(RNAIVI_KDS_ADDRESS_CMVARIANTCODING,
                                                        RNAIVI_KDS_ADDRESS_CMVARIANTCODING_ARRAYOFVALUES_BYTELEN,
                                                        l_u8Array))
                 {
                     //copy values to struct generickds_mediaplayer
                    if((l_u8Array[4]/*byte 4*/ & 0x80) == 0x80)
                    {
                        l_Bit7 = 1;
                    }


                     //Function is triggered per TTFIS only that's why we use Fatal trace
                     ETG_TRACE_FATAL(("==============================================================================================================="));
                     ETG_TRACE_FATAL(("[INFO]vPrintRNAIVKdsValuesMediaplayerFeaDVD: CMVariantCoding.HW Assembly Info.DVD :%d",l_Bit7 ));
                     ETG_TRACE_FATAL(("==============================================================================================================="));
                 }
             }
             else
             {
                 ETG_TRACE_FATAL(("[ERROR] : KDS_MAX_ENTRY_LENGTH >= RNAIVI_KDS_ADDRESS_CMVARIANTCODING_ARRAYOFVALUES_BYTELEN (%d != %d)",
                     (int)KDS_MAX_ENTRY_LENGTH,(int)RNAIVI_KDS_ADDRESS_CMVARIANTCODING_ARRAYOFVALUES_BYTELEN));
             }
         }
         else
         {
             ETG_TRACE_COMP(("[INFO]: vPrintRNAIVKdsValuesMediaplayerFeaDVD:m_pIFConfPersistent is not Type KDS")); //e.g. for GM which uses EOL this is the case
         }
     }
     else
     {
        ETG_TRACE_COMP(("[INFO]: vPrintRNAIVKdsValuesMediaplayerFeaDVD:m_pIFConfPersistent==NULL"));
     }
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
    (void)l_Bit7; //supress compiler warning
#endif

    ETG_TRACE_COMP(("************************** vPrintRNAIVKdsValuesMediaplayerFeaDVD()\\*********************************" ));
}

tVoid ConfigurationManager::vPrintRNAIVDatapoolValuesMediaplayerFeaDVD()
{
    ETG_TRACE_COMP(("[ok] ********************** vPrintRNAIVDatapoolValuesMediaplayerFeaDVD()*********************************" ));


#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#if (defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_PSARCC) || defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_G3G))
#ifdef USE_DATAPOOL_INSTEADOF_KDS
   tU8 u8DVD;
   tS32 s32Res = DP_s32GetConfigItem("CMVariantCoding", "DVD", &u8DVD, sizeof(tU8));
   if ( s32Res == DP_S32_NO_ERR )
   {
       //Function is triggered per TTFIS only that's why we use Fatal trace
       ETG_TRACE_FATAL(("==============================================================================================================="));
       ETG_TRACE_FATAL(("[INFO]vPrintRNAIVDatapoolValuesMediaplayerFeaDVD: CMVariantCoding.HW Assembly Info.DVD :%d",u8DVD ));
       ETG_TRACE_FATAL(("==============================================================================================================="));
   }
   else
   {
       ETG_TRACE_FATAL(("[ERROR] vPrintRNAIVDatapoolValuesMediaplayerFeaDVD: Could not read u8DVD with 'DP_s32GetConfigItem'"))
   }

#endif //USE_DATAPOOL_INSTEADOF_KDS
#endif //#if (defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_PSARCC) || defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_G3G))
#endif //VARIANT_S_FTR_ENABLE_UNITTEST

    ETG_TRACE_FATAL(("************************** vPrintRNAIVDatapoolValuesMediaplayerFeaDVD()\\*********************************" ));
}



tVoid ConfigurationManager::vPrintRNAIVKdsValuesMediaplayerReagionJapan()
{
    ETG_TRACE_FATAL(("[ok] ********************** vPrintRNAIVKdsValuesMediaplayerReagionJapan()*********************************" ));

    ETG_TRACE_FATAL(("[INFO] vPrintRNAIVKdsValuesMediaplayerReagionJapan: kds address unknown - not added to diagnosis document"))

    ETG_TRACE_FATAL(("************************** vPrintRNAIVKdsValuesMediaplayerReagionJapan()\\*********************************" ));
}


tVoid ConfigurationManager::vPrintRNAIVDatapoolValuesMediaplayerReagionJapan()
{
    ETG_TRACE_FATAL(("[ok] ********************** vPrintRNAIVDatapoolValuesMediaplayerReagionJapan()*********************************" ));

//see: https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-821714/Alliance_IVI_DiagnosticServices_V3.7.pdf
//Fund this 5 Bit [0x00] US [0x01] CAN [0x02] MEX [0x03] UK [0x04] TKY [0x05] RUS [0x06] other EUR [0x07] PRC [0x08] TWN [0x09] HKG/Macau
//[0x0A]GCC [0x0B] EGP [0x0C] ASR/NZE [0x0D] BRA [0x0E] AGT [0x0F] other LAC [0x10] SAF [0x11] THI [0x12] SGP [0x13] MLY [0x14] BRN [0x15] INN
//[0x16] VNM [0x17] PHL [0x18] IND [0x19] JPN [0x1A] KOR [0x1B] other GOM [0x1C] ISR
    enum enAIVIRegion
    {
        eUS        = 0x00,
        eCAN       = 0x01,
        eMEX       = 0x02,
        eUK        = 0x03,
        eTKY       = 0x04,
        eRUS       = 0x05,
        eOtherEU   = 0x06,
        ePRC       = 0x07,
        eTWN       = 0x08,
        eHKG_Macau = 0x09,
        eGCC       = 0x0A,
        eEGP       = 0x0B,
        eASR_NZE   = 0x0C,
        eBRA       = 0x0D,
        eAGT       = 0x0E,
        eOtherLAC  = 0x0F,
        eSAF       = 0x10,
        eTHI       = 0x11,
        eSGP       = 0x12,
        eMLY       = 0x13,
        eBRN       = 0x14,
        eINN       = 0x15,
        eVNM       = 0x16,
        ePHL       = 0x17,
        eIND       = 0x18,
        eJPN       = 0x19, //25 decimal
        eKOR       = 0x1A,
        eOtherGOM  = 0x1B,
        eISR       = 0x1C,
        eLastVal   = 0x1D
    };

    std::string strRegionName[eLastVal];

    strRegionName[eUS]         = "US";
    strRegionName[eCAN]        = "CAN";
    strRegionName[eMEX]        = "MEX";
    strRegionName[eUK]         = "UK";
    strRegionName[eTKY]        = "TKY";
    strRegionName[eRUS]        = "RUS";
    strRegionName[eOtherEU]    = "other EU";
    strRegionName[ePRC]        = "PRC";
    strRegionName[eTWN]        = "TWN";
    strRegionName[eHKG_Macau]  = "HKG / Macau";
    strRegionName[eGCC]        = "GCC";
    strRegionName[eEGP]        = "EGP";
    strRegionName[eASR_NZE]    = "ASR / NZE";
    strRegionName[eBRA]        = "BRA";
    strRegionName[eAGT]        = "AGT";
    strRegionName[eOtherLAC]   = "other LAC";
    strRegionName[eSAF]        = "SAF";
    strRegionName[eTHI]        = "THI";
    strRegionName[eSGP]        = "SGP";
    strRegionName[eMLY]        = "MLY";
    strRegionName[eBRN]        = "BRN";
    strRegionName[eINN]        = "INN";
    strRegionName[eVNM]        = "VNM";
    strRegionName[ePHL]        = "PHL";
    strRegionName[eIND]        = "IND";
    strRegionName[eJPN]        = "JPN";
    strRegionName[eKOR]        = "KOR";
    strRegionName[eOtherGOM]   = "other GOM";
    strRegionName[eISR]        = "ISR";



#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#if (defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_PSARCC) || defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_G3G))
#ifdef USE_DATAPOOL_INSTEADOF_KDS
    tU8 u8Region;
    tS32 s32Res = DP_s32GetConfigItem("VehicleInformation", "DestinationRegion1", &u8Region, sizeof(tU8));
    if ( s32Res == DP_S32_NO_ERR )
    {
        ETG_TRACE_FATAL(("==============================================================================================================="));
        ETG_TRACE_FATAL(("[INFO]vPrintRNAIVDatapoolValuesMediaplayerReagionJapan: VehicleInformation.DestinationRegion1:%d",u8Region ));
        if(u8Region<(int)eLastVal)
        {
            ETG_TRACE_FATAL(("[INFO]vPrintRNAIVDatapoolValuesMediaplayerReagionJapan: VehicleInformation.DestinationRegion1:%s",strRegionName[u8Region].c_str() ));
        }
        ETG_TRACE_FATAL(("==============================================================================================================="));
    }
    else
    {
        ETG_TRACE_FATAL(("[ERROR] vPrintRNAIVDatapoolValuesMediaplayerReagionJapan: Could not read u8Region with 'DP_s32GetConfigItem'"))
    }
#endif //USE_DATAPOOL_INSTEADOF_KDS
#endif //#if (defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_PSARCC) || defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_G3G))
#endif //VARIANT_S_FTR_ENABLE_UNITTEST

    ETG_TRACE_FATAL(("************************** vPrintRNAIVDatapoolValuesMediaplayerReagionJapan()\\*********************************" ));
}




////////////////////////////////////////////////////////////////////////////////
// <EOF>
