/*-----------------------------------------------------------------------------*
 * includes                                                                  *
 *-----------------------------------------------------------------------------*/
#include "Config.h"

#define INCLUDE_VD_DVM_OSAL
#define INCLUDE_VD_DVM_BASICS
#include "Common.h"
#include "Enums.h"


#include "config/ConfigurationBase.h"
/*
#include "config/ConfigurationProduct.h"
#include "config/IConfigurationPersistent.h"
#include "config/ReaderKDS.h"
*/

#include "IConfigurationPersistent.h"
#include "CommonReadRoutinesKds.h"
#include "config/ReaderKDS.h"


/*-----------------------------------------------------------------------------*
 * ETG Tracing                                                                 *
 *-----------------------------------------------------------------------------*/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_dvm.h"
     
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
  #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
  #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_DEVICEMANAGER_CONFIGMANAGER
  #include "trcGenProj/Header/CommonReadRoutinesKds.cpp.trc.h"
  #endif
  #include "ETGTrace.h"
#endif //VARIANT_S_FTR_ENABLE_UNITTEST



/*-----------------------------------------------------------------------------*
 * define                                                                 *
 *-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*
 * namespace                                                                 *
 *-----------------------------------------------------------------------------*/
using namespace configmgr;


/*-----------------------------------------------------------------------------*
 * constructor()  
 *-----------------------------------------------------------------------------*/
CommonReadRoutinesKds::CommonReadRoutinesKds()
{
    ETG_TRACE_USR4(("Begin: Constructor: CommonReadRoutinesKds() "));

    ETG_TRACE_USR4(("End  : Constructor: CommonReadRoutinesKds() "));
}

/*-----------------------------------------------------------------------------*
 * vInitCustomerValues                                                                 *
 *-----------------------------------------------------------------------------*/
void CommonReadRoutinesKds::vInitCustomerValues_G3G_USBExtendedInfo(IN IConfigurationPersistent *f_pIFConfPersistent, INOUT tU16 (&f_u16ConfigurationValue)[eCONF_LAST_ELEMENT])
{

/*
    reference see: Suzuki CM diagnostic services_v0.77 f
    in 5.1.6.13 CMVariantCoding

   references see: G3G kds - wating for Reference from Christoph Koytek

    KDS-Address: 0x0DF4
    Identifier: Identifier ($8100)
    byte index 13 also im 14. 

    Byte:13 	USB Extended Info 	HexDump (1 Byte) 
    bit0 - 1 	USB1 Extended Info 	CMUSBExtendedInfoType 
    bit2 - 3 	USB2 Extended Info 	CMUSBExtendedInfoType 
    bit4 - 7 	(reserved) 

     
    CMUSBExtendedInfoType 	2 Bit 
    [0x00] Unknown/HUB support
    [0x01] HUB not supported 
*/

    //read KDS values
    //die KDS Adresse SUZSLN Coding  lautet: 0x0DF4
    //die fuer Dich wichtigen Infos stehen in Byte 13 (dezimal) - Bit0:1 and Bit2:3 und wir fangen bei Byte 0 an zu z�hlen :
    //BIT0:0:1 : 00=HUB@USB1 Supported 
    //                 01= HUB@USB1 not supported
    //BIT0:2:3 : 00=HUB@USB2 Supported 
    //                 01= HUB@USB2 not supported

   
    tU8 l_u8Array[KDS_MAX_ENTRY_LENGTH];
    tU8 l_u8PayloadByte;
    tU8 l_Byte13_Bit0And1 = 0;
    tU8 l_Byte13_Bit2And3 = 0;
    
    if(f_pIFConfPersistent)
    {
        if(TRUE==f_pIFConfPersistent->bReadKDS(0x0DF4      /*address*/,
                                               14          /*len of bytes to read - we start to count with 0 as first byte i.e. byte 1 has index 0 byte 13 has index 14*/,
                                               l_u8Array))
        {
            l_u8PayloadByte = l_u8Array[13];

            l_Byte13_Bit0And1 = ((l_u8PayloadByte) & 0x03);   /*00000011=0x03 =  3*/
            l_Byte13_Bit2And3 = ((l_u8PayloadByte) & 0x0C)>>2;/*00001100=0x0C =  12*/

            ETG_TRACE_COMP(("vInitCustomerValues_G3G_USBExtendedInfo(G3G): KDSvalue 0x0DF4 read,    l_u8PayloadByte13 :  0x%x", l_u8PayloadByte));
            ETG_TRACE_COMP(("vInitCustomerValues_G3G_USBExtendedInfo(G3G):                          l_Byte13_Bit0And1 :  0x%x", l_Byte13_Bit0And1));
            ETG_TRACE_COMP(("vInitCustomerValues_G3G_USBExtendedInfo(G3G):                          l_Byte13_Bit2And3 :  0x%x", l_Byte13_Bit2And3));

            //-------------
            //HUB at USB1
            //------------
            //SUZUKI - in Suzuki the IMX connectors are at the outside of the target
            //syspath of  IMXConnector contains "/2184200.usb/";  //IMXConnectorUSB1    - number at the outside of the target: USB1
            //syspath of  IMXConnector contains "/2184000.usb/";  //IMXConnectorUSB2    - number at the outside of the target  USB2

            //CAF - assume the same configuration like Suzuki 

            //RNAIVI - in RNAIVI 

            switch(l_Byte13_Bit0And1)
            {
                case ((tU8)enHUBSupported_NO):
                     f_u16ConfigurationValue[eCONF_ENABLE_IMX_HOST_USB_2184200_ALLOWHUB]  = DVM_OFF;   //mean USB at IMX-USBConnector 1
                     break;
                case ((tU8)enHUBSupported_YES):
                     f_u16ConfigurationValue[eCONF_ENABLE_IMX_HOST_USB_2184200_ALLOWHUB]  = DVM_ON;   //mean USB at IMX-USBConnector 1
                     break;
                 default:
                    ETG_TRACE_FATAL(("vInitCustomerValues_G3G_USBExtendedInfo(G3G): Not supported value check KDS-values (l_Byte13_Bit0And1 - HUB@USB1) !!!"));
                    break;
            }
            //-------------
            //HUB at USB2
            //-------------
            switch(l_Byte13_Bit2And3)
            {
                case ((tU8)enHUBSupported_NO):
                     f_u16ConfigurationValue[eCONF_ENABLE_IMX_OTG__USB_2184000_ALLOWHUB]  = DVM_OFF;   //mean USB at IMX-USBConnector 2
                     break;
                case ((tU8)enHUBSupported_YES):
                     f_u16ConfigurationValue[eCONF_ENABLE_IMX_OTG__USB_2184000_ALLOWHUB]  = DVM_ON;   //mean USB at IMX-USBConnector 2
                     break;
                 default:
                    ETG_TRACE_FATAL(("vInitCustomerValues_G3G_USBExtendedInfo(G3G): Not supported value check KDS-values (l_Byte13_Bit2And3 - HUB@USB1) !!!"));
                    break;
            }

        }
        else
        {
            ETG_TRACE_FATAL(("vInitCustomerValues_G3G_USBExtendedInfo: failed to Read configuration 0x0DF4 from KDS"));
            ETG_TRACE_ERRMEM(("vInitCustomerValues_G3G_USBExtendedInfo: failed to Read configuration 0x0DF4 from KDS"));
        }
    }
    else
    {
        ETG_TRACE_FATAL(("vInitCustomerValues_G3G_USBExtendedInfo:f_pIFConfPersistent = NULL"));
        ETG_TRACE_ERRMEM(("vInitCustomerValues_G3G_USBExtendedInfo:f_pIFConfPersistent = NULL"));
    }

    ETG_TRACE_USR4(("vInitCustomerValues_G3G_USBExtendedInfo:  f_u16ConfigurationValue[eCONF_ENABLE_IMX_HOST_USB_2184200_ALLOWHUB]:%d", f_u16ConfigurationValue[eCONF_ENABLE_IMX_HOST_USB_2184200_ALLOWHUB]));
    ETG_TRACE_USR4(("vInitCustomerValues_G3G_USBExtendedInfo:  f_u16ConfigurationValue[eCONF_ENABLE_IMX_OTG__USB_2184000_ALLOWHUB]:%d", f_u16ConfigurationValue[eCONF_ENABLE_IMX_OTG__USB_2184000_ALLOWHUB]));
}

void CommonReadRoutinesKds::vInitCustomerValues_G3G_ConfigureUSBConnectors(IN IConfigurationPersistent *f_pIFConfPersistent, OUT tU16 (&f_u16ConfigurationValue)[eCONF_LAST_ELEMENT])
{
    //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    //WILL BE IMPORTANT FOR SCOPE2 and further hardware
    //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    //tbd read kds value which will be defined in g3g and bound to teStringMatchers
    //teStringMatchers help to  set this configuration with this m_rCustomerUSBConnectorConfig[eUSB1 - eUSB3] 
    //this function has to be called after hard coded initialisation has been done which is in ConfigrationProduct_Gen3_RNAIVI.cpp
}

////////////////////////////////////////////////////////////////////////////////
// <EOF>

