/*
 * etrace_dvm.h
 *
 *  Created on: 09.12, 2013
 *      Author: Christian Koechling
 */

#ifndef ETRACE_DVM_H_
#define ETRACE_DVM_H_


#ifdef USE_SYSLOG_TRACES
    #include "etrace_syslog.h"
#else
  #ifdef VARIANT_S_FTR_ENABLE_UNITTEST
    //#define TR_COMP_MC_MEDIAPLAYER 1 /*fake but gives compiler warning check that*/

    #include "etrace_unittest.h"
    
    //ASSERTS are treated different for product code and unittests
    #define DVM_FATAL_M_ASSERT_ALWAYS()   UTEST_FATAL_M_ASSERT_ALWAYS()
    #define DVM_FATAL_M_ASSERT(expr)      UTEST_FATAL_M_ASSERT(expr)

    #define DVM_NORMAL_M_ASSERT_ALWAYS()  UTEST_NORMAL_M_ASSERT_ALWAYS()
    #define DVM_NORMAL_M_ASSERT(expr)     UTEST_NORMAL_M_ASSERT(expr)

    
  #else
    #include "etrace_if.h"

    //ASSERTS are treated different for product code and unittests
    #define DVM_FATAL_M_ASSERT_ALWAYS()   FATAL_M_ASSERT_ALWAYS()
    #define DVM_FATAL_M_ASSERT(expr)      FATAL_M_ASSERT(expr)

    #define DVM_NORMAL_M_ASSERT_ALWAYS()  NORMAL_M_ASSERT_ALWAYS()
    #define DVM_NORMAL_M_ASSERT(expr)     NORMAL_M_ASSERT(expr)
  #endif //VARIANT_S_FTR_ENABLE_UNITTEST

#endif //USE_SYSLOG_TRACES


#endif //ETRACE_DVM_H_
////////////////////////////////////////////////////////////////////////////////
// <EOF>


