/*-----------------------------------------------------------------------------*
 * TimerDVM.h                                                      *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM G3G                                                   *
 * COPYRIGHT   : (c) 2014-2016  Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file TimerDVM.h
 *
 * \brief Adapter class (Wrapper) to ease replacing osal timer functions it uses gmp frame work timer
 *
 * \version 22.12.2014, Koechling Christian (CM-AI/ECD1), version 1.0 - first implementation to hand over 
 *  this to Rajeev Narayanan Sambhu (RBEI/ECS1)
 
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifndef TIMERDVM_H
#define TIMERDVM_H  

/*-----------------------------------------------------------------------------*
 * include declaration                                                           *
 *-----------------------------------------------------------------------------*/
#include "Config.h"
#include <string>
#include <vector>

#include "Timer.h"


typedef void (*tpfCallback) ( tPVoid );



/*-----------------------------------------------------------------------------*
 * defines                                                           *
 *-----------------------------------------------------------------------------*/
#define MAXNUM_DVMTIMERS (int)20

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class 
 */



class TimerDVM
{
    public:


        typedef enum
        {
            OK    = 0,
            ERROR = 1,
            /*more specific ERRORS*/
            ERROR_INVALID_HANDLE   = 2,
            ERROR_INVALID_CALLBACK = 3,
            ERROR_ALREADY_CREATED  = 4
        }tenReturn;

        /*!
         * \brief Default constructor
         */
        TimerDVM();

        /*!
         * \brief Destructor
         */
        virtual ~TimerDVM();



    public:
        /*!
         * \brief to replace tS32 s32TimerCreate(OSAL_tpfCallback pCallback,tPVoid pvArg, OSAL_tTimerHandle* phTimer);

         * some hint to types:
         *OSAL_tTimerHandle replaced by tU32 replaced by unsigned int*
         * tPVoid replaced by void *
         * found in ai_osal_common this 
        * typedef void (*OSAL_tpfCallback) ( tPVoid ); replaced by tpfCallback see above in this code - not sure yet if this works
         */
        int iTimerCreate(tpfCallback pCallback,void* pvArg, std::string strNameOfTimer);



        /*!
         * \brief to replace OSAL_s32TimerDelete(OSAL_tTimerHandle hTimer);
         * OSAL_tTimerHandle replaced by unsigned int 
         
         */
        int iTimerDelete();


              /*!
            * \brief to replace OSAL_s32TimerSetTime(OSAL_tTimerHandle hTimer,OSAL_tMSecond msec, OSAL_tMSecond interval);
            * OSAL_tTimerHandle replaced by unsigned int 
            * OSAL_tMSecond replaced by unsingned int
            */
        int iTimerStart(long timeMilliseconds,long intervalMilliseconds, void *pObject,Timer::tCallBackFn pCallBackFn, void *userData);


        tpfCallback mpCallback;


        static unsigned int  m_uiUsedTimerIDs;
      
        
        /*!
        * \brief stop the timer - is equivalent to iTimerSet(hTimer, 0 , 0) and thus could also replace directly OSAL_s32TimerSetTime hTimer,0, 0);
        */
        int iTimerStop();


    private:

        //gmp framework timer specific variables


        //gmp framework timer object

        Timer             mTimer;



        timer_t         mTimerID;


        //to check whether the timer has started or not.
        bool            m_isTimerCreated;
        bool            m_isTimerStarted;

        long int        m_hTimerDVMID;

        std::string     m_strNameOfTimer;


    


    protected:
        
        bool bCalcNewUniqID(INOUT unsigned int &f_iUsedTimerIDs, OUT long int &f_hTimerDVMID);

};
// class TimerDVM

#endif // TIMERDVM_H

////////////////////////////////////////////////////////////////////////////////
// <EOF>
