

/*-----------------------------------------------------------------------------*
 * ThreadFactoryDVM.cpp                                                    *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : G3G                                                   *
 * COPYRIGHT   : (c) 2012 - 2020 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*! 
 * \file ThreadFactoryDVM.cpp
 *
 * \brief Implementation of Thread- code based on version foundin Framework of GMP
 *
 * \version 10.06.2014, Koechling Christian (CM-AI/ECD1), initial version start to with objective to split VD_DVM into
*                                    2 libs: 1 Lib holding CCA_Dependencies and one for the rest which has dependencies to OSAL, LInux and basic cpp only
 *
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2020
 */

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"

#define INCLUDE_VD_DVM_OSAL
#define INCLUDE_VD_DVM_BASICS
#include "Common.h"

#include <iostream>
using namespace std;

#include <string.h>
#include <errno.h>
#include <sys/prctl.h>

 /*-----------------------------------------------------------------------------*
  * ETG Tracing                                                                 *
  *-----------------------------------------------------------------------------*/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_dvm.h"
     
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST  
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_DEVICEMANAGER_APPLICATION
#include "trcGenProj/Header/ThreadFactoryDVM.cpp.trc.h"
#endif

#include "ETGTrace.h"
#endif //VARIANT_S_FTR_ENABLE_UNITTEST

#include "LockDVM.h"
#include "ThreadFactoryDVM.h"

/*-----------------------------------------------------------------------------*
 * Singleton                                                                   *
 *-----------------------------------------------------------------------------*/
// static pointer used to ensure a single instance of vd_devicemanager_tclApp
ThreadFactoryDVM* ThreadFactoryDVM::m_pThreadFactoryDVM = NULL;
DVMLOCK           ThreadFactoryDVM::m_singelton;

/*-----------------------------------------------------------------------------*
 * ThreadFactoryDVM *ThreadFactoryDVM::GetInstance()
 *-----------------------------------------------------------------------------*/
ThreadFactoryDVM *ThreadFactoryDVM::GetInstance()
{
    ETG_TRACE_USR4(("Begin: GetInstance"));
    ThreadFactoryDVM::m_singelton.lock();
    if(NULL == m_pThreadFactoryDVM)
    {
        m_pThreadFactoryDVM = new ThreadFactoryDVM();
    }
    ThreadFactoryDVM::m_singelton.unlock();
    ETG_TRACE_USR4(("End  : GetInstance"));

    return m_pThreadFactoryDVM;
}

/*-----------------------------------------------------------------------------*
 * void ThreadFactoryDVM::DestroyInstance()
 *-----------------------------------------------------------------------------*/
void ThreadFactoryDVM::DestroyInstance()
{
    ThreadFactoryDVM::m_singelton.lock();
    ETG_TRACE_USR4(("Begin: DestroyInstance"));
    delete(m_pThreadFactoryDVM);
    m_pThreadFactoryDVM = NULL;
    ThreadFactoryDVM::m_singelton.unlock();
    ETG_TRACE_USR4(("End  : DestroyInstance"));
}

/*-----------------------------------------------------------------------------*
 * int ThreadFactoryDVM::Initialize()
 *-----------------------------------------------------------------------------*/
int ThreadFactoryDVM::Initialize() const
{
    tS32 s32RetVal = OSAL_ERROR;
    ETG_TRACE_USR4(("Begin: Initialize                                         "));
    if(m_pThreadFactoryDVM)
    {
        /*Create thread factory*/
        m_pThreadFactory->Create();
        s32RetVal = OSAL_OK;
    }
    ETG_TRACE_USR4(("End  : Initialize                                        "));

    return (int)s32RetVal;
}

ThreadFactoryDVM::ThreadFactoryDVM()
{
    m_pThreadFactory    = new ThreadFactory(VDDVM_NUMOFTHREADS);
}

ThreadFactory *ThreadFactoryDVM::GetThreadFactory(void)
{
    return GetInstance()->m_pThreadFactory;
}



