/*
 * LockDVM.cpp
 *
 *  Created on: , 2013
 *      Author: Christian Koechling
 */

#include "Config.h"
#include "LockDVM.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_dvm.h"

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_DEVICEMANAGER_UDEVMANAGER
#include "trcGenProj/Header/LockDVM.cpp.trc.h"
#endif
#include "ETGTrace.h"
#endif //VARIANT_S_FTR_ENABLE_UNITTEST


LockDVM::LockDVM()
{
    
}

LockDVM::~LockDVM()
{
   
}
int LockDVM::lock()
{
#ifdef SUSPICOUS_LOCKTIMOUT_SEC
    tBool bLockedOk = false;
    while(false == bLockedOk)
    {
        bLockedOk = lock((unsigned int)SUSPICOUS_LOCKTIMOUT_SEC);
        if(false == bLockedOk)
        {
           ETG_TRACE_FATAL(("[WARNING] LockDVM: SUSPICOUS_LOCKTIMOUT_SEC: %d ",(unsigned int)SUSPICOUS_LOCKTIMOUT_SEC));
           DVM_NORMAL_M_ASSERT_ALWAYS(); //to get callstack i.e. more information which thread hangs
        }
    }
    return 0; //success
#else
    return m_Lock.lock();
#endif
}

void LockDVM::unlock()
{
    m_Lock.unlock();
}



void LockDVM::setTimeout(const unsigned int sec)
{
    m_Lock.setTimeout(sec);
}

bool LockDVM::lock(unsigned int uiTimout_sec)
{
    bool bRet = false;
    
    m_Lock.setTimeout(uiTimout_sec);
    int iResult = m_Lock.lock();

    if(iResult == 0)
    {
        bRet = true;
    }


    return bRet;
}

