/*-----------------------------------------------------------------------------*
 * GenString.h                                                                    *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : Gen3                                                   *
 * COPYRIGHT   : (c) 2013 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*! 
 * \file Device.h
 *
 * \brief to replace QStrings in VD_DeviceManager this class has been added. In dependency of define USE_QSTRING
 *          in config.h either QStrings are used or stl-strings
 *
 * \version Initial Version
 * \version 23.10.2013, Koechling, Christian (Bosch)
 *
 *-----------------------------------------------------------------
 *									development for Gen3:
 *-----------------------------------------------------------------
 *\version 23.10.2013, Christian Koechling (Bosch) 
 *		  -# start tp replace QStrings by replacing QString by define GENSTRING
 *
 *          
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifndef __GENSTRING_H__
#define __GENSTRING_H__

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"
#include <string>

/*-----------------------------------------------------------------------------*
 * Defines                                                                     *
 *-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*
 * Namespaces                                                                  *
 *-----------------------------------------------------------------------------*/

using namespace std;


//Note: 
//ok   : usable with UTF coded string
//okl  : localy ok for using with UTF8 strings since e.g. search pattern in contains is ascii 0...128 ASCII
//nok : not ok if utf8 is  envolved

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class GenString
 *
 * \brief class to hold the properties of the device
 */

class GenString

{

    public:

        /*!
         * \brief Constructor - creates emtpy string
         */
        GenString(); ///ok
        
        /*!
         * \brief Constructor - creates string from pString
         */
        GenString(const char* pString);///ok

        /*!
         * \brief Constructor - creates string from std::string
         */
        GenString(std::string pString);///ok


        /*!
         * \brief Constructor - packs cChar into string i.e. Null terminated string
         */
        GenString(char cChar);///ok

        /*!
         * \brief Constructor - creates a string from an integer e.g. 111 gives "111"
         */
        GenString(int iNumber);///ok



     /*!
         * \brief Destructor
         */
        ~GenString();///ok


        //-------------------------------------------------------------
        //operator overloading
        //-------------------------------------------------------------
        /*!
          * \brief  add strings e.g. StringC = StringA + StringB or StringC = StringA +StringB +StringC
          */
        GenString operator+(const GenString& toAdd);///ok

        /*!
          * \brief  add strings e.g. StringB += StringA means StringB = StringB +StringA
          */
        GenString& operator+=(const GenString& toAdd);///ok

        
        /*!
          * \brief  Assigns other to this string and returns a reference to this string.
          */
        GenString& operator=(const GenString& oGenStringToSetThisOne);///ok
        
        /*!
          * \brief  Assigns charToSetThisOne to this string. The const char pointer is converted to Unicode using the fromAscii() function
          */
        GenString& operator=(const char*  charToSetThisOne);///ok

        /*!
          * \brief  Assigns charToSetThisOne to this string. The const char pointer is converted to Unicode using the fromAscii() function
          */
        GenString& operator=(const std::string& stdStringToSetThisOne);///ok


        /*!
          * \brief 
          */
        bool       operator==(GenString const& arg2toCompareWith1) const ;///ok

       /*!
        * \brief Overloading == with const char* to make it more efficient.
        */
        bool       operator==(const char* arg2toCompareWith1) const ;///ok

        /*!
          * \brief Returns true if s1 is not equal to s2; otherwise returns false.
          */
        bool       operator!=(GenString const& arg2toCompareWith1) const ;///ok


        //-------------------------------------------------------------
        //manipulations of string to retunr new string don't change existing one
        //-------------------------------------------------------------

        /*!
        * \brief Returns a string that has whitespace removed from the start and the end.  
        *  Whitespace means any character for which QChar::isSpace() returns true. This includes the ASCII characters '\t', '\n', '\v', '\f', '\r', and ' '.
        */
        GenString trimmed() const;  ///ok 

        /*!
        * \brief Returns a lowercase copy of the string.
        */
        GenString toLower() const; ///check used to lower serial ID of HUB and MAcdevice

        /*!
        * \brief Returns a substring that contains the n leftmost characters of the string.
                   The entire string is returned if n is greater than size() or less than zero.
        */
        GenString left(const int num) const; ///okl:used with signs 0...128 thus no problem if std::string is used

        /*!
        * \brief  Returns a substring that contains the n rightmost characters of the string.
                    The entire string is returned if n is greater than size() or less than zero.
        */
        GenString right(const int num) const;///okl:used with 

        /*!
        * \brief  Returns a string that contains n characters of this string, starting at the specified position index.
             Returns a null string if the position index exceeds the length of the string. If there are less 
              than n characters available in the string starting at the given position, or if n is -1 (default), the function returns all characters that are available from the specified position.
              pos starts with 0
        GenString x = "Nine pineapples";
        GenString y = x.mid(5, 4);            // y == "pine"
        */
        GenString mid( int position, int n) const; //okl: used in checkIf mounted





        //-------------------------------------------------------------
        //convert GenString into other format
        //-------------------------------------------------------------

        /*!
        * \brief  string converted to an int using base 10
        */
        int                   toInt() const; ///ok for device version and port number detection of HUB
        /*!
          * \brief 
          */

    

   
        std::string           toStdString() const ;//ok

  
        /*!
          * \brief 
          */
        tU16        Hex2UShort( ) const; //ok used for vendor and version of HUB could be replaced by toInt

        /*-----------------------------------------------------------------------------*
        * manipulate existing string                                                                  *
        *-----------------------------------------------------------------------------*/


        /*!
          * \brief 
          */
        GenString& append(const GenString& oGenStringToappend); ///ok

        /*!
          * \brief 
          */
        GenString& remove( int position, int n );//okl: used with ascii 0...127 only

     /*!
          * \brief 
          */
        GenString& remove( const GenString& oGenStringToRemove);//okl: used with ascii 0...127 only

        //-------------------------------------
        //get info about the string
        //-------------------------------------


         /*!
           * \brief       Returns the number of characters in this string without NULL termination
           */
        int  size() const; //nok repllaced by length
        
        /*!
          * \brief Returns the number of characters in this string. Equivalent to size().
          */
        int  length() const; //okl

        /*!
          * \brief  checkif string is emtpy
          *
          * \return [boot] true if empty else false
          */
        bool isEmpty() const; //ok

        /*!
          * \brief  checkif string is the same CASE SENSITIVE
          *
          * \return [int] 0:is equal 1:not equal
          */
        int  compare(const GenString& oGenStringToSearch) const;//ok
        int  indexOf(const char* charToSearch) const;//ok
        int  indexOf(const char* charToSearch,int from) const;//ok
        int  lastIndexOf( const GenString & oGenStringToFind, int from) const; //okl


        /*!
  * \brief 
  */
        GenString& replace(const GenString& oBefore,const GenString& oAfter); ///nok not used at all

#ifdef USE_VALIDATE_AND_CONVERT2REGION_LANGUAGE
        int  toAsciiSize() const;//nok gbk
        char toAsciiAt(unsigned int iIndex) const;//nok gbk
        const char*           toAscii() const;///nok used with GBK

        /*!
          * \brief 
          */
                /*!
          * \brief Returns the string in the given Unicode normalization mode.
          */
        GenString normalized( int iNormalizationForm ) const;///nok used with gbk
        
        /*!
          * \brief  Returns a QString initialized with the first size bytes of the UTF-8 string str.
          */
        GenString fromUtf8( const char * str) const;///nok used with gbk
               /*!
          * \brief 
          */
        GenString& replace(unsigned int uiPos,unsigned int uiLen, char cReplacer);///ok used in usbutils for ASCCII based routines - need to add routine to prevent different usage

        
        /*!
            * \brief 
            */
          const char*           toUtf8constData() const; //nok used in GBK-routine
#endif
        bool contains(const GenString& oGenStringToSearch,int iMode) const; //ok

       /*!
        * \brief Returns true if this string contains an occurrence of the string str; otherwise returns false.
        */
        bool contains(const GenString& oGenStringToSearch) const; //ok


    protected:
      bool bTestProtected(IN int iVar) const;

    private:

        std::string m_String; //note: tried to inheritate class GenString from this but std::string has no virtual destructor
        
      

};

#endif // __GenString_H__


/*!
  * \brief 
  */


////////////////////////////////////////////////////////////////////////////////
// <EOF>

