/*-----------------------------------------------------------------------------*
 * DeviceManager_ErrorCodes.h                                                  *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file DeviceManager_ErrorCodes.h
 *
 * \brief This file holds the return codes for the Device Manager
 *
 * \version 0.0.1
 * \version 27.07.2012, Negi, Sunder (MontaVista), Cleaned up file hierarchy
 * \version 05.08.2012, Negi, Sunder (MontaVista), Modified and fixed doxygen comments
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifndef __DEVICEMANAGER_ERRORCODES_H__ // only include this file once
#define __DEVICEMANAGER_ERRORCODES_H__

/*-----------------------------------------------------------------------------*
 * Defines                                                                     *
 *-----------------------------------------------------------------------------*/

#define DEVICEMANAGER_ERROR_UNKNOWN          -1
#define DEVICEMANAGER_ERROR_NOERROR           0
#define DEVICEMANAGER_ERROR_MEM_ALLOC         1
#define DEVICEMANAGER_ERROR_FILE_OPEN         2
#define DEVICEMANAGER_ERROR_FILE_READ         3
#define DEVICEMANAGER_ERROR_FILE_WRITE        4
#define DEVICEMANAGER_ERROR_NULL_POINTER      5
#define DEVICEMANAGER_ERROR_INVALID_PARAM     6
#define DEVICEMANAGER_ERROR_NODEVICE          7
#define DEVICEMANAGER_DEVICE_DETECTED         8
#define DEVICEMANAGER_ERROR_NOTVALID          9
#define DEVICE_NOK_APPLE_DEVICE_CONNECTION_WITHOUT_CUSTOMERHUB 10

#define DEVICEMANAGER_OK                      DEVICEMANAGER_ERROR_NOERROR //changed this to prevent that traces with ERROR of the devicemanager does disturb analysis of GMP traces



#define DEVICE_OK  DEVICEMANAGER_DEVICE_DETECTED
#define DEVICE_NOK DEVICEMANAGER_ERROR_NODEVICE



#endif //__DEVICEMANAGER_ERRORCODES_H__

////////////////////////////////////////////////////////////////////////////////
// <EOF>
