
/*-----------------------------------------------------------------------------*
 * VD_DeviceManager_clienthandler_VD_MediaManager.h                            *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : G3G                                                   *
 * COPYRIGHT   :  (c) 2013-2020 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file VD_DeviceManager_clienthandler_VD_MediaManager.cpp
 *
 * \brief CCA client-handler for the service VD_MediaManager
 *
 * \version 05.06.2015, Rajeev Narayanan Sambhu (RBEI/ECS1), version 1.0
 *          Initial version
 */

#ifndef _VD_DEVICEMANAGER_CLIENTHANDLER_VD_MEDIAMANAGER_H_
#define _VD_DEVICEMANAGER_CLIENTHANDLER_VD_MEDIAMANAGER_H_

/*-----------------------------------------------------------------------------*
 * namespaces                                                                     *
 *-----------------------------------------------------------------------------*/





/*-----------------------------------------------------------------------------*
 * Defines                                                                     *
 *-----------------------------------------------------------------------------*/
#include "Enums.h"
#include "Device.h"
#include "StateTable.h"






/*-----------------------------------------------------------------------------*
 * forwards declarations
 *-----------------------------------------------------------------------------*/
class vd_devicemanager_tclApp;

/*-----------------------------------------------------------------------------*
 * Structs/enums                                                               *
 *-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class vd_devicemanager_tclClientHandler_Diaglog
 *
 * \see ahl_tclBaseOneThreadClientHandler
 */
class VD_DeviceManager_clienthandler_VD_MediaManager: public ahl_tclCallbackBase, public ahl_tclBaseOneThreadClientHandler

{
public:

    /*!
         * \brief Default constructor
         *
         * \see ahl_tclBaseOneThreadService::ahl_tclBaseOneThreadService()
         */
	VD_DeviceManager_clienthandler_VD_MediaManager(tVoid);

    /*!
         * \brief Parameterized constructor
         *
         * Create an object of the base class ahl_tclBaseOneThreadService with
         * a pointer to this application, the service identifier, the application
         * identifier and the service version as parameters.
         *
         * \see ahl_tclBaseOneThreadService::ahl_tclBaseOneThreadService()
         */
	VD_DeviceManager_clienthandler_VD_MediaManager(
            vd_devicemanager_tclApp* poMainAppl);

    /*!
         * \brief Destructor
         *
         * \see ahl_tclBaseOneThreadService::~ahl_tclBaseOneThreadService()
         */
    virtual ~VD_DeviceManager_clienthandler_VD_MediaManager();

    /*!
         * \brief Assignment Operator
         *
         * Will not be implemented. Avoids Lint Prio 3 warning: Info 1732: new
         * in constructor for class 'VD_DeviceManager_clienthandler_VD_MediaManager'
         * which has no assignment operator.
         *
         * \note This is a technique to disable the assignment operator for this
         *       class. So if an attempt for the assignment is made compiler
         *       complains.
         */
    VD_DeviceManager_clienthandler_VD_MediaManager& operator=
    (const VD_DeviceManager_clienthandler_VD_MediaManager &oClientHandler);



    /*---------------------------------------------------------------------*
         * Overriding ahl_tclBaseOneThreadClientHandler methods                *
         *---------------------------------------------------------------------*/

    /*!
         * \brief This function is called by the CCA framework when the service
         *        which is offered by this server has become available.
         *
         * \see ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable();
         */
    virtual tVoid vOnServiceAvailable();

    /*!
         * \brief This function is called by the CCA framework when the service
         *        which is offered by this server has become unavailable.
         *
         * \see ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable();
         */
    virtual tVoid vOnServiceUnavailable();

    /*!
        * \brief vSendOpticalDiscEject( tVoid )
        *
        * Used to send cca message to VD_Mediamanager. This will internally eject the cdda
        *
        *
        */
     tVoid vSendOpticalDiscEject( tVoid );

     /*!
         * \brief vSendOpticalDiscInsert( tVoid )
         *
         * Used to send cca message to VD_Mediamanager. This will internally insert the optical disc
         *
         *
         */
     tVoid vSendOpticalDiscInsert(tVoid);

    /*---------------------------------------------------------------------*
         * Handler function declarations used by message map                   *
         *---------------------------------------------------------------------*/

    // Add your CCA message handler function prototypes here.

    /*---------------------------------------------------------------------*
         * Message map definition macro                                        *
         *---------------------------------------------------------------------*/
    DECLARE_MSG_MAP(VD_DeviceManager_clienthandler_VD_MediaManager)

    private :

    /*!
         * \brief Request for status of MMGR Property CDInfo
         *
         * Handle MIDW_MMGRFI_C_U16_CDINFO - Request for status of MMGR Property CDInfo.
         * \param [in] poMessage - the message.
         *
         */
    tVoid vHandleMediaManagerInternalCdAudioInfo( IN amt_tclServiceData *poMessage );



    /*!
         * \brief vHandle_OpticalDiscEject_MethodResult( tVoid )
         *
         * Used to get cca method result from VD_Mediamanager.
         *
         *
         */

    tVoid vHandle_OpticalDiscEject_MethodResult(IN  amt_tclServiceData* poMessage );






private:
    CDevice m_CDevice;
    tBool m_isServiceAvailble;
    vd_devicemanager_tclApp* m_poMainApp;
    //Will store the status of malfunction
    tBool m_bOpticalDiscMalfunctionstatus;
	tBool m_SendOpticalDiscEjectCalledBeforeServiceAvailable;





};

#endif // _VD_DEVICEMANAGER_CLIENTHANDLER_VD_MEDIAMANAGER_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
