/*-----------------------------------------------------------------------------*
 * VD_DeviceManager_clienthandler_VD_MediaManager.cpp                                  *
 *-----------------------------------------------------------------------------*
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : G3G                                                           *
 * COPYRIGHT   : (c) 2013-2020 Robert Bosch GmbH, Hildesheim                   *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file VD_DeviceManager_clienthandler_VD_MediaManager.cpp
 *
 * \brief CCA client-handler for the service VD_MediaManager
 *
 * \version 05.06.2015, Rajeev Narayanan Sambhu (RBEI/ECS1), version 1.0
 *          Initial version
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2016
 */

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include <stdio.h>
#include <string.h>
#include "Config.h"

#define INCLUDE_VD_DVM_AILAHL
#define INCLUDE_VD_DVM_FIDIAG
#define INCLUDE_VD_DVM_BASICS
#include "Common.h"

#define DIAGLIB_INCLUDE_GENERIC
#include <diaglib_if.h>
using namespace diaglib;


#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"

#include "VD_DeviceManager_clienthandler_VD_MediaManager.h"
#include "config/ConfigurationManager.h"
#include "Diagnosis.h"
#include "interface/DeviceManagerInterface.h"
#include "AdapterOpticalDiscNotifications.h"
#include "WorkThread.h"
#include "diag/DiagLibHandlerGen2.h"
#include "VD_DeviceManager_main.h"


#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MMGRFI_TYPES
#include "mplay_fi_if.h"
#include "mplay_mmgrfifctid.h"
#include "mplay_mmgrfiserviceinfo.h"


/*-----------------------------------------------------------------------------*
 * ETG Tracing                                                                 *
 *-----------------------------------------------------------------------------*/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_dvm.h"

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_DEVICEMANAGER_CLIENTHANDLER_VD_MEDIAMANAGER
#include "trcGenProj/Header/VD_DeviceManager_clienthandler_VD_MediaManager.cpp.trc.h"
#endif

#include "ETGTrace.h"
#endif //VARIANT_S_FTR_ENABLE_UNITTEST


/*-----------------------------------------------------------------------------*
 * define                                                                      *
 *-----------------------------------------------------------------------------*/

#define VD_MEDIAMANAGER_SERVICE_FI_MAJOR_VERSION  MPLAY_MMGRFI_C_U16_SERVICE_MAJORVERSION
#define VD_MEDIAMANAGER_SERVICE_FI_MINOR_VERSION  MPLAY_MMGRFI_C_U16_SERVICE_MINORVERSION

/*-----------------------------------------------------------------------------*
 * CCA_Message MAP                                                             *
 *-----------------------------------------------------------------------------*/

BEGIN_MSG_MAP(VD_DeviceManager_clienthandler_VD_MediaManager, ahl_tclBaseWork)
   ON_MESSAGE( MPLAY_MMGRFI_C_U16_CDINFO, vHandleMediaManagerInternalCdAudioInfo)
   ON_MESSAGE_SVCDATA( MPLAY_MMGRFI_C_U16_CDEJECT,AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,vHandle_OpticalDiscEject_MethodResult)
END_MSG_MAP()


/*-----------------------------------------------------------------------------*
 * Namespaces                                                                  *
 *-----------------------------------------------------------------------------*/


class mplay_fi_tcl_e8_MMgr_MethodResult;


/*-----------------------------------------------------------------------------*
 * VD_DeviceManager_clienthandler_VD_MediaManager(                             *
 *       vd_devicemanager_tclApp* poMainAppl)                                  *
 *-----------------------------------------------------------------------------*/
VD_DeviceManager_clienthandler_VD_MediaManager::
VD_DeviceManager_clienthandler_VD_MediaManager(vd_devicemanager_tclApp* poMainAppl)
    : ahl_tclBaseOneThreadClientHandler(
          /* Application Pointer          */ poMainAppl,
          /* ID of used Service           */ CCA_C_U16_SRV_MMGR,
          /* MajorVersion of used Service */ VD_MEDIAMANAGER_SERVICE_FI_MAJOR_VERSION,
          /* MinorVersion of used Service */ VD_MEDIAMANAGER_SERVICE_FI_MINOR_VERSION )
    , m_poMainApp(poMainAppl)
{
    ETG_TRACE_USR4(("Begin  : VD_DeviceManager_clienthandler_VD_MediaManager()"));

    m_isServiceAvailble             = FALSE;
    m_bOpticalDiscMalfunctionstatus = FALSE;
    m_SendOpticalDiscEjectCalledBeforeServiceAvailable = FALSE;

    vAddAutoRegisterForProperty(MPLAY_MMGRFI_C_U16_CDINFO);

    ETG_TRACE_USR4(("End  : VD_DeviceManager_clienthandler_VD_MediaManager()"));
}


/*-----------------------------------------------------------------------------*
 * Destructor                                                                  *
 *-----------------------------------------------------------------------------*/

VD_DeviceManager_clienthandler_VD_MediaManager::~VD_DeviceManager_clienthandler_VD_MediaManager(tVoid)
{
    ETG_TRACE_USR4(("Begin  : Destructor VD_DeviceManager_clienthandler_VD_MediaManager"));
    ETG_TRACE_USR4(("End  : Destructor VD_DeviceManager_clienthandler_VD_MediaManager"));

}


/*-----------------------------------------------------------------------------*
 * tVoid vOnServiceAvailable()                                                 *
 *-----------------------------------------------------------------------------*/
tVoid VD_DeviceManager_clienthandler_VD_MediaManager::vOnServiceAvailable()
{
    ETG_TRACE_USR4(("Running: VD_DeviceManager_clienthandler_VD_MediaManager::vOnServiceAvailable() entered. AppID = %u.",
                    u16GetServerAppID()));
    m_isServiceAvailble = TRUE;

    if(m_SendOpticalDiscEjectCalledBeforeServiceAvailable >0)
    {
        ETG_TRACE_USR4(("vOnServiceAvailable: m_SendOpticalDiscEjectCalledBeforeServiceAvailable:%d",m_SendOpticalDiscEjectCalledBeforeServiceAvailable))
        m_SendOpticalDiscEjectCalledBeforeServiceAvailable = 0;
        vSendOpticalDiscEject();
    }

}

/*-----------------------------------------------------------------------------*
 * tVoid vOnServiceUnavailable()                                               *
 *-----------------------------------------------------------------------------*/
tVoid VD_DeviceManager_clienthandler_VD_MediaManager::vOnServiceUnavailable()
{

    ETG_TRACE_USR4(("Running: VD_DeviceManager_clienthandler_VD_MediaManager::vOnServiceUnavailable() entered. AppID = %u.",
                    u16GetServerAppID()));
    m_isServiceAvailble = FALSE;
}


/*-----------------------------------------------------------------------------*
 * tVoid vHandleMediaManagerInternalCdAudioInfo( amt_tclServiceData *poMessage )            *
 *-----------------------------------------------------------------------------*/
tVoid VD_DeviceManager_clienthandler_VD_MediaManager::vHandleMediaManagerInternalCdAudioInfo( amt_tclServiceData *poMessage )
{
    ETG_TRACE_USR4(("Begin  : vHandleMediaManagerInternalCdAudioInfo"));

      switch( poMessage->u8GetOpCode() )
      {
         case CCA_C_U8_OPCODE_STATUS:
         {
            // extract payload
            mplay_mmgrfi_tclMsgCDInfoStatus oStatus;
            (tVoid)fi_tclVisitorMessage(poMessage).s32GetData( oStatus );
            char cCDDASerialNumber[1024];
            tU8 u8CDType     = (tU8)oStatus.CDType.enType;               // Get CD Type
            tU8 u8MediaState = (tU8)oStatus.MediaState.enType;           // Get CD Media State
            tU8 u8InsertState = (tU8)oStatus.InsertState.enType;         // Get CD Insert State

            trOpticalDiskCDInfo l_OpticalDiskCDInfo;
            l_OpticalDiskCDInfo.OpticalDeviceState = (tenOpticalDeviceState)oStatus.e8DeviceState.enType;         // Get CD Device State
            strncpy(l_OpticalDiskCDInfo.OpticalDriveVersion,oStatus.DriveVersion.szValue, sizeof(l_OpticalDiskCDInfo.OpticalDriveVersion)-1);   // Get Drive Version
            l_OpticalDiskCDInfo.OpticalDriveVersion[sizeof(l_OpticalDiskCDInfo.OpticalDriveVersion)-1] = '\0'; // sim4hi: fix for Coverity CID-10138

            ETG_TRACE_USR4(( "vHandleMediaManagerInternalCdAudioInfo( ): Get drive versions HW: %s", (tPChar)l_OpticalDiskCDInfo.OpticalDriveVersion ));
            ETG_TRACE_USR4(( "vHandleMediaManagerInternalCdAudioInfo( ): Get Devicestate: %d", l_OpticalDiskCDInfo.OpticalDeviceState ));
            AdapterOpticalDiscNotifications l_AdapterOpticalDiscNotifications;
            l_AdapterOpticalDiscNotifications.vSendCDInfo( l_OpticalDiskCDInfo);

            strncpy(cCDDASerialNumber,oStatus.szcUniqueID.szValue, sizeof(cCDDASerialNumber)-1);// Get CD Unique Id
            cCDDASerialNumber[sizeof(cCDDASerialNumber)-1]= '\0';
            ETG_TRACE_USR4(("vHandleMediaManagerInternalCdAudioInfo : cCDDASerialNumber : %s",cCDDASerialNumber));
            ETG_TRACE_USR4(("vHandleMediaManagerInternalCdAudioInfo : Send the cdda device info"));
            l_AdapterOpticalDiscNotifications.vUpdateOpticalDiscSerialID(cCDDASerialNumber);

            tDMOpticalDiscSlotState  eOpticalDiscSlotState = l_AdapterOpticalDiscNotifications.vCalculateOpticalDiscState(u8CDType,u8InsertState,u8MediaState);

            bool l_bTempMalfunctionState = l_AdapterOpticalDiscNotifications.bCalculateOpticalDiscMalfunctionState(l_OpticalDiskCDInfo.OpticalDeviceState,u8MediaState);

            if(l_bTempMalfunctionState != m_bOpticalDiscMalfunctionstatus)//Update if the malfunction status is not equal
            {
                m_bOpticalDiscMalfunctionstatus = l_bTempMalfunctionState;
                ETG_TRACE_USR4(("vHandleMediaManagerInternalCdAudioInfo :Malfunction Status of Optical Disc is changed. Current Malfunction Status : %d",ETG_ENUM(BOOL,m_bOpticalDiscMalfunctionstatus)));
                l_AdapterOpticalDiscNotifications.vSendMalfunctionStatus(m_bOpticalDiscMalfunctionstatus);
            }

            if( eOpticalDiscSlotState != UNDEFINED_STATE)
            {
                l_AdapterOpticalDiscNotifications.vSendResult( eOpticalDiscSlotState);
            }

            ETG_TRACE_USR4(("vHandleMediaManagerInternalCdAudioInfo : CDType: %d",ETG_ENUM(CDDATypes, u8CDType)));
            if(u8CDType == MMGR_INCORRECT) // Handle eject request for Incorrect(Scratched/reverse CD) NCG3D-6472
            {
                ETG_TRACE_USR4(("vHandleMediaManagerInternalCdAudioInfo : CDType is MMGR_INCORRECT.. Send Eject command to MediaManager"));
                vSendOpticalDiscEject();
            }
            break;
         }
         case CCA_C_U8_OPCODE_ERROR:
         {
            ETG_TRACE_ERR(( "vHandleMediaManagerInternalCdAudioInfo: ERROR  OpCode error state received" ));
            break;
         }
         default:
         {
            ETG_TRACE_ERR(( "vHandleMediaManagerInternalCdAudioInfo: ERROR: Unhandled OpCode received" ));
            break;
         }
      }


   if(! poMessage->bDelete())
   {
      ETG_TRACE_ERR(( "vHandleMediaManagerInternalCdAudioInfo: ERROR: deleting message failed" ));
   }

   ETG_TRACE_USR4(("End  : vHandleMediaManagerInternalCdAudioInfo"));
}



/*-----------------------------------------------------------------------------*
 * tVoid vSendOpticalDiscEject( tVoid )                                                    *
 *-----------------------------------------------------------------------------*/
tVoid VD_DeviceManager_clienthandler_VD_MediaManager::vSendOpticalDiscEject( tVoid )
{
    ETG_TRACE_USR3(( "Begin ::vSendOpticalDiscEject" ));
    if(m_isServiceAvailble)
    {


        // Create object of midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodStart
        mplay_mmgrfi_tclMsgCDEjectMethodStart oFiDataObject;

        // Create FI VisitorMessage. (The FI data object will be streamed (each
        // parameter is copied individually) to shared memory.)
        fi_tclVisitorMessage oMsg(oFiDataObject,VD_MEDIAMANAGER_SERVICE_FI_MAJOR_VERSION);

        // Always destroy the (message related) FI data object (before leaving
        // its creation scope)
        oFiDataObject.vDestroy();

        // Here the message related header information is added and by this the
        // creation of the message is completed.
        vInitServiceData (oMsg,                                                   // ServiceDataMsg
                          0,                                                          // CmdCounter
                          MPLAY_MMGRFI_C_U16_CDEJECT,// Function ID
                          AMT_C_U8_CCAMSG_OPCODE_METHODSTART);                        // Opcode

        // Post the message
        ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oMsg, TRUE);

        if (AIL_EN_N_NO_ERROR != enResult)
        {
            // Posting of the message has failed,
            // but it is not necessary to call 'oMsg2.bDelete()' here as the
            // 'TRUE' in "enPostMessage(&oMsg, TRUE)" will take care that the
            // message is deleted in a case of an error.
            ETG_TRACE_ERR(( "vSendOpticalDiscEject: enPostMessage() failed for 'CDEject \
                    - GET' message, 'ail_tenCommunicationError' = %u", (tU32)enResult ));
        }

    }
    else
    {
        ETG_TRACE_USR3(( "vSendOpticalDiscEject: !!!!!!!VD_Mediamanager Service not ready!!!!!!" ));
        //tbd send the error message to servide vd_devicemanager

        ++m_SendOpticalDiscEjectCalledBeforeServiceAvailable;

    }
    ETG_TRACE_USR3(( "End ::vSendOpticalDiscEject" ));

}


/*-----------------------------------------------------------------------------*
 * tVoid vSendOpticalDiscInsert( tVoid )                                                    *
 *-----------------------------------------------------------------------------*/
tVoid VD_DeviceManager_clienthandler_VD_MediaManager::vSendOpticalDiscInsert( tVoid )
{
    ETG_TRACE_USR3(( "Begin ::vSendOpticalDiscInsert" ));
    if(m_isServiceAvailble)
    {


        // Create object of midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodStart
        mplay_mmgrfi_tclMsgCDEjectMethodStart oFiDataObject;

        // Create FI VisitorMessage. (The FI data object will be streamed (each
        // parameter is copied individually) to shared memory.)
        fi_tclVisitorMessage oMsg(oFiDataObject,VD_MEDIAMANAGER_SERVICE_FI_MAJOR_VERSION);

        // Always destroy the (message related) FI data object (before leaving
        // its creation scope)
        oFiDataObject.vDestroy();

        // Here the message related header information is added and by this the
        // creation of the message is completed.
        vInitServiceData (oMsg,                                                   // ServiceDataMsg
                          0,                                                          // CmdCounter
                          MPLAY_MMGRFI_C_U16_CDINSERT,// Function ID
                          AMT_C_U8_CCAMSG_OPCODE_METHODSTART);                        // Opcode

        // Post the message
        ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oMsg, TRUE);

        if (AIL_EN_N_NO_ERROR != enResult)
        {
            // Posting of the message has failed,
            // but it is not necessary to call 'oMsg2.bDelete()' here as the
            // 'TRUE' in "enPostMessage(&oMsg, TRUE)" will take care that the
            // message is deleted in a case of an error.
            ETG_TRACE_ERR(( "vSendOpticalDiscInsert: enPostMessage() failed for 'CDEject \
                    - GET' message, 'ail_tenCommunicationError' = %u", (tU32)enResult ));
        }

    }
    else
    {
        ETG_TRACE_USR3(( "vSendOpticalDiscInsert: !!!!!!!VD_Mediamanager Service not ready!!!!!!" ));
        //tbd send the error message to servide vd_devicemanager

    }
    ETG_TRACE_USR3(( "End ::vSendOpticalDiscInsert" ));

}



/*-----------------------------------------------------------------------------*
 * vHandle_OpticalDiscEject_MethodResult( amt_tclServiceData* poMessage )                                                    *
 *-----------------------------------------------------------------------------*/

tVoid VD_DeviceManager_clienthandler_VD_MediaManager::vHandle_OpticalDiscEject_MethodResult( amt_tclServiceData* poMessage )
{
    ETG_TRACE_USR3(( "Begin ::vHandle_OpticalDiscEject_MethodResult" ));

    // Create a FI visitor message for the received CCA message
    fi_tclVisitorMessage oResultMsg( poMessage );
    // Create the (message related) FI data object
    mplay_mmgrfi_tclMsgCDEjectMethodResult oResultData;
    oResultMsg.s32GetData(oResultData);

    // if control setting accepted, composing positive response

    switch(oResultData.ServiceStatus.enType)
    {
        case mplay_fi_tcl_e8_MMgr_MethodResult::FI_EN_MMGR_ACCEPTED:
          ETG_TRACE_USR4 (("vHandle_OpticalDiscEject_MethodResult :: Accepted"));
          DeviceManagerInterface::GetInstance()->vSendOpticalDiscEjectMethodResult(ACCEPTED);
          break;
        case mplay_fi_tcl_e8_MMgr_MethodResult::FI_EN_MMGR_NOTACCEPTED:
          ETG_TRACE_ERR (("vHandle_OpticalDiscEject_MethodResult :: NOTACCEPTED"));
          DeviceManagerInterface::GetInstance()->vSendOpticalDiscEjectMethodResult(NOTACCEPTED);
          break;
        case mplay_fi_tcl_e8_MMgr_MethodResult::FI_EN_MMGR_DEVICENOTREADY:
          ETG_TRACE_ERR (("vHandle_OpticalDiscEject_MethodResult :: DEVICENOTREADY"));
          DeviceManagerInterface::GetInstance()->vSendOpticalDiscEjectMethodResult(DEVICENOTREADY);
          break;
        default:
         ETG_TRACE_FATAL(("vHandle_OpticalDiscEject_MethodResult: Unexpected value : %d",(int)oResultData.ServiceStatus.enType))
         ETG_TRACE_FATAL(("onOpticalDiscEjectMethodResult: mplay_fi_tcl_e8_MMgr_MethodResult::FI_EN_MMGR_ACCEPTED : %d",(int)mplay_fi_tcl_e8_MMgr_MethodResult::FI_EN_MMGR_ACCEPTED));
         ETG_TRACE_FATAL(("onOpticalDiscEjectMethodResult: mplay_fi_tcl_e8_MMgr_MethodResult::FI_EN_NOTACCEPTED   : %d",(int)mplay_fi_tcl_e8_MMgr_MethodResult::FI_EN_MMGR_NOTACCEPTED));
         ETG_TRACE_FATAL(("onOpticalDiscEjectMethodResult: mplay_fi_tcl_e8_MMgr_MethodResult::FI_EN_DEVICENOTREADY: %d",(int)mplay_fi_tcl_e8_MMgr_MethodResult::FI_EN_MMGR_DEVICENOTREADY));

    }

    oResultData.vDestroy();



  ETG_TRACE_USR3(( "End ::vHandle_OpticalDiscEject_MethodResult" ));
}



////////////////////////////////////////////////////////////////////////////////
// <EOF>
