/************************************************************************
* FILE:         VD_DeviceManager_clienthandler_SPM.h
* PROJECT:      ARION Prototype
* SW-COMPONENT: Virtual Device Media Manager
*----------------------------------------------------------------------
*
* DESCRIPTION: VD_DeviceManager
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date        | Author                     | Modification
* 13.12.16  | Christian Koechling   | initial version
*
*************************************************************************/

#ifndef _VD_DEVICEMANAGER_CLIENT_HANDLERSPM_H_
#define _VD_DEVICEMANAGER_CLIENT_HANDLERSPM_H_

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#include "Config.h"

class vd_devicemanager_tclApp;//lint !e763 Info 763;Redundant declaration for symbol 'x'

//-----------------------------------------------------------------------------
// defines
//-----------------------------------------------------------------------------

//service id
#define VDDVM_C_U16_SERVICE_SPM_MAJOR_VERSION 1 
#define VDDVM_C_U16_SERVICE_SPM_MINOR_VERSION 0

#ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE_PIONEER
   #define VDDVM_CLIENTSPM_WAITTIME_GETLOADERSTATE   1400  // introduced for MASCA (500ms). For PIONEER drive (firmware 0xA) changes to 1.4s (with firmware 0x5 1.2s was sufficient...)
#else
   #define VDDVM_CLIENTSPM_WAITTIME_GETLOADERSTATE   500   // introduced for MASCA drives
#endif // #ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE_PIONEER

#define VDDVM_CLIENTSPM_THREADNAME          "Mmgr_GPIO"             // Default Thread name
#define VDDVM_CLIENTSPM_DEFAULT_STACKSIZE   10000                   // Default stacksize
#define VDDVM_CLIENTSPM_DEFAULT_PRIO        145                     // Magic priority for worker threads -> given by architect
#define VDDVM_CLIENTSPM_EVENTNAME           "vd_devicemanager_EventGPIO"

// Defines for events from callback function to thread
#define VDDVM_CLIENTSPM_EVENT_MASK_CD_DRIVE_INSERT_CLAMPS  (tU16)0x0010   // Event to indicate a change at GPIO for insert clamps

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------
// ---  the application has one client message handler for each service ---
class vd_devicemanager_clienthandler_SPM : public ahl_tclCallbackBase, public ahl_tclBaseOneThreadClientHandler
{ 
public:


	/*!
	* \brief Parameterized constructor
	*
	* Create an object of the base class ahl_tclBaseOneThreadService with
	* a pointer to this application, the service identifier, the application
	* identifier and the service version as parameters.
	*
	* \see ahl_tclBaseOneThreadService::ahl_tclBaseOneThreadService()
	*/

   vd_devicemanager_clienthandler_SPM (vd_devicemanager_tclApp* poMainAppl); // constructor


	/*!
	* \brief Destructor
	*
	* \see ahl_tclBaseOneThreadService::~ahl_tclBaseOneThreadService()
	*/
   ~vd_devicemanager_clienthandler_SPM( tVoid );               // Destructor
   //---------------------------------------------------------------------


	/*!
	* \brief Assignment Operator
		*
	* Will not be implemented. Avoids Lint Prio 3 warning: Info 1732: new
	* in constructor for class 'VD_DeviceManager_clienthandler_VD_MediaManager'
	* which has no assignment operator.
	*
	* \note This is a technique to disable the assignment operator for this
	*		class. So if an attempt for the assignment is made compiler
	*		complains.
	*/
   vd_devicemanager_clienthandler_SPM& operator=
   (const vd_devicemanager_clienthandler_SPM &oClientHandler);




   /*---------------------------------------------------------------------*
         * Overriding ahl_tclBaseOneThreadClientHandler methods                *
         *---------------------------------------------------------------------*/

    /*!
         * \brief This function is called by the CCA framework when the service
         *        which is offered by this server has become available.
         *
         * \see ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable();
         */
    virtual tVoid vOnServiceAvailable();

    /*!
         * \brief This function is called by the CCA framework when the service
         *        which is offered by this server has become unavailable.
         *
         * \see ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable();
         */
    virtual tVoid vOnServiceUnavailable();

	// Add your CCA message handler function prototypes here.
	/*---------------------------------------------------------------------*
	* Message map definition macro										*
	*---------------------------------------------------------------------*/
    DECLARE_MSG_MAP(vd_devicemanager_clienthandler_SPM)

private:
   
   /*!
	* \brief This function is called by SPM
	*		 
	*
	* \see ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable();
	*/

   tVoid vHandleHistoryTrigger( amt_tclServiceData* poMessage );



	/*!
	* \brief checks if this is the first pressed eject after startup
	* 	   
	*
	* \see ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable();
	*/
   tVoid CheckSendEject(tU32 u32Timestamp);

   // +++   Enter your public Data and functions here   +++




   private:
   vd_devicemanager_tclApp* m_poMainApp;
   tBool m_isServiceAvailble;

   tU32 u32OldTimestamp;

};

#endif // _VDDVM_CLIENT_HANDLERSPM_H_

