/************************************************************************
* FILE:         vd_devicemanager_clienthandler_SPM.cpp
* PROJECT:      MIB2_ENTRY
* SW-COMPONENT: Virtual Device Media Manager
*----------------------------------------------------------------------
*
* DESCRIPTION: VD MediaManager
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 27.05.05  | CM-DI/ESA2 Fiebing | initial version
*
*************************************************************************/

#define REMOVE_FROM_CODE
#define NOT_SUPRESS_DOING

#define _CLASS  VDDVM_TR_CLIENTSPM
#define FOR_FUTURE_USE(parm) (tVoid)(parm)

#define VDDVM_CDCTRLIF_EVENTNAME                              "vdvm_PrcEventCD"
#define VDDVM_EVENT_MASK_MEDIA_CHANGE                         (tU32)0x00000001// Event media change: AUDIO_MEDIA,DATA_MEDIA, MEDIA_EJECTED...
#define VDDVM_EVENT_MASK_TOTAL_FAILURE                        (tU32)0x00000002// Event total failure: DEVICE_OK, DEVICE_FAIL
#define VDDVM_EVENT_MASK_MEDIA_STATE                          (tU32)0x00000008// Event media state changed: MEDIA_READY, MEDIA_NOT_READY
#define VDDVM_EVENT_MASK_DEFECT                               (tU32)0x00000020// Event defect: DEFECT_LOAD_EJECT, LOAD_INSERT, DISCTOC...
#define VDDVM_EVENT_MASK_CD_DEVICE_STATE                      (tU32)0x00000040// Event defect: OSAL_C_U16_DEVICE_NOT_READY, OSAL_C_U16_DEVICE_READY
#define VDDVM_EVENT_MASK_CMD_EJECTCD                          (tU32)0x00000100// Event eject CD: eject CD started from the thread
#define VDDVM_EVENT_MASK_CMD_AUTOREINSERTCD                   (tU32)0x00000200// Event automatic reinsert of media
#define VDDVM_EVENT_MASK_CMD_DIAG_START_CDDRIVE_TEST          (tU32)0x00000400// Event start drive test: Trigger to start the drive test if it's not running actual
#define VDDVM_EVENT_MASK_CD_TEMP_TIMEOUT                      (tU32)0x00000800// Event to indicate that a timeout to get CD drive temperature again occured
#define VDDVM_EVENT_MASK_CD_GET_FIRST_TEMP                    (tU32)0x00001000// Event to indicate that the first CD drive temperature should be get and send
#define VDDVM_EVENT_MASK_CMD_DIAG_CONTINUE_CD_DRV_SHORT_TEST  (tU32)0x00002000// Event to continue the  drive test with next.
#define VDDVM_EVENT_MASK_CMD_DIAG_CONTINUE_CD_DRV_INT_TEST    (tU32)0x00004000// Event to continue the  drive test with next.
#define VDDVM_EVENT_MASK_CMD_DIAG_SET_REQUESTED_TRACKTYPE     (tU32)0x00008000// Event to select a requested track type

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#include "Config.h"
#include <vector>

#define INCLUDE_VD_DVM_AILAHL
#define INCLUDE_VD_DVM_FIDIAG
#define INCLUDE_VD_DVM_BASICS
#include "Common.h"

#define DIAGLIB_INCLUDE_GENERIC
#include <diaglib_if.h>
using namespace diaglib;



#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_dvm.h"

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_VD_DEVICEMANAGER_CLIENTHANDLER_VD_MEDIAMANAGER
#include "trcGenProj/Header/VD_DeviceManager_clienthandler_SPM.cpp.trc.h"
#endif
#include "ETGTrace.h"
#endif //VARIANT_S_FTR_ENABLE_UNITTEST


/*
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"                                   // use AIL template with MessageMaps
#define AHL_S_IMPORT_INTERFACE_NOTIFICTABLE
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"
*/

/*this is the old inferface not used anymore precompiled fi is used
#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_FUNCTIONIDS
#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_TYPES     // or #define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_STDVISITORS
#include "cfc_fi_if.h"
*/
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_STDVISITORS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#include "spm_fi_if.h"


#define VDDVM_S_IMPORT_INTERFACE_MSG
//#include "vd_devicemanager_if.h"                                // For VD MMgr interface


#include "Enums.h"
#include "Device.h"
#include "DeviceCard.h"
#include "Diagnosis.h"
#include "StateTable.h"
#include "debug/HistoryManager.h"
#include "interface/DeviceManagerInterface.h"


//#include "vd_devicemanager_main.h"
#include "VD_DeviceManager_clienthandler_SPM.h"
#include "VD_DeviceManager_clienthandler_VD_MediaManager.h"
#include "config/ConfigurationManager.h"
#include "Diagnosis.h"
#include "interface/DeviceManagerInterface.h"
#include "AdapterOpticalDiscNotifications.h"
#include "WorkThread.h"
//#include "diag/DiagLibHandlerGen2.h"
#include "VD_DeviceManager_main.h"



//#include "vd_devicemanager_timer.h"                             // 'automatic reinsert CD' timer
//#include "vd_devicemanager_service.h"
#ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE
//   #include "vd_devicemanager_cdctrlif.h"
#endif // #ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE
//#include "vd_devicemanager_trace.h"


/*-----------------------------------------------------------------------------*
 * Namespaces                                                                  *
 *-----------------------------------------------------------------------------*/
using namespace statetbl;


/* ************************************************************************** */
/* INITIALIZE STATIC CLASS VARIABLES                                          */
/* ************************************************************************** */


//uses hardcoded binding
#define SPM_SERVICE_FI_MAJOR_VERSION  1 //SPM_COREFI_C_U16_SERVICE_MAJORVERSION
#define SPM_SERVICE_FI_MINOR_VERSION  2 //SPM_COREFI_C_U16_SERVICE_MINORVERSION



#ifndef VARIANT_S_FTR_ENABLE_DEVMGR_USE_SPM_HISTORYTRIGGER_EJECT
#define DISABLED_HISTORYTRIGGER
#pragma message "SPM_COREFI_C_U16_HISTORYTRIGGER of SPM not used yet - check if exists meanwhile"
#else
#undef DISABLED_HISTORYTRIGGER
#pragma message "SPM_COREFI_C_U16_HISTORYTRIGGER used for early eject"
#endif


// +++ MESSAGE MAP: enter the function IDs (FID) and the corresponding functions here.
//      the function will be called when a message with the corresponding FID arrives +++
#ifndef DISABLED_HISTORYTRIGGER
BEGIN_MSG_MAP(vd_devicemanager_clienthandler_SPM, ahl_tclBaseWork)
   ON_MESSAGE( SPM_COREFI_C_U16_HISTORYTRIGGER,  vHandleHistoryTrigger)
END_MSG_MAP()
#else
BEGIN_MSG_MAP(vd_devicemanager_clienthandler_SPM, ahl_tclBaseWork)
END_MSG_MAP()
#endif




/*************************************************************************
*
* FUNCTION: vd_devicemanager_clienthandler_SPM::vd_devicemanager_clienthandler_SPM(vd_devicemanager_tclApp* m_poMainAppApp)
* 
* DESCRIPTION: constructor, creates object vd_devicemanager_clienthandler_SPM - object
*
* PARAMETER: vd_devicemanager_tclApp* m_poMainAppApp: main - object of this application 
*
* RETURNVALUE: none
*
*************************************************************************/
vd_devicemanager_clienthandler_SPM::vd_devicemanager_clienthandler_SPM( vd_devicemanager_tclApp* poMainAppl )
    : ahl_tclBaseOneThreadClientHandler(
            /* Application Pointer          */ poMainAppl,
            /* ID of used Service           */ CCA_C_U16_SRV_SPM,
            /* MajorVersion of used Service */ SPM_SERVICE_FI_MAJOR_VERSION,
            /* MinorVersion of used Service */ SPM_SERVICE_FI_MINOR_VERSION )
      , m_poMainApp(poMainAppl)

{
    ETG_TRACE_USR4(("Begin  : vd_devicemanager_clienthandler_SPM()"));

   
    ETG_TRACE_USR4(("vd_devicemanager_clienthandler_SPM: Expected: SPM_SERVICE_FI_MAJOR_VERSION:%d ",(int)SPM_SERVICE_FI_MAJOR_VERSION));
    ETG_TRACE_USR4(("vd_devicemanager_clienthandler_SPM: Expected: SPM_SERVICE_FI_MINOR_VERSION:%d ",(int)SPM_SERVICE_FI_MAJOR_VERSION));

    m_isServiceAvailble             = FALSE;
    u32OldTimestamp = 0;

#ifndef DISABLED_HISTORYTRIGGER
    vAddAutoRegisterForProperty(SPM_COREFI_C_U16_HISTORYTRIGGER);
#endif
    ETG_TRACE_USR4(("End  : vd_devicemanager_clienthandler_SPM()"));

}



/*************************************************************************/
/*
* FUNCTION:    vd_devicemanager_clienthandler_SPM::~vd_devicemanager_clienthandler_SPM( )
* 
* DESCRIPTION: destructor: deletes the thread
*
* PARAMETER:   void
*
* RETURNVALUE: none
*/
/*************************************************************************/
vd_devicemanager_clienthandler_SPM::~vd_devicemanager_clienthandler_SPM( )
{
   tS32 s32Success;
   // Reset pointer to main application
   m_poMainApp = OSAL_NULL;
}


/*************************************************************************
*
* FUNCTION:    tVoid vHandleHistoryTrigger(...)
* 
* DESCRIPTION: react on messages with FID = SPM_COREFI_C_U16_HISTORYTRIGGER
*
* PARAMETER: 
*
* RETURNVALUE: void
*
* HISTORY:     InitialVersion
* 
*************************************************************************/
tVoid vd_devicemanager_clienthandler_SPM::vHandleHistoryTrigger( amt_tclServiceData* poMessage )
{

#ifndef DISABLED_HISTORYTRIGGER
    ETG_TRACE_USR4(("vd_devicemanager_clienthandler_SPM::vHandleHistoryTrigger: Begin"));

    spm_corefi_tclMsgHistoryTriggerStatus oFiDataObjectStatus;
    fi_tclVisitorMessage oVisitorMsg(poMessage);
   
    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectStatus, VDDVM_C_U16_SERVICE_SPM_MAJOR_VERSION))
    {
        ETG_TRACE_USR4(("vd_devicemanager_clienthandler_SPM::vHandleHistoryTrigger:filled oFiDataObjectStatus.tTriggeredStates.size():%d",oFiDataObjectStatus.tTriggeredStates.size())); 
        
        //bpstl::vector<spm_fi_tcl_SPM_HistoryTrigger>::iterator it;
		std::vector<spm_fi_tcl_SPM_HistoryTrigger>::iterator it;
        for(it = oFiDataObjectStatus.tTriggeredStates.begin(); it < oFiDataObjectStatus.tTriggeredStates.end(); it++)
        {
            switch( it->eTriggerType.enType )
            {
             //------------------------------------------------------------------------------------------------------------------
             //Note according FO-SPM only FI_EN_SPM_U32_SUBSTATE_ON_TIPPER and FI_EN_SPM_U32_SUBSTATE_EJECT is expected to be received
             //------------------------------------------------------------------------------------------------------------------
            
            
             case spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_EJECT:
                 ETG_TRACE_COMP(("============================================================================================" ));
                 ETG_TRACE_COMP(("vd_devicemanager_clienthandler_SPM::vHandleHistoryTrigger:: FI_EN_SPM_U32_SUBSTATE_EJECT)" ));
                 ETG_TRACE_COMP(("vd_devicemanager_clienthandler_SPM::vHandleHistoryTrigger: u32Timestamp: %d", it->u32Timestamp ));
                 ETG_TRACE_COMP(("============================================================================================" ));
                 CheckSendEject(it->u32Timestamp);
                 break;
             case spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_ON_TIPPER:
                ETG_TRACE_COMP(( "-----------------------------------------------------------------------------------------" ));
                ETG_TRACE_USR4(("vd_devicemanager_clienthandler_SPM::vHandleHistoryTrigger: FI_EN_SPM_U32_SUBSTATE_ON_TIPPER"));
                ETG_TRACE_COMP(("vd_devicemanager_clienthandler_SPM::vHandleHistoryTrigger: u32Timestamp: %d", it->u32Timestamp ));
                ETG_TRACE_COMP(( "-----------------------------------------------------------------------------------------" ));
                break;
             default:
                ETG_TRACE_USR4(("============================================================================================" ));
                ETG_TRACE_USR4(("[INFO] vd_devicemanager_clienthandler_SPM::vHandleHistoryTrigger:: FI_EN_SPM_U32_SUBSTATE_: %d)", it->eTriggerType.enType  ));
                ETG_TRACE_USR4(("[INFO]vd_devicemanager_clienthandler_SPM::vHandleHistoryTrigger: u32Timestamp: %d", it->u32Timestamp ));
                ETG_TRACE_USR4(("============================================================================================" ));
                break;

            }
       }
    }
    



   ETG_TRACE_USR4(("vd_devicemanager_clienthandler_SPM::vHandleHistoryTrigger: End"));
#endif
} //lint !e1762  DevStudios says:'not const, please'

/*-----------------------------------------------------------------------------*
 * tVoid vOnServiceAvailable()                                                 *
 *-----------------------------------------------------------------------------*/
tVoid vd_devicemanager_clienthandler_SPM::vOnServiceAvailable()
{
    ETG_TRACE_USR4(("Running: vd_devicemanager_clienthandler_SPM::vOnServiceAvailable() entered. AppID = %u.",
                    u16GetServerAppID()));
    m_isServiceAvailble = TRUE;
}

/*-----------------------------------------------------------------------------*
 * tVoid vOnServiceUnavailable()                                               *
 *-----------------------------------------------------------------------------*/
tVoid vd_devicemanager_clienthandler_SPM::vOnServiceUnavailable()
{

    ETG_TRACE_USR4(("Running: vd_devicemanager_clienthandler_SPM::vOnServiceUnavailable() entered. AppID = %u.",
                    u16GetServerAppID()));
    m_isServiceAvailble = FALSE;
}

/*-----------------------------------------------------------------------------*
 * tVoid CheckSendEject()                                               *
 *-----------------------------------------------------------------------------*/
tVoid vd_devicemanager_clienthandler_SPM::CheckSendEject(tU32 u32Timestamp)
{
    ETG_TRACE_USR4(("Begin: vd_devicemanager_clienthandler_SPM::CheckSendEject: u32Timestamp:%d",u32Timestamp));

    if(m_poMainApp)
    {
        if(m_poMainApp->m_poClientHandlerMediaManager)
        {
            if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_USE_SPM_HISTORYTRIGGER_FOR_EARLYEJECT))
            {
                if(u32OldTimestamp == 0) //called once only
                {
#ifdef TEST_EJECT_BEFORESTARTUP
                    ETG_TRACE_FATAL(("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
                    ETG_TRACE_USR4(("vd_devicemanager_clienthandler_SPM::CheckSendEject: SendIt (TimeStamp eject:u32OldTimestamp: %d u32Timestamp: %d)",u32OldTimestamp,u32Timestamp));
                    ETG_TRACE_FATAL(("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
#endif
                    ETG_TRACE_USR4(("vd_devicemanager_clienthandler_SPM::CheckSendEject: SendIt (TimeStamp eject:u32OldTimestamp: %d u32Timestamp: %d)",u32OldTimestamp,u32Timestamp));
                    m_poMainApp->m_poClientHandlerMediaManager->vSendOpticalDiscEject();
                    u32OldTimestamp = u32Timestamp; 
                }
                else
                {
                 ETG_TRACE_USR4(("vd_devicemanager_clienthandler_SPM::CheckSendEject: note expected: u32OldTimestamp: %d u32Timestamp: %d)",u32OldTimestamp,u32Timestamp));
                }
            }
            else
            {
                ETG_TRACE_USR4(("vd_devicemanager_clienthandler_SPM::CheckSendEject: Disabled to SendIt (eCONF_ENABLE_USE_SPM_HISTORYTRIGGER_FOR_EARLYEJECT is OFF)"));
            }
        }
        else
        {
            ETG_TRACE_FATAL(("vd_devicemanager_clienthandler_SPM::CheckSendEject: m_poClientHandlerMediaManager == NULL"));
        }
    }
    else
    {
        ETG_TRACE_FATAL(("vd_devicemanager_clienthandler_SPM::CheckSendEject: m_poMainApp == NULL"));
    }

    
    ETG_TRACE_USR4(("End  : vd_devicemanager_clienthandler_SPM::CheckSendEject"));

}



