/*-----------------------------------------------------------------------------*
 * AdapterDiagnosisTroubleCode.cpp                                                         *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : G3G                                                           *
 * COPYRIGHT   : (c) 2012 - 2020 Robert Bosch GmbH, Hildesheim                 *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file MessageQueueDVM.cpp
 *
 * \brief fill ITC's this object is used by VD_DeviceManager_clienthandler_doaglog
 *
 * \version 09.02.2016, Christian Koechling: Initial version to get code form VD_DevicEManager_clienthandler_diaglog shifted to make is unit testable
 *
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2020
 */

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/



#include "Config.h"
#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"

//to include types like tBool, tchar, tU8 etc
#define INCLUDE_VD_DVM_OSAL
#define INCLUDE_VD_DVM_BASICS
#include "Common.h"

#include "DiagnosisTroubleCoder.h"
#include "Device.h"
#include "config/ConfigurationManager.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_dvm.h"

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST  
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_DEVICEMANAGER_CLIENTHANDLER_DIAGLOG
#include "trcGenProj/Header/DiagnosisTroubleCoder.cpp.trc.h"
#endif
#include "ETGTrace.h"
#endif //VARIANT_S_FTR_ENABLE_UNITTEST


/*-----------------------------------------------------------------------------*
 * define                                                                 *
 *-----------------------------------------------------------------------------*/

DiagnosisTroubleCoder::DiagnosisTroubleCoder()
{
}

DiagnosisTroubleCoder::~DiagnosisTroubleCoder()
{
}


/*-----------------------------------------------------------------------------*
 * tU8 u8SetDiagLogDTCCode(tenDevManagerUSBHost usb,                           *
 *          tenUsbTestType enDtcTestType, tU8 u8Result,                        *
 *          midw_diaglogfi_tclMsgSaveTestResultMethodStart   *poTestData)      *
 *-----------------------------------------------------------------------------*/

tU8  DiagnosisTroubleCoder::u8SetDiagLogDTCCode(IN tenDevManagerUSBHost usb, IN tenUsbTestType enDtcTestType, IN tU8 u8Result, tBool bServiceIsAvailable,diaglog_rDtc_error (&f_rDtc_error)[NUM_OF_DTC_ERRORS],INOUT vector<trDtcCodeResult> &ListCyclicDiagResults )
{
    tU8   u8Index    = 0; ///@todo check if there is a better way to avoid: Variable 'u8Index' may not have been initialized
    tU8   u8Changed  = 0; //o means not changed 1 means changed
    tU16  u16DtcCode = 0;
    tBool bvalid     = TRUE;
    tBool bTestResultChanged = FALSE;

    ETG_TRACE_USR4 (("Begin: u8SetDiagLogDTCCode:: USB%1d DTCTestType %d u8Result=%d",
                     (tInt)usb, ETG_CENUM(tenUsbTestType,enDtcTestType), u8Result));

#ifdef USE_DECOUPLE_CYCLICDIAGCCA
    if ( bServiceIsAvailable == TRUE) // check for VD_Diaglog is availability
#else
    if ((bServiceIsAvailable == TRUE)&& (poTestData!=NULL)) // check for VD_Diaglog is availability
#endif //USE_DECOUPLE_CYCLICDIAGCCA
    {
#ifdef USE_FOURTH_USB_CONNECTOR
        if((usb<=ARRAYSIZEFORUSB) &&  (eUSB1 <=usb) && (usb<=eUSB4))
#else
        if((usb<=ARRAYSIZEFORUSB)&& (eUSB1 <=usb) && (usb<=eUSB3))
#endif
        {
            switch(enDtcTestType)
            {
            //=================================
            case enUSB_OVERCURRENT:
                //=================================

                //@todo replace switch later-----------------------
                switch(usb)
                {
                case eUSB1:
                    u8Index    = enITC_USB1_SIGNAL_OVERCURRENT;
                    u16DtcCode =   ITC_USB1_OVERCURRENT;
                    break;
                case eUSB2:
                    u8Index    = enITC_USB2_SIGNAL_OVERCURRENT;
                    u16DtcCode =   ITC_USB2_OVERCURRENT;
                    break;
                case eUSB3:
                    u8Index    = enITC_USB3_SIGNAL_OVERCURRENT;
                    u16DtcCode =   ITC_USB3_OVERCURRENT;
                    break;
#ifdef USE_FOURTH_USB_CONNECTOR
                case eUSB4:
                    u8Index = enITC_USB4_SIGNAL_OVERCURRENT;
                    u16DtcCode = ITC_USB4_OVERCURRENT;
                    break;
#endif
                default:
                    ETG_TRACE_FATAL((" [ERROR]: u8SetDiagLogDTCCode usb:%d", (tInt)usb));
                    ETG_TRACE_ERRMEM(("[ERROR]: u8SetDiagLogDTCCode usb:%d", (tInt)usb));
                    DVM_NORMAL_M_ASSERT_ALWAYS();
                    break;
                }
                //------------------------------------------------
                break ;
                //=================================
            case enUSB_HUB_NOT_DETECTED:
                //=================================
                //@todo replace switch later-----------------------
                switch(usb)
                {
                case eUSB1:
                    u8Index    = enITC_USB1_HUB_NOT_DETECTED;
                    u16DtcCode =   ITC_USB1_HUB_NOT_DETECTED;
                    break;
                case eUSB2:
                    u8Index    = enITC_USB2_HUB_NOT_DETECTED;
                    u16DtcCode =   ITC_USB2_HUB_NOT_DETECTED;
                    break;
                case eUSB3:
                    u8Index    = enITC_USB3_HUB_NOT_DETECTED;
                    u16DtcCode =   ITC_USB3_HUB_NOT_DETECTED;
                    break;
#ifdef USE_FOURTH_USB_CONNECTOR
                case eUSB4:
                    u8Index = enITC_USB4_HUB_NOT_DETECTED;
                    u16DtcCode = ITC_USB4_HUB_NOT_DETECTED;
                    break;
#endif
                default:
                    ETG_TRACE_FATAL((" [ERROR]: u8SetDiagLogDTCCode usb:%d", (tInt)usb));
                    ETG_TRACE_ERRMEM(("[ERROR]: u8SetDiagLogDTCCode usb:%d", (tInt)usb));
                    DVM_NORMAL_M_ASSERT_ALWAYS();
                    break;
                }
                //------------------------------------------------
                break;
                //=================================
            case enUSB_HUB_NUMBER_OF_PORT_MISMATCH:
                //=================================
                switch(usb)
                {
                case eUSB1:
                    u8Index    = enITC_USB1_HUB_NUMBER_OF_PORT_MISMATCH;
                    u16DtcCode =   ITC_USB1_HUB_NUMBER_OF_PORTS_MISMATCH;
                    break;
                case eUSB2:
                    u8Index    = enITC_USB2_HUB_NUMBER_OF_PORT_MISMATCH;
                    u16DtcCode =   ITC_USB2_HUB_NUMBER_OF_PORTS_MISMATCH;
                    break;
                case eUSB3:
                    u8Index    = enITC_USB3_HUB_NUMBER_OF_PORT_MISMATCH;
                    u16DtcCode =   ITC_USB3_HUB_NUMBER_OF_PORTS_MISMATCH;
                    break;
#ifdef USE_FOURTH_USB_CONNECTOR
                case eUSB4:
                    u8Index = enITC_USB4_HUB_NUMBER_OF_PORT_MISMATCH;
                    u16DtcCode = ITC_USB4_HUB_NUMBER_OF_PORTS_MISMATCH;
                    break;
#endif
                default:
                    ETG_TRACE_FATAL((" [ERROR]: u8SetDiagLogDTCCode usb:%d", (tInt)usb));
                    ETG_TRACE_ERRMEM(("[ERROR]: u8SetDiagLogDTCCode usb:%d", (tInt)usb));
                    DVM_NORMAL_M_ASSERT_ALWAYS();
                    break;
                }
                //------------------------------------------------
                break;

                //=================================
            case enUSB_POWER_SUPPLY_FAULT:
                //=================================
                switch(usb)
                {
                case eUSB1:
                    u8Index    = enITC_USB1_POWER_SUPPLY_FAULT;
                    u16DtcCode =   ITC_USB1_POWER_SUPPLY_FAULT;
                    break;
                case eUSB2:
                    u8Index    = enITC_USB2_POWER_SUPPLY_FAULT;
                    u16DtcCode =   ITC_USB2_POWER_SUPPLY_FAULT;
                    break;
                case eUSB3:
                    u8Index    = enITC_USB3_POWER_SUPPLY_FAULT;
                    u16DtcCode =   ITC_USB3_POWER_SUPPLY_FAULT;
                    break;
#ifdef USE_FOURTH_USB_CONNECTOR
                case eUSB4:
                    u8Index = enITC_USB4_POWER_SUPPLY_FAULT;
                    u16DtcCode = ITC_USB4_POWER_SUPPLY_FAULT;
                    break;
#endif //USE_FOURTH_USB_CONNECTOR

                default:
                    ETG_TRACE_FATAL((" [ERROR]: u8SetDiagLogDTCCode usb:%d", (tInt)usb));
                    ETG_TRACE_ERRMEM(("[ERROR]: u8SetDiagLogDTCCode usb:%d", (tInt)usb));
                    DVM_NORMAL_M_ASSERT_ALWAYS();
                    break;
                }
                //------------------------------------------------
                break;
                //=================================
            case enUSB_OPEN:
                //=================================
                switch(usb)
                {
                case eUSB1:
                    u8Index    = enITC_USB1_OPEN;
                    u16DtcCode =   ITC_USB1_OPEN;
                    break;
                case eUSB2:
                    u8Index    = enITC_USB2_OPEN;
                    u16DtcCode =   ITC_USB2_OPEN;
                    break;
                case eUSB3:
                    u8Index    = enITC_USB3_OPEN;
                    u16DtcCode =   ITC_USB3_OPEN;
                    break;
#ifdef USE_FOURTH_USB_CONNECTOR
                case eUSB4:
                    u8Index = enITC_USB4_OPEN;
                    u16DtcCode = ITC_USB4_OPEN;
                    break;
#endif //USE_FOURTH_USB_CONNECTOR

                default:
                    ETG_TRACE_FATAL((" [ERROR]: u8SetDiagLogDTCCode usb:%d", (tInt)usb));
                    ETG_TRACE_ERRMEM(("[ERROR]: u8SetDiagLogDTCCode usb:%d", (tInt)usb));
                    DVM_NORMAL_M_ASSERT_ALWAYS();
                    break;
                }
                //------------------------------------------------
                break;

                //=================================
            case enUSB_LINK_DISABLED:
                //=================================
                switch(usb)
                {
                case eUSB1:
                    u8Index    = enITC_USB1_LINK_DISABLED;
                    u16DtcCode =   ITC_USB1_LINK_DISABLED;
                    break;
                case eUSB2:
                    u8Index    = enITC_USB2_LINK_DISABLED;
                    u16DtcCode =   ITC_USB2_LINK_DISABLED;
                    break;
                case eUSB3:
                    u8Index    = enITC_USB3_LINK_DISABLED;
                    u16DtcCode =   ITC_USB3_LINK_DISABLED;
                    break;
#ifdef USE_FOURTH_USB_CONNECTOR
                case eUSB4:
                    u8Index = enITC_USB4_LINK_DISABLED;
                    u16DtcCode = ITC_USB4_LINK_DISABLED;
                    break;
#endif //USE_FOURTH_USB_CONNECTOR

                default:
                    ETG_TRACE_FATAL((" [ERROR]: u8SetDiagLogDTCCode usb:%d", (tInt)usb));
                    ETG_TRACE_ERRMEM(("[ERROR]: u8SetDiagLogDTCCode usb:%d", (tInt)usb));
                    DVM_NORMAL_M_ASSERT_ALWAYS();
                    break;
                }
                //------------------------------------------------
                break;

                //=================================
            case enUSB_SPEED_REDUCED:
                //=================================
                switch(usb)
                {
                case eUSB1:
                    u8Index    = enITC_USB1_SPEED_REDUCED;
                    u16DtcCode =   ITC_USB1_SPEED_REDUCED;
                    break;
                case eUSB2:
                    u8Index    = enITC_USB2_SPEED_REDUCED;
                    u16DtcCode =   ITC_USB2_SPEED_REDUCED;
                    break;
                case eUSB3:
                    u8Index    = enITC_USB3_SPEED_REDUCED;
                    u16DtcCode =   ITC_USB3_SPEED_REDUCED;
                    break;
#ifdef USE_FOURTH_USB_CONNECTOR
                case eUSB4:
                    u8Index = enITC_USB4_SPEED_REDUCED;
                    u16DtcCode = ITC_USB4_SPEED_REDUCED;
                    break;
#endif //USE_FOURTH_USB_CONNECTOR

                default:
                    ETG_TRACE_FATAL((" [ERROR]: u8SetDiagLogDTCCode usb:%d", (tInt)usb));
                    ETG_TRACE_ERRMEM(("[ERROR]: u8SetDiagLogDTCCode usb:%d", (tInt)usb));
                    DVM_NORMAL_M_ASSERT_ALWAYS();
                    break;
                }
                //------------------------------------------------
                break;
            case enITC_DATA_LINE_FAULT:
                //=================================
                switch(usb)
                {
                case eUSB1:
                    u8Index    = enITC_USB1_DATA_LINE_FAULT;
                    u16DtcCode = ITC_USB1_DATA_LINE_FAULT;
                    break;
                case eUSB2:
                    u8Index    = enITC_USB2_DATA_LINE_FAULT;
                    u16DtcCode = ITC_USB2_DATA_LINE_FAULT;
                    break;
                case eUSB3:
                    u8Index    = enITC_USB3_DATA_LINE_FAULT;
                    u16DtcCode = ITC_USB3_DATA_LINE_FAULT;
                    break;
#ifdef USE_FOURTH_USB_CONNECTOR
                case eUSB4:
                    u8Index = enITC_USB4_DATA_LINE_FAULT;
                    u16DtcCode = ITC_USB4_DATA_LINE_FAULT;
                    break;
#endif //USE_FOURTH_USB_CONNECTOR

                default:
                    ETG_TRACE_FATAL((" [ERROR]: u8SetDiagLogDTCCode usb:%d", (tInt)usb));
                    ETG_TRACE_ERRMEM(("[ERROR]: u8SetDiagLogDTCCode usb:%d", (tInt)usb));
                    DVM_NORMAL_M_ASSERT_ALWAYS();
                    break;
                }
                //------------------------------------------------
                break;

                //=================================
            default:
                //=================================
                bvalid = FALSE;
                ETG_TRACE_FATAL((" [ERROR]: u8SetDiagLogDTCCode enDtcTestType %d is not recognized",enDtcTestType));
                ETG_TRACE_ERRMEM(("[ERROR]: u8SetDiagLogDTCCode enDtcTestType %d is not recognized",enDtcTestType));
                DVM_NORMAL_M_ASSERT_ALWAYS();
            } // switch(enDtcTestType)
            if(TRUE ==bvalid)
            {
                if (f_rDtc_error[u8Index].s8DtcResult != u8Result)
                {
                    f_rDtc_error[u8Index].s8DtcResult = (tS8)u8Result;     // cast is OK because u8Result has values from 0 'FI_EN_PASSED' to 7 'FI_EN_ENABLE'
                    bTestResultChanged = TRUE;
                }
            }
        }
        else   // if( (eUSB1 <=usb) && (usb<=eUSB2))
        {
            ETG_TRACE_FATAL((" [ERROR]: u8SetDiagLogDTCCode usb:%d out of bound", (tInt)usb));
            ETG_TRACE_ERRMEM(("[ERROR]: u8SetDiagLogDTCCode usb:%d out of bound", (tInt)usb));
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }

        if (bTestResultChanged)  //@todo cleanup this variable with later release not necessary anymore
        {
#ifdef USE_DECOUPLE_CYCLICDIAGCCA
            vStoreResultInVector(u16DtcCode,u8Result,ListCyclicDiagResults);
#else
            midw_fi_tcl_TestResult     oTestResult;
            oTestResult.TroubleCode = u16DtcCode;
            //fill this oTestResult with result type from data
            oTestResult.Result.enType = (midw_fi_tcl_e8_TestResult::tenType)u8Result;

            //add the oTestResult into TestResultList
            poTestData->TestResultList.TestResultList.push_back(oTestResult);
#endif

            u8Changed = 1;
            ETG_TRACE_COMP(("*******************************************************************************"));
            ETG_TRACE_COMP(("u8SetDiagLogDTCCode: USB%1d DTCTestType=%d u8Result=%d",
                            (tInt)usb,
                            ETG_CENUM(tenUsbTestType,enDtcTestType),
                            u8Result
                            /*ETG_CENUM(midw_fi_tcl_e8_TestResult::tenType,u8Result)*/));
            switch(u8Index)
            {
            /*overcurrent*/
            case enITC_USB1_SIGNAL_OVERCURRENT:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCode:enITC_USB1_SIGNAL_OVERCURRENT : u8Result=0x%x",u8Result));
                break;
            case enITC_USB2_SIGNAL_OVERCURRENT:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCode:enITC_USB2_SIGNAL_OVERCURRENT : u8Result=0x%x",u8Result));
                break;
            case enITC_USB3_SIGNAL_OVERCURRENT:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCodeenITC_USB3_SIGNAL_OVERCURRENT : u8Result=0x%x ",u8Result));
                break;
#ifdef USE_FOURTH_USB_CONNECTOR
            case enITC_USB4_SIGNAL_OVERCURRENT:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCodeenITC_USB4_SIGNAL_OVERCURRENT : u8Result=0x%x ", u8Result));
                break;
#endif
                /*hub missing or not*/
            case enITC_USB1_HUB_NOT_DETECTED:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCode:enITC_USB1_HUB_NOT_DETECTED u8Result=0x%x",u8Result));
                break;
            case enITC_USB2_HUB_NOT_DETECTED:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCode:enITC_USB2_HUB_NOT_DETECTED u8Result=0x%x",u8Result));
                break;
            case enITC_USB3_HUB_NOT_DETECTED:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCodeenITC_USB3_HUB_NOT_DETECTED u8Result=0x%x ",u8Result)); //the codes came from Gen2 check if this is still valid
                break;
#ifdef USE_FOURTH_USB_CONNECTOR
            case enITC_USB4_HUB_NOT_DETECTED:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCodeenITC_USB4_HUB_NOT_DETECTED u8Result=0x%x ", u8Result)); //the codes came from Gen2 check if this is still valid
                break;
#endif
                /*hub number of port mismatch*/
            case enITC_USB1_HUB_NUMBER_OF_PORT_MISMATCH:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCode:enITC_USB1_HUB_NUMBER_OF_PORT_MISMATCH u8Result=0x%x",u8Result));
                break;
            case enITC_USB2_HUB_NUMBER_OF_PORT_MISMATCH:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCode:enITC_USB2_HUB_NUMBER_OF_PORT_MISMATCH u8Result=0x%x",u8Result));
                break;
            case enITC_USB3_HUB_NUMBER_OF_PORT_MISMATCH:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCodeenITC_USB3_HUB_NUMBER_OF_PORT_MISMATCH for  u8Result=0x%x ",u8Result));
                break;
#ifdef USE_FOURTH_USB_CONNECTOR
            case enITC_USB4_HUB_NUMBER_OF_PORT_MISMATCH:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCodeenITC_USB4_HUB_NUMBER_OF_PORT_MISMATCH for  u8Result=0x%x ", u8Result));
                break;
#endif

                /*power supply fault*/
            case enITC_USB1_POWER_SUPPLY_FAULT:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCode:enITC_USB1_POWER_SUPPLY_FAULT : u8Result=0x%x",u8Result));
                break;
            case enITC_USB2_POWER_SUPPLY_FAULT:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCode:enITC_USB2_POWER_SUPPLY_FAULT : u8Result=0x%x",u8Result));
                break;
            case enITC_USB3_POWER_SUPPLY_FAULT:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCodeenITC_USB3_POWER_SUPPLY_FAULT : u8Result=0x%x ",u8Result));
                break;
#ifdef USE_FOURTH_USB_CONNECTOR
            case enITC_USB4_POWER_SUPPLY_FAULT:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCodeenITC_USB4_POWER_SUPPLY_FAULT : u8Result=0x%x ", u8Result));
                break;
#endif

                /*usb open*/
            case enITC_USB1_OPEN:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCode:ITC_USB1_OPEN : u8Result=0x%x",u8Result));
                break;
            case enITC_USB2_OPEN:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCode:ITC_USB2_OPEN : u8Result=0x%x",u8Result));
                break;
            case enITC_USB3_OPEN:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCodeITC_USB3_OPEN : u8Result=0x%x ",u8Result));
                break;
#ifdef USE_FOURTH_USB_CONNECTOR
            case enITC_USB4_OPEN:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCodeITC_USB4_OPEN : u8Result=0x%x ", u8Result));
                break;
#endif

                /*link disabled*/
            case enITC_USB1_LINK_DISABLED:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCode:enITC_USB1_LINK_DISABLED : u8Result=0x%x",u8Result));
                break;
            case enITC_USB2_LINK_DISABLED:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCode:enITC_USB2_LINK_DISABLED : u8Result=0x%x",u8Result));
                break;
            case enITC_USB3_LINK_DISABLED:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCode:enITC_USB3_LINK_DISABLED : u8Result=0x%x ",u8Result));
                break;
#ifdef USE_FOURTH_USB_CONNECTOR
            case enITC_USB4_LINK_DISABLED:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCode:enITC_USB4_LINK_DISABLED : u8Result=0x%x ", u8Result));
                break;
#endif

                /*speed reduced*/
            case enITC_USB1_SPEED_REDUCED:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCode:enITC_USB1_SPEED_REDUCED : u8Result=0x%x",u8Result));
                break;
            case enITC_USB2_SPEED_REDUCED:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCode:enITC_USB2_SPEED_REDUCED : u8Result=0x%x",u8Result));
                break;
            case enITC_USB3_SPEED_REDUCED:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCode:enITC_USB3_SPEED_REDUCED : u8Result=0x%x ",u8Result));
                break;
#ifdef USE_FOURTH_USB_CONNECTOR
            case enITC_USB4_SPEED_REDUCED:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCode:enITC_USB4_SPEED_REDUCED : u8Result=0x%x ", u8Result));
                break;
#endif

                /*data line fault*/
            case enITC_USB1_DATA_LINE_FAULT:
                  ETG_TRACE_COMP(("u8SetDiagLogDTCCode:enITC_USB1_DATA_LINE_FAULT : u8Result=0x%x",u8Result));
                  break;
            case enITC_USB2_DATA_LINE_FAULT:
                  ETG_TRACE_COMP(("u8SetDiagLogDTCCode:enITC_USB2_DATA_LINE_FAULT : u8Result=0x%x",u8Result));
                  break;
            case enITC_USB3_DATA_LINE_FAULT:
                  ETG_TRACE_COMP(("u8SetDiagLogDTCCode:enITC_USB3_DATA_LINE_FAULT : u8Result=0x%x ",u8Result));
                  break;
#ifdef USE_FOURTH_USB_CONNECTOR
            case enITC_USB4_DATA_LINE_FAULT:
                ETG_TRACE_COMP(("u8SetDiagLogDTCCode:enITC_USB4_DATA_LINE_FAULT : u8Result=0x%x ", u8Result));
                break;
#endif
            default:
                ETG_TRACE_ERR(("u8SetDiagLogDTCCode: Unknow u8Index to ITC u8Result=0x%x",u8Result));
                break;
            }
            ETG_TRACE_COMP(("*******************************************************************************"));

        }
        else
        {
            ETG_TRACE_USR4 ((" u8SetDiagLogDTCCode Test result has not changed"))
        }
    }
    else
    {
#ifdef USE_DECOUPLE_CYCLICDIAGCCA
        ETG_TRACE_ERR (("Error u8SetDiagLogDTCCode Service is Not Available"));
#else
        ETG_TRACE_ERR (("Error u8SetDiagLogDTCCode Service is Not Available/poTestData==NULL "));
#endif
    }

    ETG_TRACE_USR4 (("End  : u8SetDiagLogDTCCode"));

    return u8Changed;
}  //  tVoid vd_devicemanager_tclClientHandler_Diaglog::vSetDiagLogDTCCode(tU..

void DiagnosisTroubleCoder::vStoreResultInVector(IN tU16 u16DtcCode,IN tU8 u8Result,INOUT vector<trDtcCodeResult> &ListCyclicDiagResults)
{
    trDtcCodeResult oResult;

    oResult.u8Result        = u8Result;
    oResult.u16DTroubleCode = u16DtcCode;

    ListCyclicDiagResults.push_back(oResult);
}
