
/*-----------------------------------------------------------------------------*
 * VD_DeviceManager_clienthandler_VD_MediaManager.h                            *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : G3G                                                   *
 * COPYRIGHT   :  (c) 2013-2020 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file VD_DeviceManager_clienthandler_VD_MediaManager.cpp
 *
 * \brief CCA client-handler for the service VD_MediaManager
 *
 * \version 11.06.2015, Rajeev Narayanan Sambhu (RBEI/ECS1), version 1.0
 *          Initial version
 */

#ifndef ADAPTEROPTICALDISCNOTIFICATIONS_H_
#define ADAPTEROPTICALDISCNOTIFICATIONS_H_
/*-----------------------------------------------------------------------------*
 * namespaces                                                                     *
 *-----------------------------------------------------------------------------*/





/*-----------------------------------------------------------------------------*
 * Defines                                                                     *
 *-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*
 * forwards declarations
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * Structs/enums                                                               *
 *-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class AdapterOpticalDiscNotifications
 *
 * \to derive the cdda media state.The input to the class will be passed from client
 * handler of vd_mediamanager.
 *
 */
class AdapterOpticalDiscNotifications {
public:
    /*!
     * \brief Default constructor
     *
     *
     */
    AdapterOpticalDiscNotifications();


    /*!
     * \brief Update the Serial number of the optical disk connected.
     *  This will be used by client
     * handler of vd_mediamanager
     * \param [in] f_cCDDASerialNumber      - Optical disk serial
     */

    tVoid vUpdateOpticalDiscSerialID(char f_cCDDASerialNumber[1024]);

    /*!
     * \brief method to calculate the insert state and checks whether the cdda can be playable
     *  This will be used by client
     * handler of vd_mediamanager
     * \param [in] u8CDType      - CD type
     * \param [in] u8InsertState - CD insert state
     * \param [in] u8MediaState  - CD media state
     * \return [out] the cd slot state
     *
     */
    tDMOpticalDiscSlotState vCalculateOpticalDiscState(IN tU8 u8CDType,IN tU8 u8InsertState,IN tU8 u8MediaState);
    /*!
         * \brief method to call the interface methods based on the cd state
         *  This will be used by vCalculateOpticalDiscState function
         *
         * \param [in]  eOpticalDiscSlotState      - derived  Slot State
         *
         */
    tVoid vSendResult(const tDMOpticalDiscSlotState  eOpticalDiscSlotState) ;
    /*!
         * \brief method to Simulate cd connection state
         *  This will be used by Trace command manager function
         *
         * \param [in] f_cConnectiontype        - Optical disc connection state
         * \param [in] uiCDDAMountPointPartOne   - Optical disc Mount point string (part1)
         * \param [in] uiCDDAMountPointPartTwo  - Optical disc Mount point string (part2)
         *
         */
    tVoid vSimulateCDDAConnection(IN DEVICE_CONNECTSTATUS_E eCDDAConnectionStatus,IN std::string &strCDDAMountPoint);
    
    /*!
         * \brief method to Simulate cd connection state
         *  This will be used by Trace command manager function. If a CDDA is inserted then SRx and SGx is gained from udev commands
         *
         * \param [in] f_cConnectiontype        - Optical disc connection state
         *
         */
    tVoid  vSimulateCDDAConnection(IN DEVICE_CONNECTSTATUS_E eCDDAConnectionStatuse);




    /*!
         * \brief method to call the interface methods based on the cd state
         *  This will be used by vCalculateOpticalDiscState function
         *
         * \param [in]  trOpticalDiskCDInfo      - CD Info Struct- Device State and Drive Version
         *
         */

    tVoid vSendCDInfo(IN trOpticalDiskCDInfo f_OpticalDiskCDInfo) ;


    /*!
         * \brief Destructor
         *
         *
         */

    virtual ~AdapterOpticalDiscNotifications();

    /*!
     * \brief method to calculate optical disc malfunction state
     *  \param [in] f_OpticalDeviceState   - Optical disc Device state
     *  \param [in] u8MediaState           - Optical disc Media state
     *  \return [out] True if the device is in malfunction state
     *
     */
    tBool bCalculateOpticalDiscMalfunctionState(IN tenOpticalDeviceState f_OpticalDeviceState,IN tU8 u8MediaState);

    /*!
     * \brief method to inform the optical disc malfunction state

     *  \param [in] f_bOpticalDiscMalfunctionstatus   - Optical disc Malfunction Status
     *
     *
     *
     */
    tVoid vSendMalfunctionStatus( IN tBool f_bOpticalDiscMalfunctionstatus);

private:

    /*!
             * \brief method to fill the device details in CDevice structure
             *
             *
             * \param [in] f_CDevice               - device structure
             * \param [in] eCDDAConnectionStatus   - connections status of the device
             * \param [in] strCDDAMountPoint       - Mount point of the cdda device.
             */

    tVoid vFillCDDADevice(OUT CDevice &f_CDevice, IN DEVICE_CONNECTSTATUS_E eCDDAConnectionStatus, IN std::string &strCDDAMountPoint);

    /*!
               * \brief method to fill the device details in CDevice structure
               *
               *
               * \param [in] f_CDevice               - device structure
               * \param [in] eCDDAConnectionStatus   - connections status of the device
               */

    tVoid vFillCDDADevice(OUT CDevice &f_CDevice, IN DEVICE_CONNECTSTATUS_E eCDDAConnectionStatus);



    static CDDA_IFOutput_t  m_CDDA_IFOutput_t[];
    tU8                     m_u8NumberofCDDAStates;
    char m_cCDDASerialNumber[1024];
    char m_cDriveVersion[DVMGR_MAX_DRIVEVERSIONLENGTH];



};

#endif /* ADAPTEROPTICALDISCNOTIFICATIONS_H_ */


////////////////////////////////////////////////////////////////////////////////
// <EOF>

