///@todo Gen3Generic VD_DVM DEVICE_TYPE_E in Enums.h types should be set to FI values this would also save code in VD_DVMService
/*-----------------------------------------------------------------------------*
 * Config.cpp                                                                  *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file Config.h
 *
 * \brief This file holds defines used for configuration
 *
 * \version 21.09.2011, Koechling, Christian (Bosch), initial version (Gen2)
 *
 *-----------------------------------------------------------------
 *                                   development for Gen3:
 *-----------------------------------------------------------------
 *\version 23.10.2013, Christian Koechling (Bosch)
 *         -# start tp replace QStrings by replacing QString by define GENSTRING
 *         -# adust build rule to build vd_dvm with ai_mediaplayer.prod
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifndef __CONFIG_H__
#define __CONFIG_H__

//-----------------------
//#define version
//-----------------------
#define VERSION_NUM_OF_COMPONENT "05.07.2019->GEN3:AI_MPLAY_TEAM_19.0F350"

//helper
#define IN     /*means INPUT PARAMETER    e.g. func(OUT result, IN val1, IN val2)*/
#define OUT    /*means OUTPUT PARAMETER*/
#define INOUT  /*mean is input to function function manipulates it that is is used as output*/
#define INTERN /*means is a function which is internally called @todo:check to replace it by direct call*/

//---------------------------------------------------------------------
//switches with dependencies to control if and how state machine informs clients
//----------------------------------------------------------------------

//---------------------------------
//diagnosis and end of line
//---------------------------------
#define CYLCIC_DIAGNOSIS_DISABLEFILE      "/var/opt/bosch/dynamic/media/cyclicdiag.off"
#define CYCLIC_DIAGNOSIS_DISABLEFILETEXT  "use it for test only:if this file exists then VD_DeviceManager cyclic diagnosis is disabled permanent"

//PDT-related
#define USE_DIAGSOLUTION_SIZEONLY           /*production diagnosis rely on size of connected usb-stick only */
#define DELAY_DIGANOSISRESULT_CYCLICDIAG 30 /*give 30s time to udev to get hubs notified then failed is allowed */ /*increased to prevent misleading entries in diagnosis errmem - asked Oliver Rademacher (02.02.2016) status:waiting for answer*/


//------------------------------
//other defines
//------------------------------
#define  USE_LOOKUP                  // former realisation: look up for connected devices

#define OBSERVER_INTERVAL_TIME             10 /*sec*/ //check every 10 sec if anything has changed concerning connected devices - this mechanism helps if notification mechanism would fail   ///@todo delete #else part if still exists
#define USE_EXTERNAL_UNSUPPORTED_DEVICES  //@todo if dully adjust to automounter then check if such vaiat can be used dynamically again VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_UNSUPPORTED_DEVICES
#ifndef USE_EXTERNAL_UNSUPPORTED_DEVICES
//This macro will be applied only for GM
//As the macro VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_UNSUPPORTED_DEVICES is set for Nissan and in the future for VWMib but not for GM
#define DISABLE_UNSUPPORTED_APPLE_DEVICES //devmgr should not send  unsupported apple devices for playback
#endif

#define BUGFIX_STARTUPRECOGNITION_INOTIFY
#define INOTIFY_DIR                "/tmp/.automounter/mounted_partitions_db/"
#define INOTIFY_MSC_DIR            "/tmp/.mountdb/"         ///@todo Gen3Generic VD_DVM: disabled - remove dependent code
#define INOTIFY_UNSUP_DIR          "/tmp/.unsupported/"
#define INOTIFY_APPLE_DIR          "/tmp/.appledev/"        ///@todo Gen3Generic VD_DVM: disabled - remove dependent code
#define INOTIFY_MTP_DIR            "/tmp/.mtpdev/"          ///@todo Gen3Generic VD_DVM: disabled - remove dependent code


//------------------------------
//History command
//------------------------------
///@todo check if HW-SD-card issues use Historymechanism (important for post error analysis)
///Lars will give hint for related files
#define HELPER_ANALYSIS_UDEVEVENTS          100  //store last adds for analysis   - support TTFIS cmd VD_DVM_GET_STORED_UDEV_EVTS
#define HELPER_ANAYLSIS_STATETABLE           50  //store states and messages of state table
#define HELPER_ANAYLSIS_SEND2CLIENTS         50  //store last messages to clients - see VD_DVM_GET_STORED_LAST_MSGS_SEND2CLIENTS
#define HELPER_ANAYLSIS_SEND2DIAGNOSIS       50  //store last messages send to diagnosis - see VD_DVM_GET_STORED_LAST_MSGS_SEND2DIAGNOSIS
#define HELPER_ANAYLSIS_PRMCALLBACKS         50  //store callbacks received by prm
#define HELPER_ANALYSIS_VOLTCALLLBACKS       50  //store notifications from spm
#define HELPER_ANALYSIS_SENDINTERFACESERVICE 50
#define HELPER_ANALYSIS_HWMALFUNCTION       300  //store notifications bound to mechanism HWMalfunction (temporyry not available)


//----------------------
//for test
//----------------------
#define STARTUP_DEVICEMONITOR_DISABLEFILE      "/var/opt/bosch/dynamic/media/devicemonitor.off"
#define STARTUP_DEVICEMONITOR_DISABLEFILETEXT  "use it for test only:if this file exists then VD_DeviceManager does not start monitor at use TTFIS cmd: VD_DVM_MONITOR_ENABLE"

#define STARTUP_SERVICEAVAILABLE_DISABLEFILE      "/var/opt/bosch/dynamic/media/serviceAtStartup.off"
#define STARTUP_SERVICEAVAILABLE_DISABLEFILETEXT  "use it for test only:if this file exists then VD_DeviceManager does not make its service available  use TTFIS cmd: VD_DVM_SETSERVICE AVAILABLE"

// Always send notifications
#define BUGFIX_POORDEVICERECOGNITION ///@todo care for Gen3 to clean

#define CHECK_LAST_DEVICE
#define SPECIALUSLEEP

//-------------------------------
//crit voltage and over current
//-------------------------------
#undef USE_SENT_ALL_CHANGES //replaces VARIANT_S_FTR_ENABLE_DEVMGR_SENT_ALL_CHANGES

#ifndef USE_SENT_ALL_CHANGES
#define ADJUST_OUTPUTAFTERDRITVOLT
#endif // #ifndef USE_SENT_ALL_CHANGES

#define WORKAROUND_PRM_U50_USB_RESET     //at startup PRM sends this as undefined this has negative influence on over current mechanism and simulating MSGs  ///@todo check if in the meantime driver has been fixed
#define MONITOR_PERMANENT_HW_FAILURE 15 /*sec*/ //has device permanent over current this will observed and later send to clients   ///@todo GenGeneric was thought to inform HMI about permanent overcurrent

#undef USE_ENABLE_DEVMGR_GPIOIF  //replaces VARIANT_S_FTR_ENABLE_DEVMGR_GPIOIF

//----------------------------------------------
//switches related to 'polling' and/or delays
//----------------------------------------------
/*mechanism uses polling - check for other solutions*/
#define USE_STARTUP_SYNC_UDEV             (int)100 /*ms*/
#define USE_APPLEDEVICEINFO_DELAY         (int)10  /*ms*/
#define USE_DELAY_RETRIAL_SEARCH_SOUNDDEV (int)200 /*ms*/
#define USE_DELAY_RETRIAL_SEARCH_MTP_MOUNTPOINT (int)200 /*ms*/
#define USE_DELAY_RETRIAL_LIBUSB_FILLDEVICE (int)200 /*ms*/

// If Apple device is empty then push it to incomplete list (sound device plus apple have to be available )
#define INCOMPLETE_DEV                               ///@todo Gen3Generic VD_DVM: always enabled keep code delete #else part and remove switch

//---------------------------------------------
//shift all device lists onto a singleton called DeviceListManager
//i.e. device list of stateTable, UdevManager and Service
//---------------------------------------------
#define IMPROVE_CRITVOLT                 ///@todo Gen3Generic VD_DVM: always enabled keep code remove #else part and #ifndef-part, remove switch

#define TTFISCMD_PRODUCTIONLINETEST     ///@todo Gen3Generic VD_DVM: always enabled keep code remove #else part and #ifndef-part, remove switch

#define KEYFILE_FAKE_SDCARD "SDCARD"


#define WRITEHISTORYTOUSBSTICK
#ifdef WRITEHISTORYTOUSBSTICK
    #define WRITEHISTORYTOUSBSTICK_KEY \
        "if this key exist in a file called 'LogHistory2USBStick.txt' then   "\
        "information is written to the USB stick which helps to analyse a    "\
        "device detection bug. A directory of current date will be created   "\
        "                                                                    "\
        "KEYSTART:1436578901ASDGTRURJNZEUTZUE345297297346986816450gfjt4gf813h"\
        "buaevzgurugftazugfkcbvuiagrzagzuabgvfdjjkhasdgf89489gfhgklsd8903hfkl"\
        "asdjkfioervnmdfyjkle82390rhcvn    w23rig398523958582938592- _:KEYEND"

    #define WRITEHISTORYTOUSBSTICK_KEYLEN                sizeof(WRITEHISTORYTOUSBSTICK_KEY)
    #define WRITEHISTORYTOUSBSTICK_KEYFILENAME           "LogHistory2USBStick.txt"
    #define WRITEHISTORYTOUSBSTICK_LOGFILENAME           "LogHistory2USBStick.log"
    #define WRITEHISTORYTOUSBSTICK_LOGFILENAME_PLATFORM  "LogHistory2USBStick_platform.log"
#endif //WRITEHISTORYTOUSBSTICK

#define GAINMOREINFOONRESET             //a sporadic reset has been observed and we need to get the retval from platform in ERROR_MEMORY   ///@todo Gen3Generic VD_DVM: always enabled remove #else part of switch and #define of switch


#define EOL_DELAY_AFTEROVERCURRENT   //in GM we don't use CriticalVolt Signal of SPM i.e. we rely on OC-Signals of USB-connectors
                                     //if OC = TRUE this means USB Connector has switched off because of Overcurrent
                                     // of low voltage (critical voltage level)
                                     // we assume if all connectors notifiy OC = TRUE that this is a situation where
                                     // critical voltage has taken place and thus INFO_USB_VOLTRECOV_AUTOPLAYDELAYTIME
                                     // has to be taken into account. INFO_USB_VOLTRECOV_AUTOPLAYDELAYTIME means an additional
                                     // delay before a connect after critical voltage is notified to clients of VD_DeviceManager
                                     // Note: Current solution delays if all connectors i.e. send OC signal i.e. OC1 and OC2 for USB1 and USB2

#define CODE_CLEANUP_SEPT             ///@todo Gen3Generic VD_DVM: always enabled remove #else part of switch and #define of switch

#undef  BUGFIX_UDEV_SETTLE          //additional effort to synchronise VD_DVM with UDEV //in G3G this is not necessary anymore @todo clean from code
#define BUGFIX_CLOSE                //don't close result of stat, care for close in error case  ///@todo Gen3Generic VD_DVM: always enabled remove #else part of switch and #define of switch
#define BUGFIX_DIAGGMHUB            //GMHUB has not been recognized   ///@todo Gen3Generic VD_DVM: always enabled remove #else part of switch and #define of switch

#define BUGFIX_NO_SERIALID          // Notify USB MS device even if the m_cSerialID is empty    ///@todo should be enabled always clean eventually existing #else part and #indefs then switch from code

#define BUGFIX_EMPTYSERIALID_IPOD

#define USE_OLDSTYLECONFIGURATION    //prepare: replace Info_rDmEolConfSettings by m_6ConfigurationValue[eINFO_LAST_ELEMENT];
#define USE_TOTAL_USED_FREE_SIZE  //use df to get sizes for Roadmap 13001,13023
#define USE_FILESYSTEMTYPE_ALIAS_FSTY //File system type is notified to the clients too
#define USE_PARITIONNUMBER    //Partition lnumber has to be notified to thr clients for Roadmap 13001,13002 //@todo always enable this

#undef USE_RANDOMID_CDDA //used for first bring up where automounter did not have identifier yet  - i.e. identifier has been created randomized

#define GENSTRING GenString


#define USE_THIRD_USB_CONNECTOR // Added to control the third USB connector
#define USE_FOURTH_USB_CONNECTOR // Added to control the fourth USB connector
#undef USE_TEST_GMWITH3PORTSFORPSA  //has to be undef before any release - if you have a vtable build problem you forgot to undef it!!

#define WORKAROUND_PRMBUG //if prm notifies at startup OC=SIG_UNDEF PPON=SIG_UNDEF this is mapped to OC=SIG_FALSE, PPON=SIG_TRUE i.e. normal behaviour
                           //in this manner not all device connection is suppressed within the ignition cycle where prm has malfunction


#undef UNDERCONSTRUCTION_ENABLE_AUTOMOUNTER_TXTIF_FULL    //withouth this switch /tmp/.autmounter is used like /tmp/.aumount   i.e. blockDevname and mountPoint are used other information is gained from ude-calls
                                                       // with this define set information is taken what is delivered by /tmp/.autmounter in mounted_partitions_db and device_db

#define BUGFIX_CONNECTIPOD_REMOVEUSBSAMETIME   //in GEN3 if an IPOD is connected and at the same time an USB stick is removed then IPOD might not be notified

#define USE_HUB_CONNECTED_TO_HUB
#define USE_HUB_CONNECTED_TO_HUB_ALLOW_IT_FILE      "/var/opt/bosch/dynamic/media/hub_connected_hub.on"
#define USE_HUB_CONNECTED_TO_HUB_ALLOW_IT_FILETEXT  "use it for test only:if this file exists then VD_DeviceManager enables connecting devices at a HUB connected to another HUB"

#define CLEANUP_QTSEMAPHORE_DISABLED  //if defined it still uses the old semaphore QT-READWRITELOCK

//DEVMGR_MOUNTCDROMINTERNAL cleanup necessary if backwardcompatibility is left - us tag as search key to find positions in code //@todo
//DEVMGR_DEVMANAGEROVERTEMPCD cleanup necessary if backwardcompatibility is left //@todo


#define CDROMDIAG_MOUNTPOINT                      (const char*)"/media/cdrom_diag"
#define CDROMDIAG_FILESYSTEMTYPE                  (const char*)"iso9660"
#define CDROMDIAG_FILESYSTEMTYPE_TESTWITHUSBSTICK (const char*)"vfat"


#define INTERMEDIATELY_DISABLED_USINGKDSVALUES_VAG //has to be tested first
#undef INTERMEDIATELY_DISABLED_USINGKDSVALUES_SUZ //has to be tested first
#undef INTERMEDIATELY_DISABLED_USINGKDSVALUES_RNAIVI
#undef INTERMEDIATELY_DISABLED_USINGKDSVALUES_CAF

//#define BUGFIX_PLATFORM_MISSING1 in HMI
//Info VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_GMMY16  //at startup in the past an empty device DTY_UNKNOWN has been send due to a reset in GM-HMI I had to keep this behaviour //@todo clean this

//used for testing if system does not show all traces from the beginning of startup VD_DeviceManager
//#define USE_DELAY_STARTUP_SECONDS (tU8)20 /*delay startup for 20sec of VD_DeVicemanager*/


#undef USE_HWCONFIGURATIONINIT  //if VARIANT_S_FTR_ENABLE_DEVMGR_USBHWCTRL this allows intialising at startup

//bound to VAG but never finished implementation
#undef USE_MEASUREMENT_RESISTANCE_USBCONNECTOR //switched off due to partial development only - for VAGMIBE

#undef USE_AUTMOUNTERLIB //Intermediate until it is fully tested


//#define GEN2_STRING_GEN2_CARDIF OSAL_C_STRING_RES_SDA /*see osdevice.h for definition*/
#define GEN3_STRING_GEN3_CARDIF "/dev/media"          /**/

#define STRING_CARD_INTERFACE GEN3_STRING_GEN3_CARDIF

//@todo clean //FillConnector( f_pCurDevice );  //replaced see below
//@todo clean fillTestDevices() and dependencies
// clean prm mount


#define THREAD_FACTORY_MAXNUMOFTHREADS 6 /*VoltageManager,StateTable,Workerthread,Automounter*/


#undef USE_VALIDATE_AND_CONVERT2REGION_LANGUAGE  //originally developped to serve GBK conversion we assume that this job has ben already by plattform - it#ll be tested

#undef USE_STATETABLESTOPS_VOLTAGETHREAD   //this has to be checked also to shutdown VD_DVM in a clean way

#define USE_MYSPIN_CHANGE       //SZH1_TEAM_FEA_GCO1SZH_146_01 handed over by Ullrich
#define USE_MYSPIN_CHANGE_PTP   //android phones could be configured PTP or MTP if configured MTP VD_DVM sets it to type MTP and checks with DetectMTPDevice (libmtp) if it is really an mtp device
                                //if it is configured PTP then VD_DVM will notify it as unsupported and miscalleanous for component listening for possible MySpin devices


#define WORKAROUND_MTP_NODEVICENAME //if LIBMTP_Get_Friendlyname returns emtpy string then this workaround helps to create a replacement name (Ticket: CMG3GB-932)
#define BUGFIX_MTP_SERIALNUMBER     //CMG3GB-938 there is a '#' plus devicenumber added to the serial number one has to thing to add something else device specific here

#define BUGFIX_REDUNDNANTMSGS_GM    //there is a problem that InformHWSignals leads to additional already done informDevices - this gives trouble for Carplay
                                   //clean solution has been implmented but needs to be fully tested


#define REFACTOR_STATETABLE_OUTPUT  //there are some redundant and intermediate messages send by VD_DeviceManager. This is related to the output StateTable - this switch marks a possible solution

#undef USE_RANDOMID_CDROM          //before automounter has been used  the ID of a CDROM had to be created random to force Mediaplayer indexing

#define BUGFIX_DECOUPLE_SDCARD_PRM  //prm sends information if USB connectors are available or not  - SDCArdInternal  has nothing to do with this
#define BUGFIX_DECOUPLE_CDROM_PRM   //prm sends information if USB connectors are available or not  - CDROMInternal has nothing to do with that


#define USE_EXPERIMENTAL_PSA_HUBCOMMUNICATION  //exprimental code to find out for PSA (later RNAIVI) if overcurrent happens at ports of the HUB. It is not yet clear if this cod ehas to be called from Rootdaemon later -first it is thought to be establised in usbutils.cpp/h

#define USE_PSA_DIAGLOG_ADDITIONAL_ITCS_FOR_MALFUNCTION   //in PSA an overcurrent at one detector leads to malfunction for all three USB connectors beside
                                                          //define ITC_USB1_OVERCURRENT, ITC_USB1_POWER_SUPPLY_FAULT, ITC_USB3_OPEN is send


#define USE_PSA_BTA_TELEMATICSBOX_ITCS                    //ITC_USB3_LINK_DISABLED will we send if FC_ATB announce that Application layer BTA communication fails. for this reason like for FC_HeatCtrl a property is provided to be set by
                                                                                                                                                                                                                                                                                                                                //ITC_USB3_SPEED_REDUCED HUBHardwareSignalReader has to observe this


#define INTERMEDIATEDEFINE_SHIFTFIRSTDIAGLOGMESSAGE     //should be always switched on in the future


#define TEMPORARY_UNAVAILABLE_INTERMEDIATE_SOLUTION


#define STATETABLE_MESSAGE_QUEUE_TIMEOUT_SEC    5  //Used by the temporary not available feature. Every 5 secs the timeout will happen to message queues of statetable, This timeout can be used for monitoring permanent malfunction
#define BUGFIX_CARE_PERMANENT_OVERCURRENT

#define MSD_BIGGEST_PARTITON_FEATURE

#undef WORKAROUND_EMPTYMESSAG  //if message is posted to q (gmp framework_so)but not yet fetched it turned out that there is a segmentaiton fault happening. Hence q will be emtied first

#define INTERMEDIATEDEFINE_REFACTORUDEV   //objective is to get functions necessary for device detection into a class called devierecognizer. This is done step by step in a way that each of the future releases will contain a partial step
                                          //1. step to make functions which should be shifted later reintrant
                                          //2. replace calls of those functions in udev by reintrant function calls
                                          //3. shift those functions to devicerecognized
                                          //4.  write unit tests for devicerecognizer

//----------------------------------
// Automounter shared lib
//----------------------------------

#undef USE_AUTMOUNTERSHAREDLIB_ENABLED  //in automounter.init it won't be started at all

#undef USE_AUTOMOUNTER_SHAREDLIB_TFTTHREAD_TEST   //automounter shared lib started to run in parallel to the tex based usage of automounter interface. Text based solution is still used //current status: callbacks received ok but reset if reading device-structure -> but has been addressed to Adit

#define TEST_AUTOMOUNTER_REGISTER_ALL_CALLBACKFUNCTIONS //for performance reason only some callbackfunctions are registed callbacks. Output of all possible callbacks are seen here
#ifdef USE_AUTOMOUNTER_SHAREDLIB_TFTTHREAD_TEST
#define USE_DELAY_STARTUP_SECONDS (tU8)30 /*delay startup for 30sec of VD_DeVicemanager*/
#endif


#define USE_REPLACE_DF_WITH_STATFS    //replace usage of df with statfs  //tbd.: future maintenance - this should be enabled always


//----------------------------------
// cyclic diag rectored
//----------------------------------

#define  USE_SHIFT_CYCLICDIAGNOSIS    //effort started because of GMMY17-13137 - see details within this ticket. Basic idea is to shift
#ifdef USE_SHIFT_CYCLICDIAGNOSIS      //defines shifted from VD_DeviceManager_main - it is always good to have less positions in code to search for ressource defines and configurations
                                      //2nd reason: VD_CLIENTHANDLER_DIAGLOG_TIMER_ID has to be visible for vd_DeviceManager_clienthandler_diaglog.h with USE_SHIFT_CYCLICDIAGNOSIS enabled
  #define VD_DEVICEMANAGER_TIMER_ID 0
  #define VD_DEVICEMANAGER_TIMER_TIME_UNTIL_FIRST_TICK 2000
  #define VD_DEVICEMANAGER_TIMER_TICK_INTERVALL 2000

  #define VD_CLIENTHANDLER_DIAGLOG_TIMER_ID 1
  #define VD_CLIENTHANDLER_DIAGLOG_TIMER_TIME_UNTIL_FIRST_TICK_SEC 3
  #define VD_CLIENTHANDLER_DIAGLOG_TIMER_TICK_INTERVAL_SEC 1
  //thread is started always currently is uses sleeps since accuracy of milliseconds is not used hence it'll run always but as lon as diag is not enabled it won't call underlying diag routines
  //to keep load low these intervalls have been chosen
  #define VD_CLIENTHANDLER_DIAGLOG_TIMER_TIME_UNTIL_FIRST_TICK_SEC_DEFAULT 15
  #define VD_CLIENTHANDLER_DIAGLOG_TIMER_TICK_INTERVAL_SEC_DEFAULT 10



  #define USE_DECOUPLE_CYCLICDIAGCCA   //CyclicThreadCalls calls an interface function which calls diaglog cca elements but this can be done only from VD_MAIN because it seems to fill things like FCID and APPLID implicietly
                                       //hence I free this code part from CCA-dependency to send the result to VD_DVM_MAIN which uses diaglog to send it

  #ifdef  USE_DECOUPLE_CYCLICDIAGCCA
    //either of these are allowed to be switched on
    #define USE_ENABLE_VD_DVM_CLH_DIAGLOG_ICYCLICDIAGRECEIVER
    #undef USE_SHIFT_PARTOFDIAG_TO_ADAPTER                //AdapterDiagnosisTroubleCode is a new container for diagnosis functions which could be seperated from VD_DEviceManager_clienthandler_Diaglog - in this manner it could be made testable
  #endif

#endif //USE_SHIFT_CYCLICDIAGNOSIS

#define TIMOUT_LOCK_DIAG_MS (tInt)10000 /*ms*/
#define  MARKER_UNUSED_CODE //this marker marks unused code after an additional check this should be cleaned from code
#define  USE_SUPPRESS_TRACES_LOOPBACK   //loopbackservice is if one sends himself messages into the cca queue to use it internally - service is not used thus traces would disturb
#define USE_BUGFIX_READINGKDS_SUZSLN //bit shifting wrong after reading from KDS - seen while writing unittests for this
#undef  USE_BUGFIX_READINGKDS_CAF //see USE_BUGFIX_READINGKDS_SUZSLN - Ra


//--------------------------------
//threads
//--------------------------------
/*
search for  'ThreadFactoryDVM::GetThreadFactory()->Do() to get a hint of the number of threads used by this code
1. StateTable.cpp (\\g3gdev-koe2hi\koe2hi_samba\koe2hi_gmg3g_linux_15.0b185.vws\ai_mediaplayer\components\vd_devicemanager\core):        tInt iThreadIndex = ThreadFactoryDVM::GetThreadFactory()->Do(IN this, (int)StateTable::eThread_StateTable, NULL); //starts thread eThread_SystemVolt - see 'Do'-function above
2. WorkThread.cpp (\\g3gdev-koe2hi\koe2hi_samba\koe2hi_gmg3g_linux_15.0b185.vws\ai_mediaplayer\components\vd_devicemanager\main):        tInt iThreadIndex = ThreadFactoryDVM::GetThreadFactory()->Do(IN this, (int)WorkThread::eThread_WorkThread, NULL); //starts thread
3. AutomounterAdapter.cpp (\\g3gdev-koe2hi\koe2hi_samba\koe2hi_gmg3g_linux_15.0b185.vws\ai_mediaplayer\components\vd_devicemanager\platform):    tInt iThreadIndex = ThreadFactoryDVM::GetThreadFactory()->Do(IN this, (int)AutomounterAdapter::eThread_AutomounterAdapter, NULL);
4. HUBHardwareSignalReader.cpp (\\g3gdev-koe2hi\koe2hi_samba\koe2hi_gmg3g_linux_15.0b185.vws\ai_mediaplayer\components\vd_devicemanager\platform):    tInt iThreadIndex = ThreadFactoryDVM::GetThreadFactory()->Do(IN this, (int)HUBHardwareSignalReader::eThread_HUBHardwareSignalReader, NULL);
5. VoltageManager.cpp (\\g3gdev-koe2hi\koe2hi_samba\koe2hi_gmg3g_linux_15.0b185.vws\ai_mediaplayer\components\vd_devicemanager\platform):         tInt iThreadIndex = ThreadFactoryDVM::GetThreadFactory()->Do(IN this, (int)VoltageManager::eThread_SystemVolt, NULL); //starts thread eThread_SystemVolt - see Do func
=> 5 threads
*/
#ifdef USE_SHIFT_CYCLICDIAGNOSIS
#define VDDVM_NUMOFTHREADS 7
#else
#define VDDVM_NUMOFTHREADS 6
#endif //USE_SHIFT_CYCLICDIAGNOSIS

#define USE_BUGFIX_DIAGNOSIS_READSSIZE_MSC   //prevent this error in trace:
                                             //FillStorageInfo: Begin [utils.cpp(374)]
                                             //<gen3flex@dlt>(core0)TIME_STAMP:237294 ms:(core0)VD_DVM_MGR_UDEV_US4 :FillStorageInfo: Mount point: MISCELLANEOUS [utils.cpp(387)]
                                             //<gen3flex@dlt>(core0)TIME_STAMP:237294 ms:(core0)VD_DVM_MGR_UDEV_ERR :FillStorageInfo: [ERROR] 'statfs' failed [No such file or directory] [utils.cpp(412)]

#define TIMOUT_LOCKDIAGLOG_LIST_SEC    (unsigned int)2       //CyclicDiag thread and vd_clientHandlerDiaglog use the same list - semaphore is used to lock this list to have thread save access . Locks use this timout
#define TIMOUT_LOCKCYCLICTHREAD_TIMOUT (unsigned int)10     //cyclic thread has a semophore for shutdown synchronisation. Lock in this context is used with timout

#ifdef TEMPORARY_UNAVAILABLE_INTERMEDIATE_SOLUTION
#define USE_HIGHRISK4USB_HWMALFUNCTION   //it turned out that the HW-signals via prm are slow - so we want to use additionally information from dev_volt or it should replace the information
#define USR_BUGFIX_UPDATEMALFUNCTION     //I think increasing interval should not be 5sec but less
#endif



#define INFORM_IF_TESTMODE(strFunctionName,u64TestValue)    ConfigurationManager::GetInstance()->InformIfTestmode(strFunctionName,u64TestValue); //in test mode some functions receive test values - these function have to use this macro . In this manne rone does see if test values are used in product code



//check where to find orifinal values
#define LEVEL_FATAL  0
#define LEVEL_COMP    4
#define LEVEL_USR4   8
#define ETG_TRACE_U64_FATAL(strDescriptionText,u64TestValue) ConfigurationManager::GetInstance()->EtgTraceU64Value(strDescriptionText, u64TestValue, LEVEL_FATAL); //ETG does not support values of 64bit this is a workaround
#define ETG_TRACE_U64_COMP(strDescriptionText,u64TestValue)  ConfigurationManager::GetInstance()->EtgTraceU64Value(strDescriptionText, u64TestValue, LEVEL_COMP); //ETG does not support values of 64bit this is a workaround
#define ETG_TRACE_U64_USR4(strDescriptionText,u64TestValue)  ConfigurationManager::GetInstance()->EtgTraceU64Value(strDescriptionText, u64TestValue, LEVEL_USR4); //ETG does not support values of 64bit this is a workaround




// please refer to section 5.1 in https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-730309/DESIGN_15003_HandlingOfTemporaryUnavailableDevices_05.doc
      //
      //                  r
      //                  e
      //                  m
      //                  o
      //                  v
      //                  e
      //     zerotime     |           nowtime
      //          |       |           |
      //      ->  | Tprev | Tpost     |<---
      //          |       |           |
      //

#define DVM_Tprev_ms  (tU16)4699 // /*milli seconds*/ //koe2hi 01.04.2016: Previously set value of 400ms did not work for RNAIVI | koe2hi 07.06.2016 Ticket NCG3D-1031 previously used value of 3000ms had to be increased
#define DVM_Tpost_ms  (tU16)300 /*milli seconds*/

//STATETABLE_EXECUTION_TIME_MS is for disconnection, malfunction and other events
#ifdef TEMPORARY_UNAVAILABLE_INTERMEDIATE_SOLUTION
#define STATETABLE_EXECUTION_TIME_MS DVM_Tpost_ms
#else
#define STATETABLE_EXECUTION_TIME_MS (tU16)200
#endif

//NCG3D-146730 : This timeout is for connection event. The Current HW+SW cannot send 2 simultaneous events with 100ms(value greater than this will delay the connection).
//In future if there is any project which can deliver 2 simultaneous events within 100ms then override this timeout value in that specific project config to achieve accumulation of events
#define STATETABLE_CONNECT_EXECUTION_TIME_MS (tU16)0

#define DEFAULT_LOCK_TIMOUT_SEC (unsigned int)10 //to see if locks get stuck this is helpful

#define USE_BUGFIX_AFTERMALFUNCTION_NEWMOUNTPOINT //after overcurrent/critical voltage device is notified with a new mount point

#undef USE_ECLAPSEDTIME_UNIXEPOCHE   //if undef we starttime equalts boot time otherwhise EPOCH TIME Unix i.e. from Jan 1970


//Note: For Maintenance - before deleting it check existing dependency
//eCONF_ENABLE_HWSIGNALS_MAPPING    is obsolete but in Config it is still in but marked obsolete: Please do this if a new value is necessary then use index 0x55 for this and all dependencies.
//eCONF_ENABLE_HWSIGNALS_SWAPPING is obsolete but in Config it is still in but marked obsolete: Please do this if a new value is necessary then use index 0x6A for this and all dependencies.


#undef USE_OLD_GETSYSPATH //we want to make USBConnector configuration bound to function vGetUSBConnectorFromSysPath generic so only one function in Congiguration Base is expected
#define USE_SYSPATH_MATCHER //in kds we can store some numbers the mechanism marked with this define can be used to map kds values to strings which are used to configure USB configuration

#define DIR_DEV_SUFFIX_LEN                                4 //strlen("/dev")

#undef USE_LIBUSBMTP_ERRMEM  //Writes errors of libmtp into the errormemory - special implmentation for PSA to analyse errors with libusb usage
#undef USE_LIBUSBRETRIAL_ERRMEM //Used for Testpurpose  retrials libusb are written to error memory

//Note: Currently direct readong of KDS-values is done this has to be changed to use data pool
#define GENERIC_KDS_ADDRESS_DEVICEMANAGER      0xA0B0  //CMG3G-10428
#define GENERIC_KDS_ADDRESS_DEVICEMANAGER_ARRAYOFVALUES_BYTELEN 92//bytes

#define GENERIC_KDS_ADDRESS_MEDIAPLAYER    0xA0C1  //CMG3G-11037
#define GENERIC_KDS_ADDRESS_MEDIAPLAYER_ARRAYOFVALUES_BYTELEN 32 //bytes


//https://hi-dms.de.bosch.com/docushare/dsweb/View/Collection-246901
#define RNAIVI_KDS_ADDRESS_CMVARIANTCODING    0x0DF4  //
#define RNAIVI_KDS_ADDRESS_CMVARIANTCODING_ARRAYOFVALUES_BYTELEN 32 //bytes


#define TEST_EJECT_BEFORESTARTUP  //produces fatal traces which show if eject has happened before startup of VD_DVM


#define INTERMEDIATE_PREVENT_REMOVE_DVD //with real PIVI current code can not differ between removal of DVDDrive (which never happens like with external sample drive) and removed disc which had been inserted previously

#undef TMP_CDDA    //intermediate switch to examine cdda recognition with UDEV by adding fatal traces to the system
#undef TEST_DVDDRIVE_CDDA_NOTIFICATION   //with DVDDrive it is possible to notify DTY_CDDA. Tests have shown that CDDACtrl gets stuck then
#define DEVICETYPE_RETRY_ELAPSED_TIMESEC 40 // this is to delay the notification of certain device type until a timeout is occurred
//#define SUSPICOUS_LOCKTIMOUT_SEC 40//if a thread stopps more than 40sec becoause it hangs on a lock this is suspicious an dmight be a deadlock. Hence internally in LockDVM we use lock with timout to generate a callstack plus thread

#define USE_DATAPOOL_INSTEADOF_KDS //diagnosis recommends to use datappol fnuciton instead of KDS-Function. This switch has been added to realise this.



///->!!!DON't USE WITH FEATURE BRANCH!!!
#undef USE_WORKAROUND_WRONG_PROJECT_CONFIGURATION //Meeting Project AIVI: FO Mediaplayer Thomas Beul, FO Diagnosis Christoph Koytek, Project leader Christioph Langner, Mediaplayer team : Christian Koechling.
                                                   //Context: Project uses wrong production diagnosis value. Customer forbids adjustment of PD-values at all thus requires this workaround: If Scope1 in PD Scope2 is used
//<-


// Needs to be reworked properly by MPlay team
// affected files:
//  \ai_mediaplayer\components\VD_DeviceManager\config\ConfigurationBase.cpp
//  \ai_mediaplayer\components\VD_DeviceManager\config\ConfigurationProduct_Gen3_RNAIVI.cpp
#ifdef OSAL_GEN4
#define USE_TMP_WORKAROUND_CLEO2   //udev monitor --propoerty shows this  /devices/platform/soc/ee080100.usb/usb1/1-1/1-1:1.0/host0/target0:0:0/0:0:0:0/block/sda/sda1 (block)
                                  // in contradiction to Gen3 'ee080100.usb' is part of the path  this has to be taken into account
#else
#undef USE_TMP_WORKAROUND_CLEO2   //udev monitor --propoerty shows this  /devices/platform/soc/ee080100.usb/usb1/1-1/1-1:1.0/host0/target0:0:0/0:0:0:0/block/sda/sda1 (block)
                                  // in contradiction to Gen3 'ee080100.usb' is part of the path  this has to be taken into account

#endif
#endif // __CONFIG_H__

////////////////////////////////////////////////////////////////////////////////
// <EOF>

