/* -------------------------------------------------------------------------- */
/**
 *   @defgroup meengine mecodec_null.hpp
 *   @ingroup  MEngine
 *   @author   Stephan Pieper, 2014
 *
 *   Void streaming codec.
 */
/* -------------------------------------------------------------------------- */
 
#if !defined(ME_CODEC_NULL_HPP_INCLUDED)
#define ME_CODEC_NULL_HPP_INCLUDED

/* -------------------------------------------------------------------------- */

#include "1_common/mebase.hpp"
 
/* -------------------------------------------------------------------------- */

namespace me {
 
/* -------------------------------------------------------------------------- */

struct codec_null_t : public codec_t,
                      public single_t<codec_null_t> {

   /* ----------------------------------------------------------------------- */

   friend class single_t<codec_null_t>;

   /* ----------------------------------------------------------------------- */

   virtual strings_t onexts() const {
      trace("codec_null:onexts()");
      static strings_t fts;
      if(fts.empty()) {
         fts.append(string_t("null"));
      }
      return fts;
   }

   virtual int_t onisaudio(string_t const &ext0) const { 
      if(0 == onexts().find_f(ext0)) return -1;
      return 0; // file extension *.null does not support audio;
   }      
   virtual int_t onisvideo(string_t const &ext0) const {
      if(0 == onexts().find_f(ext0)) return -1;
      return 0; // file extension *.null does not support video;
   }   

   
   /* ----------------------------------------------------------------------- */

   codec_null_t() {

       pump = false;
   }

   /* ----------------------------------------------------------------------- */

   virtual void_t oninit() {
      trace("me:codec_null:oninit");
   }
   virtual void_t mainloop() {
      trace("me:codec_null:mainloop");
   }
   virtual void_t onfini() {
      trace("me:codec_null:onfini");
   }

   /* ----------------------------------------------------------------------- */

   virtual int_t onctrl(state_t const &state) {

      playstate_e const ps = state.playstate;

      trace("me:codec_null:onctrl:", estr2(ps));

      //out.reason = REASON_END_OF_STREAM;
      //forward(out);

      trace("me:codec_null:onctrl:exit");

      return 1;
   }

   /* ----------------------------------------------------------------------- */

   virtual int_t read(file_t &file, int_t const& space, buffer_t &buf) {

      trace("me:codec_null:read:buf:", buf.str());
      thr_t::wait(100);
      return 0;
   }
   virtual int_t write(buffer_t const &buf) {

      trace("me:codec_null:write:buf:", buf.str());
      thr_t::wait(100);
      return 0;
   }

   /* ----------------------------------------------------------------------- */
};

/* -------------------------------------------------------------------------- */

#ifdef __cplusplus
   extern "C" {
#endif

codec_t *instance() {
   return &codec_null_t::inst();
}
 
#ifdef __cplusplus
   }
#endif

/* -------------------------------------------------------------------------- */

} // me;

/* -------------------------------------------------------------------------- */

#include "1_common/mecodecif.hpp"

/* -------------------------------------------------------------------------- */
 
 #endif // ME_CODEC_NULL_HPP_INCLUDED
 
/* -------------------------------------------------------------------------- */
