/* -------------------------------------------------------------------------- */
/*
 * MediaEngineIF.cpp
 *
 *  Created on: Mar 25, 2014
 *      Author: thm3hi
 */
/* -------------------------------------------------------------------------- */

#include "MediaEngineServerIF.h"
#include "MediaEngineServer.h"

/* instance of media engine state machine */
static MediaEngineServer mes;

#define THREAD_FACTORY_MAX_THREADS (5)

ThreadFactory ThreadFactory(THREAD_FACTORY_MAX_THREADS);

int RunMediaEngine(int RunInThread)
{
    me::trace("MediaEngineServerIF:RunMediaEngine");

    /* create the state machine */
    mes.Create();

    /* init state machine */
    mes.Init();

    me::trace("MediaEngineServerIF:RunMediaEngine:StartDbusMainLoop");

    /* start the Dbus main loop (must be after the Init call!) */
    int res = Dispatcher::GetInstance().mRemoteStateMachineManager.StartDbusMainLoop();

   if(0 != res) {
      me::trace("MediaEngineServerIF:RunMediaEngine:StartDbusMainLoop:failed");
    }

    me::trace("MediaEngineServerIF:RunMediaEngine:ThreadFactory.Create");

    /* init the thread factory */
    ThreadFactory.Create();

    /* synchronize startup 2 */
    #ifdef TARGET_BUILD
        sem_t* handle = (sem_t*)0;
        me::trace("MediaEngineServerIF:RunMediaEngine:sem_open");

        handle = sem_open("mestart", 0);
        MP_FATAL_ASSERT((sem_t*)0 != handle);
        res = sem_post(handle);
        MP_FATAL_ASSERT(0 == res);
    #endif

    if(RunInThread) {

        me::trace("MediaEngineServerIF:RunMediaEngine:run:thread");

        /* run media engine as extra thread (for cppunit tests) */
        ThreadFactory.Do(&mes, 0, NULL);
    } else {

        me::trace("MediaEngineServerIF:RunMediaEngine:run:process");

        /* do the main loop for the state machine (for media engine process) */
        mes.Do(0, NULL);
    }

    /* synchronize shutdown 2 */
    #ifdef TARGET_BUILD
        me::trace("MediaEngineServerIF:RunMediaEngine:sem_post");

        res = sem_post(handle);
        MP_FATAL_ASSERT(0 == res);
        res = sem_close(handle);
        MP_FATAL_ASSERT(-1 != res);
        handle = (sem_t*)0;
    #endif

    me::trace("MediaEngineServerIF:RunMediaEngine:exit");

    return 0;
}

/* -------------------------------------------------------------------------- */
