/* -------------------------------------------------------------------------- */
/**
 *   @defgroup meterminal meterminal.hpp
 *   @ingroup  MEngine
 *   @author   Stephan Pieper, 2016
 *
 *   TTfis input handler.
 */
/* -------------------------------------------------------------------------- */

#if !defined(ME_TERMINAL_HPP_INCLUDED)
#define ME_TERMINAL_HPP_INCLUDED

/* ------------------------------------------------------------------------- */

#define  OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "metrace.hpp"

/* -------------------------------------------------------------------------- */

namespace me {

/* -------------------------------------------------------------------------- */

struct terminal_t : public single_t<terminal_t> {

   /* -------------------------------------------------------------------- */

   friend class single_t<terminal_t>;

   /* -------------------------------------------------------------------- */

   typedef OSAL_tIODescriptor         fd_t;
   typedef TR_tenTraceChan            channel_t;
   typedef OSAL_trIOCtrlLaunchChannel launch_t;

   typedef void_t (*cb_t)(byte_t*, void_t*);

   /* -------------------------------------------------------------------- */

   terminal_t() : that(0), handle(OSAL_ERROR) {
   }
   ~terminal_t() {

      trace("me:terminal:isolate");
      isolate();
   };

   /* -------------------------------------------------------------------- */

   // provide callback handler or overload virtual funtion terminal();

   int_t setup(channel_t const channel0, cb_t cb0 = 0, void_t *that0 = 0) {

      trace("me:terminal:setup:channel:", channel0, hed, " cb:", (void_t*)cb0);

      launch.enTraceChannel =  channel0;
      launch.pCallback      = &callback;

      cb   = cb0;
      that = that0;

      return connect();
   }

   virtual void_t terminal(byte_t*, void_t*) {

      trace("me:terminal:terminal:error:missing overload");
   };

   static void_t callback(void_t* data) {

      terminal_t& term = inst();

      if(term.cb) {

         trace("me:terminal:callback:call fptr");
         (*term.cb)((byte_t*)data, term.that);

      } else {

         trace("me:terminal:callback:call virtual");
         term.terminal((byte_t*)data, term.that);
      }
   }

   /* -------------------------------------------------------------------- */

   int_t connect() {

      trace("me:terminal:connect");

      if(OSAL_ERROR != handle) {

         trace("me:terminal:connect:already opened");
         return -1;
      }

      handle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE);

      if(OSAL_ERROR == handle) {

         trace("me:terminal:connect:open failed");
         return -2;
      }

      int_t const res = OSAL_s32IOControl(handle, OSAL_C_S32_IOCTRL_CALLBACK_REG, (intptr_t)&launch);

      if(OSAL_ERROR == res) {

         trace("me:terminal:connect:reg launch failed");
         return -3;
      }
      trace("me:terminal:connect:success");
      return 0;
   }

   int_t isolate() {

      trace("me:terminal:isolate");

      if(OSAL_ERROR == handle) {

         trace("me:terminal:isolate:already isolated");
         return -1;
      }

      int_t res = OSAL_s32IOControl(handle, OSAL_C_S32_IOCTRL_CALLBACK_UNREG, (intptr_t)&launch);

      if(OSAL_ERROR == res) {

        trace("me:terminal:isolate:unreg launch failed");
        return -2;
      }

      res = OSAL_s32IOClose(handle);

      if(OSAL_ERROR == res) {

        trace("me:terminal:isolate:close failed");
        return -3;
      }

      handle = OSAL_ERROR;

      trace("me:terminal:isolate:success");
      return 0;
   }

   /* -------------------------------------------------------------------- */

   fd_t     handle;
   launch_t launch;

   cb_t    cb;
   void_t *that;

   /* -------------------------------------------------------------------- */
};

/* -------------------------------------------------------------------------- */

} // me;

/* -------------------------------------------------------------------------- */

 #endif // ME_TERMINAL_HPP_INCLUDED

 /* ------------------------------------------------------------------------- */
