/** -------------------------------------------------------------------------
	Copyright (C) 2012 RBEI
	All rights reserved.
	-------------------------------------------------------------------------
	This document contains proprietary information belonging to RBEI.
	Passing on and copying of this document, use and communication of its
	contents is not permitted without prior written authorization.
	-------------------------------------------------------------------------
	Revision Information:
	File name   : EventDispatcher.cpp
	Description : Source file to handle events
	Version     : 0.1
	Date        : 2012-10-01    
	Author      : RBEI

	Date        | Version  | Author      | Description
	2012-10-01    0.1		RBEI           Initial version
	------------------------------------------------------------------------- */

#include "EventDispatcher.h"

EventDispatcher* EventDispatcher::m_poEventDispatcher = NULL;

EventDispatcher::EventDispatcher()
{
}

EventDispatcher::~EventDispatcher()
{
//	if (m_poEventDispatcher != NULL)
//		delete m_poEventDispatcher;
    m_poEventDispatcher = NULL;
    if (m_Signals.size() > 0)
        m_Signals.clear();
}

EventDispatcher* EventDispatcher::poGetEventDispatcher()
{
	if(NULL == m_poEventDispatcher)
		m_poEventDispatcher = new EventDispatcher();
	return m_poEventDispatcher;
}

guint8 EventDispatcher::u8EmitEvent(guint32 u32EventId, gpointer pParam1, gpointer pParam2)
{
	u8CreateEvent(u32EventId);
	m_Signals[u32EventId].emit(u32EventId, pParam1, pParam2);
	return EVENT_DISPATCHER_OK; //TO DO : Return values made to be proper
}	

guint8 EventDispatcher::u8DetachConnection(sigc::connection oConnection)
{
	oConnection.disconnect();
	return EVENT_DISPATCHER_OK; //TO DO : Return values made to be proper
}	

guint8 EventDispatcher::u8CreateEvent(guint32 u32EventId)
{
	map <guint32,sigc::signal<void, guint32, gpointer, gpointer> >::iterator itSignal;
	guint32 u32EventId1 = u32EventId;
	itSignal = m_Signals.find(u32EventId1);
	if(itSignal == m_Signals.end())
	{
		sigc::signal<void, guint32, gpointer, gpointer> oNewSignal;
		m_Signals[u32EventId1] = oNewSignal;
	}

	return EVENT_DISPATCHER_OK; //TO DO : Return values made to be proper
}
