/** -------------------------------------------------------------------------
Copyright (C) 2012 RBEI
All rights reserved.
-------------------------------------------------------------------------
This document contains proprietary information belonging to RBEI.
Passing on and copying of this document, use and communication of its
contents is not permitted without prior written authorization.
-------------------------------------------------------------------------
Revision Information:
File name   : EventDispatcher.h
Description : Header file to handle events
Version     : 0.1
Date        : 2012-10-01    
Author      : RBEI

Date        | Version  | Author      | Description
2012-10-01    0.1        RBEI       Initial version
------------------------------------------------------------------------- */

#ifndef EVENTDISPATCHER_H_
#define EVENTDISPATCHER_H_
#include <iostream>
#include <stdlib.h>

#include <glib.h>
#include <sigc++/sigc++.h>

#include <map>

#include <iostream>

#include "FunctionTracer.h"

using namespace std;
//using namespace sigc;

enum tenEventDispatcherError
{
	EVENT_NOT_DEFINED = 0,
	EVENT_DISPATCHER_FAILED,
	EVENT_DISPATCHER_OK
};

class EventDispatcher
{
public:
	/**
	* poGetEventDispatcher:
	* @returns: returns pointer to event dispatcher
	*
	* Function to get pointer to the event dispatcher 
	**/
	static EventDispatcher* poGetEventDispatcher();
	//static EventDispatcher* m_poEventDispatcher;
	/**
	* oRegisterEvent:
	* @u32EventId: event ID
	* @_A_obj : object pointer
	* @_A_func: call back member function
	* @returns: sigc::connection object. Application has to store this and can use later to disconnect the slot from the event using the 'vDetachConnection' API
	*
	* register the event ID with callback. 
	**/	
	template <class T_obj, class T_obj2>
	sigc::connection oRegisterEvent(guint32 u32EventId, T_obj* _A_obj, void (T_obj2::*_A_func)(guint32,gpointer,gpointer))
	{
		u8CreateEvent(u32EventId);
		return (m_Signals[u32EventId].connect(sigc::mem_fun(_A_obj,_A_func)));
	}

	/**
	* u8DetachConnection:
	* @oConnection: The sigc::connection object, returned by  'oRegisterEvent' API
	* @returns: guint8
	*
	* detach the callback function from the event 
	**/
	guint8 u8DetachConnection(sigc::connection oConnection);
	
	/**
	* u8EmitEvent:
	* @u32EventId: event ID  
	* @pParam1: parameter1
	* @pParam2: parameter2
	* @returns: guint8
	*
	* emits the event. 
	**/
	guint8 u8EmitEvent(guint32 u32EventId, gpointer pParam1, gpointer pParam2);	
	~EventDispatcher();

private:
	// Constructor
	EventDispatcher();
	// copy constructor
	EventDispatcher(const EventDispatcher &);
	// Destructor

	guint8 u8CreateEvent(guint32 u32EventId);

private:
	static EventDispatcher *m_poEventDispatcher;
	map< guint32,sigc::signal<void, guint32, gpointer, gpointer> > m_Signals;
};

#endif /* CEVENTDISPATCHER_H_ */

