#if 0
# define ETRACE_S_IMPORT_INTERFACE_GENERIC
# define ET_TRACE_INFO_ON
# include "etrace_mp.h"

# ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#  define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_SERVICE_MEDIAPLAYER
#  ifdef TARGET_BUILD
#   include "trcGenProj/Header/GMPCommands.cpp.trc.h"
#   define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_SERVICE_MEDIAPLAYER
#  endif
# endif
# include "VarTrace.h"
#else
# define VARTRACE(x)
#endif

/*
 * GMPCommands.cpp
 *
 *  Created on: Jul 22, 2014
 *      Author: Matthias Thömel
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sys/mount.h>
#include <syslog.h>
#include <errno.h>
#ifdef TARGET_BUILD
#include <libkmod.h>
#endif
#include <glob.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <ctype.h>
#include <unistd.h> // for fork(), execve()
#include <sys/wait.h>  // for waitpid()

#include "GMPCommands.h"
#include "Utils.h"
#include "iPodControlCommon.h"

/*lint -save -e1773 */

#define STR_GADGET                              "gadget"
#define STR_HOST                                "host"

#define IAP2_OK                               0
#define IAP2_CTL_ERROR                       -1

#ifndef TRUE
# define TRUE                                  1
#endif

int iAP2Common_Write(const char* path, const char* subPath, const char* value, int checkBeforeWrite)
{
    int status = 0;
    char valuePath[256];
    int file = 0;

    int ret = snprintf(valuePath, 256, "%s/%s", path, subPath);
    if (ret >= 0 && ret < 256)
    {
        file = open(valuePath, checkBeforeWrite ? O_RDWR : O_WRONLY);
        if (file >= 0)
        {
            const size_t len = strlen_r(value);

            /* check before writing the same value */
            if (checkBeforeWrite == TRUE)
            {
                char buffer[len + 1]; /* to capture longer entries */
                ret = read(file, buffer, sizeof(buffer));
                if (ret == (int)len)
                {
                    if (0 == strncmp(buffer, value, len)) /* without trailing \0 */
                    {
                        /* no need to write */
                        status = TRUE;
                    }
                    // ETG_TRACE_USR3(("iAP2Common_Write():  read: %s", buffer));
                }
                else if (ret < 0)
                {
                    syslog(LOG_ERR, "iAP2Common_Write():  read: %d %s", errno, strerror(errno));
                }
            }

            /* write or skip if already the same value */
            if (status == 0)
            {
                ret = write(file, value, len);
                if (ret == (int)len)
                {
                    /* successful write */
                    status = 1;
                }
                else if (ret < 0)
                {
                    syslog(LOG_ERR, "iAP2Common_Write():  write: %d %s", errno, strerror(errno));
                }
            }

            close(file);
        }
        else
        {
            syslog(LOG_ERR, "iAP2Common_Write():  open: %d %s", errno, strerror(errno));
        }
    }

    return status;
}

int iap2Common_WriteValue(const char* path, const char* value)
{
    int status = 0;
    int file = 0;
    int ret = 0;

    file = open(path, O_WRONLY);
    if (file >= 0)
    {
        const size_t len = strlen_r(value) + 1;

        /* write or skip if already the same value */
        ret = write(file, value, len);
        if (ret == (int)len)
        {
            /* successful write */
            status = 1;
        }
        else if (ret < 0)
        {
            syslog(LOG_ERR, "WriteValue():  write: %d %s", errno, strerror(errno));
        }

        close(file);
    }
    else
    {
        syslog(LOG_ERR, "WriteValue():  open: %d %s", errno, strerror(errno));
    }

    return status;
}

#ifdef IPODCONTROL_IAP2_PF_CONFIGFS_NON_ROOT

int iap2InitGadgetConfiguration(iAP2_usbg_config_t* usb_gadget_configuration,
        const bool carPlayEnabled,
        const bool nativeTransportEnabled,
        const char * deviceID,
        const char * name,
        const char * modelIdentifier,
        const char * manufacturer,
        const char * serialNumber,
        const char * vendorID,
        const char * productID,
        const char * bcdDevice,
        const char * mountLocation,
        const char * udcDeviceName,
        const char * initEndPoint,
        const char * appName)
{
    int ret = IAP2_OK;

    char iAP2GadgetName[STRING_MAX]         = {0};
    strncpy_r(iAP2GadgetName, "iAP_Interface_", sizeof(iAP2GadgetName));
    strncat_r(iAP2GadgetName, deviceID, sizeof(iAP2GadgetName));
    usb_gadget_configuration->iAP2GadgetName                = (U8*)strndup((const char*)iAP2GadgetName, (STRING_MAX - 1) );

    char iAP2FFS_InstanceName[STRING_MAX]   = {0};
    strncpy_r(iAP2FFS_InstanceName, "ffs_", sizeof(iAP2FFS_InstanceName));
    strncat_r(iAP2FFS_InstanceName, deviceID, sizeof(iAP2FFS_InstanceName));
    usb_gadget_configuration->iAP2FFS_InstanceName = (U8*)strndup((const char*)iAP2FFS_InstanceName, STRING_MAX - 1);

    if(name) usb_gadget_configuration->iAP2AccessoryName = (U8*)strndup(name, (STRING_MAX-1));
    if(modelIdentifier) usb_gadget_configuration->iAP2AccessoryModelIdentifier = (U8*)strndup(modelIdentifier, (STRING_MAX-1));
    if(manufacturer) usb_gadget_configuration->iAP2AccessoryManufacturer = (U8*)strndup(manufacturer, (STRING_MAX-1));
    if(serialNumber) usb_gadget_configuration->iAP2AccessorySerialNumber = (U8*)strndup(serialNumber, (STRING_MAX-1));
    if(vendorID) usb_gadget_configuration->iAP2AccessoryVendorId = (U8*)strndup(vendorID, (STRING_MAX-1));
    if(productID) usb_gadget_configuration->iAP2AccessoryProductId = (U8*)strndup(productID, (STRING_MAX-1));
    if(bcdDevice) usb_gadget_configuration->iAP2AccessoryBcdDevice = (U8*)strndup(bcdDevice, (STRING_MAX-1));
    if(mountLocation) usb_gadget_configuration->iAP2ConfigFS_MountLocation = (U8*)strndup(mountLocation, (STRING_MAX-1));
    if(udcDeviceName) usb_gadget_configuration->iAP2UdcDeviceName = (U8*)strndup(udcDeviceName, (STRING_MAX-1));

    if(carPlayEnabled) {
        //CARPLAY ON
        usb_gadget_configuration->CarPlayEnabled = TRUE;

        char iAP2NCM_InstanceName[STRING_MAX]   = {0};
        strncpy_r(iAP2NCM_InstanceName, "USB_", sizeof(iAP2NCM_InstanceName));
        strncat_r(iAP2NCM_InstanceName, deviceID, sizeof(iAP2NCM_InstanceName));
        usb_gadget_configuration->iAP2NCM_InstanceName = (U8*)strndup((const char*)iAP2NCM_InstanceName, (STRING_MAX - 1) );

    } else {
        //CARPLAY OFF
        char iAP2UAC2_InstanceName[STRING_MAX]   = {0};
        strncpy_r(iAP2UAC2_InstanceName, "uac2_", sizeof(iAP2UAC2_InstanceName));
        strncat_r(iAP2UAC2_InstanceName, deviceID, sizeof(iAP2UAC2_InstanceName));
        usb_gadget_configuration->iAP2UAC2_InstanceName = (U8*)strndup((const char*)iAP2UAC2_InstanceName, (STRING_MAX - 1) );

#if defined(TARGET_BUILD_GEN3) && !defined(GEN3X86)
        usb_gadget_configuration->iAP2_UAC2_Attrs = new (usbg_f_uac2_attrs);
        if(usb_gadget_configuration->iAP2_UAC2_Attrs) {
            memset(usb_gadget_configuration->iAP2_UAC2_Attrs, 0, sizeof(usbg_f_uac2_attrs));
            usb_gadget_configuration->iAP2_UAC2_Attrs->c_chmask     = 3;
            usb_gadget_configuration->iAP2_UAC2_Attrs->c_srate_def  = 44100;
            usb_gadget_configuration->iAP2_UAC2_Attrs->c_ssize      = 2;
            usb_gadget_configuration->iAP2_UAC2_Attrs->delay_tout   = 80;
#ifdef VARIANT_S_FTR_ENABLE_CHY
            usb_gadget_configuration->iAP2_UAC2_Attrs->p_chmask     = 3;
#else
            usb_gadget_configuration->iAP2_UAC2_Attrs->p_chmask     = 0;
#endif
            usb_gadget_configuration->iAP2_UAC2_Attrs->p_srate_def  = 44100;
            usb_gadget_configuration->iAP2_UAC2_Attrs->p_ssize      = 2;
            usb_gadget_configuration->iAP2_UAC2_Attrs->c_srate      = "44100,48000";
            usb_gadget_configuration->iAP2_UAC2_Attrs->p_srate      = "44100,48000";
        }
#endif
    }

    usb_gadget_configuration->iAP2FFSConfig.initEndPoint = (U8*)strndup(initEndPoint, (STRING_MAX - 1) );
    if(nativeTransportEnabled) {
        usb_gadget_configuration->iAP2FFSConfig.nativeTransport = TRUE;

        int numApps = 1; //restriction to single native transport app support.
        usb_gadget_configuration->iAP2FFSConfig.iOSAppNames = new U8*[numApps];
        usb_gadget_configuration->iAP2FFSConfig.iOSAppIdentifier = new U8[numApps];
        if(usb_gadget_configuration->iAP2FFSConfig.iOSAppNames
                && usb_gadget_configuration->iAP2FFSConfig.iOSAppIdentifier) {

            usb_gadget_configuration->iAP2FFSConfig.nativeTransport = TRUE;
            usb_gadget_configuration->iAP2FFSConfig.iOSAppCnt = numApps;
            for(int i = 0; i < numApps; i++) {
                if(appName) usb_gadget_configuration->iAP2FFSConfig.iOSAppNames[i] = (U8*)strndup((const char*)appName, (STRING_MAX - 1) );
                usb_gadget_configuration->iAP2FFSConfig.iOSAppIdentifier[i] = i+1; //count from zero
            }
        }
    }

    return ret;
}

void iap2DeInitGadgetConfiguration(iAP2_usbg_config_t* usb_gadget_configuration)
{
    delete [] usb_gadget_configuration->iAP2GadgetName;
    delete [] usb_gadget_configuration->iAP2FFS_InstanceName;
    delete [] usb_gadget_configuration->iAP2AccessoryName;
    delete [] usb_gadget_configuration->iAP2AccessoryModelIdentifier;
    delete [] usb_gadget_configuration->iAP2AccessoryManufacturer;
    delete [] usb_gadget_configuration->iAP2AccessorySerialNumber;
    delete [] usb_gadget_configuration->iAP2AccessoryVendorId;
    delete [] usb_gadget_configuration->iAP2AccessoryProductId;
    delete [] usb_gadget_configuration->iAP2AccessoryBcdDevice;
    delete [] usb_gadget_configuration->iAP2ConfigFS_MountLocation;
    delete [] usb_gadget_configuration->iAP2UdcDeviceName;
    delete [] usb_gadget_configuration->iAP2UAC2_InstanceName;
#if defined(TARGET_BUILD_GEN3) && !defined(GEN3X86)
    delete usb_gadget_configuration->iAP2_UAC2_Attrs;
#endif
    delete [] usb_gadget_configuration->iAP2NCM_InstanceName;

    delete [] usb_gadget_configuration->iAP2FFSConfig.initEndPoint;
    delete [] usb_gadget_configuration->iAP2FFSConfig.iOSAppIdentifier;
    if(usb_gadget_configuration->iAP2FFSConfig.iOSAppNames) {
        for(unsigned int i = 0; i < usb_gadget_configuration->iAP2FFSConfig.iOSAppCnt; i++) {
            delete [] usb_gadget_configuration->iAP2FFSConfig.iOSAppNames[i];
        }
        delete [] usb_gadget_configuration->iAP2FFSConfig.iOSAppNames;
    }
}

#endif

uid_t GetGidByName(const char *groupName)
{
    if(groupName) {
        struct group *grp = getgrnam(groupName); /* don't free, see getgrnam() for details */
        if(grp) return grp->gr_gid;
    }
    return -1;
}

int ExecuteSystemCommand(char *argv[])
{
    if (!argv)       /* just checking... */
        return(1);

    pid_t pid;
    int status = -1;
    char *const envp[]  = { (char*)"GST_REGISTRY_UPDATE=no", (char*)"GST_REGISTRY_FORK=no", NULL};

#if 0 //SIGCHLD platform bug
    struct sigaction sigAction;
    memset(&sigAction, 0, sizeof(sigAction));
    sigAction.sa_handler = SIG_DFL;
    sigemptyset(&sigAction.sa_mask);
    sigAction.sa_flags   = 0;
    sigaction(SIGCHLD, &sigAction, 0);
#endif

    sig_t intsave, quitsave;
    sigset_t mask, omask;
    int pstat;

    sigemptyset(&mask);
    sigaddset(&mask, SIGCHLD);
    sigprocmask(SIG_BLOCK, &mask, &omask);
    switch (pid = vfork()) {
        case -1:        /* error */
            syslog(LOG_INFO, "vfork error: %d", pid);
            sigprocmask(SIG_SETMASK, &omask, NULL);
            return(-1);
        case 0:             /* child */
            syslog(LOG_INFO, "child execve");
            sigprocmask(SIG_SETMASK, &omask, NULL);
            execve(argv[0], argv, envp);
            syslog(LOG_INFO, "execve failed %d", errno);
            _exit(127);
    }

    syslog(LOG_INFO, "parent wait for %d", pid);
    // http://man7.org/linux/man-pages/man3/bsd_signal.3.html
    // change bsd_signal to signal
    intsave = (sig_t)  signal(SIGINT, SIG_IGN);
    quitsave = (sig_t) signal(SIGQUIT, SIG_IGN);
    pid = waitpid(pid, (int *)&pstat, 0);

    syslog(LOG_INFO, "waitpid returned: pid %d", pid);
    syslog(LOG_INFO, "waitpid returned: pstat %d", pstat);
    syslog(LOG_INFO, "waitpid returned: WIFEXITED %d", WIFEXITED(pstat));
    syslog(LOG_INFO, "waitpid returned: WEXITSTATUS %d", WEXITSTATUS(pstat));

    if(pid != -1 && WIFEXITED(pstat)) {
        //0-256 valid range, LSB 8 bit exit code of child process
        char cstatus = WEXITSTATUS(pstat);
        //cast to signed integer return value
        status = (cstatus & 0x80) ? (0xffffff00 | cstatus) : cstatus;
    }

    sigprocmask(SIG_SETMASK, &omask, NULL);
    (void)signal(SIGINT, intsave);
    (void)signal(SIGQUIT, quitsave);

    syslog(LOG_INFO, "ExecuteSystemCommand: returned %d", status);
    return status;
}

int GMPCommands::Command(const int commandNo, const char *arguments, const int timeoutMs)
{
    int err = -999;
    char commandString[2048];
    //static char lsCommand[2048];

    (void)timeoutMs;

    /* set log mask */
    setlogmask(LOG_UPTO(LOG_INFO));

    /* do the commands */
    switch(commandNo) {
        case GMP_CMD_UNMOUNT:

            strncpy_r(commandString, "umount ", sizeof(commandString));
            strncat_r(commandString, arguments, sizeof(commandString));

            syslog(LOG_INFO, "system(%s)", commandString);
            errno = 0;
            system(commandString);
            err = errno;
            break;

        case GMP_CAT_MTAB:
        {
            /* get the arguments */
            char *mountPoint;
            char *tmpFilename;
            char *iter;
            char *args = (char *)arguments;
            mountPoint = strtok_r(args, GMP_COMMANDS_DELIM, &iter); args = NULL;
            tmpFilename = strtok_r(args, GMP_COMMANDS_DELIM, &iter);

            /* issue the command */
            // cat /etc/mtab | awk -v m=/dev/media/2C200F50200F2086 '{  if ($2 == m) print $1 }'
            strncpy_r(commandString, "cat /etc/mtab | awk -v m=", sizeof(commandString));
            strncat_r(commandString, mountPoint, sizeof(commandString));
            strncat_r(commandString, " '{  if ($2 == m) print $1 }' > ", sizeof(commandString));
            strncat_r(commandString, tmpFilename, sizeof(commandString));

            syslog(LOG_INFO, "system(%s)", commandString);
            system(commandString);
            err = 0;

            break;
        }
        case GMP_DF:
        {
            /* get the arguments */
            char *mountPoint;
            char *tmpFilenameInterim;
            char *iter;
            char *args = (char *)arguments;
            mountPoint = strtok_r(args, GMP_COMMANDS_DELIM, &iter); args = NULL;
            tmpFilenameInterim = strtok_r(args, GMP_COMMANDS_DELIM, &iter);

            /* issue the command */
            strncpy_r(commandString, "df ", sizeof(commandString));
            strncat_r(commandString, mountPoint, sizeof(commandString));
            strncat_r(commandString, " | sed -e 's/sd./sdx/g' > ", sizeof(commandString));
            strncat_r(commandString, tmpFilenameInterim, sizeof(commandString));

            syslog(LOG_INFO, "system(%s)", commandString);
            system(commandString);
            err = 0;

            break;
        }
        case GMP_FIND:
        {
            /* get the arguments */
            char *mountPoint;
            char *searchString;
            char *outFileName;
            char *iter;
            char *args = (char *)arguments;
            mountPoint = strtok_r(args, GMP_COMMANDS_DELIM, &iter); args = NULL;
            searchString = strtok_r(args, GMP_COMMANDS_DELIM, &iter); args = NULL;
            outFileName = strtok_r(args, GMP_COMMANDS_DELIM, &iter);

            /* issue the command */
            strncpy_r(commandString, "find ", sizeof(commandString));
            strncat_r(commandString, mountPoint, sizeof(commandString));
            strncat_r(commandString, " -type f -regex ", sizeof(commandString));
            strncat_r(commandString, searchString, sizeof(commandString));
            strncat_r(commandString, " -exec sh -c 'printf \"%s\n\" \"$1\"; kill \"$PPID\"' sh {} \\; > ", sizeof(commandString));
            strncat_r(commandString, outFileName, sizeof(commandString));

            syslog(LOG_INFO, "system(%s)", commandString);
            system(commandString);
            err = 0;

            break;
        }
        case GMP_KILL_LS_1RA:
        {
            /* create the command */
            strncpy_r(commandString, "ps -ef | grep 'ls -1RA' | grep -v grep | awk '{ print $2 }' | xargs -r kill -9", sizeof(commandString));

            syslog(LOG_INFO, "system(%s)", commandString);
            system(commandString);
            err = 0;

            break;
        }
        case GMP_LS_1RA:
        {
            /* get the arguments */
            char *mountPoint;
            char *tmpFilenameInterim;
            //char *timeOutValue;
            char *iter;
            char *args = (char *)arguments;
            mountPoint = strtok_r(args, GMP_COMMANDS_DELIM, &iter); args = NULL;
            tmpFilenameInterim = strtok_r(args, GMP_COMMANDS_DELIM, &iter);
            //timeOutValue = strtok_r(args, GMP_COMMANDS_DELIM, &iter);

            /* create the command */
#ifdef VARIANT_S_FTR_ENABLE_GM
            strncpy_r(commandString, "nice -n 19 ionice -c2 -n7 ls -1RA ", sizeof(commandString));
#else
            //strncpy_r(commandString, "ls -1RAs ", sizeof(commandString));    //old flow where nice is NOT used
            strncpy_r(commandString, "nice -n 19 ionice -c2 -n7 ls -1RAs ", sizeof(commandString));
#endif
            strncat_r(commandString, mountPoint, sizeof(commandString));
#ifdef VARIANT_S_FTR_ENABLE_GM
            strncat_r(commandString, " | nice -n 19 sed -e 's/sd./sdx/g' >> ", sizeof(commandString));
#else
            //strncat_r(commandString, " | sed -e 's/sd./sdx/g' >> ", sizeof(commandString));   //old flow where nice is NOT used
            strncat_r(commandString, " | nice -n 19 sed -e 's/sd./sdx/g' >> ", sizeof(commandString));
#endif
            strncat_r(commandString, tmpFilenameInterim, sizeof(commandString));


#if 0 // not passing modultests - switched off until thomas knows why

            int timeOut = atoi(timeOutValue);

            /* create a script which will be sourced to bash */
            char *scriptName = tempnam("/tmp", "lscript");
            FILE *fpScript = fopen(scriptName, "w");
            if (fpScript) {

                syslog(LOG_INFO, "create: %s", scriptName);

                /* write the script */
                fprintf(fpScript, "#!/bin/bash\n");
                fprintf(fpScript, "%s &\n", commandString);
                fprintf(fpScript, "pid=$!\n");
                fprintf(fpScript, "sleep %d\n", (int)((timeOut/1000)+10)); // timeout value plus offset
                fprintf(fpScript, "if [ `ps -eo pid | grep $pid` ]\n");
                fprintf(fpScript, "  then\n");
                fprintf(fpScript, "    kill $pid\n"); // kill it
                fprintf(fpScript, "fi\n");
                fprintf(fpScript, "rm %s\n", scriptName); // remove myself

                /* close the script */
                fclose(fpScript);

                /* change the execution mode */
                chmod(scriptName, S_IXUSR | S_IRUSR | S_IWUSR);

                /* run (source) it */
                char waitScript[512];
                strncpy_r(waitScript, "source ", sizeof(waitScript));
                strncat_r(waitScript, scriptName, sizeof(waitScript));
                syslog(LOG_INFO, "system(%s)", waitScript);
                err = system(waitScript);
            }
#else
            syslog(LOG_INFO, "system(%s)", commandString);
            err = system(commandString);
#endif
            if (err != 0) {
                syslog(LOG_INFO, "return value: %i, errno: %i", err, errno);
            }

            break;
        }
        case GMP_GREP_CIE:
        {
            /* get the arguments */
            char *tmpFilenameInterim;
            char *searchString;
            char *tmpFilenameResult;
            char *iter;
            char *args = (char *)arguments;
            tmpFilenameInterim = strtok_r(args, GMP_COMMANDS_DELIM, &iter); args = NULL;
            searchString = strtok_r(args, GMP_COMMANDS_DELIM, &iter);
            tmpFilenameResult = strtok_r(args, GMP_COMMANDS_DELIM, &iter);

            /* issue the command */
            strncpy_r(commandString, "grep -ciE ", sizeof(commandString));
            strncat_r(commandString, searchString, sizeof(commandString));
            strncat_r(commandString, tmpFilenameInterim, sizeof(commandString));
            strncat_r(commandString, " > ", sizeof(commandString));
            strncat_r(commandString, tmpFilenameResult, sizeof(commandString));

            syslog(LOG_INFO, "system(%s)", commandString);
            system(commandString);
            err = 0;

            break;
        }
        case GMP_MD5SUM:
        {
            /* get the arguments */
            char *tmpFilenameInterim;
            char *tmpFilenameResult;
            char *iter;
            char *args = (char *)arguments;
            tmpFilenameInterim = strtok_r(args, GMP_COMMANDS_DELIM, &iter); args = NULL;
            tmpFilenameResult = strtok_r(args, GMP_COMMANDS_DELIM, &iter);

            /* issue the command */
            strncpy_r(commandString, "md5sum ", sizeof(commandString));
            strncat_r(commandString, tmpFilenameInterim, sizeof(commandString));
            strncat_r(commandString, " >> ", sizeof(commandString));
            strncat_r(commandString, tmpFilenameResult, sizeof(commandString));

            syslog(LOG_INFO, "system(%s)", commandString);
            system(commandString);

            err = 0;

            break;
        }

        case GMP_USB_RM_TEMP:
        {
            char *tmpFilename;
            char *iter;
            char *args = (char *)arguments;
            tmpFilename = strtok_r(args, GMP_COMMANDS_DELIM, &iter); args = NULL;

            /* issue the command */
            syslog(LOG_INFO, "remove(%s)", tmpFilename);
            err = remove(tmpFilename); // CID 10468 (#1 of 1): Unchecked return value from library (CHECKED_RETURN)
            if (err) {
                syslog(LOG_ERR, "ERROR(GMP) :- Remove error %d - %s ", errno, strerror(errno));
            }
            break;
        }

        case GMP_RM_FOLDER_CONTENT:
        {
            char *tmpFilename;
            char *iter;
            char *args = (char *)arguments;
            tmpFilename = strtok_r(args, GMP_COMMANDS_DELIM, &iter); args = NULL;

            /* issue the command */
            strncpy_r(commandString, "rm -rf ", sizeof(commandString));
            strncat_r(commandString, tmpFilename, sizeof(commandString));

            syslog(LOG_INFO, "system(%s)", commandString);
            system(commandString);

            break;
        }

        case GMP_IAP_LOAD_MODULE:
        {
            /* get the arguments */
            char *modname;
            char *params;
            char *iter;
            char *args = (char *)arguments;
            modname = strtok_r(args, GMP_COMMANDS_DELIM, &iter); args = NULL;
            params = strtok_r(args, GMP_COMMANDS_DELIM, &iter);

            syslog(LOG_INFO, "GMP_IAP_LOAD_MODULE '%s', params '%s'", modname, params);

#ifdef TARGET_BUILD
            struct kmod_module *mod = 0;
            struct kmod_ctx *ctx = 0;

            ctx = kmod_new(NULL, NULL);
            if (!ctx) {
                syslog(LOG_ERR, "kmod_new failed: %s", strerror(errno));
                err = -1;
            } else {

                err = kmod_module_new_from_name(ctx, modname, &mod);
                if (err != 0) {
                    syslog(LOG_ERR, "kmod_module_new_from_name(...,%s,..) failed: %s", modname, strerror(errno));
                } else {

                    err = kmod_module_insert_module(mod, KMOD_PROBE_APPLY_BLACKLIST, params);
                    if (err != 0) {
                        syslog(LOG_ERR, "kmod_module_insert_module(%s) failed: %s", modname, strerror(errno));
                    } else {
                        syslog(LOG_INFO, "kmod_module_insert_module(%s) ok", modname);
                    }
                    kmod_module_unref(mod);
                }
                kmod_unref(ctx);
            }
#endif
            break;
        }

        case GMP_IAP_UNLOAD_MODULE:
        {
            /* get the arguments */
            char *modname;
            char *iter;
            char *args = (char *)arguments;
            modname = strtok_r(args, GMP_COMMANDS_DELIM, &iter); args = NULL;

            syslog(LOG_INFO, "GMP_IAP_UNLOAD_MODULE '%s''", modname);

#ifdef TARGET_BUILD
            struct kmod_module *mod = 0;
            struct kmod_ctx *ctx = 0;

            ctx = kmod_new(NULL, NULL);
            if (!ctx) {
                syslog(LOG_ERR, "kmod_new failed: %s", strerror(errno));
                err = -1;
            } else {

                err = kmod_module_new_from_name(ctx, modname, &mod);
                if (err != 0) {
                    syslog(LOG_ERR, "kmod_module_new_from_name(...,%s,..) failed: %s", modname, strerror(errno));
                } else {
                    err = kmod_module_remove_module(mod, KMOD_PROBE_APPLY_BLACKLIST);
                    if (err != 0) {
                        syslog(LOG_ERR, "kmod_module_remove_module(%s) failed: %s", modname, strerror(errno));
                    } else {
                        syslog(LOG_INFO, "kmod_module_remove_module(%s) ok", modname);
                    }
                    kmod_module_unref(mod);
                }
                kmod_unref(ctx);
            }
#endif
            break;
        }

        case GMP_IAP_COMMON_WRITE:
        {
            /* get the arguments */
            char *otgPath;
            char *value;
            char *key;
            char *iter;
            char *args = (char *)arguments;
            otgPath = strtok_r(args, GMP_COMMANDS_DELIM, &iter); args = NULL;
            key = strtok_r(args, GMP_COMMANDS_DELIM, &iter);
            value = strtok_r(args, GMP_COMMANDS_DELIM, &iter);

            //switch OTG to Value
            if (TRUE != iAP2Common_Write(otgPath, key, value, TRUE))
            {
                syslog(LOG_ERR, "GMP_IAP_COMMON_WRITE():  writing  %40s/%40s to %s failed", otgPath, key, value);
                err = IAP2_CTL_ERROR;
            } else {
                syslog(LOG_INFO, "GMP_IAP_COMMON_WRITE(%40s/%40s, %s) ok", otgPath, key, value);
                err = IAP2_OK;
            }

            break;
        }

        case GMP_DU:
        {
            /* get the arguments */
            char *mountPoint;
            char *tmpFilename;
            char *iter;
            char *args = (char *)arguments;
            mountPoint = strtok_r(args, GMP_COMMANDS_DELIM, &iter); args = NULL;
            tmpFilename = strtok_r(args, GMP_COMMANDS_DELIM, &iter);

            /* issue the command */
            strncpy_r(commandString, "du -s ", sizeof(commandString));
            strncat_r(commandString, mountPoint, sizeof(commandString));
            strncat_r(commandString, " > ", sizeof(commandString));
            strncat_r(commandString, tmpFilename, sizeof(commandString));

            syslog(LOG_INFO, "system(%s)", commandString);
            system(commandString);
            err = 0;

            break;
        }

        case GMP_CMD_LS: // for module test
        {
            char command[1024];
            memset(command, 0, sizeof(command));
            strncpy_r(command, "ls -la -- ",sizeof(command));//CID 17376
            strncat_r(command, arguments, sizeof(command));
            strncat_r(command, " > /tmp/ls.txt", sizeof(command));
            syslog(LOG_INFO, "system(%s)", command);
            err = system(command);
            break;
        }
        case GMP_IAP_MOUNT: // mount for ipod
        {

#define FUNCTION_FS_NAME                        "ffs"
#define FUNCTION_FS_PATH                        "/dev/ffs"
#define FUNCTION_FS_PATH_EP                     "/dev/ffs/ep0"
#define FUNCTION_FS_TYPE                        "functionfs"

            mkdir(FUNCTION_FS_PATH, 0755);
            syslog(LOG_INFO, "mkdir(%s)", FUNCTION_FS_PATH);

#if 1
            /* temp workaround - till group is released*/
            mount(FUNCTION_FS_NAME, FUNCTION_FS_PATH, FUNCTION_FS_TYPE, 0, "mode=0777");
            syslog(LOG_INFO, "mount(%s,%s,%s,0,mode=0777)", FUNCTION_FS_NAME, FUNCTION_FS_PATH, FUNCTION_FS_TYPE);

#else // solution when the carplay is switched to user mode
            /* target */

            char cbuf[512];
            snprintf(cbuf, sizeof(cbuf), "mode=0770,gid=%d", GetGidByName("aid_gadgetffs"));
            mount(FUNCTION_FS_NAME, FUNCTION_FS_PATH, FUNCTION_FS_TYPE, MS_NOEXEC, cbuf);
            syslog(LOG_INFO, "mount(%s,%s,%s,%d,%s)", FUNCTION_FS_NAME, FUNCTION_FS_PATH, FUNCTION_FS_TYPE, MS_NOEXEC, cbuf);
#endif
            err = 0;
            break;
        }
        case GMP_IAP_MOUNT_CONFIGFS: // mount for ipod
        {
#define CONFIGFS_NAME "config"
#define CONFIGFS_PATH "/sys/kernel/config"
#define CONFIGFS_TYPE "configfs"
            /* temp workaround - till group is released*/
            mount(CONFIGFS_NAME, CONFIGFS_PATH, CONFIGFS_TYPE, 0, "mode=0777");
            syslog(LOG_INFO, "mount(%s,%s,%s,0,mode=0777)", CONFIGFS_NAME, CONFIGFS_PATH, CONFIGFS_TYPE);
            chmod(CONFIGFS_PATH, 0777);
#ifndef IPODCONTROL_IAP2_PF_CONFIGFS_NON_ROOT
#define CONFIGFS_USB_GADGET_PATH "/sys/kernel/config/usb_gadget"
            chmod(CONFIGFS_USB_GADGET_PATH, 0777);
            err = 0;
#else
            //non root user mode
            /* get the arguments */
            bool carPlayEnabled = false;
            bool nativeTransportEnabled = false;
            char * tmp = 0;
            char * deviceID = 0;
            char * name = 0;
            char * modelID = 0;
            char * manufacturer = 0;
            char * serialNumber = 0;
            char * vendorID = 0;
            char * productID = 0;
            char * bcdDevice = 0;
            const char * mountLocation = CONFIGFS_PATH;
            char * udcDeviceName = 0;
            const char * initEndPoint = "/dev/ffs/ep0";
            char * appName = 0;

            VARTRACE(arguments);

            char *iter;
            char *args = (char *)arguments;
            carPlayEnabled = !strcmp("true", strtok_r(args, GMP_COMMANDS_DELIM, &iter)); args = NULL;
            nativeTransportEnabled = !strcmp("true", strtok_r(args, GMP_COMMANDS_DELIM, &iter));
            deviceID = strtok_r(args, GMP_COMMANDS_DELIM, &iter);
            name = strtok_r(args, GMP_COMMANDS_DELIM, &iter);
            modelID = strtok_r(args, GMP_COMMANDS_DELIM, &iter);
            manufacturer = strtok_r(args, GMP_COMMANDS_DELIM, &iter);
            serialNumber = strtok_r(args, GMP_COMMANDS_DELIM, &iter);
            vendorID = strtok_r(args, GMP_COMMANDS_DELIM, &iter);
            productID = strtok_r(args, GMP_COMMANDS_DELIM, &iter);
            bcdDevice = strtok_r(args, GMP_COMMANDS_DELIM, &iter);
            udcDeviceName = strtok_r(args, GMP_COMMANDS_DELIM, &iter);
            appName = strtok_r(args, GMP_COMMANDS_DELIM, &iter);

            VARTRACE(carPlayEnabled);
            VARTRACE(nativeTransportEnabled);
            VARTRACE(deviceID);
            VARTRACE(name);
            VARTRACE(modelID);
            VARTRACE(manufacturer);
            VARTRACE(serialNumber);
            VARTRACE(vendorID);
            VARTRACE(productID);
            VARTRACE(bcdDevice);
            VARTRACE(udcDeviceName);
            VARTRACE(appName);

            iAP2_usbg_config_t usb_gadget_configuration;
            memset(&usb_gadget_configuration, 0, sizeof(usb_gadget_configuration));

            err = iap2InitGadgetConfiguration(&usb_gadget_configuration, carPlayEnabled, nativeTransportEnabled,
                    deviceID, name, modelID, manufacturer, serialNumber, vendorID, productID, bcdDevice, mountLocation, udcDeviceName, initEndPoint, appName);
            VARTRACE(err);
            syslog(LOG_INFO, "iap2InitGadgetConfiguration(): %d", err);
            if(err == IAP2_OK) {
                err = iAP2InitializeGadget(&usb_gadget_configuration);
                VARTRACE(err);
                syslog(LOG_INFO, "iAP2InitializeGadget(): %d", err);
                if(err == IAP2_OK) {
                    err = mkdir(FUNCTION_FS_PATH, 0755);
                    VARTRACE(err);
                    syslog(LOG_INFO, "mkdir(%s): %d", FUNCTION_FS_PATH, err);
                    if((err == 0) || (err == EEXIST)) {
                        err =  mount((char*)usb_gadget_configuration.iAP2FFS_InstanceName, FUNCTION_FS_PATH, FUNCTION_FS_TYPE, 0, "mode=0777");
                        VARTRACE(err);
                        syslog(LOG_INFO, "mount(%s,%s,%s,0,mode=0777): %d", (char*)usb_gadget_configuration.iAP2FFS_InstanceName, FUNCTION_FS_PATH, FUNCTION_FS_TYPE, err);
                        if(err == IAP2_OK) {
                            err = chmod(FUNCTION_FS_PATH, 0777);
                            VARTRACE(err);
                            syslog(LOG_INFO, "chmod(%s,0,mode=0777): %d", FUNCTION_FS_PATH, err);
                            if(err == IAP2_OK) {
                                err = chmod(FUNCTION_FS_PATH_EP, 0777);
                                VARTRACE(err);
                                syslog(LOG_INFO, "chmod(%s,0,mode=0777): %d", FUNCTION_FS_PATH_EP, err);
                                if(err == IAP2_OK) {
                                    err = iAP2InitializeFFSGadget(&usb_gadget_configuration);
                                    VARTRACE(err);
                                    syslog(LOG_INFO, "iAP2InitializeFFSGadget(%s): %d", (char*)initEndPoint, err);
                                }
                            }
                        }
                    }
                }
            }
            //clear up
            iap2DeInitGadgetConfiguration(&usb_gadget_configuration);
#endif
            break;

        }
        case GMP_IAP_UMOUNT: // mount for ipod
        {
            err = umount(FUNCTION_FS_PATH);
            if (err != 0) {
                err = errno;
            }
            syslog(LOG_INFO, "umount(%s)", FUNCTION_FS_PATH);
            break;
        }
        case GMP_IAP_UMOUNT_CONFIGFS: // mount for ipod
        {
#ifdef IPODCONTROL_IAP2_PF_CONFIGFS_NON_ROOT
            err = iAP2DeInitializeGadget();
            VARTRACE(err);
            syslog(LOG_INFO, "iAP2DeInitializeGadget(): %d", err);
#endif
            if (0 == access(CONFIGFS_PATH, F_OK)) {
                err = umount(CONFIGFS_PATH);
                VARTRACE(err);
                if (err != 0) {
                    err = errno;
                }
                syslog(LOG_INFO, "umount(%s): %i", CONFIGFS_PATH, err);

                //err = rmdir(CONFIGFS_PATH);
                //VARTRACE(err);
                //syslog(LOG_INFO, "rmdir(%s): %i", CONFIGFS_PATH, err);
            }

            if (0 == access(FUNCTION_FS_PATH, F_OK)) {
                err = umount(FUNCTION_FS_PATH);
                VARTRACE(err);
                if (err != 0) {
                    err = errno;
                }
                syslog(LOG_INFO, "umount(%s): %i", FUNCTION_FS_PATH, err);
                err = rmdir(FUNCTION_FS_PATH);
                VARTRACE(err);
                syslog(LOG_INFO, "rmdir(%s): %i", FUNCTION_FS_PATH, err);
            }
            break;
        }
        case GMP_USB_SCAN_VIDEO_METADATA:
        {
            char *pathToBin;
            char *videoFileName;
            char *tempFileName;
            char *iter;
            char *args = (char *)arguments;
            pathToBin = strtok_r(args, GMP_COMMANDS_DELIM, &iter); args = NULL;
            videoFileName = strtok_r(args, GMP_COMMANDS_DELIM, &iter);
            tempFileName = strtok_r(args, GMP_COMMANDS_DELIM, &iter);

            syslog(LOG_INFO, "GMP_USB_SCAN_VIDEO_METADATA from '%s' to '%s'", videoFileName, tempFileName);
#if 1
            char progName[1024];
            strncpy(progName, pathToBin, sizeof(progName)-1);
            strncat(progName, "/videometascan_out.out", sizeof(progName)-1);

            char *command[4];
            command[0] = progName;
            command[1] = videoFileName;
            command[2] = tempFileName;
            command[3] = NULL;
            syslog(LOG_INFO, "ExecuteSystemCommand(%s)", progName);
            err = ExecuteSystemCommand(command);
#else
            char command[1024];
            memset(command, 0, sizeof(command));
            strcpy(command, pathToBin);
            strncat(command, "/videometascan_out.out '", sizeof(command)-1);
            strncat(command, videoFileName, sizeof(command)-1);
            strncat(command, "' ", sizeof(command)-1);
            strncat(command, tempFileName, sizeof(command)-1);
            syslog(LOG_INFO, "system(%s)", command);

            err = system(command);
#endif
            if (err != 0) {
                syslog(LOG_INFO, "return value: %i, errno: %i", err, errno);
            }

            break;
        }
        //>--Roadmap CMG3G-10221 : 'Scene Recorder '
        case GMP_FILE_CHMOD:
        {
            char *pathToChange;
            char *mode;
            char *iter;
            char *args = (char *)arguments;
            pathToChange = strtok_r(args, GMP_COMMANDS_DELIM, &iter); args = NULL;
            mode = strtok_r(args, GMP_COMMANDS_DELIM, &iter);
            if(mode && pathToChange)
            {
                syslog(LOG_INFO, "GMP_FILE_CHMOD Path %s and Mode %s", pathToChange, mode);
                err = setfilePermission(pathToChange, mode);
            }
            break;
        }
        case GMP_MOUNT_OPERATION:
        {
            char *pathToChange;
            char *filetype;
            char *mode;
            char *iter;
            char *args = (char *)arguments;
            pathToChange = strtok_r(args, GMP_COMMANDS_DELIM, &iter); args = NULL;
            filetype = strtok_r(args, GMP_COMMANDS_DELIM, &iter);
            mode = strtok_r(args, GMP_COMMANDS_DELIM, &iter);
            if(pathToChange && filetype && mode)
            {
                err = setMountOperation(pathToChange,filetype, mode);
            }
            break;
        }
        //<--Roadmap CMG3G-10221 : 'Scene Recorder '
        case GMP_CMD_REMOVE_LS_TXT: // for module test
        {
            syslog(LOG_INFO, "system(rm /tmp/ls.txt)");
            err = system("rm /tmp/ls.txt");
            break;
        }
        case GMP_CMD_TEST_TRANSFER:
        {
            int len = strlen_r(arguments);

            /* search the number at the end of the test string */
            char *cptr = (char *)arguments + len - 1;
            while(cptr >= arguments) {
                if (!isdigit(*cptr)) break;
                cptr--;
            }

            /* send number back as error number */
            err = atoi(cptr);

            syslog(LOG_INFO, "string='%s', number=%d", arguments, err);
            break;
        }
        default:
            break;
    }

    return err;
}
//>--Roadmap CMG3G-10221 : 'Scene Recorder '
int GMPCommands::isFileAccessible(char *path)
{
    int ret = -1;
    if(path)
    {

        ret = access(path, F_OK);
        syslog(LOG_INFO, "GMP_FILE_DELETE isFileAccessible ='%s', %d", path, ret);
    }
    return ret;
}
int GMPCommands::setfilePermission(char *path, char* mode)
{
    int ret = -1;
    mode_t mType = getfileMode(path);
    tU32 r_mode = 0577;
    tU32 rw_mode = 0600;

    if(path && (0 == isFileAccessible(path)))
    {
        if(mode)
        {
            if(0 == strcmp(mode,"r"))
            {
                mType = mType & r_mode;
            }
            if(0 == strcmp(mode,"rw"))
            {
                mType = mType | rw_mode;
            }
        }
        if(0!=mType)
        {
            if ((ret = chmod(path, mType)) == -1) {
                syslog(LOG_ERR, "ERROR(GMP) :- not able to do chmod %d - %s ", errno, strerror(errno));
            }
            else
            {
                syslog(LOG_INFO, "SUCESS(GMP) :-  chmod ");
            }
        }
    }
    return ret;
}
int GMPCommands::setMountOperation(char *path, char *filetype, char* mode)
{
    int err = -999;
    char mount_cmd[100] = "mount -o ";
    char remount_cmd[20] = "remount,";

    if(path && mode)
    {
        strncat(mount_cmd, remount_cmd, sizeof(mount_cmd)-1);
        strncat(mount_cmd, mode, sizeof(mount_cmd)-1);
        strncat(mount_cmd, path, sizeof(mount_cmd)-1);
        syslog(LOG_INFO, "setMountOperation ExecuteSystemCommand(%s)", mount_cmd);
        err = system(mount_cmd);
        if (err != 0) {
           syslog(LOG_ERR, "ERROR(GMP) :- not able to do chmod %d - %s ", errno, strerror(errno));
        }
    }
#if 0
    if(path && filetype && mode)
    {
        syslog(LOG_INFO, "GMP_MOUNT_OPERATION mount point %s filetype %s Mode %s", path,filetype, mode);
        if(str == "rw")
        {
            ret = mount(path,path,filetype,MS_REMOUNT | MS_BIND ,NULL);
        }
        else
        {
            ret = mount(path,path,filetype,MS_REMOUNT | MS_BIND | MS_RDONLY,NULL);
        }
        if(-1 == ret)
        {
            syslog(LOG_ERR, "ERROR(GMP) :- not able to do mount %d - %s ", errno, strerror(errno));
        }
        else
        {
            syslog(LOG_INFO, "SUCESS(GMP) :-  mount ");
        }
    }
    #endif
    return err;
}
//<--Roadmap CMG3G-10221 : 'Scene Recorder '
