#ifndef _PLAYERMANAGERTEST_H_
#define _PLAYERMANAGERTEST_H_

#include <cppunit/extensions/HelperMacros.h>

#include "TypeDefinitions.h"
#include "TimeTrace.h"

#ifdef useTestFW
#include "test_util.h"
#include "Listener.h"


class PlayerManagerTest : public CppUnit::TestFixture, cBaseTest
#else
class PlayerManagerTest : public CppUnit::TestFixture
#endif
{
    CPPUNIT_TEST_SUITE( PlayerManagerTest );
    CPPUNIT_TEST( NewList_CreateMPIndexedList );
    CPPUNIT_TEST( SeekTo );                 //Inactive seek to
    CPPUNIT_TEST( Allocate );
    CPPUNIT_TEST( SourceActivityOn );
    // CPPUNIT_TEST( NextBuffer ); TODO: Enable again if feature gapless play is working
    CPPUNIT_TEST( AlbumArtAvailability );
    CPPUNIT_TEST( PlaybackActionNext );
    CPPUNIT_TEST( PlaybackActionMultipleNext );
    CPPUNIT_TEST( PlaybackActionPrev );
    CPPUNIT_TEST( PlaybackActionPrev );
    CPPUNIT_TEST( PlaybackActionMultiplePrev );
    CPPUNIT_TEST( FastNextInALoop );
    CPPUNIT_TEST( PlaybackActionPause );
    CPPUNIT_TEST( PlaybackActionFfwd );     //Fast forward in pause
    CPPUNIT_TEST( SeekTo );                 //Active seek to in pause
    CPPUNIT_TEST( PlaybackActionFrev );     //Fast reverse in pause
    CPPUNIT_TEST( PlaybackActionResume );
    CPPUNIT_TEST( PlaybackActionFfwd );     //Normal fast forward
    CPPUNIT_TEST( SeekTo );                 //Active seek to in pause
    CPPUNIT_TEST( PlaybackActionFrev );     //Normal fast reverse
    CPPUNIT_TEST( PlaybackActionStop );
    CPPUNIT_TEST( PlaybackActionResume );   //Stop is like Pause. We have to resume playback with Play again or AutoPlay is configured

    CPPUNIT_TEST( PlaybackActionFFwdInDealloate );
    CPPUNIT_TEST( PlaybackActionFRevInDealloate );

    CPPUNIT_TEST( NewList_CreateMPFileList );
    CPPUNIT_TEST( LastModeAfterSourceSwitch );
    CPPUNIT_TEST( NewList_ActiveMediaDeviceSet );
    CPPUNIT_TEST( StreamError_FileNotFound );
    CPPUNIT_TEST( StreamError_DevNotFound );
    CPPUNIT_TEST( NoPlayableContent );
    CPPUNIT_TEST( LastPlaytime );

    CPPUNIT_TEST( NewListTwice );
    CPPUNIT_TEST( PlayAndIndexingTogetherForPlaytimeUpdates );
    CPPUNIT_TEST( CheckSetPlaytimeStatus );
    CPPUNIT_TEST( CheckSetPlaytimeStatusforPlaytimeNone );

#if 0
    /* RemoteControl (streaming) tests */
    CPPUNIT_TEST( RemoteActivity );
    CPPUNIT_TEST( NowPlayingStatus );
    CPPUNIT_TEST( PlaytimeStatus );
    CPPUNIT_TEST( SeekTo );                 //Active seek to while streaming
    CPPUNIT_TEST( PlaybackActionPause );    //Pause while streaming
    CPPUNIT_TEST( PlaybackActionResume );   //Resume while streaming
    CPPUNIT_TEST( SendPlaybackMode );
    CPPUNIT_TEST( SendRepeatMode );
#endif

    CPPUNIT_TEST( SourceActivityOff );
    CPPUNIT_TEST( DeAllocate );
    CPPUNIT_TEST_SUITE_END();

public:

#ifdef useTestFW
    /**** Test frame work - Started ****/
    virtual void testCallback(cTestData *objTestData);
    void SourceActivityCallback(cTestData *objTestData);
    void (PlayerManagerTest::*funPtr)(cTestData *);
    /**** Test frame work - Ended ****/
#endif

    PlayerManagerTest();

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

    /*test cases*/
    void Allocate();
    void DeAllocate();
    void SourceActivityOn();
    void SourceActivityOff();
    void NewList_CreateMPIndexedList();
    void NewList_ActiveMediaDeviceSet();
    void NewList_CreateMPFileList();
    void SeekTo();
    void PlaybackActionNext();
    void PlaybackActionMultipleNext();
    void PlaybackActionPrev();
    void PlaybackActionMultiplePrev();
    void FastNextInALoop();
    void PlaybackActionPause();
    void PlaybackActionResume();
    void PlaybackActionStop();
    void PlaybackActionFfwd();
    void PlaybackActionFrev();
    void PlaybackActionFFwdInDealloate();
    void PlaybackActionFRevInDealloate();
    void StreamError_FileNotFound();
    void StreamError_DevNotFound();
    void NoPlayableContent();
    void LastModeAfterSourceSwitch();
    void LastPlaytime();
    void RemoteActivity();
    void NowPlayingStatus();
    void PlaytimeStatus();
    void SendPlaybackMode();
    void SendRepeatMode();
    void AlbumArtAvailability();
    void NextBuffer();
    void NewListTwice();
    void PlayAndIndexingTogetherForPlaytimeUpdates();
    void CheckSetPlaytimeStatus();
    void CheckSetPlaytimeStatusforPlaytimeNone();

private:
    void SourceActivityOff(int checkCallbackResult);
    tResult CheckPlaybackState(const tHMIPlaybackState stateToReach, const int timeoutInSec);
    tResult WaitForPosition(const tPlaytime position);

    TimeTrace ticks;        /**< time object to trace the time taken by testcases */
    tBoolean UcssortFolderCreated;
};

#endif  // _PLAYERMANAGERTEST_H_
