#ifndef _PICTUREMANAGERTEST_H_
#define _PICTUREMANAGERTEST_H_

#include <cppunit/extensions/HelperMacros.h>

class PictureManagerTest : public CppUnit::TestFixture

{
    CPPUNIT_TEST_SUITE( PictureManagerTest );
    CPPUNIT_TEST( InitTestsuite );
    CPPUNIT_TEST( NewList_CreateMPIndexedList );
    CPPUNIT_TEST( PlaybackActionNext );
    CPPUNIT_TEST( PlaybackActionPrev );
    CPPUNIT_TEST( PlaybackActionPause );
    CPPUNIT_TEST( PlaybackActionNextOnPaused );
    CPPUNIT_TEST( PlaybackActionPrevOnPaused );
    CPPUNIT_TEST( PlaybackActionPlay );
    CPPUNIT_TEST( PlaybackActionStop );
    CPPUNIT_TEST( PlaybackActionPlayOnStop );
    CPPUNIT_TEST( PlaybackActionStopOnPaused );
    CPPUNIT_TEST( EndTestsuite );
    CPPUNIT_TEST_SUITE_END();

public:

    PictureManagerTest();

    /*test cases*/
    void InitTestsuite();
    void EndTestsuite();
    void NewList_CreateMPIndexedList();
    void PlaybackActionNext();
    void PlaybackActionPrev();
    void PlaybackActionPause();
    void PlaybackActionNextOnPaused();
    void PlaybackActionPrevOnPaused();
    void PlaybackActionPlay();
    void PlaybackActionStop();
    void PlaybackActionPlayOnStop();
    void PlaybackActionStopOnPaused();


};



#endif /* PICTUREMANAGERTEST_H_ */
