/*
 * ILocalSPM.cpp
 *
 *  - Implementation
 *
 */

#include "LocalSPM_StartSM.h"
#include "LocalSPM_StopSM.h"
#include "ILocalSPM.h"
#include "LocalSPM.h"
#include "Dispatcher.h"

#include <sstream>

int ILocalSPM::CreateDone(int error)
{
    (void)error;
    mComponentState = COMPONENT_STATE_CREATE;
    return 0;
}

int ILocalSPM::InitDone(int error)
{
    (void)error;

    char parameter[32];
    LocalSPM::GetInstance().ParameterINIT_READY(parameter, sizeof(parameter)-1, mComponentID);
    Dispatcher::GetInstance().SendMessage("LocalSPMStartSM::INIT_READY", parameter);

    return 0;
};

int ILocalSPM::RunDone(int error)
{
    (void)error;

    char parameter[32];
    LocalSPM::GetInstance().ParameterRUN_READY(parameter, sizeof(parameter)-1, mComponentID);
    Dispatcher::GetInstance().SendMessage("LocalSPMStartSM::RUN_READY", parameter);

    return 0;
};

int ILocalSPM::StopDone(int error)
{
    (void)error;

    char parameter[32];
    LocalSPM::GetInstance().ParameterSTOP_READY(parameter, sizeof(parameter)-1, mComponentID);
    Dispatcher::GetInstance().SendMessage("LocalSPMStopSM::STOP_READY", parameter);

    return 0;
};

int ILocalSPM::DoneDone(int error)
{
    (void)error;

    char parameter[32];
    LocalSPM::GetInstance().ParameterDONE_READY(parameter, sizeof(parameter)-1, mComponentID);
    Dispatcher::GetInstance().SendMessage("LocalSPMStopSM::DONE_READY", parameter);

    return 0;
};

void ILocalSPM::SetState(tComponentState componentState )
{
    mComponentState = componentState;
}

const char* ILocalSPM::GetStateName(void) const
{
    switch(mComponentState)
    {
        case COMPONENT_STATE_CREATE:
            return "COMPONENT_STATE_CREATE";
        case COMPONENT_STATE_INIT:
            return "COMPONENT_STATE_INIT";
        case COMPONENT_STATE_RUNNING:
            return "COMPONENT_STATE_RUNNING";
        case COMPONENT_STATE_STOP:
            return "COMPONENT_STATE_STOP";
        case COMPONENT_STATE_DONE:
            return "COMPONENT_STATE_DONE";

        case COMPONENT_STATE_UNKNOWN:
        default:
            return "COMPONENT_STATE_UNKNOWN";

    }
}

const char* ILocalSPM::GetComponentName(void) const
{
    switch(mComponentID)
    {
        case COMPONENT_ID_INDEXER:
            return "COMPONENT_ID_INDEXER";
        case COMPONENT_ID_USB_CONTROL:
            return "COMPONENT_ID_USB_CONTROL";
        case COMPONENT_ID_IPOD_CONTROL:
            return "COMPONENT_ID_IPOD_CONTROL";
        case COMPONENT_ID_MTP_CONTROL:
            return "COMPONENT_ID_MTP_CONTROL";
        case COMPONENT_ID_LIST_CONTROL:
            return "COMPONENT_ID_LIST_CONTROL";
        case COMPONENT_ID_CUSTOM_CONTROL:
            return "COMPONENT_ID_CUSTOM_CONTROL";
        case COMPONENT_ID_PLAYER_MANAGER:
            return "COMPONENT_ID_PLAYER_MANAGER";
        case COMPONENT_ID_DEVICE_DISPATCHER:
            return "COMPONENT_ID_DEVICE_DISPATCHER";

        case COMPONENT_ID_DISPATCHER:
            return "COMPONENT_ID_DISPATCHER";
        case COMPONENT_ID_DB_MANAGER:
            return "COMPONENT_ID_DB_MANAGER";
        case COMPONENT_ID_DATA_PROVIDER:
            return "COMPONENT_ID_DATA_PROVIDER";
        case COMPONENT_ID_IPC_PROVIDER:
            return "COMPONENT_ID_IPC_PROVIDER";
        case COMPONENT_ID_CONFIGURATION:
            return "COMPONENT_ID_CONFIGURATION";
        case COMPONENT_ID_OUTPUTWRAPPER:
            return "COMPONENT_ID_OUTPUTWRAPPER";
        case COMPONENT_ID_CUSTOMCONTROL:
            return "COMPONENT_ID_CUSTOMCONTROL";
        case COMPONENT_ID_THREAD_FACTORY:
            return "COMPONENT_ID_THREAD_FACTORY";
        case COMPONENT_ID_BT_CONTROL:
            return "COMPONENT_ID_BT_CONTROL";
        case COMPONENT_ID_PICTURE_MANAGER:
             return "COMPONENT_ID_PICTURE_MANAGER";
        case COMPONENT_ID_MEDIA_ENGINE:
             return "COMPONENT_ID_MEDIA_ENGINE";

        case COMPONENT_ID_ROOT_DAEMON:
             return "COMPONENT_ID_ROOT_DAEMON";
        case COMPONENT_ID_CDDA_CONTROL:
              return "COMPONENT_ID_CDDA_CONTROL";
        case COMPONENT_ID_CS_CONTROL:
              return "COMPONENT_ID_CS_CONTROL";
        case COMPONENT_ID_IPOD_CONTROL_HELPER:
              return "COMPONENT_ID_IPOD_CONTROL_HELPER";
        case COMPONENT_ID_ALBUMART_INDEXER:
              return "COMPONENT_ID_ALBUMART_INDEXER";
        case COMPONENT_ID_UNKNOWN:
        default:
            return "COMPONENT_ID_UNKNOWN";
    }
}

char *ILocalSPM::GetSMStateName(OUT tGeneralString stateName, size_t size)
{
    strncpy(stateName, "n/a", size);
    return stateName;
};

tBoolean ILocalSPM::IsComponentSM()
{
    return false; //component is no state machine
};
