#ifndef _ListControlTest_H_
#define _ListControlTest_H_

/*lint -save -e578 */

#include <cppunit/extensions/HelperMacros.h>

#include <TypeDefinitions.h>
#include "SimulationOutputWrapper.h" //added for Roadmap 16014 'full text search'
#include <TimeTrace.h>

#define TEST_ROADMAP_16014
#define TEST_ROADMAP_16014_ONLY


#define NUM_OF_EXPECTED_MSGS_DISABLED_NONE 0



class ListControlTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( ListControlTest );
    CPPUNIT_TEST( InitTestsuite );

	//-->>Roadmap 160014 'Full text search'
	 //test function type: normal usage interface

    //search
    CPPUNIT_TEST(CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_NOMATCH);
    CPPUNIT_TEST(CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH );
    CPPUNIT_TEST(CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_INCREMENT1 );
    //take into account release of lists
    CPPUNIT_TEST(CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_ReleaseParentListWhichReleaseAlsoSearchList );
    CPPUNIT_TEST(CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_INCREMENT1_ABORT );
    CPPUNIT_TEST(CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_INCREMENT1_REPLACELIST_AfterSearchFinished );
    CPPUNIT_TEST(CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_INCREMENT1_REPLACELIST_DuringSearch);

    //take into account more user behaviour
    CPPUNIT_TEST(CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_INCREMENT1_REPLACELIST_USER_TYPE_CHARS_AfterEachSearchFinished);
    CPPUNIT_TEST(CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_INCREMENT1_REPLACELIST_USER_TYPE_CHARS_DuringEachSearch );

    //request slices
    CPPUNIT_TEST(RequestSlice_AfterSearchFinished_LTY_ARTIST_SEARCH);
    CPPUNIT_TEST( RequestSlice_AfterRleaseOfList_LTY_ARTIST_SEARCH);

    //test function type: wrong usage of interface scenarios
    CPPUNIT_TEST( RequestSliceSizeToHigh_AfterSearchFinished_LTY_ARTIST_SEARCH);

    //all other possible list types - basic test
    CPPUNIT_TEST(CreateMediaPlayerIndexedListWithSearchString_AllTypeOfLists_ParametrizedTest );
    CPPUNIT_TEST(CreateMediaPlayerIndexedListWithSearchString_AllTypeOfLists_ParametrizedTest_UseDummyContent);

/*
    //further possible tests - depend on available of additional modul (connectivity is elaborating resulty planned ot be reused here)
    //lower and upper!
    //check parent and check next of parent
	//test function type: wrong usage of interface scenarios
	CPPUNIT_TEST(CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_CreateMoreThanOneListAtTheTime(); //1%  //tbd.
	CPPUNIT_TEST(checkifSPMShutdowndestrysAllLists)
*/
	//Placeholder for tests which do this: 
	//list is created but size returned is 0
	//then a RequestListSlice is done
	//it turns out that it takes to much time to find e.g. 50 elements or evene more if the next list slice is required
	//a parallel mechanism is necessary to update Listinformation like the mechanism used with indexing
	//this mechanism has to search
	//=>first approach is not to do this kine of search
	
    //<<--Roadmap 16014 'Full text search'

    CPPUNIT_TEST( CreateMediaPlayerIndexedListForTests );
	CPPUNIT_TEST( CreateMediaPlayerFileList );
    CPPUNIT_TEST( CreatePlayableFilelist );
	// CPPUNIT_TEST( SetMediaObject ); // todo: set position failes because its using nowPlaying in list control, which is 0
	CPPUNIT_TEST( StoreLastPlayed );
	CPPUNIT_TEST( GetObjectID );
	CPPUNIT_TEST( CheckMediaObject );
	CPPUNIT_TEST( GetCurrentMediaObject );
	CPPUNIT_TEST( GetPositionInList );
	CPPUNIT_TEST( NextMediaObject );
    CPPUNIT_TEST( PrevMediaObject );
    CPPUNIT_TEST( RequestListInformation );
    CPPUNIT_TEST( Quicksearch_Itemfound );
    CPPUNIT_TEST( Quicksearch_Itemnotfound_following );
    CPPUNIT_TEST( Quicksearch_Itemnotfound_endoflist );
    CPPUNIT_TEST( Quicksearch_Unsupported_list );
    CPPUNIT_TEST( Quicksearch_File_list );
    CPPUNIT_TEST( SearchKeyboardMediaPlayerList );
    CPPUNIT_TEST( RequestMediaPlayerIndexedListSlice );
    CPPUNIT_TEST( RequestMediaPlayerIndexedListSliceMoreThanAvail );
    CPPUNIT_TEST( RequestMediaPlayerIndexedUUIDListSlice );
    CPPUNIT_TEST( RequestMediaPlayerIndexedListSlice_LTY_GENRE );
    CPPUNIT_TEST( RequestMediaPlayerIndexedListSlice_LTY_ARTIST );
    CPPUNIT_TEST( RequestMediaPlayerIndexedListSlice_LTY_GENRE_ARTIST_ALBUM );
    CPPUNIT_TEST( RequestMediaPlayerIndexedListSlice_LTY_ALBUM_UNKNOWN_ALBUMART );
    CPPUNIT_TEST( GetPlaybackMode );
    CPPUNIT_TEST( SetPlaybackMode );
    CPPUNIT_TEST( GetRepeatMode );
    CPPUNIT_TEST( SetRepeatMode );
    CPPUNIT_TEST( RepeatList );
    CPPUNIT_TEST( RepeatAll );
    CPPUNIT_TEST( RequestMediaPlayerFileListSlice );
    CPPUNIT_TEST( PlayMediaPlayerFileList );
    CPPUNIT_TEST( NextMediaPlayerFileList );
    CPPUNIT_TEST( StoreLastPlayedFileList );
    CPPUNIT_TEST( ParentFileListHighlighting );
    CPPUNIT_TEST( UpdateNowPlaying );
    CPPUNIT_TEST( CreateMediaPlayerPlaylistList );
    CPPUNIT_TEST( CreatePlayableFileList );
    CPPUNIT_TEST( CreatePlayableCDList );
    CPPUNIT_TEST( CreatePlayableFileList_IncludeSubFolder );
	CPPUNIT_TEST( CreatePlayList_4Tags );
	CPPUNIT_TEST( CreatePlayList_DoNextCheckGetPosition );
	CPPUNIT_TEST( CreatePlayList_Object );
	CPPUNIT_TEST( CreateRequestCreateReleaseRequest );
	CPPUNIT_TEST( CreateListCheckShuffle );
	CPPUNIT_TEST( CreateListAndCheckParents );
    CPPUNIT_TEST( CreateFollowingList );
    CPPUNIT_TEST( CreatePlaylist_RequestedMultipleTimesFor_SameAttributes_DifferentAttributes );
    CPPUNIT_TEST( CreateMediaPlayerFileList_RequestedMultipleTimesFor_SameAttributes_DifferentAttributes);
    CPPUNIT_TEST( CheckListsPerformanceTest );
    CPPUNIT_TEST( CreateLTY_YEAR);
    CPPUNIT_TEST( ReleaseList );
    CPPUNIT_TEST( ReleaseLastModeFileList );


    CPPUNIT_TEST_SUITE_END();

public:

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();
    ListControlTest();

    /*test cases*/	
    void InitTestsuite();
	void CreateMediaPlayerIndexedListForTests();
	void CreateMediaPlayerFileList();
    void CreatePlayableFilelist();
	void StoreLastPlayed();
	void SetMediaObject();
	void GetCurrentMediaObject();
	void GetPositionInList();
	void NextMediaObject();
    void PrevMediaObject();
    void CreatePlayList_4Tags();
    void CreatePlayList_DoNextCheckGetPosition();
    void CreatePlayList_Object();
    void ReleaseList();
    void ReleaseLastModeFileList();
	void RequestListInformation();
	void Quicksearch_Itemfound();
	void Quicksearch_Itemnotfound_following();
	void Quicksearch_Itemnotfound_endoflist();
	void Quicksearch_Unsupported_list();
	void Quicksearch_File_list();
 	void SearchKeyboardMediaPlayerList();
	void RequestMediaPlayerIndexedListSlice();
	void RequestMediaPlayerIndexedListSliceMoreThanAvail();
	void RequestMediaPlayerIndexedUUIDListSlice();
	void RequestMediaPlayerIndexedListSlice_LTY_GENRE();
	void RequestMediaPlayerIndexedListSlice_LTY_ARTIST();
    void RequestMediaPlayerIndexedListSlice_LTY_GENRE_ARTIST_ALBUM();
    void RequestMediaPlayerIndexedListSlice_LTY_ALBUM_UNKNOWN_ALBUMART();
	void GetPlaybackMode();
	void SetPlaybackMode();
	void GetRepeatMode();
	void SetRepeatMode();
	void RepeatList();
	void RepeatAll();
	void RequestMediaPlayerFileListSlice();
	void PlayMediaPlayerFileList();
	void NextMediaPlayerFileList();
	void StoreLastPlayedFileList();
    void ParentFileListHighlighting();
	void UpdateNowPlaying();
	void CreatePlayableFileList();
	void CreatePlayableCDList();
	void CreatePlayableFileList_IncludeSubFolder();
	void GetObjectID();
	void CheckMediaObject();
	void CreateMediaPlayerPlaylistList();
	void CreateRequestCreateReleaseRequest();
	void CreateListCheckShuffle();
    void CreateListAndCheckParents();
    void CreateFollowingList();

	//-->>Roadmap 160014 'Full text search'
	void CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_NOMATCH();
	void CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH();
	void CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_ReleaseParentListWhichReleaseAlsoSearchList();
	void CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_INCREMENT1();
	void CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_INCREMENT1_ABORT();
	void CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_INCREMENT1_REPLACELIST_AfterSearchFinished();
	void CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_INCREMENT1_REPLACELIST_DuringSearch();
	void CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_INCREMENT1_REPLACELIST_USER_TYPE_CHARS_AfterEachSearchFinished();
	void CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_INCREMENT1_REPLACELIST_USER_TYPE_CHARS_DuringEachSearch();
	void RequestSlice_AfterSearchFinished_LTY_ARTIST_SEARCH();
    void RequestSlice_AfterRleaseOfList_LTY_ARTIST_SEARCH();
    void RequestSlice_LTY_ARTIST_SEARCH_INCREMENT1_SEVERALSLIZES();
	void RequestSliceSizeToHigh_AfterSearchFinished_LTY_ARTIST_SEARCH(); 
	void CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_CreateMoreThatOneList(); 

	void CreateMediaPlayerIndexedListWithSearchString_AllTypeOfLists_ParametrizedTest();
	void CreateMediaPlayerIndexedListWithSearchString_AllTypeOfLists_ParametrizedTest_UseDummyContent();
	

	void CheckListsPerformanceTest();
	void CreateLTY_YEAR();
	void CreatePlaylist_RequestedMultipleTimesFor_SameAttributes_DifferentAttributes();
	void CreateMediaPlayerFileList_RequestedMultipleTimesFor_SameAttributes_DifferentAttributes();



	


protected:
	tResult helperSetupParentList_LTY_ARTIST_SEARCH(OUT tListID &listIDParent, OUT vector<tMediaObject> &mediaObjectVector);
	tResult helperSetupParentList_FullTextSearch(OUT tListID &listIDParent, IN tListType listType, IN tDeviceType testDevice=DTY_USB);
	tResult helperShowContentParentList(IN tListID listIDParent);
	tResult helperGetElementFromList(OUT tMediaObject &MediaObject, IN const std::string &stringToFind, IN tListID listID);
	tResult helperFillTestSearchString(IN tListID listIDParent,OUT std::string &searchString,OUT vector <std::string> &expectedResultList);
	tResult helperCheckContentOfList(IN tListID listIDSearch,IN std::vector <std::string> &expectedSearchResultList);
	
	tResult helperAddDeleteTestContentToDB(IN tDeviceType testDevice, IN tCategoryType categoryType,IN int numOfCategories,IN int numOfMediaObjectsToAdd, IN tBool bDelete = FALSE);
	

	tResult helperLoopTest(std::vector<tListType> &listTypesOfFullTextSearch);

	
	tResult    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(IN SimulationOutputWrapper *pSimulationOutputWrapper,
	                                                                  IN SimulationOutputWrapper::tenFctType eFctTypeExpected,
	                                                                  IN tListID listIDExpected,
	                                                                  IN tListSize listSizeExpected,
	                                                                  IN tDeviceID deviceIDExpected,
	                                                                  IN int       numOfExpectedMsgs = NUM_OF_EXPECTED_MSGS_DISABLED_NONE);

	tListSize helperWaitCheckAnswer_MethodReturnCreateListWithSearchStringAll(IN SimulationOutputWrapper *pSimulationOutputWrapper,
                                                                                IN tListID listIDExpected,
                                                                                IN tListSize listSizeExpected,
                                                                                IN tDeviceID deviceIDExpected,
                                                                                IN int numOfExpectedMsgs = NUM_OF_EXPECTED_MSGS_DISABLED_NONE);


    //<<--Roadmap 160014 'Full text search'
	

private:
    TimeTrace	 	 ticks;			/**< time object to trace the time taken by testcases*/

    pthread_cond_t   condition ;	/**< wait condition used for asynchronous test cases */
    pthread_mutex_t  mutex ;		/**< lock used during asynchronous test case execution*/
};

#endif  // _ListControlTest_H_
