/*
 * ListControl.cpp
 *
 *  Created on: Sep 6, 2012
 *      Author: tritonsu
 */
/*lint -save -e578 */
/* ETG definitions */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_LISTCONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/ListControl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_LISTCONTROL
#endif
#endif
#include "FunctionTracer.h"
#include "VarTrace.h"

/* others */
#include <stdlib.h>
#include <string.h>
#include "TypeDefinitions.h"
#include "LocalSPM.h"
#include "ListControl.h"
#include "Lock.h"
#include <TimeTrace.h>
#include <fstream>
#include <iterator>
#include "sortlib_helper.h"
#include "sortlib.h"
#include <taginfo.h>
using namespace std;
using namespace TagInfo;
#ifdef VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
#ifndef _FC_MEDIAPLAYER_ROOTDAEMON_CLIENT_H_
#include "FC_MediaPlayer_rootdaemon_client.h"
#endif
#else
#include "GMPCommands.h"
#endif

//#define ENTRY           FunctionTracer  _t(ETG_DEFAULT_TRACE_CLASS,__PRETTY_FUNCTION__);
#define QS_DEFAULT_STARTPOSITION      0  // Quicksearch default startpostion

#define QS_NONSPECIALCHAR_FIRST_RANK   256    //Quicksearch first value for nonspecial character

#define NEW_SHUFFLE_TABLE_RETRY_LIMIT  4 //Max trials to create a shuffletable which is different from previous one.Just a guessed limit,considering huge ListSize
#define NEW_INPUT_TABLE_FOR_SHUFFLING 2 // The Retrial count at which new Table for shuffling can be give.Just a Guessed value.
#define MIN_TABLE_SIZE_TO_CHECK_SEQ 3
tResult ListControl::Init(tInitReason /*reason*/)
{
    ENTRY;

    mFolderHierarchy.clear();
    mStopFlag = 0;
    return InitDone(0);
}

tResult ListControl::Stop(void)
{
    ENTRY;

    mStopFlag = 1;
    return StopDone(0);
}

tResult ListControl::Done()
{
    ENTRY

    /* clean up list handles */
    ReleaseAllLists();

    return DoneDone(0);
}

int ListControl::Statistics(OUT tStatistics stat)
{
    stat[0]=0;

    /* look for an empty entry in the vector */
    tUInt usedElements = 0;

    mLock.lock();
    for(tUInt i = 0; i<mLists.size(); i++) {
        if (mLists[i]->listID != LIST_ID_NONE) usedElements++;
    }
    mLock.unlock();

    /* create some statistic information */
    snprintf(stat, sizeof(tStatistics), "Lists %d/%d", usedElements, mLists.size());

    return 0;
}

inline unsigned sortlib_next_ucs_char(const char *s, unsigned *index, int len)
{
    register unsigned tempCh = 0;
    register int size = 0;
    register int idx = *index;

    tempCh = s[idx++];

    if (tempCh & 0x80) {
        // UTF8: read out char len
        if ((tempCh & 0xe0) == 0xc0) {
            tempCh &= 0x1f;
            size = 1;
        } else if ((tempCh & 0xf0) == 0xe0) {
            tempCh &= 0xf;
            size = 2;
        } else if ((tempCh & 0xf8) == 0xf0){
            tempCh &= 0x07;
            size = 3;
        }

        while(size-- && idx<len) {
            tempCh <<= 6;
            tempCh |= (unsigned char)(s[idx++]) & 0x3f;
        }
    }

    *index = idx;
    return tempCh;
}

tResult ListControl::CreateList(tListID &listID)
{
    ENTRY_INTERNAL
    tList *newList = new tList;
    static tListID _uniqueListID = 1; // unique list id counter
    tUInt i;

    mLock.lock();

    /* clear new struct */
    memset(newList, 0, sizeof(tList));
    newList->dbBrowseListID = LIST_ID_NONE;
    newList->listType = LTY_END_OF_EXTERNAL_LIST_TYPES;
    newList->objectType = CTY_NONE;
    newList->objectID = OBJECT_ID_NONE;
    newList->playContinuation = PC_NO_REPEAT;
    newList->deviceID = DEVICE_ID_NOT_SET;
    newList->nowPlayingObjectID = OBJECT_ID_NONE;
    newList->nowPlayingListPosition = POSITION_NOT_SET;
    newList->parent = LIST_ID_NONE;
    newList->next = LIST_ID_NONE;
    newList->fileTypeSelection = FTS_AUDIO_VIDEO_PLAYLIST;
    newList->refCounter = 0;
    newList->createCounter = 1;

    /* initialize ShuffleSkippingStack */
    newList->sizeOfShuffleSkippingStack = LocalSPM::GetDataProvider().ShuffleSkippingStackLength();
    newList->shuffleOnNextForward = 0;

    /* return the new internal handle */
    newList->listID = _uniqueListID;
    listID = _uniqueListID;
    _uniqueListID++;
    //ETG_TRACE_USR1(("New listID: %d", listID));

    /* look for an empty entry in the vector */
    for(i = 0; i<mLists.size(); i++) {
        if ((mLists[i]->listID == LIST_ID_NONE) && (mLists[i]->refCounter < 1)) break;
    }

    // found one
    if (i < mLists.size()) {

        /* release the shuffe tables */
        if (mLists[i]->shuffleTable) free(mLists[i]->shuffleTable);
        if (mLists[i]->shuffleSkippingStack) free(mLists[i]->shuffleSkippingStack);

        /* delete the old memory */
        delete mLists[i];

        /* replace entry with new one */
        mLists[i] = newList;

    } else { // found no free entry, add a new one:

        /* add the new list to the vector */
        mLists.push_back(newList);
    }

    mLock.unlock();

    return MP_NO_ERROR;
}

#define TOKENPASTE(x, y) x ## y
#define TOKENPASTE2(x, y) TOKENPASTE(x, y)
#define GET_LIST_POINTER(listPtrName, listId) \
        autoDeRefListPtr TOKENPASTE2(adrlp,__LINE__)(listPtrName = ListControl::GetListPointer(listId));

ListControl::tList *ListControl::GetListPointer(const tListID listID)
{
    ENTRY_INTERNAL
    tList *listPtr;

    if (listID == LIST_ID_NONE)  return NULL;

    mLock.lock();

    /* search for the element */
    for(tUInt i=0; i<mLists.size(); i++) {
        if (mLists[i]->listID == listID) {
            listPtr = mLists[i];
            listPtr->refCounter++;
            mLock.unlock();
            return listPtr;
        }
    }

    /* element not found */
    mLock.unlock();

    ETG_TRACE_ERR(("No Entry for listID %d found", listID));

    return NULL;
}

tResult ListControl::CreatePlayList(tListID &listID,
        const tListType _listType,
        const tStreaming streaming,
        const tFilterTag1 tag1,
        const tFilterTag2 tag2,
        const tFilterTag3 tag3,
        const tFilterTag4 tag4,
        const tPlayContinuation playContinuation,
        const tDeviceID deviceID,
        const tBoolean checkVTIPOD /*=true*/,
        const char *pSearchText   /*=NULL*/,
        const tUserID userID   /*=0*/)
{
    ENTRY
    tResult res;
    listID = LIST_ID_NONE;
    tDeviceID realDeviceID = deviceID;
    tListType listType = _listType;
    LISTCONTROL_HELPER(listType);

    VARTRACE(listType);
    VARTRACE(tag1);
    VARTRACE(tag2);
    VARTRACE(tag3);
    VARTRACE(tag4);
    VARTRACE(deviceID);
    VARTRACE(userID);

    /* in case of config value permanent streaming (e.g. for DTY_BLUETOOTH) or device can batch play (e.g. iPod iAP2) reset list to streaming */
    tStreaming localStreaming = streaming;
    if((LocalSPM::GetDataProvider().IsPermanentStreamingActive(deviceID))
            ||
            (LocalSPM::GetDeviceDispatcher().IsBatchPlayable(deviceID)))
    {
        ETG_TRACE_USR2(("Reset list to streaming=true because of permanent streaming or batch play"));
        localStreaming = true;
    }

#if PERF_MEAS
    TimeTrace tMeas("CreatePlayList");
#endif

    /* if it is a playlist-song list, use a special handling to use filelist for non-apple devices */
    if (listType == LTY_PLAYLIST_SONG)
    {
        //in case of MYMEDIA update the deviceID to actual one
        if(MY_MEDIA == deviceID)
        {
            LocalSPM::GetDBManager().GetObjectDeviceID(OUT realDeviceID, IN tag1.tag, CTY_PLAYLIST);
        }

        /* check if the device is of type Apple devices*/
        tDeviceInfo deviceInfo;
        res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN realDeviceID);
        if (res) return res;

        if(!IsAppleDevice(deviceInfo.deviceType))
        {
            /* get given object */
            tMediaObject mediaObject;
            res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN tag1.tag, CTY_PLAYLIST, IN deviceID);
            if (res) return res;

            /* create a file list as contents of the playlist */
            tListSize listSize;
            res = CreateMediaPlayerPlaylistList(OUT listID, OUT listSize, IN mediaObject.fileName, IN realDeviceID);
            VARTRACE(listSize);
#if PERF_MEAS
            tMeas.elapsed();
#endif
            if (res) return res;

            /* store playlist attributes in local list */
            tList *listPtr;
            GET_LIST_POINTER(OUT listPtr, IN listID);

            if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;
            //listPtr->listType = LTY_PLAYLIST_SONG;
            listPtr->deviceID = deviceID;           //set deviceID instead of realDeviceID
            listPtr->tag1.playlist = tag1.tag;

            /* store playlist attributes in DB list too */
            res = LocalSPM::GetDBManager().SetPlaylistAttributes(IN listPtr->dbBrowseListID, IN deviceID, IN tag1);
            if (res) return res;

            /* Already called in CreateMediaPlayerPlaylistList but in case of MYMEDIA reset parent to use correct deviceID (GMMY16-27630)*/
            if (MY_MEDIA == deviceID)
            {
#if PERF_MEAS
                tMeas.restart();
#endif
                SetParent(INOUT listPtr);
#if PERF_MEAS
                tMeas.elapsed();
#endif
            }

            return MP_NO_ERROR;
        }
        //else: use default list creation (CreateList) for apple devices
    }

    //ETG_TRACE_USR2(("###Check lists: listType=%d, streaming=%d, tag1=%d, tag2=%d, tag3=%d, tag4=%d, deviceID=%d",
    //        listType, localStreaming, tag1.tag, tag2.tag, tag3.tag, tag4.tag, deviceID));

    //To ease comparison,copy the searchText received to a tSearchString
    tSearchString searchText = {0};
    strncpy_r(OUT searchText,IN pSearchText,IN sizeof(searchText));

    /* search for a indexed list which uses same attributes */
    mLock.lock();
    for (tUInt i=0; i<mLists.size(); i++) {
        if (mLists[i]->listID != LIST_ID_NONE) {

            //ETG_TRACE_USR2(("###  listID=%d, listType=%d, streaming=%d, tag1=%d, tag2=%d, tag3=%d, tag4=%d, deviceID=%d",
            //        mLists[i]->listID, mLists[i]->listType, mLists[i]->streaming, mLists[i]->tag1.tag, mLists[i]->tag2.tag, mLists[i]->tag3.tag, mLists[i]->tag4.tag, mLists[i]->deviceID));

            if ((listType == mLists[i]->listType)
                    &&
                    (localStreaming == mLists[i]->streaming)
                    &&
                    (tag1.tag == mLists[i]->tag1.tag)
                    &&
                    (tag2.tag == mLists[i]->tag2.tag)
                    &&
                    (tag3.tag == mLists[i]->tag3.tag)
                    &&
                    (tag4.tag == mLists[i]->tag4.tag)
                    &&
                    (deviceID == mLists[i]->deviceID)
                    &&
                    ((0 == LocalSPM::GetDataProvider().FullTextSearch()) || (0 == strncmp(searchText, mLists[i]->searchText,IN sizeof(searchText))))
                    &&
                    (userID == mLists[i]->userID)) {

                /* in case of VTiPod list (except LTY_PLAYLIST_SONG) do not use the old lists */
                if((!mLists[i]->isVTIPODList)
                        ||
                        (mLists[i]->listType == LTY_PLAYLIST_SONG)) {

                    // found a related indexed list
                    listID = mLists[i]->listID;
                    mLists[i]->createCounter++;
#if PERF_MEAS
                    tMeas.elapsed();
#endif
                    break;
                }
            }
        }
    }
    mLock.unlock();

    if (LIST_ID_NONE == listID) {

        tListID dbBrowseListID;

        if ((LocalSPM::GetDataProvider().PersonalizationSupported()) && IsUserFavoriteList(listType))
        {
                /* create a browsable Favorites list out of the filter tag which is an object id for song */
            ETG_TRACE_USR2(("ListControl::CreatePlayList Favorites list"));
                    res = LocalSPM::GetDBManager().CreateList(OUT dbBrowseListID,
                        IN realDeviceID,
                        IN listType,
                        IN playContinuation,
                        IN tag1,
                        IN tag2,
                        IN tag3,
                        IN tag4,
                        IN localStreaming,
                        IN checkVTIPOD,
                        IN /*lastPlayedList = */false,
                        IN /*lastPlayedPath =*/ "",
                        IN pSearchText,
                        IN userID);
#if PERF_MEAS
                    tMeas.elapsed();
#endif
                    if (res) return res;

        }
        else
        {
            /* create a browsable list out of the filter tag which is an object id for a album, artist, genre, ... */
                    res = LocalSPM::GetDBManager().CreateList(OUT dbBrowseListID,
                IN realDeviceID,
                IN listType,
                IN playContinuation,
                IN tag1,
                IN tag2,
                IN tag3,
                IN tag4,
                IN localStreaming,
                IN checkVTIPOD,
                IN /*lastPlayedList = */false,
                IN /*lastPlayedPath =*/ "",
                IN pSearchText);
#if PERF_MEAS
            tMeas.elapsed();
#endif
            if (res) return res;
        }
        /* create a new list in the internal list storage */
        res = CreateList(OUT listID);
        if (res) return res;

        /* Get the list pointer */
        tList *listPtr;
        GET_LIST_POINTER(OUT listPtr, IN listID)
        if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

        /* store some values in this new list */
        listPtr->dbBrowseListID = dbBrowseListID;
        listPtr->listType = listType;
        listPtr->tag1.tag = tag1.tag;
        listPtr->tag2.tag = tag2.tag;
        listPtr->tag3.tag = tag3.tag;
        listPtr->tag4.tag = tag4.tag;
        listPtr->playContinuation = playContinuation;
        listPtr->deviceID = deviceID;
        listPtr->streaming = localStreaming;
        listPtr->userID = userID;

        listPtr->searchText[0]='\0'; //empty
        if(pSearchText) //Roadmap 16014 'full text string'
        {
            snprintf(listPtr->searchText,sizeof(tSearchString),"%s",pSearchText);
        }

        /* get additional information */
        tListInfo listInfo;
        tBoolean withListSize = false;
        res = LocalSPM::GetDBManager().GetListInfo(OUT listInfo, IN dbBrowseListID, IN withListSize);
        if (res) return res;
        listPtr->isVTIPODList = listInfo.isVTIPODList;

        if (listType == LTY_PLAYLIST_SONG)
        {
            /* store playlist attributes in DB list too */
            res = LocalSPM::GetDBManager().SetPlaylistAttributes(IN listPtr->dbBrowseListID, IN deviceID, IN tag1);
            if (res) return res;
        }

        /* check if device is in shuffle mode */
        tPlaybackMode playbackMode;
        res = LocalSPM::GetDBManager().GetPlaybackMode(OUT playbackMode, IN deviceID);
        if (res) return res;

        /* device is in random mode, shuffle the playlist */
        if (playbackMode == PBM_RANDOM) {

            TimeTrace tMeas2("CreatePlayList-CreateShuffleTable");

            /* create the shuffle table for this list */
            res = CreateShuffleTable(INOUT listPtr);
            if (res) return res;
            tMeas2.elapsed();
        }

        /* search a parent list or create one */
#if PERF_MEAS
        tMeas.restart();
#endif
        SetParent(INOUT listPtr);
#if PERF_MEAS
        tMeas.elapsed();
#endif
    }

    return MP_NO_ERROR;
}

tResult ListControl::CreatePlayList(tListID &listID, const tObjectID _objectID,
        const tCategoryType _objectType, const tPlayContinuation playContinuation, const tDeviceID deviceID)
{
    ENTRY
    tResult res;
    tObjectID objectID = _objectID;
    tCategoryType objectType = _objectType;
    tStreaming streaming = false;
    tListType listType;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tMediaObject mediaObject;

    /* init values */
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    /* if now cat id given, try to find out */
    if (objectType == CTY_NONE) {

        /* get the category type */
        res = LocalSPM::GetDBManager().GetObjectType(OUT objectType, INOUT objectID);
        if (res) return res;
        if (objectType == CTY_NONE) return MP_ERR_LC_GENERAL_ERROR;
    }

    /* calculate list type from object type and set the filter tag requierd to create such list */
    switch(objectType)
    {
        case CTY_SONG:
            listType = LTY_SONG;
            break;

        case CTY_PODCAST:
            /*find the tag for parent podcast name */
            res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN objectID, IN objectType, IN deviceID);
            if (res) return res;

            listType = LTY_PODCAST_EPISODE;
            tag1.podcast = mediaObject.MetadataTag1;
            break;

        case CTY_VIDEO:
            /*find the tag for parent video name as we don't have a list type for all episodes like LTY_EPISODE equivalent to LTY_SONG*/
            res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN objectID, IN objectType, IN deviceID);
            if (res) return res;

            listType = LTY_VIDEO_EPISODE;
            tag1.video = mediaObject.MetadataTag1;
            break;

        case CTY_AUDIOBOOK: //? how different is this from CTY_CHAPTER
        case CTY_CHAPTER:
            /*find the tag for parent title name as we don't have a list type like all chapters LTY_CHAPTER equivalent to LTY_SONG*/
            res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN objectID, IN objectType, IN deviceID);
            if (res) return res;

            listType = LTY_BOOKTITLE_CHAPTER;
            tag2.audiobook = mediaObject.MetadataTag2;
            break;

#if 0 //@todo ?
        case CTY_EPISODE:
            break;
#endif

        case CTY_GENRE:
            listType = LTY_GENRE_SONG;
            tag1.genre = objectID;
            break;
        case CTY_ARTIST:
            listType = LTY_ARTIST_SONG;
            tag2.artist = objectID;
            break;
        case CTY_ALBUM:
            listType = LTY_ALBUM_SONG;
            tag4.album = objectID;
            break;
        case CTY_COMPOSER:
            listType = LTY_COMPOSER_SONG;
            tag3.composer = objectID;
            break;
        case CTY_NAME:
            /*resolve whether CTY_NAME represents a video episode or a podcast episode*/
            res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN objectID, IN objectType, IN deviceID);
            if (res) return res;

            if(mediaObject.catType == CTY_VIDEO)
            {
                listType = LTY_VIDEO_EPISODE;
                tag1.video = objectID;
            }
            else if(mediaObject.catType == CTY_PODCAST)
            {
                listType = LTY_PODCAST_EPISODE;
                tag1.podcast = objectID;
            }
            else
            {
                ETG_TRACE_ERR(("ListControl::CreatePlayList object CTY_NAME does not represents video or podcast =%d", objectID));
                return MP_ERR_LC_NO_CTY_MATCH_TO_LTY;
            }
            break;
        case CTY_TITLE:
            listType = LTY_BOOKTITLE_CHAPTER;
            tag2.audiobook = objectID;
            break;
        case CTY_PLAYLIST:
            listType = LTY_PLAYLIST_SONG;
            tag1.playlist = objectID;
            break;
        default:
            listType = LTY_SONG;
            break;
    }

    /* create a browsable list out of the filter tags which is an object id for a album, artist, genre, ... */
    res = CreatePlayList(OUT listID,
            IN listType,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN playContinuation,
            IN deviceID);
    if (res) return res;

    /* set the list position to requested object*/
    if ((objectType == CTY_SONG) || (objectType == CTY_PODCAST) || (objectType == CTY_VIDEO) ||(objectType == CTY_AUDIOBOOK))
    {
        /* Get the list pointer */
        tList *listPtr;
        GET_LIST_POINTER(OUT listPtr, IN listID);
        if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

        /* Set the list position to new object */
        tPosition position;
        res = LocalSPM::GetDBManager().SetPosition(OUT position, IN objectID, IN listPtr->dbBrowseListID);
        if (res) return res;

        /* Set the now playing info */
        listPtr->nowPlayingObjectID = objectID;
        listPtr->nowPlayingListPosition = position;
    }

    return MP_NO_ERROR;
}

tResult ListControl::CreatePlayList(tListID &listID, const tFilterTag tag,
        const tPlayContinuation playContinuation, const tDeviceID deviceID)
{
    ENTRY
    tResult res;
    tObjectID objectID = (tObjectID)tag;
    tCategoryType objectType;

    /* get type of object */
    res = LocalSPM::GetDBManager().GetObjectType(OUT objectType, INOUT objectID);
    if (res) return res;

    res = CreatePlayList(OUT listID, IN objectID, IN objectType, IN playContinuation, IN deviceID);
    if (res) return res;

    return MP_NO_ERROR;
}

tResult ListControl::GetListInfo(tListInfo &listInfo, const tListID listID, const tBoolean withListSize)
{
    ENTRY
    tResult res;

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* fill out list information */
    InitListInfo(OUT listInfo);

    /* get list information from db manager */
    res = LocalSPM::GetDBManager().GetListInfo(OUT listInfo, IN listPtr->dbBrowseListID, IN withListSize);
    if (res) return res;

    /* replace list id with the one of list control */
    listInfo.listID = listID;

    /* set the parent and next list id, calculated at list creation */
    listInfo.next = listPtr->next;
    listInfo.parent = listPtr->parent;

    /* set the streaming flag */
    listInfo.streaming = listPtr->streaming;

    return MP_NO_ERROR;
}

tResult ListControl::GetPath(tPath &path, const tListID listID)
{
    ENTRY

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /*path information is valid only for file lists*/
    if (false == IsFileList(listPtr->listType))
    {
        return MP_ERR_DB_UNSUPPORTED_LIST_TYPE;
    }

    strncpy_r(OUT path, IN listPtr->path, IN sizeof(path));
    return MP_NO_ERROR;
}

tResult ListControl::StoreLastPlayedList(const tListID listID, const tPlaytime playtime)
{
    ENTRY
    tResult res;

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;
    tDeviceInfo deviceInfo;

    /* In case of MyMedia the list can be changed in the meantime */
    if (MY_MEDIA == listPtr->deviceID)
    {
        /* Do not store apple playlist as last mode for MyMedia */
        if (LTY_PLAYLIST_SONG == listPtr->listType)
        {
            tDeviceID realDeviceID = DEVICE_ID_NOT_SET;
            res = LocalSPM::GetDBManager().GetObjectDeviceID(OUT realDeviceID, IN listPtr->tag1.playlist, CTY_PLAYLIST);
            if (res) return res;

            res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN realDeviceID);
            if (res) return res;

            if (IsAppleDevice(deviceInfo.deviceType)) {
                return MP_NO_ERROR;
            }
        }

        /* Set the list position to current object */
        if (OBJECT_ID_NONE != listPtr->nowPlayingObjectID)
        {
            tPosition position;
            res = LocalSPM::GetDBManager().SetPosition(OUT position, IN listPtr->nowPlayingObjectID, IN listPtr->dbBrowseListID);
            if (MP_NO_ERROR == res) {
                listPtr->nowPlayingListPosition = position;
            }
        }
    }

    /* store the last mode of the list at the DB if any object is active */
    if ((OBJECT_ID_NONE != listPtr->nowPlayingObjectID)
            ||
            (POSITION_NOT_SET != listPtr->nowPlayingListPosition))
    {
        res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN IN listPtr->deviceID);
        if (res) return res;

        if((DTY_MTP == deviceInfo.deviceType) && ((IsPlayableList(listPtr->listType)) && (!IsFileList(listPtr->listType))))
        {
            tPath lastPlayedPath;
            LocalSPM::GetDeviceDispatcher().GetLastPlayedPath(IN listPtr->deviceID,lastPlayedPath);

            res = LocalSPM::GetDBManager().UpdateDBListPath(IN listPtr->deviceID ,IN listPtr->dbBrowseListID, IN lastPlayedPath);
            if (res) return res;
        }

        res = LocalSPM::GetDBManager().StoreLastPlayed(IN listPtr->dbBrowseListID, IN listPtr->nowPlayingObjectID, IN listPtr->nowPlayingListPosition, IN playtime);
        if (res) return res;

    }

    return MP_NO_ERROR;
}

tResult ListControl::GetLastPlayedList(tListID &listID, tIndex &startPosition, tPlaytime &playtime, const tDeviceID deviceID)
{
    ENTRY
    tResult res;
    tListID dbBrowseListID;
    tObjectID lastObjectID;
    listID = LIST_ID_NONE;
    startPosition = INDEX_NONE;
    playtime = PLAYTIME_NONE;

    /* get the play time for the list at the data base */
    res = LocalSPM::GetDBManager().GetLastPlayed(OUT dbBrowseListID, OUT lastObjectID, OUT playtime, IN deviceID);
    if (res) return res;

    /* if a valid list was last played */
    if (dbBrowseListID != LIST_ID_NONE) {

        /* create a new list in the internal list storage */
        res = CreateList(OUT listID);
        if (res) return res;

        /* Get the list pointer */
        tList *listPtr;
        GET_LIST_POINTER(OUT listPtr, IN listID);
        if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

        /* get additional information */
        tListInfo listInfo;
        tBoolean withListSize = false;
        res = LocalSPM::GetDBManager().GetListInfo(OUT listInfo, IN dbBrowseListID, IN withListSize);
        if (res) return res;

        /* store some values in this new list */
        listPtr->dbBrowseListID = dbBrowseListID;
        listPtr->listType = listInfo.listType;
        listPtr->objectType = CTY_NONE;
        listPtr->objectID = OBJECT_ID_NONE;
        listPtr->playContinuation = listInfo.playContinuation;
        listPtr->tag1.tag = listInfo.filterTag1.tag;
        listPtr->tag2.tag = listInfo.filterTag2.tag;
        listPtr->tag3.tag = listInfo.filterTag3.tag;
        listPtr->tag4.tag = listInfo.filterTag4.tag;
        listPtr->deviceID = listInfo.deviceID;
        listPtr->nowPlayingObjectID = lastObjectID;
        strncpy_r(OUT listPtr->path, IN listInfo.path, IN sizeof(listPtr->path));
        listPtr->fileTypeSelection = listInfo.fileTypeSelection;
        listPtr->isVTIPODList = listInfo.isVTIPODList;

        /* in case of config value permanent streaming (e.g. for DTY_BLUETOOTH) or device can batch play (e.g. iPod iAP2) reset list to streaming */
        if((LocalSPM::GetDataProvider().IsPermanentStreamingActive(deviceID))
                ||
                (LocalSPM::GetDeviceDispatcher().IsBatchPlayable(deviceID)))
        {
            ETG_TRACE_USR2(("Reset list to streaming=true because of permanent streaming or batch play"));
            listPtr->streaming = true;
        }
        else
        {
            listPtr->streaming = listInfo.streaming;
        }

        /* check if device is in shuffle mode */
        tPlaybackMode playbackMode;
        res = LocalSPM::GetDBManager().GetPlaybackMode(OUT playbackMode, IN deviceID,listPtr->fileTypeSelection);
        if (res) return res;

        /* device is in random mode, shuffle the playlist */
        if (playbackMode == PBM_RANDOM) {

            TimeTrace tMeas2("CreatePlayList-CreateShuffleTable");

            /* create the shuffle table for this list */
            res = CreateShuffleTable(INOUT listPtr);
            if (res) return res;
            tMeas2.elapsed();
        }

        if (OBJECT_ID_NONE != listPtr->nowPlayingObjectID)
        {
            res = LocalSPM::GetDBManager().GetPositionInList(OUT listPtr->nowPlayingListPosition, IN listPtr->dbBrowseListID, IN listPtr->nowPlayingObjectID);
            if (res) return res;

            startPosition = (tIndex)listPtr->nowPlayingListPosition;
        }

        /* search a parent list or create one */
        SetParent(INOUT listPtr);

        /* search for a old list which uses same attributes and release it*/
        mLock.lock();
        tListID oldListID = LIST_ID_NONE;
        int createCounter = 1;
        for (tUInt i=0; i<mLists.size(); i++) {
            if ((mLists[i]->listID != LIST_ID_NONE)
                    &&
                    (mLists[i]->listID != listID)) {

                if (IsFileList(listPtr->listType)) {
                    if ((listPtr->listType == mLists[i]->listType)
                            &&
                            (!strcmp(listPtr->path, mLists[i]->path))
                            &&
                            (listPtr->deviceID == mLists[i]->deviceID)
                            &&
                            (listPtr->fileTypeSelection == mLists[i]->fileTypeSelection)
                            &&
                            (listPtr->streaming == mLists[i]->streaming)) {

                        // found a related file list
                        oldListID = mLists[i]->listID;
                        createCounter = mLists[i]->createCounter;
                        break;
                    }
                }
                else
                {
                    if ((listPtr->listType == mLists[i]->listType)
                            &&
                            (listPtr->streaming == mLists[i]->streaming)
                            &&
                            (listPtr->tag1.tag == mLists[i]->tag1.tag)
                            &&
                            (listPtr->tag2.tag == mLists[i]->tag2.tag)
                            &&
                            (listPtr->tag3.tag == mLists[i]->tag3.tag)
                            &&
                            (listPtr->tag4.tag == mLists[i]->tag4.tag)
                            &&
                            (listPtr->deviceID == mLists[i]->deviceID)) {

                        // found a related indexed list
                        oldListID = mLists[i]->listID;
                        createCounter = mLists[i]->createCounter;
                        break;
                    }
                }
            }
        }
        mLock.unlock();

        if(LIST_ID_NONE != oldListID)
        {
            /* release the old HMI list */
            res = ReleaseList(oldListID, true/*force*/);
            if (res) return res;

            /* set the old list ID in the new list context */
            listPtr->listID = oldListID;
            listPtr->createCounter = createCounter + 1;
            listID = oldListID;
        }
    }

    return MP_NO_ERROR;
}

tResult ListControl::SetMediaObject(tMediaObject &mediaObject, const tListID listID, const tIndex startIndex)
{
    ENTRY
    tResult res;

    if(INDEX_NONE == startIndex) return MP_ERR_LC_UNDEFINED_INDEX;
    tRowNumber newRow = (tRowNumber)startIndex;

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* Init return object */
    InitMediaObject(OUT mediaObject);

    /* If index is INDEX_LAST_ACTIVE_OBJECT get position in list (=index) */
    if (INDEX_LAST_ACTIVE_OBJECT == startIndex)
    {
        if(LTY_CURRENT_SELECTION == listPtr->listType)
        {
            /* Get the first media object of the list */
            res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN listPtr->dbBrowseListID, IN 0);
            if (res) return res;

            newRow = (tRowNumber)mediaObject.active;
        }
        else
        {
            /* Get the object position of old element */
            //res = LocalSPM::GetDBManager().GetPositionInList(OUT listPtr->nowPlayingListPosition, IN listPtr->dbBrowseListID, IN listPtr->nowPlayingObjectID);
            //if (res) return res;

            VARTRACE(listPtr->nowPlayingListPosition);
            if(listPtr->nowPlayingListPosition == POSITION_NOT_SET)
            {
                newRow = 0;
            }
            else
            {
                newRow = (tRowNumber)listPtr->nowPlayingListPosition;
            }
        }
    }

    /* Set the current media object in a created list */
    res = LocalSPM::GetDBManager().SetCurrentRow(IN listPtr->dbBrowseListID, IN newRow);
    if (res) return res;

    /* Get the current media object */
    res = LocalSPM::GetDBManager().GetCurrentMediaObject(OUT mediaObject, IN listPtr->dbBrowseListID);
    if (res) return res;

    return MP_NO_ERROR;
}

tResult ListControl::GetCurrentMediaObject(tMediaObject &mediaObject, const tListID listID)
{
    ENTRY
    tResult res;

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* init return object */
    InitMediaObject(OUT mediaObject);

    /* get the current media object */
    res = LocalSPM::GetDBManager().GetCurrentMediaObject(OUT mediaObject, IN listPtr->dbBrowseListID);
    if (res) return res;

    /* skip folders and playlists */
    if ((mediaObject.fileType == FT_FOLDER)
            ||
            (mediaObject.fileType == FT_PLAYLIST))
    {
        int stepCount = 1;
        tListID localListID = listID;
        res = NextInternal(INOUT localListID, IN stepCount);
        if (res) return res;

        /* get the current media object */
        res = LocalSPM::GetDBManager().GetCurrentMediaObject(OUT mediaObject, IN listPtr->dbBrowseListID);
        if (res) return res;
    }

    /* in case the DB could not deliver a correct device id for category lists */
    if (mediaObject.deviceID == DEVICE_ID_NOT_SET) {
        mediaObject.deviceID = listPtr->deviceID;
    }

    return MP_NO_ERROR;
}

tResult ListControl::SetCurrentMediaObject(const tListID listID, const tObjectID objectID)
{
    ENTRY
    tResult res;

    if(OBJECT_ID_NONE == objectID) return MP_ERR_LC_UNDEFINED_OBJECTID;

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;
    if(listPtr->listType == LTY_BLUETOOTH_FILELIST)
    {
        //Set the nowplaying objectID for a Bluetooth device , before get position from the db as the objectID denotes the position of the song in the list.
        listPtr->nowPlayingObjectID = objectID;
        VARTRACE(listPtr->nowPlayingObjectID);
    }

    /* Set the list position */
    tPosition position;
    res = LocalSPM::GetDBManager().SetPosition(OUT position, IN objectID, IN listPtr->dbBrowseListID);
    if(listPtr->listType != LTY_BLUETOOTH_FILELIST)
    {
        if (res) return res;
    }

    /* Set the now playing info */
    listPtr->nowPlayingObjectID = objectID;
    VARTRACE(listPtr->nowPlayingObjectID);
    listPtr->nowPlayingListPosition = position;

    return MP_NO_ERROR;
}

tResult ListControl::ResetListPosition(const tListID listID)
{
    ENTRY
    tResult res;

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* Reset the list position to current object (GMMY16-19561) */
    if (!LocalSPM::GetDBManager().IsVTList(IN listPtr->dbBrowseListID))
    {
        if (OBJECT_ID_NONE != listPtr->nowPlayingObjectID)
        {
            tPosition position;
            res = LocalSPM::GetDBManager().SetPosition(OUT position, IN listPtr->nowPlayingObjectID, IN listPtr->dbBrowseListID);
            if (MP_NO_ERROR == res) {
                listPtr->nowPlayingListPosition = position;
            }
        }
    }

    return MP_NO_ERROR;
}

tResult ListControl::NextProcessing(tRowNumber &newRow, tListSize &listSize,tRowNumber &lastPlayedRow, const tListID listID, const int stepCount)
{
    ENTRY
    tResult res;

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* get the current row */
    res = LocalSPM::GetDBManager().GetCurrentRow(OUT newRow, IN listPtr->dbBrowseListID);
    if (res) return res;

    if(lastPlayedRow == ROW_NUMBER_NONE)/*avoid overwriting it during successive calls from NextInternal*/
        lastPlayedRow = newRow;

    res = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN listPtr->dbBrowseListID);
    VARTRACE(listSize);
    if (res) return res;

    tRepeatMode repeatMode;
    res = GetRepeatMode(OUT repeatMode);
    if( MP_NO_ERROR != res )
    {
        ETG_TRACE_ERR(("Error while getting repeat mode (ErrorCode:%s)", errorString(res)));
        return res;
    }

    /* calculate the skip */
    if (listPtr->isInShuffleMode) {

        /* size has changed? Use case: last mode of shuffled MyMedia list */
        if (listSize != listPtr->sizeOfShuffleTable) {

            /* recreate the shuffle table for this list */
            res = CreateShuffleTable(INOUT listPtr);
            if (res) return res;
        }

        /* find current index in shuffle table */
        tPosition iList;
        for(iList=0; iList<listPtr->sizeOfShuffleTable; iList++) {
            if (newRow == listPtr->shuffleTable[iList]) break;
        }

        /* do the next and previous without stack */
        if (listPtr->sizeOfShuffleSkippingStack == 0) {

            /* do the step in the shuffle list */
            iList += stepCount;

            /* end or start of table? */
            if ((int)iList >= (int)listPtr->sizeOfShuffleTable) {
                res = MP_ERR_DB_END_OF_LIST;
            }
            else if ((int)iList < 0)
            {
                /*For previous case, if repeat mode is none and start of list is reached,start playback of same track(first track) again*/
                if(RPT_NONE == repeatMode && stepCount < 0)
                    newRow = lastPlayedRow;
                else
                    res = MP_ERR_DB_END_OF_LIST;
            }
            else
            {
                newRow = listPtr->shuffleTable[iList];  // new, shuffled row number
            }

            /* use the stack for the next and previous */
        } else {

            /* find the position in stack if possible */
            tPosition iStack;
            for(iStack=0; iStack<listPtr->sizeOfShuffleSkippingStack; iStack++) {
                ETG_TRACE_USR2(("## listPtr->shuffleSkippingStack[%d]:%d", iStack, listPtr->shuffleSkippingStack[iStack]));
                if (newRow == listPtr->shuffleSkippingStack[iStack]) break;
            }
            tPosition tmpIStack;
            for(tmpIStack = iStack; tmpIStack<listPtr->sizeOfShuffleSkippingStack; tmpIStack++) {
                ETG_TRACE_USR2(("#### listPtr->shuffleSkippingStack[%d]:%d", tmpIStack, listPtr->shuffleSkippingStack[tmpIStack]));
            }
            /* if not found... */
            if (iStack == listPtr->sizeOfShuffleSkippingStack) {
                iStack = POSITION_NOT_SET;
            }
            ETG_TRACE_USR2(("iStack: %d", iStack));

            /* next with stack */
            if (stepCount > 0) {

                /* Reshuffle if necessary */
                if (listPtr->shuffleOnNextForward) {
                    ReshuffleShuffleTable(INOUT listPtr);
                    /* flag has to be reset */
                    mLock.lock();
                    for(tUInt i=0; i<mLists.size(); i++) {
                        if (mLists[i]->listID == listPtr->listID) {
                            mLists[i]->shuffleOnNextForward = false;
                            break;
                        }
                    }
                    mLock.unlock();
                    iStack = POSITION_NOT_SET;
                    for(iList=0; iList<listPtr->sizeOfShuffleTable; iList++) {
                        if (newRow == listPtr->shuffleTable[iList]) break;
                    }
                }

                /* If current row not in stack: clean stack and push current row to stack */
                if (iStack == POSITION_NOT_SET) {
                    ReInitShuffleSkippingStack(INOUT listPtr);
                    iStack = 0;
                    listPtr->shuffleSkippingStack[iStack] = newRow;
                }

                /* go stepCount steps ahead and push to stack if necessary */
                for (int i=1;i<=stepCount;i++) {

                    /* Just one step back in the stack */
                    if (((int)iStack - i) >= 0) {
                        newRow = listPtr->shuffleSkippingStack[iStack-i];

                        /* or one step forward in the list */
                    } else {

                        /* if end of list reached: mark it and exit */
                        if (iList + i >= listPtr->sizeOfShuffleTable) {
                            res = MP_ERR_DB_END_OF_LIST;
                            break;

                            /* else calculate new position one step forward in the shuffled list and push it to the stack */
                        } else {
                            /* shift all stack elements, drop the last en passent */
                            for (int j=listPtr->sizeOfShuffleSkippingStack-1;j>0;j--)
                                listPtr->shuffleSkippingStack[j] = listPtr->shuffleSkippingStack[j-1];
                            newRow = listPtr->shuffleTable[iList + i];
                            listPtr->shuffleSkippingStack[0] = newRow;
                        }
                    }
                }
            }
            /* prev with stack */
            else {

                /* If current row not in stack: clean stack */
                if (iStack == POSITION_NOT_SET) {
                    ReInitShuffleSkippingStack(INOUT listPtr);
                }

                for (int j=1;j<=(-stepCount);j++) {

                    /* prev in stack possible */
                    if ((iStack != POSITION_NOT_SET) &&
                            (iStack+j < listPtr->sizeOfShuffleSkippingStack) &&
                            (listPtr->shuffleSkippingStack[iStack+j] < listPtr->sizeOfShuffleTable)) {
                        newRow = listPtr->shuffleSkippingStack[iStack+j];

                        /* prev outside stack: one step back in unshuffled list and flag shuffling on next forward */
                    } else {
                        if (((int)newRow)-1 < 0) {
                            res = MP_ERR_DB_END_OF_LIST;
                            break;
                        } else {
                            newRow--;
                            /* with next forward a reshuffle has to be performed */
                            mLock.lock();
                            for(tUInt i=0; i<mLists.size(); i++) {
                                if (mLists[i]->listID == listPtr->listID) {
                                    mLists[i]->shuffleOnNextForward=true;
                                    break;
                                }
                            }
                            mLock.unlock();
                        }
                    }
                }
            }
        }
    }
    else
    {
        /* straight forward play mode */
        VARTRACE(stepCount);
        newRow += stepCount;
        VARTRACE(newRow);

        if (((int)newRow) < 0)
        {
            /*For previous case, if repeat mode is none and start of list is reached,start playback of same track(first track) again*/
            if((stepCount < 0) && (RPT_NONE == repeatMode))
            {
                newRow = lastPlayedRow;
                VARTRACE(newRow);
            }
            else
            {
                res = MP_ERR_DB_END_OF_LIST;
            }
        }
        if (newRow >= listSize)
        {
            res = MP_ERR_DB_END_OF_LIST;
        }
    }

    VARTRACE(res);
    return res;
}

tResult ListControl::CreateFollowingList(tListID &listID, const int stepCount,const tRepeatMode repeatMode)
{
    ENTRY;
    tResult res;

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    ETG_TRACE_USR2(("enter: listID=%d, dbListID=%d, listType=%d, device=%d",
            listID, listPtr->dbBrowseListID, listPtr->listType, listPtr->deviceID));

    /* if there is no parent, return error */
    /* If RepeateMode is RPT_LIST_WITH_SUBLISTS or RPT_ALL_LISTS,then Donot play the List of the next entry in ParentMost List
        e.g If LTY_GENRE_ARTIST,then it means No more artist is there to play under that genre.
            As repeatmode is RPT_LIST_WITH_SUBLISTS or RPT_ALL_LISTS, next genre should not be played.Hence Same genre should begin playback again*/

    if ((listPtr->parent == LIST_ID_NONE) ||
            (((RPT_LIST_WITH_SUBLISTS == repeatMode) ||
                    (RPT_ALL_LISTS == repeatMode)) &&
                    ((listPtr->listType == LTY_GENRE_SONG) ||
                            (listPtr->listType == LTY_ARTIST_SONG) ||
                            (listPtr->listType == LTY_ALBUM_SONG) ||
                            (listPtr->listType == LTY_COMPOSER_SONG) ||
                            (listPtr->listType == LTY_COMPILATION_SONG) ||
                            (listPtr->listType == LTY_GENRE_ARTIST) ||
                            (listPtr->listType == LTY_GENRE_ALBUM) ||
                            (listPtr->listType == LTY_YEAR_ALBUM) ||
                            (listPtr->listType == LTY_ARTIST_ALBUM) ||
                            (listPtr->listType == LTY_COMPOSER_ALBUM)||
                            (listPtr->listType == LTY_VIDEO_EPISODE) ||
                            (listPtr->listType == LTY_PLAYLIST_SONG) ||
                            (listPtr->listType == LTY_AUTHOR_BOOKTITLE) ||
                            (listPtr->listType == LTY_BOOKTITLE_CHAPTER) ||
                            (listPtr->listType == LTY_PODCAST_EPISODE))))
    {
        return MP_ERR_LC_NO_FURTHER_PARENT;
    }

    tListID parentListID = listPtr->parent;

    /* get the position of the current list in its parent list */
    tPosition positionInParent;
    res = GetPosition(OUT positionInParent, IN listID, IN parentListID);
    if (res) return res;

    /* get the list pointer of the parent list */
    tList *parentListPtr;
    GET_LIST_POINTER(OUT parentListPtr, IN parentListID);
    if (!parentListPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* get the media object in the parent list plus one step */
    tMediaObject mediaObject;
    InitMediaObject(INOUT mediaObject);

    if ((positionInParent != 0 && stepCount < 0) || stepCount > 0) {
        res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN parentListPtr->dbBrowseListID, IN positionInParent + stepCount);
        if (res && res != MP_ERR_DB_END_OF_LIST) {
            return res;
        }
    } else { // at beginning of list: list would end with a negative step
        res = MP_ERR_DB_END_OF_LIST;
    }

    /* if end of list reached, restart with next entry in parent list */
    if (res == MP_ERR_DB_END_OF_LIST) {

        res = CreateFollowingList(INOUT parentListID, IN stepCount,IN repeatMode);
        if (res && res != MP_ERR_LC_NO_FURTHER_PARENT) return res;

        /* Get the list pointer once again because it might change due to following list */
        GET_LIST_POINTER(OUT parentListPtr, IN parentListID);
        if (!parentListPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

        /* if root reached and end of root list, restart at beginning of root list */
        if (res == MP_ERR_LC_NO_FURTHER_PARENT) {

            /* dependent on the walking direction get the new element in the root list */
            if (stepCount > 0) { // forward
                res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN parentListPtr->dbBrowseListID, 0);
                if (res && res != MP_ERR_DB_END_OF_LIST) {
                    return res;
                }
            } else { // backwards

                tListSize listSize;

                res = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN parentListPtr->dbBrowseListID);
                if (res) return res;

                res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN parentListPtr->dbBrowseListID, IN listSize-1);
                if (res && res != MP_ERR_DB_END_OF_LIST) {
                    return res;
                }
            }

            /* found a next element in parent */
        } else {

            /* get the media object in the new parent list */
            res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN parentListPtr->dbBrowseListID, INDEX_LAST_ACTIVE_OBJECT);
            if (res && res != MP_ERR_DB_END_OF_LIST) {
                return res;
            }
        }
    }

    /* create a new list with the new tag from parent list */
    tListID newListID;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = mediaObject.MetadataTag1;
    tag2.tag = mediaObject.MetadataTag2;
    tag3.tag = mediaObject.MetadataTag3;
    tag4.tag = mediaObject.MetadataTag4;
    res = CreatePlayList(
            OUT newListID,
            IN listPtr->listType,
            IN listPtr->streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN listPtr->playContinuation,
            IN listPtr->deviceID);
    if (res) return res;

    /* get new list pointer */
    tList *newListPtr;
    GET_LIST_POINTER(OUT newListPtr, IN newListID);
    if (!newListPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /*Release the list only if the newListID is different from the old listID*/
    ETG_TRACE_USR4(("newListID:%d oldListID:%d", newListID, listID));
    if(listID != newListID)
    {
        //res = ReleaseList(IN listID, true/*force*/);
        //if (res) return res;

        /* set the old list ID in the new list context */
        //newListPtr->listID = listID;
        //newListPtr->createCounter = listPtr->createCounter;

        listID = newListID;
    }

    ETG_TRACE_USR2(("exit: listID=%d, dbListID=%d, listType=%d, device=%d",
            listID, newListPtr->dbBrowseListID, newListPtr->listType, newListPtr->deviceID));
    ETG_TRACE_USR2(("exit: tag1=%32s, tag2=%32s, tag3=%32s, tag4=%32s",
            mediaObject.MetadataField1, mediaObject.MetadataField2, mediaObject.MetadataField3, mediaObject.MetadataField4));

    return MP_NO_ERROR;
}

tResult ListControl::WrapProcessing(tRowNumber &newRow, tListID &listID, const int stepCount)
{
    ENTRY;
    tResult res;

    if (0 == stepCount) return MP_NO_ERROR;

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    tRepeatMode repeatMode;
    if ((!listPtr->streaming)
            &&
            (LocalSPM::GetDataProvider().UseDefaultRepeatModeForWrapList()))
    {
        tMediaContext mediaContext;
        LocalSPM::GetDBManager().GetMediaContext(OUT mediaContext);

        if(MC_VIDEO == mediaContext)
            repeatMode=(tRepeatMode)LocalSPM::GetDataProvider().DBDefaultVideoRepeatMode();
        else
            repeatMode=(tRepeatMode)LocalSPM::GetDataProvider().DBDefaultRepeatMode();
    }
    else
    {
        res = GetRepeatMode(OUT repeatMode);
        if (res) return res;
    }

    ETG_TRACE_USR3(("ListControl::WrapProcessing repeatMode: %u, parentListID: %u, playContinuation: %u", repeatMode, listPtr->parent, listPtr->playContinuation));

    /* nothing to repeat, just continue */
    if (RPT_NONE == repeatMode){

        if (stepCount > 0) { //forward
            res = MP_ERR_LC_NEXT_AT_END_OF_LIST;
        } else { //backwards
            res = MP_ERR_LC_PREV_AT_START_OF_LIST;
        }
        return res;
    }

    /* CRQ: CMG3G-8071
     * During Indexed playback,repeat all lists or lists with sublists: look for next list
     * During FileList playback,repeat all lists: look for next list
     */
    if(LocalSPM::GetDataProvider().CreateFollowingList())
    {
        if(IsFileList(listPtr->listType))
        {
            /* create a following list for RPT_ALL_LISTS
             * For all other RepeatModes,the Current List will be repeated
             */
            if(RPT_ALL_LISTS == repeatMode)
            {
                res = CreateFollowingFileList(INOUT newRow ,INOUT listID, IN stepCount);
                if (res && res != MP_ERR_LC_NO_FURTHER_PARENT) return res;
            }
        }
        else
        {
            /* CRQ:CMG3G-8071 In case of Repeat all,current list is already contains All mediaObjects.Hence donot look for next list*/
            if((/*repeatMode == RPT_ALL || */repeatMode == RPT_LIST_WITH_SUBLISTS || repeatMode == RPT_ALL_LISTS)
                    &&
                    (listPtr->parent != LIST_ID_NONE) /* if list has a parent */
                    &&
                    (listPtr->playContinuation == PC_STEPUP_ONE_LEVEL)) /* if step up is switch on for this list */
            {
                /* create a following list */
                res = CreateFollowingList(INOUT listID, IN stepCount, IN repeatMode);
                if (res && res != MP_ERR_LC_NO_FURTHER_PARENT) return res;
            }
        }
    }

    /* Get the list pointer once again because it might change due to following list */
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* repeat the list */
    if (stepCount > 0) // forward stepping:
    {
        newRow = 0; // start of list
    }
    else // backward stepping
    {
        tListSize listSize;
        res = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN listPtr->dbBrowseListID);
        if (res) return res;
        newRow = listSize-1; // last object in list
    }
    /*
     * if list is in shuffle mode and a shuffle list is present:
     * return the first element of the shuffle list
     */
    if (listPtr->isInShuffleMode)
    {
        if (listPtr->shuffleTable) {

            /* if customer wants to re-shuffle list on wrapping, do it here */
            if (LocalSPM::GetDataProvider().ShuffleReshuffleOnListWrap()) {

                /* reshuffle the list */
                res = ReshuffleShuffleTable(INOUT listPtr);

                if (res != MP_NO_ERROR) {

                    ETG_TRACE_ERR(("ListControl::WrapProcessing: reShuffle failed: %d", res));

                    /* shuffling off now */
                    listPtr->isInShuffleMode = 0;
                } else {
                    /* select first song to play from new shuffle list */
                    newRow = listPtr->shuffleTable[newRow];
                }

            } else { // no new reshuffle:

                /* select first song to play from old shuffle list */
                newRow = listPtr->shuffleTable[newRow];
            }

        } else {
            ETG_TRACE_ERR(("ListControl::WrapProcessing: no shuffleTable - switch shuffleMode off"));
            listPtr->isInShuffleMode = 0;
        }
    }

    return MP_NO_ERROR;
}

tResult ListControl::NextInternal(tListID &listID, const int stepCount)
{

    ENTRY
    tResult res;

    /* Lock next object search to prevent reset of list position (GMMY17-11877) */
    mLock.lock();

    tObjectID initialObjectID = OBJECT_ID_NONE;
    tMediaObject mediaObject;
    mediaObject.objectID = OBJECT_ID_NONE;
    tRowNumber newRow;
    tListSize listSize = 1; // start with a list size 1 to do first one next step

    tRowNumber lastPlayedRow = ROW_NUMBER_NONE;

    /* next processing loop */
    //for(tUInt runs = 0; runs < listSize+1; runs++) {
    do //while( initialObjectID != mediaObject.objectID )
    {
        /* calc the new object position in list */
        res = NextProcessing(OUT newRow, OUT listSize, INOUT lastPlayedRow, IN listID, IN stepCount);
        if (res && res != MP_ERR_DB_END_OF_LIST) {
            mLock.unlock();
            return res;
        }

        /* is the end of list reached? repeat processing... */
        if (res == MP_ERR_DB_END_OF_LIST) {

            /* normal list wrap processing */
            res = WrapProcessing(OUT newRow, INOUT listID, IN stepCount);
            //If Position not playable,the following rows in the list will be checked for playback
            if (res && (res != MP_ERR_LC_POSITION_NOT_PLAYABLE)) {
                mLock.unlock();
                return res;
            }
        }

        /* Get the list pointer */
        tList *listPtr;
        GET_LIST_POINTER(OUT listPtr, IN listID);
        if (!listPtr) {
            mLock.unlock();
            return MP_ERR_LC_UNDEFINED_LIST_ID;
        }

        /* set initial objectID */
        if ((OBJECT_ID_NONE == initialObjectID)
                &&
                (OBJECT_ID_NONE != mediaObject.objectID)) {
            initialObjectID = mediaObject.objectID;
        }

        /* set the next media object */
        res = LocalSPM::GetDBManager().SetCurrentRow(IN listPtr->dbBrowseListID, IN newRow);
        if (res) {
            mLock.unlock();
            return res;
        }

        /* get media object */
        res = LocalSPM::GetDBManager().GetCurrentMediaObject(OUT mediaObject, IN listPtr->dbBrowseListID);
        if (res) {
            mLock.unlock();
            return res;
        }

        /* in case the DB could not deliver a correct device id for category lists */
        if (mediaObject.deviceID == DEVICE_ID_NOT_SET) {
            mediaObject.deviceID = listPtr->deviceID;
        }

        /* Check if the device of this list item is still present in case of a MyMedia list.
         * For all other lists do not check the connection state. It will be done in PlayerManager (GMMY17-14695) */
        tDeviceConnected connected = true;
        if (MY_MEDIA == listPtr->deviceID) {

            tDeviceInfo deviceInfo;
            res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN mediaObject.deviceID);
            if (res) {
                mLock.unlock();
                return res;
            }
            connected = deviceInfo.connected;
        }

        /* break search loop until a playable song/video from a connected device was found */
        if (connected)
        {
            if(mediaObject.fileType == FT_FOLDER)
            {
                // For the given FolderPath ,find audio/video object to Play
                res = FolderProcessing(OUT newRow,INOUT listID,IN mediaObject.fileName,IN stepCount);
                if(MP_NO_ERROR == res) //Found an item to play
                {
                    mLock.unlock();
                    return MP_NO_ERROR;
                }
            }
            else if((mediaObject.fileType != FT_PLAYLIST)&&
                    (mediaObject.notPlayable == FNP_PLAYABLE))
            {
                mLock.unlock();
                return MP_NO_ERROR;
            }
        }
    } while( !mStopFlag && initialObjectID != mediaObject.objectID ); //reach initial object again

    mLock.unlock();

    return MP_ERR_DB_END_OF_LIST;
}

tResult ListControl::Prev(tListID &listID, const tNextPrevSkipCount stepCount, const tHMIRequest isHMIRequest)
{
    ENTRY
    tResult res;
    tRepeatMode repeatMode;

    if(LIST_ID_NONE == listID) return MP_ERR_LC_UNDEFINED_LIST_ID;

    res = GetRepeatMode(OUT repeatMode);
    if (res) return res;
    res = SetPostionDuringIndexing(listID);/*indexing might change the current objects position, so set it again*/

    // if repeat mode = RPT_ONE do nothing. PlayerManager plays same song again
    if ((RPT_ONE == repeatMode)
            &&
            !((isHMIRequest) && (LocalSPM::GetDataProvider().IgnoreRepeatModeOneByUserNext()))) {
        return MP_NO_ERROR;
    }

    return NextInternal(INOUT listID, IN -((int)stepCount));

}

tResult ListControl::Next(tListID &listID, const tNextPrevSkipCount stepCount, const tHMIRequest isHMIRequest)
{
    ENTRY
    tResult res;
    tRepeatMode repeatMode;

    if(LIST_ID_NONE == listID) return MP_ERR_LC_UNDEFINED_LIST_ID;

    res = GetRepeatMode(OUT repeatMode);
    if (res) return res;
    res = SetPostionDuringIndexing(listID);/*indexing might change the current objects position, so set it again*/

    // if repeat mode = RPT_ONE do nothing. PlayerManager plays same song again
    if ((RPT_ONE == repeatMode)
            &&
            !((isHMIRequest) && (LocalSPM::GetDataProvider().IgnoreRepeatModeOneByUserNext()))) {
        return MP_NO_ERROR;
    }
    return NextInternal(INOUT listID, IN stepCount);
}

tResult ListControl::SetPostionDuringIndexing(const tListID listID)
{
    ENTRY
    tResult res = MP_NO_ERROR;
    tDeviceInfo deviceInfo;

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN listPtr->deviceID);

    if(!res && deviceInfo.indexedState == IDS_PARTIAL)
    {
        res = LocalSPM::GetDBManager().SetPosition(IN listPtr->nowPlayingObjectID, IN listPtr->dbBrowseListID);
    }
    return res;
}

tResult ListControl::GetMediaObject(tMediaObject &mediaObject, const tListID listID, const tPosition position)
{
    ENTRY
    tResult res = MP_NO_ERROR;

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* start list access */
    res = LocalSPM::GetDBManager().StartListAccess(IN listPtr->dbBrowseListID, IN position, IN 1);
    if (res) return res;

    res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN listPtr->dbBrowseListID, IN position);
    //if (res) return res; Don't return here without finalize list access

    /* finalize the list access */
    LocalSPM::GetDBManager().EndListAccess(IN listPtr->dbBrowseListID);

    return res;


}

tBool ListControl::IsSearchList(tListID listID)
{
    ENTRY
    tBool bRet = FALSE;
    for (std::vector<tListID>::iterator it = listIDsOfFullTextSearch.begin() ; it != listIDsOfFullTextSearch.end(); ++it)
    {
        if(*it == listID)
        {
            bRet = TRUE;
            break;
        }
    }
    VARTRACE(bRet);

    return bRet;
}


tListSize ListControl::AddChildSearchListsIfExists(IN const tListID listIDParent,INOUT std::vector<tListID> &listsToRelease)
{
    ENTRY
    tListSize resNumOfChildsAdded = 0;

    tListID listIDParentOfThisChild = LIST_ID_NONE;
    tListID listIDChild             = LIST_ID_NONE;

    tListInfo listInfo;

    tResult res;
    for (std::vector<tListID>::iterator it = listIDsOfFullTextSearch.begin() ; it != listIDsOfFullTextSearch.end(); ++it)
    {
        listIDChild = *it;

        InitListInfo(listInfo);
        res = GetListInfo(OUT listInfo, IN listIDChild, false /*=withListSize*/);
        if(res == MP_NO_ERROR)
        {
            listIDParentOfThisChild = listInfo.parent;
            if(listIDParentOfThisChild == listIDParent)
            {
                listsToRelease.push_back(listIDChild);
                resNumOfChildsAdded++;
            }
        }
        else
        {
            ETG_TRACE_FATAL(("[ERROR] AddChildSearchListsIfExists: GetListInfo(...) returned with error"));
        }
    }

    VARTRACE(resNumOfChildsAdded)
    return resNumOfChildsAdded;
}

tResult ListControl::StopFullTextSearch(const tListID listID)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    for (std::vector<tListID>::iterator it = listIDsOfFullTextSearch.begin() ; it != listIDsOfFullTextSearch.end(); ++it)
    {
        if(listID == *it)
        {
            ETG_TRACE_USR4(("StopFullTextSearch: listID:%d",listID));
            ThreadFctFullTextSearchStop(); //tbd.: Better error case with timout
            listIDsOfFullTextSearch.erase(it);
            break;
        }
    }

    VARTRACE(ret)
    return ret;
}


tResult ListControl::ReleaseList(const tListID listID, const tBoolean force/*=false*/)
{
    ENTRY
    VARTRACE(listID);
    VARTRACE(force);
    tResult res = MP_ERR_LC_UNDEFINED_LIST_ID;

    if(LIST_ID_NONE == listID) return res;

    /*Roadmap 160014 'full text search' */
    //searchString based list: stop corresponding thread
    std::vector<tListID> listsToRelease;

    listsToRelease.clear();
    listsToRelease.push_back(listID);

    tListSize elementsAdded = AddChildSearchListsIfExists(listID, listsToRelease);
    if(elementsAdded>1)
    {
        ETG_TRACE_USR4(("ReleaseList: ListID:%d plus %d child lists (full text search)",listID, elementsAdded))
    }

    /* search for the element */
    mLock.lock();

    tListID l_listID;
    for (std::vector<tListID>::iterator it = listsToRelease.begin() ; it != listsToRelease.end(); ++it)
    {
        l_listID = *it;
        if(IsSearchList(l_listID)) //Roadmap 160014 'fullt text search'
        {
            StopFullTextSearch(l_listID);
        }


        for(int i = mLists.size()-1; i>=0; i--)
        {
            if (mLists[i] && (mLists[i]->listID == l_listID))
            {
                mLists[i]->createCounter--;

                if (force || (mLists[i]->createCounter < 1))
                {
                    /* destroy lists in DB manager */
                    LocalSPM::GetDBManager().ReleaseDBList(IN mLists[i]->dbBrowseListID);

                    /* destroy list in list control */
                    /* mark list entry as not used */
                    mLists[i]->listID = LIST_ID_NONE;

                    /* delete the memory only if reference counter zero */
                    if (mLists[i]->refCounter < 1)
                    {
                        /* release the shuffe tables */
                        if (mLists[i]->shuffleTable) free(mLists[i]->shuffleTable);
                        if (mLists[i]->shuffleSkippingStack) free(mLists[i]->shuffleSkippingStack);

                        /* free the list context memory */
                        delete mLists[i];

                        /* remove the element from the vector */
                        mLists.erase(mLists.begin()+i);
                    }
                }

                res = MP_NO_ERROR; //element found
            }
        }
    }
    mLock.unlock();

    return res;
}

tResult ListControl::ReleaseAllLists()
{
    ENTRY

    //Remark: Do it in opposite order because the vector can be erased by an element defined by index
    mLock.lock();
    for(int i = mLists.size()-1; i>=0; i--) {
        if (mLists[i]->listID != LIST_ID_NONE) {

            //mLock.unlock(); In a reentrant pthread mutex, the same thread can acquire the lock multiple times. However, the lock must be released the same number of times.
            ReleaseList(mLists[i]->listID, true/*force*/);
            //mLock.lock();
        }
    }
    mLock.unlock();

    return MP_NO_ERROR;
}

tResult ListControl::GetPosition(tPosition &position, const tListID listID, const tListID parentListID)
{
    ENTRY
    tResult res;
    tObjectID objectToSearch;
    int filterTagNumber = 0;

    /* reset result */
    position = 0;

    /* get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* get the list pointer of parent */
    tList *listPtrParent;
    GET_LIST_POINTER(OUT listPtrParent, IN parentListID);
    if (!listPtrParent) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* get the object id to search for in the parent list */
    switch(listPtr->listType) {
        case    LTY_GENRE_ARTIST    :
            objectToSearch = listPtr->tag1.genre;
            filterTagNumber = 1;
            break;
        case    LTY_GENRE_ARTIST_ALBUM    :
            objectToSearch = listPtr->tag2.artist;
            filterTagNumber = 2;
            break;
        case    LTY_GENRE_ARTIST_ALBUM_SONG    :
            objectToSearch = listPtr->tag4.album;
            filterTagNumber = 4;
            break;
        case    LTY_GENRE_ARTIST_SONG    :
            objectToSearch = listPtr->tag2.artist;
            filterTagNumber = 2;
            break;
        case    LTY_GENRE_ALBUM    :
            objectToSearch = listPtr->tag1.genre;
            filterTagNumber = 1;
            break;
        case    LTY_GENRE_ALBUM_SONG    :
            objectToSearch = listPtr->tag4.album;
            filterTagNumber = 4;
            break;
        case    LTY_YEAR_ALBUM    :
            objectToSearch = listPtr->tag1.yearID;
            filterTagNumber = 1;
            break;
        case    LTY_YEAR_ALBUM_SONG    :
            objectToSearch = listPtr->tag4.album;
            filterTagNumber = 4;
            break;
        case    LTY_GENRE_SONG    :
            objectToSearch = listPtr->tag1.genre;
            filterTagNumber = 1;
            break;
        case    LTY_ARTIST_ALBUM    :
            objectToSearch = listPtr->tag2.artist;
            filterTagNumber = 2;
            break;
        case    LTY_ARTIST_ALBUM_SONG    :
            objectToSearch = listPtr->tag4.album;
            filterTagNumber = 4;
            break;
        case    LTY_ARTIST_SONG    :
            objectToSearch = listPtr->tag2.artist;
            filterTagNumber = 2;
            break;
        case    LTY_ALBUM_SONG    :
        case    LTY_COMPILATION_SONG  :
            objectToSearch = listPtr->tag4.album;
            filterTagNumber = 4;
            break;
        case    LTY_PODCAST_EPISODE    :
            objectToSearch = listPtr->tag1.podcast;
            filterTagNumber = 1;
            break;
        case    LTY_BOOKTITLE_CHAPTER    :
            objectToSearch = listPtr->tag2.audiobook;
            filterTagNumber = 2;
            break;
        case    LTY_AUTHOR_BOOKTITLE    :
            objectToSearch = listPtr->tag1.author;
            filterTagNumber = 1;
            break;
        case    LTY_AUTHOR_BOOKTITLE_CHAPTER    :
            objectToSearch = listPtr->tag2.audiobook;
            filterTagNumber = 2;
            break;
        case    LTY_COMPOSER_ALBUM    :
            objectToSearch = listPtr->tag3.composer;
            filterTagNumber = 3;
            break;
        case    LTY_COMPOSER_ALBUM_SONG    :
            objectToSearch = listPtr->tag4.album;
            filterTagNumber = 4;
            break;
        case    LTY_COMPOSER_SONG    :
            objectToSearch = listPtr->tag3.composer;
            filterTagNumber = 3;
            break;
        case    LTY_VIDEO_EPISODE    :
            objectToSearch = listPtr->tag1.video;
            filterTagNumber = 1;
            break;
        case    LTY_PLAYLIST_SONG    :
            objectToSearch = listPtr->tag1.playlist;
            filterTagNumber = 1;
            break;
        default:
            ETG_TRACE_ERR(("ListControl::GetPosition Unsupported list listID:%u listType:%u", listID, listPtr->listType));
            return MP_ERR_DB_UNSUPPORTED_LIST_TYPE;
    }

    res = LocalSPM::GetDBManager().StartListAccess(IN listPtrParent->dbBrowseListID, IN 0, INDEX_NO_LIMIT);
    if (res) return res;

    /* now search in the parents list after the object to get the position */
    for(position=0; 1; position++) {

        tMediaObject mediaObject;

        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listPtrParent->dbBrowseListID, position);
        if (res && res != MP_ERR_DB_END_OF_LIST) {
            LocalSPM::GetDBManager().EndListAccess(IN listPtrParent->dbBrowseListID);
            return res;
        }
        else if (res == MP_ERR_DB_END_OF_LIST) break; // end of list

        /* check the object id */
        int found = 0;
        switch(filterTagNumber) {
            case 1:
                if (mediaObject.MetadataTag1 == objectToSearch) found = 1;
                break;
            case 2:
                if (mediaObject.MetadataTag2 == objectToSearch) found = 1;
                break;
            case 3:
                if (mediaObject.MetadataTag3 == objectToSearch) found = 1;
                break;
            case 4:
                if (mediaObject.MetadataTag4 == objectToSearch) found = 1;
                break;
            default:
                break;
        }
        if (found) break;
    }

    LocalSPM::GetDBManager().EndListAccess(IN listPtrParent->dbBrowseListID);

    return res;
}

tResult ListControl::RequestListInformation(
        tListType &listType,
        tListID &parentListID,
        tDeviceID &deviceID,
        tPosition &position,
        tListSize &listSize,
        const tListID listID)
{
    ENTRY
    tResult res;

    /* Get the list pointer of new list */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* Set the output parameters */
    listType = listPtr->listType;
    parentListID = listPtr->parent;
    deviceID = listPtr->deviceID;

    /* Get list size */
    if ((listType == LTY_FILELIST_MEDIAOBJECTS)
            ||
            (listType == LTY_FILELIST_MEDIAOBJECTS_WITH_SUBFOLDERS)
            ||
            (listType == LTY_BROWSELIST_MEDIAOBJECTS)
            ||
            (listType == LTY_BROWSELIST_MEDIAOBJECTS_WITH_SUBFOLDERS)
            ||
            (listType == LTY_BROWSELIST_MEDIAOBJECTS_ALL)) {

        tNumberOfMediaObjects numberOfMediaObjects;
        tNumberOfPlayLists numberOfPlayLists;
        tNumberOfFolders numberOfFolders;
        res = LocalSPM::GetDBManager().GetFileListSize(OUT listSize, OUT numberOfMediaObjects, OUT numberOfPlayLists, OUT numberOfFolders, IN listPtr->dbBrowseListID);
        if (res) return res;

        if(LocalSPM::GetDataProvider().OnlyMediaObjectsInFileLists()) {
            listSize = numberOfMediaObjects;
        }
    }
    else {
        res = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN listPtr->dbBrowseListID);
        if (res) return res;
    }

    position = 0;
    if (parentListID != LIST_ID_NONE) {
        res = GetPosition(OUT position, IN listID, IN parentListID);
        if (res) return res;
    }

    return MP_NO_ERROR;
}

tResult ListControl::Quicksearch(
        tPosition &outposition,
        tSearchResult &quicksearchresult,
        const tListID listID,
        tPosition startposition,
        tSearchString searchstring
)
{
    ENTRY
    tResult res;
    tListInfo listInfo;
    tBoolean withListSize = true;
    res = GetListInfo(OUT listInfo, IN listID, withListSize);
    if (res) return res;
    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN listInfo.deviceID);
    if(res)return res;

    tListSize listSize = 0;
    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* get size of list */
    res = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN listPtr->dbBrowseListID);
    if (res) return res;

    if(startposition < listSize) // Do quicksearch only for Startposition less than Listsize.. (Hotspot Analysis Fix)
    {
        if(IsFileList(listInfo.listType))  //Quicksearch for Folderview
        {
            QuicksearchForFolderList(OUT outposition, OUT quicksearchresult, IN listID, IN startposition, IN searchstring);
        }
        else if((!(deviceInfo.indexedState == IDS_COMPLETE) &&
                IsAppleDevice(deviceInfo.deviceType) &&
                !(LocalSPM::GetDeviceDispatcher().IsBatchPlayable(listInfo.deviceID))))   //Quicksearch for BrowseList
        {
            QuicksearchForBrowseList(OUT outposition, OUT quicksearchresult, IN listID, IN startposition, IN searchstring);
        }
        else    //Quicksearch for IndexedList
        {
            QuicksearchForIndexedList(OUT outposition, OUT quicksearchresult, IN listID, IN startposition, IN searchstring);
        }
    }
    else
    {
        ETG_TRACE_ERR(("Startpostion greater than Listsize. No Quicksearch done.."));
        return MP_ERR_LC_INVALID_POSITION;
    }

    return MP_NO_ERROR;
}

tResult ListControl::QuicksearchForBrowseList(
        tPosition &outposition,
        tSearchResult &quicksearchresult,
        const tListID listID,
        tPosition startposition,
        tSearchString searchstring
)
{
    ENTRY
    tResult res;
    VARTRACE(listID);
    VARTRACE(startposition);
    VARTRACE(searchstring);
    /* Default values */
    quicksearchresult = ENDOFLIST;
    outposition = 0;
    tListSize listSize = 0;

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* get size of list */
    res = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN listPtr->dbBrowseListID);
    if (res) return res;

    /* Check if the list is supported */
    if(listPtr->listType < LTY_END_OF_EXTERNAL_LIST_TYPES)
    {
        /* Set Values for the boundary limits for Binary Search */
        tPosition lowerLimitIndex = startposition;
        tPosition upperLimitIndex = listSize-1;
        BinarySearchForQuicksearch(OUT outposition, OUT quicksearchresult, IN listID, IN lowerLimitIndex, IN upperLimitIndex, IN searchstring);
    }
    else
    {
        /* Unsupported List type */
        quicksearchresult = NOTSUPPORTED;
        ETG_TRACE_USR3(("ListControl::QuickSearch- Unsupported List..Exiting Quicksearch"));
    }

    /* Print Quicksearch Result */
    ETG_TRACE_USR3(("ListControl::QuickSearch_BrowseMethodResult= Quicksearchresult :%u, Outposition:%u", quicksearchresult, outposition));

    return MP_NO_ERROR;
}

tResult ListControl::QuicksearchForFolderList(
        tPosition &outposition,
        tSearchResult &quicksearchresult,
        const tListID listID,
        tPosition startposition,
        tSearchString searchstring
)
{
    ENTRY
    tResult res;
    VARTRACE(listID);
    VARTRACE(startposition);
    VARTRACE(searchstring);

    /* Default values */
    quicksearchresult = ENDOFLIST;
    outposition = 0;
    tListSize listSize = 0;

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* get the counts */
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    res = LocalSPM::GetDBManager().GetFileListSize(OUT listSize, OUT numberOfMediaObjects, OUT numberOfPlayLists, OUT numberOfFolders, IN listPtr->dbBrowseListID);
    ETG_TRACE_USR3(("ListControl::QuickSearchFILELIST mFileListID:%d , dbBrowseListID:%d",listID,listPtr->dbBrowseListID));
    if (res) return res;

    VARTRACE(listSize);
    VARTRACE(numberOfFolders);
    VARTRACE(numberOfPlayLists);
    VARTRACE(numberOfMediaObjects);

    /* Check the availablilty of folder, playlist and tracks content in list and
     * update the limit accordingly
     */
    tSearchFileType StartingFileType = FL_NONE ;
    int maxsize=0;

    if(numberOfFolders)
    {
        maxsize++;  // If folders are present
    }
    if(numberOfPlayLists)
    {
        maxsize++;  // If Playlists are present
    }
    if(numberOfMediaObjects)
    {
        maxsize++;  // If tracks(songs) are present
    }
    VARTRACE(maxsize);

    tPosition tempStartposition = QS_DEFAULT_STARTPOSITION;
    /* Set starting file type based on startposition */
    if(startposition<numberOfFolders)
    {
        StartingFileType = FL_FOLDER;
    }else if(startposition<(numberOfFolders + numberOfPlayLists))
    {
        StartingFileType = FL_PLAYLIST;
    }
    else
    {
        StartingFileType = FL_TRACK;
    }
    tempStartposition = startposition;  // Set intial startpostiion(specified by user) for first Quicksearch
    VARTRACE(StartingFileType);

    /* Set Values for the boundary limits for Binary Search */
    tPosition lowerLimitIndex = QS_DEFAULT_STARTPOSITION; //Default
    tPosition upperLimitIndex = QS_DEFAULT_STARTPOSITION;  //Default


    /* ITERATION FOR FIRST QUICKSEARCH ON LIST ..
     * Depending upon startposition, Search is started in one of the 3 file type lists */
    for(int count=0 ; count<maxsize; count++)
    {
        ETG_TRACE_USR3(("ListControl::Quicksearch_File= StartingFileType :%u", StartingFileType));

        //if encountered for the first time
        lowerLimitIndex = tempStartposition;
        switch(StartingFileType)
        {
            case FL_FOLDER:
                upperLimitIndex = numberOfFolders-1;
                break;

            case FL_PLAYLIST:
                upperLimitIndex = (numberOfFolders + numberOfPlayLists)-1;
                break;

            case FL_TRACK:
                upperLimitIndex = listSize-1;
                break;
            default:
                ETG_TRACE_ERR(("UNKNOWN FILETYPE"));
                break;
        }

        //Do Binary Search with updated limits
        BinarySearchForQuicksearch(OUT outposition, OUT quicksearchresult, IN listID, IN lowerLimitIndex, IN upperLimitIndex, IN searchstring);
        if(FOUND == quicksearchresult)
        {
            ETG_TRACE_USR3(("ListControl::QuickSearch_FileList_Result= Quicksearchresult :%u, Outposition:%u", quicksearchresult, outposition));
            break;  //Break from loop to give the found position
        }
        else
        {   /* If not found in any one file type, Update the StartingFileType to check in other file types
         * FOLDER->PLAYLIST->TRACK->FOLDER*/
            if(FL_FOLDER == StartingFileType)
            {
                if(numberOfPlayLists) // If playlists are available
                {
                    StartingFileType = FL_PLAYLIST;
                    tempStartposition = numberOfFolders;
                }
                else
                {
                    if(numberOfMediaObjects) // If Playlists are not available, but tracks are available
                    {
                        StartingFileType = FL_TRACK;
                        tempStartposition = (numberOfFolders + numberOfPlayLists);
                    }
                    else  // If both Playlists and tracks are not available
                    {
                        ETG_TRACE_USR3(("ListControl::QuickSearch_FileList NOT FOUND"));
                        quicksearchresult = FOLLOWING;
                        break;
                    }
                }
            }else if(FL_PLAYLIST == StartingFileType)
            {
                if(numberOfMediaObjects) // If Tracks are available
                {
                    StartingFileType = FL_TRACK;
                    tempStartposition = (numberOfFolders + numberOfPlayLists);
                }
                else
                {
                    if(numberOfFolders) // If Tracks are not available, but Folders are available
                    {
                        StartingFileType = FL_FOLDER;
                        tempStartposition = 0;
                    }
                    else // If both Tracks and Folders are not available
                    {
                        ETG_TRACE_USR3(("ListControl::QuickSearch_FileList NOT FOUND"));
                        quicksearchresult = FOLLOWING;
                        break;
                    }
                }

            }else
            {
                if(numberOfFolders) // If Folders are available
                {
                    StartingFileType = FL_FOLDER;
                    tempStartposition = 0;
                }
                else
                {
                    if(numberOfPlayLists) // If Folders are not available, but Playlists are available
                    {
                        StartingFileType = FL_PLAYLIST;
                        tempStartposition = numberOfFolders;
                    }
                    else // If both Folders and Playlists are not available
                    {
                        ETG_TRACE_USR3(("ListControl::QuickSearch_FileList NOT FOUND"));
                        quicksearchresult = FOLLOWING;
                        break;
                    }
                }
            }
        }
    }


    /*QUICKSEARCH FOR FINAL ITERATION
     * When startposition is not any of the default lowerlimits
     * and the mediaobject is not found in the above iterations */
    if(startposition)
    {
        if(FOUND != quicksearchresult)
        {
            upperLimitIndex = startposition-1;
            switch(StartingFileType)
            {
                case FL_FOLDER:
                    lowerLimitIndex = 0;
                    break;

                case FL_PLAYLIST:
                    lowerLimitIndex = numberOfFolders;
                    break;

                case FL_TRACK:
                    lowerLimitIndex = (numberOfFolders + numberOfPlayLists);
                    break;
                default:
                    ETG_TRACE_ERR(("UNKNOWN FILETYPE"));
                    break;
            }

            //Do Binary Search with updated limits
            BinarySearchForQuicksearch(OUT outposition, OUT quicksearchresult, IN listID, IN lowerLimitIndex, IN upperLimitIndex, IN searchstring);
            if(FOUND == quicksearchresult)
            {
                ETG_TRACE_USR3(("ListControl::QuickSearch_FileList.. ITEM FOUND"));
            }
            else
            {
                quicksearchresult = FOLLOWING;
            }
        }
    }

    ETG_TRACE_USR3(("ListControl::QuickSearch_FileList_RESULT for %s", searchstring));
    VARTRACE(quicksearchresult);
    VARTRACE(outposition);
    return MP_NO_ERROR;
}

tResult ListControl::BinarySearchForQuicksearch(
        tPosition &outposition,
        tSearchResult &quicksearchresult,
        const tListID listID,
        tPosition lowerLimitIndex,
        tPosition upperLimitIndex,
        tSearchString searchstring
)
{
    ENTRY

    VARTRACE(listID);
    VARTRACE(lowerLimitIndex);
    VARTRACE(upperLimitIndex);
    VARTRACE(searchstring);
    tResult res;
    tPosition searchIndex = 0;
    tListSize listSize = 0;
    tPosition FirstIndex = lowerLimitIndex;  // Store the lowerlimit Index for future reference
    //tPosition LastIndex = upperLimitIndex; // Store the Upperlimit Index for future reference
    VARTRACE(FirstIndex);
    //VARTRACE(LastIndex);

    // Get SortLib Rule table
    unsigned* SortRuleTable = LocalSPM::GetConfiguration().SortlibGetRuleTable();

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* Get the list Info */
    tListInfo listInfo;
    tBoolean withListSize = true;
    res = GetListInfo(OUT listInfo, IN listID, withListSize);
    if (res) return res;

    /* get size of list */
    res = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN listPtr->dbBrowseListID);
    if (res) return res;

    // Get SortingValue of SearchString set by user
    tUInt searchStringIndex = 0;
    /* Get unicode of searchstring */
    tUInt searchstring_unicode = sortlib_next_ucs_char(searchstring,&searchStringIndex,strlen_r(searchstring));
    ETG_TRACE_USR3(("ListControl::QuickSearch SEARCHSTRING :%s",searchstring));
    ETG_TRACE_USR3(("ListControl::QuickSearch  UNICODE:%u",searchstring_unicode));

    /* Get SortingValue of unicode */
    tUInt searchStringSortingValue = SortRuleTable[searchstring_unicode];
    ETG_TRACE_USR3(("ListControl::QuickSearch searchStringSortingValue : %u",searchStringSortingValue));

    /* get list access */
    res = LocalSPM::GetDBManager().StartListAccess(IN listPtr->dbBrowseListID, IN 0, IN listSize);
    if (res) return res;

    /*BINARY SEARCH*/
    // continue searching while [lowerLimitIndex,upperLimitIndex] is not empty
    while ((lowerLimitIndex <= upperLimitIndex) && (quicksearchresult != FOUND))
    {
        // calculate the midpoint for roughly equal partition
        searchIndex = (upperLimitIndex + lowerLimitIndex) / 2;
        VARTRACE(lowerLimitIndex);
        VARTRACE(upperLimitIndex);
        VARTRACE(searchIndex);

        /////////////* Get SortingValue of Mediaobject(at SearchIndex) in List *///////////////////////////////////////
        tMediaObject mediaObject;
        tMetadata dbSearchMetadata; //Metadata searched for
        tURL fullName;

        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject , IN listPtr->dbBrowseListID, IN searchIndex);
        if (res) break;

        // Update dbSearchMetadata- Metadata searched for- Based on file type
        if(IsFileList(listInfo.listType))
        {
            //unsigned char *pureFile;
            unsigned char *pureFile;
            strncpy_r(OUT fullName, IN mediaObject.fileName, IN sizeof(fullName));
            FastUTF8::Split(OUT pureFile, INOUT (unsigned char *)fullName);
            strncpy_r(OUT dbSearchMetadata, IN (const char *)pureFile, IN sizeof(dbSearchMetadata));
        }
        else
        {
            res = GetDBSearchMetadata(mediaObject,dbSearchMetadata); // Get Search Metadata based on Category Type
            if(res)  return res;

            if(LocalSPM::GetDataProvider().IgnoreSpecialCharachters())
            {
                res = IgnoreSpecialWordsFromBeginning(dbSearchMetadata);  // Ignore special characters A An The from metadata
                if(res)  return res;
            }
        }

        ETG_TRACE_USR3(("ListControl::QuickSearch dbMetadata :%s ", dbSearchMetadata ));

        tUInt mediaObjectIndex=0;

        /*Convert to upper -- As HMI always provides Uppercase searchstring(for ASCII) NCG3D-3707*/
        strupper(dbSearchMetadata);

        /* Get unicode of metadata */
        tUInt dbSearchMetadata_unicode = sortlib_next_ucs_char(dbSearchMetadata,&mediaObjectIndex,strlen_r(dbSearchMetadata));
        ETG_TRACE_USR3(("ListControl::QuickSearch dbSearchMetadata Postition:%d",searchIndex));
        ETG_TRACE_USR3(("ListControl::QuickSearch dbSearchMetadata String:%s",dbSearchMetadata));
        ETG_TRACE_USR3(("ListControl::QuickSearch dbSearchMetadata UNICODE:%u", dbSearchMetadata_unicode));

        /* Get SortingValue of unicode */
        tUInt dbSearchMetadataSortingValue;
        if (SortRuleTable[dbSearchMetadata_unicode] > QS_NONSPECIALCHAR_FIRST_RANK) /* All values less than QS_NONSPECIALCHAR_FIRST_RANK  are special characters or numbers */
        {
            dbSearchMetadataSortingValue = SortRuleTable[dbSearchMetadata_unicode];
            ETG_TRACE_USR3(("ListControl::QuickSearch dbSearchMetadataSortingValue : %u",dbSearchMetadataSortingValue));
        }
        else
        {
            dbSearchMetadataSortingValue = SortRuleTable[0x0021];/*0x0021 is the unicode for exclamation mark , as exclamation mark is the search string for special charectes and numbers*/
            ETG_TRACE_USR3(("ListControl::QuickSearch Setting dbSearchMetadataSortingValue to '!' "));
            ETG_TRACE_USR3(("ListControl::QuickSearch dbSearchMetadataSortingValue : %u",dbSearchMetadataSortingValue));
        }
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        /*Do Binary Search*/
        if(dbSearchMetadataSortingValue == searchStringSortingValue)    // key found at index imid
        {
            quicksearchresult = FOUND;
            outposition=searchIndex;

            /* FIRST OCCURENCE LOGIC
             * Compare if 'FOUND' object is the first occurrence in list */
            if(searchIndex > FirstIndex)
            {
                res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject , IN listPtr->dbBrowseListID, IN (searchIndex-1));
                if (res) break;

                // Update dbSearchMetadata- Metadata searched for- Based on file type
                if(IsFileList(listInfo.listType))
                {
                    //unsigned char *pureFile;
                    unsigned char *pureFile;
                    strncpy_r(OUT fullName, IN mediaObject.fileName, IN sizeof(fullName));
                    FastUTF8::Split(OUT pureFile, INOUT (unsigned char *)fullName);
                    strncpy_r(OUT dbSearchMetadata, IN (const char *)pureFile, IN sizeof(dbSearchMetadata));
                }
                else
                {
                    res = GetDBSearchMetadata(mediaObject,dbSearchMetadata); // Get Search Metadata based on Category Type
                    if(res)  return res;

                    if(LocalSPM::GetDataProvider().IgnoreSpecialCharachters())
                    {
                        res = IgnoreSpecialWordsFromBeginning(dbSearchMetadata);  // Ignore special characters A An The from metadata
                        if(res)  return res;
                    }
                }

                ETG_TRACE_USR3(("ListControl::QuickSearch dbMetadata Rpt:%s ", dbSearchMetadata ));

                /*Convert to upper -- As HMI always provides Uppercase searchstring(for ASCII) NCG3D-3707*/
                strupper(dbSearchMetadata);

                tUInt firstOccurIndex=0;
                /* Get unicode of metadata at searchIndex-1 */
                tUInt dbSearchMetadata_unicode = sortlib_next_ucs_char(dbSearchMetadata,&firstOccurIndex,strlen_r(dbSearchMetadata));
                ETG_TRACE_USR3(("ListControl::QuickSearch dbSearchMetadata_RPT Postition:%d",searchIndex-1));
                ETG_TRACE_USR3(("ListControl::QuickSearch dbSearchMetadata_RPT String:%s",dbSearchMetadata));
                ETG_TRACE_USR3(("ListControl::QuickSearch dbSearchMetadata_RPT UNICODE:%u", dbSearchMetadata_unicode));

                /* Get SortingValue of unicode */

                if (SortRuleTable[dbSearchMetadata_unicode] > QS_NONSPECIALCHAR_FIRST_RANK) /* All values less than QS_NONSPECIALCHAR_FIRST_RANK  are special characters or numbers */
                {
                    dbSearchMetadataSortingValue = SortRuleTable[dbSearchMetadata_unicode];
                    ETG_TRACE_USR3(("ListControl::QuickSearch dbSearchMetadataSortingValue_RPT : %u",dbSearchMetadataSortingValue));
                }
                else
                {
                    dbSearchMetadataSortingValue = SortRuleTable[0x0021];/*0x0021 is the unicode for exclamation mark , as exclamation mark is the search string for special charectes and numbers*/
                    ETG_TRACE_USR3(("ListControl::QuickSearch dbSearchMetadataSortingValue_RPT : ! "));
                }
                if(dbSearchMetadataSortingValue == searchStringSortingValue) // If the previous mediaobject is also the searchstring
                {
                    //Do binary search again with setting from firstindex to searchindex-1
                    upperLimitIndex = searchIndex-1;
                    quicksearchresult = ENDOFLIST; // Set to continue the loop
                }
                else
                {
                    //Found searchindex is the first occuring charachter in list
                    outposition=searchIndex;
                    quicksearchresult = FOUND;
                }
            }
            ETG_TRACE_USR3(("ListControl::QuickSearch FOUND Quicksearchresult:%u, Outposition:%u", quicksearchresult, outposition));
        }
        else if (dbSearchMetadataSortingValue < searchStringSortingValue)
        {
            lowerLimitIndex = searchIndex + 1;
            ETG_TRACE_USR3(("ListControl::QuickSearch(dbSearchMetadataSortingValue < searchStringSortingValue) Outposition:%u",  outposition));
        }
        else
        {
            upperLimitIndex = searchIndex - 1;
            ETG_TRACE_USR3(("ListControl::QuickSearch(dbSearchMetadataSortingValue > searchStringSortingValue) Outposition:%u",  outposition));
        }
    } // Loop end

    /* If object is not found and index is equal to listsize */
    if((outposition == (listSize-1)) && (quicksearchresult != FOUND))
    {
        quicksearchresult = ENDOFLIST;
        ETG_TRACE_USR3(("ListControl::QuickSearch(Endoflist) Quicksearchresult:%u, Outposition:%u", quicksearchresult, outposition));
    }

    /* If object is not found and index is less than listsize */
    if(outposition < ((listSize-1)) && (quicksearchresult != FOUND))
    {
        quicksearchresult = FOLLOWING;
        outposition=upperLimitIndex+1;
        ETG_TRACE_USR3(("ListControl::QuickSearch(Following) Quicksearchresult:%u, Outposition:%u", quicksearchresult, outposition));
    }

    /* finalize the list access */
    LocalSPM::GetDBManager().EndListAccess(IN listPtr->dbBrowseListID);

    return MP_NO_ERROR;
}

tResult ListControl::QuicksearchForIndexedList(
        tPosition &outposition,
        tSearchResult &quicksearchresult,
        const tListID listID,
        tPosition startposition,
        tSearchString searchstring
)
{
    ENTRY
    tResult res;
    VARTRACE(listID);
    VARTRACE(startposition);
    VARTRACE(searchstring);
    /* Default values */
    quicksearchresult = ENDOFLIST;
    outposition = 0;
    tListSize listSize = 0;

    unsigned* SortRuleTable = LocalSPM::GetConfiguration().SortlibGetRuleTable();
    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* Check if the list is supported */
    if(listPtr->listType < LTY_END_OF_EXTERNAL_LIST_TYPES)
    {
        /* get size of list */
        res = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN listPtr->dbBrowseListID);
        if (res) return res;
        VARTRACE(listSize);

        vector<tSearchKeyboard> searchKeyboardList;
        /* Get the vertical keyboard list */
        res = LocalSPM::GetDBManager().GetSearchKeyboard(OUT searchKeyboardList, IN listPtr->dbBrowseListID);
        if(res)
        {
            if (res == MP_ERR_DB_SEARCHKEYS_NOT_SUPPORTED)
            {
                /*FALLBACK to binary search for IAP1 device*/
                tPosition lowerLimitIndex = startposition;
                tPosition upperLimitIndex = listSize-1;
                res = BinarySearchForQuicksearch(OUT outposition, OUT quicksearchresult, IN listID, IN lowerLimitIndex, IN upperLimitIndex, IN searchstring);
            }
            return res;
        }

        tUInt i=0;
        tUInt mediatitle_unicode=0;
        tUInt mediaTitleSortingValue=0;
        tUInt searchStringIndex = 0;
        tUInt searchstring_unicode = sortlib_next_ucs_char(searchstring,&searchStringIndex,strlen_r(searchstring));

        /* Get SortingValue of unicode */
        tUInt searchStringSortingValue = SortRuleTable[searchstring_unicode];
        ETG_TRACE_USR3(("ListControl::QuickSearch Searchstring: %s",searchstring));
        ETG_TRACE_USR3(("ListControl::QuickSearch searchstring_unicode : %u",searchstring_unicode));

        /*Loop utilizing Searchkeyboardlist*/
        for(i=0; i<searchKeyboardList.size(); i++)
        {

            if(searchKeyboardList[i].available==1)
            {
                tUInt mediaObjectIndex=0;
                mediatitle_unicode = sortlib_next_ucs_char(searchKeyboardList[i].letter,&mediaObjectIndex,strlen_r(searchKeyboardList[i].letter));
                //                ETG_TRACE_USR3(("ListControl::QuickSearch letter: %s mediatitle_unicode : %u",searchKeyboardList[i].letter,mediatitle_unicode));
                ETG_TRACE_USR3(("ListControl::QuickSearch Letter: %s",searchKeyboardList[i].letter));
                ETG_TRACE_USR3(("ListControl::QuickSearch mediatitle_unicode : %u",mediatitle_unicode));

                /* Get SortingValue of unicode */
                mediaTitleSortingValue = SortRuleTable[mediatitle_unicode];
                ETG_TRACE_USR3(("ListControl::QuickSearch mediaTitleSortingValue : %u",mediaTitleSortingValue));
                ETG_TRACE_USR3(("ListControl::QuickSearch Loopcount : %u",i));

                if(!(mediaTitleSortingValue < searchStringSortingValue))
                {
                    break;
                }
            }
        }


        if(mediaTitleSortingValue == searchStringSortingValue)
        {
            quicksearchresult = FOUND;
            if((startposition >= searchKeyboardList[i].startIndex) && (startposition <= searchKeyboardList[i].endIndex))  //NCG3D-15726 Check if startposition is between the indexes for searched charachter
            {
                outposition = startposition;
                ETG_TRACE_USR3(("ListControl::QuickSearch startposition=outpostion : : %u",outposition));
            }
            else
            {
                outposition = searchKeyboardList[i].startIndex;
                ETG_TRACE_USR3(("ListControl::QuickSearch StartIndex=outpostion : : %u",outposition));
            }

        }else if(i !=searchKeyboardList.size())
        {
            quicksearchresult = FOLLOWING;
            outposition = searchKeyboardList[i].startIndex;
        }else
        {
            quicksearchresult= ENDOFLIST;
            outposition=listSize-1;
        }

    }
    else
    {
        /* Unsupported List type */
        quicksearchresult = NOTSUPPORTED;
        ETG_TRACE_USR3(("ListControl::QuickSearch- Unsupported List..Exiting Quicksearch"));
    }

    /* Print Quicksearch Result */
    ETG_TRACE_USR3(("ListControl::QuickSearch_IndexedMethodResult= Quicksearchresult :%u, Outposition:%u", quicksearchresult, outposition));

    return MP_NO_ERROR;


}

tResult ListControl::SearchKeyboardMediaPlayerList(vector<tSearchKeyboard> &searchKeyboardList,
        const tListID listID)
{
    ENTRY
    tResult res;

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* Get the vertical keyboard list */
    res = LocalSPM::GetDBManager().GetSearchKeyboard(OUT searchKeyboardList, IN listPtr->dbBrowseListID);
    if (res) return res;

    return MP_NO_ERROR;
}

tResult ListControl::CreateMediaPlayerPlaylistParent(const tListID listID, const tPath path, const tDeviceID deviceID, const tStreaming streaming)
{
    ENTRY
    tResult res;

    VARTRACE(listID);
    VARTRACE(path);
    VARTRACE(deviceID);

    tListID playlistID;
    tListSize playlistSize;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    vector<tMediaObject> mediaObjectVector;

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    res = CreateMediaPlayerIndexedList(
            OUT playlistID,
            OUT playlistSize,
            LTY_PLAYLIST,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    if (res) return res;

    res = RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN playlistID, 0, IN playlistSize);
    if (res) return res;

    /* loop over all elements and search for related playlist name */
    for(tUInt i=0; i<mediaObjectVector.size(); i++)
    {
        if(!strcmp(path, mediaObjectVector[i].fileName))
        {
            /* Get the list pointer */
            tList *playlistPtr;
            GET_LIST_POINTER(OUT playlistPtr, IN playlistID);
            if (!playlistPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

            /* set this list as parent to given one */
            listPtr->parent = playlistID;
            listPtr->tag1.playlist = mediaObjectVector[i].objectID;

            /* set its next to the given list */
            playlistPtr->next = listPtr->listID;
            playlistPtr->nowPlayingListPosition = i;

            ETG_TRACE_USR3(("ListControl create a list of playlists and highlight the related one: parent=%d, nowPlayingListPosition=%d",
                    listPtr->parent, playlistPtr->nowPlayingListPosition));
            break;
        }
    }

    return MP_NO_ERROR;
}


tResult ListControl::SetParentListCriteria(OUT tList &parentListCriteria,IN tList *listPtr)
{

    ENTRY

    tResult ret = MP_NO_ERROR;

    if(listPtr)
    {
        switch(listPtr->listType)
        {
            //all entries with 'LTY_...SEARCH' added for 'Roadmap 160014 full text search:
            case LTY_GENRE:
                parentListCriteria.listType    = LTY_END_OF_EXTERNAL_LIST_TYPES;
                break;
            case LTY_GENRE_SEARCH:
                parentListCriteria.listType = LTY_GENRE;
                break;
            case LTY_YEAR:
                parentListCriteria.listType    = LTY_END_OF_EXTERNAL_LIST_TYPES;
                break;
            case LTY_ARTIST:
                parentListCriteria.listType    = LTY_END_OF_EXTERNAL_LIST_TYPES;
                break;
            case LTY_ARTIST_SEARCH:
                parentListCriteria.listType = LTY_ARTIST;
                break;
            case LTY_ALBUM:
                parentListCriteria.listType    = LTY_END_OF_EXTERNAL_LIST_TYPES;
                break;
            case LTY_ALBUM_SEARCH:
                parentListCriteria.listType = LTY_ALBUM;
                break;
            case LTY_ALBUM_UNKNOWN_ALBUMART:
                parentListCriteria.listType    = LTY_END_OF_EXTERNAL_LIST_TYPES;
                break;
            case LTY_COMPILATION:
                parentListCriteria.listType    = LTY_END_OF_EXTERNAL_LIST_TYPES;
                break;
            case LTY_COMPILATION_SEARCH:
                parentListCriteria.listType    = LTY_COMPILATION;
                break;
            case LTY_SONG:
                parentListCriteria.listType    = LTY_END_OF_EXTERNAL_LIST_TYPES;
                break;
            case LTY_SONG_SEARCH:
                parentListCriteria.listType = LTY_SONG;
                break;
            case LTY_GENRE_ARTIST:
                parentListCriteria.listType    = LTY_GENRE;
                parentListCriteria.nowPlayingObjectID = listPtr->tag1.genre;
                break;
            case LTY_GENRE_ARTIST_SEARCH:
                parentListCriteria.listType = LTY_GENRE_ARTIST;
                parentListCriteria.nowPlayingObjectID = listPtr->tag1.genre;
                break;
            case LTY_GENRE_ARTIST_ALBUM:
                parentListCriteria.listType    = LTY_GENRE_ARTIST;
                parentListCriteria.tag1.genre = listPtr->tag1.genre;
                parentListCriteria.nowPlayingObjectID = listPtr->tag2.artist;
                break;
            case LTY_GENRE_ARTIST_ALBUM_SEARCH:
                parentListCriteria.listType = LTY_GENRE_ARTIST_ALBUM;
                parentListCriteria.tag1.genre = listPtr->tag1.genre;
                parentListCriteria.nowPlayingObjectID = listPtr->tag2.artist;
                break;
            case LTY_GENRE_ARTIST_ALBUM_SONG:
                parentListCriteria.listType    = LTY_GENRE_ARTIST_ALBUM;
                parentListCriteria.tag1.genre = listPtr->tag1.genre;
                parentListCriteria.tag2.artist = listPtr->tag2.artist;
                parentListCriteria.nowPlayingObjectID = listPtr->tag4.album;
                break;
            case LTY_GENRE_ARTIST_ALBUM_SONG_SEARCH:
                parentListCriteria.listType = LTY_GENRE_ARTIST_ALBUM_SONG;
                parentListCriteria.tag1.genre = listPtr->tag1.genre;
                parentListCriteria.tag2.artist = listPtr->tag2.artist;
                parentListCriteria.nowPlayingObjectID = listPtr->tag4.album;
                break;
            case LTY_GENRE_ARTIST_SONG:
                parentListCriteria.listType    = LTY_GENRE_ARTIST;
                parentListCriteria.tag1.genre = listPtr->tag1.genre;
                parentListCriteria.nowPlayingObjectID = listPtr->tag2.artist;
                break;
            case LTY_GENRE_ARTIST_SONG_SEARCH:
                parentListCriteria.listType = LTY_GENRE_ARTIST_SONG;
                parentListCriteria.tag1.genre = listPtr->tag1.genre;
                parentListCriteria.nowPlayingObjectID = listPtr->tag2.artist;
                break;
            case LTY_GENRE_ALBUM:
                parentListCriteria.listType    = LTY_GENRE;
                parentListCriteria.nowPlayingObjectID = listPtr->tag1.genre;
                break;
            case LTY_GENRE_ALBUM_SEARCH:
                parentListCriteria.listType = LTY_GENRE_ALBUM;
                parentListCriteria.nowPlayingObjectID = listPtr->tag1.genre;
                break;
            case LTY_GENRE_ALBUM_SONG:
                parentListCriteria.listType    = LTY_GENRE_ALBUM;
                parentListCriteria.tag1.genre = listPtr->tag1.genre;
                parentListCriteria.nowPlayingObjectID = listPtr->tag4.album;
                break;
            case LTY_GENRE_ALBUM_SONG_SEARCH:
                parentListCriteria.listType = LTY_GENRE_ALBUM_SONG;
                parentListCriteria.tag1.genre = listPtr->tag1.genre;
                parentListCriteria.nowPlayingObjectID = listPtr->tag4.album;
                break;
            case LTY_YEAR_ALBUM:
                parentListCriteria.listType    = LTY_YEAR;
                parentListCriteria.nowPlayingObjectID = listPtr->tag1.yearID;
                break;
            case LTY_YEAR_ALBUM_SEARCH:
                parentListCriteria.listType = LTY_YEAR_ALBUM;
                parentListCriteria.nowPlayingObjectID = listPtr->tag1.yearID;
                break;
            case LTY_YEAR_ALBUM_SONG:
                parentListCriteria.listType    = LTY_YEAR_ALBUM;
                parentListCriteria.tag1.yearID = listPtr->tag1.yearID;
                parentListCriteria.nowPlayingObjectID = listPtr->tag4.album;
                break;
            case LTY_YEAR_ALBUM_SONG_SEARCH:
                parentListCriteria.listType = LTY_YEAR_ALBUM_SONG;
                parentListCriteria.tag1.yearID = listPtr->tag1.yearID;
                parentListCriteria.nowPlayingObjectID = listPtr->tag4.album;
                break;
            case LTY_GENRE_SONG:
                parentListCriteria.listType    = LTY_GENRE;
                parentListCriteria.nowPlayingObjectID = listPtr->tag1.genre;
                break;
            case LTY_GENRE_SONG_SEARCH:
                parentListCriteria.listType = LTY_GENRE_SONG;
                parentListCriteria.nowPlayingObjectID = listPtr->tag1.genre;
                break;
            case LTY_ARTIST_ALBUM:
                parentListCriteria.listType    = LTY_ARTIST;
                parentListCriteria.nowPlayingObjectID = listPtr->tag2.artist;
                break;
            case LTY_ARTIST_ALBUM_SEARCH:
                parentListCriteria.listType = LTY_ARTIST_ALBUM;
                parentListCriteria.nowPlayingObjectID = listPtr->tag2.artist;
                break;
            case LTY_ARTIST_ALBUM_SONG:
                parentListCriteria.listType    = LTY_ARTIST_ALBUM;
                parentListCriteria.tag2.artist = listPtr->tag2.artist;
                parentListCriteria.nowPlayingObjectID = listPtr->tag4.album;
                break;
            case LTY_ARTIST_ALBUM_SONG_SEARCH:
                parentListCriteria.listType = LTY_ARTIST_ALBUM_SONG;
                parentListCriteria.tag2.artist = listPtr->tag2.artist;
                parentListCriteria.nowPlayingObjectID = listPtr->tag4.album;
                break;
            case LTY_ARTIST_SONG:
                parentListCriteria.listType    = LTY_ARTIST;
                parentListCriteria.nowPlayingObjectID = listPtr->tag2.artist;
                break;
            case LTY_ARTIST_SONG_SEARCH:
                parentListCriteria.listType = LTY_ARTIST_SONG;
                parentListCriteria.nowPlayingObjectID = listPtr->tag2.artist;
                break;
            case LTY_ALBUM_SONG:
                parentListCriteria.listType    = LTY_ALBUM;
                parentListCriteria.nowPlayingObjectID = listPtr->tag4.album;
                break;
            case LTY_ALBUM_SONG_SEARCH:
                parentListCriteria.listType = LTY_ALBUM_SONG;
                parentListCriteria.nowPlayingObjectID = listPtr->tag4.album;
                break;
            case LTY_COMPILATION_SONG:
                parentListCriteria.listType    = LTY_ALBUM;
                parentListCriteria.nowPlayingObjectID = listPtr->tag4.album;
                break;
            case LTY_COMPILATION_SONG_SEARCH:
                parentListCriteria.listType    = LTY_COMPILATION_SONG;
                parentListCriteria.nowPlayingObjectID = listPtr->tag4.album;
                break;
            case LTY_PODCAST:
                parentListCriteria.listType    = LTY_END_OF_EXTERNAL_LIST_TYPES;
                break;
            case LTY_PODCAST_SEARCH:
                parentListCriteria.listType    = LTY_PODCAST;
                break;
            case LTY_PODCAST_EPISODE:
                parentListCriteria.listType    = LTY_PODCAST;
                parentListCriteria.nowPlayingObjectID = listPtr->tag1.podcast;
                break;
            case LTY_PODCAST_EPISODE_SEARCH:
                parentListCriteria.listType    = LTY_PODCAST_EPISODE;
                parentListCriteria.nowPlayingObjectID = listPtr->tag1.podcast;
                break;
            case LTY_AUDIOBOOK:
                parentListCriteria.listType    = LTY_END_OF_EXTERNAL_LIST_TYPES;
                break;
            case LTY_AUDIOBOOK_SEARCH:
                parentListCriteria.listType    = LTY_AUDIOBOOK;
                break;
            case LTY_BOOKTITLE_CHAPTER:
                parentListCriteria.listType    = LTY_AUDIOBOOK;
                parentListCriteria.nowPlayingObjectID = listPtr->tag2.audiobook;
                break;
            case LTY_BOOKTITLE_CHAPTER_SEARCH:
                parentListCriteria.listType    = LTY_BOOKTITLE_CHAPTER;
                parentListCriteria.nowPlayingObjectID = listPtr->tag2.audiobook;
                break;
            case LTY_AUTHOR:
                parentListCriteria.listType    = LTY_END_OF_EXTERNAL_LIST_TYPES;
                break;
            case LTY_AUTHOR_SEARCH:
                parentListCriteria.listType    = LTY_AUTHOR;
                break;
            case LTY_AUTHOR_BOOKTITLE:
                parentListCriteria.listType    =LTY_AUTHOR;
                parentListCriteria.nowPlayingObjectID = listPtr->tag1.author;
                break;
            case LTY_AUTHOR_BOOKTITLE_SEARCH:
                parentListCriteria.listType    =LTY_AUTHOR_BOOKTITLE;
                parentListCriteria.nowPlayingObjectID = listPtr->tag1.author;
                break;
            case LTY_AUTHOR_BOOKTITLE_CHAPTER:
                parentListCriteria.listType    = LTY_AUTHOR_BOOKTITLE;
                parentListCriteria.tag1.author = listPtr->tag1.author;
                parentListCriteria.nowPlayingObjectID = listPtr->tag2.audiobook;
                break;
            case LTY_AUTHOR_BOOKTITLE_CHAPTER_SEARCH:
                parentListCriteria.listType    = LTY_AUTHOR_BOOKTITLE_CHAPTER;
                parentListCriteria.tag1.author = listPtr->tag1.author;
                parentListCriteria.nowPlayingObjectID = listPtr->tag2.audiobook;
                break;
            case LTY_COMPOSER:
                parentListCriteria.listType    = LTY_END_OF_EXTERNAL_LIST_TYPES;
                break;
            case LTY_COMPOSER_SEARCH:
                parentListCriteria.listType    = LTY_COMPOSER;
                break;
            case LTY_COMPOSER_ALBUM:
                parentListCriteria.listType    = LTY_COMPOSER;
                parentListCriteria.nowPlayingObjectID = listPtr->tag3.composer;
                break;
            case LTY_COMPOSER_ALBUM_SEARCH:
                parentListCriteria.listType    = LTY_COMPOSER_ALBUM;
                parentListCriteria.nowPlayingObjectID = listPtr->tag3.composer;
                break;
            case LTY_COMPOSER_ALBUM_SONG:
                parentListCriteria.listType    = LTY_COMPOSER_ALBUM;
                parentListCriteria.tag3.composer = listPtr->tag3.composer;
                parentListCriteria.nowPlayingObjectID = listPtr->tag4.album;
                break;
            case LTY_COMPOSER_ALBUM_SONG_SEARCH:
                parentListCriteria.listType    = LTY_COMPOSER_ALBUM_SONG;
                parentListCriteria.tag3.composer = listPtr->tag3.composer;
                parentListCriteria.nowPlayingObjectID = listPtr->tag4.album;
                break;
            case LTY_COMPOSER_SONG:
                parentListCriteria.listType    = LTY_COMPOSER;
                parentListCriteria.nowPlayingObjectID = listPtr->tag3.composer;
                break;
            case LTY_COMPOSER_SONG_SEARCH:
                parentListCriteria.listType    = LTY_COMPOSER_SONG;
                parentListCriteria.nowPlayingObjectID = listPtr->tag3.composer;
                break;
            case LTY_VIDEO:
                parentListCriteria.listType    = LTY_END_OF_EXTERNAL_LIST_TYPES;
                break;
            case LTY_VIDEO_SEARCH:
                parentListCriteria.listType    = LTY_VIDEO;
                break;
            case LTY_VIDEO_EPISODE:
                parentListCriteria.listType    = LTY_VIDEO;
                parentListCriteria.nowPlayingObjectID = listPtr->tag1.video;
                break;
            case LTY_VIDEO_EPISODE_SEARCH:
                parentListCriteria.listType    = LTY_VIDEO_EPISODE;
                parentListCriteria.nowPlayingObjectID = listPtr->tag1.video;
                break;
            case LTY_PLAYLIST:
                parentListCriteria.listType    = LTY_END_OF_EXTERNAL_LIST_TYPES;
                break;
            case LTY_PLAYLIST_SEARCH:
                parentListCriteria.listType    = LTY_PLAYLIST;
                break;
            case LTY_PLAYLIST_SONG_SEARCH:
                parentListCriteria.listType = LTY_PLAYLIST_SONG;
                //askRoadmap 160014
                break;
            case LTY_PLAYLIST_SONG:
            case LTY_FILELIST_PLAYLIST:
                if(listPtr->tag1.playlist)
                {
                    parentListCriteria.listType = LTY_PLAYLIST;
                    parentListCriteria.nowPlayingObjectID = listPtr->tag1.playlist;
                }
                else
                {
                    /* create a list of playlists and highlight the related one */
                    CreateMediaPlayerPlaylistParent(IN listPtr->listID, IN listPtr->path, IN listPtr->deviceID, IN listPtr->streaming);

                    parentListCriteria.listType = LTY_END_OF_EXTERNAL_LIST_TYPES;
                }
                break;
            case LTY_USER_FAVORITES_SONG_SEARCH:
                parentListCriteria.listType = LTY_USER_FAVORITES_SONG;
                //askRoadmap 160014
                break;


            default:
                parentListCriteria.listType    = LTY_END_OF_EXTERNAL_LIST_TYPES;
                break;
        }
    }
    else
    {
        ret = MP_ERR_LC_GENERAL_ERROR;
        ETG_TRACE_FATAL(("[MP_ERR_LC_GENERAL_ERROR]: ListControl: SetParentListCriteria: listPtr is NULL !!! "));
    }

    return ret;
}


//listPtr is pointer of the current list i.e. the list which has been creaded
tResult ListControl::SetParent(tList *listPtr)
{
    ENTRY
    //tResult res;
    tList parentListCriteria;

    /* reset parent list info */
    memset(&parentListCriteria, 0, sizeof(tList));

    /* figure out the parent list type */
    if(MP_NO_ERROR != SetParentListCriteria(OUT parentListCriteria, IN listPtr))
    {
        parentListCriteria.listType = LTY_END_OF_EXTERNAL_LIST_TYPES; //default behaviour
    }

    /* no parent possible? */
    if (parentListCriteria.listType == LTY_END_OF_EXTERNAL_LIST_TYPES) {
        return MP_NO_ERROR;
    }

    parentListCriteria.deviceID = listPtr->deviceID;
    parentListCriteria.streaming = listPtr->streaming;
    parentListCriteria.isVTIPODList = listPtr->isVTIPODList;

    ETG_TRACE_USR3(("ListControl::SetParent parentListCriteria listType:%u, deviceID:%u, nowPlayingObjectID:%u, filterTag1:%u, filterTag2:%u, filterTag3:%u",
            parentListCriteria.listType, parentListCriteria.deviceID, parentListCriteria.nowPlayingObjectID, parentListCriteria.tag1.tag, parentListCriteria.tag2.tag, parentListCriteria.tag3.tag));

    /* lock the list table */
    mLock.lock();

    /* search for a parent list which uses same tags
     * remark: Do it in opposite order to get last created list */
    for(int i = mLists.size()-1; i>=0; i--) {
        if (mLists[i]->listID != LIST_ID_NONE) {

            if ((parentListCriteria.listType == mLists[i]->listType) &&
                    (parentListCriteria.streaming == mLists[i]->streaming) &&
                    (parentListCriteria.tag1.tag == mLists[i]->tag1.tag) &&
                    (parentListCriteria.tag2.tag == mLists[i]->tag2.tag) &&
                    (parentListCriteria.tag3.tag == mLists[i]->tag3.tag) &&
                    (parentListCriteria.tag4.tag == mLists[i]->tag4.tag) &&
                    (parentListCriteria.deviceID == mLists[i]->deviceID) &&
                    (parentListCriteria.isVTIPODList == mLists[i]->isVTIPODList)) {

                // found a parent
                listPtr->parent = mLists[i]->listID;

                /* unlock contexts */
                mLock.unlock();

                /* get his list pointer */
                tList *oldListPtrParent;
                GET_LIST_POINTER(OUT oldListPtrParent, IN listPtr->parent);
                if (!oldListPtrParent) return MP_ERR_LC_UNDEFINED_LIST_ID;

                /* set its next to the given list */
                oldListPtrParent->next = listPtr->listID;

                /* set nowPlaying object for highlighting */
                //Do it later when object is really playing via UpdateNowPlayingt and SetParentHighlighting
                //oldListPtrParent->nowPlayingObjectID = parentListCriteria.nowPlayingObjectID;

                ETG_TRACE_USR3(("ListControl::SetParent reused: listPtr->parent=%d, oldListPtrParent->listType=%d, oldListPtrParent->next=%d",
                        listPtr->parent, oldListPtrParent->listType, oldListPtrParent->next));

                /* find its parent */
                return SetParent(INOUT oldListPtrParent);
            }
        }
    }

    /* element not found */
    mLock.unlock();

    /* If child list is "noVTIPODList" make no check and set parent also to "noVTIPODList" (GMMY17-11263) */
    tBoolean checkVTIPOD = true;
    if (!listPtr->isVTIPODList) {
        checkVTIPOD = false;
    }

    /* no parent found: create one */
    /*res = */CreatePlayList(OUT listPtr->parent,
            IN parentListCriteria.listType,
            IN parentListCriteria.streaming,
            IN parentListCriteria.tag1,
            IN parentListCriteria.tag2,
            IN parentListCriteria.tag3,
            IN parentListCriteria.tag4,
            IN PC_STEPUP_ONE_LEVEL,
            IN parentListCriteria.deviceID,
            IN checkVTIPOD);

    /* get his list pointer */
    tList *newListPtrParent;
    GET_LIST_POINTER(OUT newListPtrParent, IN listPtr->parent);
    if (!newListPtrParent) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* set its next to the given list */
    newListPtrParent->next = listPtr->listID;

    /* set nowPlaying object for highlighting */
    //Do it later when object is really playing via UpdateNowPlayingt and SetParentHighlighting
    //newListPtrParent->nowPlayingObjectID = parentListCriteria.nowPlayingObjectID;

    ETG_TRACE_USR3(("ListControl::SetParent created new: listPtr->parent=%d, newListPtrParent->listType=%d, newListPtrParent->next=%d",
            listPtr->parent, newListPtrParent->listType, newListPtrParent->next));

    /* find its parent */
    return SetParent(INOUT newListPtrParent);
}

tResult ListControl::SetParentHighlighting(const tList *listPtr)
{
    ENTRY
    //tResult res;

    /* list has no parent */
    if (LIST_ID_NONE == listPtr->parent) {
        return MP_NO_ERROR;
    }

    /* get parent list ptr */
    tList *listPtrParent;
    GET_LIST_POINTER(OUT listPtrParent, IN listPtr->parent);
    if (!listPtrParent) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* figure out the parent list type */
    switch(listPtr->listType) {
        case LTY_GENRE_ARTIST:
        case LTY_GENRE_ALBUM:
        case LTY_GENRE_SONG:
            listPtrParent->nowPlayingObjectID = listPtr->tag1.genre;
            break;
        case LTY_YEAR_ALBUM:
            listPtrParent->nowPlayingObjectID = listPtr->tag1.yearID;
            break;
        case LTY_PODCAST_EPISODE:
            listPtrParent->nowPlayingObjectID = listPtr->tag1.podcast;
            break;
        case LTY_AUTHOR_BOOKTITLE:
            listPtrParent->nowPlayingObjectID = listPtr->tag1.author;
            break;
        case LTY_VIDEO_EPISODE:
            listPtrParent->nowPlayingObjectID = listPtr->tag1.video;
            break;
        case LTY_PLAYLIST_SONG:
        case LTY_FILELIST_PLAYLIST:
            listPtrParent->nowPlayingObjectID = listPtr->tag1.playlist;
            break;
        case LTY_GENRE_ARTIST_ALBUM:
        case LTY_GENRE_ARTIST_SONG:
        case LTY_ARTIST_ALBUM:
        case LTY_ARTIST_SONG:
            listPtrParent->nowPlayingObjectID = listPtr->tag2.artist;
            break;
        case LTY_BOOKTITLE_CHAPTER:
        case LTY_AUTHOR_BOOKTITLE_CHAPTER:
            listPtrParent->nowPlayingObjectID = listPtr->tag2.audiobook;
            break;
        case LTY_COMPOSER_ALBUM:
        case LTY_COMPOSER_SONG:
            listPtrParent->nowPlayingObjectID = listPtr->tag3.composer;
            break;
        case LTY_GENRE_ARTIST_ALBUM_SONG:
        case LTY_GENRE_ALBUM_SONG:
        case LTY_YEAR_ALBUM_SONG:
        case LTY_ARTIST_ALBUM_SONG:
        case LTY_ALBUM_SONG:
        case LTY_COMPOSER_ALBUM_SONG:
        case LTY_COMPILATION_SONG:
            listPtrParent->nowPlayingObjectID = listPtr->tag4.album;
            break;
        default:
            break;
    }

    ETG_TRACE_USR3(("ListControl::SetParentHighlighting listID:%u, listType:%u, parentListID:%u, nowPlayingObjectID:%u",
            listPtr->listID, listPtr->listType, listPtrParent->listID, listPtrParent->nowPlayingObjectID));

    return SetParentHighlighting(INOUT listPtrParent);
}

tResult ListControl::SetFileListHighlighting(const tList *listPtr)
{
    ENTRY
    tResult res;
    tPosition position;

    /* lock the list table */
    mLock.lock();

    /* search for parent file lists */
    for (tUInt i=0; i<mLists.size(); i++) {
        if ((mLists[i]->listID != LIST_ID_NONE)         //valid list
                &&
                (mLists[i]->listID != listPtr->listID)      //not the reference list
                &&
                (IsFileList(listPtr->listType))             //reference list is a file list
                &&
                (mLists[i]->deviceID == listPtr->deviceID)  //both lists are related to the same device
                &&
                //(IsFileList(mLists[i]->listType))         //list is a file list
                ((mLists[i]->listType == LTY_FILELIST) || (mLists[i]->listType == LTY_MTP_FILELIST) || (mLists[i]->listType == LTY_BROWSELIST))
                &&
                (strlen_r(mLists[i]->path) < strlen_r(listPtr->path))) { //path of list is shorter than path of reference list

            res = LocalSPM::GetDBManager().GetPositionInParentFileList(OUT position, IN mLists[i]->dbBrowseListID, IN listPtr->path);
            if ((MP_NO_ERROR == res) && (POSITION_NOT_SET != position))
            {
                mLists[i]->nowPlayingListPosition = position;
                ETG_TRACE_USR3(("ListControl::SetFileListHighlighting listID:%u, listType:%u, parentListID:%u, nowPlayingListPosition:%u",
                        listPtr->listID, listPtr->listType, mLists[i]->listID, mLists[i]->nowPlayingListPosition));
            }
        }
    }

    /* element not found */
    mLock.unlock();

    return MP_NO_ERROR;
}

tResult ListControl::ResetParentHighlighting(const tListID listID)
{
    ENTRY

    /* reset highlighting of indexed parent lists
     * remark: cannot disable all lists because new lists with INDEX_LAST_ACTIVE_OBJECT will be reset too */
    tList *listPtr0;
    GET_LIST_POINTER(OUT listPtr0, IN listID);
    if (listPtr0)
    {
        if(LIST_ID_NONE != listPtr0->parent)
        {
            tList *listPtr1;
            GET_LIST_POINTER(OUT listPtr1, IN listPtr0->parent);
            if (listPtr1)
            {
                /* reset highlighting of 1st parent list */
                listPtr1->nowPlayingObjectID = OBJECT_ID_NONE;
                listPtr1->nowPlayingListPosition = POSITION_NOT_SET;
                ETG_TRACE_USR3(("ListControl::ResetParentHighlighting 1st parent listID:%u, listType:%u", listPtr1->listID, listPtr1->listType));

                if(LIST_ID_NONE != listPtr1->parent)
                {
                    tList *listPtr2;
                    GET_LIST_POINTER(OUT listPtr2, IN listPtr1->parent);
                    if (listPtr2)
                    {
                        /* reset highlighting of 2nd parent list */
                        listPtr2->nowPlayingObjectID = OBJECT_ID_NONE;
                        listPtr2->nowPlayingListPosition = POSITION_NOT_SET;
                        ETG_TRACE_USR3(("ListControl::ResetParentHighlighting 2nd parent listID:%u, listType:%u", listPtr2->listID, listPtr2->listType));

                        if(LIST_ID_NONE != listPtr2->parent)
                        {
                            tList *listPtr3;
                            GET_LIST_POINTER(OUT listPtr3, IN listPtr2->parent);
                            if (listPtr3)
                            {
                                /* reset highlighting of 3rd parent list */
                                listPtr3->nowPlayingObjectID = OBJECT_ID_NONE;
                                listPtr3->nowPlayingListPosition = POSITION_NOT_SET;
                                ETG_TRACE_USR3(("ListControl::ResetParentHighlighting 3rd parent listID:%u, listType:%u", listPtr3->listID, listPtr3->listType));
                            }
                        }
                    }
                }
            }
        }
    }

    /* check all file lists */
    mLock.lock();
    for(tUInt i=0; i<mLists.size(); i++) {
        if ((mLists[i]->listID != LIST_ID_NONE)
                &&
                (IsFileList(mLists[i]->listType))) {

            /* reset nowPlaying object for highlighting */
            mLists[i]->nowPlayingObjectID = OBJECT_ID_NONE;
            mLists[i]->nowPlayingListPosition = POSITION_NOT_SET;
        }
    }
    mLock.unlock();

    return MP_NO_ERROR;
}

tResult ListControl::CreateMediaPlayerIndexedList(tListID &listID,
        tListSize &listSize,
        const tListType listType,
        const tStreaming streaming,
        const tFilterTag1 tag1,
        const tFilterTag2 tag2,
        const tFilterTag3 tag3,
        const tFilterTag4 tag4,
        const tDeviceID deviceID,
        const tUserID userID)
{
    ENTRY
    tResult res;

    /*create the playlist*/
    res = CreatePlayList(OUT listID,
            IN listType,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN PC_STEPUP_ONE_LEVEL,
            IN deviceID,
            IN true,
            IN NULL,
            IN userID);
    if (res) return res;

    /* get additional list size information */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    res = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN listPtr->dbBrowseListID);
    if (res) return res;

    VARTRACE(listSize);
    return MP_NO_ERROR;
}


tResult ListControl::CreateMediaPlayerIndexedListWithSearchString(OUT tListID &listID, //Roadmap 160014: 100%
        OUT tListSize         &listSize,
        OUT tDeviceID         &deviceID,
        IN const tListID       listIDParent,
        IN const tListID       listIDReplacable,
        IN const tSearchString searchString,
        IN tSearchIncrement    searchIncrement,
        IN tDelaySec           testDelaySec) //tbd. setup own type for this
{
    ENTRY
    tResult res = MP_NO_ERROR;
    tListInfo listInfoParent;
    tListType listTypeSearch;

    //---------------------------
    //delete  listIDReplacable first
    //---------------------------
    if(listIDReplacable != LIST_ID_NONE)
    {
        ETG_TRACE_USR4(("CreateMediaPlayerIndexedListWithSearchString: Start to Release listIDReplacable:%d",listIDReplacable));
        res = ReleaseList(listIDReplacable);
        if(MP_NO_ERROR != res)
        {
            ETG_TRACE_FATAL(("[ERROR] CreateMediaPlayerIndexedListWithSearchString: Could not replace list"));
            res = MP_ERR_LC_UNDEFINED_LIST_ID;
        }
    }

    //-----------------------------
    // check validity of search string
    //-----------------------------
    if(MP_NO_ERROR == res)
    {
        if(strlen_r(searchString)<1)   //tbd. add end of string at the very end again to care that strlen does not end with segementation fault
        {
            res = MP_ERR_LC_GENERAL_ERROR;
        }
    }

    if(MP_NO_ERROR == res)
    {
        //-------------------
        //get list type of parent
        //-------------------

        tBoolean withListSize = true;
        GetListInfo(OUT listInfoParent, IN listIDParent, IN withListSize);

        //----------------------------------------
        // and derive search type list from parent type
        //----------------------------------------
        /* information from feature owner what aivi needs

   (x) LTY_GENRE = 0UL,
   (x)    LTY_ARTIST = 1UL,
   (x)    LTY_ALBUM = 2UL,
   (x)    LTY_SONG = 3UL,
   (x)    LTY_GENRE_ARTIST = 4UL,
   (x)    LTY_GENRE_ARTIST_ALBUM = 5UL,
   (x)    LTY_GENRE_ARTIST_ALBUM_SONG = 6UL,
   (x)    LTY_GENRE_ARTIST_SONG = 7UL,
   (x)    LTY_GENRE_ALBUM = 8UL,
   (x)    LTY_GENRE_ALBUM_SONG = 9UL,
   (x)    LTY_GENRE_SONG = 10UL,
   (x)    LTY_ARTIST_ALBUM = 11UL,
   (x)    LTY_ARTIST_ALBUM_SONG = 12UL,
   (x)    LTY_ARTIST_SONG = 13UL,
   (x)    LTY_ALBUM_SONG = 14UL,
   (x)    LTY_PODCAST = 15UL,
   (x)    LTY_PODCAST_EPISODE = 16UL,
   (x)    LTY_AUDIOBOOK = 17UL,
   (x)    LTY_BOOKTITLE_CHAPTER = 18UL,

   (x)    LTY_COMPOSER = 22UL,
   (x)    LTY_COMPOSER_ALBUM = 23UL,
   (x)    LTY_COMPOSER_ALBUM_SONG = 24UL,
   (x)    LTY_COMPOSER_SONG = 25UL,
   (x)    LTY_VIDEO = 26UL,
   (x)    LTY_VIDEO_EPISODE = 27UL,
   (x)    LTY_PLAYLIST = 28UL,
   (x)    LTY_PLAYLIST_SONG = 29UL,

   (x)    LTY_IMAGE = 31UL,


   [blt2hi] Folderlisten mit
   (x)        FTS_VIDEO
   (x)        FTS_AUDIO_PLAYLIST
   (x)        FTS_IMAGE
         */
        switch(listInfoParent.listType)
        {
            case LTY_GENRE:
                listTypeSearch = LTY_GENRE_SEARCH;
                break;
            case LTY_ARTIST:
                listTypeSearch = LTY_ARTIST_SEARCH;
                break;
            case LTY_ALBUM:
                listTypeSearch = LTY_ALBUM_SEARCH;
                break;
            case LTY_SONG:
                listTypeSearch = LTY_SONG_SEARCH;
                break;
            case LTY_GENRE_ARTIST:
                listTypeSearch = LTY_GENRE_ARTIST_SEARCH;
                break;
            case LTY_GENRE_ARTIST_ALBUM:
                listTypeSearch = LTY_GENRE_ARTIST_ALBUM_SEARCH;
                break;
            case LTY_GENRE_ARTIST_ALBUM_SONG:
                listTypeSearch = LTY_GENRE_ARTIST_ALBUM_SONG_SEARCH;
                break;
            case LTY_GENRE_ARTIST_SONG:
                listTypeSearch = LTY_GENRE_ARTIST_SONG_SEARCH;
                break;
            case LTY_GENRE_ALBUM:
                listTypeSearch = LTY_GENRE_ALBUM_SEARCH;
                break;
            case LTY_GENRE_ALBUM_SONG:
                listTypeSearch = LTY_GENRE_ALBUM_SONG_SEARCH;
                break;
            case LTY_YEAR_ALBUM:
                listTypeSearch = LTY_YEAR_ALBUM_SEARCH;
                break;
            case LTY_YEAR_ALBUM_SONG:
                listTypeSearch = LTY_YEAR_ALBUM_SONG_SEARCH;
                break;
            case LTY_GENRE_SONG:
                listTypeSearch = LTY_GENRE_SONG_SEARCH;
                break;
            case LTY_ARTIST_ALBUM:
                listTypeSearch = LTY_ARTIST_ALBUM_SEARCH;
                break;
            case LTY_ARTIST_ALBUM_SONG:
                listTypeSearch = LTY_ARTIST_ALBUM_SONG_SEARCH;
                break;
            case LTY_ARTIST_SONG:
                listTypeSearch = LTY_ARTIST_SONG_SEARCH;
                break;
            case LTY_ALBUM_SONG:
                listTypeSearch = LTY_ALBUM_SONG_SEARCH;
                break;
            case LTY_PODCAST:
                listTypeSearch = LTY_PODCAST_SEARCH;
                break;
            case LTY_PODCAST_EPISODE:
                listTypeSearch = LTY_PODCAST_EPISODE_SEARCH;
                break;
            case LTY_AUDIOBOOK:
                listTypeSearch = LTY_AUDIOBOOK_SEARCH;
                break;
            case LTY_BOOKTITLE_CHAPTER:
                listTypeSearch = LTY_BOOKTITLE_CHAPTER_SEARCH;
                break;
            case LTY_AUTHOR:
                listTypeSearch = LTY_AUTHOR_SEARCH;
                break;
            case LTY_AUTHOR_BOOKTITLE:
                listTypeSearch = LTY_AUTHOR_BOOKTITLE_SEARCH;
                break;
            case LTY_AUTHOR_BOOKTITLE_CHAPTER:
                listTypeSearch = LTY_AUTHOR_BOOKTITLE_CHAPTER_SEARCH;
                break;
            case LTY_COMPOSER:
                listTypeSearch = LTY_COMPOSER_SEARCH;
                break;
            case LTY_COMPOSER_ALBUM:
                listTypeSearch = LTY_COMPOSER_ALBUM_SEARCH;
                break;
            case LTY_COMPOSER_ALBUM_SONG:
                listTypeSearch = LTY_COMPOSER_ALBUM_SONG_SEARCH;
                break;
            case LTY_COMPOSER_SONG:
                listTypeSearch = LTY_COMPOSER_SONG_SEARCH;
                break;
            case LTY_VIDEO:
                listTypeSearch = LTY_VIDEO_SEARCH;
                break;
            case LTY_VIDEO_EPISODE:
                listTypeSearch = LTY_VIDEO_EPISODE_SEARCH;
                break;
            case LTY_PLAYLIST:
                listTypeSearch = LTY_PLAYLIST_SEARCH;
                break;
            case LTY_PLAYLIST_SONG:
                listTypeSearch = LTY_PLAYLIST_SONG_SEARCH;
                break;
            case LTY_IMAGE:
                listTypeSearch = LTY_IMAGE_SEARCH;
                break;
            case LTY_PLAYLIST_INTERNAL: //askRoadmap160014
                listTypeSearch = LTY_PLAYLIST_INTERNAL_SEARCH;
                break;
            case LTY_EPISODE_OF_VIDEO:
                listTypeSearch = LTY_EPISODE_OF_VIDEO_SEARCH;
                break;
            case LTY_COMPILATION:
                listTypeSearch = LTY_COMPILATION_SEARCH;
                break;
            case LTY_COMPILATION_SONG:
                listTypeSearch = LTY_COMPILATION_SONG_SEARCH;
                break;
            case LTY_USER_FAVORITES_SONG:
                listTypeSearch = LTY_USER_FAVORITES_SONG_SEARCH;
                break;

            //==not fts for these parent lists ==
            case LTY_IMAGE_FOLDER://askRoadmap160014
            case LTY_IMAGE_FOLDER_ITEM://askRoadmap160014
            case LTY_CD://askRoadmap160014
            case LTY_CURRENT_SELECTION:
                ETG_TRACE_FATAL(("CreateMediaPlayerIndexedListWithSearchString: Not supported for this parent ListType:%d",ETG_CENUM(tListType,listInfoParent.listType)));
            default:
                res = MP_ERR_LC_NOT_IMPLEMENTED_LIST_TYPE;
                break;

        }
    }


    if(MP_NO_ERROR == res)
    {
        tSearchString adjustedSearchString;

        snprintf(adjustedSearchString,sizeof(tSearchString),"%c%s%c",'%',searchString,'%'); // additional param Roadmap 160014
        ETG_TRACE_USR3(("ListControl::CreateMediaPlayerIndexedListWithSearchString adjustedSearchString:%s",adjustedSearchString));

        tUserID userID = 0;
        if ((LocalSPM::GetDataProvider().PersonalizationSupported()) && IsUserFavoriteList(listInfoParent.listType))
        {
            res = LocalSPM::GetDBManager().GetCurrentUser(IN userID);
            ETG_TRACE_USR2(("ListControl::CreateMediaPlayerIndexedListWithSearchString Favorites list userID : %d",userID));
        }


        //------------------
        //create the playlist
        //-----------------
        res = CreatePlayList(OUT listID,
                IN listTypeSearch,
                IN listInfoParent.streaming,
                IN listInfoParent.filterTag1,
                IN listInfoParent.filterTag2,
                IN listInfoParent.filterTag3,
                IN listInfoParent.filterTag4,
                IN PC_STEPUP_ONE_LEVEL,
                IN listInfoParent.deviceID,
                IN /*tBoolean checkVTIPOD =*/ true, //default as usal
                IN adjustedSearchString,
                IN userID);
    }
    ETG_TRACE_USR3(("ListControl::CreateMediaPlayerIndexedListWithSearchString CreatePlayList OUT listID:%d",listID));

    //------------------
    //get size of list
    //-----------------
    if(MP_NO_ERROR == res)
    {
        //add to vector which holds all lists bound to parallel thread based search - to ease clean of correspodning thread if list should be released
        tBool bFound = FALSE;
        for (std::vector<tListID>::iterator it = listIDsOfFullTextSearch.begin() ; it != listIDsOfFullTextSearch.end(); ++it)
        {
            if(*it == listID)
            {
                bFound = TRUE;
                ETG_TRACE_FATAL(("[ERROR] CreateMediaPlayerIndexedListWithSearchString: listID: %d always in list",listID));
            }
        }
        if(!bFound)
        {
            listIDsOfFullTextSearch.push_back(listID);
        }


        /* get additional list size information */
        tList *listPtr;
        GET_LIST_POINTER(OUT listPtr, IN listID);
        if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

        //res = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN listPtr->dbBrowseListID);
        res = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN listPtr->dbBrowseListID,1); //this is to searchone element only if nothing is found then listSize=0 is expected
        deviceID = listInfoParent.deviceID; //now all out-parameters listID, listSize, deviceID are set correctly

        /* start thread*/
        ThreadFctFullTextSearchStart(IN listIDParent, IN listID,IN listSize,IN deviceID, IN searchIncrement, IN testDelaySec); //thread sends first, middle and last method return

    }

    VARTRACE(listSize);
    return res;

}


/*
 * finds now playing object's ID in the context of given list type
 * e.g.ID of a now playing album if list type is LTY_GENRE_ALBUM
 *     (album to which currently playing song belongs to)
 * similarly ID of a now playing artist if list type is LTY_ARTIST etc
 */
#if 0
Not used yet but maybe in future.
tResult ListControl::GetNowPlayingObjectID(tObjectID &nowPlayingObjectID, const tListID listID)
{
    ENTRY
    tResult res;

    if (LIST_ID_NONE == listID) return MP_ERR_LC_GENERAL_ERROR;

    tNowPlaying nowPlaying;
    res = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
    if (res) return res;

    tMediaObject mediaObject = nowPlaying.object;
    nowPlayingObjectID = OBJECT_ID_NONE;

    /* In case of no nowPlaying available return without error */
    if((OBJECT_ID_NONE == mediaObject.objectID)
            ||
            (LIST_ID_NONE == nowPlaying.listID))
    {
        return MP_NO_ERROR;
    }

    /*
     * filter the highlighting after current playing list type, for example:
     * if current list type is LTY_ARTIST_SONG, mark only the corresponding artist and song as playing, NOT all other tags
     */
    tListInfo listInfo;
    tBoolean withListSize = false;
    res = GetListInfo(OUT listInfo , IN nowPlaying.listID, IN withListSize);
    if (res) return res;

    ETG_TRACE_USR2(("nowPlaying listtype=%d", listInfo.listType));

    switch(listInfo.listType) {
        case LTY_SONG:
        case LTY_PODCAST:
        case LTY_AUDIOBOOK:
        case LTY_VIDEO:
        case LTY_PLAYLIST:
        case LTY_EPISODE_OF_VIDEO:
            mediaObject.MetadataTag1 = 0;
            mediaObject.MetadataTag2 = 0;
            mediaObject.MetadataTag3 = 0;
            mediaObject.MetadataTag4 = 0;
            break;
        case LTY_COMPOSER_SONG:
            mediaObject.MetadataTag1 = 0;
            mediaObject.MetadataTag2 = 0;
            mediaObject.MetadataTag4 = 0;
            break;
        case LTY_COMPOSER_ALBUM_SONG:
            mediaObject.MetadataTag1 = 0;
            mediaObject.MetadataTag2 = 0;
            break;
        case LTY_GENRE_SONG:
        case LTY_PODCAST_EPISODE:
        case LTY_VIDEO_EPISODE:
        case LTY_PLAYLIST_SONG:
            mediaObject.MetadataTag2 = 0;
            mediaObject.MetadataTag3 = 0;
            mediaObject.MetadataTag4 = 0;
            break;
        case LTY_GENRE_ARTIST_SONG:
        case LTY_AUTHOR_BOOKTITLE_CHAPTER:
            mediaObject.MetadataTag3 = 0;
            mediaObject.MetadataTag4 = 0;
            break;
        case LTY_GENRE_ARTIST_ALBUM_SONG:
            mediaObject.MetadataTag3 = 0;
            break;
        case LTY_GENRE_ALBUM_SONG:
            mediaObject.MetadataTag2 = 0;
            mediaObject.MetadataTag3 = 0;
            break;
        case LTY_ARTIST_SONG:
        case LTY_BOOKTITLE_CHAPTER:
            mediaObject.MetadataTag1 = 0;
            mediaObject.MetadataTag3 = 0;
            mediaObject.MetadataTag4 = 0;
            break;
        case LTY_ARTIST_ALBUM_SONG:
            mediaObject.MetadataTag1 = 0;
            mediaObject.MetadataTag3 = 0;
            break;
        case LTY_ALBUM_SONG:
        case LTY_COMPILATION_SONG:
            mediaObject.MetadataTag1 = 0;
            mediaObject.MetadataTag2 = 0;
            mediaObject.MetadataTag3 = 0;
            break;
        case LTY_CURRENT_SELECTION:
        case LTY_FILELIST:
        case LTY_BROWSELIST:
            break; //nothing to do
        default:
            ETG_TRACE_ERR(("PlayerManager plays a NON-playable list: type=%d", listInfo.listType));
            break;
    }

    /* get the needed object id for now playing highlight after the displayed list type */
    res = GetListInfo(OUT listInfo, IN listID, IN withListSize);
    if (res) return res;

    ETG_TRACE_USR2(("browse listtype=%d", listInfo.listType));

    switch(listInfo.listType)
    {
        case LTY_GENRE:
        case LTY_VIDEO:
        case LTY_PODCAST:
        case LTY_PLAYLIST:
        case LTY_AUTHOR:
            nowPlayingObjectID = mediaObject.MetadataTag1;
            break;
        case LTY_ARTIST:
        case LTY_GENRE_ARTIST:
        case LTY_AUDIOBOOK:
        case LTY_AUTHOR_BOOKTITLE:
            nowPlayingObjectID = mediaObject.MetadataTag2;
            break;
        case LTY_COMPOSER:
            nowPlayingObjectID = mediaObject.MetadataTag3;
            break;
        case LTY_ALBUM:
        case LTY_ALBUM_UNKNOWN_ALBUMART:
        case LTY_GENRE_ARTIST_ALBUM:
        case LTY_GENRE_ALBUM:
        case LTY_ARTIST_ALBUM:
        case LTY_COMPOSER_ALBUM:
        case LTY_COMPILATION:
            nowPlayingObjectID = mediaObject.MetadataTag4;
            break;
        default:
            nowPlayingObjectID = mediaObject.objectID;
            break;
    }

    ETG_TRACE_USR2(("nowPlayingObjectID=%d", nowPlayingObjectID));

    return MP_NO_ERROR;
}
#endif

#define PERF_MEAS 1

tResult ListControl::RequestMediaPlayerIndexedListSlice(vector<tMediaObject> &mediaObjectVector,
        const tListID listID,
        const tIndex startIndex,
        const tIndex sliceSize)
{
    //TODO: missing video and audiobook
    ENTRY
    tResult res = MP_NO_ERROR;

    if(INDEX_NONE == startIndex) return MP_ERR_LC_UNDEFINED_INDEX;
    if(INDEX_NONE == sliceSize) return MP_ERR_LC_UNDEFINED_INDEX;

#if PERF_MEAS
    TimeTrace ticks("RequestMediaPlayerIndexedListSlice");
#endif

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* reset the output vector */
    mediaObjectVector.clear();

    /* loop over slice */
    res = LocalSPM::GetDBManager().StartListAccess(IN listPtr->dbBrowseListID, IN startIndex, IN sliceSize);
    if (res) return res;

    for(tUInt index = startIndex; index < (startIndex + sliceSize); index++)
    {
        /* fill one media object */
        tMediaObject mediaObject;
#if PERF_MEAS
        ticks.restart();
#endif
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listPtr->dbBrowseListID, IN index);
#if PERF_MEAS
        ticks.elapsed();
#endif
        if (res) break; // no more entries found

        /* is it the currently played object? */
        //ETG_TRACE_USR3(("ListControl::RequestMediaPlayerIndexedListSlice: mediaObject.objectID=%d ?= listPtr->nowPlayingObjectID=%d",
        //        mediaObject.objectID, listPtr->nowPlayingObjectID));
        if (mediaObject.objectID == listPtr->nowPlayingObjectID)
        {
            mediaObject.isPlaying = 1;
        }

        /* Map file type to FOLDER because element is an image object, which is interpreted as folder */
        if (LTY_IMAGE_FOLDER == listPtr->listType)
        {
            mediaObject.catType = CTY_DIR;
            mediaObject.fileType = FT_FOLDER;
            mediaObject.fileFormat = FFT_UNKNOWN;
        }
        //fill the yomi data for musicbox device
        if((LocalSPM::GetDataProvider().YomiMetadataSupport()) && (MUSICBOX_DEVICE_ID == mediaObject.deviceID) )
        {
            if  (CTY_SONG == mediaObject.catType)
            {
                ETG_TRACE_USR3(("RequestMediaPlayerIndexedListSlice trying the yomi data from Database"));
                tYomiMetadata yomiMetadata;
                if(MP_NO_ERROR == LocalSPM::GetDBManager().GetYomiMetadata(IN mediaObject.objectID, OUT yomiMetadata))
                {
                    ETG_TRACE_USR3(("RequestMediaPlayerIndexedListSlice Filling the yomi data from Database"));
                    strncpy_r(mediaObject.YomiTitle,yomiMetadata.YomiTitle,sizeof(tMetadata));
                    strncpy_r(mediaObject.YomiArtist,yomiMetadata.YomiArtist,sizeof(tMetadata));
                    strncpy_r(mediaObject.YomiAlbum,yomiMetadata.YomiAlbum,sizeof(tMetadata));
                    VARTRACE(yomiMetadata);
                }
                else
                {
                    ETG_TRACE_USR3(("RequestMediaPlayerIndexedListSlice Fetching the yomi data from Database got failed"));
                }
            }
            else if(CTY_ALBUM ==  mediaObject.catType)
            {
                ETG_TRACE_USR3(("RequestMediaPlayerIndexedListSlice trying the yomi album data from Database"));
                tMetadata yomiAlbum;
                if(MP_NO_ERROR == LocalSPM::GetDBManager().GetYomiAlbumNameForAlbumId(mediaObject.objectID , yomiAlbum) )
                {
                    ETG_TRACE_USR3(("RequestMediaPlayerIndexedListSlice Filling the yomi ALBUM data from Database"));
                    strncpy_r(mediaObject.YomiAlbum,yomiAlbum,sizeof(yomiAlbum));
                }
                else
                {
                    ETG_TRACE_USR3(("RequestMediaPlayerIndexedListSlice Fetching the yomi ALBUM data from Database got failed"));
                }
            }

        }
        /* add it to the vector */
        mediaObjectVector.push_back(mediaObject);
    }

    /* finalize the list access */
    LocalSPM::GetDBManager().EndListAccess(IN listPtr->dbBrowseListID);

    return MP_NO_ERROR;
}

tResult ListControl::RequestMediaPlayerIndexedUUIDListSlice(tBatchPlaybackList *batchPlaybackListPtr,
        const tListID listID,
        const tIndex startIndex,
        const tIndex sliceSize)
{
    //TODO: missing video and audiobook
    ENTRY
    tResult res;

    if(INDEX_NONE == startIndex) return MP_ERR_LC_UNDEFINED_INDEX;
    if(INDEX_NONE == sliceSize) return MP_ERR_LC_UNDEFINED_INDEX;

#if PERF_MEAS
    TimeTrace        ticks("RequestMediaPlayerIndexedListSlice");
#endif

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* reset the output vector */
    batchPlaybackListPtr->clear();

    /* loop over slice */
    res = LocalSPM::GetDBManager().StartListAccess(IN listPtr->dbBrowseListID, IN startIndex, IN sliceSize);
    if (res) return res;

    for(tUInt index = startIndex; index < (startIndex + sliceSize); index++)
    {
        /* fill one media object */
        tMediaObject mediaObject;
#if PERF_MEAS
        ticks.restart();
#endif
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listPtr->dbBrowseListID, IN index, IN 1 /* uuidOnly */);
#if PERF_MEAS
        ticks.elapsed();
#endif
        if (res) break; // no more entries found

        /* add only the UUID to the vector */
        tU64 uuid = 0ULL;
        uuid = (tU64)strtoull((char *)mediaObject.UUID, NULL, 16);
        batchPlaybackListPtr->push_back(uuid);
    }

    /* finalize the list access */
    LocalSPM::GetDBManager().EndListAccess(IN listPtr->dbBrowseListID);

    return MP_NO_ERROR;
}




tResult ListControl::CreateShuffleTable(tList *listObject)
{
    ENTRY

    tResult res = MP_NO_ERROR;

    if(NULL == listObject)
    {
        ETG_TRACE_ERR(("CreateShuffleTable:Given Listpointer is NULL"));
        return res; //TODO:check is failure errorcode be sent
    }

    //Params needed to prepare ShuffleTable attributes
    tListSize listSize = tListSize_init;
    tNumberOfMediaObjects numberOfMediaObjects = tNumberOfMediaObjects_init;
    tNumberOfPlayLists numberOfPlayLists = tNumberOfMediaObjects_init;
    tNumberOfFolders numberOfFolders = tNumberOfMediaObjects_init;

    if(LTY_BLUETOOTH_FILELIST == listObject->listType) return MP_NO_ERROR;

    /* get the current list size */
    if((LTY_FILELIST_MEDIAOBJECTS == listObject->listType)|| (LTY_BROWSELIST_MEDIAOBJECTS == listObject->listType))
    {
        res = LocalSPM::GetDBManager().GetFileListSize(OUT listSize, OUT numberOfMediaObjects, OUT numberOfPlayLists, OUT numberOfFolders, IN listObject->dbBrowseListID);
    }
    else
    {
        res = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN listObject->dbBrowseListID);
    }

    if (res)
    {
        //ETG_TRACE_ERR(("Cannot shuffle listID: %d, dbBrowseListID: %d", listObject->listID, listObject->dbBrowseListID));
        return res;
    }

    ETG_TRACE_USR4(("CreateShuffleTable:LTY:%d listSize:%d",ETG_CENUM(tListType,listObject->listType),listSize));
    ETG_TRACE_USR4(("CreateShuffleTable:files:%d folders:%d playlists:%d",numberOfMediaObjects,numberOfFolders,numberOfPlayLists));

    /* size has changed? */
    if (listSize != listObject->sizeOfShuffleTable) {

        /* create a new shuffleSkippingStack if it shall be used (sizeOfShuffleSkippingStack > 0) */
        if (listObject->sizeOfShuffleSkippingStack > 0) {

            /* realloc shuffleSkippingStack */
            if (listObject->shuffleSkippingStack) free(listObject->shuffleSkippingStack);
            listObject->shuffleSkippingStack = (tIndex *)malloc(sizeof(tIndex) * listObject->sizeOfShuffleSkippingStack);
            if (!listObject->shuffleSkippingStack) return -1; // malloc failed

            /* initialize with value sizeOfShuffleSkippingStack */
            for(tUInt i=0; i<listObject->sizeOfShuffleSkippingStack; i++) {
                listObject->shuffleSkippingStack[i] = listObject->sizeOfShuffleTable;
            }
        }

        /* Freeup shuffle table and its attributes*/
        if (listObject->shuffleTable)
        {
            free(listObject->shuffleTable);
            listObject->shuffleTable = NULL;

            listObject->sizeOfShuffleTable = tListSize_init;
            listObject->shuffleTableAttributes.numberOfMediaObjects = tNumberOfMediaObjects_init;
            listObject->shuffleTableAttributes.numberOfFolders = tNumberOfMediaObjects_init;
            listObject->shuffleTableAttributes.numberOfPlayLists = tNumberOfMediaObjects_init;
        }

        if(listSize)
        {
            //create a new table and and store its attributes
            listObject->shuffleTable = (tIndex *)malloc(sizeof(tIndex) * listSize);
            if (!listObject->shuffleTable) return -1;

            listObject->sizeOfShuffleTable = listSize;
            listObject->shuffleTableAttributes.numberOfMediaObjects = numberOfMediaObjects;
            listObject->shuffleTableAttributes.numberOfFolders = numberOfFolders;
            listObject->shuffleTableAttributes.numberOfPlayLists = numberOfPlayLists;

            tUInt i;
            /* fill shuffle table with all possible numbers */
            for(i=0; i<listObject->sizeOfShuffleTable; i++) {
                listObject->shuffleTable[i] = i;
            }

            /* shuffle this table now */
            res = ReshuffleShuffleTable(INOUT listObject);
            if (res)
            {
                //ETG_TRACE_ERR(("Cannot shuffle listID: %d, dbBrowseListID: %d", listObject->listID, listObject->dbBrowseListID));
                return res;
            }
        }
        else
        {
            ETG_TRACE_ERR(("Current ListSize is zero.Cannot create ShuffleTable"));
            //TODO:set listObject->isInShuffleMode to 0
        }
    }
    listObject->isInShuffleMode = 1;

    return MP_NO_ERROR;
}

tResult ListControl::ReshuffleShuffleTable(tList *listObject,const tIndex beginIndex /* = INDEX_NONE */)
{
    ENTRY;

    tResult res = MP_NO_ERROR;

    //TODO:If there is error,better send res != MP_NO_ERROR hence the List will not be set as in "shuffleMode"

    if((NULL == listObject) || (NULL == listObject->shuffleTable) || !(listObject->sizeOfShuffleTable))
    {
        ETG_TRACE_ERR(("one or more invalid params given.ReshuffleShuffleTable cannot be done"));
        return res; //TODO:check is failure errorcode be sent
    }
    ETG_TRACE_USR4(("Params:listObject:%p listObject->shuffleTable:%p listObject->sizeOfShuffleTable:%d",listObject,
            listObject->shuffleTable,
            listObject->sizeOfShuffleTable));

    //In general,it is expected the all table entries need shuffling.
    tListSize sizeOfShuffleTableToShuffle = listObject->sizeOfShuffleTable;

    //For LTY_FILELIST_MEDIAOBJECTS or LTY_BROWSELIST_MEDIAOBJECTS all table entries except folder entries need shuffling.
    /* If listType is LTY_FILELIST_MEDIAOBJECTS or LTY_BROWSELIST_MEDIAOBJECTS,
     * The possible items types in the list and their order : 1.Audio file,2.Video file,3.Folders
     * So only the Audio file,Video file should be shuffled.Folders are kept at the end of the List unshuffled
     * To acheive this,truncated shuffle table is subjected to shuffling
     *
     * For FileList Type:LTY_BROWSELIST,It is possible to have Folders.
     * Need to check possibility of LTY_BROWSELIST becoming NowPlayingList in RPT_ALL_LIST mode.
     * Keeping the Folders unshuffled at End of shuffle table is to serve playback in RPT_ALL_LIST.
     */
    if((LTY_FILELIST_MEDIAOBJECTS == listObject->listType)||(LTY_BROWSELIST_MEDIAOBJECTS == listObject->listType))
    {
        if(listObject->sizeOfShuffleTable != ((listObject->shuffleTableAttributes.numberOfFolders) + (listObject->shuffleTableAttributes.numberOfMediaObjects)))
        {
            ETG_TRACE_ERR(("Invalid shuffleTableAttributes.TableSize!=(FolderCount+MediaObjectsCount).Shuffling not done"));
            ETG_TRACE_ERR(("ShuffleTableAttributes: TableSize:%d FolderCount:%d MediaObjectsCount:%d",listObject->sizeOfShuffleTable,
                    (listObject->shuffleTableAttributes.numberOfFolders),
                    (listObject->shuffleTableAttributes.numberOfMediaObjects)));

            //the Shuffle table size is not as expected.Hence,donot shuffle
            sizeOfShuffleTableToShuffle = tListSize_init;
        }
        else
        {
            sizeOfShuffleTableToShuffle = (listObject->shuffleTableAttributes.numberOfMediaObjects);
        }
    }

    if(sizeOfShuffleTableToShuffle)
    {
        //Back up original sizeOfShuffleTable and update it with size of table ToShuffle
        tListSize originalShuffleTableSize = listObject->sizeOfShuffleTable;
        listObject->sizeOfShuffleTable = sizeOfShuffleTableToShuffle;

        ETG_TRACE_USR4(("ShuffleTable size: Total:%d ToShuffle:%d",originalShuffleTableSize,listObject->sizeOfShuffleTable));

        tBoolean isRetryNeeded  = true;

        //Allocate memory to copy the current shuffle table - to use for comarison against shuffle result
        tIndex* oldShuffleTable = (tIndex *)malloc(sizeof(tIndex) * (listObject->sizeOfShuffleTable));
        if (NULL == oldShuffleTable)
        {
            //Cannot copy the current shuffle table.Hence,cannot campare new shuffle table is different from current shuffle table.Hence no retry needed!
            isRetryNeeded = false;
        }

        tUInt retryCount = 0;
        tListSize i = tListSize_init;
        do
        {
            if(oldShuffleTable)
            {
                //copy the old shuffleTable
                for(i=0 ;i<listObject->sizeOfShuffleTable; i++) {
                    oldShuffleTable[i] =  listObject->shuffleTable[i];
                }
            }

            //If RetryCount reached the count at which new input table need to  be shuffled ,provide it
            if(retryCount >= NEW_INPUT_TABLE_FOR_SHUFFLING)
            {
                /* fill shuffle table with all possible numbers */
                for(i=0; i<listObject->sizeOfShuffleTable; i++) {
                    listObject->shuffleTable[i] = i;
                }
            }

            tUInt i;
            tIndex swap;
            /* Step 1: Rearrange the index numbers in the shuffle table */
            for(i=0; i<listObject->sizeOfShuffleTable; i++) {
                /* e.g is sizeOfShuffleTable is 6,shuffletable = {0,1,2,3,4,5}
                * for i =0 ,then prevIndex = 5;Else,prevIndex = i -1
                * fromIndex = any 0 till 5
                * Thus diff of items prevIndex,fromIndex in shuffleTable
                * e.g Diff of item at prevIndex = 5 and fromIndex=4 is 1.so continue finding new position
                * Diff of item at prevIndex = 5 and fromIndex=3 is 2.so loop ends.
                * Now item at index:0 "0" is swapped with item at index:3 "3"
                */
                tUInt fromIndex;
                tUInt prevIndex;

                /* calc the previous index to compare the shuffle result with */
                if (!i) {
                    prevIndex = listObject->sizeOfShuffleTable-1;
                }else {
                    prevIndex = i-1;
                }

                do {
                    /* calc a random index in the list */
                    fromIndex = rand() % (int)listObject->sizeOfShuffleTable;

                    /* do this as long as there is no direct neighbor found */
                } while(ABS((int)(listObject->shuffleTable[fromIndex]) - (int)(listObject->shuffleTable[prevIndex])) < 2 &&
                        listObject->sizeOfShuffleTable > 3);

                /* exchange two numbers in the list */
                swap = listObject->shuffleTable[i];
                listObject->shuffleTable[i] = listObject->shuffleTable[fromIndex];
                listObject->shuffleTable[fromIndex] = swap;
            }
            // Step 2: setup given IndexNumber as the first item in shuffletable
            res = SetupFirstRowInShuffleTable(INOUT listObject,IN beginIndex);

            //Step 3: Ensure there is no consecutive IndexNumbers in shuffleTable
            res = SetupUnConsecutiveNumbersInShuffleTable(INOUT listObject);

            /* create a new shuffleSkippingStack if it shall be used (sizeOfShuffleSkippingStack > 0) */
            res = ReInitShuffleSkippingStack(INOUT listObject);

            tBoolean isSame = false;
            if(oldShuffleTable) isSame = CompareShuffleTables(IN oldShuffleTable,IN listObject->shuffleTable,IN listObject->sizeOfShuffleTable);

            if(isSame)
            {
                ETG_TRACE_USR4(("oldShuffleTable == NewShuffleTable"));
                if(retryCount)
                {
                    ETG_TRACE_USR4(("%d Retrial done till now ",retryCount));
                }
                retryCount++;
            }
            else
            {
                ETG_TRACE_USR4(("New ShuffleTable different from oldShuffleTable Found!"));
                break;
            }
        }while(isRetryNeeded && (retryCount <= NEW_SHUFFLE_TABLE_RETRY_LIMIT));


        for(i= listObject->sizeOfShuffleTable;i< originalShuffleTableSize;i++)
        {
            listObject->shuffleTable[i] = i;
        }

        listObject->sizeOfShuffleTable = originalShuffleTableSize;

        if(oldShuffleTable)
        {
            free(oldShuffleTable);
        }
    }
    else
    {
        ETG_TRACE_USR4(("sizeOfShuffleTableToShuffle is zero.Shuffling not needed"));
    }
    return res;
}

tResult ListControl::ReInitShuffleSkippingStack(const tList *listObject)
{
    ENTRY_INTERNAL;

    //TODO:Add logic to avoid shuffling the FolderItems in the ListTypes: LTY_FILELIST_MEDIAOBJECTS and LTY_BROWSELIST_MEDIAOBJECTS
    /* reInitialize the shuffleSkippingStack if it shall be used (sizeOfShuffleSkippingStack > 0) */
    if (listObject->sizeOfShuffleSkippingStack > 0) {
        /* initialize with value sizeOfShuffleSkippingStack */
        for(tUInt i=0; i<listObject->sizeOfShuffleSkippingStack; i++) {
            listObject->shuffleSkippingStack[i] = listObject->sizeOfShuffleTable;
        }
        if (!listObject->shuffleSkippingStack) return -1;
    }

    return MP_NO_ERROR;
}

tResult ListControl::ReshuffleShuffleTable(const tListID listID,const tIndex beginIndex)
{
    ENTRY
    tResult res = MP_NO_ERROR;

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (listPtr)
    {
        if (listPtr->isInShuffleMode && listPtr->shuffleTable)
        {
            res = ReshuffleShuffleTable(INOUT listPtr,IN beginIndex);
        }
    }
    else
    {
        res = MP_ERR_LC_UNDEFINED_LIST_ID;
    }

   return res;
}
tResult ListControl::SetupFirstRowInShuffleTable(tList* listObject, const tIndex beginIndex)
{
    ENTRY;

    VARTRACE(beginIndex);

    tResult res = MP_NO_ERROR;
    tIndex i;
    tIndex swap;
    tIndex localBeginIndex = beginIndex;
    tRowNumber newRow = ROW_NUMBER_NONE;
    if(NULL == listObject)
    {
        ETG_TRACE_ERR(("SetupFirstRowInShuffleTable:Given List Pointer is NULL"));
        return res; //TODO:check is failure errorcode be sent
    }

    if(localBeginIndex == POSITION_NOT_SET)/*POSITION_NOT_SET and INDEX_LAST_ACTIVE_OBJECT same i.e -1*/
    {
        /* get the current row */
        res = LocalSPM::GetDBManager().GetCurrentRow(OUT newRow, IN listObject->dbBrowseListID); //? - Wont it return a row which is beyond size of shuffle table?
        if (res)
        {
            localBeginIndex = tIndex_init;
        }
        else
        {
            localBeginIndex = newRow ;
        }
    }

    VARTRACE(localBeginIndex);
    if(localBeginIndex != INDEX_NONE) /* != -2 */
    {
        if(listObject)
        {
            /*If the interested index is found in shuffle table,then swap the index postion with the first entryl in shuffle table.
             * If the interested index is NOT found in shuffle table - do nothing!
             */
            for(i=0; i<listObject->sizeOfShuffleTable; i++) {
                if (localBeginIndex == listObject->shuffleTable[i]) {
                    if(i) {
                        swap = listObject->shuffleTable[i];
                        listObject->shuffleTable[i] = listObject->shuffleTable[0];
                        listObject->shuffleTable[0] = swap;
                    }
                    ETG_TRACE_USR4(("SetupFirstRowInShuffleTable done.RowNumber at top:%d",listObject->shuffleTable[0]));
                    break;
                }
            }
            if(i == listObject->sizeOfShuffleTable)
            {
                ETG_TRACE_ERR(("Given rownumber:%d doesnt exist in shuffle table of size:%d",localBeginIndex,listObject->sizeOfShuffleTable));
            }
        }
    }
    return res;
}
tResult ListControl::SetupUnConsecutiveNumbersInShuffleTable(tList* listObject)
{
   ENTRY;

   tResult res = MP_NO_ERROR;
   if(listObject) {
      if(listObject->sizeOfShuffleTable >= MIN_TABLE_SIZE_TO_CHECK_SEQ)  //sizeOfShuffleTable is atleast 3.
      {
        tIndex lastIndexToVerify = (listObject->sizeOfShuffleTable)-2;// i.e If ShuffleTable has 5 entries.Then first 4 entries {i.e items at index:0 till 3} are verified as there is no next item for the last entry in shuffle table
        tIndex currentIndex;
        tIndex nextIndex;

        tIndex CurrItem;
        tIndex consecutiveItemForCurrItem;
        tIndex swap;

        for(currentIndex =0; currentIndex <= lastIndexToVerify ; currentIndex++) //If shuffleTable size is 5,only first 4 entries in table are checked!?
        {
          CurrItem = listObject->shuffleTable[currentIndex];

          consecutiveItemForCurrItem =  CurrItem+1;
          nextIndex = currentIndex + 1;

          if(consecutiveItemForCurrItem  == listObject->shuffleTable[nextIndex])
          {
            if(currentIndex)
            {
               swap = listObject->shuffleTable[currentIndex];
               listObject->shuffleTable[currentIndex] = listObject->shuffleTable[nextIndex];
               listObject->shuffleTable[nextIndex] = swap;
            }
            else //i.e shuffle table entries at positions:0,1 are consecutive
            {
               tIndex secondNextIndex = nextIndex+1;

               swap = listObject->shuffleTable[nextIndex];
               listObject->shuffleTable[nextIndex] = listObject->shuffleTable[secondNextIndex];
               listObject->shuffleTable[secondNextIndex] = swap;
            }
          }
        }
      }
   }
   return res;
}

tBoolean ListControl::CompareShuffleTables(const tIndex* oldShuffleTable,const tIndex* newShuffleTable,const tListSize size)
{
    ENTRY;

    tListSize i;
    tBoolean isSame = true;

    if(NULL == oldShuffleTable || NULL == newShuffleTable){
        isSame = false;
    }
    else
    {
        for(i= 0; i<size; i++)  //confirm new shuffleTable is different from old shuffleTable
        {
            if(oldShuffleTable[i] !=  newShuffleTable[i])
            {
                isSame = false;
                break;
            }
        }
#if 0
        for(i=0; i<size; i++)
        {
            ETG_TRACE_USR4(("oldShuffleTable[%d]:%d",i,oldShuffleTable[i]));
        }

        for(i=0; i<size; i++)
        {
            ETG_TRACE_USR4(("NewShuffleTable[%d]:%d",i,newShuffleTable[i]));
        }
#endif
    }
    return isSame;
}

tResult ListControl::GetPlaybackMode(tPlaybackMode &playbackMode)
{
    ENTRY
    tResult res;
    tDeviceID deviceID;

    /* Get the active device */
    res = LocalSPM::GetDBManager().GetActiveDevice(OUT deviceID);
    if (res) return res;

    /* Get the playback mode for that device */
    res = LocalSPM::GetDBManager().GetPlaybackMode(OUT playbackMode, IN deviceID);
    if (res) return res;

    return MP_NO_ERROR;
}

tResult ListControl::SetPlaybackMode(tPlaybackMode playbackMode)
{
    ENTRY
    tResult res;
    tDeviceID deviceID;

    /* Get the active device */
    res = LocalSPM::GetDBManager().GetActiveDevice(OUT deviceID);
    if (res) return res;

    return SetPlaybackMode(IN deviceID, IN playbackMode);
}

tResult ListControl::SetPlaybackMode(const tDeviceID deviceID, const tPlaybackMode playbackMode)
{
    ENTRY
    tResult res;

    /* Get the old playback mode */
    tPlaybackMode oldPlaybackMode;
    res = LocalSPM::GetDBManager().GetPlaybackMode(OUT oldPlaybackMode, IN deviceID);
    if (res) return res;

    /* Return if the mode is the same */
    if (playbackMode == oldPlaybackMode) return MP_NO_ERROR;

    /* Set the playback mode for that device */
    res = LocalSPM::GetDBManager().SetPlaybackMode(IN deviceID, IN playbackMode);
    if (res) return res;

    /* Get the active device */
    tDeviceID activeDeviceID;
    res = LocalSPM::GetDBManager().GetActiveDevice(OUT activeDeviceID);
    if (res) {
        //return res; //No active device - no error
        return MP_NO_ERROR;
    }

    /* If the device is the current device */
    if(deviceID == activeDeviceID)
    {
        /* Update HMI of property PlaybackMode (shuffle mode) */
        res = LocalSPM::GetOutputWrapper().UpdatePlaybackMode();
        if (res) return res;
    }

    /* search all lists with the current device ID and recreate the playback DB lists in new mode */
    mLock.lock();
    ETG_TRACE_USR2(("SetPlaybackMode: deviceID=%d, playbackMode=%d", deviceID, playbackMode));
    for(tUInt i = 0; i<mLists.size(); i++) {

        ETG_TRACE_USR2(("SetPlaybackMode: check list: i:%d, listID=%d, deviceID=%d, isSongList=%d",
                i, mLists[i]->listID, mLists[i]->deviceID, IsPlayableList(IN mLists[i]->listType)));

        /* list entry found that is for the requested device and is a song list? */
        if ((mLists[i]->listID != LIST_ID_NONE)
                &&
                (mLists[i]->deviceID == deviceID)
                &&
                (IsPlayableList(IN mLists[i]->listType))) {

            /* act according to playback mode */
            if (playbackMode == PBM_RANDOM) {

                /* create the shuffle table for the list */
                tList *listPtr;
                GET_LIST_POINTER(OUT listPtr, IN mLists[i]->listID);
                if (listPtr) {
                    res = CreateShuffleTable(INOUT listPtr);
                }

                /* report error but ignore it */
                if (res) {
                    /* db list id seems to be deleted but list id not. */
                    ETG_TRACE_ERR(("CreateShuffleTable: res=%d/%s", res, errorString(res)));
                    res = MP_NO_ERROR;
                }

            } else {

                /* clear the shuffle mode for this list */
                mLists[i]->isInShuffleMode = 0;
            }
        }
    }

    mLock.unlock();

    return res;
}

tResult ListControl::GetRepeatMode(tRepeatMode &repeatMode)
{
    ENTRY
    tResult res;
    tDeviceID deviceID;

    /* Get the active device */
    res = LocalSPM::GetDBManager().GetActiveDevice(OUT deviceID);
    if (res) return res;

    /* Get the repeat mode for that device */
    res = LocalSPM::GetDBManager().GetRepeatMode(OUT repeatMode, IN deviceID);
    if (res) return res;

    return MP_NO_ERROR;
}

tResult ListControl::SetRepeatMode(const tRepeatMode repeatMode)
{
    ENTRY
    tResult res;
    tDeviceID deviceID;

    /* Get the active device */
    res = LocalSPM::GetDBManager().GetActiveDevice(OUT deviceID);
    if (res) return res;

    return SetRepeatMode(IN deviceID, IN repeatMode);
}

tResult ListControl::SetRepeatMode(const tDeviceID deviceID, const tRepeatMode repeatMode)
{
    ENTRY
    tResult res;

    /* Get the old repeat mode */
    tRepeatMode oldRepeatMode;
    res = LocalSPM::GetDBManager().GetRepeatMode(OUT oldRepeatMode, IN deviceID);
    if (res) return res;

    /* Return if the mode is the same */
    if (repeatMode == oldRepeatMode) return MP_NO_ERROR;

    /* Set the playback mode for that device */
    res = LocalSPM::GetDBManager().SetRepeatMode(IN deviceID, IN repeatMode);
    if (res) return res;

    /* Get the active device */
    tDeviceID activeDeviceID;
    res = LocalSPM::GetDBManager().GetActiveDevice(OUT activeDeviceID);
    if (res) {
        //return res; //No active device - no error
        return MP_NO_ERROR;
    }

    /* If the device is the current device */
    if(deviceID == activeDeviceID)
    {
        /* Update HMI of property RepeatMode */
        res = LocalSPM::GetOutputWrapper().UpdateRepeatMode();
        if (res) return res;
    }

    return MP_NO_ERROR;
}

tResult ListControl::GetFilelistWithObject(tListID &listID,
        tListSize &listSize,
        tNumberOfMediaObjects &numberOfMediaObjects,
        const tPath path,
        const tDeviceID deviceID,
        const tStreaming streaming/*=false*/)
{
    ENTRY
    tResult res = MP_ERR_LC_GENERAL_ERROR;
    tListType listType = LTY_FILELIST;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    vector<tFiles> mediaFileVector;
    tListSize size;
    tURL fileName;


    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    if(res)return res;

    if((DTY_MTP == deviceInfo.deviceType)
            &&
            ((deviceInfo.indexedState == IDS_PARTIAL) || (deviceInfo.indexedState == IDS_COMPLETE) || (deviceInfo.indexedState == IDS_COMPLETE_FULL_DB)))
    {
        tFilterTag1 tag1;
        tFilterTag2 tag2;
        tFilterTag3 tag3;
        tFilterTag4 tag4;

        tag1.tag = 0;
        tag2.tag = 0;
        tag3.tag = 0;
        tag4.tag = 0;

        res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
                OUT listID,
                OUT size,
                LTY_SONG,
                IN false,
                IN tag1,
                IN tag2,
                IN tag3,
                IN tag4,
                IN deviceID);
        if(!res)
        {
            if(size > 0) {
                listSize = size;
                return MP_NO_ERROR;
            }
            else {
                ReleaseList(IN listID);
            }
        }
    }

    /* create a folder list */
    res = CreateMediaPlayerFileList(OUT listID,
            OUT size,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN listType,
            IN path,
            IN deviceID,
            IN streaming,
            IN FTS_AUDIO_VIDEO_PLAYLIST);
    if (res) goto end; //lint !e801

    /* we have a list with playable objects: return without releasing the list */
    if (numberOfMediaObjects) {
        listSize = size;
        return MP_NO_ERROR;
    }

    /* no playable object in it: search the sub folders */

    /* get objects from list */
    res = RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, IN size);
    if (res) goto end;   //lint !e801

    /* loop over all elements but do only a sub search on folders */
    for(tUInt i=0; i<mediaFileVector.size(); i++) {

        /* is it a directory? */
        if (mediaFileVector[i].type == FT_FOLDER) {

            ReleaseList(IN listID);

            strncpy_r(OUT fileName, IN path, IN sizeof(fileName));
            if(NULL == FastUTF8::EndsWithNC((const FastUTF8::tString)fileName, (const FastUTF8::tString)"/"))  //lint !e1773
            {
                strncat_r(OUT fileName, IN "/", IN sizeof(fileName));
            }
            strncat_r(OUT fileName, IN mediaFileVector[i].fileName, IN sizeof(fileName));

            res = GetFilelistWithObject(OUT listID, OUT listSize, OUT numberOfMediaObjects, IN fileName, IN deviceID, IN streaming);
            if ((res == MP_NO_ERROR) && (numberOfMediaObjects > 0)) return MP_NO_ERROR;
        }
    }

    end:
    /* release the created list because not needed */
    ReleaseList(IN listID);

    /* nothing found: */
    return MP_ERR_DB_END_OF_LIST;
}

tResult ListControl::CreatePlayableFilelist(tListID &listID, tListSize &listSize, tIndex &startPosition, const tDeviceID deviceID, const tStreaming streaming/*=false*/)
{
    ENTRY;
    tPath path;
    tResult res;
    tNumberOfMediaObjects numberOfMediaObjects;
    TimeTrace ticks("SearchForFirstPlayableFolder");
    ticks.begin();

    /* create a file list which has a playable object */
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    res = GetFilelistWithObject(OUT listID, OUT listSize, OUT numberOfMediaObjects, IN path, IN deviceID, IN streaming);
    if (res) return res;

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* loop over slice */
    res = LocalSPM::GetDBManager().StartListAccess(IN listPtr->dbBrowseListID, IN 0, IN listSize);
    if (res) return res;

    /* look for the first object wither audio or video*/
    for(startPosition=0; startPosition<listSize; startPosition++) {

        /* get one object */
        tMediaObject mediaObject;
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listPtr->dbBrowseListID, IN startPosition);
        if (res) break;

        if ((mediaObject.fileType == FT_AUDIO) ||
                (mediaObject.fileType == FT_VIDEO))
            break;
    }

    /* finalize the list access */
    LocalSPM::GetDBManager().EndListAccess(IN listPtr->dbBrowseListID);

    if (startPosition == listSize) {
        ETG_TRACE_ERR(("CreatePlayableFilelist: found no media object in file list"));
        return MP_ERR_LC_GENERAL_ERROR;
    }

    return MP_NO_ERROR;
}

/**
 *  An another version of creating playable files list
 *  For a given path lists all the playable mediobject at that level skipping all the folders and unknown objects
 */
tResult ListControl::CreateFileListOfMediaObjects(tListID &listID,
        const tPath path,
        const tDeviceID deviceID,
        const tBoolean withSubFolders)
{
    ENTRY
    tResult res;
    tListID dbBrowseListID = LIST_ID_NONE;
    listID = LIST_ID_NONE;
    tListType listType = LTY_FILELIST_MEDIAOBJECTS;
    if(withSubFolders)
    {
        listType = LTY_FILELIST_MEDIAOBJECTS_WITH_SUBFOLDERS;
    }

    /* in case of device is already indexed use folder database instead of VTFile */
    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    if (res) return res;

    if((LocalSPM::GetDataProvider().DBFileBrowsingByDB())
            &&
            ((LocalSPM::GetDataProvider().DBFileListWhileIndexing()) || (IDS_COMPLETE == deviceInfo.indexedState) || (IDS_COMPLETE_FULL_DB == deviceInfo.indexedState)))
    {
        if(withSubFolders)
        {
            listType = LTY_BROWSELIST_MEDIAOBJECTS_WITH_SUBFOLDERS;
        }
        else
        {
            listType = LTY_BROWSELIST_MEDIAOBJECTS;
        }
    }

    VARTRACE(listType);
    VARTRACE(path);
    VARTRACE(deviceID);

    /* in case of config value permanent streaming (e.g. for DTY_BLUETOOTH) or device can batch play (e.g. iPod iAP2) reset list to streaming */
    tStreaming localStreaming = false;
    if((LocalSPM::GetDataProvider().IsPermanentStreamingActive(deviceID))
            ||
            (LocalSPM::GetDeviceDispatcher().IsBatchPlayable(deviceID)))
    {
        ETG_TRACE_USR2(("Reset list to streaming=true because of permanent streaming or batch play"));
        localStreaming = true;
    }

    tFileTypeSelection fileTypeSelection = LocalSPM::GetDBManager().GetFTSByActiveMediaContext();

    mLock.lock();
    for (tUInt i=0; i<mLists.size(); i++) {
        if (mLists[i]->listID != LIST_ID_NONE) {

            //ETG_TRACE_USR2(("###  listID=%d, listType=%d, deviceID=%d, streaming=%d, path:%s",
            //        mLists[i]->listID, mLists[i]->listType, mLists[i]->deviceID, mLists[i]->streaming, mLists[i]->path));

            if ((listType == mLists[i]->listType)
                    &&
                    (!strcmp(path, mLists[i]->path))
                    &&
                    (deviceID == mLists[i]->deviceID)
                    &&
                    (fileTypeSelection == mLists[i]->fileTypeSelection)
                    &&
                    (localStreaming == mLists[i]->streaming)) {

                // found a related file list
                listID = mLists[i]->listID;
                dbBrowseListID = mLists[i]->dbBrowseListID;
                mLists[i]->createCounter++;
                break;
            }
        }
    }
    mLock.unlock();

    /* create or recreate (if old list is found) a file list by the DB manager */
    res = LocalSPM::GetDBManager().CreateFileListOfMediaObjects(
            INOUT dbBrowseListID,
            INOUT listType,
            IN path,
            IN deviceID,
            IN localStreaming,
            IN fileTypeSelection);
    if (res) return res;

    if (LIST_ID_NONE == listID) {

        /* create the list */
        res = CreateList(OUT listID);
        if (res) return res;
    }

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* setup internal data structs */
    listPtr->dbBrowseListID = dbBrowseListID;
    listPtr->listType = listType;
    strncpy_r(OUT listPtr->path, IN path, IN sizeof(listPtr->path));
    listPtr->deviceID = deviceID;
    listPtr->playContinuation = PC_NO_REPEAT;
    listPtr->fileTypeSelection = fileTypeSelection;
    listPtr->streaming = localStreaming;
    listPtr->isVTIPODList = 0;

    /* check if device is in shuffle mode */
    tPlaybackMode playbackMode;
    res = LocalSPM::GetDBManager().GetPlaybackMode(OUT playbackMode, IN deviceID,IN fileTypeSelection);
    if (res) return res;

    /* device is in random mode, shuffle the playlist */
    if (playbackMode == PBM_RANDOM) {

        TimeTrace tMeas2("CreateFileListOfMediaObjects-CreateShuffleTable");

        /* create the shuffle table for this list */
        res = CreateShuffleTable(INOUT listPtr);
        if (res) return res;
        tMeas2.elapsed();
    }

    return MP_NO_ERROR;
}

tResult ListControl::CreateMediaPlayerFileList(tListID &listID,
        tListSize &listSize,
        tNumberOfMediaObjects &numberOfMediaObjects,
        tNumberOfPlayLists &numberOfPlayLists,
        tNumberOfFolders &numberOfFolders,
        tListType listType,
        const tPath path,
        const tDeviceID deviceID,
        const tStreaming streaming,/*=false*/
        const tFileTypeSelection fileTypeSelection/*=FTS_AUDIO_VIDEO_PLAYLIST*/)
{
    ENTRY
    tResult res;
    tListID dbBrowseListID = LIST_ID_NONE;
    listID = LIST_ID_NONE;

    VARTRACE(listType);
    VARTRACE(path);
    VARTRACE(deviceID);

    //ETG_TRACE_USR2(("###Check lists: listType=%d, deviceID=%d, fileTypeSelection=%d, streaming=%d, path:%s",
    //        listType, deviceID, fileTypeSelection, streaming, path));

    /* search for a file list which uses same attributes */

    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    if(res)return res;

    tListType localListType = listType;
    if(DTY_MTP == deviceInfo.deviceType)
    {
        localListType = LTY_MTP_FILELIST;
    }
    else if(DTY_BLUETOOTH == deviceInfo.deviceType)
    {
        localListType = LTY_BLUETOOTH_FILELIST;
    }
    else if(DTY_CDDA == deviceInfo.deviceType)
    {
        localListType = LTY_CD;
    }


    /* in case of config value permanent streaming (e.g. for DTY_BLUETOOTH) or device can batch play (e.g. iPod iAP2) reset list to streaming */
    tStreaming localStreaming = streaming;
    if((LocalSPM::GetDataProvider().IsPermanentStreamingActive(deviceInfo.deviceType))
            ||
            (LocalSPM::GetDeviceDispatcher().IsBatchPlayable(deviceID)))
    {
        ETG_TRACE_USR2(("Reset list to streaming=true because of permanent streaming or batch play"));
        localStreaming = true;
    }

    /* in case of device is already indexed use folder database instead of VTFile */
    if(LocalSPM::GetDataProvider().IsFileBrowsingByDb(IN deviceInfo, IN path, IN localListType))
    {
        localListType = LTY_BROWSELIST;
    }

    mLock.lock();
    for (tUInt i=0; i<mLists.size(); i++) {
        if (mLists[i]->listID != LIST_ID_NONE) {

            //ETG_TRACE_USR2(("###  listID=%d, listType=%d, deviceID=%d, fileTypeSelection=%d, streaming=%d, path:%s",
            //        mLists[i]->listID, mLists[i]->listType, mLists[i]->deviceID, mLists[i]->fileTypeSelection, mLists[i]->streaming, mLists[i]->path));

            if ((localListType == mLists[i]->listType)
                    &&
                    (!strcmp(path, mLists[i]->path))
                    &&
                    (deviceID == mLists[i]->deviceID)
                    &&
                    (fileTypeSelection == mLists[i]->fileTypeSelection)
                    &&
                    (localStreaming == mLists[i]->streaming)) {

                // found a related file list
                listID = mLists[i]->listID;
                dbBrowseListID = mLists[i]->dbBrowseListID;
                mLists[i]->createCounter++;
                break;
            }
        }
    }
    mLock.unlock();

    /* create or recreate (if old list is found) a file list by the DB manager */
    res = LocalSPM::GetDBManager().CreateMediaPlayerFileList(
            INOUT dbBrowseListID,
            INOUT localListType,
            IN path,
            IN deviceID,
            IN localStreaming,
            IN fileTypeSelection);
    if (res) return res;

    if (LIST_ID_NONE == listID) {

        /* create the list */
        res = CreateList(OUT listID);
        if (res) return res;
    }

    /* Get the list pointer of new list */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    listType = localListType;
    /* setup internal data structs */
    listPtr->dbBrowseListID = dbBrowseListID;
    listPtr->listType = localListType;
    strncpy_r(OUT listPtr->path, IN path, IN sizeof(listPtr->path));
    listPtr->deviceID = deviceID;
    listPtr->playContinuation = PC_NO_REPEAT;
    listPtr->fileTypeSelection = fileTypeSelection;
    listPtr->streaming = localStreaming;
    listPtr->isVTIPODList = 0;

    /* set objectID of nowPlaying info for highlighting */
    //res = GetNowPlayingObjectID(OUT listPtr->nowPlayingObjectID, IN dbBrowseListID);
    //if (res) return res;

    /* check if device is in shuffle mode */
    tPlaybackMode playbackMode;
    res = LocalSPM::GetDBManager().GetPlaybackMode(OUT playbackMode, IN deviceID,IN fileTypeSelection);
    if (res) return res;

    /* device is in random mode, shuffle the playlist */
    if (playbackMode == PBM_RANDOM) {

        TimeTrace tMeas2("CreateMediaPlayerFileList-CreateShuffleTable");

        /* create the shuffle table for this list */
        res = CreateShuffleTable(INOUT listPtr);
        if (res) return res;
        tMeas2.elapsed();
    }

    if((localListType == LTY_PLAYLIST_SONG)
            ||
            (localListType == LTY_FILELIST_PLAYLIST)) {

        /* search a parent list or create one */
        SetParent(INOUT listPtr);
    }
    else {

        /* Pre-Highlight current playing object and the parent lists */
        tNowPlaying nowPlaying;
        res = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
        if (MP_NO_ERROR == res) {

            tPosition position = POSITION_NOT_SET;
            if ((OBJECT_ID_NONE != nowPlaying.objectID)
                    &&
                    (localListType != LTY_BLUETOOTH_FILELIST)){

                /* Set the list position to new object if object is in the list */
                res = LocalSPM::GetDBManager().SetPosition(OUT position, IN nowPlaying.objectID, IN listPtr->dbBrowseListID);
                if ((MP_NO_ERROR == res) && (POSITION_NOT_SET != position)) {

                    /* Set the now playing info */
                    listPtr->nowPlayingObjectID = nowPlaying.objectID;
                    VARTRACE(listPtr->nowPlayingObjectID);
                    listPtr->nowPlayingListPosition = position; // remember the position to update the old element also
                }
            }

            if (LIST_ID_NONE != nowPlaying.listID) {

                /* Get the list pointer of nowPlaying list */
                tList *listPtrNowPlaying;
                GET_LIST_POINTER(OUT listPtrNowPlaying, IN nowPlaying.listID);
                if (listPtrNowPlaying) {

                    /* Set highlighting of parent file lists */
                    SetFileListHighlighting(INOUT listPtrNowPlaying);
                }
            }
        }
    }

    /* get the counts */
    res = LocalSPM::GetDBManager().GetFileListSize(OUT listSize, OUT numberOfMediaObjects, OUT numberOfPlayLists, OUT numberOfFolders, IN dbBrowseListID);
    if (res) return res;

    VARTRACE(listSize);
    VARTRACE(numberOfMediaObjects);
    return MP_NO_ERROR;
}

tResult ListControl::CreateMediaPlayerFileList(tListID &listID,
        tListSize &listSize,
        tNumberOfMediaObjects &numberOfMediaObjects,
        tNumberOfPlayLists &numberOfPlayLists,
        tNumberOfFolders &numberOfFolders,
        tPosition &position,
        const tPath fullPath,
        const tDeviceID deviceID,
        const tStreaming streaming,/*=false*/
        const tFileTypeSelection fileTypeSelection/*=FTS_AUDIO_VIDEO_PLAYLIST*/)
{
    ENTRY
    tResult res;
    tListType listType = LTY_FILELIST;
    tPath path;
    strncpy_r(OUT path, IN fullPath, IN sizeof(path));

    // drop the filename from the path
    unsigned char *pureFile;
    FastUTF8::Split(OUT pureFile, INOUT (unsigned char *)path);

    /* Create the list */
    res = CreateMediaPlayerFileList(OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN listType,
            IN path,
            IN deviceID,
            IN streaming,
            IN fileTypeSelection);
    if (res) return res;

    /* Now calculate the position of media object in the list */
    position = POSITION_NOT_SET;

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    res = LocalSPM::GetDBManager().StartListAccess(IN listPtr->dbBrowseListID, IN 0, INDEX_NO_LIMIT);
    if (res) return res;

    /* loop over all elements of this list */
    for(tPosition row=0; row<listSize; row++)
    {
        tMediaObject mediaObject;

        /* get one entry */
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listPtr->dbBrowseListID, IN row);
        if (res)
        {
            LocalSPM::GetDBManager().EndListAccess(IN listPtr->dbBrowseListID);
            return res;
        }

        if (strcmp(mediaObject.fileName, fullPath) == 0)
        {
            position = row;
            break;
        }
    }

    LocalSPM::GetDBManager().EndListAccess(IN listPtr->dbBrowseListID);

    VARTRACE(position);
    return res;
}

tResult ListControl::RequestMediaPlayerFileListSlice(vector<tFiles> &mediaFileVector,
        const tListID listID,
        const tIndex startIndex,
        const tIndex sliceSize)
{
    ENTRY
    tResult res;

    if(INDEX_NONE == startIndex) return MP_ERR_LC_UNDEFINED_INDEX;
    if(INDEX_NONE == sliceSize) return MP_ERR_LC_UNDEFINED_INDEX;

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* reset the resulting vector */
    mediaFileVector.clear();

    /* loop over slice */
    res = LocalSPM::GetDBManager().StartListAccess(IN listPtr->dbBrowseListID, IN startIndex, IN sliceSize);
    if (res) return res;

    /* loop to get the objects */
    for(tUInt index = startIndex; index < (startIndex + sliceSize); index++)
    {
        /* get one object */
        tMediaObject mediaObject;
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listPtr->dbBrowseListID, IN index);
        if (res) break;

        /* fill the file object */
        tFiles file;
        InitFiles(INOUT file);
        file.fileFormat = mediaObject.fileFormat;
        strncpy_r(OUT file.fileName, IN mediaObject.title, IN sizeof(file.fileName));
        file.trackNumber = mediaObject.trackNumber;
        file.type = mediaObject.fileType;
        file.notPlayable = mediaObject.notPlayable;
        file.objectID = mediaObject.objectID;
        if(LocalSPM::GetDataProvider().EnableSRdevice()) //Get File mode only for SR device
        {
            file.readOnlyFlag = GetFileMode(IN mediaObject.deviceID, IN mediaObject.objectID);
            if(MP_NO_ERROR != LocalSPM::GetDBManager().GetFileLengthDateSize(IN mediaObject.deviceID, IN mediaObject.objectID,
                                     OUT file.playTime, OUT file.dateTime,OUT file.fileSize))
            {
                ETG_TRACE_ERR(("ListControl::GetFileLengthDateSize failed"));
            }
        }
        /* Take file name instead of the tagged title in case of a browse list because it should look like a filelist */
        if ((listPtr->listType == LTY_BROWSELIST)
                ||
                (listPtr->listType == LTY_BROWSELIST_MEDIAOBJECTS)
                ||
                (listPtr->listType == LTY_BROWSELIST_MEDIAOBJECTS_WITH_SUBFOLDERS))
        {
            tURL fullName;
            unsigned char *pureFile;
            strncpy_r(OUT fullName, IN mediaObject.fileName, IN sizeof(fullName));
            FastUTF8::Split(OUT pureFile, INOUT (unsigned char *)fullName);
            //VARTRACE(pureFile);

            if (pureFile)
            {
                /* Remove the extension, if wanted */
                if (LocalSPM::GetDataProvider().DBRemoveExtensionFromFilename())
                {
                    unsigned char *extension;
                    FastUTF8::SplitExtension(OUT extension, INOUT (unsigned char *)pureFile);
                }

                strncpy_r(OUT file.fileName, IN (const char *)pureFile, IN sizeof(file.fileName));
            }
        }
        VARTRACE(file.objectID);
        VARTRACE(LocalSPM::GetDataProvider().EnableBTNowPlayingHighlight());
        /* is it the currently played object? */
        //if (mediaObject.objectID == listPtr->nowPlayingObjectID) //for file lists do the check via position because folders (no objectID) can be active too
        //For LTY_BLUETOOTH_FILELIST the object id is the poistion , hence the object id of song and the list elament is used to compare to find out the current playing song in the list.
        if(((index == listPtr->nowPlayingListPosition) && (listPtr->listType != LTY_BLUETOOTH_FILELIST)) || ((listPtr->listType == LTY_BLUETOOTH_FILELIST) && (listPtr->nowPlayingObjectID == (file.objectID)) && (0 == strncmp((listPtr->path),"now-playing",sizeof(listPtr->path))) && (LocalSPM::GetDataProvider().EnableBTNowPlayingHighlight())))
       {
            file.isPlaying = 1;
        }

        /* add it to the vector */
        mediaFileVector.push_back(IN file);
    }

    /* finalize the list access */
    LocalSPM::GetDBManager().EndListAccess(IN listPtr->dbBrowseListID);

    return MP_NO_ERROR;
}

tResult ListControl::UpdateNowPlaying(tPosition &position, const tListID listID, const tObjectID objectID)
{
    ENTRY
    tResult res = MP_NO_ERROR;
    tListChangeType listChangeType = LCH_ITEMS_CHANGED;
    vector<tPosition> changedItems;
    VARTRACE(listID);
    VARTRACE(objectID);

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    position = POSITION_NOT_SET;
    //For bluetooth file list the objectID is used for setting position.So Avoid calling  DBManager::SetPosition function.
    if((OBJECT_ID_NONE != objectID) && (listPtr->listType != LTY_BLUETOOTH_FILELIST))
    {
        /* Set the list position to new object */
        res = LocalSPM::GetDBManager().SetPosition(OUT position, IN objectID, IN listPtr->dbBrowseListID);
        if (res) return res;

        if (IsFileList(listPtr->listType)) {

            /* Set highlighting of parent file lists */
            SetFileListHighlighting(INOUT listPtr);
        }
        else {

            /* Set highlighting of parent lists */
            SetParentHighlighting(INOUT listPtr);
        }
    }
    //else
    //no new object, just remove highlighting on list

    /* Set the items which has changed */
    if((position != listPtr->nowPlayingListPosition) && (listPtr->listType != LTY_BLUETOOTH_FILELIST))
    {
        if (listPtr->nowPlayingListPosition != POSITION_NOT_SET)
        {
            changedItems.push_back(listPtr->nowPlayingListPosition); //old position
        }
        if (position != POSITION_NOT_SET)
        {
            changedItems.push_back(position); //new position
        }
    }

    /* Set the now playing info */
    listPtr->nowPlayingObjectID = objectID;
    VARTRACE(listPtr->nowPlayingObjectID);
    listPtr->nowPlayingListPosition = position; // remember the position to update the old element also

    /* In case of LTY_CURRENT_SELECTION and streaming flag update the whole list */
    //For LTY_BLUETOOTH_FILELIST Inform content change to HMI when the song changes to avoid confusion when a song playing is not yet fetched in the /NowPlaying list.
    VARTRACE(listPtr->path);
    if(((LTY_CURRENT_SELECTION == listPtr->listType)
            &&
            (listPtr->streaming))|| ((listPtr->listType == LTY_BLUETOOTH_FILELIST) &&  (0 == strncmp((listPtr->path),"now-playing",sizeof(listPtr->path))) && (LocalSPM::GetDataProvider().EnableBTNowPlayingHighlight())))
    {
        listChangeType = LCH_CONTENT_CHANGED;
        if((OBJECT_ID_NONE != objectID) && (listPtr->listType == LTY_BLUETOOTH_FILELIST))
        {
            position = objectID - 1;
            listPtr->nowPlayingListPosition = position;
        }
    }
    else
    {
        /* No changed elements? */
        if (changedItems.size() == 0)
        {
            ETG_TRACE_USR2(("ListControl::UpdateNowPlaying: No update because no element changed"));
            return MP_NO_ERROR;
        }
    }

    /* Get list information to get the current list size */
    tListSize listSize;
    res = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN listPtr->dbBrowseListID);
    if (res) listSize = 0; //listID not found

    /* Send signal via output wrapper that a list has changed */
    res = LocalSPM::GetOutputWrapper().SendMediaPlayerListChanged(
            IN listID,
            IN listChangeType,
            IN listSize,
            IN changedItems);
    if (res) return res;

    //CheckFileLists(IN listInfo.deviceID); update of all existing file lists, but until now comment out due to low performance

    return MP_NO_ERROR;
}

tResult ListControl::UpdateListSlice(const tListID listID, const tIndex startIndex, const tIndex sliceSize)
{
    ENTRY
    tResult res;
    VARTRACE(listID);
    VARTRACE(startIndex);
    VARTRACE(sliceSize);

    if(INDEX_NONE == startIndex) return MP_ERR_LC_UNDEFINED_INDEX;
    if(INDEX_NONE == sliceSize) return MP_ERR_LC_UNDEFINED_INDEX;

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    /* Set the items which has changed */
    vector<tPosition> changedItems;
    for(tUInt i=0; i<sliceSize; i++) {
        changedItems.push_back(startIndex+i);
    }

    /* Try to get the list size */
    tListSize listSize = 0;
    res = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN listPtr->dbBrowseListID);
    if (res) listSize = sliceSize; //listID not found

    /* Send message via output wrapper */
    res = LocalSPM::GetOutputWrapper().SendMediaPlayerListChanged(
            IN listID,
            IN LCH_ITEMS_CHANGED,
            IN listSize,
            IN changedItems);

    return MP_NO_ERROR;
}

tResult ListControl::CheckLists(const tDeviceID deviceID)
{
    ENTRY
    tResult res;
    vector<tPosition> changedItems;
    tListID listID;
    tListSize listSize;

    /* check all lists */
    mLock.lock();
    for(tUInt i=0; i<mLists.size(); i++) {

        //Performance issue, do not update all lists,
        //but update lists for indexing device and MyMedia only
        if ((mLists[i]->listID != LIST_ID_NONE)
                &&
                ((mLists[i]->deviceID == deviceID) || (mLists[i]->deviceID == MY_MEDIA))) {

            //Suppress updates on VT lists, redundant information anyway
            if (!LocalSPM::GetDBManager().IsVTList(IN mLists[i]->dbBrowseListID)) {
                tPosition prevNowPlayingListPosition = POSITION_NOT_SET;
                tPosition position;
                tResult setPositionRes = MP_ERR_LC_GENERAL_ERROR;
                /* Reset the list position to current object because of MediaObjects table changes in DB (GMMY16-19561) */
                if (OBJECT_ID_NONE != mLists[i]->nowPlayingObjectID)
                {

                    setPositionRes = LocalSPM::GetDBManager().SetPosition(OUT position, IN mLists[i]->nowPlayingObjectID, IN mLists[i]->dbBrowseListID);
                    if (MP_NO_ERROR == setPositionRes) {
                        prevNowPlayingListPosition = mLists[i]->nowPlayingListPosition;
                        if(mLists[i]->nowPlayingListPosition != position)
                        {
                            mLists[i]->nowPlayingListPosition = position;
                        }
                    }
                }

                /* try to get the list size */
                listSize = 0;
                res = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN mLists[i]->dbBrowseListID);
                if (res) listSize = 0; //listID not found

                listID = mLists[i]->listID;
                mLock.unlock();

                /*PSARCC21-1710:If Currently playing track's Position changes in Nowplaying List i.e Due to Increase in listsize,
                 * update its new position via NowPlaying property
                 */
                if ((MP_NO_ERROR == setPositionRes) && (prevNowPlayingListPosition != position))
                {
                    LocalSPM::GetPlayerManager().UpdateNowPlayingWithGivenPosition(IN listID,IN position);
                }

                /* send message via output wrapper */
                res = LocalSPM::GetOutputWrapper().SendMediaPlayerListChanged(
                        IN listID,
                        IN LCH_CONTENT_CHANGED,
                        IN listSize,
                        IN changedItems);
                //if (res) return res; Go on even in error case

                mLock.lock();
            }
        }
    }
    mLock.unlock();

    return MP_NO_ERROR;
}

tResult ListControl::CheckFileLists(const tDeviceID deviceID)
{
    ENTRY
    tResult res;
    vector<tPosition> changedItems;
    tListID listID;
    tListSize listSize;

    /* Reset highlighting of all file lists */
    mLock.lock();
    for(tUInt i=0; i<mLists.size(); i++) {
        if ((mLists[i]->listID != LIST_ID_NONE)
                &&
                (mLists[i]->deviceID == deviceID)
                &&
                (IsFileList(mLists[i]->listType))) {

            /* reset nowPlaying object for highlighting */
            mLists[i]->nowPlayingObjectID = OBJECT_ID_NONE;
            mLists[i]->nowPlayingListPosition = POSITION_NOT_SET;
        }
    }

    /* Highlight current playing object and the parent lists */
    tNowPlaying nowPlaying;
    tPosition position;
    res = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
    if (MP_NO_ERROR == res) {

        if (OBJECT_ID_NONE != nowPlaying.objectID) {

            for(tUInt i=0; i<mLists.size(); i++) {

                if ((mLists[i]->listID != LIST_ID_NONE)
                        &&
                        (mLists[i]->deviceID == deviceID)
                        &&
                        (IsFileList(mLists[i]->listType))) {

                    /* Set the list position to new object if object is in the list */
                    position = POSITION_NOT_SET;
                    res = LocalSPM::GetDBManager().SetPosition(OUT position, IN nowPlaying.objectID, IN mLists[i]->dbBrowseListID);
                    if ((MP_NO_ERROR == res) && (POSITION_NOT_SET != position)) {

                        /* Set the now playing info */
                        mLists[i]->nowPlayingObjectID = nowPlaying.objectID;
                        mLists[i]->nowPlayingListPosition = position; // remember the position to update the old element also
                    }
                }
            }
        }

        if (LIST_ID_NONE != nowPlaying.listID) {

            /* Get the list pointer of nowPlaying list */
            tList *listPtrNowPlaying;
            GET_LIST_POINTER(OUT listPtrNowPlaying, IN nowPlaying.listID);
            if (listPtrNowPlaying) {

                /* Set highlighting of parent file lists */
                SetFileListHighlighting(INOUT listPtrNowPlaying);
            }
        }
    }

    /* Update the HMI */
    for(tUInt i=0; i<mLists.size(); i++) {
        if ((mLists[i]->listID != LIST_ID_NONE)
                &&
                (mLists[i]->deviceID == deviceID)
                &&
                ((IsFileList(mLists[i]->listType)) && (mLists[i]->listType != LTY_BLUETOOTH_FILELIST))) {

            /* Try to get the list size */
            listSize = 0;
            res = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN mLists[i]->dbBrowseListID);
            if (res) listSize = 0; //listID not found

            listID = mLists[i]->listID;
            mLock.unlock();

            /* Send message via output wrapper */
            res = LocalSPM::GetOutputWrapper().SendMediaPlayerListChanged(
                    IN listID,
                    IN LCH_CONTENT_CHANGED,
                    IN listSize,
                    IN changedItems);
            //if (res) return res; Go on even in error case

            mLock.lock();
        }
    }
    mLock.unlock();

    return MP_NO_ERROR;
}

tResult ListControl::CheckMediaObject(tMediaObjectInfo &mediaObjectInfo,
        const tListID listID,
        const tIndex rowNumber,
        const tPlaytime playtime)
{
    ENTRY
    tResult res;

    if(LIST_ID_NONE == listID) return MP_ERR_LC_UNDEFINED_LIST_ID;
    if(INDEX_NONE == rowNumber) return MP_ERR_LC_UNDEFINED_INDEX;

    /* reset the result */
    vector<tMediaObject> mediaObjectVector;
    InitMediaObjectInfo(OUT mediaObjectInfo);

    /* ask for that object in the list */
    res = RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, IN rowNumber, 1);

    /* qualify the error status */
    if (res) {
        mediaObjectInfo.ListInvalid = 1;
    } else if (mediaObjectVector.size() == 0) {
        mediaObjectInfo.ObjectInvalid = 1;
    } else {
        mediaObjectInfo.ObjectValid = 1;
        if (playtime > mediaObjectVector[0].totalPlaytime) {
            mediaObjectInfo.PositionInvalid = 1;
        }
    }

    return MP_NO_ERROR;
}

tResult ListControl::CreateMediaPlayerPlaylistList(tListID &listID, tListSize &listSize, const tFilename fileName, tDeviceID deviceID)
{
    ENTRY

    tResult res = MP_NO_ERROR;
    tListType listType = LTY_PLAYLIST_SONG;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;

    /* create a normal file list which points to the play list. rest is done by virtual table file system */
    res = CreateMediaPlayerFileList(OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN listType,
            IN fileName,
            IN deviceID);
    if (res) return res;

    VARTRACE(listSize);

    return MP_NO_ERROR;
}

tResult ListControl::CreateMediaPlayerPlaylistList(tListID &listID, tListSize &listSize, const tFilename fileName)
{
    ENTRY

    tResult res = MP_NO_ERROR;

    /* the interface provides no device id but a device is needed for the mount point */
    /* get the current active device id */
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetActiveDevice(OUT deviceID);
    if (res) return res;

    res = CreateMediaPlayerPlaylistList(OUT listID, OUT listSize, IN fileName ,IN deviceID);
    if (res) return res;

    return MP_NO_ERROR;
}

tResult ListControl::GetPositionInList(tPosition &position, const tListID listID, const tObjectID objectID)
{
    ENTRY
    tResult res;

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN listPtr->deviceID);
    if (res) return res;

    /* get the list position to this song */
    if ((objectID == listPtr->nowPlayingObjectID) && (DTY_MTP != deviceInfo.deviceType))
    {
        position = listPtr->nowPlayingListPosition;
    }
    else
    {
        res = LocalSPM::GetDBManager().GetPositionInList(OUT position, IN listPtr->dbBrowseListID, IN objectID);
        if (res) return res;
    }

    return MP_NO_ERROR;
}

tResult ListControl::CreateInternalFileNamePlaylist(tPath &playlistPath, const tDeviceID deviceID, const tPlaylistName playlistName)
{
    ENTRY
    tResult res;

    //Check if the playlist name exists already, if exists return error
    int playlistNameCount = 0;
    LocalSPM::GetDBManager().CheckifPlaylistExists(playlistNameCount,deviceID,playlistName);
    if(playlistNameCount != 0)
    {
        return MP_ERR_LC_PLAYLIST_MULTIPLE_ENTRIS_FOUND;
    }
    tPlaylistName playlistNameModified = "";
    strncpy_r(OUT playlistNameModified, IN playlistName, IN sizeof(playlistNameModified));


    //if the playlist name is given with out m3u extention, the mediacore will add m3u extention to file name
    if(!strcasestr(playlistNameModified,".m3u"))
    {
        strncat_r(OUT playlistNameModified,".m3u",sizeof(playlistNameModified));
    }
    strncpy_r(OUT playlistPath, IN LocalSPM::GetDataProvider().InternalPlaylistStoragePath().c_str(), IN sizeof(playlistPath));
    strncat_r(OUT playlistPath, IN "/", IN sizeof(playlistPath));
    strncat_r(OUT playlistPath, IN playlistNameModified, IN sizeof(playlistPath));

    VARTRACE(playlistNameModified);

    /* Creating the Playlist as a file using normal file operations in the file system., Will replaced with Totem library functions as an option*/
    FILE *fp;
    fp = fopen (playlistPath,"w");
    if (fp == NULL)
    {
        ETG_TRACE_ERR(("Could not create playlist on the filesystem : %s ",playlistPath));
        return MP_ERR_LC_PLAYLIST_FILE_CREATE;
    }
    fclose (fp);

    /*prepare the mediaobject which represents the playlisr*/
    tMediaObject mediaObject;
    InitMediaObject(OUT mediaObject);
    mediaObject.catType = CTY_PLAYLIST_INTERNAL;
    mediaObject.mediaType = MTY_PLAYLIST_INTERNAL;
    mediaObject.deviceID = deviceID;
    strncpy_r(OUT mediaObject.fileName, IN playlistNameModified, IN sizeof(mediaObject.fileName));
    //returning the playlist path (with out the complete path) to playlist creation method result
    strncpy_r(OUT playlistPath, IN playlistNameModified, IN sizeof(playlistPath));
    strncpy_r(OUT mediaObject.MetadataField1, IN playlistName, IN sizeof(mediaObject.MetadataField1));
    strncpy_r(OUT mediaObject.title, IN playlistName, IN sizeof(mediaObject.title));

    /*push the newly created playlist into indexed database*/
    res = LocalSPM::GetDBManager().StoreMediaObject(IN mediaObject);
    if (res) return MP_ERR_LC_PLAYLIST_DATABASE_ERROR;
    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
    if (res) return MP_ERR_LC_PLAYLIST_DATABASE_ERROR;

    /* Inform ListControl that playlist has updated */
    CheckLists(deviceID);
    VARTRACE(playlistPath);

    return MP_NO_ERROR;

}

tResult ListControl::AddFileNameToPlaylist(const tPath playlistPath, const tPath filenamePath, const tPosition position)
{
    ENTRY

    tUInt pos = position;
    string line;
    vector<string> playlistData;
    tResult ret = MP_NO_ERROR;
    ETG_TRACE_USR4(("AddFileNameToPlaylist: playlistPath=%s",playlistPath));
    ETG_TRACE_USR4(("AddFileNameToPlaylist: playlistPath position =%d",position));
    tPath playlistCompletePath = "";
    GetCompletePlaylistPath(playlistCompletePath,playlistPath);

    /*check if playlist exisits */
    ifstream myfile(playlistCompletePath);
    if(!myfile)
    {
        ret = MP_ERR_LC_PLAYLIST_NOT_FOUND;
    }
    else
    {

        /*pop the entries into a list*/
        while (std::getline(myfile, line))
        {
            playlistData.push_back(line);
        }
        myfile.close();

        if( (!LocalSPM::GetDataProvider().PlaylistMulipleEntriesAllowed()) &&
                (find(playlistData.begin(),playlistData.end(),filenamePath) != playlistData.end())
        )
        {
            ETG_TRACE_USR4(("AddFileNameToPlaylist: not allowed to add same entry multiple times"))
            ret = MP_ERR_LC_PLAYLIST_MULTIPLE_ENTRIS_FOUND;
        }
        else
        {
            /*check the boundaries*/
            if(position == POSITION_NOT_SET)
            {
                pos = playlistData.size();
            }

            /*check for position boundary errors*/
            if((int)pos < 0 || (int)pos > (int)playlistData.size())  //lint !e574
            {
                ETG_TRACE_USR4(("AddFileNameToPlaylist: invalid position "))
                                                        ret = MP_ERR_LC_INVALID_POSITION;
            }
            else
            {
                /* insert the new entry into local list of playlist entries*/
                playlistData.insert(playlistData.begin()+pos,1,filenamePath);

                /* push all the entries from local list into playlist file*/
                ofstream outfile(playlistCompletePath);
                if ((outfile.rdstate() & std::ifstream::failbit ) != 0)
                {
                    ETG_TRACE_USR4(("AddFileNameToPlaylist: not sufficient permission "))
                                                            ret = MP_ERR_LC_PLAYLIST_FILE_PERMISSION;
                }
                else
                {
                    ostream_iterator<string> output_iterator(outfile, "\n");
                    copy(playlistData.begin(), playlistData.end(), output_iterator);
                    if ( ((outfile.rdstate() & std::ifstream::badbit ) != 0))
                    {
                        ETG_TRACE_USR4(("AddFileNameToPlaylist: File operation error"))
                                                                ret = MP_ERR_LC_PLAYLIST_FILE_OPERATATION;
                    }
                    else
                    {
                        outfile.close();
                    }
                }
            }
        }
    }

    return ret;
}

tResult ListControl::DeleteEntryFromPlaylist(const tPath playlistPath, const tPosition position,const bool deleteAllEntries)
{
    ENTRY

    tPosition pos = position;
    string line;
    vector<string> playlistData;

    tPath playlistCompletePath = "";
    GetCompletePlaylistPath(playlistCompletePath,playlistPath);

    /*check if playlist exisits */
    ifstream myfile(playlistCompletePath);
    if(!myfile) return MP_ERR_LC_PLAYLIST_NOT_FOUND;

    /*pop the entries into a list*/
    while (std::getline(myfile, line))
    {
        playlistData.push_back(line);
    }
    myfile.close();

    if(deleteAllEntries)
    {
        playlistData.erase(playlistData.begin(),playlistData.end());
    }
    else
    {
        /*check the boundaries*/
        if(position == POSITION_NOT_SET)
        {
            pos = (tPosition)(playlistData.size())-1;
        }

        /*check for position boundary errors*/
        if((int)pos < 0 || (int)pos >= (int)playlistData.size()) { //lint !e574
            return MP_ERR_LC_INVALID_POSITION;
        }

        /*delete the entry from the local list*/
        playlistData.erase(playlistData.begin()+pos);
    }


    /*push the modified entry list into the playlist file*/
    ofstream outfile(playlistCompletePath);
    if ((outfile.rdstate() & std::ifstream::failbit ) != 0)
    {
        ETG_TRACE_USR4(("DeleteEntryFromPlaylist: not sufficient permission "))
        return MP_ERR_LC_PLAYLIST_FILE_PERMISSION;
    }
    ostream_iterator<string> output_iterator(outfile, "\n");
    copy(playlistData.begin(), playlistData.end(), output_iterator);
    if ( ((outfile.rdstate() & std::ifstream::badbit ) != 0))
    {
        ETG_TRACE_USR4(("DeleteEntryFromPlaylist: File operation error"))
        return MP_ERR_LC_PLAYLIST_FILE_OPERATATION;
    }
    else
    {
        outfile.close();
    }


    return MP_NO_ERROR;
}

tResult ListControl::RenameInternalPlaylist(const tDeviceID deviceID, const tPath oldPlaylistName,  const tPlaylistName newPlaylistName)
{
    ENTRY
    tResult res;

    tPath PlaylistName;
    VARTRACE(oldPlaylistName);
    VARTRACE(newPlaylistName);

    tPath playlistCompletePath = "";
    GetCompletePlaylistPath(playlistCompletePath,oldPlaylistName);

    strncpy_r(PlaylistName, oldPlaylistName , sizeof(tPath));
    strtok(PlaylistName,".");
    if(strcmp(PlaylistName,newPlaylistName) == 0)
    {
        return MP_NO_ERROR;
    }


    /*check if playlist exists */
    if (!exists_file(playlistCompletePath)) {
        return MP_ERR_LC_PLAYLIST_NOT_FOUND;
    }

    /*rename the InternalPlaylist title only with respect to the playlist url in the MP Indexed database*/
    res = LocalSPM::GetDBManager().UpdateInternalPlaylist(IN oldPlaylistName, IN newPlaylistName,IN deviceID);
    if (res == MP_ERR_LC_PLAYLIST_MULTIPLE_ENTRIS_FOUND)
    {
        return res;
    }
    else if(res)
    {
        return MP_ERR_LC_PLAYLIST_DATABASE_ERROR;
    }

    /* Inform ListControl that playlist has updated */
    CheckLists(deviceID);

    VARTRACE(res);

    return MP_NO_ERROR;
}



tResult ListControl::DeleteInternalPlaylist(IN const tDeviceID deviceID, IN const tPath playlistName)
{
    ENTRY
    tResult res;
    tPath playlistCompletePath = "";
    GetCompletePlaylistPath(playlistCompletePath,playlistName);



    /*check if playlist exists */
    if (!exists_file(playlistCompletePath)) {
        return MP_ERR_LC_PLAYLIST_NOT_FOUND;
    }

    /*remove the InternalPlaylist from the file system*/
    res = remove( playlistCompletePath );
    if (res) return MP_ERR_LC_PLAYLIST_FILE_OPERATATION;

    /*remove the InternalPlaylist from the MP Indexed database*/
    res = LocalSPM::GetDBManager().DeleteMediaObject(IN deviceID, IN playlistName);
    if (res) return MP_ERR_LC_PLAYLIST_DATABASE_ERROR;

    /* Inform ListControl that playlist has updated */
    CheckLists(deviceID);

    return MP_NO_ERROR;
}

tResult ListControl::CreateMediaPlayerInternalPlaylistList(tListID& listID, tListSize& listSize, const tDeviceID deviceTag)
{
    ENTRY

    tResult res;

    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;

    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    /*map to indexed list API as internal playlist are part of the indexed DB*/
    res = CreateMediaPlayerIndexedList(OUT listID,
            OUT listSize,
            LTY_PLAYLIST_INTERNAL,
            false /*streaming*/,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceTag);
    if (res) return res;

    return MP_NO_ERROR;
}

tResult ListControl::RecreateDatabase(const tLanguageType language)
{
    ENTRY

    tResult res = MP_NO_ERROR;

    /*Create all the lists*/
    res = ReleaseAllLists();
    if(res) return res;

    /*Set the new lanaguage to central configuration*/
    res = LocalSPM::GetDataProvider().SetLanguage(language);
    if(res) return res;

    /*Ask DBManager to recreate the database*/
    res = LocalSPM::GetDBManager().ClearMediaPlayerData();

    return MP_NO_ERROR;
}

tResult ListControl::AddCoverArtAndThumbnail(vector<tMediaObject> &mediaObjectVector)
{
    ENTRY

    tResult res = MP_NO_ERROR;
    tResult res2 = MP_NO_ERROR;

    for(tUInt i=0; i<mediaObjectVector.size(); i++)
    {
        /* has media object an album tag? */
        if ((0 < mediaObjectVector[i].MetadataTag4) && (CTY_IMAGE != mediaObjectVector[i].catType))
        {
            /* get cover art path */
            res = LocalSPM::GetDBManager().GetCoverArtPath(OUT mediaObjectVector[i].coverArtString, IN mediaObjectVector[i].deviceID, IN mediaObjectVector[i].MetadataTag4);
            if (res) res2 = res;


            /* get thumbnail image */
            res = LocalSPM::GetDBManager().GetThumbnailImage(OUT mediaObjectVector[i].thumbnailBlob, IN mediaObjectVector[i].deviceID, IN mediaObjectVector[i].MetadataTag4);
            if (res) res2 = res;
        }
        if(LocalSPM::GetDataProvider().VideoThumbnail() && (FT_VIDEO == mediaObjectVector[i].fileType))
        {
            res = LocalSPM::GetDBManager().GetCoverArtPath(OUT mediaObjectVector[i].coverArtString, IN mediaObjectVector[i].deviceID, IN mediaObjectVector[i].MetadataTag1);
            if (res) res2 = res;
        }
    }

    return res2;
}

tResult ListControl::AddCoverArt(vector<tMediaObject> &mediaObjectVector)
{
    ENTRY

    tResult res = MP_NO_ERROR;
    tResult res2 = MP_NO_ERROR;

    for(tUInt i=0; i<mediaObjectVector.size(); i++)
    {
        /* has media object an album tag? */
        if ((0 < mediaObjectVector[i].MetadataTag4) && (CTY_IMAGE != mediaObjectVector[i].catType))
        {
            /* get cover art path */
            res = LocalSPM::GetDBManager().GetCoverArtPath(OUT mediaObjectVector[i].coverArtString, IN mediaObjectVector[i].deviceID, IN mediaObjectVector[i].MetadataTag4);
            if (res) res2 = res;
        }
        if(LocalSPM::GetDataProvider().VideoThumbnail() && (FT_VIDEO == mediaObjectVector[i].fileType))
        {
            res = LocalSPM::GetDBManager().GetCoverArtPath(OUT mediaObjectVector[i].coverArtString, IN mediaObjectVector[i].deviceID, IN mediaObjectVector[i].MetadataTag1);
            if (res) res2 = res;
        }
    }

    return res2;
}

tResult ListControl::AddThumbnail(vector<tMediaObject> &mediaObjectVector)
{
    ENTRY

    tResult res = MP_NO_ERROR;
    tResult res2 = MP_NO_ERROR;

    for(tUInt i=0; i<mediaObjectVector.size(); i++)
    {
        /* has media object an album tag? */
        if ((0 < mediaObjectVector[i].MetadataTag4) && (CTY_IMAGE != mediaObjectVector[i].catType))
        {
            /* get thumbnail image */
            res = LocalSPM::GetDBManager().GetThumbnailImage(OUT mediaObjectVector[i].thumbnailBlob, IN mediaObjectVector[i].deviceID, IN mediaObjectVector[i].MetadataTag4);
            if (res) res2 = res;
        }
        if(LocalSPM::GetDataProvider().VideoThumbnail() && (FT_VIDEO == mediaObjectVector[i].fileType))
        {
            res = LocalSPM::GetDBManager().GetCoverArtPath(OUT mediaObjectVector[i].coverArtString, IN mediaObjectVector[i].deviceID, IN mediaObjectVector[i].MetadataTag1);
            if (res) res2 = res;
        }
    }

    return res2;
}


tResult ListControl::AddCoverArt(vector<tFiles> &mediaFileVector, const tDeviceID deviceID)
{
    ENTRY

    tResult res = MP_NO_ERROR;

    for(tUInt i=0; i<mediaFileVector.size(); i++)
    {
        /* has media object an album name? */
        if ((FT_IMAGE != mediaFileVector[i].type))
        {
            res = LocalSPM::GetDBManager().GetCoverArtPathByObjectId(OUT mediaFileVector[i].coverArtString, IN deviceID, IN mediaFileVector[i].objectID);
        }
    }
    return res;
}



#if USE_IMAGE_OBJECT
tResult ListControl::ReplaceFilenameWithAbsolutePath(vector<tMediaObject> &mediaObjectVector)
{
    ENTRY
    for(tUInt i=0; i<mediaObjectVector.size(); i++)
    {
        if(CTY_IMAGE == mediaObjectVector[i].catType)
        {
            if(strlen_r(mediaObjectVector[i].mountPoint) && strlen_r(mediaObjectVector[i].fileName))
            {
                tURL filename = { 0 };

                strncpy_r(filename, mediaObjectVector[i].mountPoint, sizeof(filename));

                if(FastUTF8::StartsWith((const FastUTF8::tString)mediaObjectVector[i].fileName, (const FastUTF8::tString)"/")) //lint !e1773
                {
                    if(FastUTF8::EndsWithNC((const FastUTF8::tString)filename, (const FastUTF8::tString)"/")) //lint !e1773
                    {
                        unsigned char *pureFile;
                        /* trim last character if it is "/" */
                        FastUTF8::Split(OUT pureFile, INOUT (unsigned char *)filename);    //lint !e1773

                    }
                }
                /* add "/" in between mount point and file name if it is missing. */
                else if(NULL == FastUTF8::EndsWithNC((const FastUTF8::tString)filename, (const FastUTF8::tString)"/")) //lint !e1773
                {

                    strncat_r(filename, "/", sizeof(filename));
                }

                strncat_r(filename, mediaObjectVector[i].fileName, sizeof(filename));
                strncpy_r(mediaObjectVector[i].fileName, filename, sizeof(filename));
            }
        }
    }
    return MP_NO_ERROR;
}
#endif

tResult ListControl::FolderProcessing(tRowNumber &newRow,tListID &listID,tPath &path, const int stepCount,const tBoolean isEmptyListIDNeeded)
{
    ENTRY
    VARTRACE(path);

    tResult ret = MP_NO_ERROR;
    tRepeatMode repeatMode = RPT_INVALID;

    //Donot try playing a Folder if repeatmode is anything other than  RPT_ALL_LISTS.
    ret = GetRepeatMode(OUT repeatMode);
    if (RPT_ALL_LISTS != repeatMode)
    {
        return MP_ERR_LC_GENERAL_ERROR ;
    }

    //Get the DeviceID
    tListInfo listInfo;
    ret = GetListInfo(OUT listInfo, IN listID, IN false/* withListSize */);
    if(ret) return ret;

    /* Step 1: For the given path,Create FileList of MediaObjects(Audio,Video,Directory)
     * Step 2: Check the ListSize.
     * case a: If ListSize is zero,Return MP_ERR_LC_EMPTY_LIST.In addition,give the listID to the caller if they need it.
     * case b: If ListSize is not zero,find the Row to be played in the created List.
     * Step 3: Check the FileType of the rowItem
     * case a: If FielType is Audio/Video ,return the rowNumber and ListID for Playback
     * case b: Else,the rowItem must be a Folder.Hence,repeat from Step 1 until an Audio/video file found
     */

    tListID newListID = LIST_ID_NONE;
    ret = CreateFileListOfMediaObjects(OUT newListID,
            IN path,
            IN listInfo.deviceID,
            IN false /*withSubFolders*/);
    if(ret) return ret;

    //Get the List Pointer
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN newListID);
    if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

    tListSize listSize = 0;
    ret = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN listPtr->dbBrowseListID);
    if (ret) return ret;

    // If Folder has items,then find an audio/video object in the list to play
    if(listSize)
    {
        if (stepCount > 0) // forward stepping:
        {
            newRow = 0; // start of list
        }
        else // backward stepping
        {
            newRow = listSize-1; // last object in list
        }

        /*
         * If the list is in shuffle mode and a shuffle list is present:
         * return the first element of the shuffle list
         */
        if (listPtr->isInShuffleMode)
        {
            if (listPtr->shuffleTable) {

                /* if customer wants to re-shuffle list on wrapping, do it here */
                if (LocalSPM::GetDataProvider().ShuffleReshuffleOnListWrap()) {

                    /* reshuffle the list */
                    ret = ReshuffleShuffleTable(INOUT listPtr);

                    if (ret != MP_NO_ERROR) {

                        ETG_TRACE_ERR(("ListControl::FolderProcessing : reShuffle failed: %d", ret));

                        /* shuffling off now */
                        listPtr->isInShuffleMode = 0;
                    } else {
                        /* select first song to play from new shuffle list */
                        newRow = listPtr->shuffleTable[newRow];
                    }

                } else { // no new reshuffle:

                    /* select first song to play from old shuffle list */
                    newRow = listPtr->shuffleTable[newRow];
                }

            } else {
                ETG_TRACE_ERR(("ListControl::FolderProcessing : no shuffleTable - switch shuffleMode off"));
                listPtr->isInShuffleMode = 0;
            }
        }

        /* set the  media object */
        ret = LocalSPM::GetDBManager().SetCurrentRow(IN listPtr->dbBrowseListID, IN newRow);
        if (ret) return ret;

        /* get media object */
        tMediaObject mediaObject;
        ret = LocalSPM::GetDBManager().GetCurrentMediaObject(OUT mediaObject, IN listPtr->dbBrowseListID);
        if (ret) return ret;

        if((FT_AUDIO == mediaObject.fileType) || (FT_VIDEO == mediaObject.fileType))
        {
            listID = newListID;
            if(FNP_PLAYABLE != mediaObject.notPlayable)
            {
                return MP_ERR_LC_POSITION_NOT_PLAYABLE; //ListControl::NextProcessing will take care to play if any item available after this in this list
            }
        }
        else if(FT_FOLDER == mediaObject.fileType)//It must be Folder.
        {
            ret = FolderProcessing(INOUT newRow,IN newListID,IN mediaObject.fileName,IN stepCount,isEmptyListIDNeeded);

            if(MP_NO_ERROR == ret ||
                    MP_ERR_LC_POSITION_NOT_PLAYABLE == ret ||
                    (MP_ERR_LC_EMPTY_LIST == ret && isEmptyListIDNeeded ))
            {
                listID = newListID;
            }
        }
        else //Unexpected FileType
        {
            listID = newListID;
            return MP_ERR_LC_POSITION_NOT_PLAYABLE;
        }
    }
    else
    {
        if(isEmptyListIDNeeded)
        {
            listID = newListID;
        }

        return MP_ERR_LC_EMPTY_LIST; //If Folder is empty,Just return.ListControl::NextProcessing will take care
    }
    return ret;
}

tResult ListControl::CreateFollowingFileList(tRowNumber &newRow,tListID &listID, const int stepCount)
{
    ENTRY
    tResult res = MP_NO_ERROR;

    tList *listPtr = NULL;
    tPath parentPath = tPath_init;
    tPath folderItem = tPath_init;
    tListSize parentListSize = 0;

    //Get the DeviceID
    tListInfo listInfo;
    res = GetListInfo(OUT listInfo, IN listID, IN false/* withListSize */);
    if(res) return res;

    // Construct the ParentFolder Path
    tPath folderPath = tPath_init;
    res = LocalSPM::GetListControl().GetPath(OUT folderPath, IN listID);
    if(res) return res;

    VARTRACE(folderPath);
    string folderPathString = string(folderPath);

    //If FolderPath is empty,It is an unexpected error.
    if(!folderPathString.size()) return MP_ERR_LC_INVALID_PATH;

    if(PATH_DELIMITER == folderPathString) //We have reached the End of the ROOT folder.Begin replaying the ROOT folder
    {
        return MP_ERR_LC_NO_FURTHER_PARENT;
    }
    else
    {
        //If the Path ends with "/",remove it.
        size_t pos = string::npos;
        pos = folderPathString.find_last_of(PATH_DELIMITER);
        if(pos == (folderPathString.size()-1))
        {
            folderPathString = folderPathString.substr(0,pos);
        }

        pos = folderPathString.find_last_of(PATH_DELIMITER);
        if(pos != string::npos)
        {
            if(pos)
            {
                strncpy_r(parentPath,(folderPathString.substr(0,pos)).c_str(),sizeof(tPath));

            }
            else //ROOT is the parent Folder
            {
                strncpy_r(parentPath,PATH_DELIMITER,sizeof(tPath));
            }
            strncpy_r(folderItem ,(folderPathString.substr(pos+1)).c_str(),sizeof(tPath));

            /* Step 1: Create FileList of MediaObjects of the ParentFolder.
             * Step 2: Position the Currentfolder in the created parentList.
             * Step 3: Make the ParentList as currentList
             * Step 4: Thus calculate the NewRow based on stepcount + ShuffleMode.
             * Step 5: Check whether the NewRow < listSize.
             * case a: If TRUE,Set it as the CurrentRow.If the rowItem is folder,do folder Processing else return the row
             * case b: If FALSE,CreateFollowingFielList for the currentList
             */
            VARTRACE(parentPath);
            VARTRACE(folderItem);

            tListID parentListID = LIST_ID_NONE;
            res = CreateFileListOfMediaObjects(OUT parentListID,
                    IN parentPath,
                    IN listInfo.deviceID,
                    IN false /*withSubFolders*/);
            if(res) return res;

            // Find the Position of the FolderItem in its ParentList
            tPosition position = POSITION_NOT_SET;
            res = GetPositionInList(OUT position,IN parentListID,IN folderItem);
            if(res) return res;

            /* Get the list pointer */
            GET_LIST_POINTER(OUT listPtr, IN parentListID);
            if (!listPtr) return MP_ERR_LC_UNDEFINED_LIST_ID;

            listID = parentListID;

            //Get the Listsize
            res = LocalSPM::GetDBManager().GetListSize(OUT parentListSize, IN listPtr->dbBrowseListID);
            if (res) return res;

            if (stepCount > 0) // forward stepping:
            {
                newRow = ++position; // Item following the Folder
            }
            else // backward stepping
            {
                newRow = position -1; // last object in list
            }
        }
        else { //Unexpected Error happened.FodlerPath without character '/' in it
            return MP_ERR_DB_END_OF_LIST;
        }

        if((ROW_NUMBER_NONE != newRow) && (newRow < parentListSize))
        {
            /*
             * If the list is in shuffle mode and a shuffle list is present:
             * return the first element of the shuffle list
             */
            if (listPtr->isInShuffleMode)
            {
                if (listPtr->shuffleTable) {

                    /* if customer wants to re-shuffle list on wrapping, do it here */
                    if (LocalSPM::GetDataProvider().ShuffleReshuffleOnListWrap()) {

                        /* reshuffle the list */
                        res = ReshuffleShuffleTable(INOUT listPtr);

                        if (res != MP_NO_ERROR) {

                            ETG_TRACE_ERR(("ListControl::CreateFollowingFileList : reShuffle failed: %d", res));

                            /* shuffling off now */
                            listPtr->isInShuffleMode = 0;
                        } else {
                            /* select first song to play from new shuffle list */
                            newRow = listPtr->shuffleTable[newRow];
                        }

                    } else { // no new reshuffle:

                        /* select first song to play from old shuffle list */
                        newRow = listPtr->shuffleTable[newRow];
                    }

                } else {
                    ETG_TRACE_ERR(("ListControl::CreateFollowingFileList: no shuffleTable - switch shuffleMode off"));
                    listPtr->isInShuffleMode = 0;
                }
            }
            /* set the  media object */
            res = LocalSPM::GetDBManager().SetCurrentRow(IN listPtr->dbBrowseListID, IN newRow);
            if (res) return res;

            /* get media object */
            tMediaObject mediaObject;
            res = LocalSPM::GetDBManager().GetCurrentMediaObject(OUT mediaObject, IN listPtr->dbBrowseListID);
            if (res) return res;

            if((FT_AUDIO == mediaObject.fileType) || (FT_VIDEO == mediaObject.fileType))
            {
                //Just inform the Item is not-playable.Listcontrol::NextProcessing will take care to find playable item in the list
                if(mediaObject.notPlayable != FNP_PLAYABLE) return MP_ERR_LC_POSITION_NOT_PLAYABLE;
            }
            else if(FT_FOLDER == mediaObject.fileType)
            {
                res = FolderProcessing(INOUT newRow,INOUT listID,IN mediaObject.fileName,IN stepCount,IN true /*isListIDNeededForEmptyList*/);
                if (res == MP_ERR_LC_EMPTY_LIST)
                {
                    res = CreateFollowingFileList(INOUT newRow,INOUT listID, IN stepCount);
                    if(res) return res;
                }
            }
            else //Unexpected FileType
            {
                return MP_ERR_LC_POSITION_NOT_PLAYABLE;
            }
        }
        else //End of List Reached.Hence,try creating the Following List
        {
            res = CreateFollowingFileList(INOUT newRow,INOUT listID, IN stepCount);
            if(res) return res;
        }
    }
    return res;
}
tResult ListControl::GetPositionInList(tPosition &position, const tListID &listID, const tPath &fileName)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    position = POSITION_NOT_SET;

    // Get the List size
    tListInfo listInfo;
    ret = GetListInfo(OUT listInfo, IN listID, IN true/* withListSize */);
    if(ret) return ret;

    // Get all the MediaFiles in the list
    vector<tFiles> mediaFileVector;
    ret = RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0,listInfo.listSize);
    if(ret) return ret;

    for(tUInt i =0;i<mediaFileVector.size();i++)
    {
        if(0 == strncmp(mediaFileVector[i].fileName,fileName,sizeof(tURL)))
        {
            position = i;
            break;
        }
    }
    if(POSITION_NOT_SET == position) ret = MP_ERR_DB_END_OF_LIST;

    return ret;
}


//tbd.: care that only one thread search exists at a time -otherwhise we get into trouble for sync between the threads
//tbd.: what are cases where list pointer is not there anymore
//tbd.: write thread functions as much reintrant as possible to gain possibility to extend this mechanism to run in parallel
void ListControl::ThreadFctFullTextSearch() //roadmap 160014 'full text search '
{
    ENTRY

    mLockIt[eThreadFct_FullTextSearch].lock();

    ETG_TRACE_USR4(("============================="));
    ETG_TRACE_USR4(("Begin:ThreadFctFullTextSearch"));
    ETG_TRACE_USR4(("============================="));

    tResult res = MP_NO_ERROR;
    tBool bAllElementsFound = FALSE;

    //=============
    //Send First message
    //=============
    res = LocalSPM::GetOutputWrapper().Send_onCreateMediaPlayerListSearchString_MethodReturnFirst(IN m_ParmsFullTextSearch.listIDParent,
            IN m_ParmsFullTextSearch.listID,
            IN m_ParmsFullTextSearch.listSize,
            IN m_ParmsFullTextSearch.deviceID);
    if (res != MP_NO_ERROR)
    {
        ETG_TRACE_FATAL(("[ERROR] ThreadFctFullTextSearch: Error sending MethodReturnFirst"));
    }
    else
    {
        ETG_TRACE_USR4(("ThreadFctFullTextSearch: MethodReturnFirst: listID:%d listSize:%d",m_ParmsFullTextSearch.listID,m_ParmsFullTextSearch.listSize));
    }


    //===============
    //Send middle messages
    //===============
    //first Middle has same value like first to ease testing
    //last middle message has the same values like last message
    res = LocalSPM::GetOutputWrapper().Send_onCreateMediaPlayerListSearchString_MethodReturnMiddle(IN m_ParmsFullTextSearch.listIDParent,
            IN m_ParmsFullTextSearch.listID,
            IN m_ParmsFullTextSearch.listSize,
            IN m_ParmsFullTextSearch.deviceID);
    if (res != MP_NO_ERROR)
    {
        ETG_TRACE_FATAL(("[ERROR] ThreadFctFullTextSearch: Error sending MethodReturnFirst"));
    }
    else
    {
        ETG_TRACE_USR4(("ThreadFctFullTextSearch: MethodReturnMiddle: listID:%d listSize:%d",m_ParmsFullTextSearch.listID,m_ParmsFullTextSearch.listSize));
    }



    tResult ret = MP_NO_ERROR;
    unsigned int searchOffset           = 0;
    unsigned int searchIncrement        = m_ParmsFullTextSearch.searchIncrement;
    tListSize listSizeFoundForIncrement = 0;

    //do further middle search if at least a single element has been found with first seach
    if(m_ParmsFullTextSearch.listSize>0)
    {
        tList *listPtr = NULL;;
        GET_LIST_POINTER(OUT listPtr, IN m_ParmsFullTextSearch.listID);
        if(listPtr)
        {
            mbLoopThreadFct[eThreadFct_FullTextSearch] = TRUE;
        }
        else
        {
            mbLoopThreadFct[eThreadFct_FullTextSearch] = FALSE;
            ETG_TRACE_FATAL(("[ERROR] ThreadFctFullTextSearch: could not get listPtr of listID"));
        }

        while(mbLoopThreadFct[eThreadFct_FullTextSearch])
        {
            //------------------------
            //search using DBManager
            //------------------------
            searchOffset = m_ParmsFullTextSearch.listSize;
            VARTRACE(searchOffset)
            VARTRACE(searchIncrement)
            //search and update member variable
            ret = LocalSPM::GetDBManager().GetListSize(OUT listSizeFoundForIncrement, IN listPtr->dbBrowseListID,IN searchIncrement, IN searchOffset); //this is to searchone element only if nothing is found then listSize=0 is expected
            ETG_TRACE_USR4(("ThreadFctFullTextSearch: old:m_ParmsFullTextSearch.listSize=%d new:m_ParmsFullTextSearch.listSize=%d",
                    m_ParmsFullTextSearch.listSize, m_ParmsFullTextSearch.listSize+listSizeFoundForIncrement));

            m_ParmsFullTextSearch.listSize   += listSizeFoundForIncrement;

            if(ret != MP_NO_ERROR)
            {
                ETG_TRACE_FATAL(("[ERROR]: ret")); //tbd. care more
            }

            //stop condition
            if(listSizeFoundForIncrement < searchIncrement)
            {
                bAllElementsFound = TRUE;
                mbLoopThreadFct[eThreadFct_FullTextSearch] = FALSE;
                ETG_TRACE_USR4(("ThreadFctFullTextSearch: end loop final value found: m_ParmsFullTextSearch.listSize:%d",m_ParmsFullTextSearch.listSize))
            }
            if(listSizeFoundForIncrement > 0) //don't send if nothing has been found
            {
                //=====================
                //Send further middle messages
                //=====================
                //-----------------------------------------------------
                //Alternative1: send middle message directly to outputwrapper
                //=========================================
                if(m_ParmsFullTextSearch.useNotifyThread == FALSE)
                {
                    res = LocalSPM::GetOutputWrapper().Send_onCreateMediaPlayerListSearchString_MethodReturnMiddle(IN m_ParmsFullTextSearch.listIDParent,
                            IN m_ParmsFullTextSearch.listID,
                            IN m_ParmsFullTextSearch.listSize,
                            IN m_ParmsFullTextSearch.deviceID);

                    if (res != MP_NO_ERROR)
                    {
                        ETG_TRACE_FATAL(("[ERROR] ThreadFctFullTextSearch: Error sending MethodReturnMiddle"));
                    }
                    else
                    {
                        ETG_TRACE_USR4(("ThreadFctFullTextSearch: MethodReturnMiddle: listID:%d listSize:%d",m_ParmsFullTextSearch.listID,m_ParmsFullTextSearch.listSize));
                    }

                    //------------------------------------------------
                    //!!delay is allowed to be used for test only!!!
                    //used to test aborts
                    //-----------------------------------------------
                    if(m_ParmsFullTextSearch.testDelaySec != tDelaySec_noDelay)
                    {
                        ETG_TRACE_FATAL(("[INFO]: ThreadFctFullTextSearch: test waits for : %d seconds mbLoopThreadFct[eThreadFct_FullTextSearch]: %d",m_ParmsFullTextSearch.testDelaySec,mbLoopThreadFct[eThreadFct_FullTextSearch]));
                        sleep(m_ParmsFullTextSearch.testDelaySec);
                        ETG_TRACE_FATAL(("[INFO]: ThreadFctFullTextSearch: continues after: %d seconds mbLoopThreadFct[eThreadFct_FullTextSearch]: %d",m_ParmsFullTextSearch.testDelaySec,mbLoopThreadFct[eThreadFct_FullTextSearch]));
                    }
                }
                //---------------------------------------------------------------
                //Alternative2: send to thread which sends value more often to output wrapper
                //=================================================
                else
                {

                    //----------------------------------------------------------
                    //send to message queue: receiver is 'ThreadFctFullTextSearchNotify
                    //----------------------------------------------------------
                    m_ParmsFullTextSearch.uMsgLen     = sizeof(tParmsFullText);
                    m_ParmsFullTextSearch.pMsgBuffer  = m_ParmsFullTextSearch.pMsgQ->CreateMessageBuffer (m_ParmsFullTextSearch.uMsgLen);

                    if(m_ParmsFullTextSearch.pMsgBuffer)
                    {
                        //fill it & send it
                        memcpy(m_ParmsFullTextSearch.pMsgBuffer, (void*)(&m_ParmsFullTextSearch), m_ParmsFullTextSearch.uMsgLen);
                        m_ParmsFullTextSearch.pMsgQ->Push(m_ParmsFullTextSearch.pMsgBuffer,
                                m_ParmsFullTextSearch.uMsgLen,
                                m_ParmsFullTextSearch.uMsgPrio);
                    }
                    else
                    {
                        ETG_TRACE_FATAL(("[ERROR] creation of buffer failed"));
                    }
                }
            }
        }
    }
    else if(m_ParmsFullTextSearch.listSize == 0)
    {
        ETG_TRACE_USR4(("ThreadFctFullTextSearch: size is 0 - care for sending last message"));
        bAllElementsFound = TRUE; //for 0 send first, mid and last message with size 0 - see corresponding test
    }
    else
    {
        ETG_TRACE_FATAL(("ThreadFctFullTextSearch: Unexpected listSize"));
    }

    //==================
    //send last message
    //==================
    if(bAllElementsFound)
    {
        res = LocalSPM::GetOutputWrapper().Send_onCreateMediaPlayerListSearchString_MethodReturnLast(IN m_ParmsFullTextSearch.listIDParent,
                IN m_ParmsFullTextSearch.listID,
                IN m_ParmsFullTextSearch.listSize,
                IN m_ParmsFullTextSearch.deviceID);
        if (res != MP_NO_ERROR)
        {
            ETG_TRACE_FATAL(("[ERROR] ThreadFctFullTextSearch: Error sending MethodReturnLast"));
        }
        else
        {
            ETG_TRACE_USR4(("-----------------------------------"));
            ETG_TRACE_USR4(("Full text search: MethodReturnLast:"));
            ETG_TRACE_USR4(("  m_ParmsFullTextSearch.listIDParent  : %d, ", m_ParmsFullTextSearch.listIDParent));
            ETG_TRACE_USR4(("  m_ParmsFullTextSearch.listID  : %d, ", m_ParmsFullTextSearch.listID));
            ETG_TRACE_USR4(("  m_ParmsFullTextSearch.listSize      : %d, ", m_ParmsFullTextSearch.listSize));
            ETG_TRACE_USR4(("  m_ParmsFullTextSearch.deviceID      : %d, ", m_ParmsFullTextSearch.deviceID));
            ETG_TRACE_USR4(("-----------------------------------"));
            ETG_TRACE_USR4(("ThreadFctFullTextSearch: MethodReturnLast: listID:%d listSize:%d",m_ParmsFullTextSearch.listID,m_ParmsFullTextSearch.listSize));
        }
    }
    else
    {
        res = LocalSPM::GetOutputWrapper().Send_onCreateMediaPlayerListSearchString_MethodReturnAbort(IN m_ParmsFullTextSearch.listIDParent,
                IN m_ParmsFullTextSearch.listID,
                IN m_ParmsFullTextSearch.listSize,
                IN m_ParmsFullTextSearch.deviceID);
        ETG_TRACE_USR4(("ThreadFctFullTextSearch: Search stopped before last element found"));
    }

    ETG_TRACE_USR4(("============================="));
    ETG_TRACE_USR4(("End:ThreadFctFullTextSearch"));
    ETG_TRACE_USR4(("============================="));

    mLockIt[eThreadFct_FullTextSearch].unlock();

    tBool bLastFTSThread = TRUE;
    ThreadFctFullTextSearchStop(bLastFTSThread); //care to finish dependent thread

    ETG_TRACE_USR1(("ThreadFctFullTextSearch finshed!"));

}

void ListControl::ThreadFctFullTextSearchNotify() //roadmap 160014 'full text search ' use to send middle messages only
{
    ENTRY
    mLockIt[eThreadFct_FullTextSearchNotify].lock();

    tResult res = MP_NO_ERROR;

    tParmsFullText oParmsFullText;

    oParmsFullText.listIDParent = tListID_init;
    oParmsFullText.listID       = tListID_init;
    oParmsFullText.listSize     = tListSize_init;
    oParmsFullText.deviceID     = tDeviceID_init;

    mbLoopThreadFct[eThreadFct_FullTextSearchNotify] = TRUE;
    while(mbLoopThreadFct[eThreadFct_FullTextSearchNotify])
    {

        //receive from message queue
        void         *receive_buffer = NULL;
        size_t        receive_size   = 0;
        receive_buffer = m_ParmsFullTextSearch.pMsgQ->WaitForMessage(&receive_size,m_ParmsFullTextSearch.uMsgQTimout_sec); //blocking function

        //tbd.: adjust underlying message queue to differ if timout has occured of an error
        //----------------
        //payload received
        //----------------
        if(NULL != receive_buffer)
        {
            if(receive_size > 0)
            {
                if(receive_size == sizeof(tParmsFullText))
                {
                    memcpy((void*)&oParmsFullText,receive_buffer,receive_size);
                }
                else
                {
                    ETG_TRACE_FATAL(("[ERROR]:Wrong size of receive_size:%d != sizeof(tParmsFullText)=%d",receive_size,sizeof(tParmsFullText)))
                }
            }
            else
            {
                ETG_TRACE_FATAL(("[ERROR]: receive_size<1 !"));
            }

            //free buffer
            free(receive_buffer);
            receive_buffer = NULL;
        }
        //------------------
        //no payload received
        //------------------
        else
        {
            ETG_TRACE_USR4(("[ERROR]: receive_buffer: NULL! Note timoutMsgQ_sec=%d",m_ParmsFullTextSearch.uMsgQTimout_sec));
        }


        //-----------------------
        //case suppress message
        //-----------------------
        if(   (oParmsFullText.listID   == tListID_init)
                && (oParmsFullText.listSize == tListSize_init)
                && (oParmsFullText.deviceID == tDeviceID_init))
        {
            ETG_TRACE_USR4(("[info]: suppress message - no content yet"));
        }
        //---------------------------------------------------------------------------------------------------------------
        //case send message either send because something has received from queue or because  of time out (last received content send again)
        //---------------------------------------------------------------------------------------------------------------
        else
        {
            res = LocalSPM::GetOutputWrapper().Send_onCreateMediaPlayerListSearchString_MethodReturnMiddle(IN oParmsFullText.listIDParent,
                    IN oParmsFullText.listID,
                    IN oParmsFullText.listSize,
                    IN oParmsFullText.deviceID);
            if(MP_NO_ERROR != res)
            {
                ETG_TRACE_FATAL(("[ERROR] ThreadFctFullTextSearchNotify: Send_onCreateMediaPlayerListSearchString_MethodReturnMiddle()"));
            }
            else
            {
                ETG_TRACE_USR4(("[ok]: ThreadFctFullTextSearchNotify: Send_onCreateMediaPlayerListSearchString_MethodReturnMiddle()"));
            }
        }

    }

    mLockIt[eThreadFct_FullTextSearchNotify].unlock();

    ETG_TRACE_USR1(("ThreadFctFullTextSearchNotify: finished"));
}

void ListControl::ThreadFctFullTextSearchStop(tBoolean bCalledByFTSThread)
{
    ENTRY

    ETG_TRACE_USR4(("Begin: ThreadFctFullTextSearchStop bCalledByFTSThread:%d",bCalledByFTSThread));

    mbLoopThreadFct[eThreadFct_FullTextSearch] = FALSE;
    ETG_TRACE_USR4(("ThreadFctFullTextSearchStop: try stop ThreadFctFullTextSearch mbLoopThreadFct[eThreadFct_FullTextSearch]:%d",mbLoopThreadFct[eThreadFct_FullTextSearch]));
    mLockIt[eThreadFct_FullTextSearch].lock();
    mLockIt[eThreadFct_FullTextSearch].unlock();
    ETG_TRACE_USR4(("ThreadFctFullTextSearchStop: Got ThreadFctFullTextSearch stopped"));

    if(m_ParmsFullTextSearch.useNotifyThread == TRUE)
    {

        //stop notification thread bound to search thread
        mbLoopThreadFct[eThreadFct_FullTextSearchNotify] = FALSE;
        mLockIt[eThreadFct_FullTextSearchNotify].lock();

        mLockIt[eThreadFct_FullTextSearchNotify].unlock();
    }

    //delete message queue
    if(m_ParmsFullTextSearch.pMsgQ)
    {
        m_ParmsFullTextSearch.pMsgQ->Flush();
        /* todo: koe2hi: deleting sporadically gives trouble
         delete m_ParmsFullTextSearch.pMsgQ;
         m_ParmsFullTextSearch.pMsgQ = NULL;
         */
    }

    ETG_TRACE_USR4(("End  : ThreadFctFullTextSearchStop bCalledByFTSThread:%d",bCalledByFTSThread));

}


void ListControl::ThreadFctFullTextSearchStart(IN tListID listIDParent,IN tListID listID,IN tListSize listSize,IN tDeviceID deviceID, IN tSearchIncrement searchIncrement, IN tDelaySec testDelaySec) //tbd. care for parameters to be handed over instead of NULL-ponter
{
    ENTRY;
    ETG_TRACE_USR4(("Begin: ThreadFctFullTextSearchStart"));

    //------------------
    //init message queue
    //------------------
    //main payload of queue
    m_ParmsFullTextSearch.listIDParent    = listIDParent;
    m_ParmsFullTextSearch.listID          = listID;
    m_ParmsFullTextSearch.listSize        = listSize;
    m_ParmsFullTextSearch.deviceID        = deviceID;

    m_ParmsFullTextSearch.searchIncrement = searchIncrement;
    m_ParmsFullTextSearch.testDelaySec    = testDelaySec;

    //msgQ
    if(!m_ParmsFullTextSearch.pMsgQ) //only created once
    {
        m_ParmsFullTextSearch.pMsgQ            = new MessageQueue("MsgQFullTextSearch");
    }
    m_ParmsFullTextSearch.uMsgQTimout_sec  = 1;
    m_ParmsFullTextSearch.pMsgBuffer       = NULL;
    m_ParmsFullTextSearch.uMsgPrio         = 0;
    m_ParmsFullTextSearch.useNotifyThread  = FALSE; //<-------need configuration value for this

    LocalSPM::GetThreadFactory().Do(this, eThreadFct_FullTextSearch,NULL);

    if(tDelaySec_noDelay == testDelaySec)
    {
        m_ParmsFullTextSearch.useNotifyThread = FALSE;
        ETG_TRACE_FATAL(("[INFO]: ThreadFctFullTextSearchStart: tDelaySec_noDelay:%d test mode with delay does not use second thread ",tDelaySec_noDelay));
    }


    if(m_ParmsFullTextSearch.useNotifyThread)
    {
        LocalSPM::GetThreadFactory().Do(this, eThreadFct_FullTextSearchNotify,NULL);
    }

    ETG_TRACE_USR4(("End: ThreadFctFullTextSearchStart"));

}




void ListControl::Do(int functionID, void *ptr)
{
    switch(functionID)
    {
        case eThreadFct_FullTextSearch:
        {
            LocalSPM::GetThreadFactory().SetName("eThreadFct_FullTextSearch");
            ThreadFctFullTextSearch();
            break;
        }
        case eThreadFct_FullTextSearchNotify:
        {
            LocalSPM::GetThreadFactory().SetName("eThreadFct_FullTextSearchNotify");
            ThreadFctFullTextSearchNotify();
            break;
        }
        default:
        {
            ETG_TRACE_ERR(("ListControl::Do: No thread defined for functionID: %d", functionID));
            break;
        }
    }
}

tResult ListControl::GetDBSearchMetadata(tMediaObject mediaObject, tMetadata &dbSearchMetadata)
{
    ENTRY

    tResult res =MP_NO_ERROR;

    tCategoryType categoryType;

    /* get the object type first */
    res = LocalSPM::GetDBManager().GetObjectType(OUT categoryType, INOUT mediaObject.objectID);
    if (res) return res;
    VARTRACE(categoryType);

    /* Choose which metadata needs to be functioned based on category type */
    switch(categoryType)
    {
        case CTY_SONG:
            strncpy(OUT dbSearchMetadata,IN mediaObject.title,IN sizeof(dbSearchMetadata));
            break;
        case CTY_GENRE:
            strncpy(OUT dbSearchMetadata,IN mediaObject.MetadataField1,IN sizeof(dbSearchMetadata));
            break;
        case CTY_ARTIST:
            strncpy(OUT dbSearchMetadata,IN mediaObject.MetadataField2,IN sizeof(dbSearchMetadata));
            break;
        case CTY_COMPOSER:
            strncpy(OUT dbSearchMetadata,IN mediaObject.MetadataField3,IN sizeof(dbSearchMetadata));
            break;
        case CTY_ALBUM:
            strncpy(OUT dbSearchMetadata,IN mediaObject.MetadataField4,IN sizeof(dbSearchMetadata));
            break;
        case CTY_PLAYLIST:
            strncpy(OUT dbSearchMetadata,IN mediaObject.title,IN sizeof(dbSearchMetadata));
            break;
            /*ToDo
        case CTY_PODCAST:
            strncpy(OUT dbSearchMetadata,IN mediaObject.title,IN sizeof(dbSearchMetadata));
            break;
        case CTY_AUDIOBOOK:
            strncpy(OUT dbSearchMetadata,IN mediaObject.title,IN sizeof(dbSearchMetadata));
            break;
        case CTY_VIDEO:
            strncpy(OUT dbSearchMetadata,IN mediaObject.title,IN sizeof(dbSearchMetadata));
            break;
             */
        default:
            res = MP_ERR_DB_UNSUPPORTED_CAT_TYPE;
            break;
    }
    return res;
}

tResult ListControl::IgnoreSpecialWordsFromBeginning(tMetadata &dbSearchMetadata)
{
    ENTRY
    VARTRACE(dbSearchMetadata);
    tResult res;

    //convert metadata to String for String operations
    string searchtitle = dbSearchMetadata;
    string specialword;

    for(int i=0;i<SPECIALWORDSCOUNT;i++)
    {
        specialword = SpecialWordsTable[i];
        if(0 == (searchtitle.find(specialword)))  //if the Special word is found at beginning
        {
            searchtitle = searchtitle.substr(specialword.length(),searchtitle.length());  //Create substring from word length to metadata length

            strncpy_r(OUT dbSearchMetadata,IN searchtitle.c_str(),IN sizeof(dbSearchMetadata));  //Copy back to dbSearchMetadata
            ETG_TRACE_USR1(("IgnoreSpecialWordsFromBeginning..New Metadata: %s", dbSearchMetadata));
            break;
        }
    }
    return MP_NO_ERROR;
}

inline void GetCompletePlaylistPath(tPath &playlistCompletePath,const tPath playlistName)
{

    strncpy_r(OUT playlistCompletePath, IN LocalSPM::GetDataProvider().InternalPlaylistStoragePath().c_str(), IN sizeof(playlistCompletePath));
    strncat_r(OUT playlistCompletePath, IN "/", IN sizeof(playlistCompletePath));
    strncat_r(OUT playlistCompletePath, IN playlistName, IN sizeof(playlistCompletePath));
    ETG_TRACE_USR4(("GetCompletePlaylistPath formed: %s", playlistCompletePath));

}
tResult ListControl::ReorderInternalPlaylist(IN const tPath &playlistPath, IN const tDeviceID deviceID, IN const tPosition oldPosition,IN const tPosition newPosition)
{
    ENTRY
    string line;
    vector<string> playlistData;

    tPath playlistCompletePath = "";

    GetCompletePlaylistPath(playlistCompletePath,playlistPath);

    ifstream myfile(playlistCompletePath);
    if(!myfile) return MP_ERR_LC_PLAYLIST_NOT_FOUND;
    while (std::getline(myfile, line))
    {
        playlistData.push_back(line);
    }
    myfile.close();
    if((int)oldPosition < 0 || (int)newPosition > (int)playlistData.size()) { //lint !e574
        return MP_ERR_LC_INVALID_POSITION;
    }
    swap(playlistData[oldPosition],playlistData[newPosition]);
    for(int i=0;i<playlistData.size();i++)
        ETG_TRACE_USR4(("Playlistentries %s",playlistData[i].c_str()))
        ofstream outfile(playlistCompletePath);
    if ( ((outfile.rdstate() & std::ifstream::failbit ) != 0))
    {
        ETG_TRACE_USR4(("ReorderInternalPlaylist: not sufficient permission "))
        return MP_ERR_LC_PLAYLIST_FILE_PERMISSION;
    }
    ostream_iterator<string> output_iterator(outfile, "\n");
    copy(playlistData.begin(), playlistData.end(), output_iterator);
    if ( ((outfile.rdstate() & std::ifstream::badbit ) != 0))
    {
        ETG_TRACE_USR4(("ReorderInternalPlaylist: File operation error"))
        return MP_ERR_LC_PLAYLIST_FILE_OPERATATION;
    }
    else
    {
        outfile.close();
    }
    //update the HMI if the list is changed
    CheckLists(deviceID);
    return MP_NO_ERROR;
}
tResult ListControl::DeleteMediaContent(IN const tDeviceInfo &deviceInfo,IN  const string &mediaObjectUrl, IN tBoolean isNormalMode)
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    if(!isNormalMode)
    {
        ETG_TRACE_USR4(("DeleteMediaContent failed to find the device id %d",deviceInfo.deviceID));
        ret = MP_ERR_DEVICE_NOT_EXIST;
    }
    else
    {
        string filename = deviceInfo.mountPoint;
        filename += mediaObjectUrl;
        ETG_TRACE_USR4(("DeleteMediaContent filepath to be deleted %s", filename.c_str()));

        //Fix for deleting the now playing items
        //if the file which is about to delete is currently playing
        //Check nowplayling list size, if list size>1 --> send next playback
        //if list size == 1 --> send stop
        //Proceed with delete
        tPlaybackAction currentPlaybackAction = PBA_NEXT;
        tNowPlaying nowPlaying;
        tHMIPlaybackState hmiPlaybackState;
        ret = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
        ret = LocalSPM::GetPlayerManager().GetPlaybackState(hmiPlaybackState);
        if(!ret && mediaObjectUrl.c_str())
        {
            if(strcmp(nowPlaying.object.fileName,mediaObjectUrl.c_str()) == 0)
            {
                if( (HMI_PBS_PAUSED != hmiPlaybackState) && ( HMI_PBS_STOPPED != hmiPlaybackState) )
                {
                    ETG_TRACE_USR4(("DeleteMediaContent Need to delete Currently Playing Track %s", nowPlaying.object.fileName));

                    tListSize listSize = 0;
                    /* Get the list pointer */
                    tList *listPtr;
                    GET_LIST_POINTER(OUT listPtr, IN nowPlaying.listID);
                    if (listPtr)
                    {
                        /* get size of list */
                        ret = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN listPtr->dbBrowseListID);
                        if(!ret && listSize>1)
                        {
                            ETG_TRACE_USR4(("DeleteMediaContent Many items are there in the list. Sending next playback"));
                            currentPlaybackAction = PBA_NEXT;
                            LocalSPM::GetPlayerManager().SendPlaybackAction(PBA_NEXT);
                        }
                        else if(1 == listSize)
                        {
                            ETG_TRACE_USR4(("DeleteMediaContent Only one item is there in the list. Sending stop playback"));
                            currentPlaybackAction = PBA_STOP;
                            LocalSPM::GetPlayerManager().SendPlaybackAction(PBA_STOP);

                        }
                    }

                    int sleepCount = 25;/*Maximum waiting time = 2.5 seconds*/
                    do
                    {
                        usleep(100000);//sleep 100ms
                        tNowPlaying newNowPlaying;
                        ret = LocalSPM::GetPlayerManager().GetNowPlaying(OUT newNowPlaying);
                        if(!ret)
                        {
                            ret = LocalSPM::GetPlayerManager().GetPlaybackState(hmiPlaybackState);
                            VARTRACE(nowPlaying.object.objectID);
                            VARTRACE(newNowPlaying.object.objectID);
                            VARTRACE(newNowPlaying.state);
                            VARTRACE(hmiPlaybackState);
                            /*If the next track started playing or if end of the list is reached or if playback gets stopped/paused, then we are ready for deleting the current playing track*/
                            if((!ret) && (nowPlaying.object.objectID != newNowPlaying.object.objectID || NP_LIST_COMPLETE == newNowPlaying.state || HMI_PBS_PAUSED == hmiPlaybackState || HMI_PBS_STOPPED == hmiPlaybackState))
                            {
                                break;
                            }
                        }
                    }while(--sleepCount);
                }
                else
                {
                    ETG_TRACE_USR4(("DeleteMediaContent NOWPLAYING hmiPlaybackstate is %d , Can be deleted", hmiPlaybackState));
                }

            }

            if (!IsSRStorageDevice(IN deviceInfo.deviceType))
            {
                if (0 != unlink(IN filename.c_str()))
                {
                    ETG_TRACE_ERR(("DeleteMediaContent failed to delete the file %s", filename.c_str()));
                    ret = MP_ERR_RD_FILE_PERMISSION;
                }
                else
                {
                    ETG_TRACE_USR4(("DeleteMediaContent unlink successful"));
                    //Even after unlink and deletion of file, the song is played due to startplay triggered by mute_status
                    //TODO check mute_status event
                    //TODO mediaEngine is able to play complete song even after deletion from file system
                    tNowPlaying newNowPlaying;
                    ret = LocalSPM::GetPlayerManager().GetNowPlaying(OUT newNowPlaying);
                    if(!ret)
                    {
                        if(strcmp(newNowPlaying.object.fileName,mediaObjectUrl.c_str()) == 0)
                        {
                            ret = LocalSPM::GetPlayerManager().GetPlaybackState(hmiPlaybackState);
                            if((!ret) && (NP_LIST_COMPLETE == newNowPlaying.state || HMI_PBS_PAUSED == hmiPlaybackState || HMI_PBS_STOPPED == hmiPlaybackState))
                            {
                                //do nothing
                            }
                            else
                            {
                                ret = LocalSPM::GetPlayerManager().SendPlaybackAction(currentPlaybackAction);
                            }
                        }
                    }
                }
            }
            else if(false == GetFileMode(deviceInfo, mediaObjectUrl.c_str()))
            {
                ETG_TRACE_USR4(("DeleteMediaContent inside GetFileMode"));
                if(LocalSPM::GetDataProvider().EnableSRdevice())
                {
                    if(0 != remove(filename.c_str()))
                    {
                        ETG_TRACE_ERR(("Cannot delete temp file: %s", filename.c_str()));
                        ret = MP_ERR_RD_FILE_PERMISSION;
                    }
                }
            }
        }
        else
        {
            ETG_TRACE_ERR(("DeleteMediaContent for SR failed to delete the file %s", mediaObjectUrl.c_str()));
            ret = MP_ERR_RD_FILE_PERMISSION;
        }
        if(!ret)
        {
            ret = LocalSPM::GetDBManager().DeleteMediaObject(IN deviceInfo.deviceID,IN mediaObjectUrl);
            if(ret)
            {
                ETG_TRACE_USR4(("DeleteMediaContent failed to delete the file from database %s ",mediaObjectUrl.c_str()));
                ret = MP_ERR_DB_UNEXPECTED;
            }
            else
            {
                ETG_TRACE_USR4(("DeleteMediaContent  the deletion of file   %s is successful ",mediaObjectUrl.c_str()));

            }
        }
        else
        {
            ETG_TRACE_USR4(("DeleteMediaContent ret not successful %d",ret));
        }
    }
    return ret;
}

tResult ListControl::EditMetaData(IN tEditMetaDataByUrl &editMetaDataByUrl)
{
    ENTRY
    VARTRACE(editMetaDataByUrl);
    tResult ret = MP_NO_ERROR;
    tFileOperationErrorCodes result = LocalSPM::GetUSBControl().EditMetadataOfURL(editMetaDataByUrl);
    if(FILE_OPERATION_OK == result)
    {
        ret = LocalSPM::GetDBManager().UpdateMediaObject(IN editMetaDataByUrl);
        if(ret)
        {
            ETG_TRACE_USR1(("EditMetadata database update failed"));
            ret = MP_ERR_DB_UNEXPECTED;
        }
        else
        {
            ETG_TRACE_USR1(("EditMetadata database update successful"));
        }
    }
    else
    {
        ret = TAG_EDIT_ERROR;
    }
    return ret;
}
//>--Roadmap CMG3G-10221 : 'Scene Recorder '
tResult ListControl::SetFilePermissions(IN const tDeviceInfo deviceInfo,IN  const vector<tFilePermission> &filePermission,OUT tU16 &numofFiles)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    vector<tFilePermission>::const_iterator objit;
    numofFiles = 0;
    tAllParameters parameters;
    tCategoryType type;
    tObjectID obj;
    tBool bReadOnlyInfo = false;

    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_USR1(("SetFilePermissions failed to find the device id %d",deviceInfo.deviceID));
        ret = MP_ERR_DEVICE_NOT_EXIST;
    }
    else if(LocalSPM::GetDataProvider().EnableSRdevice() && IsSRStorageDevice(IN deviceInfo.deviceType))
    {
        for(objit = filePermission.begin();objit<filePermission.end();objit++)
        {
            bReadOnlyInfo = GetFileMode(deviceInfo.deviceID,objit->objectID);
            if(bReadOnlyInfo != objit->readOnly)
            {
                /*File mode change operation will be done only for VIDEO list type*/
                obj = objit->objectID;
                ret = LocalSPM::GetDBManager().GetObjectType(type, obj);
                /* File permition set is only support for Video files
                   for Scene recorder devices*/
                if(type == CTY_VIDEO)
                {
                    if(MP_NO_ERROR == ret)
                    {

                        string filename = deviceInfo.mountPoint;
                        string l_url = objit->url;
                        filename += l_url;

                        memset(parameters,0,sizeof(parameters));
                        strncpy_r(OUT parameters, IN filename.c_str(), IN sizeof(parameters));
                        strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));
                        if(objit->readOnly)
                        {
                            strncat_r(OUT parameters, IN "r", IN sizeof(parameters));
                        }
                        else
                        {
                            strncat_r(OUT parameters, IN "rw", IN sizeof(parameters));
                        }
                        ETG_TRACE_USR1(("command to Change Mode %s", parameters));
#ifdef VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
                        CmdData result;
                        result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_FILE_CHMOD, IN parameters);
                        ret = result.errorNo;
#else
                        ret = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_FILE_CHMOD, IN parameters);
#endif
                        if(ret)
                        {
                            ETG_TRACE_USR1(("SetFilePermissions failed to change mode for file %s", filename.c_str()));
                            ret = MP_ERR_RD_FILE_PERMISSION;
                            break;
                        }
                        numofFiles++;
                        /*Update DB as per file mode set by User*/
                        ret = LocalSPM::GetDBManager().UpdateMediaObject(deviceInfo.deviceID, *objit,filename.c_str());
                    }
                    else
                    {
                        ETG_TRACE_USR1(("SetFilePermissions failed to change file mode from database"));
                        ret = MP_ERR_DB_UNEXPECTED;
                        break;
                    }
                }
                else
                {
                    ETG_TRACE_USR1(("Implementation is only for VIDEO FILE s "));
                    ret = MP_ERR_LC_UNDEFINED_LIST_ID;
                    break;
                }
            }
        }
    }
    else{
        ret = MP_ERR_RD_FILE_PERMISSION;
    }
    if(numofFiles)
    {
        ETG_TRACE_USR1(("SetFilePermissions No of files  %d : ",numofFiles));
    }
    return ret;
}

tResult ListControl::MediaplayerFolderInfo(IN tDeviceID deviceID, IN tPath Path,
        IN tFileTypeSelection fileTypeSelection, OUT tFolderInfo& folderinfo)
{
    ENTRY
    VARTRACE(Path)
    VARTRACE(deviceID)
    VARTRACE(fileTypeSelection)
    tResult retVal= MP_NO_ERROR;
    tCategoryType catrgory = CTY_NONE;

    switch(fileTypeSelection)
    {
        case FTS_AUDIO:
            catrgory = CTY_SONG;
            break;
        case FTS_VIDEO:
            catrgory = CTY_VIDEO;
            break;
        default:
            break;
    }
    /* Sanity check for path */
    std::string localPath = Path;
    localPath = LocalSPM::GetDataProvider().ConvertDbPath(localPath);
        localPath = localPath+"%";

    VARTRACE(localPath.c_str());
    retVal = LocalSPM::GetDBManager().GetFolderSizeInfo(IN deviceID, IN localPath.c_str(), catrgory,folderinfo);
    return retVal;
}

tResult ListControl::ReMountFolder(const tDeviceInfo &deviceInfo, const tBool readPermission)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tAllParameters parameters;

    /*ReMount the Device with file permission read and Write for User
          before changing file mode*/
    memset(parameters,0,sizeof(parameters));
    string mountPoint = deviceInfo.mountPoint;
    string fileType = LocalSPM::GetDataProvider().GetDeviceFileSystemType(deviceInfo.fileSystemType);
    strncpy_r(OUT parameters, IN mountPoint.c_str(), IN sizeof(parameters));
    strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));
    strncat_r(OUT parameters, IN fileType.c_str(), IN sizeof(parameters));
    strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));
    if(true == readPermission)
    {
        strncat_r(OUT parameters, IN "ro ", IN sizeof(parameters));
    }
    else
    {
        strncat_r(OUT parameters, IN "rw ", IN sizeof(parameters));
    }
    ETG_TRACE_USR1(("command to mount device %s", parameters));

#ifdef VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
    CmdData result;
    result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_MOUNT_OPERATION, IN parameters);
    ret = result.errorNo;
#else
    ret = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_MOUNT_OPERATION, IN parameters);
#endif
    return ret;
}

tBoolean ListControl::GetFileMode(const tDeviceInfo &deviceInfo, const char* path)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tBoolean Mode = false;
    mode_t fileMode = 0;



    if(path)
    {
       string Path = path;
       string c_path = LocalSPM::GetDataProvider().ConvertDbPath(deviceInfo.mountPoint);
       c_path+= Path;
       fileMode = getfileMode(c_path.c_str());
       Mode = (fileMode&S_IRUSR) && (!(fileMode&S_IWUSR));
    }
    return Mode;
}
tBoolean ListControl::GetFileMode(IN const tDeviceID deviceID, IN const tObjectID objectID)
{
    ENTRY
    tResult res = MP_NO_ERROR;
    tFileMode fileMode;
    tUserID uId;
    tGroupID gid;
    tBoolean Mode = false;

    res = LocalSPM::GetDBManager().GetFileMode(IN deviceID, objectID, OUT fileMode,OUT uId, OUT gid);
    if(!res)
    {
       Mode = (fileMode&S_IRUSR) && (!(fileMode&S_IWUSR));
    }
    return Mode;
}
//<--Roadmap CMG3G-10221 : 'Scene Recorder '

//Suzuki CRQ 296694 and Bug 265009
tResult ListControl::GetPositionFromShuffleList(IN tListID listID, IN tPosition listPosition, OUT tPosition &shuffleListPosition)
{
    ENTRY
    tResult res = MP_NO_ERROR;
    VARTRACE(listID);
    VARTRACE(listPosition);
    tList *listPtr = NULL;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (listPtr)
    {
        if( listPtr->isInShuffleMode)
        {
            for(int iList=0; iList<listPtr->sizeOfShuffleTable; iList++)
            {
                if (listPosition == listPtr->shuffleTable[iList])
                {
                    shuffleListPosition = iList;
                    break;
                }
            }
        }
        else
        {
            ETG_TRACE_USR4(("GetPostionFormShuffleList not in suffle mode"));
            res = MP_ERR_LC_INVALID_POSITION;
        }
    }
    else
    {
        res = MP_ERR_LC_UNDEFINED_LIST_ID;
    }
    VARTRACE(shuffleListPosition);
    return res;
}
tIndex ListControl::GetFirstItemFromShuffleList(IN tListID listID)
{
    ENTRY
    VARTRACE(listID);
    tList *listPtr = NULL;
    tIndex firstItem = INDEX_NONE;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if(listPtr)
    {
        if(listPtr->isInShuffleMode)
        {
            if(listPtr->shuffleTable)
            {
                firstItem = listPtr->shuffleTable[0];
            }
            else
            {
                ETG_TRACE_USR4(("ShuffleTable not available for List"));
            }
        }
        else
        {
            ETG_TRACE_USR4(("List is not in shuffle mode "));
        }
    }
    else
    {
        ETG_TRACE_USR4(("Undefined list id"));
    }
    VARTRACE(firstItem);
    return firstItem;
}

tResult ListControl::GetFolderPathToSwitchTo(INOUT tPath& folderPath, IN tDeviceID deviceID, IN tPlaybackAction playbackAction, IN tNextPrevSkipCount nextPrevSkipCount)
{
    ENTRY

    VARTRACE(folderPath);
    VARTRACE(deviceID);
    VARTRACE(playbackAction);
    VARTRACE(nextPrevSkipCount);

    tResult res = MP_NO_ERROR;

    // Find childID of received folderPath wrt the deviceID
    tObjectID childID = OBJECT_ID_NONE;
    res = LocalSPM::GetDBManager().GetChildIDForFolderPath(OUT childID, IN deviceID, IN folderPath);

    if(MP_NO_ERROR == res)
    {
        // Retrieve the FolderHierarchy of the deviceID
        std::map<tDeviceID, vector<tObjectID>>::iterator it = mFolderHierarchy.find(deviceID);
        if (it != mFolderHierarchy.end())
        {
            // Find position of childID in FolderHierarchy
            unsigned long pos = 0;
            tBool bRet = FALSE;

            for (pos = 0 ; pos < it->second.size(); pos++)
            {
                if(it->second[pos] == childID)
                {
                    bRet = TRUE;
                    break;
                }
            }

            // Calculate the position to move to for the folder up/down action
            if(TRUE == bRet)
            {
                VARTRACE(pos);
                VARTRACE(it->second[pos]);

                size_t size = it->second.size();
                VARTRACE(size);

                switch (playbackAction)
                {
                    case PBA_FOLDER_UP:
                    {
                        // Skip to next folders
                        pos = (((pos + nextPrevSkipCount) % size) + size) % size;
                    }
                    break;
                    case PBA_FOLDER_DOWN:
                    {
                        // Skip to previous folders
                        pos = (((long)(pos - nextPrevSkipCount) % (long)size) + size) % size;
                    }
                    break;
                    default:
                    {
                        ETG_TRACE_ERR((" Unsupported playbackAction! "));
                    }
                }

                VARTRACE(pos);
                VARTRACE(it->second[pos]);

                // Find folderPath for the childID wrt the deviceID
                res = LocalSPM::GetDBManager().GetFolderPathForChildID(OUT folderPath, IN it->second[pos], IN deviceID);
            }
            else
            {
                ETG_TRACE_ERR((" ChildID of folder not found in folderHierarchy structure! "));
            }
        }
        else
        {
            ETG_TRACE_ERR((" No folder hierarchy found for device ID! ")); // Ideally this should never happen
        }
    }
    return res;
}

tResult ListControl::UpdateFolderHierarchyForDeviceID(const IN tDeviceID deviceID)
{
    ENTRY

    VARTRACE(deviceID);

    tResult res = MP_NO_ERROR;

    vector<tObjectID> folderHierarchy;
    res = LocalSPM::GetDBManager().GetFolderHierarchyForDeviceID(OUT folderHierarchy, IN deviceID);

    // Root folder is not part of folderhierarchy table in db.
    // Add entry for root folder as childid = 0 so that folder up/down can include root folder also.
    std::vector<tObjectID>::iterator iter = folderHierarchy.begin();
    folderHierarchy.insert ( iter , 0 );

    VARTRACE(folderHierarchy);

    // Retrieve the FolderHierarchy of the deviceID
    std::map<tDeviceID, vector<tObjectID>>::iterator it = mFolderHierarchy.find(deviceID);
    if (it != mFolderHierarchy.end())
    {
        it->second.swap(folderHierarchy);
    }
    else
    {
        mFolderHierarchy.insert( std::pair<tDeviceID,vector<tObjectID>>(IN deviceID, IN folderHierarchy));
    }

    return res;
}

tResult ListControl::GetNumberOfMediaObjects(tListID listID, tNumberOfMediaObjects& numberOfMediaObjects)
{
    ENTRY

    VARTRACE(listID);

    tResult res = MP_NO_ERROR;

    /* Get the list pointer */
    tList *listPtr;
    GET_LIST_POINTER(OUT listPtr, IN listID);
    if (!listPtr)
    {
        res = MP_ERR_LC_UNDEFINED_LIST_ID;
        numberOfMediaObjects = 0;
    }
    else
    {
       /* get the counts */
       tListSize listSize = 0;
       tNumberOfPlayLists numberOfPlayLists = 0;
       tNumberOfFolders numberOfFolders = 0;
       res = LocalSPM::GetDBManager().GetFileListSize(OUT listSize, OUT numberOfMediaObjects, OUT numberOfPlayLists, OUT numberOfFolders, IN listPtr->dbBrowseListID);
    }

    VARTRACE(numberOfMediaObjects);

    return res;
}
