#ifndef _MEDIAPLAYERINTERFACETEST_H_
#define _MEDIAPLAYERINTERFACETEST_H_

#include <cppunit/extensions/HelperMacros.h>

#include "ConfigTest.h"
#include "MediaPlayerInterface.h"
#include "FunctionTracer.h"
#include "LocalSPM.h"
#include "CppUnitDefinitions.h"
#include "Dispatcher.h"
#include "RequestResponseSM.h"
#include "MediaPlayer_ErrorCodes.h"

#include "TypeDefinitions.h"
#include "TimeTrace.h"

#include "SimulationConfiguration.h"
#include "SimulationOutputWrapper.h"
#include "SimulationCustomControl.h"

#include "test_util.h"
#include "Listener.h"

class MediaPlayerInterfaceTest : public CppUnit::TestFixture, cBaseTest
{
    CPPUNIT_TEST_SUITE( MediaPlayerInterfaceTest );
    CPPUNIT_TEST( InitTestsuite );

    /*** Already Startup test case is added in the MediaPlayerStartupTest file - Started ***/
    //CPPUNIT_TEST( CreateMediaPlayer );
    //CPPUNIT_TEST( StateChangeNormal );
    /*** Already Startup test case is added in the MediaPlayerStartupTest file - Ended ***/

    //CPPUNIT_TEST( ConnectDeviceUSBStick);
    //CPPUNIT_TEST( DisconnectDeviceUSBStick);
    //CPPUNIT_TEST( CreateMediaPlayerFileListWithUSBDisconnected );

    //CPPUNIT_TEST( ConnectDeviceUSBStickSeveral);
    //CPPUNIT_TEST( DisconnectDeviceUSBStickSeveral);

    //CPPUNIT_TEST( StressConnectDeviceUSBStick);
    //CPPUNIT_TEST( StressConnectDeviceUSBStickSeveral);

    //Roadmap 13035 Overtemperature
    CPPUNIT_TEST( CDROMInsertedSetOvertempCDROM_ExpectRemoveAtIndexerSM );
    CPPUNIT_TEST( CDROMInsertedSetOvertempCDROM_ExpectRemoveAtPlayerManagerSM );
    CPPUNIT_TEST( CDROMInsertedSetOvertempCDROM_ExpectUpdateMPDeviveConnectionAtOutputWrapper );
    CPPUNIT_TEST( CDROMInsertedSetOvertempCDROM_ExpectUpdateDeviceConnectionAtOutputWrapper );


    CPPUNIT_TEST( PrepareTestValues );   //Do not comment out because static variable mListID, mListSize are set here

    CPPUNIT_TEST( ActiveMediaDeviceSet_ValidDeviceTag );
    CPPUNIT_TEST( ActiveMediaDeviceGet );
    CPPUNIT_TEST( ActiveMediaDeviceSet_InvalidDeviceTag );

    CPPUNIT_TEST( SendAllocate );
    CPPUNIT_TEST( SendSourceActivityOn );

    CPPUNIT_TEST( GetIndexingStateOfexisting );
    CPPUNIT_TEST( GetIndexingStateOfAllDevices );

    CPPUNIT_TEST( CreateMediaPlayerFileList );

    CPPUNIT_TEST( CreateMediaPlayerIndexedList_SONG);
    CPPUNIT_TEST( PlayItemFromListDefaultOffset );

    CPPUNIT_TEST( VideoasAudio3gpTest );
    CPPUNIT_TEST( RenameMusicBoxPlaylistTest );
    CPPUNIT_TEST( EditYomimetadataTest );
    CPPUNIT_TEST( GetPlaybackState );
    CPPUNIT_TEST( SendPlaybackMode_VideoAudio);
    CPPUNIT_TEST( SendPlaybackMode_Random );
    CPPUNIT_TEST( SendPlaybackActionPause );
    CPPUNIT_TEST( SendSeekTo_Absoulte_Pause );
    CPPUNIT_TEST( SendSeekTo_Percentage_Pause );
    CPPUNIT_TEST( SendPlaybackActionPlay );
    CPPUNIT_TEST( GetNowPlaying );
    //#ifndef TARGET_BUILD // TODO: porsch: fix this test
    CPPUNIT_TEST( SendSeekTo_Absoulte_Playing );
    //#endif
    CPPUNIT_TEST( SendPlaybackMode_Normal );
    CPPUNIT_TEST( GetPlaybackMode );
    CPPUNIT_TEST( SendPlaybackActionNext );
    CPPUNIT_TEST( SendRepeatMode_VideoAudio );
    CPPUNIT_TEST( SendRepeatMode_RepeatOne );
    CPPUNIT_TEST( SendSeekTo_Percentage_Playing );
    CPPUNIT_TEST( GetRepeatMode );
    CPPUNIT_TEST( SendPlaybackActionPrev );
    CPPUNIT_TEST( SendPlaybackActionStop ); //Stop is like Pause. We have to resume playback with Play again or AutoPlay is configured
    CPPUNIT_TEST( SendPlaybackActionPlay );

    //Testcases the Use or Ignore of LastMode Pause:NCG3D-25268
    CPPUNIT_TEST( SendPlaybackActionPause );
    CPPUNIT_TEST( DisableAutoPlayInLastModePause );
    CPPUNIT_TEST( SendSourceActivityOff );
    CPPUNIT_TEST( SendDeAllocate );
    CPPUNIT_TEST(SendClearLastModePause);
    CPPUNIT_TEST( ActiveMediaDeviceSet_ValidDeviceTag );
    CPPUNIT_TEST( SendAllocate );
    CPPUNIT_TEST( SendSourceActivityOn );
    CPPUNIT_TEST( CheckPlaybackStatePLAYING );
    CPPUNIT_TEST( SendPlaybackActionPause );
    CPPUNIT_TEST( SendSourceActivityOff );
    CPPUNIT_TEST( SendDeAllocate );
    CPPUNIT_TEST( ActiveMediaDeviceSet_ValidDeviceTag );
    CPPUNIT_TEST( SendAllocate );
    CPPUNIT_TEST( SendSourceActivityOn );
    CPPUNIT_TEST( CheckPlaybackStateSTOPPED);
    CPPUNIT_TEST( EnableAutoPlayInLastModePause );

    CPPUNIT_TEST( SendPlaybackActionPlay );
    CPPUNIT_TEST( SendRepeatMode_Normal );
    CPPUNIT_TEST( SendRepeatMode_RepeatAll );
    CPPUNIT_TEST( SendRepeatMode_InValidParamter );

    CPPUNIT_TEST( GetIndexingStateUnsupportedDevice );
    CPPUNIT_TEST( GetIndexingStateforNewDevice );
    //CPPUNIT_TEST( UpdateIndexingState );

    CPPUNIT_TEST( CreateMediaPlayerIndexedListInvalidTag );
    CPPUNIT_TEST( CreateMediaPlayerIndexedListInvalidDevice );

    CPPUNIT_TEST( CreateMediaPlayerIndexedList_ALBUM_SONG );
    CPPUNIT_TEST( CreateMediaPlayerIndexedList_ARTIST_ALBUM_SONG );

    CPPUNIT_TEST( CreateMediaPlayerIndexedList_COMPOSER_ALBUM_SONG );
    CPPUNIT_TEST( CreateMediaPlayerIndexedList_GENRE_ARTIST_ALBUM );    //Do not comment out because static variable genre, artist, album, composer are set here

    //CPPUNIT_TEST( CreateMediaPlayerIndexedList_PODCAST_EPISODE );     //TODO: No podcasts in DB at the moment

    //CPPUNIT_TEST( CreateMediaPlayerIndexedList_BOOKTITLE_CHAPTER );   //TODO: No audiobooks in DB at the moment
    //CPPUNIT_TEST( CreateMediaPlayerIndexedList_AUTHOR_BOOKTITILE_CHAPTER );   //TODO: No audiobooks in DB at the moment

    CPPUNIT_TEST( CreateMediaPlayerIndexedList_VIDEO_EPISODE );         //Do not comment out because static variable video are set here
    CPPUNIT_TEST( CreateMediaPlayerIndexedList_EPISODE );
    CPPUNIT_TEST( CreateMediaPlayerIndexedList_PLAYLIST_SONG );         //Do not comment out because static variable playlist are set here
    CPPUNIT_TEST( GetImageFileCount );
    CPPUNIT_TEST( PictureViewerAccordingtoFolder );

    CPPUNIT_TEST( GetNowPlayingWithoutFilePlaying );
    CPPUNIT_TEST( GetPlaytimeWithoutFilePlaying );

    // Commented below test case for issue in Shutdown
    //PERFORMANCE,TRACE_LEVEL_USER4,Function:begin,LINE:48,tResult MediaPlayerInterface::CreateMediaPlayerPlaylistList(tListID&, tListSize&, const char*) ->Start time : 2012-12-19 14:15:57 , 623 msec 617 usec
    //DB_MANAGER,TRACE_LEVEL_ERROR,Function:Do,LINE:267,Query::Do:Select:sqlite3_step: SQL logic error or missing database
    CPPUNIT_TEST( CreateMediaPlayerPlaylistList );
    //CPPUNIT_TEST( CreateMediaPlayerPlaylistListInvalidURL );

    CPPUNIT_TEST( CreateQuickPlaylistLTY_GENRE_SONG );
    CPPUNIT_TEST( CreateQuickPlaylistLTY_GENRE_ARTIST_SONG );
    CPPUNIT_TEST( CreateQuickPlaylistLTY_GENRE_ARTIST_ALBUM_SONG );
    CPPUNIT_TEST( CreateQuickPlaylistLTY_GENRE_ARTIST_ALBUM_SONG_TAGALL );
    CPPUNIT_TEST( CreateQuickPlaylistLTY_ARTIST_SONG );
    CPPUNIT_TEST( CreateQuickPlaylistLTY_ARTIST_ALBUM_SONG );
    CPPUNIT_TEST( CreateQuickPlaylistLTY_ARTIST_ALBUM_SONG_TAGALL );
    CPPUNIT_TEST( CreateQuickPlaylistLTY_ALBUM_SONG );
    CPPUNIT_TEST( CreateQuickPlaylistLTY_ALBUM_SONG_TAGALL );
    CPPUNIT_TEST( CreateQuickPlaylistLTY_SONG );
    CPPUNIT_TEST(PlayItemFromListByTagYearList);
    //CPPUNIT_TEST( CreateQuickPlaylistLTY_PODCAST_EPISODE );       //TODO: No podcasts in DB at the moment
    //CPPUNIT_TEST( CreateQuickPlaylistLTY_BOOKTITLE_CHAPTER );     //TODO: No audiobooks in DB at the moment
    CPPUNIT_TEST( CreateQuickPlaylistLTY_COMPOSER_ALBUM_SONG );
    CPPUNIT_TEST( CreateQuickPlaylistLTY_COMPOSER_SONG );
#if defined(TARGET_TEST)
    CPPUNIT_TEST( CreateQuickPlaylistLTY_VIDEO_EPISODE );
#endif
    CPPUNIT_TEST( CreateQuickPlaylistLTY_PLAYLIST_SONG );
    CPPUNIT_TEST( CreateQuickPlaylistLTY_FILELIST_folder );
    CPPUNIT_TEST( CreateQuickPlaylistLTY_FILELIST_playlist );

    CPPUNIT_TEST( CreateMediaPlayerFileListWithInvalidParam );
    CPPUNIT_TEST( CreateMediaPlayerFileList_AllTypes );
    CPPUNIT_TEST( CreateMediaPlayerFileList_AudioVideoPlaylistOnly );
    CPPUNIT_TEST( CreateMediaPlayerFileList_AudioPlaylistOnly );
    CPPUNIT_TEST( CreateMediaPlayerFileList_SecondLevelDir );
    CPPUNIT_TEST( CreateMediaPlayerFileList_ImageOnly_SecondLevelDir );
    CPPUNIT_TEST( CreateMediaPlayerFileList_VideoOnly_SecondLevelDir );
    CPPUNIT_TEST( CreateMediaPlayerFileList_AudioPlaylistOnly_SecondLevelDir );
    CPPUNIT_TEST( CreateMediaPlayerFileList_PlaylistOnly_SecondLevelDir );
    CPPUNIT_TEST( CreateMediaPlayerFileList_AudioOnly_SecondLevelDir );
    CPPUNIT_TEST( CreateMediaPlayerFileList_AudioVideoPlaylistOnly_SecondLevelDir );
    CPPUNIT_TEST( CreateMediaPlayerFileList_AllTypes_SecondLevelDir );
    CPPUNIT_TEST( CreateMediaPlayerFileList_AudioOnly );
    CPPUNIT_TEST( CreateMediaPlayerFileList_VideoOnly);
    CPPUNIT_TEST( CreateMediaPlayerFileList_PlaylistOnly);
    CPPUNIT_TEST( CreateMediaPlayerFileList_ImageOnly);

    CPPUNIT_TEST( PlayMediaPlayerObject );
    CPPUNIT_TEST( RequestMediaPlayerFileListSlice );
    CPPUNIT_TEST( PlayItemFromFileList);
    CPPUNIT_TEST( PlayItemFromCDList);
    CPPUNIT_TEST( RequestMediaPlayerFileListSliceInvalidListId );

    CPPUNIT_TEST( RequestListInformation );
    CPPUNIT_TEST( RequestListInformationInvalidListId );
    CPPUNIT_TEST( SearchKeyboardMediaPlayerListInvalidListId );

    CPPUNIT_TEST( PlayMediaPlayerObjectRepeat );
    CPPUNIT_TEST( PlayMediaPlayerObjectWithSourceDeallocationOff );
    CPPUNIT_TEST( PlayMediaPlayerObjectWithSourceDeallocationOffAndOn );
    CPPUNIT_TEST( PlayMediaPlayerObjectInvalidObjectId );
    CPPUNIT_TEST( PlayMediaPlayerObjectTwice );

    CPPUNIT_TEST( SearchKeyboardMediaPlayerList );
    CPPUNIT_TEST( GetMediaObject );
    //CPPUNIT_TEST( GetMediaObjectInvalidId );
    CPPUNIT_TEST( GetMediaObjectAlbumArtInfo );
    //CPPUNIT_TEST( GetMediaObjectAlbumArtInfoInvalidAlbumArtString );
    CPPUNIT_TEST( GetMediaObjectAlbumArt );
    //CPPUNIT_TEST( GetMediaObjectAlbumArtInvalidAlbumArtString );

    CPPUNIT_TEST( PlayItemFromListDefaultIndexOffset );
    CPPUNIT_TEST( PlayItemFromListDefaultIndex );
    CPPUNIT_TEST( PlayItemFromListWithAudioTurnedOff );
    CPPUNIT_TEST( PlayItemFromListWithAudioTurnedOffAndOn );
    CPPUNIT_TEST( PlayItemFromListInvalidListId );

    CPPUNIT_TEST( GetMediaplayerDeviceConnections );
    CPPUNIT_TEST( SourceChangeSuzuki );

    CPPUNIT_TEST( AddUSBPortNumberInfo );
    CPPUNIT_TEST( UpdateUSBPortNumberInfo );
    CPPUNIT_TEST( RemoveUSBPortNumberInfo );

    CPPUNIT_TEST( ReleaseMediaPlayerList );
    CPPUNIT_TEST( ReleaseMediaPlayerListwithInvalidListId );
    CPPUNIT_TEST( ReleaseActiveMediaPlayerList );
    CPPUNIT_TEST( GetNowPlayingOnReleasedList );
    CPPUNIT_TEST( GetPlaytimeOnReleasedList );
    CPPUNIT_TEST( GetPlaybackStateOnReleasedList );

    CPPUNIT_TEST( ActiveMediaDeviceSet_ValidDeviceTag );

    /*Internal playlist testcases*/
    CPPUNIT_TEST( CreateInternalPlaylist );
    CPPUNIT_TEST( AddEntryToPlaylist1 );
    CPPUNIT_TEST( AddEntryToPlaylist2 );
    CPPUNIT_TEST( AddEntryToPlaylistWithMultipleEntries );

    CPPUNIT_TEST( PlayItemFromInternalPlaylist );
    CPPUNIT_TEST( QuickPlayInternalPlaylist );
    CPPUNIT_TEST(AddFileNamesToPlaylistByTag);
    CPPUNIT_TEST( DeleteEntryFromPlaylist );
    CPPUNIT_TEST( ReorderInternalPlaylist );
    CPPUNIT_TEST( RenameInternalPlaylist );
    CPPUNIT_TEST( DeleteInternalPlaylist );
    CPPUNIT_TEST( InternalPlaylist_InvalidInputsTest );
    CPPUNIT_TEST( PlayItemFromInvalidInternalPlaylist );
    CPPUNIT_TEST( ResetInternalPlaylists );

#if !defined(TARGET_BUILD)
    CPPUNIT_TEST( InsertBTDevice );
    CPPUNIT_TEST( ActivateBTDevice );
    CPPUNIT_TEST( BTDevicePlaybackAction );
    CPPUNIT_TEST( BTDeviceBrowseRootFolder );
    CPPUNIT_TEST( BTDeviceBrowseSubFolder );
    CPPUNIT_TEST( RemoveBTDevice );
#endif

    CPPUNIT_TEST( FindMTPDevice );
    CPPUNIT_TEST( FileBrowseMTPDevice );


#if 0
    //VW NEW test cases
    CPPUNIT_TEST( UCADynamicSort );
#endif


    // start of extended test case list *************************
    CPPUNIT_TEST( SendMuteStatus );
    CPPUNIT_TEST( CreateMediaPlayerFileListExt );
    CPPUNIT_TEST( GetDeviceInfo );
    CPPUNIT_TEST( GetConnectedDeviceCount );
    /*DiPO testcases*/
    CPPUNIT_TEST( GetDiPOCallState );
    CPPUNIT_TEST( GetDiPOCommunications );
    CPPUNIT_TEST( GetDiPOPlaybackRepeatMode );
    CPPUNIT_TEST( GetDiPOPlaybackShuffleMode );
    CPPUNIT_TEST( GetDiPOPlaybackStatus );
    CPPUNIT_TEST( GetDiPONowPlaying );
    CPPUNIT_TEST( GetBTProfileInfo );

    CPPUNIT_TEST( PlayItemFromListByTag );
    CPPUNIT_TEST( GetCurrentFolderPath );

    /*Favorites testcases*/
    CPPUNIT_TEST( StoreFavorites );
    CPPUNIT_TEST( GetFavoriteInfo );
    CPPUNIT_TEST( ActivateFavorite );
    CPPUNIT_TEST( DeleteFavorite );
    CPPUNIT_TEST( ResetFavorites );
    CPPUNIT_TEST( GetAllFavoriteInfo );

    /*** Already the ClearMediaPlayerData test case is there in MediaPlayerTest test suite*****/
    CPPUNIT_TEST( ClearMediaPlayerData );
    CPPUNIT_TEST( SetOutsideTemperature );
    // CPPUNIT_TEST( TransferTags ); Deprecated (iPod classic).
    CPPUNIT_TEST( SendAppControlConnect );
    CPPUNIT_TEST( SendAppControlCommand );
    CPPUNIT_TEST( SendAppControlClose );
    CPPUNIT_TEST( StartAudio );
    CPPUNIT_TEST( StopAudio );
    CPPUNIT_TEST( Reindexing );
    CPPUNIT_TEST( DiagnosisPlaySong );

    CPPUNIT_TEST( StartSlideshow );
    CPPUNIT_TEST( SendSlideshowAction );
    CPPUNIT_TEST( GetSlideshowTime );
    CPPUNIT_TEST( SetSlideshowTime );
    CPPUNIT_TEST( GetNowShowing );
    CPPUNIT_TEST( GetSlideshowState );

    CPPUNIT_TEST( DiPOActiveDevice );
    CPPUNIT_TEST( DiPORoleSwitchRequest );
    CPPUNIT_TEST( DiPORoleSwitchRequiredResult );
    CPPUNIT_TEST( DiPOTransferGPSData );
    CPPUNIT_TEST( DiPOTransferDRData );
    CPPUNIT_TEST( DiPORequestAudioDevice );
    // CPPUNIT_TEST( DiPOReleaseAudioDevice ); No functionality to test
    CPPUNIT_TEST( StopMediaPlaybackResult );
    CPPUNIT_TEST( RequestAVActivationResult );

    //        CPPUNIT_TEST( RestartOfCrashedMediaEngine );

    // end of extended list *****************************

    CPPUNIT_TEST( SetLanguage );
    CPPUNIT_TEST( GetLanguage );
    CPPUNIT_TEST( SetLanguageWithSorting );

    CPPUNIT_TEST( SendSourceActivityOff );
    CPPUNIT_TEST( SendDeAllocate );
    CPPUNIT_TEST( Umount );

    CPPUNIT_TEST( EnableBrowseList );
    CPPUNIT_TEST( CreateMediaPlayerFileList_AllTypes );
    CPPUNIT_TEST( CreateMediaPlayerFileList_AudioVideoPlaylistOnly );
    CPPUNIT_TEST( CreateMediaPlayerFileList_AudioPlaylistOnly );
    CPPUNIT_TEST( CreateMediaPlayerFileList_AudioOnly );
    CPPUNIT_TEST( CreateMediaPlayerFileList_VideoOnly);
    CPPUNIT_TEST( CreateMediaPlayerFileList_PlaylistOnly);
    CPPUNIT_TEST( CreateMediaPlayerFileList_ImageOnly);
    CPPUNIT_TEST( CheckFileListHighlighting );
    //CPPUNIT_TEST( DisableBrowseList );


    /*** Already Startup test case is added in the MediaPlayerShutdownTest file - Started ***/
    //CPPUNIT_TEST( StateChangeOff );
    /*** Already Startup test case is added in the MediaPlayerShutdownTest file - Ended ***/


    CPPUNIT_TEST( EnableCodesetConversion);
    CPPUNIT_TEST( MultipartitionDeviceCheck_3Valid1InvalidPartitions);
    CPPUNIT_TEST( MultipartitionDeviceCheck_AllValidPartitions);
    CPPUNIT_TEST( MultipartitionDeviceCheck_4ValidUSB1ValidPartitions1NonUSB);

    CPPUNIT_TEST( InsertUSBDeviceWithMultiLanguageMediaFiles);
    CPPUNIT_TEST( ActivateDeviceWithMultiLanguageMediaFiles);
    CPPUNIT_TEST( SendAllocate );
    CPPUNIT_TEST( SendSourceActivityOn );
    CPPUNIT_TEST( ValidateMediaObjectsInSysLangEnglish);
    CPPUNIT_TEST( ValidateMediaObjectsInSysLangTurkish);
    CPPUNIT_TEST( ValidateMediaObjectsInSysLangArabic);
    CPPUNIT_TEST( ValidateMediaObjectsInSysLangRussian);
    CPPUNIT_TEST( ValidateMediaObjectsInSysLangCroatian);
    CPPUNIT_TEST( ValidateMediaObjectsInSysLangGerman);
    CPPUNIT_TEST( ValidateMediaObjectsInSysLangJapanese);
    CPPUNIT_TEST( ValidateMediaObjectsInSysLangFrench);
    CPPUNIT_TEST( ValidateMediaObjectsInSysLangThai);
    CPPUNIT_TEST( ValidateMediaObjectsInSysLangGreek);
    CPPUNIT_TEST( GetPositionInCTY_ALBUM);
    CPPUNIT_TEST( GetAndPlayMediaObjectCTY_ALBUM);
    CPPUNIT_TEST( GetAndPlayMediaObjectCTY_SONG);
    CPPUNIT_TEST( GetMediaObjectLTY_PLAYLIST);
    //CPPUNIT_TEST( ValidateEpisodeObjectsInSysLangArabic); --Issue with CodeSetConversion For Videos present.Need to enable once solved

    CPPUNIT_TEST( SendSourceActivityOff );
    CPPUNIT_TEST( SendDeAllocate );

    CPPUNIT_TEST( DisableCodesetConversion);

    CPPUNIT_TEST( SendVideoBrightness );
    CPPUNIT_TEST( SendVideoHue );
    CPPUNIT_TEST( SendVideoSaturation );
    CPPUNIT_TEST( SendVideoContrast );
    CPPUNIT_TEST( SendVideoBrightnessOffset );
    CPPUNIT_TEST( SendVideoHueOffset );
    CPPUNIT_TEST( SendVideoSaturationOffset );

    //Tets cases for Video handling
    CPPUNIT_TEST( EnableSeparateMediaContent );
    CPPUNIT_TEST( EnableFileListBrowsingFromDB );
    CPPUNIT_TEST( InsertUSBWithAudioVideoFiles );
    CPPUNIT_TEST( VerifyMediaFileCountInformation );

    //>--Roadmap CMG3G-10221 : 'Scene Recorder '
    CPPUNIT_TEST(VerifySetFilePermissionMediaObject_Read);
    CPPUNIT_TEST(VerifySetFilePermissionMediaObject_ReadWrite);
    CPPUNIT_TEST(MediaplayerFolderInfo);
    //<--Roadmap CMG3G-10221 : 'Scene Recorder '

    // Browse list verification for large data
    CPPUNIT_TEST( EnableListBrowsingFromDB );
    CPPUNIT_TEST( InsertUSBWithHugeData );

#if 0
    //>--Roadmap 16003 : 'CD Ripping With Gracenote'
    CPPUNIT_TEST(EditTitleMetadata);
    CPPUNIT_TEST(EditArtistMetadata);
    CPPUNIT_TEST(EditAlbumMetadata);
    CPPUNIT_TEST(EditGenreMetadata);
    CPPUNIT_TEST(DeleteMediaContentCurrentMediaObject);
    CPPUNIT_TEST(DeleteMediaWhileIndexingSameDevice);
    CPPUNIT_TEST(DeleteMediaContentForOneFile);
    CPPUNIT_TEST(DeleteMediaWhileIndexingDifferentDevice);
    CPPUNIT_TEST(DeleteMediaContentByURLForAllFile);

    //<--Roadmap 16003 : 'CD Ripping With Gracenote'
#endif
    //CPPUNIT_TEST( ExtractGracenoteMetadataTest );

    //CPPUNIT_TEST( SendAllocate );
    //CPPUNIT_TEST( SendSourceActivityOn );
    //        CPPUNIT_TEST( GetIndexingStateOfexisting );
    //        CPPUNIT_TEST( GetIndexingStateOfAllDevices );
    //        CPPUNIT_TEST( CreateMediaPlayerFileList );
    //        CPPUNIT_TEST( CreateMediaPlayerIndexedList_SONG);
    //        CPPUNIT_TEST( PlayItemFromListDefaultOffset );

    //      CPPUNIT_TEST( SendPlaybackActionPlay );
    //      CPPUNIT_TEST( GetNowPlaying );
    //     CPPUNIT_TEST( SendPlaybackSpeedForward_with_0_2x);
    //     CPPUNIT_TEST( SendPlaybackSpeedForward_with_0_5x);
    //     CPPUNIT_TEST( SendPlaybackSpeedForward_with_2x );

    //     CPPUNIT_TEST( SendPlaybackActionNext);
    //     CPPUNIT_TEST( GetNowPlaying );
    //     CPPUNIT_TEST( SendPlaybackSpeedForward_with_realative_Increase );
    //    CPPUNIT_TEST( SendPlaybackSpeedForward_with_realative_Decrease );

    //    CPPUNIT_TEST( SendPlaybackActionNext);
    //    CPPUNIT_TEST( GetNowPlaying );
    //   CPPUNIT_TEST( SendPlaybackSpeedForward_with_4x );
    //   CPPUNIT_TEST( SendPlaybackSpeedForward_with_8x );

    //     CPPUNIT_TEST( SendPlaybackActionNext);
    //    CPPUNIT_TEST( GetNowPlaying );
    //    CPPUNIT_TEST( SendPlaybackSpeedForward_with_16x );
    //    CPPUNIT_TEST( SendPlaybackSpeedForward_with_32x );

    // CPPUNIT_TEST( SendPlaybackActionNext);
    // CPPUNIT_TEST( GetNowPlaying );
    // CPPUNIT_TEST( SendSeekTo_Absoulte_Playing );
    // CPPUNIT_TEST( SendPlaybackSpeedRewind_with_0_2x);
    // CPPUNIT_TEST( SendPlaybackSpeedRewind_with_0_5x);
    // CPPUNIT_TEST( SendPlaybackSpeedRewind_with_2x);

    // CPPUNIT_TEST( SendPlaybackActionNext);
    // CPPUNIT_TEST( GetNowPlaying );
    // CPPUNIT_TEST( SendSeekTo_Absoulte_Playing );
    // CPPUNIT_TEST( SendPlaybackSpeedRewind_with_4x);
    // CPPUNIT_TEST( SendPlaybackSpeedRewind_with_8x);

    // CPPUNIT_TEST( SendPlaybackActionNext);
    // CPPUNIT_TEST( GetNowPlaying );
    // CPPUNIT_TEST( SendSeekTo_Absoulte_Playing );
    // CPPUNIT_TEST( SendPlaybackSpeedRewind_with_16x);
    // CPPUNIT_TEST( SendPlaybackSpeedRewind_with_32x);



    // CPPUNIT_TEST( SendSourceActivityOff );
    //  CPPUNIT_TEST( SendDeAllocate );

    //>--Roadmap 1615 Internal DVD Drive
#ifdef USE_TESTS_WITH_REAL_DVDDRIVE
    CPPUNIT_TEST(InitTestsuitewithoutDB);
    CPPUNIT_TEST( SendAllocate );
    CPPUNIT_TEST( SendSourceActivityOn );
    CPPUNIT_TEST( DVDDriveInitialization);
    CPPUNIT_TEST( InsertDVD_Device );
    CPPUNIT_TEST( DVD_TemperatureTest );
    CPPUNIT_TEST( DVD_Playback_DVDVideo);
    CPPUNIT_TEST( DVD_TemperatureTest );
    // CPPUNIT_TEST( DVD_RepeatModeTest );
    // CPPUNIT_TEST(checkDVDProperties);
    // CPPUNIT_TEST(changeDVDAudioOutput);
    // CPPUNIT_TEST(changeMultiAngle);
    // CPPUNIT_TEST(changeSubtitle);
    // CPPUNIT_TEST(changeDVDSetupProperties);
    // CPPUNIT_TEST( DVD_Playback_DVDVideo);
    CPPUNIT_TEST( DVD_Eject);
    //   CPPUNIT_TEST( InsertDVD_Device_Data_CD);
    //  CPPUNIT_TEST( DVD_Eject);
    CPPUNIT_TEST( InsertDVD_Device);
    CPPUNIT_TEST( DVD_Playback_DVDVideo_MultiAngle);
    CPPUNIT_TEST( DVD_Eject);
    CPPUNIT_TEST( InsertDVD_Device);
    CPPUNIT_TEST( DVD_Eject);
    CPPUNIT_TEST( InsertDVD_Device_Audio_CD);
    CPPUNIT_TEST( DVD_DoneRipping );
    CPPUNIT_TEST( DVD_PlaybackActions );
    CPPUNIT_TEST(PlayItemFromListByTagAudioCD );
    CPPUNIT_TEST( DVD_PlaybackModeTest );
    CPPUNIT_TEST( DVD_Eject);
    //   CPPUNIT_TEST( InsertDVD_Device_Data_CD);
    //  CPPUNIT_TEST( DVD_Eject);
    //  CPPUNIT_TEST( InsertDVD_Device );
    // CPPUNIT_TEST( DVD_Playback_DVDVideo);
    //CPPUNIT_TEST( DVD_RepeatModeTest );
    //CPPUNIT_TEST( DVD_Eject);
     CPPUNIT_TEST( DVD_DisableAutoRipping);
     CPPUNIT_TEST( InsertDVD_Device_Audio_CD);
     CPPUNIT_TEST( DVD_PlaybackActions );
    //CPPUNIT_TEST( DVD_PlaybackModeTest );
    CPPUNIT_TEST( DVD_Eject);
    //CPPUNIT_TEST(StopDVD);
   // CPPUNIT_TEST(PlayDVD);
    //CPPUNIT_TEST(DVDStorageTableTest);
    //CPPUNIT_TEST( RemoveDVD_Device );
    //<--Roadmap 1615 Internal DVD Drive
#endif
    // Suppressing Lint errors by tagging following line with NOLINT  .. was lint -e578
    CPPUNIT_TEST(TriggerRG);
    CPPUNIT_TEST( SimulateDeviceError );
    CPPUNIT_TEST_SUITE_END();  // NOLINT


public:

    MediaPlayerInterfaceTest();

    //common to all test cases triggered before and after respectively
    void setUp();
    void tearDown();

    void InitTestsuite();
    void EnableBrowseList();
    void DisableBrowseList();

    /************** Interface Test Case Started ******************/
    /**** Start-Up Test Cases  - Started ****/
    void PrepareTestValues();
    void CreateMediaPlayer();
    void StateChangeNormal();
    /**** Start-Up Test Cases  - Ended ****/

    /**** Shut-down Test Cases  - Started ****/
    void StateChangeOff();
    void ClearMediaPlayerData();
    /**** Shut-down Test Cases  - Ended ****/

    void SendAllocate();
    void SendSourceActivityOn();
    void SendSourceActivityOff();
    void SendDeAllocate();

    void SourceChangeSuzuki();

    void GetIndexingStateOfexisting();
    void GetIndexingStateOfAllDevices();
    void GetIndexingStateUnsupportedDevice();
    void GetIndexingStateforNewDevice();
    void UpdateIndexingState();

    void CreateMediaPlayerFileList();
    void UCADynamicSort();
    void CreateMediaPlayerIndexedList_SONG();
    void PlayItemFromListDefaultOffset();
    void GetPlaybackState();
    void PlayItemFromList(tListSize &listSize, tIndex index, tPlaytime offset);
    void SendPlaybackMode_VideoAudio();
    void SendPlaybackMode_Random();
    void SendPlaybackActionPause();
    void SendSeekTo_Absoulte_Pause();
    void SendSeekTo_Percentage_Pause();
    void SendPlaybackActionPlay();
    void GetNowPlaying();
    void GetPlaytime();
    void SendSeekTo_Absoulte_Playing();
    void SendPlaybackMode_Normal();
    void GetPlaybackMode();
    void SendPlaybackActionNext();
    void SendRepeatMode_VideoAudio();
    void SendRepeatMode_RepeatOne();
    void GetRepeatMode();
    void SendSeekTo_Percentage_Playing();
    void SendPlaybackActionPrev();
    void SendPlaybackActionStop();
    void SendRepeatMode_Normal();
    void SendRepeatMode_RepeatAll();
    void SendRepeatMode_InValidParamter();
    void ActiveMediaDeviceSet_ValidDeviceTag();
    void ActiveMediaDeviceGet();
    void ActiveMediaDeviceSet_InvalidDeviceTag();

    void CreateMediaPlayerIndexedListInvalidTag();
    void CreateMediaPlayerIndexedListInvalidDevice();

    void CreateMediaPlayerIndexedList_ALBUM_SONG();
    void CreateMediaPlayerIndexedList_ARTIST_ALBUM_SONG();
    void CreateMediaPlayerIndexedList_COMPOSER_ALBUM_SONG();

    void CreateMediaPlayerIndexedList_GENRE_ARTIST_ALBUM();
    void CreateMediaPlayerIndexedList_PODCAST_EPISODE();
    void CreateMediaPlayerIndexedList_BOOKTITLE_CHAPTER();
    void CreateMediaPlayerIndexedList_AUTHOR_BOOKTITILE_CHAPTER();
    void CreateMediaPlayerIndexedList_VIDEO_EPISODE();
    void CreateMediaPlayerIndexedList_EPISODE();
    void CreateMediaPlayerIndexedList_PLAYLIST_SONG();
    void GetImageFileCount();
    void PictureViewerAccordingtoFolder();

    void GetNowPlayingWithoutFilePlaying();
    void GetPlaytimeWithoutFilePlaying();

    void CreateMediaPlayerPlaylistList();
    void CreateMediaPlayerPlaylistListInvalidURL();
    void CreateQuickPlaylistLTY_GENRE_SONG();
    void CreateQuickPlaylistLTY_GENRE_ARTIST_SONG();
    void CreateQuickPlaylistLTY_GENRE_ARTIST_ALBUM_SONG();
    void CreateQuickPlaylistLTY_GENRE_ARTIST_ALBUM_SONG_TAGALL();
    void CreateQuickPlaylistLTY_ARTIST_SONG();
    void CreateQuickPlaylistLTY_ARTIST_ALBUM_SONG();
    void CreateQuickPlaylistLTY_ARTIST_ALBUM_SONG_TAGALL();
    void CreateQuickPlaylistLTY_ALBUM_SONG();
    void CreateQuickPlaylistLTY_ALBUM_SONG_TAGALL();
    void CreateQuickPlaylistLTY_SONG();
    void CreateQuickPlaylistLTY_PODCAST_EPISODE();
    void CreateQuickPlaylistLTY_BOOKTITLE_CHAPTER();
    void CreateQuickPlaylistLTY_COMPOSER_ALBUM_SONG();
    void CreateQuickPlaylistLTY_COMPOSER_SONG();
    void CreateQuickPlaylistLTY_VIDEO_EPISODE();
    void CreateQuickPlaylistLTY_PLAYLIST_SONG();
    void CreateQuickPlaylistLTY_FILELIST_folder();
    void CreateQuickPlaylistLTY_FILELIST_playlist();
    void CreateMediaPlayerFileListWithInvalidParam();
    void CreateMediaPlayerFileListWithUSBDisconnected();
    void CreateMediaPlayerFileList_AllTypes();
    void CreateMediaPlayerFileList_AudioVideoPlaylistOnly();
    void CreateMediaPlayerFileList_AudioPlaylistOnly();
    void CreateMediaPlayerFileList_AudioOnly();
    void CreateMediaPlayerFileList_VideoOnly();
    void CreateMediaPlayerFileList_PlaylistOnly();
    void CreateMediaPlayerFileList_ImageOnly();
    void CheckFileListHighlighting();
    void RequestMediaPlayerIndexedListSlice();
    void RequestMediaPlayerFileListSlice();
    void PlayItemFromFileList();
    void PlayItemFromCDList();
    void RequestMediaPlayerFileListSliceInvalidListId();
    void ReleaseMediaPlayerList();
    void ReleaseMediaPlayerListwithInvalidListId();
    void ReleaseActiveMediaPlayerList();
    void GetNowPlayingOnReleasedList();
    void GetPlaytimeOnReleasedList();
    void GetPlaybackStateOnReleasedList();
    void RequestListInformation();
    void RequestListInformationInvalidListId();
    void SearchKeyboardMediaPlayerListInvalidListId();

    void SearchKeyboardMediaPlayerList();

    void GetMediaObject();
    //void GetMediaObjectInvalidId();
    void GetMediaObjectAlbumArtInfo();
    void GetMediaObjectAlbumArtInfoInvalidAlbumArtString();
    void GetMediaObjectAlbumArt();
    void GetMediaObjectAlbumArtInvalidAlbumArtString();

    void PlayItemFromListDefaultIndexOffset();
    void PlayItemFromListSendMediaPlayerListchanged();
    void PlayItemFromListDefaultIndex();
    void PlayItemFromListWithAudioTurnedOff();
    void PlayItemFromListWithAudioTurnedOffAndOn();
    void PlayItemFromListCheckContinous();
    void PlayItemFromListInvalidListId();
    void PlayMediaPlayerObject();
    void PlayMediaPlayerObjectRepeat();
    void PlayMediaPlayerObjectWithSourceDeallocationOff();
    void PlayMediaPlayerObjectWithSourceDeallocationOffAndOn();
    void PlayMediaPlayerObjectInvalidObjectId();
    void PlayMediaPlayerObjectTwice();
    void GetNowPlayingWithoutFileCurrentlyPlaying();
    void GetPlaytimeWithoutFileCurrentlyPlaying();
    void GetPlaybackStateWithoutFileCurrentlyPlaying();

    void GetMediaplayerDeviceConnections();

    void AddUSBPortNumberInfo();
    void UpdateUSBPortNumberInfo();
    void RemoveUSBPortNumberInfo();

    /* Internal playlist test cases */
    void CreateInternalPlaylist();
    void AddEntryToPlaylist1();
    void AddEntryToPlaylist2();
    void AddEntryToPlaylistWithMultipleEntries();
    void PlayItemFromInternalPlaylist();
    void QuickPlayInternalPlaylist();
    void DeleteEntryFromPlaylist();
    void RenameInternalPlaylist();
    void DeleteInternalPlaylist();
    void InternalPlaylist_InvalidInputsTest();
    void PlayItemFromInvalidInternalPlaylist();
    void ResetInternalPlaylists();

    /* Internal playlist test cases Ended*/

    /* BT Device source tests*/
    void InsertBTDevice();
    void ActivateBTDevice();
    void BTDevicePlaybackAction();
    void BTDeviceBrowseRootFolder();
    void BTDeviceBrowseSubFolder();
    void RemoveBTDevice();

    /* MTP Device file browse*/
    void FindMTPDevice();
    void FileBrowseMTPDevice();
    void SendVideoBrightness();
    void SendVideoHue();
    void SendVideoSaturation();
    void SendVideoContrast();
    void SendVideoBrightnessOffset();
    void SendVideoHueOffset();
    void SendVideoSaturationOffset();
    /************** Interface Test Case Ended ******************/

    void SendAllocateInvalidAudioDevice();
    void SendDeAllocateInvalidAudioDevice();
    void SendPlaybackActionFstRev();
    void SendPlaybackActionFstForward();

    void SendPlaybackMode_InvalidParam();
    void GetPlaybackMode_NoDevice();
    void GetRepeatMode_NoDevice();

    void ConnectDeviceUSBStick();
    void DisconnectDeviceUSBStick();
    void StressConnectDeviceUSBStick();
    void ConnectDeviceUSBStickSeveral();
    void DisconnectDeviceUSBStickSeveral();
    void StressConnectDeviceUSBStickSeveral();

    void SendMuteStatus();
    void CreateMediaPlayerFileListExt();
    void GetDeviceInfo();
    void GetConnectedDeviceCount();

    void GetDiPOCallState();
    void GetDiPOCommunications();
    void GetDiPOPlaybackRepeatMode();
    void GetDiPOPlaybackShuffleMode();
    void GetDiPOPlaybackStatus();
    void GetDiPONowPlaying();
    void GetBTProfileInfo();

    void PlayItemFromListByTag();
    void GetCurrentFolderPath();

    void StoreFavorites();
    void GetFavoriteInfo();
    void ActivateFavorite();
    void DeleteFavorite();
    void ResetFavorites();

    void GetAllFavoriteInfo();
    void SetOutsideTemperature();
    // void TransferTags(); Deprecated (iPod classic).
    void SendAppControlConnect();
    void SendAppControlCommand();
    void SendAppControlClose();
    void StartAudio();
    void StopAudio();
    void SwapCalls();
    void Reindexing();
    void DiagnosisPlaySong();
    void StartSlideshow();
    void SendSlideshowAction();
    void GetSlideshowTime();
    void SetSlideshowTime();
    void GetNowShowing();
    void GetSlideshowState();
    void RestartOfCrashedMediaEngine();
    void DiPOActiveDevice();
    void DiPORoleSwitchRequest();
    void DiPORoleSwitchRequiredResult();
    void DiPOTransferGPSData();
    void DiPOTransferDRData();
    void DiPORequestAudioDevice();
    void DiPOReleaseAudioDevice();
    void StopMediaPlaybackResult();
    void RequestAVActivationResult();

    void SetLanguage();
    void GetLanguage();
    void SetLanguageWithSorting();
    void Umount();

    //Roadmap 13035 Overtemp
    void CDROMInsertedSetOvertempCDROM_ExpectRemoveAtIndexerSM();
    void CDROMInsertedSetOvertempCDROM_ExpectRemoveAtPlayerManagerSM();
    void CDROMInsertedSetOvertempCDROM_ExpectUpdateMPDeviveConnectionAtOutputWrapper();
    void CDROMInsertedSetOvertempCDROM_ExpectUpdateDeviceConnectionAtOutputWrapper();
    void helperPrepareCDROM(tDeviceInfo &deviceInfoItem);
    void helperChangeDevice(tDeviceInfo deviceInfoItem, const tConnectionState connectionState, const tDisconnectReason disconnectReason);

    void RegisterUpdatePlaybackState();
    void RegisterUpdatePlaytime();
    void RegisterNowPlaying();
    void UpdatePlaybackStateCallback(cTestData*objTestData);
    void PlayMediaPlayerObjectCallback(cTestData*objTestData);
    virtual void testCallback(cTestData *objTestData);
    void GetMediaObjectAlbumArtInfoCallback(cTestData *objTestData);
    void (MediaPlayerInterfaceTest::*funPtr)(cTestData *);

    void EnableCodesetConversion();
    void DisableCodesetConversion();
    void InsertUSBDeviceWithMultiLanguageMediaFiles();
    void ActivateDeviceWithMultiLanguageMediaFiles();
    void ValidateMediaObjectsInSysLangEnglish();
    void ValidateMediaObjectsInSysLangTurkish();
    void ValidateMediaObjectsInSysLangArabic();
    void ValidateMediaObjectsInSysLangRussian();
    void ValidateMediaObjectsInSysLangCroatian();
    void ValidateMediaObjectsInSysLangGerman();
    void ValidateMediaObjectsInSysLangJapanese();
    void ValidateMediaObjectsInSysLangFrench();
    void ValidateMediaObjectsInSysLangThai();
    void ValidateMediaObjectsInSysLangGreek();
    void ValidateEpisodeObjectsInSysLangArabic();
    void GetPositionInCTY_ALBUM();
    void GetAndPlayMediaObjectCTY_ALBUM();
    void GetAndPlayMediaObjectCTY_SONG();
    void GetMediaObjectLTY_PLAYLIST();

    void MultipartitionDeviceCheck_3Valid1InvalidPartitions();
    void MultipartitionDeviceCheck_AllValidPartitions();
    void MultipartitionDeviceCheck_4ValidUSB1ValidPartitions1NonUSB();
    //NCG3D-25268
    void DisableAutoPlayInLastModePause();
    void EnableAutoPlayInLastModePause();
    void SendClearLastModePause();
    void CheckPlaybackStatePLAYING();
    void CheckPlaybackStateSTOPPED();
    //Playbackspeed
    tResult setplaybackspeedNormal();
    void SendPlaybackSpeedForward_with_0_2x();
    void SendPlaybackSpeedForward_with_0_5x();
    void SendPlaybackSpeedForward_with_2x();
    void SendPlaybackSpeedForward_with_4x();
    void SendPlaybackSpeedForward_with_8x();
    void SendPlaybackSpeedForward_with_16x();
    void SendPlaybackSpeedForward_with_32x();
    void SendPlaybackSpeedForward_with_realative_Increase();
    void SendPlaybackSpeedForward_with_realative_Decrease();

    void SendPlaybackSpeedRewind_with_0_2x();
    void SendPlaybackSpeedRewind_with_0_5x();
    void SendPlaybackSpeedRewind_with_2x();
    void SendPlaybackSpeedRewind_with_4x();
    void SendPlaybackSpeedRewind_with_8x();
    void SendPlaybackSpeedRewind_with_16x();
    void SendPlaybackSpeedRewind_with_32x();
    void SendPlaybackSpeedRewind_with_realative_Increase();
    void SendPlaybackSpeedRewind_with_realative_Decrease();
    void SimulateDeviceError();
    void GetDiPOPower();

    //>--Roadmap 16003 : 'CD Ripping With Gracenote'
    void ReorderInternalPlaylist();
    void DeleteMediaContentCurrentMediaObject();
    void DeleteMediaWhileIndexingDifferentDevice();
    void DeleteMediaWhileIndexingSameDevice();
    void DeleteMediaContentForOneFile();
    void DeleteMediaContentByURLs();
    void DeleteMediaContentByURLForAllFile();
    void EditTitleMetadata();
    void EditArtistMetadata();
    void EditAlbumMetadata();
    void EditGenreMetadata();
    //<--Roadmap 16003 : 'CD Ripping With Gracenote'

    //DVD control tests
    void InitTestsuitewithoutDB();
    void  InsertDVD_Device();
    void  InsertDVD_Device_Audio_CD();
    void  DVD_PlaybackActions();
    void  DVD_DoneRipping();
    void DVD_DisableAutoRipping();
    void  DVD_PlaybackModeTest();
    void  DVD_RepeatModeTest();
    void  DVD_Eject();
    void  RemoveDVD_Device();
    void  DVD_Playback_DVDVideo();
    void DVDDriveInitialization();
    void InsertDVD_Device_Data_CD();
    void checkDVDProperties();
    void changeDVDAudioOutput();
    void changeMultiAngle();
    void changeSubtitle();
    void changeDVDSetupProperties();
    void DVD_Playback_DVDVideo_MultiAngle();
    void StopDVD();
    void PlayDVD();
    void PlayItemFromListByTagAudioCD();
    void PlayItemFromListByTagYearList();
    void DVD_TemperatureTest();
    void ExtractGracenoteMetadataTest();
    void RenameMusicBoxPlaylistTest();
    void EditYomimetadataTest();
    void VideoasAudio3gpTest();

    //Video test cases
    void EnableSeparateMediaContent();
    void EnableFileListBrowsingFromDB();
    void InsertUSBWithAudioVideoFiles();
    void VerifyMediaFileCountInformation();
    void TriggerRG();
    //scene recorder test
    void VerifySetFilePermissionMediaObject_Read();
    void VerifySetFilePermissionMediaObject_ReadWrite();
    void MediaplayerFolderInfo();

    //>--Roadmap 16003 : 'CD Ripping With Gracenote'
    void AddFileNamesToPlaylistByTag();
    //<--Roadmap 16003 : 'CD Ripping With Gracenote'

    //Test media content by verifying file list information.
    void EnableListBrowsingFromDB ();
    void InsertUSBWithHugeData();
    void BrowseFileListInfo();
    void CreateMediaPlayerFileList_SecondLevelDir();
    void CreateMediaPlayerFileList_ImageOnly_SecondLevelDir();
    void CreateMediaPlayerFileList_VideoOnly_SecondLevelDir();
    void CreateMediaPlayerFileList_AudioPlaylistOnly_SecondLevelDir();
    void CreateMediaPlayerFileList_PlaylistOnly_SecondLevelDir();
    void CreateMediaPlayerFileList_AudioOnly_SecondLevelDir();
    void CreateMediaPlayerFileList_AudioVideoPlaylistOnly_SecondLevelDir();
    void CreateMediaPlayerFileList_AllTypes_SecondLevelDir();

private:
    TimeTrace ticks;                               /**< time object to trace the time taken by testcases */
    SimulationConfiguration mSimulationConfiguration;
    SimulationOutputWrapper mSimulationOutputWrapper;
    SimulationCustomControl mSimulationCustomControl;
    tResult CheckPlaybackState(const tHMIPlaybackState stateToReach, const int timeoutInSec);
    tResult WaitForPlaytimeUpdate(int sec = 30);
    tResult WaitForTitleUpdate(const char *title, int sec = 20,const tBoolean isVideoObject = false);
    tResult WaitForListID(const tListID listID, int sec = 30);
    void PreparemediaObjectTitleMap(map<string,string> &mediaObjectTitleMap);
    void HelperFileOperations(OUT tDeviceID &deviceID, OUT vector<tMediaObject> &mediaObjectVector);
    void HelperFileOperations(OUT tDeviceID &deviceID, OUT vector<tFiles> &mediaFileVector);
    inline tResult WaitForFileOperationResult();

};

#endif  // _MEDIAPLAYERINTERFACETEST_H_
