#ifndef _INDEXERTEST_H_
#define _INDEXERTEST_H_

#include <cppunit/extensions/HelperMacros.h>

#include "TypeDefinitions.h"
#include "TimeTrace.h"


class IndexerTest : public MTPControlTestUtil, public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( IndexerTest );
    CPPUNIT_TEST( InitTestsuite );    
    CPPUNIT_TEST( DBDeviceInserted );
    CPPUNIT_TEST( DBDeviceConnectedUSB );
    CPPUNIT_TEST( DBDeviceConnectedFlash );
    CPPUNIT_TEST( DBDeviceIndexing );
    CPPUNIT_TEST( DBDeviceRemoved );
    CPPUNIT_TEST( ContinueIndexing );
    CPPUNIT_TEST( DBFreeSpace );
    CPPUNIT_TEST( Reindexing );
    CPPUNIT_TEST( DBDeviceConnectedMTP );
    CPPUNIT_TEST( DBDeviceConnectedExtUserConfig_SuppressDeviceTypes );
    CPPUNIT_TEST( DBDeviceConnectedExtUserConfig_SuppressFilesystems );
    CPPUNIT_TEST( DBDeviceConnectedExtUserConfig_SuppressPartitions );
    CPPUNIT_TEST( EndTestsuite );
    CPPUNIT_TEST_SUITE_END();

public:

    IndexerTest()
    {
        //CID 17793 (#1 of 1): Uninitialized scalar field (UNINIT_CTOR)
        m_iSupportedDeviceTypes = 0;
        m_iSupportedDeviceType_01 = 0;
        m_iSupportedDeviceType_02 = 0;
        m_iSupportedDeviceType_03 = 0;
        m_iSupportedDeviceType_04 = 0;
        m_iSupportedDeviceType_05 = 0;
        m_iSupportedDeviceType_06 = 0;
        m_iSupportedDeviceType_07 = 0;
        m_iSupportedDeviceType_08 = 0;

        m_iSupportedfileSystems = 0;
        m_iSupportedfileSystem_01 = 0;
        m_iSupportedfileSystem_02 = 0;
        m_iSupportedfileSystem_03 = 0;
        m_iSupportedfileSystem_04 = 0;
        m_iSupportedfileSystem_05 = 0;
        m_iSupportedfileSystem_06 = 0;
        m_iSupportedfileSystem_07 = 0;
        m_iSupportedfileSystem_08 = 0;

        m_iSupportedPartitionNumbers = 0;

        m_iUnsupportedDeviceTypeVisible = 0;
        m_iUnsupportedFileSystemVisible = 0;
        m_iUnsupportedPartitionVisible = 0;
    };

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

    /*test cases*/
    void InitTestsuite();
    void EndTestsuite();
    void DBDeviceInserted();
    void DBDeviceConnectedUSB();
    void DBDeviceConnectedMTP();
    void DBDeviceConnectedFlash();
    void DBDeviceIndexing();
    void DBDeviceRemoved();
    void ContinueIndexing();
    void DBFreeSpace();
    void Reindexing();

    void DBDeviceConnectedExtUserConfig_SuppressDeviceTypes();
    void DBDeviceConnectedExtUserConfig_SuppressFilesystems();
    void DBDeviceConnectedExtUserConfig_SuppressPartitions();


private:
    TimeTrace ticks;        /**< time object to trace the time taken by testcases */

    /**< helpers to restore original values of configuration after manipulation of test function */
    int m_iSupportedDeviceTypes;           
    int m_iSupportedDeviceType_01;         
    int m_iSupportedDeviceType_02;         
    int m_iSupportedDeviceType_03;         
    int m_iSupportedDeviceType_04;         
    int m_iSupportedDeviceType_05;         
    int m_iSupportedDeviceType_06;         
    int m_iSupportedDeviceType_07;         
    int m_iSupportedDeviceType_08;         

    int m_iSupportedfileSystems;           
    int m_iSupportedfileSystem_01;         
    int m_iSupportedfileSystem_02;         
    int m_iSupportedfileSystem_03;         
    int m_iSupportedfileSystem_04;         
    int m_iSupportedfileSystem_05;         
    int m_iSupportedfileSystem_06;         
    int m_iSupportedfileSystem_07;         
    int m_iSupportedfileSystem_08;         

    int m_iSupportedPartitionNumbers;         

    int m_iUnsupportedDeviceTypeVisible;
    int m_iUnsupportedFileSystemVisible;
    int m_iUnsupportedPartitionVisible;


    //helper functions for parametriesed tests
    
    void  util_OrigConfigurationStore();
    void  util_OrigConfigurationRestore();
    void  util_TestConfigurationSet();
    void  util_showConfiguration();
    void  util_showdevicesDB(IN tDeviceType f_deviceType, IN char* f_serialNumber);
    void  util_InsertNewDevicetoDB(IN tDeviceType      f_DeviceType,
                                        IN tFileSystemType  fileSystemType,
                                        IN tPartitionNumber f_partitionNumber,
                                        IN char*            f_serialNumber,
                                        IN char*            f_deviceVersion,
                                        IN char*            f_deviceName,
                                        IN char*            f_accessoryName,
                                        IN char*            f_mountPoint,
                                        IN char*            f_UUID
                                        );


    
    tBool util_ExtUserConfigCheckSuppressPartitions(IN tUInt uPartitionNum);
    tBool util_ExtUserConfigCheckSuppressDeviceType(IN tDeviceType eDeviceType);
    tBool util_ExtUserConfigCheckSuppressFilesystems(IN tFileSystemType eFileSystemType);
    tBool util_ExtUserConfigInsertDeviceAndCheck(IN tDeviceState expectedDeviceState,IN tDeviceType eDeviceType, IN tFileSystemType eFileSystemType, IN tUInt uPartitionNum, IN char* strIdentifier);


    tBool util_CompareWithNewDeviceInDB(IN tDeviceID    f_deviceID,
                                                 IN tDeviceType  f_DeviceType,
                                                 IN tFileSystemType  f_fileSystemType,
                                                 IN tPartitionNumber f_partitionNumber,
                                                 IN char*            f_serialNumber,
                                                 IN char*            f_deviceVersion,
                                                 IN char*            f_deviceName,
                                                 IN char*            f_accessoryName,
                                                 IN char*            f_mountPoint,
                                                 IN char*            f_UUID,
                                                 /*configuration dependend*/
                                                 IN tConnectionState f_connectionState,
                                                 IN tDeviceState     f_deviceState,
                                                 IN tIndexingState   f_indexedState
                                                );
    
   
};

#endif  // _INDEXERTEST_H_
