#ifndef _ALBUMARTINDEXERTEST_H_
#define _ALBUMARTINDEXERTEST_H_

#include <cppunit/extensions/HelperMacros.h>

#include "TypeDefinitions.h"
#include "TimeTrace.h"


class AlbumArtIndexerTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( AlbumArtIndexerTest );
    CPPUNIT_TEST( InitTestsuite );
    CPPUNIT_TEST( DBDeviceIDSComplete );
    CPPUNIT_TEST( DBDeviceRemoved );
    CPPUNIT_TEST( ContinueIndexing );
    CPPUNIT_TEST( FreeAlbumArtSpace );
    CPPUNIT_TEST( ChangeFocus );
    CPPUNIT_TEST( EndTestsuite );
    CPPUNIT_TEST_SUITE_END();

public:

    AlbumArtIndexerTest(){};

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

    /*test cases*/
    void InitTestsuite();
    void EndTestsuite();
    void DBDeviceIDSComplete();
    void DBDeviceRemoved();
    void ContinueIndexing();
    void FreeAlbumArtSpace();
    void ChangeFocus();


private:
    TimeTrace ticks;        /**< time object to trace the time taken by testcases */


};

#endif  // _ALBUMARTINDEXERTEST_H_
