#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/AlbumArtIndexerTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include "AlbumArtIndexer.h"
#include "FunctionTracer.h"
#include "LocalSPM.h"
#include "CppUnitDefinitions.h"
#include "Dispatcher.h"
#include "MediaPlayer_ErrorCodes.h"

#include "AlbumArtIndexerTest.h"

/*lint -save -e1401 */

void AlbumArtIndexerTest::setUp()
{
    ticks.begin();
}

void AlbumArtIndexerTest::tearDown()
{
    ticks.elapsed();
}


/**********************************************************************
 * Test cases
 *********************************************************************/

void AlbumArtIndexerTest::InitTestsuite()
{
    ENTRY_TEST

    tResult ret = MP_NO_ERROR;

    /* Recreate the test database without song table */
    //ret = LocalSPM::GetDataProvider().RecreateTestDatabase(true, true);
    //CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Set MY_MEDIA as active device so we can free the DB entries of other devices */
    //ret = LocalSPM::GetDBManager().ActiveMediaDeviceSet(IN MY_MEDIA, true);
    //CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Register DB trigger of indexer */
    ret = LocalSPM::GetAlbumArtIndexer().SwitchDBTrigger(IN TT_ALL, IN TS_ON);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    sleep(1);
}

void AlbumArtIndexerTest::EndTestsuite()
{
    ENTRY_TEST

    tResult ret = MP_NO_ERROR;

    /* Deregister DB trigger of indexer */
    ret = LocalSPM::GetAlbumArtIndexer().SwitchDBTrigger(IN TT_ALL, IN TS_OFF);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Recreate the test database */
    ret = LocalSPM::GetDataProvider().RecreateTestDatabase(true, true);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
}

void AlbumArtIndexerTest::DBDeviceIDSComplete()
{
    ENTRY_TEST

    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tDeviceCount deviceCount = 3;

    /* Get first deviceID */
    tDeviceID deviceID1 = DEVICE_ID_NOT_SET;
    ret = LocalSPM::GetDBManager().GetDevice(OUT deviceID1, DTY_USB, "USB-2");
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Delete all album art entries for a device from the AlbumArts table */
    ret = LocalSPM::GetDBManager().RemoveAlbumArts(IN deviceID1);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Set album art indexing complete flag to false */
    tAlbumArtIndexingComplete completeFlag = false;
    ret = LocalSPM::GetDBManager().SetAlbumArtIndexingComplete(IN deviceID1, IN completeFlag);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    // test intermediate result
    ret = LocalSPM::GetDBManager().GetAlbumArtIndexingComplete(OUT completeFlag, IN deviceID1);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(!completeFlag);

    /* Send DB_DEVICE_INSERTED message to IndexerSM to create scan context */
    ret = LocalSPM::GetIndexer().ParameterDB_DEVICE_INSERTED(OUT parameterString, IN size, IN deviceCount, IN deviceID1);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = LocalSPM::GetIndexer().SendEventByName("DB_DEVICE_INSERTED", IN parameterString);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Send DB_DEVICE_CONNECTED message to IndexerSM */
    ret = LocalSPM::GetIndexer().ParameterDB_DEVICE_CONNECTED(OUT parameterString, IN size, IN deviceCount, IN deviceID1);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = LocalSPM::GetIndexer().SendEventByName("DB_DEVICE_CONNECTED", IN parameterString);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    sleep(1);

    /* Get second deviceID */
    tDeviceID deviceID2 = DEVICE_ID_NOT_SET;
    ret = LocalSPM::GetDBManager().GetDevice(OUT deviceID2, DTY_USB, "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Delete all album art entries for a device from the AlbumArts table */
    ret = LocalSPM::GetDBManager().RemoveAlbumArts(IN deviceID2);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Set album art indexing complete flag to false */
    completeFlag = false;
    ret = LocalSPM::GetDBManager().SetAlbumArtIndexingComplete(IN deviceID2, IN completeFlag);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    // test intermediate result
    ret = LocalSPM::GetDBManager().GetAlbumArtIndexingComplete(OUT completeFlag, IN deviceID2);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(!completeFlag);

    /* Send DB_DEVICE_IDS_COMPLETE message to AlbumArtIndexerSM */
    ret = LocalSPM::GetAlbumArtIndexer().ParameterDB_DEVICE_IDS_COMPLETE(OUT parameterString, IN size, IN deviceCount, IN deviceID2);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = LocalSPM::GetAlbumArtIndexer().SendEventByName("DB_DEVICE_IDS_COMPLETE", IN parameterString);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    // test result
    /* Wait until album art indexing complete flag changes to correct state in DB */
    int retry = 50; //wait at most 5s
    while(retry) {
        usleep(100000); //100ms
        ret = LocalSPM::GetDBManager().GetAlbumArtIndexingComplete(OUT completeFlag, IN deviceID2);
        CPPUNIT_ASSERT(MP_NO_ERROR == ret);
        if(completeFlag) break;
        retry--;
    }
    ETG_TRACE_USR4(("%d retries left", retry));
    CPPUNIT_ASSERT(0 != retry);

    retry = 50; //wait at most 5s
    while(retry) {
        usleep(100000); //100ms
        ret = LocalSPM::GetDBManager().GetAlbumArtIndexingComplete(OUT completeFlag, IN deviceID1);
        CPPUNIT_ASSERT(MP_NO_ERROR == ret);
        if(completeFlag) break;
        retry--;
    }
    ETG_TRACE_USR4(("%d retries left", retry));
    CPPUNIT_ASSERT(0 != retry);
}

void AlbumArtIndexerTest::DBDeviceRemoved()
{
    ENTRY_TEST

    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tDeviceCount deviceCount = 3;

    /* Get deviceID */
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    ret = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Delete all album art entries for a device from the AlbumArts table */
    ret = LocalSPM::GetDBManager().RemoveAlbumArts(IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Set album art indexing complete flag to false */
    tAlbumArtIndexingComplete completeFlag = false;
    ret = LocalSPM::GetDBManager().SetAlbumArtIndexingComplete(IN deviceID, IN completeFlag);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    // test intermediate result
    ret = LocalSPM::GetDBManager().GetAlbumArtIndexingComplete(OUT completeFlag, IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(!completeFlag);

    /* Send DB_DEVICE_IDS_COMPLETE message to AlbumArtIndexerSM */
    ret = LocalSPM::GetAlbumArtIndexer().ParameterDB_DEVICE_IDS_COMPLETE(OUT parameterString, IN size, IN deviceCount, IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = LocalSPM::GetAlbumArtIndexer().SendEventByName("DB_DEVICE_IDS_COMPLETE", IN parameterString);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Send DB_DEVICE_REMOVED message to AlbumArtIndexerSM */
    ret = LocalSPM::GetAlbumArtIndexer().ParameterDB_DEVICE_REMOVED(OUT parameterString, IN size, IN deviceCount, IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = LocalSPM::GetAlbumArtIndexer().SendEventByName("DB_DEVICE_REMOVED", IN parameterString);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    sleep(1);

    // test result
    ret = LocalSPM::GetDBManager().GetAlbumArtIndexingComplete(OUT completeFlag, IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(!completeFlag);
}

void AlbumArtIndexerTest::ContinueIndexing()
{
    ENTRY_TEST

    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tDeviceCount deviceCount = 3;

    /* Get deviceID */
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    ret = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Create an album list without album art entry (not indexed yet) via DBManager */
    tFilterTag1 tag1 = { 0 };
    tFilterTag2 tag2 = { 0 };
    tFilterTag3 tag3 = { 0 };
    tFilterTag4 tag4 = { 0 };
    tListID dbListID;

    ret = LocalSPM::GetDBManager().CreateList(
            OUT dbListID,
            IN deviceID,
            LTY_ALBUM_UNKNOWN_ALBUMART,
            PC_NO_REPEAT,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(LIST_ID_NONE != dbListID);

    /* Get count of album list */
    tListSize oldlistSize;
    ret = LocalSPM::GetDBManager().GetListSize(OUT oldlistSize, IN dbListID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(0 < oldlistSize);

    /* Delete all album art entries for a device from the AlbumArts table */
    ret = LocalSPM::GetDBManager().RemoveAlbumArts(IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Set album art indexing complete flag to false */
    tAlbumArtIndexingComplete completeFlag = false;
    ret = LocalSPM::GetDBManager().SetAlbumArtIndexingComplete(IN deviceID, IN completeFlag);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    // test intermediate result
    ret = LocalSPM::GetDBManager().GetAlbumArtIndexingComplete(OUT completeFlag, IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(!completeFlag);

    /* Send DB_DEVICE_IDS_COMPLETE message to AlbumArtIndexerSM to start indexing */
    ret = LocalSPM::GetAlbumArtIndexer().ParameterDB_DEVICE_IDS_COMPLETE(OUT parameterString, IN size, IN deviceCount, IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = LocalSPM::GetAlbumArtIndexer().SendEventByName("DB_DEVICE_IDS_COMPLETE", IN parameterString);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Wait until number of files of new device is available in DB */
    int retry = 200; //wait at most 2s
    tListSize newlistSize;
    while(retry) {
        usleep(10000); //10ms
        ret = LocalSPM::GetDBManager().GetListSize(OUT newlistSize, IN dbListID);
        CPPUNIT_ASSERT(MP_NO_ERROR == ret);
        CPPUNIT_ASSERT(0 < newlistSize);
        if(newlistSize < oldlistSize) break;
        retry--;
    }
    ETG_TRACE_USR4(("%d retries left", retry));
    CPPUNIT_ASSERT(0 != retry);

    /* Send DB_DEVICE_REMOVED message to AlbumArtIndexerSM to cancel indexing */
    ret = LocalSPM::GetAlbumArtIndexer().ParameterDB_DEVICE_REMOVED(OUT parameterString, IN size, IN deviceCount, IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = LocalSPM::GetAlbumArtIndexer().SendEventByName("DB_DEVICE_REMOVED", IN parameterString);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    sleep(1);

    // test intermediate result
    ret = LocalSPM::GetDBManager().GetAlbumArtIndexingComplete(OUT completeFlag, IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(!completeFlag);


    /* Send DB_DEVICE_IDS_COMPLETE message to AlbumArtIndexerSM to restart indexing again */
    ret = LocalSPM::GetAlbumArtIndexer().ParameterDB_DEVICE_IDS_COMPLETE(OUT parameterString, IN size, IN deviceCount, IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = LocalSPM::GetAlbumArtIndexer().SendEventByName("DB_DEVICE_IDS_COMPLETE", IN parameterString);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    // test result
    /* Wait until album art indexing complete flag changes to correct state in DB */
    retry = 50; //wait at most 5s
    while(retry) {
        usleep(100000); //100ms
        ret = LocalSPM::GetDBManager().GetAlbumArtIndexingComplete(OUT completeFlag, IN deviceID);
        CPPUNIT_ASSERT(MP_NO_ERROR == ret);
        if(completeFlag) break;
        retry--;
    }
    ETG_TRACE_USR4(("%d retries left", retry));
    CPPUNIT_ASSERT(0 != retry);

    ret = LocalSPM::GetDBManager().ReleaseDBList(IN dbListID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
}

void AlbumArtIndexerTest::FreeAlbumArtSpace()
{
    ENTRY_TEST

    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tDeviceCount deviceCount = 3;

    /* Get deviceID which should be freed */
    tDeviceID deviceID1 = DEVICE_ID_NOT_SET;
    ret = LocalSPM::GetDBManager().GetDevice(OUT deviceID1, DTY_USB, "USB-2");
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Delete all album art entries for a device from the AlbumArts table */
    ret = LocalSPM::GetDBManager().RemoveAlbumArts(IN deviceID1);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Set album art indexing complete flag to false */
    tAlbumArtIndexingComplete completeFlag = false;
    ret = LocalSPM::GetDBManager().SetAlbumArtIndexingComplete(IN deviceID1, IN completeFlag);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    // test intermediate result
    ret = LocalSPM::GetDBManager().GetAlbumArtIndexingComplete(OUT completeFlag, IN deviceID1);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(!completeFlag);

    /* Send DB_DEVICE_IDS_COMPLETE message to AlbumArtIndexerSM to (re)-start indexing again */
    ret = LocalSPM::GetAlbumArtIndexer().ParameterDB_DEVICE_IDS_COMPLETE(OUT parameterString, IN size, IN deviceCount, IN deviceID1);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = LocalSPM::GetAlbumArtIndexer().SendEventByName("DB_DEVICE_IDS_COMPLETE", IN parameterString);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    // test intermediate result
    /* Wait until album art indexing complete flag changes to correct state in DB */
    int retry = 50; //wait at most 5s
    while(retry) {
        usleep(100000); //100ms
        ret = LocalSPM::GetDBManager().GetAlbumArtIndexingComplete(OUT completeFlag, IN deviceID1);
        CPPUNIT_ASSERT(MP_NO_ERROR == ret);
        if(completeFlag) break;
        retry--;
    }
    ETG_TRACE_USR4(("%d retries left", retry));
    CPPUNIT_ASSERT(0 != retry);


    /* Reduce limit for max memory on flash used for cover arts to test free space */
    tMemorySize limitCoverArtMemoryOnFlashKB = (tNumberOfMediaObjects)LocalSPM::GetDataProvider().LimitCoverArtMemoryOnFlashKB();
    LocalSPM::GetDataProvider().LimitCoverArtMemoryOnFlashKB = 500;

    /* Get new deviceID */
    tDeviceID deviceID2 = DEVICE_ID_NOT_SET;
    ret = LocalSPM::GetDBManager().GetDevice(OUT deviceID2, DTY_USB, "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Delete all album art entries for a device from the AlbumArts table */
    ret = LocalSPM::GetDBManager().RemoveAlbumArts(IN deviceID2);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Set album art indexing complete flag to false */
    completeFlag = false;
    ret = LocalSPM::GetDBManager().SetAlbumArtIndexingComplete(IN deviceID2, IN completeFlag);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    // test intermediate result
    ret = LocalSPM::GetDBManager().GetAlbumArtIndexingComplete(OUT completeFlag, IN deviceID2);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(!completeFlag);

    /* Send DB_DEVICE_IDS_COMPLETE message to AlbumArtIndexerSM to (re)-start indexing again */
    ret = LocalSPM::GetAlbumArtIndexer().ParameterDB_DEVICE_IDS_COMPLETE(OUT parameterString, IN size, IN deviceCount, IN deviceID2);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = LocalSPM::GetAlbumArtIndexer().SendEventByName("DB_DEVICE_IDS_COMPLETE", IN parameterString);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    // test result
    /* Wait until album art indexing complete flag changes to correct state in DB */
    retry = 50; //wait at most 5s
    while(retry) {
        usleep(100000); //100ms
        ret = LocalSPM::GetDBManager().GetAlbumArtIndexingComplete(OUT completeFlag, IN deviceID2);
        CPPUNIT_ASSERT(MP_NO_ERROR == ret);
        if(completeFlag) break;
        retry--;
    }
    ETG_TRACE_USR4(("%d retries left", retry));
    CPPUNIT_ASSERT(0 != retry);

    /* Reset limit to old value */
    LocalSPM::GetDataProvider().LimitCoverArtMemoryOnFlashKB = limitCoverArtMemoryOnFlashKB;
}

void AlbumArtIndexerTest::ChangeFocus()
{
    ENTRY_TEST

    tResult ret = MP_NO_ERROR;

    /* Get deviceID */
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    ret = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB-2");
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Create an album list via ListControl */
    tListID listID;
    tListSize listSize;
    tStreaming streaming = false;
    tFilterTag1 tag1 = { 0 };
    tFilterTag2 tag2 = { 0 };
    tFilterTag3 tag3 = { 0 };
    tFilterTag4 tag4 = { 0 };

    ret = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_ALBUM,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(LIST_ID_NONE != listID);
    CPPUNIT_ASSERT(0 < listSize);

    /* Delete all album art entries for a device from the AlbumArts table */
    ret = LocalSPM::GetDBManager().RemoveAlbumArts(IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Set album art indexing complete flag to false */
    tAlbumArtIndexingComplete completeFlag = false;
    ret = LocalSPM::GetDBManager().SetAlbumArtIndexingComplete(IN deviceID, IN completeFlag);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    // test intermediate result
    ret = LocalSPM::GetDBManager().GetAlbumArtIndexingComplete(OUT completeFlag, IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(!completeFlag);

    /* Send CHANGE_FOCUS message to AlbumArtIndexerSM to start indexing of new focus */
    tIndex startIndex = listSize / 2;
    tIndex sliceSize = (tIndex)listSize - startIndex;
    ret = LocalSPM::GetAlbumArtIndexer().SendChangeFocus(IN deviceID, IN listID, IN startIndex, IN sliceSize);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    // test result
    /* Create an album list without album art entry (not indexed yet) via ListControl */
    int retry = 5; //wait at most 5s
    tListID newListID;
    tListSize newListSize;
    while(retry) {
        sleep(1);
        ret = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
                OUT newListID,
                OUT newListSize,
                LTY_ALBUM_UNKNOWN_ALBUMART,
                IN streaming,
                IN tag1,
                IN tag2,
                IN tag3,
                IN tag4,
                IN deviceID);
        CPPUNIT_ASSERT(MP_NO_ERROR == ret);
        CPPUNIT_ASSERT(LIST_ID_NONE != newListID);
        if(startIndex == (tIndex)newListSize) break;
        retry--;
    }
    ETG_TRACE_USR4(("%d retries left", retry));
    CPPUNIT_ASSERT(0 != retry);

    ret = LocalSPM::GetDBManager().GetAlbumArtIndexingComplete(OUT completeFlag, IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(!completeFlag);

    ret = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    ret = LocalSPM::GetListControl().ReleaseList(IN newListID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
}

