#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_DEVICE_CONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/IPCProvider.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_DEVICE_CONTROL
#endif
#endif

#include "PlayerEngineIpcIF.h"
#include "LocalSPM.h"
#include "IPCProvider.h"
#include "FunctionTracer.h"
#include "VarTrace.h"

//SPM part

IPCProvider::IPCProvider(const tComponentID componentID):ILocalSPM(componentID) // finished: 100%
{
    ENTRY_INTERNAL

    /* These variables are initialized only once in lifetime */

    m_RegisterSerial = -1;
    m_SetVideoLayerSerial = -1;
    m_SuspendComponent = NULL;
    m_SuspendAudioOutputDevice[0] = '\0';
    mStopThread = 0;
    m_Observer = NULL;
    m_Initialized = false;

    //fix for GMMY17-14978: Playerengine will reserve the object path, to avoid the delay if many clients are trying to access the Playerengine process at the start up
    IpcClient::OverridePath(IN IPC_PLAYER_ENGINE_INSTANCE_INTERFACE,IN IPC_PLAYER_ENGINE_INSTANCE_PATH);

    /* Init IPC service */
    IpcBase::RegisterService(MEDIAPLAYER_SERVICE, MEDIAPLAYER_PATH, MEDIAPLAYER_INTERFACE);
}

IPCProvider::~IPCProvider() // finished: 100%
{
    ENTRY_INTERNAL
}

void IPCProvider::Create()
{
    ENTRY

    CreateDone(0);
}

tResult IPCProvider::Init(tInitReason reason)
{
    ENTRY
    (void)reason;

    /* Initialize variables */
    mLockObserver.lock();
    m_Observer = NULL;
    mLockObserver.unlock();
    m_MethodCalls.clear();
    mStopThread = 0;

    return InitDone(0);
}

tResult IPCProvider::Run()
{
    ENTRY

    /* Create and start threads */
    LocalSPM::GetThreadFactory().Do(IN this, 0, NULL); //IPC client






    return RunDone(0);
}

void IPCProvider::Do(int functionID, void *ptr)
{
    ENTRY
    (void)ptr;

    switch(functionID)
    {
        case 0:
        {
            LocalSPM::GetThreadFactory().SetName("IPCProvider_0");

            //Add all required match rules and call dbus_add_filter for callback function.
            AddFilters();
            // thread is about to run in a loop
            mEndOfThread.lock();

            /* thoemel: set this thread to a higher priority */
            ThreadFactory::SetPriority(50);

            while(!IpcClient::DispatchMessages()) // this is a polling loop for dbus
            {
                // is stopping requested?
                if (mStopThread) break;
            }

#ifndef TARGET_BUILD
            /* Execute the given line (kill all player engine instances) as a shell command */
            //system("killall PlayerEngine"); -> Do it at the end of module tests
#endif

            //Remove all added match rules and call dbus_remove_filter for removing callback functions registered.
            RemoveFilters();

            // signal end of thread
            mEndOfThread.unlock();

            break;
        }
        default:
        {
            ETG_TRACE_ERR(("IPCProvider::Do: No thread defined for functionID: %d", functionID));
            break;
        }
    }
}

tResult IPCProvider::Stop()
{
    ENTRY

    mLockObserver.lock();
    m_Observer = NULL;
    mLockObserver.unlock();
    m_MethodCalls.clear();

    return StopDone(0);
}

tResult IPCProvider::Done()
{
    ENTRY

    // request thread stopping
    mStopThread = 1;

    // wait for end of thread
    mEndOfThread.lock();
    mEndOfThread.unlock();

    return DoneDone(0);
}


void IPCProvider::RegisterListener(IPCListener *listener)
{
    mListeners.push_back(listener);
}

//IPC client callbacks
tBoolean IPCProvider::SignalReceived(const char* name, const char* params)
{
    ENTRY
    // thoemel: to many traces
    //ETG_TRACE_USR1(("##########IPCProvider::SignalReceived Dbus signal -> %128s:%s", name, params));

    unsigned int iter;
    for(iter = 0 ; iter < mListeners.size() ; iter++)
    {
        if(mListeners[iter]->belongs(name, params))
        {
            //ETG_TRACE_USR1(("##########IPCProvider::SignalReceived Dbus signal -> %128s:%s", name, params));
            mListeners[iter]->RouteSignal(name,params);
            return 0x01; /*signal handled*/
        }
    }
    return 0x00; /*signal not handled*/
}

tBoolean IPCProvider::MethodAnswered(dbus_uint32_t serial, const char* params)
{
    ENTRY
    ETG_TRACE_USR1(("##########IPCProvider::MethodAnswered Dbus answer -> serial(%d):%s", serial, params));

    tUInt iter;
    for(iter = 0 ; iter < mListeners.size() ; iter++)
    {
        if(mListeners[iter]->belongs(serial))
        {
            mListeners[iter]->RouteMethodAnswer(serial, params);
            return 0x01; /*method answer handled*/;
        }
    }


    if((m_RegisterSerial == (tInteger)serial))
    {
        m_RegisterSerial = -1;

        tLayerName layerName;
        strncpy(layerName, LocalSPM::GetDataProvider().VideoLayerName().c_str(), sizeof(layerName)-1);
        tUInt layerOrder = LocalSPM::GetDataProvider().VideoLayerOrder();

        /* Send SetVideoLayer to PlayerEngine via DBUS */
        m_SetVideoLayerSerial = IpcClient::MethodCall(ipc_PlayerEngine_SetVideoLayer, IN layerName, IN (int)layerOrder);
        ETG_TRACE_USR4(("Auto send SetVideoLayer serial:%d", m_SetVideoLayerSerial));
        if(0 > m_SetVideoLayerSerial)
        {
            ETG_TRACE_ERR(("Error while sending message via DBus"));
        }

        //Set the display size in playerengine
        tUInt layerWidth = LocalSPM::GetDataProvider().VideoLayerWidth();
        tUInt layerHeight = LocalSPM::GetDataProvider().VideoLayerHeight();

        tInteger setDisplaySizeSerial = IpcClient::MethodCall(ipc_PlayerEngine_DisplaySize, IN (int)layerWidth, IN (int)layerHeight);
        ETG_TRACE_USR4(("Auto send SetDisplaySize serial : %d", setDisplaySizeSerial));

        if(0 > setDisplaySizeSerial)
        {
            ETG_TRACE_ERR(("Error while sending message SetDisplaySize via DBus"));
        }
    }
    else if((m_SetVideoLayerSerial == (tInteger)serial))
    {
        m_SetVideoLayerSerial = -1;

        if(m_SuspendComponent)
        {
#ifdef TARGET_BUILD
            /* Send suspended AssignAudioOutputDevice to PlayerEngine via DBUS */
            tInteger assignAudioOutputSerial = IpcClient::MethodCall(ipc_PlayerEngine_AssignAudioOutputDevice, IN m_SuspendAudioOutputDevice);
            if (0 > assignAudioOutputSerial)
            {
                ETG_TRACE_ERR(("Error while sending message via DBus"));
            }
            else if(COMPONENT_STATE_RUNNING == GetState())
            {
                m_MethodCalls.insert(make_pair(assignAudioOutputSerial, m_SuspendComponent));
                ETG_TRACE_USR4(("Add to MethodCall map  serial:%d, component:%p", assignAudioOutputSerial, m_SuspendComponent));
            }
#else
            /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            tReturnValue returnValue = true;

            //tResult ret = snprintf(parameterString, size, tReturnValue_format , returnValue);
            tResult ret = LocalSPM::GetDeviceDispatcher().ParameterMETHOD_RETURN(OUT parameterString, IN size, IN returnValue);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while preparing parameter string"));
                parameterString[0] = '\0';
            }

            ret = m_SuspendComponent->SendEventByName("METHOD_RETURN", IN parameterString);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }
#endif
        }
    }
    else
    {
        map<tInteger, SMF *>::iterator iterMethodCalls = m_MethodCalls.find(serial);
        if((iterMethodCalls != m_MethodCalls.end()) && params)
        {
            SMF *component = iterMethodCalls->second;
            //ETG_TRACE_USR1(("Found method call in map size: %d, serial: %d, SM pointer: %d", m_MethodCalls.size(), iterMethodCalls->first, iterMethodCalls->second));
            m_MethodCalls.erase(iterMethodCalls);

            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            tReturnValue returnValue = atoi(params);

            //tResult ret = snprintf(parameterString, size, tReturnValue_format , returnValue);
            tResult ret = LocalSPM::GetDeviceDispatcher().ParameterMETHOD_RETURN(OUT parameterString, IN size, IN returnValue);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while preparing parameter string"));
                parameterString[0] = '\0';
            }

            ret = component->SendEventByName("METHOD_RETURN", IN parameterString);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }
        }
    }

    return 0x01; /*method answer handled*/;
}

tBoolean IPCProvider::MethodRequested(dbus_uint32_t serial, const char* name, const char* params)
{
    ENTRY
    ETG_TRACE_USR1(("##########IPCProvider::MethodRequested Dbus update -> serial(%d), name(%128s):%s", serial, name, params));

    mLockObserver.lock();

    tResult ret = MP_NO_ERROR;

    if( m_Observer )
    {
        if(0 == strcmp("PlaybackStatusResponseSlot", name))
        {
            tPEPlaybackState status = PE_PBS_LOADINGSTATE;
            tMetadata metadata1 = {0};
            tMetadata metadata2 = {0};
            tMetadata metadata3 = {0};
            tMetadata metadata4 = {0};

            if(params)
            {
                char *m1, *m2, *m3, *m4;

                m1 = NULL;
                m2 = NULL;
                m3 = NULL;
                m4 = NULL;

                /* let scanf allocate the space for the metadata */
                sscanf(params, "%u,%m[^,],%m[^,],%m[^,],%m[^,]", &status, &m1, &m2, &m3, &m4);

                /* secure copy the metadata */
                if (m1) {
                    strncpy_r(metadata1, m1, sizeof(metadata1));
                    free(m1);
                } else strncpy_r(metadata1, "", sizeof(metadata1));

                if (m2) {
                    strncpy_r(metadata2, m2, sizeof(metadata2));
                    free(m2);
                } else strncpy_r(metadata2, "", sizeof(metadata2));

                if (m3) {
                    strncpy_r(metadata3, m3, sizeof(metadata3));
                    free(m3);
                } else strncpy_r(metadata3, "", sizeof(metadata3));

                if (m4) {
                    strncpy_r(metadata4, m4, sizeof(metadata4));
                    free(m4);
                } else strncpy_r(metadata4, "", sizeof(metadata4));

                // old: TODO: remove this
                //sscanf(params, "%u,%[^,],%[^,],%[^,],%[^,]", &status ,metadata1 ,metadata2 ,metadata3, metadata4);
                //ETG_TRACE_USR1(("Scanned parameter -> status: %u, metadata1: %s, metadata2: %s, metadata3: %s, metadata4: %s", status,metadata1 ,metadata2 ,metadata3, metadata4));
            }

            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            tObjectID ObjectID = OBJECT_ID_NONE;

            ret = LocalSPM::GetUSBControl().ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN status, IN metadata1, IN metadata2, IN metadata3, IN metadata4,IN ObjectID);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while preparing parameter string"));
                parameterString[0] = '\0';
            }

            ret = m_Observer->SendEventByName("PLAYBACK_STATUS_RESPONSE", IN parameterString);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }

            //send a dedicated STOP event to xxxControl SM - GMMY16-24734
            if(status == PE_PBS_STOPPEDSTATE || status == PE_PBS_ERRORSTATE)
            {
                ret = m_Observer->SendEventByName("STOP_ANSWER", IN NULL);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                }
            }
        }
        else if(0 == strcmp("Tick_TimeElapsedSlot", name))
        {
            tPlaytime elapsedPlaytime = 0;
            tPlaytime totalPlaytime = 0;

            if(params)
            {
#if 0
                //QDBus PE is using QTime
                tUInt eTime_h, eTime_m, eTime_s, eTime_ms = 0;
                tUInt tTime_h, tTime_m, tTime_s, tTime_ms = 0;

                sscanf(params, "%u,%u,%u,%u,%u,%u,%u,%u",&eTime_h ,&eTime_m ,&eTime_s ,&eTime_ms, &tTime_h ,&tTime_m ,&tTime_s ,&tTime_ms);
                elapsedPlaytime = eTime_ms + (eTime_s*1000) + (eTime_m*60000) + (eTime_h*3600000);
                totalPlaytime   = tTime_ms + (tTime_s*1000) + (tTime_m*60000) + (tTime_h*3600000);
                //ETG_TRACE_USR1(("Calculated times -> elapsedPlaytime: %us, totalPlaytime: %us", elapsedPlaytime/1000, totalPlaytime/1000));
#endif
                //GDBus PE is using int values
                sscanf(params, "%u,%u",&elapsedPlaytime ,&totalPlaytime);
            }

            tAllParameters parameterString;
            size_t size = sizeof(parameterString);

            ret = LocalSPM::GetUSBControl().ParameterTICK_TIME_ELAPSED(OUT parameterString, IN size, IN elapsedPlaytime, IN totalPlaytime);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while preparing parameter string"));
            }
            else
            {
                ret = m_Observer->SendInternalEventByName("TICK_TIME_ELAPSED", IN parameterString);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                }
            }
        }
        else if(0 == strcmp("viewStatusDCReplySlot", name))
        {
            tViewStatus viewStatus = VS_INVALID;

            if(params)
            {
                sscanf(params, "%u",&viewStatus);
                ETG_TRACE_USR1(("Scanned parameter -> view status: %u", viewStatus));
            }
#if 0
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);

            ret = LocalSPM::GetUSBControl().ParameterVIEW_STATUS(OUT parameterString, IN size, IN viewStatus);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while preparing parameter string"));
                parameterString[0] = '\0';
            }

            ret = m_Observer->SendEventByName("VIEW_STATUS", IN parameterString);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }
#endif
        }
        else
        {
            mLockObserver.unlock();

            return 0x00; /*method request not handled*/;
        }
    }

    mLockObserver.unlock();

    return 0x01; /*method request handled*/;
}

tBoolean IPCProvider::Error(dbus_uint32_t serial, const char* errorName, const char* errorMessage)
{
    ENTRY
    ETG_TRACE_ERR(("##########IPCProvider::Error Dbus error -> serial(%d) errorName:%s", serial, errorName));
    ETG_TRACE_ERR(("##########IPCProvider::Error Dbus error -> serial(%d) errorMessage:%s", serial, errorMessage));

    unsigned int iter;
    for(iter = 0 ; iter < mListeners.size() ; iter++)
    {
        if(mListeners[iter]->belongs(serial))
        {
            mListeners[iter]->RouteError(serial, errorName);
            return 0x01; /*method error response handled*/;
        }
    }



    return 0x01; /*method error response handled*/;
}


//PlayerEngine interface part

tResult IPCProvider::RegisterObserver(SMF *component) const
{
    ENTRY
    (void)component;
    ETG_TRACE_USR3(("IPCProvider::RegisterObserver"));

    return MP_NO_ERROR;
}

tResult IPCProvider::UnregisterObserver(SMF *component)
{
    ENTRY
    ETG_TRACE_USR3(("IPCProvider::UnregisterObserver"));

    mLockObserver.lock();

    /* Reset observer pointer */
    if(component == m_Observer)
    {
        m_Observer = NULL;
    }

    mLockObserver.unlock();

    return MP_NO_ERROR;
}

tResult IPCProvider::SwitchObserver(SMF *component)
{
    ENTRY
    ETG_TRACE_USR3(("IPCProvider::SwitchObserver"));

    tResult ret = MP_NO_ERROR;

    if(COMPONENT_STATE_RUNNING == GetState())
    {
        mLockObserver.lock();

        /* Save pointer to observer */
        m_Observer = component;

        mLockObserver.unlock();
    }

    /* Send SwitchObserver of MediaPlayer to PlayerEngine via DBUS */
    tInteger serial = IpcClient::MethodCall(ipc_PlayerEngine_SwitchObserver, MEDIAPLAYER_SERVICE, MEDIAPLAYER_PATH, MEDIAPLAYER_INTERFACE);
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }
    else if(COMPONENT_STATE_RUNNING == GetState())
    {
        m_MethodCalls.insert(make_pair(serial, component) );
        ETG_TRACE_USR4(("Add to MethodCall map  serial:%d, component:%p", serial, component));
    }

    return ret;
}

tResult IPCProvider::AssignAudioOutputDevice(SMF *component, const tAudioOutputDevice audioOutputDevice)
{
    ENTRY
    ETG_TRACE_USR3(("IPCProvider::AssignAudioOutputDevice audioOutputDevice:%s", audioOutputDevice));

    tResult ret = MP_NO_ERROR;

    if(m_Initialized)
    {
#ifdef TARGET_BUILD
        /* Send AssignAudioOutputDevice to PlayerEngine via DBUS */
        tInteger serial = IpcClient::MethodCall(ipc_PlayerEngine_AssignAudioOutputDevice, IN audioOutputDevice);
        if(0 > serial)
        {
            ETG_TRACE_ERR(("Error while sending message via DBus"));
            ret = MP_ERR_DBUS;
        }
        else if(COMPONENT_STATE_RUNNING == GetState())
        {
            m_MethodCalls.insert(make_pair(serial, component) );
            ETG_TRACE_USR4(("Add to MethodCall map  serial:%d, component:%p", serial, component));
        }
#else
        /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        tReturnValue returnValue = true;

        //tResult ret = snprintf(parameterString, size, tReturnValue_format , returnValue);
        tResult ret = LocalSPM::GetDeviceDispatcher().ParameterMETHOD_RETURN( OUT parameterString, IN size, IN returnValue);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string"));
            parameterString[0] = '\0';
        }

        ret = m_SuspendComponent->SendEventByName("METHOD_RETURN", IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF"));
        }
#endif
    }
    else
    {

        m_SuspendComponent = component;
        strncpy(m_SuspendAudioOutputDevice, audioOutputDevice, sizeof(m_SuspendAudioOutputDevice)-1);
        /* Send RegisterObserver to PlayerEngine via DBUS */
        m_RegisterSerial = IpcClient::MethodCall(ipc_PlayerEngine_RegisterObserver, MEDIAPLAYER_SERVICE, MEDIAPLAYER_PATH, MEDIAPLAYER_INTERFACE);
        ETG_TRACE_USR4(("Auto send RegisterObserver serial:%d", m_RegisterSerial));
        if(0 > m_RegisterSerial)
        {
            ETG_TRACE_ERRMEM(("IPCProvider::Send RegisterObserver to PlayerEngine via DBUS failed"))
                            ETG_TRACE_ERR(("IPCProvider::Send RegisterObserver to PlayerEngine via DBUS failed"));
        }
        else
        {
            m_Initialized = true;
        }
    }


    return ret;
}

tResult IPCProvider::AssignAudioInputDevice(SMF *component, const tAudioInputDevice audioInputDevice)
{
    ENTRY
    ETG_TRACE_USR3(("IPCProvider::AssignAudioInputDevice audioInputDevice:%s", audioInputDevice));

    tResult ret = MP_NO_ERROR;

    /* Send AssignAudioInputDevice to PlayerEngine via DBUS */
    tInteger serial = IpcClient::MethodCall(ipc_PlayerEngine_AssignAudioInputDevice, IN audioInputDevice);
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }
    else if(COMPONENT_STATE_RUNNING == GetState())
    {
        m_MethodCalls.insert(make_pair(serial, component));
        ETG_TRACE_USR4(("Add to MethodCall map  serial:%d, component:%p", serial, component));
    }

    return ret;
}

tResult IPCProvider::DeAllocateOutDevice(SMF *component)
{
    ENTRY
    ETG_TRACE_USR3(("IPCProvider::DeAllocateOutDevice"));

    tResult ret = MP_NO_ERROR;

    /* Send DeAllocateOutDevice to PlayerEngine via DBUS */
    tInteger serial = IpcClient::MethodCall(ipc_PlayerEngine_DeAllocateOutDevice);
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }
    else if(COMPONENT_STATE_RUNNING == GetState())
    {
        m_MethodCalls.insert(make_pair(serial, component) );
        ETG_TRACE_USR4(("Add to MethodCall map  serial:%d, component:%p", serial, component));
    }

    return ret;
}

tResult IPCProvider::DeAllocateInDevice(SMF *component)
{
    ENTRY
    ETG_TRACE_USR3(("IPCProvider::DeAllocateInDevice"));

    tResult ret = MP_NO_ERROR;

    /* Send DeAllocateInDevice to PlayerEngine via DBUS */
    tInteger serial = IpcClient::MethodCall(ipc_PlayerEngine_DeAllocateInDevice);
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }
    else if(COMPONENT_STATE_RUNNING == GetState())
    {
        m_MethodCalls.insert(make_pair(serial, component) );
        ETG_TRACE_USR4(("Add to MethodCall map  serial:%d, component:%p", serial, component));
    }

    return ret;
}

tResult IPCProvider::NewPlaySlot(SMF *component, const tURL URL, const tPlaytime position, const tPlaypointFormat playpointFormat)
{
    ENTRY
    ETG_TRACE_USR3(("IPCProvider::NewPlaySlot URL:%40s, position:%d, format:%d", URL, position, playpointFormat));

    tResult ret = MP_NO_ERROR;
    (void)component;

    /* Send NewPlaySlot to PlayerEngine via DBUS */
    tInteger serial = IpcClient::MethodCall(ipc_PlayerEngine_NewPlaySlot, IN URL, IN (int)position, IN (int)playpointFormat);
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }

    return ret;
}

tResult IPCProvider::StopSlot(SMF *component)
{
    ENTRY
    ETG_TRACE_USR3(("IPCProvider::StopSlot"));

    tResult ret = MP_NO_ERROR;
    (void)component;

    /* Send StopSlot to PlayerEngine via DBUS */
    tInteger serial = IpcClient::MethodCall(ipc_PlayerEngine_StopSlot);
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }

    return ret;
}

tResult IPCProvider::PauseSlot(SMF *component, const tURL URL, const tPlaytime position, const tPlaypointFormat playpointFormat)
{
    ENTRY
    ETG_TRACE_USR3(("IPCProvider::PauseSlot URL:%40s, position:%d, format:%d", URL, position, playpointFormat));

    tResult ret = MP_NO_ERROR;
    (void)component;

    /* Send PauseSlot to PlayerEngine via GDBUS */
    tInteger serial = IpcClient::MethodCall(ipc_PlayerEngine_PauseSlot, IN URL, IN (int)position, IN (int)playpointFormat);
#if 0 //QDBus PE IF is using PauseSlot without parameter
    tInteger serial = IpcClient::MethodCall(ipc_PlayerEngine_PauseSlot);
#endif
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }

    return ret;
}

tResult IPCProvider::ResumePlaySlot(SMF *component)
{
    ENTRY
    ETG_TRACE_USR3(("IPCProvider::ResumePlaySlot"));

    tResult ret = MP_NO_ERROR;
    (void)component;

    /* Send ResumePlaySlot to PlayerEngine via DBUS */
    tInteger serial = IpcClient::MethodCall(ipc_PlayerEngine_ResumePlaySlot);
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }

    return ret;
}

tResult IPCProvider::SeekToSlot(SMF *component, const tPlaytime position, const tPlaypointFormat playpointFormat)
{
    ENTRY
    ETG_TRACE_USR3(("IPCProvider::SeekToSlot position:%d, format:%d", position, playpointFormat));

    tResult ret = MP_NO_ERROR;
    (void)component;

    /* Send SeekToSlot to PlayerEngine via DBUS */
    tInteger serial = IpcClient::MethodCall(ipc_PlayerEngine_SeekToSlot, IN (int)position, IN (int)playpointFormat);
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }

    return ret;
}

tResult IPCProvider::PlayFromDeviceSlot(SMF *component,
        const tEncoding encoding,
        const tBitRate bitRate,
        const me::samplerate_i sampleRate,
        const channels_i channels,
        const samplewidth_i sampleWidth,
        const me::sampledepth_i sampleDepth,
        const signedness_e sampleSignedness,
        const endianess_e sampleEndianness)
{
    ENTRY
    ETG_TRACE_USR3(("IPCProvider::PlayFromDeviceSlot encoding:%40s, bitRate:%d", encoding, bitRate));
    VARTRACE(sampleRate);
    VARTRACE(channels);
    VARTRACE(sampleWidth);
    VARTRACE(sampleDepth);
    VARTRACE(sampleSignedness);
    VARTRACE(sampleEndianness);

    tResult ret = MP_NO_ERROR;
    (void)component;

    /* Send PlayFromDeviceSlot to PlayerEngine via DBUS */
    tInteger serial = IpcClient::MethodCall(ipc_PlayerEngine_PlayFromDeviceSlot,
            IN encoding,
            IN (int)bitRate,
            IN (int)sampleRate,
            IN (int)channels,
            IN (int)sampleWidth,
            IN (int)sampleDepth,
            IN (bool)sampleSignedness,
            IN (bool)sampleEndianness);
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }

    return ret;
}

tResult IPCProvider::StartFfSlot(SMF *component, tCueingRate rate)
{
    ENTRY
    ETG_TRACE_USR3(("IPCProvider::StartFfSlot rate:%d", rate));

    tResult ret = MP_NO_ERROR;
    (void)component;

    /* Send StartFfSlot to PlayerEngine via DBUS */
    tInteger serial = IpcClient::MethodCall(ipc_PlayerEngine_StartFfSlot, IN (int)rate);
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }

    return ret;
}

tResult IPCProvider::StopFfSlot(SMF *component)
{
    ENTRY
    ETG_TRACE_USR3(("IPCProvider::StopFfSlot"));

    tResult ret = MP_NO_ERROR;
    (void)component;

    /* Send StopFfSlot to PlayerEngine via DBUS */
    tInteger serial = IpcClient::MethodCall(ipc_PlayerEngine_StopFfSlot);
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }

    return ret;
}

tResult IPCProvider::StartFrevSlot(SMF *component, tCueingRate rate)
{
    ENTRY
    ETG_TRACE_USR3(("IPCProvider::StartFrevSlot rate:%d", rate));
    (void)component;

    tResult ret = MP_NO_ERROR;

    /* Send StartFrevSlot to PlayerEngine via DBUS */
    tInteger serial = IpcClient::MethodCall(ipc_PlayerEngine_StartFrevSlot, IN (int)rate);
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }

    return ret;
}

tResult IPCProvider::StopFrevSlot(SMF *component)
{
    ENTRY
    ETG_TRACE_USR3(("IPCProvider::StopFrevSlot"));

    tResult ret = MP_NO_ERROR;
    (void)component;

    /* Send StopFrevSlot to PlayerEngine via DBUS */
    tInteger serial = IpcClient::MethodCall(ipc_PlayerEngine_StopFrevSlot);
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }

    return ret;
}
void IPCProvider::GetInterfaceName(OUT tInterfaceName &interfacename, IN const char* params)
{
    ENTRY
    ETG_TRACE_USR3(("IPCProvider::GetInterfaceName"));

    //Find the Literal Count
    int literalCount = 0;
    char *ptr = (char*) strchr(params,IPC_DBUS_PARAM_DELIMITER_INT);
    ETG_TRACE_USR4(("ptr:%p",ptr));
    while (ptr != NULL)
    {
        ptr = strchr(ptr + 1,IPC_DBUS_PARAM_DELIMITER_INT);
        literalCount++;
    }
    ETG_TRACE_USR4(("literalCount : %d",literalCount));
    std::string strFromChar;
    strFromChar.append(params);
    std::istringstream ss(strFromChar);
    std::string token;
    if(literalCount>0)
    {
        std::getline(ss, token, IPC_DBUS_PARAM_DELIMITER_CHAR);
    }
    else
    {
        ETG_TRACE_ERR(("Error while getting interfacename. No literals in Params"));
        return;
    }
    ETG_TRACE_USR4(("token : %s",token.c_str()));
    strncpy(interfacename, (const char*)token.c_str(), sizeof(interfacename)-1);
    ETG_TRACE_USR4(("interfacename : %s",interfacename));
    return ;
}

void IPCProvider::AddFilters()
{

    ENTRY
    /* Set filter for IPC client to receive player engine messages over session bus*/
    IpcClient::SetFilter(GMPDBUS_BUS_SESSION,"type='method_call',interface='local.MediaPlayer'");
    IpcClient::SetFilter(GMPDBUS_BUS_SESSION,"type='method_return',interface='local.PlayerEngine.PlayerEngine'");
    IpcClient::SetFilter(GMPDBUS_BUS_SESSION,"type='signal',interface='local.PlayerEngine.PlayerEngine'");
    IpcClient::SetFilter(GMPDBUS_BUS_SESSION,"type='error',interface='local.PlayerEngine.PlayerEngine'");

    /*Register Callback Function for Session Bus Connection*/
    RegisterCallbackFunction(GMPDBUS_BUS_SESSION);

    //com.bosch.MediaAgentService is listening on separate dbus session bus (custom session bus -->'unix:path=/tmp/shared/iddbus/lxcdbus')than the usual bus used by Mediaplayer or mediaengine
    /* Set filter for IPC client to receive com.bosch.MediaAgentService messages over session bus*/
    IpcClient::SetFilter(GMPDBUS_BUS_CUSTOMSESSION,"type='method_call',interface='com.bosch.MediaAgentService.GracenoteInterface'");
    IpcClient::SetFilter(GMPDBUS_BUS_CUSTOMSESSION,"type='method_return',interface='com.bosch.MediaAgentService.GracenoteInterface'");
    IpcClient::SetFilter(GMPDBUS_BUS_CUSTOMSESSION,"type='signal',interface='com.bosch.MediaAgentService.GracenoteInterface'");
    IpcClient::SetFilter(GMPDBUS_BUS_CUSTOMSESSION,"type='error',interface='com.bosch.MediaAgentService.GracenoteInterface'");

    /*Register Callback Function for custom Session Bus('unix:path=/tmp/shared/iddbus/lxcdbus') Connection*/
    RegisterCallbackFunction(GMPDBUS_BUS_CUSTOMSESSION);

    /* Set filter for IPC client to receive bt-daemon messages over system bus*/
    IpcClient::SetFilter(GMPDBUS_BUS_SYSTEM,"type='method_return',interface='com.alps.bt.Audiovisual'");
    if(LocalSPM::GetDataProvider().AVRCPLowerProfileSupported())
    {
        IpcClient::SetFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='com.alps.bt.Audiovisual'");
    }
    IpcClient::SetFilter(GMPDBUS_BUS_SYSTEM,"type='error',interface='com.alps.bt.Audiovisual'");

    IpcClient::SetFilter(GMPDBUS_BUS_SYSTEM,"type='method_return',interface='org.bluez.MediaPlayer'");
    //IpcClient::SetFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.freedesktop.DBus.Properties'");
    IpcClient::SetFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.freedesktop.DBus.Properties',arg0='org.bluez.MediaPlayer'");
    IpcClient::SetFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.freedesktop.DBus.Properties',arg0='org.bluez.MediaFolder'");
    IpcClient::SetFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.freedesktop.DBus.Properties',arg0='org.bluez.evo.AVP'");
    IpcClient::SetFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.freedesktop.DBus.Properties',arg0='org.bluez.MediaTransport'");

    IpcClient::SetFilter(GMPDBUS_BUS_SYSTEM,"type='error',interface='org.bluez.MediaPlayer'");
    //IpcClient::SetFilter(DBUS_BUS_SYSTEM,"type='signal',interface='org.bluez.evo.AVP',member='PlayerAdded'");
    IpcClient::SetFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.bluez.MediaPlayer',member='TrackChanged'");
    IpcClient::SetFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.bluez.evo.AVP',member='NowPlayingContent'");
    IpcClient::SetFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.bluez.evo.AVP',member='PlayerRemoved'");
    IpcClient::SetFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.bluez.evo.AVP',member='UIDsChanged'");
    IpcClient::SetFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.bluez.evo.AVP',member='AvailablePlayerChange'");

    IpcClient::SetFilter(GMPDBUS_BUS_SYSTEM, "type='signal',interface='org.bosch.cm.persmidw'");
    IpcClient::SetFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.genivi.audiomanager.CommandInterface',member='MainSinkSoundPropertyChanged'");
    /*Register Callback Function for System Bus Connection*/
    RegisterCallbackFunction(GMPDBUS_BUS_SYSTEM);
}

void IPCProvider::RemoveFilters()
{
    ENTRY
    /* Remove filters of player engine messages messages for IPC client over session bus*/
    IpcClient::RemoveFilter(GMPDBUS_BUS_SESSION,"type='method_call',interface='local.MediaPlayer'");
    IpcClient::RemoveFilter(GMPDBUS_BUS_SESSION,"type='method_return',interface='local.PlayerEngine.PlayerEngine'");
    IpcClient::RemoveFilter(GMPDBUS_BUS_SESSION,"type='signal',interface='local.PlayerEngine.PlayerEngine'");
    IpcClient::RemoveFilter(GMPDBUS_BUS_SESSION,"type='error',interface='local.PlayerEngine.PlayerEngine'");

    /*DeRegister Callback Function for Session Bus Connection*/
    DeRegisterCallbackFunction(GMPDBUS_BUS_SESSION);

    /* Remove filter for IPC client to receive com.bosch.MediaAgentService messages over session bus*/
    IpcClient::RemoveFilter(GMPDBUS_BUS_CUSTOMSESSION,"type='method_call',interface='com.bosch.MediaAgentService.GracenoteInterface'");
    IpcClient::RemoveFilter(GMPDBUS_BUS_CUSTOMSESSION,"type='method_return',interface='com.bosch.MediaAgentService.GracenoteInterface'");
    IpcClient::RemoveFilter(GMPDBUS_BUS_CUSTOMSESSION,"type='signal',interface='com.bosch.MediaAgentService.GracenoteInterface'");
    IpcClient::RemoveFilter(GMPDBUS_BUS_CUSTOMSESSION,"type='error',interface='com.bosch.MediaAgentService.GracenoteInterface'");

    /*DeRegister Callback Function for custom Session Bus('unix:path=/tmp/shared/iddbus/lxcdbus') Connection*/

    DeRegisterCallbackFunction(GMPDBUS_BUS_CUSTOMSESSION);


    /* Remove filters of BT stack messages for IPC client over system bus*/
    IpcClient::RemoveFilter(GMPDBUS_BUS_SYSTEM,"type='method_return',interface='com.alps.bt.Audiovisual'");
    if(LocalSPM::GetDataProvider().AVRCPLowerProfileSupported())
    {
        IpcClient::RemoveFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='com.alps.bt.Audiovisual'");
    }
    IpcClient::RemoveFilter(GMPDBUS_BUS_SYSTEM,"type='error',interface='com.alps.bt.Audiovisual'");

    IpcClient::RemoveFilter(GMPDBUS_BUS_SYSTEM,"type='method_return',interface='org.bluez.MediaPlayer'");
    IpcClient::RemoveFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.freedesktop.DBus.Properties',arg0='org.bluez.MediaPlayer'");
    IpcClient::RemoveFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.freedesktop.DBus.Properties',arg0='org.bluez.MediaFolder'");
    IpcClient::RemoveFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.freedesktop.DBus.Properties',arg0='org.bluez.evo.AVP'");
    IpcClient::RemoveFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.freedesktop.DBus.Properties',arg0='org.bluez.MediaTransport'");

    IpcClient::RemoveFilter(GMPDBUS_BUS_SYSTEM,"type='error',interface='org.bluez.MediaPlayer'");
   // IpcClient::RemoveFilter(DBUS_BUS_SYSTEM,"type='signal',interface='org.bluez.evo.AVP',member='PlayerAdded'");
    IpcClient::RemoveFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.bluez.MediaPlayer',member='TrackChanged'");
    IpcClient::RemoveFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.bluez.evo.AVP',member='NowPlayingContent'");
    IpcClient::RemoveFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.bluez.evo.AVP',member='PlayerRemoved'");
    IpcClient::RemoveFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.bluez.evo.AVP',member='UIDsChanged'");
    IpcClient::RemoveFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.bluez.evo.AVP',member='AvailablePlayerChange'");

    IpcClient::RemoveFilter(GMPDBUS_BUS_SYSTEM, "type='signal',interface='org.bosch.cm.persmidw'");
    IpcClient::RemoveFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.genivi.audiomanager.CommandInterface',member='MainSinkSoundPropertyChanged'");

    /*DeRegister Callback Function for System Bus Connection*/
    DeRegisterCallbackFunction(GMPDBUS_BUS_SYSTEM);
}
