/*
 * MessageQueueTest.h
 *
 *  Created on: Jul 1, 2013
 *      Author: tritonsu
 */

#ifndef MESSAGEQUEUETEST_H_
#define MESSAGEQUEUETEST_H_

#include <cppunit/extensions/HelperMacros.h>

#include "MessageQueue.h"

class MessageQueueTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( MessageQueueTest );

    CPPUNIT_TEST( HappyDayTest );
    CPPUNIT_TEST( SpeedTest );
    CPPUNIT_TEST( MessageWaitUnlimited );
    CPPUNIT_TEST( MessageWaitFixedTime );
    CPPUNIT_TEST( MessageWaitTimeout );
    CPPUNIT_TEST( MessagePeekAndDelete );
    CPPUNIT_TEST( MessageFlush );
    CPPUNIT_TEST( WrapAroundTest );
	CPPUNIT_TEST( StressCreateDeleteQTest );

    CPPUNIT_TEST_SUITE_END();

public:

   /*test cases*/
    void WrapAroundTest();
    void SpeedTest();
    void HappyDayTest();
    void MessageWaitFixedTime();
    void MessageWaitTimeout();
    void MessageWaitUnlimited();
    void MessagePeekAndDelete();
    void MessageFlush();
	void StressCreateDeleteQTest();

private:
    static void* WriteThreadFunction(void *pQueue);
};

#endif /* MESSAGEQUEUETEST_H_ */
