#include <errno.h>
#include <memory.h>
#include <unistd.h>

#include "LongRunnerCatcherTest.h"

#include <FunctionTracer.h>

#include "TraceDefinitions.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/LongRunnerCatcherTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

void LongRunnerCatcherTest::setUp()
{
}

void LongRunnerCatcherTest::tearDown()
{
}

int LongRunnerCatcherTest::someMethodReturningInt(int param1, const char *param2)
{
    ETG_TRACE_USR1(("param1=%d, param2=%s", param1, param2));
    if (param1 == 20) {
        while(1) sleep(1);
    }
    return param1;
}

void LongRunnerCatcherTest::FirstTest()
{
    ENTRY_TEST
    int res;

    /* check the comma seperated list computation */
    res = (1 ? -10 : -20);
    CPPUNIT_ASSERT(res == -10);

    res = (0 ? -10 : -20);
    CPPUNIT_ASSERT(res == -20);

    /* call method with error catcher wrapper */
    LR_INIT;

    /* test: non blocking -> no error catch */
    res = LR_CATCH(1000, -99) someMethodReturningInt(10, "Should not be catched") LR_CATCH_END;
    CPPUNIT_ASSERT(res == 10);

    /* test: blocking -> error catch after 1000 ms */
    res = LR_CATCH(1000, -99) someMethodReturningInt(20, "Should be catched") LR_CATCH_END;
    CPPUNIT_ASSERT(res == -99);
}
