/*
 * Utils.cpp
 *
 *  Created on: Feb 14, 2013
 *      Author:
 */

#include "Utils.h"
#include <errno.h>
#include <mntent.h>
#include <string.h>
#include <stdio.h>
#include <syslog.h>
#include <sys/stat.h>
#include <sys/resource.h>
#include <sys/wait.h>
#include <fcntl.h>

/*Trace includes*/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_FRAMEWORK
#ifdef TARGET_BUILD
#include "trcGenProj/Header/Utils.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_FRAMEWORK
#endif
#endif
#include "TraceDefinitions.h"
#include "FunctionTracer.h"

/*lint -save -e1773 */

int usleep (__useconds_t __useconds)
{
    struct timespec req,rem;

    req.tv_sec = __useconds/1000000;
    req.tv_nsec= (__useconds%1000000)*1000;

    while(1)
    {
        if(nanosleep(&req,&rem) != -1)
            break;
        //sleep is terminated
        //resume the sleep for remaining period
        req.tv_sec = rem.tv_sec;
        req.tv_nsec= rem.tv_nsec;
    }

    return 0;
}
unsigned int sleep (unsigned int __seconds)
{
    struct timespec req,rem;

    req.tv_sec = __seconds;
    req.tv_nsec= 0;

    while(1)
    {
        if(nanosleep(&req,&rem) != -1)
            break;
        //sleep is terminated
        //resume the sleep for remaining period
        req.tv_sec = rem.tv_sec;
        req.tv_nsec= rem.tv_nsec;
    }

    return 0;
}

#if 0
#ifndef TARGET_BUILD_GEN3
void *memcpy(void *dest, const void *src, size_t n) throw()
{
    /*
     * this function replaces memcpy for that case the regions overlapping. Even the stl uses memcpy to
     * copy overlapping regions. Duma reports that. Also DBUS lib and totem pl parser.
     * I wanted to eliminate this risk at all, Thömel.
     */
    return __builtin_memmove(dest, src, n);
}
#endif
void *__builtin_memmove(void *dst, const void *src, size_t len)
{
    /*
     * this function replaces __builtin_memmove. This is because the stl uses __builtin_memmove and the original implementation
     * switches back to memcpy in some cases. But duma complains overlapping memory regions in memcpy.
     * I wanted to eliminate this risk at all, Thömel.
     */
    size_t i;
    int reverse = 1;

    /*
     * if destination pointer is less than source pointer: reverse the copy direction:
     */
    if ( dst < src) {
        reverse = 0;
    }

    /* is it possible to copy whole words? */
    if ( (unsigned long)dst % (unsigned long)sizeof(long) == 0 &&  (unsigned long)src % (unsigned long)sizeof(long) == 0 && len % sizeof(long) == 0) {

        long *d = (long *) dst;
        const long *s = (const long *) src;

        if (reverse) {
            for (i = len / sizeof(long); i > 0; i--) {
                d[i - 1] = s[i - 1];
            }
        } else {
            for (i = 1; i <= len / sizeof(long); i++) {
                d[i - 1] = s[i - 1];
            }
        }

    } else { // copy bytes:

        char *d = (char *) dst;
        const char *s = (const char *) src;

        if (reverse) {
            for (i = len; i > 0; i--) {
                d[i - 1] = s[i - 1];
            }
        } else {
            for (i = 1; i <= len; i++) {
                d[i - 1] = s[i - 1];
            }
        }
    }

    return dst;
}
#endif

char *lltoa(long long value, char *c, int base)
{
    const char *letters = (char *)"0123456789abcdef";
    long long _value = value;

    if (_value == 0) {
        *c++ = '0';
        return c;
    }

    if (value < 0) {
        _value = -value;
        *c++ = '-';
    }

    int i;
    char buf[128];
    char *cb = buf+(sizeof(buf)-1);
    *cb = 0;

    // Translating number to string with base:
    for (i=127; _value && i ; --i) {
        cb--;
        *cb = letters[_value % base];
        _value /= base;
    }

    strcpy(c, cb);
    while(*c) c++;
    return c;
}

char *ulltoa(unsigned long long value, char *c, int base)
{
    const char *letters = (char *)"0123456789abcdef";

    if (value == 0) {
        *c++ = '0';
        return c;
    }

    int i;
    char buf[128];
    char *cb = buf+(sizeof(buf)-1);
    *cb = 0;

    // Translating number to string with base:
    for (i=127; value && i ; --i) {
        cb--;
        *cb = letters[value % (unsigned long long)base];
        value /= base;
    }

    strcpy(c, cb);
    while(*c) c++;
    return c;
}

char *itoa(int value, char *c, int base)
{
    return lltoa((long long)value, c, base);
}

int toUtf8Fake(char *outBuffer, const size_t outBufferLen, const char *inBuffer)
{
    const char *cIn = inBuffer;
    unsigned char *cOut = (unsigned char *)outBuffer;
    size_t cCount = outBufferLen - 2;

    /* loop over input buffer */
    while(*cIn && cCount) {

        /* is character value bigger than 6 bits? */
        if (*cIn & 0x80) {

            /* convert to 2 byte utf8 */
            *cOut++ = 0xc0 | ((*cIn >> 6) & 0x3);
            *cOut++ = 0x80 | (*cIn++ &  0x3f);
            cCount-=2;

        /* no conversion: just take the character */
        } else {
            *cOut++ = *cIn++;
            cCount--;
        }
    }

    *cOut = 0;

    return (cCount ? 0 : 1);
}

int fromUtf8Fake(char *outBuffer, const size_t outBufferLen, const char *inBuffer)
{
    const char *cIn = inBuffer;
    unsigned char *cOut = (unsigned char *)outBuffer;
    size_t cCount = outBufferLen - 2;

    /* loop over input buffer */
    while(*cIn && cCount) {

        /* is character value bigger than 6 bits? */
        if (*cIn & 0x80) {

            /* convert to ascii */
            *cOut    = (*cIn++ << 6);
            *cOut++ |= (*cIn++ & 0x3f);

        /* no conversion: just take the character */
        } else {
            *cOut++ = *cIn++;
            cCount--;
        }
    }

    *cOut = 0;

    return (cCount ? 0 : 1);
}


char *strncat_r(char *dest, const char *src, size_t sizeOfDest)
{
    /* sanity: empty source string */
    if (src == NULL || *src == 0) { // CID 13997 (#1 of 2): Dereference after null check (FORWARD_NULL)
        return dest;
    }

    int iCopy = 0;
    char *_src = (char *)src;
    char *ret = dest;
    sizeOfDest--; // les one for the trailing zero
    while(*_src && sizeOfDest) {
        if (iCopy == 0 && *dest == 0) iCopy = 1;    // end of dest string found
        if (iCopy == 1) *dest = *_src++;            // copy src to dest
        dest++;
        sizeOfDest--;
    }
    *dest = 0;
    return ret;
}
int strlen_r(const char *src)
{
    if(src == NULL) { //terminate src on NULL
        return 0;
    }
    return strlen(src);
}
char *strncpy_r(char *dest, const char *src, size_t sizeOfDest)
{
    if(src == NULL) { //terminate dest on NULL
        dest[0] = 0;
        return dest;
    }
    dest[sizeOfDest-1] = 0; //implicit null-character termination if source is longer than sizeOfDest
    return strncpy(dest, src, sizeOfDest-1);
}

char *strupper(char *s)
{
    for(char *p = s; *p; ++p)
    {
        *p = toupper(*p);
    }
    return s;
}

char *strlower(char *s)
{
    for(char *p = s; *p; ++p)
    {
        *p = tolower(*p);
    }
    return s;
}

char *strtrim(char *str)
{
    size_t len = 0;
    char *frontp = str - 1;
    char *endp = NULL;

    if( str == NULL ) return NULL;

    if( str[0] == '\0' ) return str;

    len = strlen_r(str);
    endp = str + len;

    /* Move the front and back pointers to address the first non-whitespace characters from each end. */
    while( isspace(*(++frontp)) ) {}
    while( isspace(*(--endp)) && endp != frontp ) {}

    if( str + len - 1 != endp )
    {
        *(endp + 1) = '\0';
    }
    else if( frontp != str &&  endp == frontp )
    {
        *str = '\0';
    }

    /* Shift the string so that it starts at str so that if it's dynamically allocated, we can still free
     * it on the returned pointer. Note the reuse of endp to mean the front of the string buffer now. */
    endp = str;
    if( frontp != str )
    {
        while( *frontp ) *endp++ = *frontp++;
        *endp = '\0';
    }

    return str;
}

#ifdef TARGET_BUILD
extern "C" void OSAL_vAssertFunction(const char* exp, const char* file, unsigned int line);

void MP_AssertFunction(const char* exp, const char* file, unsigned int line)
{
    OSAL_vAssertFunction(exp, file, line);
}
#endif


/* this function is copied from:
 * http://stackoverflow.com/questions/7775991/how-to-get-hexdump-of-a-structure-data
 */
void hexDump (FILE *fp, const char *desc, void *addr, int len) {
    int i;
    unsigned char buff[17];
    unsigned char *pc = (unsigned char*)addr;

    // Output description if given.
    if (desc != NULL)
        fprintf (fp, "%s:\n", desc);

    /* print pure string */
    fprintf (fp, "printf: %.*s\n", len, (char *)addr);

    // Process every byte in the data.
    for (i = 0; i < len; i++) {
        // Multiple of 16 means new line (with line offset).

        if ((i % 16) == 0) {
            // Just don't print ASCII for the zeroth line.
            if (i != 0)
                fprintf (fp, "  %s\n", buff);

            // Output the offset.
            fprintf (fp, "  %04x ", i);
        }

        // Now the hex code for the specific character.
        fprintf (fp, " %02x", pc[i]);

        // And store a printable ASCII character for later.
        //if ((pc[i] < 0x20) || (pc[i] > 0x7e))
        if (!isprint(pc[i]))
            buff[i % 16] = '.';
        else
            buff[i % 16] = pc[i];
        buff[(i % 16) + 1] = '\0';
    }

    // Pad out last line if not exactly 16 characters.
    while ((i % 16) != 0) {
        fprintf (fp, "   ");
        i++;
    }

    // And print the final ASCII bit.
    fprintf (fp, "  %s\n", buff);
    fflush(fp);
}

int exists_file(const char *filePath)
{
    FILE *fp;
    fp = fopen(filePath, "r");
    if (fp) {
        fclose(fp);
        return 1;
    }
    return 0;
}

int exists_directory(const char *directoryPath)
{
    DIR *dirp;
    dirp = opendir(directoryPath);
    if (dirp) {
        closedir(dirp);
        return 1;
    }
    else if(ENOENT != errno)
        return 1;
    else
        return 0;
}

bool isDirOpenable(const char *path)
{
    bool status = true;
    if(exists_directory(path))
    {
        ETG_TRACE_ERR(("isDirOpenable : Directory Exists errno:%d errmsg:%s",errno,strerror(errno)));
        if((EACCES == errno) || (EIO == errno) || (ENOTDIR == errno))
        {
            status = false;
        }
    }
    else
    {
        ETG_TRACE_ERR(("isDirOpenable : Directory not exits Directory name:%s",path));
        status = false;
    }
    return status;
}

/*Checks whether the device related to this mount point exists or not*/
int checkIfMounted(const char *mountPoint)
{
    int retVal = 0;

    if (NULL == mountPoint)
    {
        syslog(LOG_INFO, "checkIfMounted: Invalid argument");
    }
    else
    {
        FILE            *file;
        struct mntent   *entry;
        char mtabFilePath[] = "/etc/mtab";

        file = setmntent(mtabFilePath, "r");
        if (NULL == file)
        {
            syslog(LOG_INFO, "checkIfMounted: Error opening %s", mtabFilePath);
        }
        else
        {
            for(entry = getmntent(file); entry; entry = getmntent(file))
            {
                if(0 == strcmp(entry->mnt_dir,mountPoint))
                {
                   struct stat buf;
                   if(!stat(entry->mnt_fsname,&buf))
                   {
                       retVal = 1;
                       syslog(LOG_INFO, "Mount point: %s exists and file system(device) : %s exists",entry->mnt_dir,entry->mnt_fsname);
                   }
                   else
                   {
                       syslog(LOG_INFO, "Not able to open file system(device) : %s , errno :%d , strerror(errno):%s", entry->mnt_fsname,errno, strerror(errno));
                   }
                   break;
               }
            }
            if(!entry)
            {
                syslog(LOG_INFO, "Mount point: %s does not exist", mountPoint);
            }

            endmntent(file);
        }
    }
    return retVal;
}

/* this function is copied from:
 * http://stackoverflow.com/questions/2256945/removing-a-non-empty-directory-programmatically-in-c-or-c
 */
int remove_directory(const char *path)
{
   DIR *dirp = opendir(path);
   size_t path_len = strlen_r(path);
   int r = -1;

   if (dirp)
   {
      struct dirent *p;

      r = 0;

      while (!r && (p=readdir(dirp)))
      {
          int r2 = -1;
          char *buf;
          size_t len;

          /* Skip the names "." and ".." as we don't want to recurse on them. */
          if (!strcmp(p->d_name, ".") || !strcmp(p->d_name, ".."))
          {
             continue;
          }

          len = path_len + strlen_r(p->d_name) + 2;
          buf = (char *)malloc(len);

          if (buf)
          {
             struct stat statbuf;

             snprintf(buf, len, "%s/%s", path, p->d_name);

             if (!stat(buf, &statbuf))
             {
                if (S_ISDIR(statbuf.st_mode))
                {
                   r2 = remove_directory(buf);
                }
                else
                {
                   r2 = unlink(buf);
                }
             }

             free(buf);
          }

          r = r2;
      }

      closedir(dirp);
   }

   if (!r)
   {
      r = rmdir(path);
   }

   return r;
}

#define GMP_QUOTE(str) #str
#define GMP_EXPAND_AND_QUOTE(str) GMP_QUOTE(str)
char *getMediaPlayerBinPath()
{
    char *mepath;
    char *pvar = getenv((char *)"MEDIAENGINE_PATH");
    if(pvar) {
        mepath = pvar; // env;
    } else {
        #if defined(MEDIAENGINE_PATH)
            mepath = (char *)GMP_EXPAND_AND_QUOTE(MEDIAENGINE_PATH); // xml;
        #else
            mepath = (char *)"."; // fallback;
        #endif
    }
    return mepath;
}

/**
 * Returns the current resident set size (physical memory use) measured
 * in bytes, or zero if the value cannot be determined on this OS.
 */
size_t getCurrentRSS()
{
    long rss = 0L;
    FILE* fp = NULL;
    if ( (fp = fopen( "/proc/self/statm", "r" )) == NULL )
        return (size_t)0L;      /* Can't open? */
    if ( fscanf( fp, "%*s%ld", &rss ) != 1 )
    {
        fclose( fp );
        return (size_t)0L;      /* Can't read? */
    }
    fclose( fp );
    return (size_t)rss * (size_t)sysconf( _SC_PAGESIZE);
}


/**
 * Returns 1 if all chars in the string is hexadecimal, else 0
 */
int isHexadecimalString(char *str)
{
    size_t len = 0;
    char ch;
    size_t index = 0;

    if( str == NULL ) return 0;
    if( str[0] == '\0' ) return 0;

    len = strlen_r(str);

    for (index = 0; index < len; index++)
    {
        ch = *str;
        if (0 == isxdigit (ch))
        {
            break;
        }
        ++str;
    }
    if (index == len)
    {
        return 1;
    }

    return 0;
}
/*Get File mode from path */
mode_t getfileMode(const char* path)
{
    struct stat buf;
    if(path && (0 == access(path, F_OK)))
    {
        if (stat(path, &buf) != -1) {
            return (unsigned int)buf.st_mode;
        }
    }
    return 0;
}

bool isStartWith(const char* str1,const char* str2)
{
    std::string s(str2);
    std::string t(str1);
    if (s.compare(0, t.length(), t) == 0)
    {
        return true;
    }
    return false;
}

std::string toString(int num)
{
    char value[128];
    itoa(num,value,10);
    return std::string(value);
}



std::string string_to_hex(const char* inStr,int length)
{
    std::stringstream ss;
    ss << std::hex << std::setfill('0');
    if(inStr != NULL)
    {
        int len = length;

        if(len == 0)
        {
            len = strlen(inStr);
        }
        for (int i = 0; i < len; ++i) {
            ss << std::setw(2) << static_cast<unsigned int>(static_cast<unsigned char>(inStr[i]));
        }
    }
    return ss.str();
}

void SetThreadNiceProperty(int tId, int reniceVal)
{
    setpriority(PRIO_PROCESS, tId, reniceVal);
}

/*TODO: To use RemoveDirectory() in place of remove_directory() function as it is copied from open source.
deleteDir - If deleteDir is true given parent directory is removed else given directory is not removed.Irrespective of deleteDir value, sub directories are always removed.
matchingPattern - If matchingPattern is given,Files matching the given pattern is removed from the given directory level.Subdirectories are not considered in this case for now.*/
int RemoveDirectory(string dirPath, bool deleteDir, string matchingPattern)
{
    syslog(LOG_INFO, "deleteDir: %d", deleteDir);
    int result = -1;

    if(dirPath.empty() == false)
    {
        syslog(LOG_INFO, "dirPath: %s", dirPath.c_str());
        string folderPath = dirPath + "/";
        struct dirent *entry = NULL;
        DIR *dir = opendir(folderPath.c_str());
        if(dir != NULL)
        {
            while(entry = readdir(dir))
            {
                if((strcmp(entry->d_name, ".") == 0) || (strcmp(entry->d_name, "..") == 0))
                {
                    //In case of empty directory
                    result = 0;
                }
                else if(entry->d_type == DT_DIR && matchingPattern.empty())//If matching pattern is given,skip reading sub directories.
                {
                    string folderContent = folderPath + entry->d_name + "/";
                    syslog(LOG_INFO, "directory name: %s", entry->d_name);
                    //remove folder contents
                    result = RemoveDirectory(folderContent, true);
                }
                else
                {
                    //remove if it is a file
                    //ENOTDIR is returned incase the given path is not a directory
                    std::string filename(entry->d_name);
                    if((!matchingPattern.empty()) && (filename.find(matchingPattern.c_str()) ==  string::npos))
                    {
                        continue;
                    }
                    string folderContent = folderPath + filename;
                    syslog(LOG_INFO, "Remove File from folder: %s", folderContent.c_str());
                    result = remove(folderContent.c_str());
                }
            }
            if(0 != closedir (dir))
            {
                result = errno;
                syslog(LOG_ERR, "Could not close directory: %s",strerror(errno));
            }
            syslog(LOG_INFO, "Folder: %s, Delete: %d", folderPath.c_str(), deleteDir);

            // remove parent folder
            if((result == 0) && (deleteDir == true))
            {
                syslog(LOG_INFO, "Delete directory: %s", folderPath.c_str());
                int pos = -1;
                pos = (int)folderPath.find_last_of('/');
                folderPath = folderPath.substr(0, pos);
                syslog(LOG_INFO, "Remove Folder: %s", folderPath.c_str());
                //Removes only empty folder
                result = remove(folderPath.c_str());
            }
        }
        else if(errno == ENOTDIR)
        {
            //remove if it is a file
            //ENOTDIR is returned incase the given path is not a directory
            syslog(LOG_INFO, "Not a directory. Remove File: %s", folderPath.c_str());
            result = remove(folderPath.c_str());
        }
        else
        {
            result = errno;
            syslog(LOG_ERR, "Could not open directory: %s",strerror(errno));
        }
    }
    else
    {
        syslog(LOG_ERR, "FolderPath is not valid");
    }
    syslog(LOG_INFO, "result %d :", result);
    return result;
}

/*Executes commandStr and result is redirected to given tempFileName.
tempFileName is optional and empty by default.On empty tempFileName,commandStr is executed and result redirection is skipped.*/
int executeCommand(char *commandStr[],string tempFileName)
{
    int status = EINVAL; //Invalid argument
    if(commandStr)
    {
        syslog(LOG_INFO, "Executing %s",commandStr[0]);

        pid_t pid = fork();

        if(pid == -1)
        {
            syslog(LOG_ERR, "fork failed. Error:%d - %s",errno,strerror(errno));
            return errno;
        }
        else if (pid == 0)  //child process
        {
            int fd = 0;

            if(!tempFileName.empty())
            {
                fd = open(tempFileName.c_str(), O_WRONLY | O_CREAT | O_CLOEXEC, 0600);
            }

            if (fd != -1)
            {
              //CID-2901359(Resource leak)-fd will be automatically closed when execv() is called since O_CLOEXEC flag is used while creating fd. Resource is not leaked.
              if(!tempFileName.empty())
              {
                  dup2(fd,STDOUT_FILENO);
                  dup2(fd,STDERR_FILENO);
              }

              if(-1 == execv(commandStr[0],commandStr)) // On success execv() doesn't return and on failure returns -1.
              {
                  syslog(LOG_ERR, "execv() failed. Error:%s", strerror(errno));
                  _exit(errno);
              }
            }
            else
            {
                syslog(LOG_ERR, "Creating file descriptor failed. Error:%s",strerror(errno));
                _exit(errno);
            }
        }

        //parent process
        syslog(LOG_INFO, "parent process waiting for %d", pid);
        while (-1 == (pid = waitpid(pid, &status, 0)))
        {
            if(errno != EINTR){
                break;
            }
            syslog(LOG_INFO, "waitpid failed with EINTR. Retrying waitpid()...");
        }

        syslog(LOG_INFO, "waitpid returned: pid %d", pid);
        syslog(LOG_INFO, "waitpid returned: status %d", status);
        syslog(LOG_INFO, "waitpid returned: WIFEXITED %d", WIFEXITED(status));
        syslog(LOG_INFO, "waitpid returned: WEXITSTATUS %d", WEXITSTATUS(status));

        if(-1 != pid && WIFEXITED(status)) {
            syslog(LOG_INFO,"waitpid success. child process exited");
            status = WEXITSTATUS(status);
        }
        else
        {
            status = errno;
            syslog(LOG_ERR,"waitpid failed. Error:%s",strerror(errno));
        }
    }
    syslog(LOG_INFO, "executeCommand: status:%d - %s", status,strerror(status));
    return status;
}
